#ifndef _MPC
#define _MPC
/*****************************************************************************/
/* mpC.h  - header file used in every C program created by mpcc compiler     */
/* Coded by Dm. Arapov for A.Lastovtsky 1995-1996                            */
/* Release 1.10.96                                                           */
/* -- 31.10.96 Made MPI-independent                                          */ 
/* -- 01.11.96 New fuctions introdeced to support different types on the     */ 
/*             sender and receiver sides                                     */
/* -- 11.11.96 MPC_DEBUG converted from constant to variable                 */
/* -- 13.11.96 added function MPC_My_number.                                 */
/* -- 05.01.97 To MPC_Net added member oldroot                               */
/* -- 14.02.97 MPC_MULTI_ROOT concept added                                  */
/*          mpC.h $Author: kusic $ $Revision: 1.3  $Date: 1997/10/20         */
#ifndef __STDC__
#define __STDC__
#endif 

#ifndef WIN31
#define WIN31
#endif

#ifndef NULL
#define NULL (void*)(0)
#endif 

#ifndef Int
#define Int int
#define LPPSTR char**
#endif

#ifdef __MPC__
#pragma keywords ANSI
#endif

/* ANSI C extensions needed for some OS: */
#include "mpC_Cext.h"

/* Constants for mpC program developer's OS. Used by MPC_Source_filename_set */
#define MAX_FILENAME_LENGTH    256 
#define MAX_ERRMSG_SIZE        512
#define MPC_MAX_COORDS           8

/* Constant for advanced error handking. Added on 27/Nov/2000. */
#define MPC_ERRRETURN_SIZE       4

/* Constants for error handling. Error messages defined in mpCerr.c */
#define MPC_OK                   0
#define MPC_ERR_BREAK            1
#define MPC_ERR_BUFFER           2
#define MPC_ERR_COUNT            3
#define MPC_ERR_TYPE             4
#define MPC_ERR_TAG              5
#define MPC_ERR_COMM             6
#define MPC_ERR_RANK             7
#define MPC_ERR_REQUEST          8
#define MPC_ERR_ROOT             9
#define MPC_ERR_GROUP           10
#define MPC_ERR_OP              11
#define MPC_ERR_TOPOLOGY        12
#define MPC_ERR_DIMS            13
#define MPC_ERR_ARG             14
#define MPC_ERR_MPI             15
#define MPC_ERR_TRUNCATE        16
#define MPC_ERR_NOMEM           17
#define MPC_ERR_INTERNAL        18
#define MPC_ERR_PRIV            19
#define MPC_ERR_TOOLONGFILENAME 20
#define MPC_ERR_BURSTCODE       21
#define MPC_ERR_INVNET          22
#define MPC_ERR_DEADLOCK        23
#define MPC_ERR_BURST           24
#define MPC_ERR_POWER           25
#define MPC_ERR_ENVPARAM        26
#define MPC_ERR_FILE            27
#define MPC_ERR_DUPPROCESS      28
#define MPC_ERR_MISSEDPROCESS   29
#define MPC_ERR_INVALIDMAPPING  30
#define MPC_ERR_TWICEWAITBEGIN  31
#define MPC_ERR_INVALIDRECONFIG 32
#define MPC_ERR_UNDEFSIZE       33
#define MPC_ERR_UNKNOWNREQUEST  34
#define MPC_ERR_TRACEFILE       35
#define MPC_ERR_LAST            36

/* NULL commumicator identifier */
typedef void* MPC_Web;        /* handle of the net, local for the node */
#define MPC_NULL_WEB NULL

#define MPC_NULL_NODE    -1
#define MPC_UNINITED_RANK  -1
#define MPC_UNVOTED_RANK -2

/* Values returned by MPC_Is_static function */
     
#define MPC_STATIC_NET 1
#define MPC_AUTO_NET   0     

#define MPC_OUT_OF_POINT    -2
#define MPC_UNKNOWN_COUNT   -1

#define MPC_SKIP  0
#define MPC_HIRED 1
#define MPC_OUT   2
#define MPC_FIRED 3

typedef Int       MPC_Node;       /* absolute number of the node (global coordinates) */
typedef Int       MPC_Name;       /* static identifier of the net */
typedef Int*      MPC_Topology;   /* topology is encoded as an array of Integer */
typedef Int*      MPC_Environment;/* topology of environment */
typedef Int       MPC_Parameters; /* parameters for topology functions */
typedef Int       MPC_Command;    /* MPC_HIRED or MPC_SKIP */

/*
 * Constants to use in the dispatchers maps.
 */
#define MPC_USED -2
#define MPC_FREE -1

#define MPC_NULL_ROOT      -1
#define MPC_UNDEFINED_ROOT -2
#define MPC_MULTI_ROOT     -3

#define MPC_BY_BARRIER      0
#define MPC_BY_GATHER       1
#define MPC_BY_REDUCE       2

#define MPC_CHANGE_ROOT     MPC_BY_REDUCE

/*****************************************************************************/
#define MPC_EMPTY_NODE        MPC_FREE
#define MPC_USED_NODE         MPC_USED

#define MPC_FLEXIBLE_SUBNET   1
#define MPC_UNFLEXIBLE_SUBNET 0

#define MPC_NOT_FLEXIBLE      MPC_UNFLEXIBLE_SUBNET
#define MPC_FLEXIBLE          MPC_FLEXIBLE_SUBNET

/***************** constants for topology functions **************************/
#define MPC_SHORTEST_LINK -32768
#define MPC_LONGEST_LINK  32767
#define MPC_NORMAL_LINK   1

#define MPC_SCALAR_NODE 1

/*******************new****MPC_Topo_graph*********@@@***********************/
typedef struct MPC_TOPO_GRAPH {
  Int number;   /* linear number of the virtual processor */
  double node_weight;   /* weight of the virtual processor = */
                        /* the number of benchs to compute */
  Int number_of_links;   /* the number of outgoing virtual links */
  struct MPC_TOPO_GRAPH **links;   /* array of pointers to virtual processors */
                                   /* for the links */
  double *link_weights;   /* array of weights of the virtual links, */
                          /* link_weights[i] = the number of bytes to transfer */
                          /* over i-th link */
  Int group_number;   /* number of the group into which the virtual processor */
                      /* is mapped */ 
  double proc_weight;   /* the weight of process, which the virtual processor */
                        /* is mapped to = MPC_POWER_COEFF/t(bench) */
  double *hard_link_times;   /* hard_link_times[i] = time in sec to transfer */
                             /* link_weights[i] bytes through the hard link */
                             /* on which i-th virtual link mapped */
  struct MPC_TOPO_GRAPH *next;   /* next virtual processor in the list */
} MPC_Topo_graph;

typedef struct {                 /* network type descriptor */
  Int numcoord;                  /* number of coordinates in net descrption */
  Int  (*node)(Int num, const Int* aparams, Int ppower, Int **pnodes, Int **plinks);
  Int  (*link)(Int fromnum, Int tonum, const Int* aparams, Int ppower, Int **pnodes, Int **plinks );
  Int  (*parent)(const Int* params, Int ppower, Int **pnodes, Int **plinks);  /* returns parent number */
  Int  (*power)(const Int* params, Int ppower, Int **pnodes, Int **plinks);   /* power function */
  void (*num2coord)(Int num, const Int* params, Int* coords, Int ppower, Int **pnodes, Int **plinks);  /* coord function */
  Int  (*coord2num)(const Int* coords, const Int* params, Int ppower, Int **pnodes, Int **plinks);   /* number function */
  double  (*estim)(MPC_Topo_graph **root, const Int* params, Int ppower, Int **pnodes, Int **plinks);   /* estimation function */
  /* Int bench; nettype mode: MPC_BENCH or MPC_NOT_BENCH @@@*/
  } MPC_NetType;

/*
 * MPC_Net is type of descriptors of nets. It has MPC_Web part, which 
 * represents MPI communicator associated with the net,
 * type of the net (Integer static identifier of the net), and 
 * parameters for topology functions. It also has supernet field -
 * pointer to the net which it is subnet.
 * All operations of placing MPC_Net structures in memory and removing them
 * are performed by mpC compiler. RTS never invoke malloc, realloc or free for 
 * such structures and their fields. coord field always points to an Int array 
 * somewhere in memory. Size of the array is an implementation
 * dependent constant MPC_MAX_COORDS
 */
typedef struct MPC_Net {
  MPC_Web pweb;                   /* network handler */
  MPC_NetType* type;             /* network type descriptor */
  Int count;                     /* number of parameters */
  MPC_Parameters* params;        /* value of the network parameters */
                                 /* NULL for not generic type */
  Int  is_static;                /* is the specified net static or not*/  
  Int* coord;                    /* pointer to the node coordinates in the net */
  Int  rank;                     /* linear number in the (sub)net */
  Int  power;                    /* number of the nodes in the (sub)net */
  struct MPC_Net* supernet;      /* != NULL iff MPC_Net is subnet */
  Int* mapping;                  /* subnet to net mapping. != NULL iff it is subnet.
                                    size of mapping == subnet_power. 
                                    number of subnet node or MPC_FREE */
  Int  leader;                   /* used in parent nodes for free_net operetion */
  Int  oldroot;                  /* root of previous collective operation */
  MPC_Topology temp_topo;        /* used during creation of the net */
  struct MPC_Net* subnet_list;   /* pointer to the static subnet list */
  struct MPC_Net* burst_list;    /* pointer to burst subnet creating request list */
  struct MPC_Net* subnet_next;   /* pointer to next subnet in chain of static subnets */
  struct MPC_Net* burst_next;    /* pointer to next subnet in burst subnet creating request list */
  Int* next;                     /* pointer to next net in the process */
  Int bench;                     /* network mode: MPC_BENCH or MPC_NOT_BENCH @@@*/
  Int num_of_links;              /* the number of links in the network @@@*/
  Int *nodes;
  Int *links;
  } MPC_Net;


/*
 * Type of function which establish topology information of the computational 
 * environmenet. It turns on MPC_Real_weights switch in 
 */
typedef Int (*MPC_Get_env)
  ( 
    Int  power,                  /* number of nodes in computational space (without the dispatcher) */
    int* pargc,                  /* number of parameters */
    LPPSTR* pargv,               /* list of parameters */
    Int* penv_length,            /* size of packed environment topo info */
    Int** penvironment );        /* pointer to environment array */ 
    
/*
 * Let one has parent node somewhere in the global net and needs to add count-1 
 * nodes and create a new net. He (or she) gets the global space_map (which at 
 * the start is an array of Integers with only two possible values: MPC_USED 
 * and MPC_FREE) and two objects (they are opaque for MPC_runtime): environment 
 * and req_topology, first is for the whole system topology (established at 
 * very begining), and next is topology of the net to create. User defined callback 
 * Topology_strategy operates (how we don't know) and returns values in the space. 
 * Every node in the new net should have a number (0..count-1),  including the parent, 
 * all others should have values MPC_USED and MPC_FREE. 
 * Function of this type will be invoked locally inside the dispatcher process.
 */

typedef Int (*MPC_Topology_strategy)
  ( MPC_Node parent,             /* absolute number of the node, which will be parent of the net */
    Int parent_rank,             /* linear number of the parent in the net */
    Int power,                   /* number of nodes to allocate+1 */
    Int topology_length,         /* size of topology info for requested net */
    MPC_Topology topology,       /* the requested net topology */
    Int total_nodes,             /* number of nodes in the computational space */
    Int* map );                  /* inout parameter. global map, at the start 
                                    there are only MPC_USED or MPC_FREE 
                                    in each of map_size cells. On exit some of cells contains
                                    ranks of a node in future net */
                   
typedef Int (*MPC_Error_print)
  ( const char* filename,        /* source fileneme */
    Int line,                    /* line of the source file, where error occured */
    Int column,                  /* column of the source file, where error occured */
    const char* msg );           /* error message */

/* Default constant of this type */

Int MPC_Trivial_error_print(
    const char* filename,        /* source fileneme */
    Int line,                    /* line of the source file, where error occured */
    Int column,                  /* column of the source file, where error occured */
    const char* msg );           /* error message */
        
/******************************************************************************/
/*                          Global variables                                  */
/******************************************************************************/    
/*          Those declarations would be generrated every time                 */


extern MPC_Net MPC_Net_global;   /* initiated by MPC_Init, consists from all nodes */
extern MPC_Net MPC_Net_host;     /* initiated by MPC_Init, on Host is MPI_COMM_SELF, 
                                    otherwise - MPI_COMM_NULL */
extern MPC_Net MPC_Net_recon;    /* initiated by MPC_Init, consists from one node for each prosessor */

/* rreddy
 * Abstract network HMPI_FREE
 */
extern MPC_Net MPC_Net_free_procs;

/******************************************************************************/
/*                     Topology coding functions                              */
/******************************************************************************/

typedef Int (*MPC_Init_strategy)();

/*
 * Function   - release topology information, allocated by MPC_Topology_data
 * Invoked by - same node as correspondent MPC_Topology_data
 * Parameters - 
 */
typedef Int (*MPC_Topology_free)(MPC_Net *anet);

/*
 *  Function   - form processor independent topology information from MPC_Net.
 *  Invoked by - any node
 *  Parameters - MPC_Net* must contain type and params fields filled.
 *  Exceptions - 
 */
typedef Int (*MPC_Topology_data)( MPC_Net *anet,
                                 Int *plenght,
                                 MPC_Topology *atopology,
                                 MPC_Topology_free *afreetopology);


typedef Int (*MPC_Processors_info)(
    Int* num_of_processors,
    double** relative_performance );

Int MPC_Get_number_of_processors(void)
     /* function, which returns the number of physical processors */;
     
void MPC_Get_processors_info(
  /* function, which returns physical processors dispatcher' map */
    Int* imap,
    double* map );

Int MPC_Set_processors_info(Int *map);

Int MPC_Update_Processors_info(double MPC_bench_times);

/*
 *  Function - terminate topology module
 *  Invoked by - dispatcher
 *  Parameters - none
 *  Exceptions -
 */
typedef Int (*MPC_Topology_clear)(void);


/******************************************************************************/
/*      Initialization and finalization of the MPC run-time system            */
/******************************************************************************/
/*
 *  Function   - to initiate MPC run-time system.
 *  Invoked by - synchroniusly by every node including the dispatcher 
 *               before any calls to MPC functions.
 *  Parameters - poInters to main function parameters,
 *               poInter to function to retrieve environment topology. 
 *               If NULL trivial environment topology assumed.
 *               pointer to strategy function. If NULL default strategy assumed.
 *  Exceptions -
 */
Int MPC_Init(int *pargc,
             LPPSTR *pargv,
             MPC_Init_strategy init_strategy,
             MPC_Error_print error_print,
             MPC_Get_env get_env,
             MPC_Topology_strategy strategy,
             MPC_Topology_data topology_data,
             MPC_Processors_info processors_info);
  
/*
 *  Function   - abnormal terminate whole the MPC run-time. No buffer or 
 *               process cleanup assumed.
 *  Invoked by - any node, including the disptcher.
 *  Parameters - error code.
 *  Exceptions - none
 */
Int MPC_Abort( Int errcode );

/*
 *  Function   - terminate the MPC run-time.
 *  Invoked by - every process at the end of the work. 
 *               It is point of global syncronization.
 *  Parameters - exit code for a shell.
 *  Exceptions -
 */
Int MPC_Exit( Int exitcode );

/*****************************************************************************/
/*                     Net manipulating functions                            */
/*****************************************************************************/
/*
 *  Function   - create a net.
 *  Invoked by - parent node of the net to create.
 *  Parameters -
 *  Exceptions -
 */
Int MPC_Net_create(
  MPC_Name name,           /* static identifier of the net to create */
  MPC_Net* net );          /* net descriptor */

/*
 *  Function   - destroy the net or subnet.
 *  Invoked by - every node of (sub)net.
 *  Parameters - identifier of (sub)net to destroy.
 *  Exceptions -
 */
Int MPC_Net_free( MPC_Net* net );

/*
 *  Function   - sends all unemloyed nodes signal to leave their focus point
 *  Invoked by - host only
 *  Parameters - none
 *  Exceptions - none
 */
Int MPC_Host_out( void );

/*
 *  Function - Sends signal to host from unknown node
 *  Invoked by - any node
 *  Parameters - 
 *  Exceptions -
 */
Int MPC_Send_end( void );

/*
 *  Function - Receives signal from unknown node
 *  Invoked by - host only
 *  Parameters - count of senders
 *  Exceptions -
 */
Int MPC_Recv_end( Int count );

/*
 *  Function   - test for a job
 *  Invoked by - all nodes except parent node
 *  Parameters -
 *  Exceptions -
 */
Int MPC_Offer( 
  MPC_Command* command,           /* MPC_SKIP, MPC_HIRED or MPC_OUT */
  const MPC_Name* names,          /* array of static names of nets, pointed by nets_voted array of pointers */
  MPC_Net** nets_voted,           /* array of pointers to nets */
  Int voted_count );              /* number of nets voting at the point */

Int MPC_Reconfig( void );

Int MPC_Waiting_point_begin(
  Int number_of_nets_to_create,
  Int number_of_nets_to_free);

Int MPC_Waiting_point_end( void );

/*
 *  Function   - Tests is the net (which caller belong) static or not.
 *  Invoked by - any employed node.
 *  Parameters - dynamic identifier of the net. 
 *  Result     - O if static, 1 for automatic
 *  Exceptions -
 */
Int MPC_Is_static( const MPC_Net* net  );

/*
 *  Function - test does the net handle associated with a net or with a subnet
 *  Invoked by - any member of the net
 *  Parameters - dynamic identifier of the net
 *  Result     - 0 if it is net, otherwise 1.
 *  Exceptions -
 */
Int MPC_Is_subnet( const MPC_Net* net );

/*
 *  Function   - find out node linear number in the specified net.
 *  Invoked by - any employed node.
 *  Parameters - dynamic identifier of the net and the result
 *  Exceptions -
 */
Int MPC_Node_rank( const MPC_Net* net );


/*
 *  Function   - find out node linear number in global net.
 *  Invoked by - any employed node.
 *  
 */

Int MPC_Global_rank( void );

/*
 *  Function   - tests does current node involved in any net
 *  Invoked by - any node
 *  Parameters - none
 *  Exceptions -
 */
Int MPC_Is_busy(void);

/*
 *  Function   - tests does current node involved in any net
 *  Invoked by - any  node
 *  Parameters - none
 *  Exceptions -
 */
Int MPC_Is_free(void);

/*
 *  Function   - tests is current node host or not
 *  Invoked by - any node
 *  Parameters - none
 *  Exceptions -
 */
Int MPC_Is_host(void);
                     
/*
 *  Function   - tests is current node member of given net
 *  Invoked by - any node
 *  Parameters - net
 *  Exceptions -
 */
Int MPC_Is_member(const MPC_Net* net);

/*
 *  Funtion    - tests if current node belong to any of given nets
 *  Invoked by - any node
 *  Parameters - array on pointers to nets and size of the array.
 *  Exceptions - 
 */
Int MPC_Is_member_of_anynet( MPC_Net** nets, Int count);

/*
 *  Function   - tests if current node is parent of given net.
 *  Invoked by - any node
 *  Parameters - net
 *  Exceptions - 
 */
Int MPC_Is_parent(MPC_Net* net);

/*
 *  Function   - returns number of nodes in computational space
 *  Invoked by - any node
 *  Parameters - none
 *  Exceptions - none
 */
/* Int MPC_Total_nodes( void );  --- deleted 06.10.97 according to A.Kalinov!!! */

Int MPC_Is_created(const MPC_Net* net);

Int MPC_Set_created(MPC_Net* net);

Int MPC_Test_net(const MPC_Net* net);
/*****************************************************************************/
/*                       Subnet manipulations                                */
/*****************************************************************************/
/*
 * Function    - create subnet
 * Invoked by  - all members of supernet
 * Parametrs   -
 * Exceptions  -
 */
Int MPC_Subnet_create( 
  MPC_Net* subnet,	 /* subnet descriptor */    
  Int is_flexible ); /* 0 iff ordinal, 1 - flexible */
  
/*
 * Function   - init Bust creating of subnets
 * Invoked by - all memebers of supernet
 * Parameters - net, which the subnet belong
 * Exceptions -
 */   

/*****************************************************************************/
/*                       Topology incapsulation                              */
/*****************************************************************************/
/*
 * Function    - returns class of the node
 * Invoked by  - any member of the net
 * Parametrs   - net and linear number of the node
 * Exceptions  -
 */
Int MPC_Node_class(
  const MPC_Net* net,
  Int number );         

/*
 * Function    - returns type of the link (may be 0) between node_from 
 *               and node_to (may be assimmetric!)
 * Invoked by  - any member of the net
 * Parametrs   - net and linear numbers of both nodes.
 * Exceptions  -
 */
Int MPC_Link(
  const MPC_Net* net,
  Int number_from,
  Int number_to );  
  
/*
 * Function    - returns linear number of the parent node
 * Invoked by  - any member of the net
 * Parametrs   - the net 
 * Exceptions  -
 */
Int MPC_Parent( MPC_Net* net );

/*
 * Function    - returns number of nodes in the net
 * Invoked by  - any member of the net
 * Parametrs   - the net 
 * Exceptions  -
 */
Int MPC_Power( MPC_Net* net );

/*
 * Function    - sets array of coordinates for specified node of the net
 * Invoked by  - any member of the net
 * Parametrs   - the net, linear number, pointer to coord array
 * Exceptions  -
 */
void MPC_Coord(
  MPC_Net* net, 
  Int number,
  Int* coord);
  
/*
 * Function    - sets net.coord for node on which it is called
 * Invoked by  - every node 
 * Parametrs   - descriptor of the net (function changes it). 
 * Exceptions  -
 */ 
  
void MPC_Coord_set(
  MPC_Net* net,  /* descriptor of the net (function changes it). */
  Int number );  /* linear number of the node */

/*
 * Function    - returns linear number of the node, using given coords
 * Invoked by  - any member of the net
 * Parametrs   - the net, pointer to coord array
 * Exceptions  -
 */
 
Int  MPC_Number(
  MPC_Net* net,
  const Int* coord);

/*
 * Function    - returns linear number of the node, using its coords
 * Invoked by  - any member of the net
 * Parametrs   - the net, pointer to coord array
 * Exceptions  -
 */  
Int  MPC_My_number(
  MPC_Net* net );

/*****************************************************************************/
/*                      Data types manipulations                             */
/*****************************************************************************/
typedef void*            MPC_Rts_datatype;
extern  MPC_Rts_datatype MPC_CHAR; 
extern  MPC_Rts_datatype MPC_SHORT; 
extern  MPC_Rts_datatype MPC_INT; 
extern  MPC_Rts_datatype MPC_LONG; 
extern  MPC_Rts_datatype MPC_UNSIGNED_CHAR; 
extern  MPC_Rts_datatype MPC_UNSIGNED_SHORT; 
extern  MPC_Rts_datatype MPC_UNSIGNED; 
extern  MPC_Rts_datatype MPC_UNSIGNED_LONG; 
extern  MPC_Rts_datatype MPC_FLOAT; 
extern  MPC_Rts_datatype MPC_DOUBLE; 
extern  MPC_Rts_datatype MPC_LONG_DOUBLE; 

#define MPC_DATATYPE_NULL NULL

#define MPC_DTN MPC_DATATYPE_NULL 

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifndef __RTS__
#include "typoper.h"
#include "machine.def"
#endif

#include "mpCtree.h"
typedef MPC_Datatype MPC_Dt;

char* MPC_Get_typename(MPC_Datatype datatype);
MPC_Rts_datatype MPC_Get_datatype(MPC_Datatype datatype );
Int MPC_Get_step(MPC_Datatype datatype);
Int MPC_Get_count(MPC_Datatype datatype);
MPC_Datatype MPC_Get_element(MPC_Datatype datatype);
Int MPC_Elem_copy(void* dest, const void* source, MPC_Datatype datatype);
Int MPC_Elem_copy_conv( void* dest, const void* source, MPC_Datatype recv_datatype, MPC_Datatype send_datatype);
Int MPC_Type_size( MPC_Datatype datatype );  

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*
 *  Function   - create equally spaced array of oldtype elements (simple form of MPC_Type_vector)
 *  Invoked by - any node
 *  Parameters -
 *  Exceptions -
 */
Int MPC_Type_array(
  Int count,              /* number of elements */
  Int stride,             /* gap in elements between start of each block */
  MPC_Rts_datatype oldtype,   /* type of an element */
  MPC_Rts_datatype* pnewtype); /* result datatype */

Int MPC_Datatype_array(
  Int count,
  Int stride,
  MPC_Datatype elemtype,
  MPC_Rts_datatype* pnewtype);

Int MPC_Datatype_record(
  Int count,
  const MPC_Datatype* elemtypes,
  MPC_Rts_datatype* pnewtype); 

Int MPC_Datatype_struct(
  Int count,
  const MPC_Datatype* elemtypes,
  const Int* offsets,
  MPC_Rts_datatype* pnewtype);   

/*
 *  Function   - creates structure, where each block can consist of 1 element
 *               of different datatypes, but all placed one by one.
 *  Invoked by - any node
 *  Parameters -
 *  Exceptions -
 */
  
Int MPC_Type_record(
  Int count,                     /* number of blocks, each consist from 1 element only */  
  const MPC_Rts_datatype* array_of_types,  /* types of elements in each block */
  MPC_Rts_datatype* pnewtype );       /* result datatype */

/*
 *  Function   - registrate created datatype before using it in communications
 *  Invoked by - any node
 *  Parameters - datatype to registrate
 *  Exceptions -
 */
Int MPC_Type_commit( MPC_Rts_datatype* datatype );

/*
 *  Function   - unregistrate datatype after it was used in communications
 *  Invoked by - any node
 *  Parameters - datatype to registrate
 *  Exceptions -
 */
Int MPC_Type_free( MPC_Rts_datatype* pdatatype );

/*****************************************************************************/
/*                 Assigment operations. Unpacked mode                       */
/*****************************************************************************/
  
Int MPC_Send(
  const MPC_Net* net,   
  const void* message,
  MPC_Datatype datatype,
  Int dest);
  
Int MPC_Recv(
  const MPC_Net* net,
  void* message,
  MPC_Datatype datatype,
  Int source);

Int MPC_Send_copy(
  const MPC_Net* net,   
  const void* send_message,
  void* recv_message,
  MPC_Datatype datatype,
  Int dest);
  
Int MPC_Recv_copy(
  const MPC_Net* net,
  void* message,
  MPC_Datatype datatype,
  Int source);

Int MPC_Send_copy_conv(
  const MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype send_datatype,
  MPC_Datatype recv_datatype,
  Int dest);
  
Int MPC_Send_all(
  MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype datatype );

Int MPC_Send_all_conv(
  MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype send_datatype,
  MPC_Datatype recv_datatype);
  
Int MPC_Recv_all(
  MPC_Net* net,
  void* message,
  MPC_Datatype datatype,
  Int source );  
  
Int MPC_Send_scatter(
  MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype datatype );

Int MPC_Send_scatter_conv(
  MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype send_datatype,
  MPC_Datatype recv_datatype );
  
Int MPC_Recv_scatter(
  MPC_Net* net,
  void* message,
  MPC_Datatype datatype,
  Int source );    
  
Int MPC_Send_gather(
  const MPC_Net* net,
  const void* message,
  MPC_Datatype datatype,
  Int dest );
  
Int MPC_Recv_gather(
  const MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype datatype );    

Int MPC_Recv_gather_conv(
  const MPC_Net* net,
  const void* send_message,
  void* recv_message,
  MPC_Datatype send_datatype,
  MPC_Datatype recv_datatype );  

/*****************************************************************************/
/*                   Built-in functions for assignment operations            */
/*                      Coordinate mode                                      */
/*****************************************************************************/
Int MPC_Var_send_receive(
  const MPC_Net* net,
  const Int* sender,
  const void* send_buffer,
  Int   send_step,
  Int   count,
  const Int* receiver,
  void* recv_buffer,
  Int   recv_step,
  MPC_Datatype datatype );

Int MPC_Var_broadcast(
  MPC_Net* net,
  const Int* sender,
  const void* send_buffer,
  Int   send_step,
  Int   count,
  void* recv_buffer,
  Int   recv_step,
  MPC_Datatype datatype );

Int MPC_Var_scatter(
  MPC_Net* net,
  const Int* sender,
  const void* send_buffer,
  const Int* displs,
  const Int* counts,
  Int count,
  void* recv_buffer,
  MPC_Datatype datatype );

Int MPC_Var_gather(
  const MPC_Net* net,
  const Int* recveiver,
  void* recv_buffer,
  const Int* displs,
  const Int* counts,
  Int count,
  const void* send_buffer,
  MPC_Datatype datatype );

/*****************************************************************************/
/*                   Assigment operations. Packed mode                       */
/*****************************************************************************/

typedef struct                /* This is internal representation of a package for burst mode operations, except scatter type */
  {
    Int opcode;               /* Code of the operation with packed data */
    MPC_Net* net;             /* Net or subnet, used for operation */
    Int src_dst;              /* destination field in send-side nodes, and source in receive ones */
    Int buffersize;           /* size of the buffer */
    void* buffer;             /* data buffer */
    Int position;             /* current position in the data buffer, used for MPI packing and unpacking */
  } MPC_Bag; 
  
typedef struct
  {
    Int opcode;
    MPC_Net* net;
    Int root;
    Int* buffersizes;
    void** buffers;
    Int* positions;
  } MPC_Baggage; 
  
#define MPC_NULL_BAG 0  
  
Int MPC_Burst_send_begin( 
  const MPC_Net* net,         /* Net both source and destination must belong */
  Int dest,                   /* Rank of the destination in the specified net */
  MPC_Bag* bag);              /* Package handle */
  
Int MPC_Burst_send( 
  MPC_Bag* bag,               /* Package all messages will be put to */
  const void* message,        /* Message to send */
  MPC_Datatype datatype );    /* Message datatype */

Int MPC_Burst_send_end( MPC_Bag* bag );

Int MPC_Burst_recv_begin(     
  const MPC_Net* net,         /* Net, both source and destination must belong*/ 
  Int source,                 /* Source of the message */
  MPC_Bag* bag );             /* Received packet */

Int MPC_Burst_recv( 
  MPC_Bag* bag,               /* Packet with messages */
  void* message,              /* Message to receive */
  MPC_Datatype datatype );    /* Message datatype */

Int MPC_Burst_recv_end( MPC_Bag* bag );                                 

Int MPC_Burst_send_all_begin(
  const MPC_Net* net,         /* Net, to broadcast over */
  MPC_Bag* bag );             /* Package to send */
  
Int MPC_Burst_send_all(
  MPC_Bag* bag,               /* Package all messages will be put to */
  const void* message,
  void* recv_message,
  MPC_Datatype datatype );
  
Int MPC_Burst_send_all_end( MPC_Bag* bag );

Int MPC_Burst_recv_all_begin(
  const MPC_Net* net,
  Int source,
  MPC_Bag* bag );
  
Int MPC_Burst_recv_all(
  MPC_Bag* bag,
  void* message,
  MPC_Datatype datatype );
  
Int MPC_Burst_recv_all_end( MPC_Bag* bag );

Int MPC_Burst_send_scatter_begin(
  const MPC_Net* net,
  MPC_Baggage* baggage );
  
Int MPC_Burst_send_scatter(
  MPC_Baggage* baggage,
  const void* send_message,   /* address of the whole message (all parts) */
  void* recv_message,         /* place for local part of message */
  MPC_Datatype datatype);     /* Message datatype */

Int MPC_Burst_send_scatter_end( MPC_Baggage* baggage );

Int MPC_Burst_recv_scatter_begin( 
  const MPC_Net* net,         
  Int source,
  MPC_Bag* bag );
  
Int MPC_Burst_recv_scatter(
  MPC_Bag* bag, 
  void* message,              /* address of destination buffer */
  MPC_Datatype datatype);     /* Message datatype, must be same as in MPC_Msg_send_scatter */
  
Int MPC_Burst_recv_scatter_end( MPC_Bag* bag );

Int MPC_Burst_send_gather_begin(
  const MPC_Net* net,
  Int dest,
  MPC_Bag* bag );
  
Int MPC_Burst_send_gather(
  MPC_Bag* bag,
  const void* send_message,   /* address of the local part of the message */
  MPC_Datatype datatype );    /* Message datatype, must be same as in MPC_Msg_recv_gather */
  
Int MPC_Burst_send_gather_end( MPC_Bag* bag );

Int MPC_Burst_recv_gather_begin(
  const MPC_Net* net,
  MPC_Baggage* baggage);
  
Int MPC_Burst_recv_gather(
  MPC_Baggage* baggage,
  const void* send_message,
  MPC_Datatype datatype,
  void* recv_message );
  
Int MPC_Burst_recv_gather_end( MPC_Baggage* baggage );

/*****************************************************************************/
/*                      Barrier operations                                   */
/*****************************************************************************/

/*
 *  Function   - barrier over all nodes (both hired or not)
 *  Invoked by - all nodes simultaniosly
 *  Parameters - none
 *  Exceptions -
 */
Int MPC_Global_barrier( void );

/*
 *  Function   - barrier over all nodes in the net or subnet
 *  Invoked by - every node of the specified net
 *  Parameters - net to synchronize over
 *  Exceptions -
 */
Int MPC_Local_barrier( MPC_Net* net );

/*
 *  Function   - says that mapin part of the fan operator is done.
 *  Invoked by - all nodes of the net running fan operator
 *  Parameters - the net, where fan is running
 *  Exceptions - 
 */
Int MPC_Fan_in( const MPC_Net* net );

/*
 *  Function   - says that body is done. Waits for all mapin are commited
 *  Invoked by - all nodes of the net running fan operator
 *  Parameters - the net, where fan is running
 *  Exceptions - 
 */
Int MPC_Fan_out( const MPC_Net* net );

/*****************************************************************************/
/*                                  Reduction                                */
/*****************************************************************************/
typedef void* MPC_Op;
typedef void	(MPC_User_function)(void* invec, void* outvec, int* len, MPC_Rts_datatype type);

extern  MPC_Op     MPC_SUM;
extern  MPC_Op     MPC_PROD;
extern  MPC_Op     MPC_BAND;
extern  MPC_Op     MPC_BOR;
extern  MPC_Op     MPC_BXOR;
extern  MPC_Op     MPC_MAX;
extern  MPC_Op     MPC_MIN;
extern  MPC_Op     MPC_LAND;
extern  MPC_Op     MPC_LOR;

/*
 * Function   - create commutative operation.
 * Invoked by - every node in the (sub)net, where Allreduce will be invoked
 * Paramters  -
 * Exceptions -
 */
Int MPC_Op_create_commutative(MPC_User_function* function, MPC_Op* op);

/*
 * Function   - create uncommutative operation.
 * Invoked by - every node in the (sub)net, where reduce will be invoked
 * Paramters  -
 * Exceptions -
 */
Int MPC_Op_create_uncommutative(MPC_User_function* function, MPC_Op* op);

/*
 * Function   - free operation handle
 * Invoked by - same node as MPC_Op_create...
 * Parameters - Operation handle
 * Exceptions -
 */
Int MPC_Op_free(MPC_Op* op);

/*
 * Function   - perform linearization and broadcast results to every node
 * Invoked by - all nodes of the net
 * Parameters -
 * Exceptions -
 */

Int MPC_Reduce(
  MPC_Net* net,           /* net, where operands are distributed */
  void* sendbuf,          /* address of an array of operands */
  void* recvbuf,          /* address of the receive buffer */
  MPC_Datatype datatype,  /* type of array as a whole */
  MPC_Datatype elemtype,  /* type of element, which the op apply to */
  MPC_Op op);
  
/*****************************************************************************/
/*                               Break operations                            */
/*****************************************************************************/
/*
 * Function   - send break signal in fan operator.
 * Invoked by - any node of net
 * Parameters - net handle
 * Exceptions -
 */
Int MPC_Break_send( const MPC_Net* net );

/* 
 * Function   - test the break signal from other nodes of the specified net
 * Invoked by - any node
 * Parameters - net handle
 * Results    - MPC_OK (no break occured)
 *            - MPC_ERR_BREAK  (break occured)
 *            - other - exception condition detected
 */
Int MPC_Break_test( const MPC_Net* net );

/*****************************************************************************/
/*                 Control propagation functions                             */
/*****************************************************************************/

/*
 * Funcion    - if ctrl_index == rank then sends parent control value, if rank == parent then 
 *              receives it.
 * Invoked by - all members of the net 
 * Results    - 
 */

Int MPC_Ctrl_known(
  const MPC_Net* net,   /* net, where control is sended */
  Int* ctrl_value,      /* control value before call is valid on ctrl_index node. after it it is valid on parent node */ 
  Int  ctrl_index );    /* rank of the sender node */

/*
 * Function    - if am_sender != 0 then sends parent control value. if rank == rarent then
 *               receives it. After control value is passed all memebers of the net 
 *               wait the barrier.
 * Invoked by  - all members of the net
 * Results     -
 */

Int MPC_Ctrl_any(
  MPC_Net* net,         /* net, where control is sended */
  Int* ctrl_value,      /* control value before call is valid on node with am_sender != 0,
                           after the call is done it is valid on parent node */
  Int am_sender );      /* everywhere == 0, except the sender node */

/*
 * Function    - sends control value from the root to all members of the net 
 * Invoked by  - all members of the net  
 * Results     - 
 */

Int MPC_Ctrl_prop(
  MPC_Net* net,   /* net, where control is sended */
  Int* ctrl_value );    /* integer before call valid only on the parent node. 
                           After call is propagated to all members of the net */

/*
 * Function    - wait for all penging Bcasts, Scatter and ... rooted
 *               in some other node are finished
 * Invoked by  - all members of the net
 */

Int MPC_Change_root(
  MPC_Net* net,
  Int newroot);

Int MPC_Change_root_done(
  MPC_Net* net,
  Int newroot);

Int MPC_Set_web_root(
  MPC_Net* net,
  Int newroot);

Int MPC_Change_root_always(
  MPC_Net* net );

/*****************************************************************************/
/*                 Error handling functions                                  */
/*****************************************************************************/
                  
/*
 * Function   - sets source file, where error can occure
 * Invoked by - all nodes
 * Parameters - filename
 * Exceptions -
 */                  
Int MPC_Source_filename_set( const char* filename );

/*
 * Function   - sets source file position, where error can occure
 * Invoked by - all nodes
 * Parameters - source file line and column
 * Exceptions -
 */                  
Int MPC_Source_position_set( Int column, Int line );

/*
 * Function   - raises an error. Error msg is emitted and system will be aborted
 * Invoked by - any node
 * Parameters - error messge in form for prIntf function and parameters
 * Exceptions -
 */                  
Int MPC_Error_raise( const char* error_message );

Int MPC_Warning_raise( const char* error_message );

/*
 * Funcion    - prints from any node, using dispatcer print service
 * Invoked by - any node
 * Parameters - 
 */

Int MPC_Printf( const char* format, ... );

Int MPC_Debug_printf( const char* format, ... );

/*
 * Function - returns floating-point number of seconds, representing elapsed 
 *            wall-clock time since some time in the past.
 * Invoked by - any node
 * Parameters - none
 */

double MPC_Wtime(void);

/*
 * Function - returns number of phisical processors and their relative performance
 * Invoked by - any node
 */

Int MPC_Processors_static_info(
  Int* num_of_processors,           
  double** relative_performance );   

/* rreddy
 * Function - returns relative performances of all processes
 * Invoked by - all nodes
 */
Int 
MPC_Processes_static_info
(
  double* relative_performance 
);   

/* rreddy
 * Synchronization functions
 */
Int MPC_Get_processor_number();
Int MPC_Send_sync_message_to_dispatcher();
Int MPC_Recv_sync_message_from_dispatcher();
Int MPC_Notify_free_processes();

/* rreddy
 * Function to get the number of free processes
 * Invoked by - any node
 */
Int
MPC_Free_processes_info
(
   int* number_of_free_processes
);


void RC2STR(char* message, Int RC );
Int I2C(Int mpi_error);

extern Int MPC_count;
extern Int MPC_num;
extern MPC_Command MPC_command;

/*********************** Functions for Env_get and Strategy_init **************/
Int MPC_Env_send(Int env_length, Int* env_buffer);
Int MPC_Env_recv(Int* penv_length, Int** penv_buffer);

/*********************** Environment information ******************************/
extern Int  MPC_Processor_number;
extern Int* MPC_Processor_scalability;  
extern Int* MPC_Processor_weight;
extern Int* MPC_Processor_number_of_nodes;
extern Int** MPC_Processor_nodes_indexes;
extern Int* MPC_Link_weight;
extern char* MPC_Debug_source_name;
extern Int  MPC_Debug_source_line;
extern Int  MPC_Debug_source_column;

/*********************** Memory management functions **************************/

void* MPC_Malloc(Int size);
void* MPC_Realloc(void *ptr, Int size);
void  MPC_Free(void* ptr);
  
#define MAX_ERR_STR 20
extern int MPC_DEBUG;


/******** Brand new part for bench @@@*****************************************/

#define MPC_FIXPOINT_SCALE 100.0   /* Abs. weight of a virtual processor returned by info functions */
                                   /* for bench variant of node descriptions is represented by integer */
                                   /* equal to  MPC_FIXPOINT_SCALE*(real weight of the node) */
  
#define MPC_POWER_COEFF 1000.0     /* Power of real processor = MPC_POWER_COEFF/t(benchmark) */
#define MPC_MAX_WEIGHT 1000000     /* weight of too fast processor */

#define MPC_BENCH 1                /* BENCH? YES. */
#define MPC_NOT_BENCH 0            /* BENCH? NO.  */

#define MPC_SIZE_OF_DATA_PACK 64   /* Unit while mesuring link speeds */
#define MPC_TRANSFER_DATA_RANGE 3  /* MPC_SIZE_OF_DATA_PACK**i, i=1,...,MPC_TRANSFER_DATA_RANGE, */
                                   /* sizes of test data packages when mesuring link speeds */
#define MPC_MAX_LINK_LEVELS 32     /* Maximum hight of the hierarchy graph of hard network */

#define MPC_INIT_POWER  0       /* initial value of MPC_Net.power - used by most topo-functions; */

/******new new scheme ********************************@@@******/
#define MPC_COMPUTED_MAPPING (-1)  /* element of topology info indicating scheme case */

int MPC_Double2ints(double single_double, int *pair_of_ints);
double MPC_Ints2double(int *pair_of_ints);
double MPC_Part_comp_est(double portion, MPC_Topo_graph *node);
double MPC_Part_comm_est(double portion, MPC_Topo_graph *source, MPC_Topo_graph *dest);
double MPC_Net_estimate(MPC_Node parent,MPC_Net* net);
double MPC_Par_estimation(int ppower, int MPC_actions,
                          double *MPC_estimation,
                          char **MPC_involved_VPs,
                          char *MPC_enclosed_involved_VPs);

#ifdef __MPC__
#pragma keywords SHORT
#endif

#endif
