/* mpC-compiler, pass 2:     Relations between all (sub)nets        */
/* ====================      ===============================        */
/*                                                                  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*         =============== Initial revision, 1996/09/.. ==========  */

#ifndef _NET_REL_H
#define _NET_REL_H

#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif

#include "context.h"
#include "Tree.h"

#define  NO_RELATION	UNDEFINED
#define  NOT_SET	0
#define  EQUAL_NET	1
#define  COMPATIBLE	2
#define  SUBNET		3
#define  SUPERNET	4	/* WRK value; */

/* Table of nets and subnets */

void	Init_NetTable();
int	Add_Net			ARGS((tTree Net));
int	Set_Relation		ARGS((int Rel, tTree Net1, tTree Net2, tPosition Pos));
bool	Is_Subnet		ARGS((tTree subnet, tTree supernet));
bool	Is_Equal_Net		ARGS((tTree net1, tTree net2));
bool	Is_Compatible_Net	ARGS((tTree net1, tTree net2));
int	NetSize			ARGS((tTree net));
void	NetTable_Dump();
void	Release_NetTable();
bool    Is_SingleNode_Predicate	ARGS((tTree Subnet));
bool	Is_DistributedNet	ARGS((tTree Net));

#endif
