
/* mpC-compiler, pass 1:         "SEMANTICS" (declarations)         */
/* ====================           =========   ============          */
/*                                                                  */
/* Copyright (c) 1995,1996,1997 Institute for System Programming,   */
/*                              Russian Academy of Sciences.        */
/*         =============== Initial revision, 1995/09/.. ==========  */

#ifndef _PASS1
#define _PASS1

#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif


#define POSTFIX  DISTRIBUTED-LINEAR   /* for OpCode evaluation; */


	/* work data for declarations parsing: */

#define SIGNED			(-20)
#define SIGNED_SHORT		(-21)
#define SIGNED_SHORT_INT	(-22)
#define UNSIGNED_SHORT_INT	(-23)
#define SIGNED_INT		(-24)
#define UNSIGNED_INT		(-25)
#define SIGNED_LONG		(-26)
#define SIGNED_LONG_INT		(-27)
#define UNSIGNED_LONG_INT	(-28)
#define SIGNED_LONG_LONG	(-29)
#define SIGNED_LONG_LONG_INT	(-30)
#define UNSIGNED_LONG_LONG_INT	(-31)

typedef struct {
	  bool	Const,
		Volatile,
		Repl;
} tQual;

extern tQual 	  NoQual;
extern tDeclFlags NoDeclFlag;
extern tTypeFlags NoTypeFlag;
extern tStatFlags NoStatFlag;
extern tExprFlags NoExprFlag;

	/* Special Flag.Native for function type: */

#define NATIVE_MPC	0
#define NATIVE_CBR	1
#define NATIVE_C	2

extern int NativeMode;

	/* mpc-tree copy function (without 'Type' & 'Distribution' duplication): */

tTree	Copy_mpcList		ARGS((tTree tree));

	/* work functions for declarations parsing: */

int	BasicTypeName		ARGS((int TypeSpec, int TypeName));
int	BasicTypeConstructor	ARGS((int TypeName));
tQual	JoinQualifiers		ARGS((tQual List, tQual Qual, bool *Ignore, tPosition Pos));

	/* temporary table of types & stack of types: */

void	Init_TypeTable      ();
void	Push_Pattern        ARGS((tTree Pattern));
bool	Typedef_Dependent   ARGS((tTree Pattern));
bool	Pointer_Dependent   ARGS((tTree Pattern));
void	Push_PurePattern    ARGS((tTree Pattern));
void	Enable_SUE_Typedef  ();
void	Disable_SUE_Typedef ();
void	NestedType_ON       ();
void	NestedType_OFF      ();
tTree	TopType		    ();
tTree	Find_FunctionType   ();
void	Clean_TypeStack	    ();
tTree	Make_Type           ();
tTree	Find_Type           ARGS((tTree TypePattern));
bool	Is_FunctionType     ARGS((tTree Type));    /* func. or pointer/typedef -> func. ? */
void	Set_FunctionKind    ARGS((tTree Type, int Kind));
tTree	Find_Member	    ARGS((tIdent Ident, tTree Member));
void	Add_EquivType	    ARGS((tTree Type, tTree Equiv));
bool	Is_EqualType	    ARGS((tTree type1, tTree type2, bool strict));
void	Release_TypeTable   ();

	/* pointers to MPC_BasicType for constant expression and topo-generation: */

extern
tTree	VoidType,
	CharType,
	IntType,
	ConstIntType,
	ReplIntType,
	ReplConstIntType,
	UnsignedType,
	LongType,
	UnsignedLongType,
	FloatType,
	DoubleType,
        ReplConstDoubleType,
	LongDoubleType,		/* -- rapidly used basic types;                       */
	LongLongType,		/* -- extension: 'long long int' type;                */
	UnsignedLongLongType,	/* -- extension: 'unsigned long long int' type;       */
	ErrorType;		/* -- "basic type" for recovery after SEMANT. errors; */
extern
tTree	Default_FunctionType,	/* type of implicitly declared function ( int f(); ); */
	Barrier_FunctionType;	/* type of [*]MPC_Global_barrier(void);               */

extern
tTree	ErrorNet, ErrorNetList;	/* -- for recovery of mpcAttr() after SEMANT. errors; */


	/* name spaces: */

#define NONE		0
#define LABEL		1
#define NSUE_TAG	2
#define NSUE_MEMBER	3
#define IDENT		4

	/* scope stack - temporary table of identifiers: */

void	Init_ScopeStack	   ();
void	ScopeStack_Dump	   ();
void	Open_Scope	   ();
void	Close_Scope	   ();
void	Try_ExprScopeBegin ();
bool	ExprScopeEnd	   (); /* returns true when expr was with cast's; */
void	Restore_ExprScope  ();
void	Save_SUE_Tags	   (); /* copy all SUE_Tags from non-ANSI SUE-scope to prev. scope
				   before making Close_Scope() for this SUE-scope;          */
tTree	Find_Ident	ARGS((tIdent Ident, int NameSpace));
tTree	Add_Ident	ARGS((tIdent Ident, int NameSpace, tTree Decl));
bool	Is_CorrectRedeclaration	ARGS((tTree decl1, tTree decl2));
bool	Is_CorrectParamRedecl	ARGS((tTree type1, tTree type2, int Verbose));
int	Is_Same_PointerToFunction	ARGS((tTree type1, tTree type2));
void	Release_ScopeStack();

        /* table of subnetworks: */

void    Init_SubnetTable    ();
void    Add_Subnet          ARGS((tTree Subnet));
tTree   Find_Subnet         ARGS((tTree Subnet));
tTree   Find_ParentSubnet   ARGS((tTree Net));
void    Release_SubnetTable ();

	/* work functions for tree generation: */

tDeclFlags Make_DeclFlag ARGS((int Auto, int Static, int Register, int Parameter, int Extern, int Exported, int Distributed, int FC_Generated, int Source, int Ignore));
tTypeFlags Make_TypeFlag ARGS((int Const, int Volatile, int Repl, int BitArray, int TypedefList, int Basic, int Nodal, int Network, int Source, int Ignore));
tStatFlags Make_StatFlag ARGS((int Distributed, int Asynchr, int PartAsynchr, int CreateAutoNet, int CreateStaticNet, int Source, int Ignore));
tExprFlags Make_ExprFlag ARGS((int Lvalue, int Const, int Distributed, int Asynchr, int PartAsynchr, int InBrackets, int Generated, int Peculiarity, int Defer, int SideEffects, int Source, int Ignore));

bool EqualDeclFlags	ARGS((tDeclFlags yyf1, tDeclFlags yyf2));
bool EqualTypeFlags	ARGS((tTypeFlags yyf1, tTypeFlags yyf2));

int Eval_UnaryExpr ARGS((int OpCode, int Operand, tPosition Position));
int Eval_SizeofExpr ARGS((tTree Operand, tPosition Position));
int Eval_BinaryExpr ARGS((int OpCode, int Loperand, int Roperand, tPosition Position));

tTree Make_IntConst		ARGS((int Value));
tTree Make_ParentSubnet		ARGS((tTree net, tPosition pos, tPosition endpos));  /*K*/
tTree Make_NetList		ARGS((tTree net));
tTree Make_UnreduceableNetList	ARGS((tTree net));
tTree Make_FunctionType		ARGS((tTree TypeSpec, tTree Distribution, tPosition Pos, tTree Old_F_Decls));
tTree Rebuild_NetworkParamList	ARGS((tTree Exprs, tTree NetParam));
int   CheckAndReset_NetworkParamTypes ARGS((tTree Param, tTree Pattern, tPosition ParamPos));
int   Check_LabelList		ARGS((tTree List));
int   Recurse_DistrLabel	ARGS((tTree Stat, tTree Net, tPosition Pos));
tTree Make_Epilogue		ARGS((tPosition Pos));

void BreakParser(); /* dummy function for setting of breakpoints inside of mpcPars(); */

#endif
