#include "context.h"
#include "Tree.h"
#include "mpc_diag.h"
#include "options.h"
#include "mpc_pass1.h"

#ifndef __CB_COMPILER__
# include "mpc_demo.h"
#endif

#include "Errors.h"
#include "mpcErrors.h"

#include <string.h>


#ifndef ARGS
#if defined __STDC__ | defined __cplusplus
#define ARGS(parameters)	parameters
#else
#define ARGS(parameters)	()
#endif
#endif

int WngMode=WNG_SOME;
WngKinds NoWngs={NO,NO,NO,NO,NO,NO,NO,NO},
	 ActualWng={YES/*Decl*/,  NO/*Scope*/,  NO/*Sizes*/, YES/*Init*/,
		    YES/*Distr*/, YES/*Stats*/, NO/*Label*/, NO/*Args*/};

tPosition  SourcePosition  ARGS((tPosition Pos, tTree Tree));


bool IgnoreAll = false;


/********************/
void Make_ErrorMessage
/********************/
#if defined __STDC__ | defined __cplusplus
	(int ErrorCode, int ErrorClass, tPosition Position)
#else
	(ErrorCode, ErrorClass, Position)
	int ErrorCode;
	int ErrorClass;
	tPosition Position;
#endif
{
  IgnoreAll = true;

  if(STORE_MESSAGES)
    TreeRoot->MPC_Root.Messages = mMPC_ErrorMessage(ErrorClass, Position,
						    TreeRoot->MPC_Root.Messages,
						    TreeRoot->MPC_Root.Messages,
						    ErrorCode
				  );
  else {
    tPosition pos;
    pos = RealPosition(Position);
    MessageI("Diagnostic for source file", xxInformation, pos, xxString, SourceFile(Position));
    ErrorMessage(ErrorCode, ErrorClass, pos);
  }
}

char *Save_Info(tString Info, int InfoClass);

/*********************/
void Make_ErrorMessageI
/*********************/
#if defined __STDC__ | defined __cplusplus
	(int ErrorCode, int ErrorClass, tPosition Position, int InfoClass, tString Info)
#else
	(ErrorCode, ErrorClass, Position, InfoClass, Info)
	int ErrorCode;
	int ErrorClass;
	tPosition Position;
	int InfoClass;
	tString Info;
#endif
{
  IgnoreAll = true;

  if(STORE_MESSAGES)
    TreeRoot->MPC_Root.Messages = mMPC_ErrorMessageI(ErrorClass, Position,
						     TreeRoot->MPC_Root.Messages,
						     TreeRoot->MPC_Root.Messages,
						     ErrorCode, InfoClass,
						     Save_Info(Info,InfoClass)
				  );
  else {
    tPosition pos;
    pos = RealPosition(Position);
    MessageI("Diagnostic for source file", xxInformation, pos, xxString, SourceFile(Position));
    ErrorMessageI(ErrorCode, ErrorClass, pos, InfoClass, Info);
  }
}

/***************/
void Make_Message
/***************/
#if defined __STDC__ | defined __cplusplus
	(short ErrorNumber, int ErrorClass, tPosition Position, tTree Tree)
#else
	(ErrorNumber, ErrorClass, Position, Tree)
	short ErrorNumber;
	int ErrorClass;
	tPosition Position;
	tTree Tree;
#endif
{
  Position = SourcePosition(Position, Tree);
  if(STORE_MESSAGES) {
    TreeRoot->MPC_Root.Messages = mMPC_Message(ErrorClass, Position,
						   TreeRoot->MPC_Root.Messages,
						   TreeRoot->MPC_Root.Messages,
						   ErrorNumber);
    TreeRoot->MPC_Root.Messages->MPC_Message.Tree = Tree;
  }
  else {
    tPosition pos;
    pos = RealPosition(Position);
    MessageI("Diagnostic for source file", xxInformation, pos, xxString, SourceFile(Position));
    Message(MessageText(ErrorNumber), ErrorClass, pos);
  }
}

/****************/
void Make_MessageI
/****************/
#if defined __STDC__ | defined __cplusplus
	(short ErrorNumber, int ErrorClass, tPosition Position, int InfoClass, tString Info, tTree Tree)
#else
	(ErrorNumber, ErrorClass, Position, InfoClass, Info, Tree)
	short ErrorNumber;
	int ErrorClass;
	tPosition Position;
	int InfoClass;
	tString Info;
	tTree Tree;
#endif
{
  Position = SourcePosition(Position, Tree);
  if(STORE_MESSAGES) {
     TreeRoot->MPC_Root.Messages = mMPC_MessageI(ErrorClass, Position,
						TreeRoot->MPC_Root.Messages,
						TreeRoot->MPC_Root.Messages,
						ErrorNumber, InfoClass,
						Save_Info(Info, InfoClass)
				   );
    TreeRoot->MPC_Root.Messages->MPC_Message.Tree = Tree;
  }
  else {
    tPosition pos;
    pos = RealPosition(Position);
    MessageI("Diagnostic for source file", xxInformation, pos, xxString, SourceFile(Position));
    MessageI(MessageText(ErrorNumber), ErrorClass, pos, InfoClass, Info);
  }
}

/*************/
char *Save_Info
/********(****/
#if defined __STDC__ | defined __cplusplus
	(tString Info, int InfoClass)
#else
	(Info, InfoClass)
	tString Info;
	int InfoClass;
#endif
{
  union {
    int *i_buf;
    short *sh_buf;
    long *l_buf;
    char *c_buf;
    tString s_buf;
    tIdent *ident_buf;
  } buf;

  switch(InfoClass) {
    case xxInteger:
	buf.i_buf = (int*)malloc(sizeof(int));
	*buf.i_buf = *(int*)Info;
	break;
    case xxShort:
	buf.sh_buf = (short*)malloc(sizeof(short));
	*buf.sh_buf = *(short*)Info;
	break;
    case xxLong:
	buf.l_buf = (long*)malloc(sizeof(long));
	*buf.l_buf = *(long*)Info;
	break;
    case xxCharacter:
	buf.c_buf = (char*)malloc(sizeof(char));
	*buf.c_buf = *(char*)Info;
	break;
    case xxString:
	buf.s_buf = (tString)malloc(strlen(Info)+1);
	(void)strcpy(buf.s_buf, Info);
	break;
    case xxIdent:
	buf.ident_buf = (tIdent*)malloc(sizeof(tIdent));
	*buf.ident_buf = *(tIdent*)Info;
	break;
    default:
	printf(">>>>>>>>>>>>>> InfoClass = %d\n", InfoClass);
	CompilerError("Invalid class of additional information in SaveInfo()", NoPosition);
  }
  return buf.s_buf;
}


/****************/
void CompilerError
/****************/
#if defined __STDC__ | defined __cplusplus
	(tString ErrorText, tPosition Position)
#else
	(ErrorText, Position)
	tString ErrorText;
	tPosition Position;
#endif
{
  if(STORE_MESSAGES) { /* print all stored messages: */
    TreeRoot->MPC_Root.Source =
      ReverseTree(TreeRoot->MPC_Root.Source);
    Print_Messages();
  /*Print_Messages() is Errors_Exit of front-end;*/
  }
  MessageI("Compiler error (position - after preprocessing)",xxFatal,Position,xxString,ErrorText);
  exit(1);
}

/*******************/
void Sort_Messages ()
/*******************/
{
  tTree list, mess, *prevNext, *prevPrev, first, prev;

  list = mMPC_FreeNode(TreeRoot);
  
  while(TreeRoot->MPC_Root.Messages->Kind!=kMPC_FreeNode) {
    prevNext = prevPrev = &TreeRoot->MPC_Root.Messages;
    first = prev = TreeRoot->MPC_Root.Messages;
    mess = TreeRoot->MPC_Root.Messages->MPC_Messages.Next;
    while(mess->Kind!=kMPC_FreeNode) {
      if(mess->MPC_Messages.Pos.Line < first->MPC_Messages.Pos.Line  ||
	 mess->MPC_Messages.Pos.Line == first->MPC_Messages.Pos.Line &&
	 mess->MPC_Messages.Pos.Column <= first->MPC_Messages.Pos.Column ) {
	first = mess;
	prevNext = &prev->MPC_Messages.Next;
	prevPrev = &prev->MPC_Messages.Prev;
      }
      prev = mess;
      mess = mess->MPC_Messages.Next;
    } /* end while */
    *prevNext = *prevPrev = first->MPC_Messages.Next;
    first->MPC_Messages.Next = first->MPC_Messages.Prev = list;
    list = first;
  } /* end while */
  if(list->Kind!=kMPC_FreeNode) TreeRoot->MPC_Root.Messages = ReverseTree(list);
  
}

/****************/
void Print_Message
/****************/
#if defined __STDC__ | defined __cplusplus
	(tTree Mess)
#else
	(Mess) tTree Mess;
#endif
{
  tPosition pos;

  if(Tree_IsType(Mess, kMPC_Messages))
    pos = RealPosition(Mess->MPC_Messages.Pos);
  else {
    CompilerError("Trying to print non-existing error message",NoPosition);
    return;
  }

  if(Tree_IsType(Mess, kMPC_ErrorMessage) &&
     (DEBUG || (Mess->MPC_ErrorMessage.ErrorCode==xxSyntaxError  ||
	        Mess->MPC_ErrorMessage.ErrorCode==xxTooManyErrors )
	    || (VERBOSE && Mess->MPC_ErrorMessage.ErrorCode==xxRestartPoint)
     ) )
    ErrorMessage(Mess->MPC_ErrorMessage.ErrorCode,
		 Mess->MPC_ErrorMessage.ErrorClass, pos);

  if(Tree_IsType(Mess, kMPC_ErrorMessageI)  &&
     (DEBUG || (Mess->MPC_ErrorMessageI.ErrorCode==xxSyntaxError  ||
                Mess->MPC_ErrorMessageI.ErrorCode==xxTooManyErrors )
            || (VERBOSE && Mess->MPC_ErrorMessageI.ErrorCode==xxRestartPoint)
     ) )
    ErrorMessageI(Mess->MPC_ErrorMessageI.ErrorCode,
		  Mess->MPC_ErrorMessageI.ErrorClass, pos,
		  Mess->MPC_ErrorMessageI.InfoClass,
		  Mess->MPC_ErrorMessageI.Info);

  if(Tree_IsType(Mess, kMPC_Message))
    Message(MessageText(Mess->MPC_Message.MessageNumber),
	    Mess->MPC_Message.ErrorClass, pos);

  if(Tree_IsType(Mess, kMPC_MessageI))
    MessageI(MessageText(Mess->MPC_MessageI.MessageNumber),
	     Mess->MPC_MessageI.ErrorClass, pos,
	     Mess->MPC_MessageI.InfoClass,
	     Mess->MPC_MessageI.Info);
}

/********************/
void Print_Messages ()
/********************/
{
  tTree mess, src;
  tPosition pos = NoPosition;

  Sort_Messages();

  mess = TreeRoot->MPC_Root.Messages;
  src  = TreeRoot->MPC_Root.Source;

  while(Tree_IsType(mess, kMPC_Messages)) {

    if(Tree_IsType(mess, kMPC_Messages) && Tree_IsType(src, kMPC_Source) &&
       (pos.Line==NoPosition.Line && pos.Column==NoPosition.Column ||
	Tree_IsType(src->MPC_Source.Next, kMPC_Source) &&
	(pos.Line>=src->MPC_Source.Next->MPC_Source.VirtPos.Line ||  /* additional () from 3xx */
	 pos.Line==src->MPC_Source.Next->MPC_Source.VirtPos.Line &&
	 pos.Column>=src->MPC_Source.Next->MPC_Source.VirtPos.Column))) { /*print file name:*/

      pos = mess->MPC_Messages.Pos;
      while(src->MPC_Source.Next->Kind==kMPC_Source &&
	    (pos.Line>=src->MPC_Source.Next->MPC_Source.VirtPos.Line ||
	     pos.Line==src->MPC_Source.Next->MPC_Source.VirtPos.Line &&
	     pos.Column>=src->MPC_Source.Next->MPC_Source.VirtPos.Column))
	src = src->MPC_Source.Next;
      if(strcmp(src->MPC_Source.FileName, "\"my_o_my.mpc\""))
        MessageI("Diagnostics for source file", xxInformation, RealPosition(pos),
		xxString, src->MPC_Source.FileName );

    } else {  /* print current message: */

      Print_Message(mess);
      mess = mess->MPC_Messages.Next;
      if(Tree_IsType(mess, kMPC_Messages)) pos = mess->MPC_Messages.Pos;

    } /* end if; */

  }  /* end while; */

  STORE_MESSAGES = false;
  
}

/*****************/
int Scan_Messages()
/*****************/
{
  tTree mess=TreeRoot->MPC_Root.Messages;

  while(mess!=NoTree && Tree_IsType(mess, kMPC_Messages)){
    if(mess->Kind==kMPC_ErrorMessage || mess->Kind==kMPC_ErrorMessageI)
      return 1; /* ERROR */
    switch(mess->MPC_Messages.ErrorClass) {
      case xxFatal:
      case xxRestriction:
      case xxError:
      case xxRepair:
	return 1;  /* ERROR */
    }
    mess = mess->MPC_Messages.Next;
  }
  return 0;  /* NO ERRORS */
}

/*****************/
void New_SourceFile
/*****************/
#if defined __STDC__ | defined __cplusplus
	(tString FileName, tPosition VirtPos, tPosition RealPos)
#else
	(FileName,VirtPos,RealPos)
	tString FileName;
	tPosition VirtPos;
	tPosition RealPos;
#endif
{
  TreeRoot->MPC_Root.Source =
	mMPC_Source(FileName, VirtPos, RealPos,
		    TreeRoot->MPC_Root.Source,
		    TreeRoot->MPC_Root.Source);
}

/****************/
tString SourceFile
/****************/
#if defined __STDC__ | defined __cplusplus
	(tPosition VirtPos)
#else
	(VirtPos)
	tPosition VirtPos;
#endif
{
  tTree src, next_src;

  src = next_src = TreeRoot->MPC_Root.Source;

  if(src->MPC_Source.Next != src->MPC_Source.Prev)  /* Source list is in direct order: */
    while(Tree_IsType(next_src, kMPC_Source) &&
	  VirtPos.Line > next_src->MPC_Source.VirtPos.Line) next_src = (src=next_src)->MPC_Source.Next;
  else  /* Source list is in reverse order: */
    while(Tree_IsType(src, kMPC_Source) &&
	  VirtPos.Line < src->MPC_Source.VirtPos.Line) src = src->MPC_Source.Next;
  return src->MPC_Source.FileName;
}

/********************/
tPosition RealPosition
/********************/
#if defined __STDC__ | defined __cplusplus
	(tPosition VirtPos)
#else
	(VirtPos)
	tPosition VirtPos;
#endif
{
  tTree src, next_src;
  tPosition real_pos;

  if(!Compare(VirtPos,NoPosition)) return NoPosition;

  src = next_src = TreeRoot->MPC_Root.Source;

  if(src->MPC_Source.Next != src->MPC_Source.Prev)  /* Source list is in direct order: */
    while(Tree_IsType(next_src, kMPC_Source) &&
	  VirtPos.Line > next_src->MPC_Source.VirtPos.Line)
      next_src = (src=next_src)->MPC_Source.Next;
  else  /* Source list is in reverse order: */
    while(Tree_IsType(src, kMPC_Source) &&
	  VirtPos.Line < src->MPC_Source.VirtPos.Line) src = src->MPC_Source.Next;

  if(VirtPos.Line > src->MPC_Source.VirtPos.Line)
    real_pos.Column = VirtPos.Column;
  else  /* the first line in source, recalculate 'Column': */
    real_pos.Column = VirtPos.Column - src->MPC_Source.VirtPos.Column;

  real_pos.Line = VirtPos.Line - src->MPC_Source.VirtPos.Line +
		  src->MPC_Source.RealPos.Line;
  return real_pos;
}

/********************/
tPosition VirtPosition
/********************/
#if defined __STDC__ | defined __cplusplus
	(tString FileName, tPosition RealPos)
#else
	(FileName, RealPos)
	tString FileName;
	tPosition RealPos;
#endif
{
  tTree src;
  tPosition virt_pos;
  bool found=false;

  src = TreeRoot->MPC_Root.Source;

  while(Tree_IsType(src, kMPC_Source))
    if( !strcmp(src->MPC_Source.FileName, FileName) &&
	RealPos.Line >= src->MPC_Source.RealPos.Line ) {
      virt_pos.Column = RealPos.Column;
      virt_pos.Line = RealPos.Line - src->MPC_Source.RealPos.Line +
		      src->MPC_Source.VirtPos.Line;
      found = true;
    }
  if(found)
    return virt_pos;
  CompilerError("Invalid arguments of VirtPosition()",NoPosition);
  return NoPosition;
}


/***********************/
tPosition  SourcePosition
/***********************/
#if defined __STDC__ | defined __cplusplus
	(tPosition Pos, tTree Tree)
#else
	(Pos, Tree)
	tPosition Pos;
	tTree Tree;
#endif
{
  if(Tree!=NoTree && Tree->Kind==kMPC_NetCastExpr && !Tree->MPC_Expr.Flag.Source) {
  /* generated NetCast, => */
    while(Tree->Kind==kMPC_NetCastExpr && !Tree->MPC_Expr.Flag.Source)
      Tree = Tree->MPC_NetCastExpr.Operand;
    Pos = Tree->MPC_Expr.Pos;
  }
  return Pos;
}
