/* "White list" of functions that can be used in demo mode */

#include "gnu_kw.h"
#include <string.h>

#include "mpc_demo.h"

char *WL_Table_Init[] = {
# include "d_init.h"
   ,
   NULL  /* list terminator; */
};

/* "White list" table of functions: */

#define WLT_SIZE  512

tIdent WL_Table[WLT_SIZE];
int WL_Table_Index = 0;

/**********/
void WL_Init
/**********/
#if defined __STDC__ | defined __cplusplus
      (void)
#else
      ()
#endif
{
  for(; WL_Table_Init[WL_Table_Index]!=NULL; WL_Table_Index++){
    WL_Table[WL_Table_Index] =
         MakeIdent(WL_Table_Init[WL_Table_Index],
                   strlen(WL_Table_Init[WL_Table_Index]));
  }
}

/***********/
void WL_Close
/***********/
#if defined __STDC__ | defined __cplusplus
      (void)
#else
      ()
#endif
{
  WL_Table_Index = 0;
}

/*********/
void WL_Add
/*********/
#if defined __STDC__ | defined __cplusplus
      (tIdent Ident)
#else
      (Ident) tIdent Ident;
#endif
{
   WL_Table[WL_Table_Index++] = Ident;
}

/**************/
bool WL_Contains
/**************/
#if defined __STDC__ | defined __cplusplus
      (tIdent Ident)
#else
      (Ident) tIdent Ident;
#endif
{
  int i;
  for(i=0; i<WL_Table_Index; i++) {
    if(Ident==WL_Table[i]) return true;
  }
  return false;
}
