#include <stdio.h>
#include "options.h"
#include "Errors.h"

struct Message
{short Number;		/* MessageCode			*/
 char *Short;		/* Short message variant	*/
 char *Long;		/* Long message variant 	*/
};

/* ALL messages MUST BE ordered by 'Number' !   */

/*
 Message numeration conventions:

 001-049   compiler information
 050-099   lexical elements
 100-199   casts
 200-399   expressions
 400-599   declarations
 600-799   statements

*/

struct Message AllMessages[]=
{ 
   /* Compiler information */
   
  {1	, "Compilation continued after errors", "Compilation continued after errors"},
  {2	, "   Previous declaration of this identifier is located in file", "   Previous declaration of this identifier is located in file"},
  {3	, "   and starts in line", "   and starts in line"},
  {4	, "   (Errors possible in declaration of net type)", "   (Errors possible in declaration of net type)"},
  {5	, "   (Possibly this is syntax error)", "   (Possibly this is syntax error)"},
  {6	, "   Previous declaration of this label is located in file", "   Previous declaration of this label is located in file"},
  {7	, "   (Struct/union not declared)", "   (Struct/union not declared)"},
  {8	, "   Maybe the control expression of selection/iteration statement inside of basic function is not replicated or not [*]-distributed", "   Maybe the control expression of selection/iteration statement inside of basic function is not replicated or not [*]-distributed"},
  {9	, "   Maybe the control expression of selection/iteration statement inside of network function is not replicated or its distribution is subnet of the network parameter", "   Maybe the control expression of selection/iteration statement inside of network function is not replicated or its distribution is subnet of the network parameter"},
  {10	, "   This control expression is located in line", "   This control expression is located in line"},
  {11	, "   (This function must return only replicated value)", "   (This function must return only replicated value)"},
  {12	, "   (This is a case of [*]-distributed statement(s))", "   (This is a case of [*]-distributed statement(s))"},
  {13	, "   This label is declared in file", "   This label is declared in file"},
  {14	, "   in line", "   in line"},
  {15	, "   This function or its prototype is declared in file", "   This function or its prototype is declared in file"},
  {16	, "   and parameter declaration starts in line", "   and parameter declaration starts in line"},
  {17	, "   This topology declaration is located in file", "   This topology declaration is located in file"},
  {18	, "   This parameter declaration is located in file", "   This parameter declaration is located in file"},
  {19	, "Too bad errors, compilation terminated", "Too bad errors, compilation terminated"},
  {20	, "   The case label with the same value is declared in file", "   The case label with the same value is declared in file"},
  {21	, "   The previous 'default' label is declared in file", "   The previous 'default' label is declared in file"},
  {22	, "Too many elements in initializer list", "Too many elements in initializer list"},
  {23	, "   (This is not a C[]-construction)", "   (This is not a C[]-construction)"},
  {24	, "Diagnostic for source file", "Diagnostic for source file"},
  {25	, "Too many nets (subnets) declared in program; you can avoid this exception using -netNN option (where NN is number of nets or subnets in this program);", "Too many nets (subnets) declared in program; you can avoid this exception using -netNN option (where NN is number of nets or subnets in this program);"},
  {26	, "Number of currently declared nets/subnets", "Number of currently declared nets/subnets"},
  {27	, "DEMO MODE: Forbidden function call", "DEMO MODE: Forbidden function call"},
  {28	, "   This variable is declared in line", "   This variable is declared in line"},
  {29	, "   The subnet/supernet relation can't be checked because operand's distribution is subnetwork and the relation is not declared explicitly", "   The subnet/supernet relation can't be checked because operand's distribution is subnetwork and the relation is not declared explicitly"},
  {30	, "   The inner label in form of distribution specifier is located in line", "   The inner label in form of distribution specifier is located in line"},
  {31	, "   The subnet/supernet relation can't be checked if both distribution specifiers are subnetworks and the relation is not declared explicitly", "   The subnet/supernet relation can't be checked if both distribution specifiers are subnetworks and the relation is not declared explicitly"},
  {32	, "   The inner distribution specifier is located in line", "   The inner distribution specifier is located in line"},
  {33	, "More errors possible", "More errors possible"},
  {34	, "Label not used", "Label not used"},
  {35	, "   The corresponding non-repl parameter declaration is located in file", "   The corresponding non-repl parameter declaration is located in file"},
  {36	, "   The corresponding non-const parameter declaration is located in file", "   The corresponding non-const parameter declaration is located in file"},
  {37	, "Invalid size of right undistributed operand of '=' possible (cannot check size of left (sub)net)", "Invalid size of right undistributed operand of '=' possible (cannot check size of left (sub)net)"},
  {38	, "Incorrect distribution of operands of '=' possible (cannot check size of left net or subnet)", "Incorrect distribution of operands of '=' possible (cannot check size of left net or subnet)"},
  {39	, "Incorrect distribution of operands of '=' possible (cannot check size of right net or subnet)", "Incorrect distribution of operands of '=' possible (cannot check size of right net or subnet)"},
  {40	, "Invalid size of left undistributed operand of '=' possible (cannot check size of right (sub)net)", "Invalid size of left undistributed operand of '=' possible (cannot check size of right (sub)net)"},
  {41	, "Sorry, this is not implemented currently (topo-functions not generated)", "Sorry, this is not implemented currently (topo-functions not generated)"},
  {42	, "Can't use this predicate for semantic checks; more errors possible", "Can't use this predicate for semantic checks; more errors possible"},
  {43	, "   This distribution specifier is a special label located in line", "   This distribution specifier is a special label located in line"},
  {44   , "Not implemented yet", "Not implemented yet"}, 



   /* Lexical elements */

  {50	, "Invalid escape sequence in character constant", "Invalid escape sequence in character constant"},
  {51	, "Illegal character", "Illegal character"},
  {52	, "Maybe your 'cpp' don't allows some ANSI C facilities", "Maybe your 'cpp' don't allows some ANSI C facilities"},
  {53	, "Unclosed comment", "Unclosed comment"},
  {54	, "Invalid escape sequence in string literal", "Invalid escape sequence in string literal"},


   /* Casts */

  {100	, "Net or subnet specifier in net cast expression contains net type specifier ", "Net or subnet specifier in net cast expression contains net type specifier "},
  {101	, "Only name of net possible", "Only name of net possible"},
  {102	, "Name of net not found", "Name of net not found"},
  {103	, "Net or subnet name undeclared", "Net or subnet name undeclared"},
  {104	, "Invalid net cast expression inside of network function", "Invalid net cast expression inside of network function"},
  {105	, "Invalid net cast expression", "Invalid net cast expression"},
  {106	, "Distribution specifier isn't subnet of distribution of identifier", "Distribution specifier isn't subnet of distribution of identifier"},
  {107	, "Distribution specifier isn't subnet or supernet of inner distribution specifier in nested labeled stat", "Distribution specifier isn't subnet or supernet of inner distribution specifier in nested labeled stat"},
  {108	, "Distribution specifier isn't subnet or supernet of inner distribution specifier", "Distribution specifier isn't subnet or supernet of inner distribution specifier"},
  {109	, "Incompatible type name and type of operand of cast expression", "Incompatible type name and type of operand of cast expression"},
  {110	, "Invalid type of operand of net cast expression", "Invalid type of operand of net cast expression"},
  {111  , "This expression cannot be implicitly labeled by distibution specifier", "This expression cannot be implicitly labeled by distibution specifier. Use network cast explicitly."},
  

   /* Expressions */

  {200	, "Invalid or unimplemented code of unary operator in constant subexpression (operator ignored);  OpCode", "Invalid or unimplemented code of unary operator in constant subexpression (operator ignored);  OpCode"},
  {201	, "Error in operand of 'sizeof', sizeof-expression not evaluated", "Error in operand of 'sizeof', sizeof-expression not evaluated"},
  {202	, "Void operand of 'sizeof' expression", "Void operand of 'sizeof' expression"},
  {203	, "Incomplete struct type as an operand of 'sizeof'", "Incomplete struct type as an operand of 'sizeof'"},
  {204	, "Incomplete union type as an operand of 'sizeof'", "Incomplete union type as an operand of 'sizeof'"},
  {205	, "Sorry, 'sizeof' is not implemented for this operand", "Sorry, 'sizeof' is not implemented for this operand"},
  {206	, "Invalid or unimplemented code of binary operator in constant subexpression (operator ignored);  OpCode", "Invalid or unimplemented code of binary operator in constant subexpression (operator ignored);  OpCode"},
  {207	, "Invalid type of index", "Invalid type of index"},
  {208	, "Invalid type of expression before '['", "Invalid type of expression before '['"},
  {209	, "Invalid type of index expression", "Invalid type of index expression"},
  {210	, "Invalid type(s) of operand(s) of indexing operator", "Invalid type(s) of operand(s) of indexing operator"},
  {211	, "Invalid operand of the unary '[]'", "Invalid operand of the unary '[]'"},
  {212	, "Operand of '++' is constant expression or not lvalue", "Operand of '++' is constant expression or not lvalue"},
  {213	, "Invalid type of operand of '++'", "Invalid type of operand of '++'"},
  {214	, "Operand of '--' is constant expression or not lvalue", "Operand of '--' is constant expression or not lvalue"},
  {215	, "Invalid type of operand of '--'", "Invalid type of operand of '--'"},
  {216	, "Storage class of operand of unary '&' is 'register'", "Storage class of operand of unary '&' is 'register'"},
  {217	, "Operand of unary '&' is not lvalue", "Operand of unary '&' is not lvalue"},
  {218	, "Invalid type of operand of unary '*'", "Invalid type of operand of unary '*'"},
  {219	, "Invalid type of operand of unary '+'", "Invalid type of operand of unary '+'"},
  {220	, "Invalid type of operand of unary '-'", "Invalid type of operand of unary '-'"},
  {221	, "Invalid type of operand of operator '~'", "Invalid type of operand of operator '~'"},
  {222	, "Invalid type of operand of operator '!'", "Invalid type of operand of operator '!'"},
  {223	, "Non-integral type (or type of element) of operand of the vector reduce operator", "Non-integral type (or type of element) of operand of the vector reduce operator"},
  {224	, "Invalid type of operand of linear operator", "Invalid type of operand of linear operator"},
  {225	, "Operand of linear operator is not vector", "Operand of linear operator is not vector"},
  {226	, "Vector operands of the binary operator have different length", "Vector operands of the binary operator have different length"},
  {227	, "Left operand of '.' is not struct or union", "Left operand of '.' is not struct or union"},
  {228	, "Struct or union has no member named", "Struct or union has no member named"},
  {229	, "Left operand of '->' is not pointer to struct or union", "Left operand of '->' is not pointer to struct or union"},
  {230	, "Invalid type of left operand of the multiplicative operator", "Invalid type of left operand of the multiplicative operator"},
  {231	, "Invalid type of right operand of the multiplicative operator", "Invalid type of right operand of the multiplicative operator"},
  {232	, "Invalid type of left operand of '%'", "Invalid type of left operand of '%'"},
  {233	, "Invalid type of right operand of '%'", "Invalid type of right operand of '%'"},
  {234	, "Invalid type of left operand of binary '+'", "Invalid type of left operand of binary '+'"},
  {235	, "Invalid type of right operand of binary '+'", "Invalid type of right operand of binary '+'"},
  {236	, "Invalid or incompatible types of operands of binary '-'", "Invalid or incompatible types of operands of binary '-'"},
  {237	, "Invalid type of left operand of the shift operator", "Invalid type of left operand of the shift operator"},
  {238	, "Invalid type of right operand of the shift operator", "Invalid type of right operand of the shift operator"},
  {239	, "Invalid or incompatible types of operands of the relational operator", "Invalid or incompatible types of operands of the relational operator"},
  {240	, "Invalid or incompatible types of operands of the equality operator", "Invalid or incompatible types of operands of the equality operator"},
  {241	, "Invalid type of left operand of the logical operator", "Invalid type of left operand of the logical operator"},
  {242	, "Invalid type of right operand of the logical operator", "Invalid type of right operand of the logical operator"},
  {243	, "Invalid or incompatible types of operands of '='", "Invalid or incompatible types of operands of '='"},
  {244	, "Left operand of '=' is not lvalue", "Left operand of '=' is not lvalue"},
  {245	, "Left operand of '=' is read-only", "Left operand of '=' is read-only"},
  {246	, "Left operand of compound assignment has not integral type", "Left operand of compound assignment has not integral type"},
  {247	, "Right operand of compound assignment has not integral type", "Right operand of compound assignment has not integral type"},
  {248	, "Left operand of compound assignment has not arithmetic type", "Left operand of compound assignment has not arithmetic type"},
  {249	, "Right operand of compound assignment has not arithmetic type", "Right operand of compound assignment has not arithmetic type"},
  {250	, "Invalid (not integral) type of right operand of compound assignment", "Invalid (not integral) type of right operand of compound assignment"},
  {251	, "Invalid or incompatible operand types in compound assignment", "Invalid or incompatible operand types in compound assignment"},
  {252	, "Left operand of compound assignment is not lvalue", "Left operand of compound assignment is not lvalue"},
  {253	, "Left operand of compound assignment is declared with 'const' qualifier", "Left operand of compound assignment is declared with 'const' qualifier"},
  {254	, "Sorry, this operator is not implemented", "Sorry, this operator is not implemented"},
  {255	, "Different length of vector operands of operator '?:'", "Different length of vector operands of operator '?:'"},
  {256	, "Invalid type of condition in conditional expression", "Invalid type of condition in conditional expression"},
  {257	, "Invalid or incompatible types of operands #2 and #3 of conditional expression", "Invalid or incompatible types of operands #2 and #3 of conditional expression"},
  {258	, "Invalid type of first operand of grid operator [:]", "Invalid type of first operand of grid operator [:]"},
  {259	, "Invalid first operand of grid operator '[:]'", "Invalid first operand of grid operator '[:]'"},
  {260	, "Type of argument in function call is wrong or incompatible with prototype", "Type of argument in function call is wrong or incompatible with prototype"},
  {261	, "Type of argument is wrong or incompatible with topology declaration", "Type of argument is wrong or incompatible with topology declaration"},
  {262	, "Parameter is declared 'repl' and argument is not 'repl'", "Parameter is declared 'repl' and argument is not 'repl'"},
  {263	, "Left operand of assignment is repl and right operand isn't", "Left operand of assignment is repl and right operand isn't"},
  {264	, "Invalid distribution of operands of binary operator", "Invalid distribution of operands of binary operator"},
  {265	, "Incompatible size of left (sub)net and right undistributed vector", "Incompatible size of left (sub)net and right undistributed vector"},
  {266	, "Invalid distribution of operands of '=' (different size of left and right (sub)nets)", "Invalid distribution of operands of '=' (different size of left and right (sub)nets)"},
  {267	, "Left undistributed operand of distributed assignment is not lvector", "Left undistributed operand of distributed assignment is not lvector"},
  {268	, "Incompatible size of left undistributed lvector and right (sub)net", "Incompatible size of left undistributed lvector and right (sub)net"},
  {269	, "Invalid or incompatible distribution of operands of '='", "Invalid or incompatible distribution of operands of '='"},
  {270	, "Invalid type in synchronous assignment (right operand is pointer-dependent and can't be transmitted)", "Invalid type in synchronous assignment (right operand is pointer-dependent and can't be transmitted)"},
  {271	, "No such coordinate in this topology", "No such coordinate in this topology"},
  {272	, "Statement with unreplicated distributed control expression should be acynchronous", "Statement with unreplicated distributed control expression should be acynchronous"},
  {273	, "Control expression(s) and statement(s) in selection or iteration statement are of different distribution", "Control expression(s) and statement(s) in selection or iteration statement are of different distribution"},
  {274	, "Invalid (not integral) size of array", "Invalid (not integral) size of array"},
  {275	, "This array type is used in global declarations but its size is not constant", "This array type is used in global declarations but its size is not constant"},
  {276	, "Invalid (not integral) step of array", "Invalid (not integral) step of array"},
  {277	, "This array type is used in global declarations but its step is not constant", "This array type is used in global declarations but its step is not constant"},
  {278	, "This pointer type is used in global declarations but its step is not constant", "This pointer type is used in global declarations but its step is not constant"},
  {279	, "The distributed net can't be specified inside of timeof expression", "The distributed net can't be specified inside of timeof expression"},
  {280	, "Invalid lower bound of grid", "Invalid lower bound of grid"},
  {281	, "Invalid upper bound of grid", "Invalid upper bound of grid"},
  {282	, "Invalid grid step", "Invalid grid step"},
  {283	, "Net or subnet undeclared", "Net or subnet undeclared"},
  {284	, "Bad or missing argument list in network function call", "Bad or missing argument list in network function call"},
  {285	, "This expression can't be used in net type argument", "This expression can't be used in net type argument"},
  {286	, "Too few network arguments in function call", "Too few network arguments in function call"},
  {287	, "Too many network arguments in function call", "Too many network arguments in function call"},
  {288	, "Network function call incompatible with prototype (invalid net argument)", "Network function call incompatible with prototype (invalid net argument)"},
  {289	, "Identifier not declared", "Identifier not declared"},
  {290	, "Incorrect use of distributed variable inside of nodal or network function", "Incorrect use of distributed variable inside of nodal or network function"},
  {291	, "Operand of 'coordof' is not distributed or [*]-distributed", "Operand of 'coordof' is not distributed or [*]-distributed"},
  {292	, "Invalid operand of reduce operator (distributed on flexible subnet)", "Invalid operand of reduce operator (distributed on flexible subnet)"},
  {293	, "Operands of ternary operator have different distribution", "Operands of ternary operator have different distribution"},
  {294	, "Operands of grid operator have different distribution", "Operands of grid operator have different distribution"},
  {295	, "Basic function is called inside of nodal or network function", "Basic function is called inside of nodal or network function"},
  {296	, "Invalid (not [*]) distribution of pointer to basic function", "Invalid (not [*]) distribution of pointer to basic function"},
  {297	, "Not empty list of network arguments in basic function call", "Not empty list of network arguments in basic function call"},
  {298	, "Invalid distribution of argument of basic function", "Invalid distribution of argument of basic function"},
  {299	, "Argument of basic function is not replicated", "Argument of basic function is not replicated"},
  {300	, "Pointer to nodal function and argument have different distribution", "Pointer to nodal function and argument have different distribution"},
  {301	, "Not empty list of network arguments in nodal function call", "Not empty list of network arguments in nodal function call"},
  {302	, "Network arguments are missing in network function call", "Network arguments are missing in network function call"},
  {303	, "Invalid distribution of pointer to network function", "Invalid distribution of pointer to network function"},
  {304	, "Network function is called on flexible subnet", "Network function is called on flexible subnet"},
  {305	, "Net argument and argument of network function have different distribution", "Net argument and argument of network function have different distribution"},
  {306	, "Net argument and network argument have different distribution", "Net argument and network argument have different distribution"},
  {307	, "Network argument in function call is not replicated", "Network argument in function call is not replicated"},
  {308	, "First operand of call expression is not pointer to function", "First operand of call expression is not pointer to function"},
  {309	, "Distribution of argument incompatible with prototype", "Distribution of argument incompatible with prototype"},
  {310	, "Too many arguments in function call", "Too many arguments in function call"},
  {311	, "Too few arguments in function call", "Too few arguments in function call"},
  {312	, "Argument list missing in function call", "Argument list missing in function call"},
  {313	, "Distributed variable in expression inside of nodal function", "Distributed variable in expression inside of nodal function"},
  {314	, "Passing the argument discards 'repl' from pointer target type", "Passing the argument discards 'repl' from pointer target type"},
  {315	, "Passing the argument discards 'const' from pointer target type", "Passing the argument discards 'const' from pointer target type"},
  {316	, "Net class ignored inside of timeof expression", "Net class ignored inside of timeof expression"},
  {317	, "Unimplemented operator in expression inside of topology", "Unimplemented operator in expression inside of topology"},
  {318  , "Missing operand(s) of ternary expression", "Missing operand(s) of ternary expression (this is restriction of the current implementation)"},
  

   /* Declarations */

  {400	, "Type qualifier duplicated", "Type qualifier duplicated"},
  {401	, "Invalid redeclaration of identifier", "Invalid redeclaration of identifier"},
  {402	, "Redeclaration of struct/union member", "Redeclaration of struct/union member"},
  {403	, "Invalid redeclaration of struct/union/enum/nettype", "Invalid redeclaration of struct/union/enum/nettype"},
  {404	, "Conflicting result types in redeclaration of function", "Conflicting result types in redeclaration of function"},
  {405	, "Function was previously declared with another function kind", "Function was previously declared with another function kind"},
  {406	, "Function was previously declared 'static'", "Function was previously declared 'static'"},
  {407	, "Function is declared 'static' and has non-static prototype(s)", "Function is declared 'static' and has non-static prototype(s)"},
  {408	, "Function is declared without parameters and previously was declared with parameter list", "Function is declared without parameters and previously was declared with parameter list"},
  {409	, "Conflicting types in function parameter declaration", "Conflicting types in function parameter declaration"},
  {410	, "List of parameters is too long", "List of parameters is too long"},
  {411	, "List of parameters is too short", "List of parameters is too short"},
  {412	, "Cannot evaluate parent node of this network", "Cannot evaluate parent node of this network"},
  {413	, "Sorry, the compiler cannot evaluate the parent node of this network", "Sorry, the compiler cannot evaluate the parent node of this network"},
  {414	, "Invalid declarator in function definition", "Invalid declarator in function definition"},
  {415	, "Definition of network function without net parameter", "Definition of network function without net parameter"},
  {416	, "Invalid declarator in function definition (without parameter list)", "Invalid declarator in function definition (without parameter list)"},
  {417	, "Invalid declaration (not variable) in old-fashioned definition of function", "Invalid declaration (not variable) in old-fashioned definition of function"},
  {418	, "Invalid storage class in parameter declaration", "Invalid storage class in parameter declaration"},
  {419	, "No such identifier in list of parameters", "No such identifier in list of parameters"},
  {420	, "Invalid declaration of network parameter", "Invalid declaration of network parameter"},
  {421	, "Invalid declaration of special network parameter (only scalar or array without step is possible)", "Invalid declaration of special network parameter (only scalar or array without step is possible)"},
  {422	, "Invalid (not integral) type of constant in size of special parameter", "Invalid (not integral) type of constant in size of special parameter"},
  {423	, "Unimplemented kind of expression in declaration of special parameter", "Unimplemented kind of expression in declaration of special parameter"},
  {424	, "Invalid type of network parameter (the corresponding topo-parameter is scalar)", "Invalid type of network parameter (the corresponding topo-parameter is scalar)"},
  {425	, "List of network parameters is too short (compared to nettype declaration)", "List of network parameters is too short (compared to nettype declaration)"},
  {426	, "List of network parameters is too long (compared to nettype declaration)", "List of network parameters is too long (compared to nettype declaration)"},
  {427	, "The global declaration introduces array or pointer type, which has dynamic size or step", "The global declaration introduces array or pointer type, which has dynamic size or step"},
  {428	, "Ellipsis not at end of parameter list", "Ellipsis not at end of parameter list"},
  {429	, "Net definition is possible only at global level or in basic function", "Net definition is possible only at global level or in basic function"},
  {430	, "Invalid class of computing space in subnet declaration", "Invalid class of computing space in subnet declaration"},
  {431	, "Declaration of net type is possible only at global level", "Declaration of net type is possible only at global level"},
  {432	, "Net type has parameters, but argument list is missing", "Net type has parameters, but argument list is missing"}, 
  {433  , "Struct/union member declared void or array of void", "Struct/union member declared void or array of void"},
  {434	, "This struct/union member declaration introduces an array or pointer type, which has dynamic size or step", "This struct/union member declaration introduces an array or pointer type, which has dynamic size or step"},
  {435	, "Variable declared void or array of void", "Variable declared void or array of void"},
  {436	, "The declarator introduces at global level an array or pointer type, which has dynamic size or step", "The declarator introduces at global level an array or pointer type, which has dynamic size or step"},
  {437	, "Invalid type in declaration or definition of variable", "Invalid type in declaration or definition of variable"},
  {438	, "Invalid parameter declaration (declared with distribution)", "Invalid parameter declaration (declared with distribution)"},
  {439	, "Distributed local variable in nodal function", "Distributed local variable in nodal function"},
  {440	, "Invalid or missing distribution of local variable in network function", "Invalid or missing distribution of local variable in network function"},
  {441	, "Specifier of automatic net or subnet is used in declaration of following static variable", "Specifier of automatic net or subnet is used in declaration of following static variable"},
  {442	, "Both absolute and relative node performances specified in one topology", "Both absolute and relative node performances specified in one topology"},
  {443	, "The net is declared static but has automatic or flexible parent net(s)", "The net is declared static but has automatic or flexible parent net(s)"},
  {444	, "Invalid distribution [*] in net declaration", "Invalid distribution [*] in net declaration"},
  {445	, "Distribution of the declared net and argument(s) of net type specifier are incompatible", "Distribution of the declared net and argument(s) of net type specifier are incompatible"},
  {446	, "The subnet is declared static but has automatic or flexible supernet(s)", "The subnet is declared static but has automatic or flexible supernet(s)"},
  {447	, "Identifier of net or subnet in left part of relation not declared", "Identifier of net or subnet in left part of relation not declared"},
  {448	, "Identifier of net or subnet in right part of relation not declared", "Identifier of net or subnet in right part of relation not declared"},
  {449	, "Not constant argument in net type specifier at global level", "Not constant argument in net type specifier at global level"},
  {450	, "Too many arguments in net type specifier", "Too many arguments in net type specifier"},
  {451	, "Invalid (not replicated) distributed argument in net type specifier", "Invalid (not replicated) distributed argument in net type specifier"},
  {452	, "Too few arguments in net type specifier", "Too few arguments in net type specifier"},
  {453	, "Illegal use of struct or union specifier inside struct or union", "Illegal use of struct or union specifier inside struct or union"},
  {454	, "Identifier is previously declared as 'union'", "Identifier is previously declared as 'union'"},
  {455	, "Identifier is previously declared as 'struct'", "Identifier is previously declared as 'struct'"},
  {456	, "Invalid class of computing space in net declaration", "Invalid class of computing space in net declaration"},
  {457	, "Invalid class of net type", "Invalid class of net type"},
  {458	, "Invalid type specifier in topology parameter declaration", "Invalid type specifier in topology parameter declaration"},
  {459	, "Invalid class of computing space in net/subnet declaration", "Invalid class of computing space in net/subnet declaration"},
  {460	, "Typedef is initialized", "Typedef is initialized"},
  {461	, "'Flex' is not a storage class", "'Flex' is not a storage class"},
  {462	, "Storage class redeclared or duplicated", "Storage class redeclared or duplicated"},
  {463	, "Invalid declaration specifier (storage class redeclared)", "Invalid declaration specifier (storage class redeclared)"},
  {464	, "Invalid basic type specifier", "Invalid basic type specifier"},
  {465	, "Typedef name not found", "Typedef name not found"},
  {466	, "Storage class redeclared or duplicated", "Storage class redeclared or duplicated"},
  {467	, "Typedef name not found", "Typedef name not found"},
  {468	, "Invalid type specifier: storage class in struct/union declaring list", "Invalid type specifier: storage class in struct/union declaring list"},
  {469	, "Not integral expression in bit field size", "Not integral expression in bit field size"},
  {470	, "Enumerator value has not integral type", "Enumerator value has not integral type"},
  {471	, "Invalid storage class in parameter declaration", "Invalid storage class in parameter declaration"},
  {472	, "Invalid storage class in function definition", "Invalid storage class in function definition"},
  {473	, "Invalid size of array", "Invalid size of array"},
  {474	, "Invalid value of step", "Invalid value of step"},
  {475	, "Incorrect use of array topology parameter inside scheme", "Incorrect use of array topology parameter inside scheme"},
  {476	, "Initializer in 'extern' declaration of identifier", "Initializer in 'extern' declaration of identifier"},
  {477	, "This typedef name is already declared 'const'", "This typedef name is already declared 'const'"},
  {478	, "This typedef name is already declared 'volatile'", "This typedef name is already declared 'volatile'"},
  {479	, "This typedef name is already declared 'repl'", "This typedef name is already declared 'repl'"},
  {480	, "struct/union declared inside parameter list, its scope is only this declaration", "struct/union declared inside parameter list, its scope is only this declaration"},
  {481	, "enum type declared inside parameter list, its scope is only this declaration", "enum type declared inside parameter list, its scope is only this declaration"},
  {482	, "Link declaration has no effect when relative node performance specified or when node declaration is absent", "Link declaration has no effect when relative node performance specified or when node declaration is absent"},
  {483	, "Invalid (not arithmetical) type of expression inside of nettype declaration", "Invalid (not arithmetical) type of expression inside of nettype declaration"},
  {484	, "Redeclaration of subnet/supernet relation", "Redeclaration of subnet/supernet relation"},
  {485	, "Ellipsis not in proper place", "Ellipsis not in proper place"},
  {486	, "Scalar (or scalar element of aggregate object) initialized by the list", "Scalar (or scalar element of aggregate object) initialized by the list"},
  {487	, "Invalid distribution of variable inside of predicate", "Invalid distribution of variable inside of predicate"},
  {488	, "Predicate inside subnet specifier should be asynchronous expression", "Predicate inside subnet specifier should be asynchronous expression"},
  {489	, "Net type undeclared", "Net type undeclared"},
  {490  , "Parameter name expected", "Parameter name expected"},
  {491  , "Network declaration inside of compound statement, which is labeled by distribution specifier", "Network declaration inside of compound statement, which is labeled by distribution specifier"},
  {492  , "Node specifier is too long", "Node specifier is too long (too many coordinates). See 'coord' declaration"},
  {493  , "Node specifier is too short", "Node specifier is too short (too few coordinates). See 'coord' declaration"},
  {494  , "Not integral expression in node specifier", "Not integral expression in node specifier"},
  {495  , "Expression in node specifier out of range", "Expression in node specifier out of range (see the corresponding constant expression in 'coord' declaration)"},
  {496  , "Scheme declaration has no effect when relative node performance specified or when node declaration is absent", "Scheme declaration has no effect when relative node performance specified or when node declaration is absent"},
  {497  , "Node declaration declares only void nodes", "Node declaration declares only void nodes"},
  {498  , "Not integral expression in coord declaration", "Not integral expression in coord declaration"},


   /* Statements */

  {600	, "Label duplicated", "Label duplicated"},
  {601	, "Invalid statement labeled with distribution specifier", "Invalid statement labeled with distribution specifier"},
  {602	, "Expression in selection statement has not a scalar type", "Expression in selection statement has not a scalar type"},
  {603	, "Expression in switch statement has not integral type", "Expression in switch statement has not integral type"},
  {604	, "Expression in iteration statement has not scalar type", "Expression in iteration statement has not scalar type"},
  {605	, "Label undeclared", "Label undeclared"},
  {606	, "Invalid distributed 'goto' inside of nodal function", "Invalid distributed 'goto' inside of nodal function"},
  {607	, "'continue' outside of iteration statement", "'continue' outside of iteration statement"},
  {608	, "Invalid distributed 'continue' inside of nodal function", "Invalid distributed 'continue' inside of nodal function"},
  {609	, "'break' outside of 'switch' or iteration statement", "'break' outside of 'switch' or iteration statement"},
  {610	, "Invalid distributed 'break' inside of nodal function", "Invalid distributed 'break' inside of nodal function"},
  {611	, "'break?' outside of 'fan' statement", "'break?' outside of 'fan' statement"},
  {612	, "Invalid distributed 'break?' inside of nodal function", "Invalid distributed 'break?' inside of nodal function"},
  {613	, "Forbidden 'return' inside of selection or iteration statement", "Forbidden 'return' inside of selection or iteration statement"},
  {614	, "Invalid distributed 'return' statement (with net/subnet specifier)", "Invalid distributed 'return' statement (with net/subnet specifier)"},
  {615	, "Invalid distribution of expression in return statement", "Invalid distribution of expression in return statement"},
  {616	, "Invalid type of expression in return statement", "Invalid type of expression in return statement"},
  {617	, "Expression in case label has not integral type", "Expression in case label has not integral type"},
  {618	, "The statement after 'recon' is not asynchronous", "The statement after 'recon' is not asynchronous"},
  {619	, "Control expression(s) and statement(s) in selection or iteration statement are of different distribution", "Control expression(s) and statement(s) in selection or iteration statement are of different distribution"},
  {620	, "Case label duplicated", "Case label duplicated"},
  {621	, "Net specifier before the parallel statement", "Net specifier before the parallel statement"},
  {622	, "Invalid net specifier in labeled statement", "Invalid net specifier in labeled statement"},
  {623	, "Subnet specifier before parallel statement", "Subnet specifier before parallel statement"},
  {624	, "Labeled statement after net specifier", "Labeled statement after net specifier"},
  {625	, "Labeled statement after subnet specifier", "Labeled statement after subnet specifier"},
  {626	, "The 'goto' statement has different distribution with the statement after label", "The 'goto' statement has different distribution with the statement after label"},
  {627  , "'%%' statement outside of scheme declaration", "'%%' statement outside of scheme declaration"},
  {628  , "'par' statement outside of scheme declaration", "'par' statement outside of scheme declaration"},
  {629  , "Expression in 'par' statement has not scalar type", "Expression in 'par' statement has not scalar type"},
  
#if !defined __STRICT_ANSI__ & !defined __STDC__
   {}
#endif
};

/*extern int VERBOSE=0;*/

char Mess_not_found[80];

char* MessageText
#if defined __STDC__ | defined __cplusplus
	(short Number)
#else
	(Number)
	short Number;
#endif

{short l,m,r;

 l=0; r=sizeof(AllMessages)/sizeof(struct Message)-1;
 m=(l+r)>>1;	/* (l+r)/2 */

 do{
  if(AllMessages[m].Number < Number ) l=m;
	else if( AllMessages[m].Number > Number) r=m;
				else return (VERBOSE)?AllMessages[m].Long:
						      AllMessages[m].Short;
  m=(l+r)>>1;
   } while(r-l>1);
   
 if( AllMessages[m].Number == Number ) return (VERBOSE)?AllMessages[m].Long:
 							AllMessages[m].Short;
 else {sprintf(Mess_not_found,"Compiler error: message number %d not found",Number);
       Message(Mess_not_found,xxError, NoPosition);
       return "";}

} 
  
  
/*
main()
{ int num;
 while(1)
 { puts(">"); scanf("%d",&num);
   puts(MessageText((short)num));
 }  
}*/
