
/*            Global context of mpC-compiler              *
 *            ==============================              *
 *            V.2.2  for  C-code  generation              *
 *            ==============================              */

# ifndef _CONTEXT
# define _CONTEXT

# include <stdlib.h>
# include <stdio.h>
# include <string.h>

# include "gnu_kw.h"

# include <limits.h>

# define    YES  1
# define    NO   0

# define UNDEFINED  (-99)      /* for Number_Of_components in array  *
                                * and function declarations;   for   *
				* FUNCTION'Component_Type (case ...);*/

       /* type constructor: */

# define    NO_TYPE            0    /* work constant, not type constructor; */
# define    VOID             (-1)
# define    CHAR             (-2)
# define    SIGNED_CHAR      (-3)
# define    UNSIGNED_CHAR    (-4)
# define    SHORT            (-5)
# define    UNSIGNED_SHORT   (-6)
# define    INT              (-7)
# define    UNSIGNED         (-8)
# define    LONG             (-9)
# define    UNSIGNED_LONG    (-10)
# define    FLOAT            (-11)
# define    DOUBLE           (-12)
# define    LONG_DOUBLE      (-13)
# define    LONG_LONG	     (-14)
# define    UNSIGNED_LONG_LONG (-15)


                 /***   Kinds  of  mpC-functions:   ***/

# define    BASIC		1
# define    NODAL		2
# define    NETWORK		3


		/***   Kinds  of  net topologies:   ***/

# define    DYNAMIC		1
# define    SPACE_REPLICATED	2
# define    CONST		3


		/***   Node types & link length: ***/

# define    VOID_NODE		0
# define    MEMORY_NODE 	VOID_NODE+1
# define    SCALAR_NODE		VOID_NODE+2
# define    VECTOR_NODE		VOID_NODE+3
# define    FAST		4
			/* fast <node_type> = <node_type>_NODE + FAST, ... */
# define    SLOW		(-4)
			/* slow <node_type> = <node_type>_NODE + SLOW, ... */

# define    BasicNodeType(t)	((t>=0)?(t%FAST):(FAST+t%FAST))
# define    NodeTypeQual(t)	((t>=0)?(t/FAST):(t/FAST-1))

# define    NO_LINK		0
# define    NORMAL_LINK		1
# define    LONG_LINK		1
# define    SHORT_LINK		(-1)


                 /*** storage & net class + others: ****/

# define    EXTERN         1
# define    STATIC         2
# define    AUTO           3
# define    REGISTER       4
# define    TYPEDEF        5    /* work constant, not storage class; */
# define    FLEXIBLE	   6
# define    PARAMETER      10
# define    REG_PAR        11
# define    GLOBAL_STATIC  12
# define    LOCAL_STATIC   13

# define    NO_NET	         NoTree
# define    HOST	         TreeRoot->MPC_Root.Host
# define    HOST_LIST	         TreeRoot->MPC_Root.HostList
# define    SINGLE_NODE          TreeRoot->MPC_Root.SingleNode
# define    SINGLE_NODE_LIST     TreeRoot->MPC_Root.SingleNodeList
# define    COMPUTING_SPACE      TreeRoot->MPC_Root.ComputingSpace
# define    COMPUTING_SPACE_LIST TreeRoot->MPC_Root.ComputingSpaceList
# define    CONST_NET	         TreeRoot->MPC_Root.Const
# define    CONST_NET_LIST       TreeRoot->MPC_Root.ConstList
# define    RECON_NET            TreeRoot->MPC_Root.Recon
# define    RECON_NET_LIST       TreeRoot->MPC_Root.ReconList

# define    HOST_NAME	     "MPC_host"
# define    SINGLE_NODE_NAME "MPC_single"
# define    ALL_NAME	     "MPC_global"
# define    CONST_NET_NAME   "MPC_const"
# define    RECON_NAME       "MPC_recon"
# define    ERROR_NAME       "MPC_error"


# include "ratc.h"        /* -- bool, true, false and tString definitions; */
# include "General.h"
# include "Idents.h"
# include "StringMem.h"
# include "Positions.h"

# define    ScopeNumber   UniqueNumber   /* alias only for MPC_Type; */

        /*** mpC Tree: attribute types: ***/

typedef short tClass;     /* storage or computing space class               *
			   *                          (AUTO, STATIC, ... ); */
typedef short tNodeType;  /* type of processor node (VOID_NODE,             *
			   *        MEMORY_NODE, SCALAR_NODE, VECTOR_NODE); */
typedef short tLinkType;  /* type of link (SHORT ... or LONG ...); */

typedef void * tFreePointer;
typedef signed char MPC_signed_char;
typedef unsigned char MPC_unsigned_char;
typedef unsigned short MPC_unsigned_short;
typedef unsigned long MPC_long_unsigned;
typedef long double MPC_long_double;

typedef struct Optm_Attributes {
  short first_slot, last_slot;
  short slot;
  short generated;
  short first_reg;
  short last_reg;
} tOptm_Attribute;


		/*** flags for MPC_Tree: ***/

#ifdef __WRK

  /* Define all flags optimized for easy look: */

  typedef struct {
	unsigned
	/*1*/	 Auto:4,
	/*2*/	 Static:4,
	/*3*/	 Register:4,
	/*4*/	 Parameter:4,
	/*5*/	 Extern:4,
	/*6*/	 Exported:4,
	/*7*/	 Distributed:4,
	/*8*/	 FC_Generated:4,
	/*9*/	 ExplDistr:4,
	/*10*/	 DistrLabel:4,
	/*11*/	 Source:4,
	/*12*/	 Ignore:4,
		 DUMMY:16;
  } tDeclFlags;

  typedef struct {
	unsigned
	/*1*/	 Const:4,
	/*2*/	 Volatile:4,
	/*3*/	 Repl:4,
	/*4*/	 BitArray:4,
	/*5*/	 DynArray:4,	/* this type tree contains dyn.array      */
	/*6*/	 ExplStep:4,    /* array/pointer step is specified expl.  */
	/*7*/	 DynStep:4,
	/*8*/	 MemCopy:4,	/* memcopy-assign is poss. (without step) */
	/*9*/	 TypedefList:4,
		/*** flags for FUNCTION & POINTER to FUNCTION: ***/
	/*10*/	 Basic:4,
	/*11*/	 Nodal:4,
	/*12*/	 Network:4,
	/*13*/	 Native:4,	/* values: mpC, C[], C ; */
		/*************************************************/
	/*14*/	 Checked:4,
	/*15*/	 Source:4,
	/*16*/	 Ignore:4;
  } tTypeFlags;

  typedef struct {
	unsigned
	/*1*/	 Distributed:4,
	/*2*/	 Asynchr:4,
	/*3*/	 PartAsynchr:4,
	/*4*/	 DistrLabel:4,
		/*** flags for COMPOUND (and other) STATEMENT: ***/
	/*5*/	 CreateAutoNet:4,
	/*6*/	 CreateStaticNet:4,
	/*7*/	 CreateSubnet:4,
	/*8*/	 CtrlSend:4,
		/*************************************************/
	/*9*/	 Source:4,
	/*10*/	 Ignore:4,
		 DUMMY:24;
  } tStatFlags;

  typedef struct {
	unsigned
	/*1*/	 Lvalue:4,
	/*2*/	 Const:4,
	/*3*/	 Distributed:4,
	/*4*/	 Asynchr:4,
	/*5*/	 PartAsynchr:4,
	/*6*/	 InParentheses:4,
		/*** following flags are not set by front-end: ***/
	/*7*/	 Generated:4,
	/*8*/	 Peculiarity:4,
	/*9*/	 Defer:4,
		/*************************************************/
	/*10*/	 SideEffects:4,	/* values: _NO_, _SRC_, _INH_ */
	/*11*/	 FixPoint:4,    /* double coded by int        */
	/*12*/	 DistrComma:4,  /* Expr contains ',' with different */
				/*      distribution of operands... */
	/*13*/	 Source:4,
	/*14*/	 Ignore:4,
		 DUMMY:8;
  } tExprFlags;

#else  /* optimize memory distribution */

  typedef struct {
	unsigned
	/*1*/	 Auto:1,
	/*2*/	 Static:1,
	/*3*/	 Register:1,
	/*4*/	 Parameter:1,
	/*5*/	 Extern:1,
	/*6*/	 Exported:1,
	/*7*/	 Distributed:1,
	/*8*/	 FC_Generated:1,
	/*9*/	 ExplDistr:1,
	/*10*/	 DistrLabel:1,
	/*11*/	 Source:1,
	/*12*/	 Ignore:1,
		 DUMMY:4;
  } tDeclFlags;

  typedef struct {
	unsigned
	/*1*/	 Const:1,
	/*2*/	 Volatile:1,
	/*3*/	 Repl:1,
	/*4*/	 BitArray:1,
	/*5*/	 DynArray:1,	/* this type tree contains dyn.array      */
	/*6*/	 ExplStep:1,    /* array/pointer step is specified expl.  */
	/*7*/	 DynStep:1,
	/*8*/	 MemCopy:1,	/* memcopy-assign is poss. (without step) */
	/*9*/	 TypedefList:1,
		/*** flags for FUNCTION & POINTER to FUNCTION: ***/
	/*10*/	 Basic:1,
	/*11*/	 Nodal:1,
	/*12*/	 Network:1,
     /*13,14*/	 Native:2,	/* values: mpC, C[], C ; */
		/*************************************************/
	/*15*/	 Checked:1,
	/*16*/	 Source:1,
	/*17*/	 Ignore:1,
		 DUMMY:15;
  } tTypeFlags;

  typedef struct {
	unsigned
	/*1*/	 Distributed:1,
	/*2*/	 Asynchr:1,
	/*3*/	 PartAsynchr:1,
	/*4*/	 DistrLabel:1,
		/*** flags for COMPOUND (and other) STATEMENT: ***/
	/*5*/	 CreateAutoNet:1,
	/*6*/	 CreateStaticNet:1,
	/*7*/	 CreateSubnet:1,
	/*8*/	 CtrlSend:1,
		/*************************************************/
	/*9*/	 Source:1,
	/*10*/	 Ignore:1,
		 DUMMY:6;
  } tStatFlags;

  typedef struct {
	unsigned
	/*1*/	 Lvalue:1,
	/*2*/	 Const:1,
	/*3*/	 Distributed:1,
	/*4*/	 Asynchr:1,
	/*5*/	 PartAsynchr:1,
	/*6*/	 InParentheses:1,
		/*** following flags are not set by front-end: ***/
	/*7*/	 Generated:1,
      /*8,9*/	 Peculiarity:2,
	/*10*/	 Defer:1,
		/*************************************************/
     /*11,12*/	 SideEffects:2,	/* values: _NO_, _SRC_, _INH_ */
	/*13*/	 FixPoint:1,    /* double coded by int        */
	/*14*/	 DistrComma:1,  /* Expr contains ',' with different */
				/*      distribution of operands... */
	/*15*/	 Source:1,
	/*16*/	 Ignore:1;
  } tExprFlags;

#endif

# include "mpc_operator.h"

# endif
