# include "Tree.h"
# define yyALLOC(ptr, size)	if ((ptr = (tTree) Tree_PoolFreePtr) >= (tTree) Tree_PoolMaxPtr) \
  ptr = Tree_Alloc (); \
  Tree_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

/* line 11 "mpc.ast" */

#include "CocktailIO.h"  

/* line 271 "mpc.ast" */


tTree Clean_OutAttributes
#if defined __STDC__ || defined __cplusplus
	(tTree node)
#else
	(node)
	tTree node;
#endif
{
  if(Tree_IsType(node, kMPC_Type)) {
    node->MPC_Type.Buffer = false;
    node->MPC_Type.UniqueNumber = 0;
    node->MPC_Type.pType = NULL;
    if(node->Kind==kMPC_PointerType)
      node->MPC_PointerType.GeneratedFrom = NoTree;
  }
  if(Tree_IsType(node, kMPC_NetType))
    node->MPC_NetType.Bench = false;
  if(Tree_IsType(node, kMPC_NetOrSubnet)) {
    node->MPC_NetOrSubnet.WithNumber = false;
    node->MPC_NetOrSubnet.SingleNode = false;
    node->MPC_NetOrSubnet.IsParent = false;
    node->MPC_NetOrSubnet.pGen = NULL;
    node->MPC_NetOrSubnet.NextUse = node->MPC_NetOrSubnet.PrevUse = NoTree;
    node->MPC_NetOrSubnet.MyList = NoTree;
    node->MPC_NetOrSubnet.UniqueNumber = 0;
  }
  if(node->Kind==kMPC_NetList)
    node->MPC_NetList.UnReduceable = false;
  if(Tree_IsType(node, kMPC_Stat)) {
    node->MPC_Stat.ActualExecNet = node->MPC_Stat.RootNet =
				   node->MPC_Stat.PropNet = NoTree;
    node->MPC_Stat.Benchmark = false;
  }
  if(node->Kind==kMPC_Goto)
    node->MPC_Goto.LabelDef = node->MPC_Goto.NextUse =
			      node->MPC_Goto.PrevUse = NoTree;
  if(Tree_IsType(node, kMPC_Label))
    node->MPC_Label.NextLabel = node->MPC_Label.PrevLabel = NoTree;
  if(node->Kind==kMPC_IdentLabel) node->MPC_IdentLabel.NextUse = NoTree;
  if(node->Kind==kMPC_Ident)
    node->MPC_Ident.NextUse = node->MPC_Ident.PrevUse = NoTree;
  if(Tree_IsType(node, kMPC_Expr)) node->MPC_Expr.ActualEvalNet = NoTree;

  return node;
}


# ifdef getchar
# undef getchar
# endif
# ifdef putchar
# undef putchar
# endif
# include "yyTree.w"

static void yyExit () { Exit (1); }

void (* Tree_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tTree TreeRoot;
unsigned long Tree_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoTree;
char * Tree_PoolFreePtr	= (char *) NoTree;
char * Tree_PoolMaxPtr	= (char *) NoTree;
static unsigned short yyMaxSize	= 0;
unsigned short Tree_NodeSize [97 + 1] = { 0,
 sizeof (yMPC_AstNode),
 sizeof (yMPC_Root),
 sizeof (yMPC_Source),
 sizeof (yMPC_Messages),
 sizeof (yMPC_ErrorMessage),
 sizeof (yMPC_ErrorMessageI),
 sizeof (yMPC_Message),
 sizeof (yMPC_MessageI),
 sizeof (yMPC_FreeNode),
 sizeof (yMPC_Decls),
 sizeof (yMPC_UncompString),
 sizeof (yMPC_Type),
 sizeof (yMPC_BasicType),
 sizeof (yMPC_EnumType),
 sizeof (yMPC_Typedef),
 sizeof (yMPC_DerivedType),
 sizeof (yMPC_ArrayType),
 sizeof (yMPC_VectorType),
 sizeof (yMPC_PointerType),
 sizeof (yMPC_StructType),
 sizeof (yMPC_UnionType),
 sizeof (yMPC_FunctionType),
 sizeof (yMPC_VarDecl),
 sizeof (yMPC_Function),
 sizeof (yMPC_Ellipsis),
 sizeof (yMPC_NetDecl),
 sizeof (yMPC_SubnetDecl),
 sizeof (yMPC_RelDecl),
 sizeof (yMPC_NetTypeDecl),
 sizeof (yMPC_NetType),
 sizeof (yMPC_NetTypeSpecifier),
 sizeof (yMPC_TopoFunctions),
 sizeof (yMPC_EnumConst),
 sizeof (yMPC_SU_MemberDecl),
 sizeof (yMPC_SU_Member),
 sizeof (yMPC_Var),
 sizeof (yMPC_CoordDecl),
 sizeof (yMPC_Node),
 sizeof (yMPC_NodeQual),
 sizeof (yMPC_NodeTypeQual),
 sizeof (yMPC_BenchQual),
 sizeof (yMPC_LinkDecl),
 sizeof (yMPC_LinkDeclaringList),
 sizeof (yMPC_LinkDeclarator),
 sizeof (yMPC_LinkLengthSpecifier),
 sizeof (yMPC_Scheme),
 sizeof (yMPC_NetList),
 sizeof (yMPC_NetOrSubnet),
 sizeof (yMPC_Net),
 sizeof (yMPC_Subnet),
 sizeof (yMPC_Relation),
 sizeof (yMPC_Stats),
 sizeof (yMPC_Stat),
 sizeof (yMPC_ExprStat),
 sizeof (yMPC_If),
 sizeof (yMPC_IfElse),
 sizeof (yMPC_Switch),
 sizeof (yMPC_While),
 sizeof (yMPC_DoWhile),
 sizeof (yMPC_For),
 sizeof (yMPC_Goto),
 sizeof (yMPC_Continue),
 sizeof (yMPC_Break),
 sizeof (yMPC_BreakFan),
 sizeof (yMPC_Return),
 sizeof (yMPC_Compound),
 sizeof (yMPC_CompScheme),
 sizeof (yMPC_CommScheme),
 sizeof (yMPC_ParScheme),
 sizeof (yMPC_Fan),
 sizeof (yMPC_Label),
 sizeof (yMPC_IdentLabel),
 sizeof (yMPC_CaseLabel),
 sizeof (yMPC_Default),
 sizeof (yMPC_Expr),
 sizeof (yMPC_Const),
 sizeof (yMPC_IntConst),
 sizeof (yMPC_UIntConst),
 sizeof (yMPC_FloatConst),
 sizeof (yMPC_StringLiteral),
 sizeof (yMPC_Ident),
 sizeof (yMPC_CastExpr),
 sizeof (yMPC_NetCastExpr),
 sizeof (yMPC_CoordExpr),
 sizeof (yMPC_SizeofExpr),
 sizeof (yMPC_Size_Of_Value),
 sizeof (yMPC_Size_Of_Type),
 sizeof (yMPC_TimeofExpr),
 sizeof (yMPC_UnaryExpr),
 sizeof (yMPC_BinaryExpr),
 sizeof (yMPC_TernaryExpr),
 sizeof (yMPC_QuaternaryExpr),
 sizeof (yMPC_CallExpr),
 sizeof (yMPC_Exprs),
 sizeof (yMPC_Initializer),
 sizeof (yMPC_SimpleInit),
 sizeof (yMPC_InitList),
};
char * Tree_NodeName [97 + 1] = {
 "NoTree",
 "MPC_AstNode",
 "MPC_Root",
 "MPC_Source",
 "MPC_Messages",
 "MPC_ErrorMessage",
 "MPC_ErrorMessageI",
 "MPC_Message",
 "MPC_MessageI",
 "MPC_FreeNode",
 "MPC_Decls",
 "MPC_UncompString",
 "MPC_Type",
 "MPC_BasicType",
 "MPC_EnumType",
 "MPC_Typedef",
 "MPC_DerivedType",
 "MPC_ArrayType",
 "MPC_VectorType",
 "MPC_PointerType",
 "MPC_StructType",
 "MPC_UnionType",
 "MPC_FunctionType",
 "MPC_VarDecl",
 "MPC_Function",
 "MPC_Ellipsis",
 "MPC_NetDecl",
 "MPC_SubnetDecl",
 "MPC_RelDecl",
 "MPC_NetTypeDecl",
 "MPC_NetType",
 "MPC_NetTypeSpecifier",
 "MPC_TopoFunctions",
 "MPC_EnumConst",
 "MPC_SU_MemberDecl",
 "MPC_SU_Member",
 "MPC_Var",
 "MPC_CoordDecl",
 "MPC_Node",
 "MPC_NodeQual",
 "MPC_NodeTypeQual",
 "MPC_BenchQual",
 "MPC_LinkDecl",
 "MPC_LinkDeclaringList",
 "MPC_LinkDeclarator",
 "MPC_LinkLengthSpecifier",
 "MPC_Scheme",
 "MPC_NetList",
 "MPC_NetOrSubnet",
 "MPC_Net",
 "MPC_Subnet",
 "MPC_Relation",
 "MPC_Stats",
 "MPC_Stat",
 "MPC_ExprStat",
 "MPC_If",
 "MPC_IfElse",
 "MPC_Switch",
 "MPC_While",
 "MPC_DoWhile",
 "MPC_For",
 "MPC_Goto",
 "MPC_Continue",
 "MPC_Break",
 "MPC_BreakFan",
 "MPC_Return",
 "MPC_Compound",
 "MPC_CompScheme",
 "MPC_CommScheme",
 "MPC_ParScheme",
 "MPC_Fan",
 "MPC_Label",
 "MPC_IdentLabel",
 "MPC_CaseLabel",
 "MPC_Default",
 "MPC_Expr",
 "MPC_Const",
 "MPC_IntConst",
 "MPC_UIntConst",
 "MPC_FloatConst",
 "MPC_StringLiteral",
 "MPC_Ident",
 "MPC_CastExpr",
 "MPC_NetCastExpr",
 "MPC_CoordExpr",
 "MPC_SizeofExpr",
 "MPC_Size_Of_Value",
 "MPC_Size_Of_Type",
 "MPC_TimeofExpr",
 "MPC_UnaryExpr",
 "MPC_BinaryExpr",
 "MPC_TernaryExpr",
 "MPC_QuaternaryExpr",
 "MPC_CallExpr",
 "MPC_Exprs",
 "MPC_Initializer",
 "MPC_SimpleInit",
 "MPC_InitList",
};
static Tree_tKind yyTypeRange [97 + 1] = { 0,
 kMPC_InitList,
 kMPC_Root,
 kMPC_Source,
 kMPC_MessageI,
 kMPC_ErrorMessage,
 kMPC_ErrorMessageI,
 kMPC_Message,
 kMPC_MessageI,
 kMPC_FreeNode,
 kMPC_NetTypeSpecifier,
 kMPC_UncompString,
 kMPC_FunctionType,
 kMPC_BasicType,
 kMPC_EnumType,
 kMPC_Typedef,
 kMPC_FunctionType,
 kMPC_ArrayType,
 kMPC_VectorType,
 kMPC_PointerType,
 kMPC_StructType,
 kMPC_UnionType,
 kMPC_FunctionType,
 kMPC_VarDecl,
 kMPC_Function,
 kMPC_Ellipsis,
 kMPC_NetDecl,
 kMPC_SubnetDecl,
 kMPC_RelDecl,
 kMPC_NetTypeSpecifier,
 kMPC_NetType,
 kMPC_NetTypeSpecifier,
 kMPC_TopoFunctions,
 kMPC_EnumConst,
 kMPC_SU_MemberDecl,
 kMPC_SU_Member,
 kMPC_Var,
 kMPC_CoordDecl,
 kMPC_Node,
 kMPC_BenchQual,
 kMPC_NodeTypeQual,
 kMPC_BenchQual,
 kMPC_LinkDecl,
 kMPC_LinkDeclaringList,
 kMPC_LinkDeclarator,
 kMPC_LinkLengthSpecifier,
 kMPC_Scheme,
 kMPC_NetList,
 kMPC_Subnet,
 kMPC_Net,
 kMPC_Subnet,
 kMPC_Relation,
 kMPC_Default,
 kMPC_Fan,
 kMPC_ExprStat,
 kMPC_If,
 kMPC_IfElse,
 kMPC_Switch,
 kMPC_While,
 kMPC_DoWhile,
 kMPC_For,
 kMPC_Goto,
 kMPC_Continue,
 kMPC_Break,
 kMPC_BreakFan,
 kMPC_Return,
 kMPC_Compound,
 kMPC_CompScheme,
 kMPC_CommScheme,
 kMPC_ParScheme,
 kMPC_Fan,
 kMPC_Default,
 kMPC_IdentLabel,
 kMPC_CaseLabel,
 kMPC_Default,
 kMPC_CallExpr,
 kMPC_FloatConst,
 kMPC_IntConst,
 kMPC_UIntConst,
 kMPC_FloatConst,
 kMPC_StringLiteral,
 kMPC_Ident,
 kMPC_CastExpr,
 kMPC_NetCastExpr,
 kMPC_CoordExpr,
 kMPC_Size_Of_Type,
 kMPC_Size_Of_Value,
 kMPC_Size_Of_Type,
 kMPC_TimeofExpr,
 kMPC_UnaryExpr,
 kMPC_BinaryExpr,
 kMPC_TernaryExpr,
 kMPC_QuaternaryExpr,
 kMPC_CallExpr,
 kMPC_Exprs,
 kMPC_InitList,
 kMPC_SimpleInit,
 kMPC_InitList,
};

tTree Tree_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 97; i ++) {
   Tree_NodeSize [i] = (Tree_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Tree_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Tree_PoolFreePtr = yyBlockList->yyBlock;
 Tree_PoolMaxPtr = Tree_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Tree_HeapUsed += yyBlockSize;
 return (tTree) Tree_PoolFreePtr;
}

tTree MakeTree
# if defined __STDC__ | defined __cplusplus
 (Tree_tKind yyKind)
# else
 (yyKind) Tree_tKind yyKind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool Tree_IsType
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt, register Tree_tKind yyKind)
# else
 (yyt, yyKind) register tTree yyt; register Tree_tKind yyKind;
# endif
{
 return yyt != NoTree && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}

tTree nMPC_AstNode () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_AstNode])
 yyt->Kind = kMPC_AstNode;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree nMPC_Root () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Root])
 yyt->Kind = kMPC_Root;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->MPC_Root.Decls)
 begintTree(yyt->MPC_Root.Source)
 begintTree(yyt->MPC_Root.Messages)
 begintTree(yyt->MPC_Root.Host)
 begintTree(yyt->MPC_Root.SingleNode)
 begintTree(yyt->MPC_Root.ComputingSpace)
 begintTree(yyt->MPC_Root.Const)
 begintTree(yyt->MPC_Root.Recon)
 begintTree(yyt->MPC_Root.HostList)
 begintTree(yyt->MPC_Root.SingleNodeList)
 begintTree(yyt->MPC_Root.ComputingSpaceList)
 begintTree(yyt->MPC_Root.ConstList)
 begintTree(yyt->MPC_Root.ReconList)
 return yyt;
}

tTree nMPC_Source () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Source])
 yyt->Kind = kMPC_Source;
 yyt->yyHead.yyMark = 0;
 begintString(yyt->MPC_Source.FileName)
 begintPosition(yyt->MPC_Source.VirtPos)
 begintPosition(yyt->MPC_Source.RealPos)
 begintTree(yyt->MPC_Source.Next)
 begintTree(yyt->MPC_Source.Prev)
 return yyt;
}

tTree nMPC_Messages () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Messages])
 yyt->Kind = kMPC_Messages;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->MPC_Messages.ErrorClass)
 begintPosition(yyt->MPC_Messages.Pos)
 begintTree(yyt->MPC_Messages.Next)
 begintTree(yyt->MPC_Messages.Prev)
 begintTree(yyt->MPC_Messages.Tree)
 return yyt;
}

tTree nMPC_ErrorMessage () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ErrorMessage])
 yyt->Kind = kMPC_ErrorMessage;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->MPC_ErrorMessage.ErrorClass)
 begintPosition(yyt->MPC_ErrorMessage.Pos)
 begintTree(yyt->MPC_ErrorMessage.Next)
 begintTree(yyt->MPC_ErrorMessage.Prev)
 begintTree(yyt->MPC_ErrorMessage.Tree)
 beginint(yyt->MPC_ErrorMessage.ErrorCode)
 return yyt;
}

tTree nMPC_ErrorMessageI () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ErrorMessageI])
 yyt->Kind = kMPC_ErrorMessageI;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->MPC_ErrorMessageI.ErrorClass)
 begintPosition(yyt->MPC_ErrorMessageI.Pos)
 begintTree(yyt->MPC_ErrorMessageI.Next)
 begintTree(yyt->MPC_ErrorMessageI.Prev)
 begintTree(yyt->MPC_ErrorMessageI.Tree)
 beginint(yyt->MPC_ErrorMessageI.ErrorCode)
 beginint(yyt->MPC_ErrorMessageI.InfoClass)
 begintString(yyt->MPC_ErrorMessageI.Info)
 return yyt;
}

tTree nMPC_Message () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Message])
 yyt->Kind = kMPC_Message;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->MPC_Message.ErrorClass)
 begintPosition(yyt->MPC_Message.Pos)
 begintTree(yyt->MPC_Message.Next)
 begintTree(yyt->MPC_Message.Prev)
 begintTree(yyt->MPC_Message.Tree)
 beginshort(yyt->MPC_Message.MessageNumber)
 return yyt;
}

tTree nMPC_MessageI () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_MessageI])
 yyt->Kind = kMPC_MessageI;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->MPC_MessageI.ErrorClass)
 begintPosition(yyt->MPC_MessageI.Pos)
 begintTree(yyt->MPC_MessageI.Next)
 begintTree(yyt->MPC_MessageI.Prev)
 begintTree(yyt->MPC_MessageI.Tree)
 beginshort(yyt->MPC_MessageI.MessageNumber)
 beginint(yyt->MPC_MessageI.InfoClass)
 begintString(yyt->MPC_MessageI.Info)
 return yyt;
}

tTree nMPC_FreeNode () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FreeNode])
 yyt->Kind = kMPC_FreeNode;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->MPC_FreeNode.Parent)
 return yyt;
}

tTree nMPC_Decls () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Decls])
 yyt->Kind = kMPC_Decls;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Decls.Pos)
 begintTree(yyt->MPC_Decls.Next)
 begintTree(yyt->MPC_Decls.Prev)
 begintPosition(yyt->MPC_Decls.EndPos)
 return yyt;
}

tTree nMPC_UncompString () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UncompString])
 yyt->Kind = kMPC_UncompString;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_UncompString.Pos)
 begintTree(yyt->MPC_UncompString.Next)
 begintTree(yyt->MPC_UncompString.Prev)
 begintPosition(yyt->MPC_UncompString.EndPos)
 begintString(yyt->MPC_UncompString.uString)
 return yyt;
}

tTree nMPC_Type () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Type])
 yyt->Kind = kMPC_Type;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Type.Pos)
 begintTree(yyt->MPC_Type.Next)
 begintTree(yyt->MPC_Type.Prev)
 begintPosition(yyt->MPC_Type.EndPos)
 begintTypeFlags(yyt->MPC_Type.Flag)
 beginbool(yyt->MPC_Type.Buffer)
 beginMPC_unsigned_short(yyt->MPC_Type.UniqueNumber)
 begintTree(yyt->MPC_Type.EquivType)
 beginpVoid(yyt->MPC_Type.pType)
 return yyt;
}

tTree nMPC_BasicType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BasicType])
 yyt->Kind = kMPC_BasicType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_BasicType.Pos)
 begintTree(yyt->MPC_BasicType.Next)
 begintTree(yyt->MPC_BasicType.Prev)
 begintPosition(yyt->MPC_BasicType.EndPos)
 begintTypeFlags(yyt->MPC_BasicType.Flag)
 beginbool(yyt->MPC_BasicType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_BasicType.UniqueNumber)
 begintTree(yyt->MPC_BasicType.EquivType)
 beginpVoid(yyt->MPC_BasicType.pType)
 beginshort(yyt->MPC_BasicType.TypeConstructor)
 return yyt;
}

tTree nMPC_EnumType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_EnumType])
 yyt->Kind = kMPC_EnumType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_EnumType.Pos)
 begintTree(yyt->MPC_EnumType.Next)
 begintTree(yyt->MPC_EnumType.Prev)
 begintPosition(yyt->MPC_EnumType.EndPos)
 begintTypeFlags(yyt->MPC_EnumType.Flag)
 beginbool(yyt->MPC_EnumType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_EnumType.UniqueNumber)
 begintTree(yyt->MPC_EnumType.EquivType)
 beginpVoid(yyt->MPC_EnumType.pType)
 begintIdent(yyt->MPC_EnumType.EnumTag)
 begintTree(yyt->MPC_EnumType.EnumList)
 return yyt;
}

tTree nMPC_Typedef () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Typedef])
 yyt->Kind = kMPC_Typedef;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Typedef.Pos)
 begintTree(yyt->MPC_Typedef.Next)
 begintTree(yyt->MPC_Typedef.Prev)
 begintPosition(yyt->MPC_Typedef.EndPos)
 begintTypeFlags(yyt->MPC_Typedef.Flag)
 beginbool(yyt->MPC_Typedef.Buffer)
 beginMPC_unsigned_short(yyt->MPC_Typedef.UniqueNumber)
 begintTree(yyt->MPC_Typedef.EquivType)
 beginpVoid(yyt->MPC_Typedef.pType)
 begintIdent(yyt->MPC_Typedef.TypedefName)
 begintTree(yyt->MPC_Typedef.Type)
 return yyt;
}

tTree nMPC_DerivedType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_DerivedType])
 yyt->Kind = kMPC_DerivedType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_DerivedType.Pos)
 begintTree(yyt->MPC_DerivedType.Next)
 begintTree(yyt->MPC_DerivedType.Prev)
 begintPosition(yyt->MPC_DerivedType.EndPos)
 begintTypeFlags(yyt->MPC_DerivedType.Flag)
 beginbool(yyt->MPC_DerivedType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_DerivedType.UniqueNumber)
 begintTree(yyt->MPC_DerivedType.EquivType)
 beginpVoid(yyt->MPC_DerivedType.pType)
 beginint(yyt->MPC_DerivedType.NumberOfComponents)
 return yyt;
}

tTree nMPC_ArrayType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ArrayType])
 yyt->Kind = kMPC_ArrayType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_ArrayType.Pos)
 begintTree(yyt->MPC_ArrayType.Next)
 begintTree(yyt->MPC_ArrayType.Prev)
 begintPosition(yyt->MPC_ArrayType.EndPos)
 begintTypeFlags(yyt->MPC_ArrayType.Flag)
 beginbool(yyt->MPC_ArrayType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_ArrayType.UniqueNumber)
 begintTree(yyt->MPC_ArrayType.EquivType)
 beginpVoid(yyt->MPC_ArrayType.pType)
 beginint(yyt->MPC_ArrayType.NumberOfComponents)
 beginshort(yyt->MPC_ArrayType.Step)
 begintTree(yyt->MPC_ArrayType.ElementType)
 begintTree(yyt->MPC_ArrayType.ArraySize)
 begintTree(yyt->MPC_ArrayType.DynStep)
 return yyt;
}

tTree nMPC_VectorType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_VectorType])
 yyt->Kind = kMPC_VectorType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_VectorType.Pos)
 begintTree(yyt->MPC_VectorType.Next)
 begintTree(yyt->MPC_VectorType.Prev)
 begintPosition(yyt->MPC_VectorType.EndPos)
 begintTypeFlags(yyt->MPC_VectorType.Flag)
 beginbool(yyt->MPC_VectorType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_VectorType.UniqueNumber)
 begintTree(yyt->MPC_VectorType.EquivType)
 beginpVoid(yyt->MPC_VectorType.pType)
 beginint(yyt->MPC_VectorType.NumberOfComponents)
 begintTree(yyt->MPC_VectorType.ElementType)
 begintTree(yyt->MPC_VectorType.VectorSize)
 return yyt;
}

tTree nMPC_PointerType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_PointerType])
 yyt->Kind = kMPC_PointerType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_PointerType.Pos)
 begintTree(yyt->MPC_PointerType.Next)
 begintTree(yyt->MPC_PointerType.Prev)
 begintPosition(yyt->MPC_PointerType.EndPos)
 begintTypeFlags(yyt->MPC_PointerType.Flag)
 beginbool(yyt->MPC_PointerType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_PointerType.UniqueNumber)
 begintTree(yyt->MPC_PointerType.EquivType)
 beginpVoid(yyt->MPC_PointerType.pType)
 beginint(yyt->MPC_PointerType.NumberOfComponents)
 beginshort(yyt->MPC_PointerType.Step)
 begintTree(yyt->MPC_PointerType.ElementType)
 begintTree(yyt->MPC_PointerType.DynStep)
 begintTree(yyt->MPC_PointerType.GeneratedFrom)
 return yyt;
}

tTree nMPC_StructType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_StructType])
 yyt->Kind = kMPC_StructType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_StructType.Pos)
 begintTree(yyt->MPC_StructType.Next)
 begintTree(yyt->MPC_StructType.Prev)
 begintPosition(yyt->MPC_StructType.EndPos)
 begintTypeFlags(yyt->MPC_StructType.Flag)
 beginbool(yyt->MPC_StructType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_StructType.UniqueNumber)
 begintTree(yyt->MPC_StructType.EquivType)
 beginpVoid(yyt->MPC_StructType.pType)
 beginint(yyt->MPC_StructType.NumberOfComponents)
 begintIdent(yyt->MPC_StructType.SU_Tag)
 begintTree(yyt->MPC_StructType.MemberDecls)
 return yyt;
}

tTree nMPC_UnionType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UnionType])
 yyt->Kind = kMPC_UnionType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_UnionType.Pos)
 begintTree(yyt->MPC_UnionType.Next)
 begintTree(yyt->MPC_UnionType.Prev)
 begintPosition(yyt->MPC_UnionType.EndPos)
 begintTypeFlags(yyt->MPC_UnionType.Flag)
 beginbool(yyt->MPC_UnionType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_UnionType.UniqueNumber)
 begintTree(yyt->MPC_UnionType.EquivType)
 beginpVoid(yyt->MPC_UnionType.pType)
 beginint(yyt->MPC_UnionType.NumberOfComponents)
 begintIdent(yyt->MPC_UnionType.SU_Tag)
 begintTree(yyt->MPC_UnionType.MemberDecls)
 return yyt;
}

tTree nMPC_FunctionType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FunctionType])
 yyt->Kind = kMPC_FunctionType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_FunctionType.Pos)
 begintTree(yyt->MPC_FunctionType.Next)
 begintTree(yyt->MPC_FunctionType.Prev)
 begintPosition(yyt->MPC_FunctionType.EndPos)
 begintTypeFlags(yyt->MPC_FunctionType.Flag)
 beginbool(yyt->MPC_FunctionType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_FunctionType.UniqueNumber)
 begintTree(yyt->MPC_FunctionType.EquivType)
 beginpVoid(yyt->MPC_FunctionType.pType)
 beginint(yyt->MPC_FunctionType.NumberOfComponents)
 beginshort(yyt->MPC_FunctionType.Kind)
 begintTree(yyt->MPC_FunctionType.ResultType)
 begintTree(yyt->MPC_FunctionType.NetParamType)
 begintTree(yyt->MPC_FunctionType.NetParam)
 begintTree(yyt->MPC_FunctionType.NetworkParamList)
 begintTree(yyt->MPC_FunctionType.ParamList)
 return yyt;
}

tTree nMPC_VarDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_VarDecl])
 yyt->Kind = kMPC_VarDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_VarDecl.Pos)
 begintTree(yyt->MPC_VarDecl.Next)
 begintTree(yyt->MPC_VarDecl.Prev)
 begintPosition(yyt->MPC_VarDecl.EndPos)
 begintClass(yyt->MPC_VarDecl.Class)
 begintDeclFlags(yyt->MPC_VarDecl.Flag)
 begintTree(yyt->MPC_VarDecl.DeclSpecifier)
 begintTree(yyt->MPC_VarDecl.Var)
 return yyt;
}

tTree nMPC_Function () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Function])
 yyt->Kind = kMPC_Function;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Function.Pos)
 begintTree(yyt->MPC_Function.Next)
 begintTree(yyt->MPC_Function.Prev)
 begintPosition(yyt->MPC_Function.EndPos)
 beginshort(yyt->MPC_Function.Kind)
 begintDeclFlags(yyt->MPC_Function.Flag)
 begintTree(yyt->MPC_Function.Distribution)
 begintTree(yyt->MPC_Function.Name)
 begintTree(yyt->MPC_Function.Type)
 begintTree(yyt->MPC_Function.ParamList)
 begintTree(yyt->MPC_Function.Stats)
 begintTree(yyt->MPC_Function.LabelList)
 return yyt;
}

tTree nMPC_Ellipsis () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Ellipsis])
 yyt->Kind = kMPC_Ellipsis;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Ellipsis.Pos)
 begintTree(yyt->MPC_Ellipsis.Next)
 begintTree(yyt->MPC_Ellipsis.Prev)
 begintPosition(yyt->MPC_Ellipsis.EndPos)
 return yyt;
}

tTree nMPC_NetDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetDecl])
 yyt->Kind = kMPC_NetDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetDecl.Pos)
 begintTree(yyt->MPC_NetDecl.Next)
 begintTree(yyt->MPC_NetDecl.Prev)
 begintPosition(yyt->MPC_NetDecl.EndPos)
 begintClass(yyt->MPC_NetDecl.NetClass)
 begintDeclFlags(yyt->MPC_NetDecl.Flag)
 begintTree(yyt->MPC_NetDecl.NetTypeSpecifier)
 begintTree(yyt->MPC_NetDecl.Net)
 return yyt;
}

tTree nMPC_SubnetDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SubnetDecl])
 yyt->Kind = kMPC_SubnetDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_SubnetDecl.Pos)
 begintTree(yyt->MPC_SubnetDecl.Next)
 begintTree(yyt->MPC_SubnetDecl.Prev)
 begintPosition(yyt->MPC_SubnetDecl.EndPos)
 begintClass(yyt->MPC_SubnetDecl.SubnetClass)
 begintDeclFlags(yyt->MPC_SubnetDecl.Flag)
 begintTree(yyt->MPC_SubnetDecl.Subnet)
 return yyt;
}

tTree nMPC_RelDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_RelDecl])
 yyt->Kind = kMPC_RelDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_RelDecl.Pos)
 begintTree(yyt->MPC_RelDecl.Next)
 begintTree(yyt->MPC_RelDecl.Prev)
 begintPosition(yyt->MPC_RelDecl.EndPos)
 begintTree(yyt->MPC_RelDecl.Relation)
 return yyt;
}

tTree nMPC_NetTypeDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetTypeDecl])
 yyt->Kind = kMPC_NetTypeDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetTypeDecl.Pos)
 begintTree(yyt->MPC_NetTypeDecl.Next)
 begintTree(yyt->MPC_NetTypeDecl.Prev)
 begintPosition(yyt->MPC_NetTypeDecl.EndPos)
 begintIdent(yyt->MPC_NetTypeDecl.Ident)
 return yyt;
}

tTree nMPC_NetType () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetType])
 yyt->Kind = kMPC_NetType;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetType.Pos)
 begintTree(yyt->MPC_NetType.Next)
 begintTree(yyt->MPC_NetType.Prev)
 begintPosition(yyt->MPC_NetType.EndPos)
 begintIdent(yyt->MPC_NetType.Ident)
 begintClass(yyt->MPC_NetType.Class)
 begintTree(yyt->MPC_NetType.ParamList)
 begintTree(yyt->MPC_NetType.CoordDecl)
 begintTree(yyt->MPC_NetType.NodeDecl)
 begintTree(yyt->MPC_NetType.LinkDecl)
 begintTree(yyt->MPC_NetType.StartDecl)
 begintTree(yyt->MPC_NetType.SchemeDecl)
 beginbool(yyt->MPC_NetType.Bench)
 begintTree(yyt->MPC_NetType.TopoFunctions)
 return yyt;
}

tTree nMPC_NetTypeSpecifier () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetTypeSpecifier])
 yyt->Kind = kMPC_NetTypeSpecifier;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetTypeSpecifier.Pos)
 begintTree(yyt->MPC_NetTypeSpecifier.Next)
 begintTree(yyt->MPC_NetTypeSpecifier.Prev)
 begintPosition(yyt->MPC_NetTypeSpecifier.EndPos)
 begintIdent(yyt->MPC_NetTypeSpecifier.Ident)
 begintTree(yyt->MPC_NetTypeSpecifier.NetType)
 begintTree(yyt->MPC_NetTypeSpecifier.ArgList)
 return yyt;
}

tTree nMPC_TopoFunctions () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TopoFunctions])
 yyt->Kind = kMPC_TopoFunctions;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->MPC_TopoFunctions.Node_Def)
 begintTree(yyt->MPC_TopoFunctions.Link_Def)
 begintTree(yyt->MPC_TopoFunctions.Main_Node_Def)
 begintTree(yyt->MPC_TopoFunctions.Power_Def)
 begintTree(yyt->MPC_TopoFunctions.Node_Coord_Def)
 begintTree(yyt->MPC_TopoFunctions.Node_Number_Def)
 begintTree(yyt->MPC_TopoFunctions.Mapping_Def)
 return yyt;
}

tTree nMPC_EnumConst () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_EnumConst])
 yyt->Kind = kMPC_EnumConst;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_EnumConst.Pos)
 begintIdent(yyt->MPC_EnumConst.Name)
 beginbool(yyt->MPC_EnumConst.WithValue)
 beginint(yyt->MPC_EnumConst.Value)
 begintTree(yyt->MPC_EnumConst.Next)
 begintTree(yyt->MPC_EnumConst.Prev)
 begintPosition(yyt->MPC_EnumConst.EndPos)
 return yyt;
}

tTree nMPC_SU_MemberDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SU_MemberDecl])
 yyt->Kind = kMPC_SU_MemberDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_SU_MemberDecl.Pos)
 begintTree(yyt->MPC_SU_MemberDecl.Next)
 begintTree(yyt->MPC_SU_MemberDecl.Prev)
 begintTree(yyt->MPC_SU_MemberDecl.Member)
 begintPosition(yyt->MPC_SU_MemberDecl.EndPos)
 return yyt;
}

tTree nMPC_SU_Member () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SU_Member])
 yyt->Kind = kMPC_SU_Member;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_SU_Member.Pos)
 begintIdent(yyt->MPC_SU_Member.Name)
 beginshort(yyt->MPC_SU_Member.BitFieldLength)
 begintTree(yyt->MPC_SU_Member.Next)
 begintTree(yyt->MPC_SU_Member.Prev)
 begintTree(yyt->MPC_SU_Member.Type)
 begintTree(yyt->MPC_SU_Member.BitFieldSize)
 begintPosition(yyt->MPC_SU_Member.EndPos)
 beginMPC_unsigned_short(yyt->MPC_SU_Member.UniqueNumber)
 return yyt;
}

tTree nMPC_Var () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Var])
 yyt->Kind = kMPC_Var;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Var.Pos)
 begintIdent(yyt->MPC_Var.Ident)
 begintDeclFlags(yyt->MPC_Var.Flag)
 begintTree(yyt->MPC_Var.Next)
 begintTree(yyt->MPC_Var.Prev)
 begintTree(yyt->MPC_Var.Type)
 begintTree(yyt->MPC_Var.Distribution)
 begintTree(yyt->MPC_Var.Init)
 begintPosition(yyt->MPC_Var.EndPos)
 return yyt;
}

tTree nMPC_CoordDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CoordDecl])
 yyt->Kind = kMPC_CoordDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CoordDecl.Pos)
 begintIdent(yyt->MPC_CoordDecl.Ident)
 begintTree(yyt->MPC_CoordDecl.Next)
 begintTree(yyt->MPC_CoordDecl.Prev)
 begintTree(yyt->MPC_CoordDecl.Range)
 begintPosition(yyt->MPC_CoordDecl.EndPos)
 beginshort(yyt->MPC_CoordDecl.CoordNumber)
 return yyt;
}

tTree nMPC_Node () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Node])
 yyt->Kind = kMPC_Node;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Node.Pos)
 begintNodeType(yyt->MPC_Node.NodeType)
 beginbool(yyt->MPC_Node.DynamicType)
 begintTree(yyt->MPC_Node.Next)
 begintTree(yyt->MPC_Node.Prev)
 begintTree(yyt->MPC_Node.Predicate)
 begintTree(yyt->MPC_Node.NodeQual)
 begintPosition(yyt->MPC_Node.EndPos)
 return yyt;
}

tTree nMPC_NodeQual () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NodeQual])
 yyt->Kind = kMPC_NodeQual;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NodeQual.Pos)
 begintTree(yyt->MPC_NodeQual.CapacityExpr)
 begintPosition(yyt->MPC_NodeQual.EndPos)
 return yyt;
}

tTree nMPC_NodeTypeQual () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NodeTypeQual])
 yyt->Kind = kMPC_NodeTypeQual;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NodeTypeQual.Pos)
 begintTree(yyt->MPC_NodeTypeQual.CapacityExpr)
 begintPosition(yyt->MPC_NodeTypeQual.EndPos)
 beginbool(yyt->MPC_NodeTypeQual.Fast)
 beginint(yyt->MPC_NodeTypeQual.Capacity)
 return yyt;
}

tTree nMPC_BenchQual () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BenchQual])
 yyt->Kind = kMPC_BenchQual;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_BenchQual.Pos)
 begintTree(yyt->MPC_BenchQual.CapacityExpr)
 begintPosition(yyt->MPC_BenchQual.EndPos)
 begindouble(yyt->MPC_BenchQual.Capacity)
 return yyt;
}

tTree nMPC_LinkDecl () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDecl])
 yyt->Kind = kMPC_LinkDecl;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_LinkDecl.Pos)
 begintTree(yyt->MPC_LinkDecl.FreeCoord)
 begintTree(yyt->MPC_LinkDecl.LinkDeclaringList)
 begintPosition(yyt->MPC_LinkDecl.EndPos)
 return yyt;
}

tTree nMPC_LinkDeclaringList () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDeclaringList])
 yyt->Kind = kMPC_LinkDeclaringList;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_LinkDeclaringList.Pos)
 begintLinkType(yyt->MPC_LinkDeclaringList.LinkType)
 beginbool(yyt->MPC_LinkDeclaringList.DynamicLength)
 begintTree(yyt->MPC_LinkDeclaringList.Next)
 begintTree(yyt->MPC_LinkDeclaringList.Prev)
 begintTree(yyt->MPC_LinkDeclaringList.Predicate)
 begintTree(yyt->MPC_LinkDeclaringList.LinkLengthSpecifier)
 begintTree(yyt->MPC_LinkDeclaringList.LinkDeclarator)
 begintPosition(yyt->MPC_LinkDeclaringList.EndPos)
 return yyt;
}

tTree nMPC_LinkDeclarator () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDeclarator])
 yyt->Kind = kMPC_LinkDeclarator;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_LinkDeclarator.Pos)
 begintTree(yyt->MPC_LinkDeclarator.Next)
 begintTree(yyt->MPC_LinkDeclarator.Prev)
 begintTree(yyt->MPC_LinkDeclarator.LeftNode)
 begintTree(yyt->MPC_LinkDeclarator.RightNode)
 begintPosition(yyt->MPC_LinkDeclarator.EndPos)
 return yyt;
}

tTree nMPC_LinkLengthSpecifier () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkLengthSpecifier])
 yyt->Kind = kMPC_LinkLengthSpecifier;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_LinkLengthSpecifier.Pos)
 begintLinkType(yyt->MPC_LinkLengthSpecifier.LinkLength)
 begintTree(yyt->MPC_LinkLengthSpecifier.LinkLengthExpr)
 begintPosition(yyt->MPC_LinkLengthSpecifier.EndPos)
 return yyt;
}

tTree nMPC_Scheme () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Scheme])
 yyt->Kind = kMPC_Scheme;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Scheme.Pos)
 begintTree(yyt->MPC_Scheme.Body)
 begintPosition(yyt->MPC_Scheme.EndPos)
 return yyt;
}

tTree nMPC_NetList () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetList])
 yyt->Kind = kMPC_NetList;
 yyt->yyHead.yyMark = 0;
 begintTree(yyt->MPC_NetList.Next)
 begintTree(yyt->MPC_NetList.Prev)
 begintTree(yyt->MPC_NetList.Net)
 begintPosition(yyt->MPC_NetList.Pos)
 beginbool(yyt->MPC_NetList.UnReduceable)
 return yyt;
}

tTree nMPC_NetOrSubnet () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetOrSubnet])
 yyt->Kind = kMPC_NetOrSubnet;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetOrSubnet.Pos)
 begintIdent(yyt->MPC_NetOrSubnet.Ident)
 beginbool(yyt->MPC_NetOrSubnet.BigCreate)
 begintTree(yyt->MPC_NetOrSubnet.Distribution)
 begintTree(yyt->MPC_NetOrSubnet.Next)
 begintTree(yyt->MPC_NetOrSubnet.Prev)
 begintPosition(yyt->MPC_NetOrSubnet.EndPos)
 beginMPC_unsigned_short(yyt->MPC_NetOrSubnet.UniqueNumber)
 beginbool(yyt->MPC_NetOrSubnet.WithNumber)
 beginbool(yyt->MPC_NetOrSubnet.SingleNode)
 beginbool(yyt->MPC_NetOrSubnet.IsParent)
 beginpVoid(yyt->MPC_NetOrSubnet.pGen)
 begintTree(yyt->MPC_NetOrSubnet.NextUse)
 begintTree(yyt->MPC_NetOrSubnet.PrevUse)
 begintTree(yyt->MPC_NetOrSubnet.MyList)
 return yyt;
}

tTree nMPC_Net () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Net])
 yyt->Kind = kMPC_Net;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Net.Pos)
 begintIdent(yyt->MPC_Net.Ident)
 beginbool(yyt->MPC_Net.BigCreate)
 begintTree(yyt->MPC_Net.Distribution)
 begintTree(yyt->MPC_Net.Next)
 begintTree(yyt->MPC_Net.Prev)
 begintPosition(yyt->MPC_Net.EndPos)
 beginMPC_unsigned_short(yyt->MPC_Net.UniqueNumber)
 beginbool(yyt->MPC_Net.WithNumber)
 beginbool(yyt->MPC_Net.SingleNode)
 beginbool(yyt->MPC_Net.IsParent)
 beginpVoid(yyt->MPC_Net.pGen)
 begintTree(yyt->MPC_Net.NextUse)
 begintTree(yyt->MPC_Net.PrevUse)
 begintTree(yyt->MPC_Net.MyList)
 beginshort(yyt->MPC_Net.Topology)
 begintTree(yyt->MPC_Net.NetType)
 return yyt;
}

tTree nMPC_Subnet () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Subnet])
 yyt->Kind = kMPC_Subnet;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Subnet.Pos)
 begintIdent(yyt->MPC_Subnet.Ident)
 beginbool(yyt->MPC_Subnet.BigCreate)
 begintTree(yyt->MPC_Subnet.Distribution)
 begintTree(yyt->MPC_Subnet.Next)
 begintTree(yyt->MPC_Subnet.Prev)
 begintPosition(yyt->MPC_Subnet.EndPos)
 beginMPC_unsigned_short(yyt->MPC_Subnet.UniqueNumber)
 beginbool(yyt->MPC_Subnet.WithNumber)
 beginbool(yyt->MPC_Subnet.SingleNode)
 beginbool(yyt->MPC_Subnet.IsParent)
 beginpVoid(yyt->MPC_Subnet.pGen)
 begintTree(yyt->MPC_Subnet.NextUse)
 begintTree(yyt->MPC_Subnet.PrevUse)
 begintTree(yyt->MPC_Subnet.MyList)
 begintIdent(yyt->MPC_Subnet.NetOrSubnetName)
 beginbool(yyt->MPC_Subnet.Flexible)
 begintTree(yyt->MPC_Subnet.Predicate)
 return yyt;
}

tTree nMPC_Relation () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Relation])
 yyt->Kind = kMPC_Relation;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Relation.Pos)
 beginint(yyt->MPC_Relation.RelCode)
 begintTree(yyt->MPC_Relation.Next)
 begintTree(yyt->MPC_Relation.Prev)
 begintTree(yyt->MPC_Relation.LNet)
 begintTree(yyt->MPC_Relation.RNet)
 begintPosition(yyt->MPC_Relation.EndPos)
 return yyt;
}

tTree nMPC_Stats () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Stats])
 yyt->Kind = kMPC_Stats;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Stats.Pos)
 begintTree(yyt->MPC_Stats.Next)
 begintTree(yyt->MPC_Stats.Prev)
 begintPosition(yyt->MPC_Stats.EndPos)
 return yyt;
}

tTree nMPC_Stat () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Stat])
 yyt->Kind = kMPC_Stat;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Stat.Pos)
 begintTree(yyt->MPC_Stat.Next)
 begintTree(yyt->MPC_Stat.Prev)
 begintPosition(yyt->MPC_Stat.EndPos)
 begintStatFlags(yyt->MPC_Stat.Flag)
 begintTree(yyt->MPC_Stat.ExecNet)
 begintTree(yyt->MPC_Stat.ActualExecNet)
 begintTree(yyt->MPC_Stat.RootNet)
 begintTree(yyt->MPC_Stat.PropNet)
 beginbool(yyt->MPC_Stat.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Stat.UniqueNumber)
 return yyt;
}

tTree nMPC_ExprStat () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ExprStat])
 yyt->Kind = kMPC_ExprStat;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_ExprStat.Pos)
 begintTree(yyt->MPC_ExprStat.Next)
 begintTree(yyt->MPC_ExprStat.Prev)
 begintPosition(yyt->MPC_ExprStat.EndPos)
 begintStatFlags(yyt->MPC_ExprStat.Flag)
 begintTree(yyt->MPC_ExprStat.ExecNet)
 begintTree(yyt->MPC_ExprStat.ActualExecNet)
 begintTree(yyt->MPC_ExprStat.RootNet)
 begintTree(yyt->MPC_ExprStat.PropNet)
 beginbool(yyt->MPC_ExprStat.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_ExprStat.UniqueNumber)
 begintTree(yyt->MPC_ExprStat.Expr)
 return yyt;
}

tTree nMPC_If () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_If])
 yyt->Kind = kMPC_If;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_If.Pos)
 begintTree(yyt->MPC_If.Next)
 begintTree(yyt->MPC_If.Prev)
 begintPosition(yyt->MPC_If.EndPos)
 begintStatFlags(yyt->MPC_If.Flag)
 begintTree(yyt->MPC_If.ExecNet)
 begintTree(yyt->MPC_If.ActualExecNet)
 begintTree(yyt->MPC_If.RootNet)
 begintTree(yyt->MPC_If.PropNet)
 beginbool(yyt->MPC_If.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_If.UniqueNumber)
 begintTree(yyt->MPC_If.Expr)
 begintTree(yyt->MPC_If.Stats)
 return yyt;
}

tTree nMPC_IfElse () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IfElse])
 yyt->Kind = kMPC_IfElse;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_IfElse.Pos)
 begintTree(yyt->MPC_IfElse.Next)
 begintTree(yyt->MPC_IfElse.Prev)
 begintPosition(yyt->MPC_IfElse.EndPos)
 begintStatFlags(yyt->MPC_IfElse.Flag)
 begintTree(yyt->MPC_IfElse.ExecNet)
 begintTree(yyt->MPC_IfElse.ActualExecNet)
 begintTree(yyt->MPC_IfElse.RootNet)
 begintTree(yyt->MPC_IfElse.PropNet)
 beginbool(yyt->MPC_IfElse.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_IfElse.UniqueNumber)
 begintTree(yyt->MPC_IfElse.Expr)
 begintTree(yyt->MPC_IfElse.Then)
 begintTree(yyt->MPC_IfElse.Else)
 return yyt;
}

tTree nMPC_Switch () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Switch])
 yyt->Kind = kMPC_Switch;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Switch.Pos)
 begintTree(yyt->MPC_Switch.Next)
 begintTree(yyt->MPC_Switch.Prev)
 begintPosition(yyt->MPC_Switch.EndPos)
 begintStatFlags(yyt->MPC_Switch.Flag)
 begintTree(yyt->MPC_Switch.ExecNet)
 begintTree(yyt->MPC_Switch.ActualExecNet)
 begintTree(yyt->MPC_Switch.RootNet)
 begintTree(yyt->MPC_Switch.PropNet)
 beginbool(yyt->MPC_Switch.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Switch.UniqueNumber)
 begintTree(yyt->MPC_Switch.Expr)
 begintTree(yyt->MPC_Switch.Stats)
 return yyt;
}

tTree nMPC_While () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_While])
 yyt->Kind = kMPC_While;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_While.Pos)
 begintTree(yyt->MPC_While.Next)
 begintTree(yyt->MPC_While.Prev)
 begintPosition(yyt->MPC_While.EndPos)
 begintStatFlags(yyt->MPC_While.Flag)
 begintTree(yyt->MPC_While.ExecNet)
 begintTree(yyt->MPC_While.ActualExecNet)
 begintTree(yyt->MPC_While.RootNet)
 begintTree(yyt->MPC_While.PropNet)
 beginbool(yyt->MPC_While.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_While.UniqueNumber)
 begintTree(yyt->MPC_While.Expr)
 begintTree(yyt->MPC_While.Stats)
 return yyt;
}

tTree nMPC_DoWhile () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_DoWhile])
 yyt->Kind = kMPC_DoWhile;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_DoWhile.Pos)
 begintTree(yyt->MPC_DoWhile.Next)
 begintTree(yyt->MPC_DoWhile.Prev)
 begintPosition(yyt->MPC_DoWhile.EndPos)
 begintStatFlags(yyt->MPC_DoWhile.Flag)
 begintTree(yyt->MPC_DoWhile.ExecNet)
 begintTree(yyt->MPC_DoWhile.ActualExecNet)
 begintTree(yyt->MPC_DoWhile.RootNet)
 begintTree(yyt->MPC_DoWhile.PropNet)
 beginbool(yyt->MPC_DoWhile.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_DoWhile.UniqueNumber)
 begintTree(yyt->MPC_DoWhile.Stats)
 begintTree(yyt->MPC_DoWhile.Expr)
 return yyt;
}

tTree nMPC_For () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_For])
 yyt->Kind = kMPC_For;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_For.Pos)
 begintTree(yyt->MPC_For.Next)
 begintTree(yyt->MPC_For.Prev)
 begintPosition(yyt->MPC_For.EndPos)
 begintStatFlags(yyt->MPC_For.Flag)
 begintTree(yyt->MPC_For.ExecNet)
 begintTree(yyt->MPC_For.ActualExecNet)
 begintTree(yyt->MPC_For.RootNet)
 begintTree(yyt->MPC_For.PropNet)
 beginbool(yyt->MPC_For.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_For.UniqueNumber)
 begintTree(yyt->MPC_For.Init)
 begintTree(yyt->MPC_For.Cond)
 begintTree(yyt->MPC_For.Reinit)
 begintTree(yyt->MPC_For.Stats)
 return yyt;
}

tTree nMPC_Goto () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Goto])
 yyt->Kind = kMPC_Goto;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Goto.Pos)
 begintTree(yyt->MPC_Goto.Next)
 begintTree(yyt->MPC_Goto.Prev)
 begintPosition(yyt->MPC_Goto.EndPos)
 begintStatFlags(yyt->MPC_Goto.Flag)
 begintTree(yyt->MPC_Goto.ExecNet)
 begintTree(yyt->MPC_Goto.ActualExecNet)
 begintTree(yyt->MPC_Goto.RootNet)
 begintTree(yyt->MPC_Goto.PropNet)
 beginbool(yyt->MPC_Goto.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Goto.UniqueNumber)
 begintIdent(yyt->MPC_Goto.Ident)
 begintTree(yyt->MPC_Goto.LabelDef)
 begintTree(yyt->MPC_Goto.NextUse)
 begintTree(yyt->MPC_Goto.PrevUse)
 return yyt;
}

tTree nMPC_Continue () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Continue])
 yyt->Kind = kMPC_Continue;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Continue.Pos)
 begintTree(yyt->MPC_Continue.Next)
 begintTree(yyt->MPC_Continue.Prev)
 begintPosition(yyt->MPC_Continue.EndPos)
 begintStatFlags(yyt->MPC_Continue.Flag)
 begintTree(yyt->MPC_Continue.ExecNet)
 begintTree(yyt->MPC_Continue.ActualExecNet)
 begintTree(yyt->MPC_Continue.RootNet)
 begintTree(yyt->MPC_Continue.PropNet)
 beginbool(yyt->MPC_Continue.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Continue.UniqueNumber)
 return yyt;
}

tTree nMPC_Break () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Break])
 yyt->Kind = kMPC_Break;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Break.Pos)
 begintTree(yyt->MPC_Break.Next)
 begintTree(yyt->MPC_Break.Prev)
 begintPosition(yyt->MPC_Break.EndPos)
 begintStatFlags(yyt->MPC_Break.Flag)
 begintTree(yyt->MPC_Break.ExecNet)
 begintTree(yyt->MPC_Break.ActualExecNet)
 begintTree(yyt->MPC_Break.RootNet)
 begintTree(yyt->MPC_Break.PropNet)
 beginbool(yyt->MPC_Break.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Break.UniqueNumber)
 return yyt;
}

tTree nMPC_BreakFan () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BreakFan])
 yyt->Kind = kMPC_BreakFan;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_BreakFan.Pos)
 begintTree(yyt->MPC_BreakFan.Next)
 begintTree(yyt->MPC_BreakFan.Prev)
 begintPosition(yyt->MPC_BreakFan.EndPos)
 begintStatFlags(yyt->MPC_BreakFan.Flag)
 begintTree(yyt->MPC_BreakFan.ExecNet)
 begintTree(yyt->MPC_BreakFan.ActualExecNet)
 begintTree(yyt->MPC_BreakFan.RootNet)
 begintTree(yyt->MPC_BreakFan.PropNet)
 beginbool(yyt->MPC_BreakFan.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_BreakFan.UniqueNumber)
 return yyt;
}

tTree nMPC_Return () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Return])
 yyt->Kind = kMPC_Return;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Return.Pos)
 begintTree(yyt->MPC_Return.Next)
 begintTree(yyt->MPC_Return.Prev)
 begintPosition(yyt->MPC_Return.EndPos)
 begintStatFlags(yyt->MPC_Return.Flag)
 begintTree(yyt->MPC_Return.ExecNet)
 begintTree(yyt->MPC_Return.ActualExecNet)
 begintTree(yyt->MPC_Return.RootNet)
 begintTree(yyt->MPC_Return.PropNet)
 beginbool(yyt->MPC_Return.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Return.UniqueNumber)
 begintTree(yyt->MPC_Return.Expr)
 return yyt;
}

tTree nMPC_Compound () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Compound])
 yyt->Kind = kMPC_Compound;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Compound.Pos)
 begintTree(yyt->MPC_Compound.Next)
 begintTree(yyt->MPC_Compound.Prev)
 begintPosition(yyt->MPC_Compound.EndPos)
 begintStatFlags(yyt->MPC_Compound.Flag)
 begintTree(yyt->MPC_Compound.ExecNet)
 begintTree(yyt->MPC_Compound.ActualExecNet)
 begintTree(yyt->MPC_Compound.RootNet)
 begintTree(yyt->MPC_Compound.PropNet)
 beginbool(yyt->MPC_Compound.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Compound.UniqueNumber)
 beginint(yyt->MPC_Compound.FunctionBody)
 begintTree(yyt->MPC_Compound.Decls)
 begintTree(yyt->MPC_Compound.Stats)
 return yyt;
}

tTree nMPC_CompScheme () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CompScheme])
 yyt->Kind = kMPC_CompScheme;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CompScheme.Pos)
 begintTree(yyt->MPC_CompScheme.Next)
 begintTree(yyt->MPC_CompScheme.Prev)
 begintPosition(yyt->MPC_CompScheme.EndPos)
 begintStatFlags(yyt->MPC_CompScheme.Flag)
 begintTree(yyt->MPC_CompScheme.ExecNet)
 begintTree(yyt->MPC_CompScheme.ActualExecNet)
 begintTree(yyt->MPC_CompScheme.RootNet)
 begintTree(yyt->MPC_CompScheme.PropNet)
 beginbool(yyt->MPC_CompScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_CompScheme.UniqueNumber)
 begintTree(yyt->MPC_CompScheme.Expr)
 begintTree(yyt->MPC_CompScheme.Node)
 return yyt;
}

tTree nMPC_CommScheme () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CommScheme])
 yyt->Kind = kMPC_CommScheme;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CommScheme.Pos)
 begintTree(yyt->MPC_CommScheme.Next)
 begintTree(yyt->MPC_CommScheme.Prev)
 begintPosition(yyt->MPC_CommScheme.EndPos)
 begintStatFlags(yyt->MPC_CommScheme.Flag)
 begintTree(yyt->MPC_CommScheme.ExecNet)
 begintTree(yyt->MPC_CommScheme.ActualExecNet)
 begintTree(yyt->MPC_CommScheme.RootNet)
 begintTree(yyt->MPC_CommScheme.PropNet)
 beginbool(yyt->MPC_CommScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_CommScheme.UniqueNumber)
 begintTree(yyt->MPC_CommScheme.Expr)
 begintTree(yyt->MPC_CommScheme.From)
 begintTree(yyt->MPC_CommScheme.To)
 return yyt;
}

tTree nMPC_ParScheme () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ParScheme])
 yyt->Kind = kMPC_ParScheme;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_ParScheme.Pos)
 begintTree(yyt->MPC_ParScheme.Next)
 begintTree(yyt->MPC_ParScheme.Prev)
 begintPosition(yyt->MPC_ParScheme.EndPos)
 begintStatFlags(yyt->MPC_ParScheme.Flag)
 begintTree(yyt->MPC_ParScheme.ExecNet)
 begintTree(yyt->MPC_ParScheme.ActualExecNet)
 begintTree(yyt->MPC_ParScheme.RootNet)
 begintTree(yyt->MPC_ParScheme.PropNet)
 beginbool(yyt->MPC_ParScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_ParScheme.UniqueNumber)
 begintTree(yyt->MPC_ParScheme.Init)
 begintTree(yyt->MPC_ParScheme.Cond)
 begintTree(yyt->MPC_ParScheme.Reinit)
 begintTree(yyt->MPC_ParScheme.Stats)
 return yyt;
}

tTree nMPC_Fan () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Fan])
 yyt->Kind = kMPC_Fan;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Fan.Pos)
 begintTree(yyt->MPC_Fan.Next)
 begintTree(yyt->MPC_Fan.Prev)
 begintPosition(yyt->MPC_Fan.EndPos)
 begintStatFlags(yyt->MPC_Fan.Flag)
 begintTree(yyt->MPC_Fan.ExecNet)
 begintTree(yyt->MPC_Fan.ActualExecNet)
 begintTree(yyt->MPC_Fan.RootNet)
 begintTree(yyt->MPC_Fan.PropNet)
 beginbool(yyt->MPC_Fan.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Fan.UniqueNumber)
 begintTree(yyt->MPC_Fan.Body)
 return yyt;
}

tTree nMPC_Label () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Label])
 yyt->Kind = kMPC_Label;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Label.Pos)
 begintTree(yyt->MPC_Label.Next)
 begintTree(yyt->MPC_Label.Prev)
 begintPosition(yyt->MPC_Label.EndPos)
 begintTree(yyt->MPC_Label.NextLabel)
 begintTree(yyt->MPC_Label.PrevLabel)
 return yyt;
}

tTree nMPC_IdentLabel () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IdentLabel])
 yyt->Kind = kMPC_IdentLabel;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_IdentLabel.Pos)
 begintTree(yyt->MPC_IdentLabel.Next)
 begintTree(yyt->MPC_IdentLabel.Prev)
 begintPosition(yyt->MPC_IdentLabel.EndPos)
 begintTree(yyt->MPC_IdentLabel.NextLabel)
 begintTree(yyt->MPC_IdentLabel.PrevLabel)
 begintIdent(yyt->MPC_IdentLabel.Ident)
 begintTree(yyt->MPC_IdentLabel.NextUse)
 beginbool(yyt->MPC_IdentLabel.Used)
 return yyt;
}

tTree nMPC_CaseLabel () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CaseLabel])
 yyt->Kind = kMPC_CaseLabel;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CaseLabel.Pos)
 begintTree(yyt->MPC_CaseLabel.Next)
 begintTree(yyt->MPC_CaseLabel.Prev)
 begintPosition(yyt->MPC_CaseLabel.EndPos)
 begintTree(yyt->MPC_CaseLabel.NextLabel)
 begintTree(yyt->MPC_CaseLabel.PrevLabel)
 beginlong(yyt->MPC_CaseLabel.CaseValue)
 begintTree(yyt->MPC_CaseLabel.Expr)
 return yyt;
}

tTree nMPC_Default () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Default])
 yyt->Kind = kMPC_Default;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Default.Pos)
 begintTree(yyt->MPC_Default.Next)
 begintTree(yyt->MPC_Default.Prev)
 begintPosition(yyt->MPC_Default.EndPos)
 begintTree(yyt->MPC_Default.NextLabel)
 begintTree(yyt->MPC_Default.PrevLabel)
 return yyt;
}

tTree nMPC_Expr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Expr])
 yyt->Kind = kMPC_Expr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Expr.Pos)
 begintExprFlags(yyt->MPC_Expr.Flag)
 begintString(yyt->MPC_Expr.TmpName)
 begintTree(yyt->MPC_Expr.Type)
 begintTree(yyt->MPC_Expr.EvalNet)
 begintTree(yyt->MPC_Expr.StoreNet)
 begintPosition(yyt->MPC_Expr.BegPos)
 begintPosition(yyt->MPC_Expr.EndPos)
 begintTree(yyt->MPC_Expr.ActualEvalNet)
 beginchar(yyt->MPC_Expr.Pass)
 beginbool(yyt->MPC_Expr.Repl)
 begintOptm_Attribute(yyt->MPC_Expr.Optm_Attribute)
 return yyt;
}

tTree nMPC_Const () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Const])
 yyt->Kind = kMPC_Const;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Const.Pos)
 begintExprFlags(yyt->MPC_Const.Flag)
 begintString(yyt->MPC_Const.TmpName)
 begintTree(yyt->MPC_Const.Type)
 begintTree(yyt->MPC_Const.EvalNet)
 begintTree(yyt->MPC_Const.StoreNet)
 begintPosition(yyt->MPC_Const.BegPos)
 begintPosition(yyt->MPC_Const.EndPos)
 begintTree(yyt->MPC_Const.ActualEvalNet)
 beginchar(yyt->MPC_Const.Pass)
 beginbool(yyt->MPC_Const.Repl)
 begintOptm_Attribute(yyt->MPC_Const.Optm_Attribute)
 begintString(yyt->MPC_Const.SymbolicForm)
 return yyt;
}

tTree nMPC_IntConst () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IntConst])
 yyt->Kind = kMPC_IntConst;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_IntConst.Pos)
 begintExprFlags(yyt->MPC_IntConst.Flag)
 begintString(yyt->MPC_IntConst.TmpName)
 begintTree(yyt->MPC_IntConst.Type)
 begintTree(yyt->MPC_IntConst.EvalNet)
 begintTree(yyt->MPC_IntConst.StoreNet)
 begintPosition(yyt->MPC_IntConst.BegPos)
 begintPosition(yyt->MPC_IntConst.EndPos)
 begintTree(yyt->MPC_IntConst.ActualEvalNet)
 beginchar(yyt->MPC_IntConst.Pass)
 beginbool(yyt->MPC_IntConst.Repl)
 begintOptm_Attribute(yyt->MPC_IntConst.Optm_Attribute)
 begintString(yyt->MPC_IntConst.SymbolicForm)
 beginlong(yyt->MPC_IntConst.Value)
 return yyt;
}

tTree nMPC_UIntConst () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UIntConst])
 yyt->Kind = kMPC_UIntConst;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_UIntConst.Pos)
 begintExprFlags(yyt->MPC_UIntConst.Flag)
 begintString(yyt->MPC_UIntConst.TmpName)
 begintTree(yyt->MPC_UIntConst.Type)
 begintTree(yyt->MPC_UIntConst.EvalNet)
 begintTree(yyt->MPC_UIntConst.StoreNet)
 begintPosition(yyt->MPC_UIntConst.BegPos)
 begintPosition(yyt->MPC_UIntConst.EndPos)
 begintTree(yyt->MPC_UIntConst.ActualEvalNet)
 beginchar(yyt->MPC_UIntConst.Pass)
 beginbool(yyt->MPC_UIntConst.Repl)
 begintOptm_Attribute(yyt->MPC_UIntConst.Optm_Attribute)
 begintString(yyt->MPC_UIntConst.SymbolicForm)
 beginMPC_long_unsigned(yyt->MPC_UIntConst.Value)
 return yyt;
}

tTree nMPC_FloatConst () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FloatConst])
 yyt->Kind = kMPC_FloatConst;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_FloatConst.Pos)
 begintExprFlags(yyt->MPC_FloatConst.Flag)
 begintString(yyt->MPC_FloatConst.TmpName)
 begintTree(yyt->MPC_FloatConst.Type)
 begintTree(yyt->MPC_FloatConst.EvalNet)
 begintTree(yyt->MPC_FloatConst.StoreNet)
 begintPosition(yyt->MPC_FloatConst.BegPos)
 begintPosition(yyt->MPC_FloatConst.EndPos)
 begintTree(yyt->MPC_FloatConst.ActualEvalNet)
 beginchar(yyt->MPC_FloatConst.Pass)
 beginbool(yyt->MPC_FloatConst.Repl)
 begintOptm_Attribute(yyt->MPC_FloatConst.Optm_Attribute)
 begintString(yyt->MPC_FloatConst.SymbolicForm)
 beginMPC_long_double(yyt->MPC_FloatConst.Value)
 return yyt;
}

tTree nMPC_StringLiteral () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_StringLiteral])
 yyt->Kind = kMPC_StringLiteral;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_StringLiteral.Pos)
 begintExprFlags(yyt->MPC_StringLiteral.Flag)
 begintString(yyt->MPC_StringLiteral.TmpName)
 begintTree(yyt->MPC_StringLiteral.Type)
 begintTree(yyt->MPC_StringLiteral.EvalNet)
 begintTree(yyt->MPC_StringLiteral.StoreNet)
 begintPosition(yyt->MPC_StringLiteral.BegPos)
 begintPosition(yyt->MPC_StringLiteral.EndPos)
 begintTree(yyt->MPC_StringLiteral.ActualEvalNet)
 beginchar(yyt->MPC_StringLiteral.Pass)
 beginbool(yyt->MPC_StringLiteral.Repl)
 begintOptm_Attribute(yyt->MPC_StringLiteral.Optm_Attribute)
 begintString(yyt->MPC_StringLiteral.String)
 beginshort(yyt->MPC_StringLiteral.FullSize)
 begintTree(yyt->MPC_StringLiteral.Next)
 begintTree(yyt->MPC_StringLiteral.Prev)
 return yyt;
}

tTree nMPC_Ident () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Ident])
 yyt->Kind = kMPC_Ident;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Ident.Pos)
 begintExprFlags(yyt->MPC_Ident.Flag)
 begintString(yyt->MPC_Ident.TmpName)
 begintTree(yyt->MPC_Ident.Type)
 begintTree(yyt->MPC_Ident.EvalNet)
 begintTree(yyt->MPC_Ident.StoreNet)
 begintPosition(yyt->MPC_Ident.BegPos)
 begintPosition(yyt->MPC_Ident.EndPos)
 begintTree(yyt->MPC_Ident.ActualEvalNet)
 beginchar(yyt->MPC_Ident.Pass)
 beginbool(yyt->MPC_Ident.Repl)
 begintOptm_Attribute(yyt->MPC_Ident.Optm_Attribute)
 begintIdent(yyt->MPC_Ident.Ident)
 begintTree(yyt->MPC_Ident.Store)
 begintTree(yyt->MPC_Ident.NextUse)
 begintTree(yyt->MPC_Ident.PrevUse)
 return yyt;
}

tTree nMPC_CastExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CastExpr])
 yyt->Kind = kMPC_CastExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CastExpr.Pos)
 begintExprFlags(yyt->MPC_CastExpr.Flag)
 begintString(yyt->MPC_CastExpr.TmpName)
 begintTree(yyt->MPC_CastExpr.Type)
 begintTree(yyt->MPC_CastExpr.EvalNet)
 begintTree(yyt->MPC_CastExpr.StoreNet)
 begintPosition(yyt->MPC_CastExpr.BegPos)
 begintPosition(yyt->MPC_CastExpr.EndPos)
 begintTree(yyt->MPC_CastExpr.ActualEvalNet)
 beginchar(yyt->MPC_CastExpr.Pass)
 beginbool(yyt->MPC_CastExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CastExpr.Optm_Attribute)
 begintTree(yyt->MPC_CastExpr.TypeName)
 begintTree(yyt->MPC_CastExpr.Operand)
 return yyt;
}

tTree nMPC_NetCastExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetCastExpr])
 yyt->Kind = kMPC_NetCastExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_NetCastExpr.Pos)
 begintExprFlags(yyt->MPC_NetCastExpr.Flag)
 begintString(yyt->MPC_NetCastExpr.TmpName)
 begintTree(yyt->MPC_NetCastExpr.Type)
 begintTree(yyt->MPC_NetCastExpr.EvalNet)
 begintTree(yyt->MPC_NetCastExpr.StoreNet)
 begintPosition(yyt->MPC_NetCastExpr.BegPos)
 begintPosition(yyt->MPC_NetCastExpr.EndPos)
 begintTree(yyt->MPC_NetCastExpr.ActualEvalNet)
 beginchar(yyt->MPC_NetCastExpr.Pass)
 beginbool(yyt->MPC_NetCastExpr.Repl)
 begintOptm_Attribute(yyt->MPC_NetCastExpr.Optm_Attribute)
 beginbool(yyt->MPC_NetCastExpr.Flexible)
 begintTree(yyt->MPC_NetCastExpr.Operand)
 beginpVoid(yyt->MPC_NetCastExpr.ExprPtr)
 return yyt;
}

tTree nMPC_CoordExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CoordExpr])
 yyt->Kind = kMPC_CoordExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CoordExpr.Pos)
 begintExprFlags(yyt->MPC_CoordExpr.Flag)
 begintString(yyt->MPC_CoordExpr.TmpName)
 begintTree(yyt->MPC_CoordExpr.Type)
 begintTree(yyt->MPC_CoordExpr.EvalNet)
 begintTree(yyt->MPC_CoordExpr.StoreNet)
 begintPosition(yyt->MPC_CoordExpr.BegPos)
 begintPosition(yyt->MPC_CoordExpr.EndPos)
 begintTree(yyt->MPC_CoordExpr.ActualEvalNet)
 beginchar(yyt->MPC_CoordExpr.Pass)
 beginbool(yyt->MPC_CoordExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CoordExpr.Optm_Attribute)
 begintIdent(yyt->MPC_CoordExpr.CoordName)
 begintTree(yyt->MPC_CoordExpr.Operand)
 beginshort(yyt->MPC_CoordExpr.CoordNumber)
 return yyt;
}

tTree nMPC_SizeofExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SizeofExpr])
 yyt->Kind = kMPC_SizeofExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_SizeofExpr.Pos)
 begintExprFlags(yyt->MPC_SizeofExpr.Flag)
 begintString(yyt->MPC_SizeofExpr.TmpName)
 begintTree(yyt->MPC_SizeofExpr.Type)
 begintTree(yyt->MPC_SizeofExpr.EvalNet)
 begintTree(yyt->MPC_SizeofExpr.StoreNet)
 begintPosition(yyt->MPC_SizeofExpr.BegPos)
 begintPosition(yyt->MPC_SizeofExpr.EndPos)
 begintTree(yyt->MPC_SizeofExpr.ActualEvalNet)
 beginchar(yyt->MPC_SizeofExpr.Pass)
 beginbool(yyt->MPC_SizeofExpr.Repl)
 begintOptm_Attribute(yyt->MPC_SizeofExpr.Optm_Attribute)
 beginbool(yyt->MPC_SizeofExpr.CompileTime)
 beginint(yyt->MPC_SizeofExpr.Value)
 return yyt;
}

tTree nMPC_Size_Of_Value () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Size_Of_Value])
 yyt->Kind = kMPC_Size_Of_Value;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Size_Of_Value.Pos)
 begintExprFlags(yyt->MPC_Size_Of_Value.Flag)
 begintString(yyt->MPC_Size_Of_Value.TmpName)
 begintTree(yyt->MPC_Size_Of_Value.Type)
 begintTree(yyt->MPC_Size_Of_Value.EvalNet)
 begintTree(yyt->MPC_Size_Of_Value.StoreNet)
 begintPosition(yyt->MPC_Size_Of_Value.BegPos)
 begintPosition(yyt->MPC_Size_Of_Value.EndPos)
 begintTree(yyt->MPC_Size_Of_Value.ActualEvalNet)
 beginchar(yyt->MPC_Size_Of_Value.Pass)
 beginbool(yyt->MPC_Size_Of_Value.Repl)
 begintOptm_Attribute(yyt->MPC_Size_Of_Value.Optm_Attribute)
 beginbool(yyt->MPC_Size_Of_Value.CompileTime)
 beginint(yyt->MPC_Size_Of_Value.Value)
 begintTree(yyt->MPC_Size_Of_Value.Operand)
 return yyt;
}

tTree nMPC_Size_Of_Type () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Size_Of_Type])
 yyt->Kind = kMPC_Size_Of_Type;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Size_Of_Type.Pos)
 begintExprFlags(yyt->MPC_Size_Of_Type.Flag)
 begintString(yyt->MPC_Size_Of_Type.TmpName)
 begintTree(yyt->MPC_Size_Of_Type.Type)
 begintTree(yyt->MPC_Size_Of_Type.EvalNet)
 begintTree(yyt->MPC_Size_Of_Type.StoreNet)
 begintPosition(yyt->MPC_Size_Of_Type.BegPos)
 begintPosition(yyt->MPC_Size_Of_Type.EndPos)
 begintTree(yyt->MPC_Size_Of_Type.ActualEvalNet)
 beginchar(yyt->MPC_Size_Of_Type.Pass)
 beginbool(yyt->MPC_Size_Of_Type.Repl)
 begintOptm_Attribute(yyt->MPC_Size_Of_Type.Optm_Attribute)
 beginbool(yyt->MPC_Size_Of_Type.CompileTime)
 beginint(yyt->MPC_Size_Of_Type.Value)
 begintTree(yyt->MPC_Size_Of_Type.Operand)
 return yyt;
}

tTree nMPC_TimeofExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TimeofExpr])
 yyt->Kind = kMPC_TimeofExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_TimeofExpr.Pos)
 begintExprFlags(yyt->MPC_TimeofExpr.Flag)
 begintString(yyt->MPC_TimeofExpr.TmpName)
 begintTree(yyt->MPC_TimeofExpr.Type)
 begintTree(yyt->MPC_TimeofExpr.EvalNet)
 begintTree(yyt->MPC_TimeofExpr.StoreNet)
 begintPosition(yyt->MPC_TimeofExpr.BegPos)
 begintPosition(yyt->MPC_TimeofExpr.EndPos)
 begintTree(yyt->MPC_TimeofExpr.ActualEvalNet)
 beginchar(yyt->MPC_TimeofExpr.Pass)
 beginbool(yyt->MPC_TimeofExpr.Repl)
 begintOptm_Attribute(yyt->MPC_TimeofExpr.Optm_Attribute)
 begintTree(yyt->MPC_TimeofExpr.NetDecl)
 return yyt;
}

tTree nMPC_UnaryExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UnaryExpr])
 yyt->Kind = kMPC_UnaryExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_UnaryExpr.Pos)
 begintExprFlags(yyt->MPC_UnaryExpr.Flag)
 begintString(yyt->MPC_UnaryExpr.TmpName)
 begintTree(yyt->MPC_UnaryExpr.Type)
 begintTree(yyt->MPC_UnaryExpr.EvalNet)
 begintTree(yyt->MPC_UnaryExpr.StoreNet)
 begintPosition(yyt->MPC_UnaryExpr.BegPos)
 begintPosition(yyt->MPC_UnaryExpr.EndPos)
 begintTree(yyt->MPC_UnaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_UnaryExpr.Pass)
 beginbool(yyt->MPC_UnaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_UnaryExpr.Optm_Attribute)
 beginshort(yyt->MPC_UnaryExpr.OpCode)
 begintTree(yyt->MPC_UnaryExpr.Operand)
 return yyt;
}

tTree nMPC_BinaryExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BinaryExpr])
 yyt->Kind = kMPC_BinaryExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_BinaryExpr.Pos)
 begintExprFlags(yyt->MPC_BinaryExpr.Flag)
 begintString(yyt->MPC_BinaryExpr.TmpName)
 begintTree(yyt->MPC_BinaryExpr.Type)
 begintTree(yyt->MPC_BinaryExpr.EvalNet)
 begintTree(yyt->MPC_BinaryExpr.StoreNet)
 begintPosition(yyt->MPC_BinaryExpr.BegPos)
 begintPosition(yyt->MPC_BinaryExpr.EndPos)
 begintTree(yyt->MPC_BinaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_BinaryExpr.Pass)
 beginbool(yyt->MPC_BinaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_BinaryExpr.Optm_Attribute)
 beginshort(yyt->MPC_BinaryExpr.OpCode)
 begintTree(yyt->MPC_BinaryExpr.Loperand)
 begintTree(yyt->MPC_BinaryExpr.Roperand)
 return yyt;
}

tTree nMPC_TernaryExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TernaryExpr])
 yyt->Kind = kMPC_TernaryExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_TernaryExpr.Pos)
 begintExprFlags(yyt->MPC_TernaryExpr.Flag)
 begintString(yyt->MPC_TernaryExpr.TmpName)
 begintTree(yyt->MPC_TernaryExpr.Type)
 begintTree(yyt->MPC_TernaryExpr.EvalNet)
 begintTree(yyt->MPC_TernaryExpr.StoreNet)
 begintPosition(yyt->MPC_TernaryExpr.BegPos)
 begintPosition(yyt->MPC_TernaryExpr.EndPos)
 begintTree(yyt->MPC_TernaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_TernaryExpr.Pass)
 beginbool(yyt->MPC_TernaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_TernaryExpr.Optm_Attribute)
 beginshort(yyt->MPC_TernaryExpr.OpCode)
 begintTree(yyt->MPC_TernaryExpr.Foperand)
 begintTree(yyt->MPC_TernaryExpr.Soperand)
 begintTree(yyt->MPC_TernaryExpr.Toperand)
 return yyt;
}

tTree nMPC_QuaternaryExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_QuaternaryExpr])
 yyt->Kind = kMPC_QuaternaryExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_QuaternaryExpr.Pos)
 begintExprFlags(yyt->MPC_QuaternaryExpr.Flag)
 begintString(yyt->MPC_QuaternaryExpr.TmpName)
 begintTree(yyt->MPC_QuaternaryExpr.Type)
 begintTree(yyt->MPC_QuaternaryExpr.EvalNet)
 begintTree(yyt->MPC_QuaternaryExpr.StoreNet)
 begintPosition(yyt->MPC_QuaternaryExpr.BegPos)
 begintPosition(yyt->MPC_QuaternaryExpr.EndPos)
 begintTree(yyt->MPC_QuaternaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_QuaternaryExpr.Pass)
 beginbool(yyt->MPC_QuaternaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_QuaternaryExpr.Optm_Attribute)
 beginshort(yyt->MPC_QuaternaryExpr.OpCode)
 begintTree(yyt->MPC_QuaternaryExpr.Operand1)
 begintTree(yyt->MPC_QuaternaryExpr.Operand2)
 begintTree(yyt->MPC_QuaternaryExpr.Operand3)
 begintTree(yyt->MPC_QuaternaryExpr.Operand4)
 return yyt;
}

tTree nMPC_CallExpr () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CallExpr])
 yyt->Kind = kMPC_CallExpr;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_CallExpr.Pos)
 begintExprFlags(yyt->MPC_CallExpr.Flag)
 begintString(yyt->MPC_CallExpr.TmpName)
 begintTree(yyt->MPC_CallExpr.Type)
 begintTree(yyt->MPC_CallExpr.EvalNet)
 begintTree(yyt->MPC_CallExpr.StoreNet)
 begintPosition(yyt->MPC_CallExpr.BegPos)
 begintPosition(yyt->MPC_CallExpr.EndPos)
 begintTree(yyt->MPC_CallExpr.ActualEvalNet)
 beginchar(yyt->MPC_CallExpr.Pass)
 beginbool(yyt->MPC_CallExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CallExpr.Optm_Attribute)
 begintTree(yyt->MPC_CallExpr.Function)
 begintTree(yyt->MPC_CallExpr.ArgList)
 begintTree(yyt->MPC_CallExpr.NetworkArgList)
 return yyt;
}

tTree nMPC_Exprs () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Exprs])
 yyt->Kind = kMPC_Exprs;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Exprs.Pos)
 begintTree(yyt->MPC_Exprs.Next)
 begintTree(yyt->MPC_Exprs.Prev)
 begintTree(yyt->MPC_Exprs.Expr)
 begintPosition(yyt->MPC_Exprs.BegPos)
 begintPosition(yyt->MPC_Exprs.EndPos)
 return yyt;
}

tTree nMPC_Initializer () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Initializer])
 yyt->Kind = kMPC_Initializer;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_Initializer.Pos)
 begintTree(yyt->MPC_Initializer.Next)
 begintTree(yyt->MPC_Initializer.Prev)
 begintPosition(yyt->MPC_Initializer.EndPos)
 return yyt;
}

tTree nMPC_SimpleInit () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SimpleInit])
 yyt->Kind = kMPC_SimpleInit;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_SimpleInit.Pos)
 begintTree(yyt->MPC_SimpleInit.Next)
 begintTree(yyt->MPC_SimpleInit.Prev)
 begintPosition(yyt->MPC_SimpleInit.EndPos)
 begintTree(yyt->MPC_SimpleInit.Expr)
 return yyt;
}

tTree nMPC_InitList () {
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_InitList])
 yyt->Kind = kMPC_InitList;
 yyt->yyHead.yyMark = 0;
 begintPosition(yyt->MPC_InitList.Pos)
 begintTree(yyt->MPC_InitList.Next)
 begintTree(yyt->MPC_InitList.Prev)
 begintPosition(yyt->MPC_InitList.EndPos)
 beginint(yyt->MPC_InitList.Length)
 begintTree(yyt->MPC_InitList.List)
 return yyt;
}


tTree mMPC_AstNode
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_AstNode])
 yyt->Kind = kMPC_AstNode;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

tTree mMPC_Root
# if defined __STDC__ | defined __cplusplus
(tTree pDecls, tTree pSource, tTree pMessages, tTree pHost, tTree pSingleNode, tTree pComputingSpace, tTree pConst, tTree pRecon, tTree pHostList, tTree pSingleNodeList, tTree pComputingSpaceList, tTree pConstList, tTree pReconList)
# else
(pDecls, pSource, pMessages, pHost, pSingleNode, pComputingSpace, pConst, pRecon, pHostList, pSingleNodeList, pComputingSpaceList, pConstList, pReconList)
tTree pDecls;
tTree pSource;
tTree pMessages;
tTree pHost;
tTree pSingleNode;
tTree pComputingSpace;
tTree pConst;
tTree pRecon;
tTree pHostList;
tTree pSingleNodeList;
tTree pComputingSpaceList;
tTree pConstList;
tTree pReconList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Root])
 yyt->Kind = kMPC_Root;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Root.Decls = pDecls;
 yyt->MPC_Root.Source = pSource;
 yyt->MPC_Root.Messages = pMessages;
 yyt->MPC_Root.Host = pHost;
 yyt->MPC_Root.SingleNode = pSingleNode;
 yyt->MPC_Root.ComputingSpace = pComputingSpace;
 yyt->MPC_Root.Const = pConst;
 yyt->MPC_Root.Recon = pRecon;
 yyt->MPC_Root.HostList = pHostList;
 yyt->MPC_Root.SingleNodeList = pSingleNodeList;
 yyt->MPC_Root.ComputingSpaceList = pComputingSpaceList;
 yyt->MPC_Root.ConstList = pConstList;
 yyt->MPC_Root.ReconList = pReconList;
 return yyt;
}

tTree mMPC_Source
# if defined __STDC__ | defined __cplusplus
(tString pFileName, tPosition pVirtPos, tPosition pRealPos, tTree pNext, tTree pPrev)
# else
(pFileName, pVirtPos, pRealPos, pNext, pPrev)
tString pFileName;
tPosition pVirtPos;
tPosition pRealPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Source])
 yyt->Kind = kMPC_Source;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Source.FileName = pFileName;
 yyt->MPC_Source.VirtPos = pVirtPos;
 yyt->MPC_Source.RealPos = pRealPos;
 yyt->MPC_Source.Next = pNext;
 yyt->MPC_Source.Prev = pPrev;
 return yyt;
}

tTree mMPC_Messages
# if defined __STDC__ | defined __cplusplus
(int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev)
# else
(pErrorClass, pPos, pNext, pPrev)
int pErrorClass;
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Messages])
 yyt->Kind = kMPC_Messages;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Messages.ErrorClass = pErrorClass;
 yyt->MPC_Messages.Pos = pPos;
 yyt->MPC_Messages.Next = pNext;
 yyt->MPC_Messages.Prev = pPrev;
 begintTree(yyt->MPC_Messages.Tree)
 return yyt;
}

tTree mMPC_ErrorMessage
# if defined __STDC__ | defined __cplusplus
(int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, int pErrorCode)
# else
(pErrorClass, pPos, pNext, pPrev, pErrorCode)
int pErrorClass;
tPosition pPos;
tTree pNext;
tTree pPrev;
int pErrorCode;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ErrorMessage])
 yyt->Kind = kMPC_ErrorMessage;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_ErrorMessage.ErrorClass = pErrorClass;
 yyt->MPC_ErrorMessage.Pos = pPos;
 yyt->MPC_ErrorMessage.Next = pNext;
 yyt->MPC_ErrorMessage.Prev = pPrev;
 begintTree(yyt->MPC_ErrorMessage.Tree)
 yyt->MPC_ErrorMessage.ErrorCode = pErrorCode;
 return yyt;
}

tTree mMPC_ErrorMessageI
# if defined __STDC__ | defined __cplusplus
(int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, int pErrorCode, int pInfoClass, tString pInfo)
# else
(pErrorClass, pPos, pNext, pPrev, pErrorCode, pInfoClass, pInfo)
int pErrorClass;
tPosition pPos;
tTree pNext;
tTree pPrev;
int pErrorCode;
int pInfoClass;
tString pInfo;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ErrorMessageI])
 yyt->Kind = kMPC_ErrorMessageI;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_ErrorMessageI.ErrorClass = pErrorClass;
 yyt->MPC_ErrorMessageI.Pos = pPos;
 yyt->MPC_ErrorMessageI.Next = pNext;
 yyt->MPC_ErrorMessageI.Prev = pPrev;
 begintTree(yyt->MPC_ErrorMessageI.Tree)
 yyt->MPC_ErrorMessageI.ErrorCode = pErrorCode;
 yyt->MPC_ErrorMessageI.InfoClass = pInfoClass;
 yyt->MPC_ErrorMessageI.Info = pInfo;
 return yyt;
}

tTree mMPC_Message
# if defined __STDC__ | defined __cplusplus
(int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, short pMessageNumber)
# else
(pErrorClass, pPos, pNext, pPrev, pMessageNumber)
int pErrorClass;
tPosition pPos;
tTree pNext;
tTree pPrev;
short pMessageNumber;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Message])
 yyt->Kind = kMPC_Message;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Message.ErrorClass = pErrorClass;
 yyt->MPC_Message.Pos = pPos;
 yyt->MPC_Message.Next = pNext;
 yyt->MPC_Message.Prev = pPrev;
 begintTree(yyt->MPC_Message.Tree)
 yyt->MPC_Message.MessageNumber = pMessageNumber;
 return yyt;
}

tTree mMPC_MessageI
# if defined __STDC__ | defined __cplusplus
(int pErrorClass, tPosition pPos, tTree pNext, tTree pPrev, short pMessageNumber, int pInfoClass, tString pInfo)
# else
(pErrorClass, pPos, pNext, pPrev, pMessageNumber, pInfoClass, pInfo)
int pErrorClass;
tPosition pPos;
tTree pNext;
tTree pPrev;
short pMessageNumber;
int pInfoClass;
tString pInfo;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_MessageI])
 yyt->Kind = kMPC_MessageI;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_MessageI.ErrorClass = pErrorClass;
 yyt->MPC_MessageI.Pos = pPos;
 yyt->MPC_MessageI.Next = pNext;
 yyt->MPC_MessageI.Prev = pPrev;
 begintTree(yyt->MPC_MessageI.Tree)
 yyt->MPC_MessageI.MessageNumber = pMessageNumber;
 yyt->MPC_MessageI.InfoClass = pInfoClass;
 yyt->MPC_MessageI.Info = pInfo;
 return yyt;
}

tTree mMPC_FreeNode
# if defined __STDC__ | defined __cplusplus
(tTree pParent)
# else
(pParent)
tTree pParent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FreeNode])
 yyt->Kind = kMPC_FreeNode;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_FreeNode.Parent = pParent;
 return yyt;
}

tTree mMPC_Decls
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Decls])
 yyt->Kind = kMPC_Decls;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Decls.Pos = pPos;
 yyt->MPC_Decls.Next = pNext;
 yyt->MPC_Decls.Prev = pPrev;
 begintPosition(yyt->MPC_Decls.EndPos)
 return yyt;
}

tTree mMPC_UncompString
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tString puString)
# else
(pPos, pNext, pPrev, puString)
tPosition pPos;
tTree pNext;
tTree pPrev;
tString puString;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UncompString])
 yyt->Kind = kMPC_UncompString;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_UncompString.Pos = pPos;
 yyt->MPC_UncompString.Next = pNext;
 yyt->MPC_UncompString.Prev = pPrev;
 begintPosition(yyt->MPC_UncompString.EndPos)
 yyt->MPC_UncompString.uString = puString;
 return yyt;
}

tTree mMPC_Type
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag)
# else
(pPos, pNext, pPrev, pFlag)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Type])
 yyt->Kind = kMPC_Type;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Type.Pos = pPos;
 yyt->MPC_Type.Next = pNext;
 yyt->MPC_Type.Prev = pPrev;
 begintPosition(yyt->MPC_Type.EndPos)
 yyt->MPC_Type.Flag = pFlag;
 beginbool(yyt->MPC_Type.Buffer)
 beginMPC_unsigned_short(yyt->MPC_Type.UniqueNumber)
 begintTree(yyt->MPC_Type.EquivType)
 beginpVoid(yyt->MPC_Type.pType)
 return yyt;
}

tTree mMPC_BasicType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, short pTypeConstructor)
# else
(pPos, pNext, pPrev, pFlag, pTypeConstructor)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
short pTypeConstructor;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BasicType])
 yyt->Kind = kMPC_BasicType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_BasicType.Pos = pPos;
 yyt->MPC_BasicType.Next = pNext;
 yyt->MPC_BasicType.Prev = pPrev;
 begintPosition(yyt->MPC_BasicType.EndPos)
 yyt->MPC_BasicType.Flag = pFlag;
 beginbool(yyt->MPC_BasicType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_BasicType.UniqueNumber)
 begintTree(yyt->MPC_BasicType.EquivType)
 beginpVoid(yyt->MPC_BasicType.pType)
 yyt->MPC_BasicType.TypeConstructor = pTypeConstructor;
 return yyt;
}

tTree mMPC_EnumType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, tIdent pEnumTag, tTree pEnumList)
# else
(pPos, pNext, pPrev, pFlag, pEnumTag, pEnumList)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
tIdent pEnumTag;
tTree pEnumList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_EnumType])
 yyt->Kind = kMPC_EnumType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_EnumType.Pos = pPos;
 yyt->MPC_EnumType.Next = pNext;
 yyt->MPC_EnumType.Prev = pPrev;
 begintPosition(yyt->MPC_EnumType.EndPos)
 yyt->MPC_EnumType.Flag = pFlag;
 beginbool(yyt->MPC_EnumType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_EnumType.UniqueNumber)
 begintTree(yyt->MPC_EnumType.EquivType)
 beginpVoid(yyt->MPC_EnumType.pType)
 yyt->MPC_EnumType.EnumTag = pEnumTag;
 yyt->MPC_EnumType.EnumList = pEnumList;
 return yyt;
}

tTree mMPC_Typedef
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, tIdent pTypedefName, tTree pType)
# else
(pPos, pNext, pPrev, pFlag, pTypedefName, pType)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
tIdent pTypedefName;
tTree pType;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Typedef])
 yyt->Kind = kMPC_Typedef;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Typedef.Pos = pPos;
 yyt->MPC_Typedef.Next = pNext;
 yyt->MPC_Typedef.Prev = pPrev;
 begintPosition(yyt->MPC_Typedef.EndPos)
 yyt->MPC_Typedef.Flag = pFlag;
 beginbool(yyt->MPC_Typedef.Buffer)
 beginMPC_unsigned_short(yyt->MPC_Typedef.UniqueNumber)
 begintTree(yyt->MPC_Typedef.EquivType)
 beginpVoid(yyt->MPC_Typedef.pType)
 yyt->MPC_Typedef.TypedefName = pTypedefName;
 yyt->MPC_Typedef.Type = pType;
 return yyt;
}

tTree mMPC_DerivedType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_DerivedType])
 yyt->Kind = kMPC_DerivedType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_DerivedType.Pos = pPos;
 yyt->MPC_DerivedType.Next = pNext;
 yyt->MPC_DerivedType.Prev = pPrev;
 begintPosition(yyt->MPC_DerivedType.EndPos)
 yyt->MPC_DerivedType.Flag = pFlag;
 beginbool(yyt->MPC_DerivedType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_DerivedType.UniqueNumber)
 begintTree(yyt->MPC_DerivedType.EquivType)
 beginpVoid(yyt->MPC_DerivedType.pType)
 yyt->MPC_DerivedType.NumberOfComponents = pNumberOfComponents;
 return yyt;
}

tTree mMPC_ArrayType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pStep, tTree pElementType)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pStep, pElementType)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
short pStep;
tTree pElementType;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ArrayType])
 yyt->Kind = kMPC_ArrayType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_ArrayType.Pos = pPos;
 yyt->MPC_ArrayType.Next = pNext;
 yyt->MPC_ArrayType.Prev = pPrev;
 begintPosition(yyt->MPC_ArrayType.EndPos)
 yyt->MPC_ArrayType.Flag = pFlag;
 beginbool(yyt->MPC_ArrayType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_ArrayType.UniqueNumber)
 begintTree(yyt->MPC_ArrayType.EquivType)
 beginpVoid(yyt->MPC_ArrayType.pType)
 yyt->MPC_ArrayType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_ArrayType.Step = pStep;
 yyt->MPC_ArrayType.ElementType = pElementType;
 begintTree(yyt->MPC_ArrayType.ArraySize)
 begintTree(yyt->MPC_ArrayType.DynStep)
 return yyt;
}

tTree mMPC_VectorType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tTree pElementType)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pElementType)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
tTree pElementType;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_VectorType])
 yyt->Kind = kMPC_VectorType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_VectorType.Pos = pPos;
 yyt->MPC_VectorType.Next = pNext;
 yyt->MPC_VectorType.Prev = pPrev;
 begintPosition(yyt->MPC_VectorType.EndPos)
 yyt->MPC_VectorType.Flag = pFlag;
 beginbool(yyt->MPC_VectorType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_VectorType.UniqueNumber)
 begintTree(yyt->MPC_VectorType.EquivType)
 beginpVoid(yyt->MPC_VectorType.pType)
 yyt->MPC_VectorType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_VectorType.ElementType = pElementType;
 begintTree(yyt->MPC_VectorType.VectorSize)
 return yyt;
}

tTree mMPC_PointerType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pStep, tTree pElementType)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pStep, pElementType)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
short pStep;
tTree pElementType;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_PointerType])
 yyt->Kind = kMPC_PointerType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_PointerType.Pos = pPos;
 yyt->MPC_PointerType.Next = pNext;
 yyt->MPC_PointerType.Prev = pPrev;
 begintPosition(yyt->MPC_PointerType.EndPos)
 yyt->MPC_PointerType.Flag = pFlag;
 beginbool(yyt->MPC_PointerType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_PointerType.UniqueNumber)
 begintTree(yyt->MPC_PointerType.EquivType)
 beginpVoid(yyt->MPC_PointerType.pType)
 yyt->MPC_PointerType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_PointerType.Step = pStep;
 yyt->MPC_PointerType.ElementType = pElementType;
 begintTree(yyt->MPC_PointerType.DynStep)
 begintTree(yyt->MPC_PointerType.GeneratedFrom)
 return yyt;
}

tTree mMPC_StructType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tIdent pSU_Tag, tTree pMemberDecls)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pSU_Tag, pMemberDecls)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
tIdent pSU_Tag;
tTree pMemberDecls;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_StructType])
 yyt->Kind = kMPC_StructType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_StructType.Pos = pPos;
 yyt->MPC_StructType.Next = pNext;
 yyt->MPC_StructType.Prev = pPrev;
 begintPosition(yyt->MPC_StructType.EndPos)
 yyt->MPC_StructType.Flag = pFlag;
 beginbool(yyt->MPC_StructType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_StructType.UniqueNumber)
 begintTree(yyt->MPC_StructType.EquivType)
 beginpVoid(yyt->MPC_StructType.pType)
 yyt->MPC_StructType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_StructType.SU_Tag = pSU_Tag;
 yyt->MPC_StructType.MemberDecls = pMemberDecls;
 return yyt;
}

tTree mMPC_UnionType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, tIdent pSU_Tag, tTree pMemberDecls)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pSU_Tag, pMemberDecls)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
tIdent pSU_Tag;
tTree pMemberDecls;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UnionType])
 yyt->Kind = kMPC_UnionType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_UnionType.Pos = pPos;
 yyt->MPC_UnionType.Next = pNext;
 yyt->MPC_UnionType.Prev = pPrev;
 begintPosition(yyt->MPC_UnionType.EndPos)
 yyt->MPC_UnionType.Flag = pFlag;
 beginbool(yyt->MPC_UnionType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_UnionType.UniqueNumber)
 begintTree(yyt->MPC_UnionType.EquivType)
 beginpVoid(yyt->MPC_UnionType.pType)
 yyt->MPC_UnionType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_UnionType.SU_Tag = pSU_Tag;
 yyt->MPC_UnionType.MemberDecls = pMemberDecls;
 return yyt;
}

tTree mMPC_FunctionType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTypeFlags pFlag, int pNumberOfComponents, short pKind, tTree pResultType, tTree pNetParamType, tTree pNetParam, tTree pNetworkParamList, tTree pParamList)
# else
(pPos, pNext, pPrev, pFlag, pNumberOfComponents, pKind, pResultType, pNetParamType, pNetParam, pNetworkParamList, pParamList)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTypeFlags pFlag;
int pNumberOfComponents;
short pKind;
tTree pResultType;
tTree pNetParamType;
tTree pNetParam;
tTree pNetworkParamList;
tTree pParamList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FunctionType])
 yyt->Kind = kMPC_FunctionType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_FunctionType.Pos = pPos;
 yyt->MPC_FunctionType.Next = pNext;
 yyt->MPC_FunctionType.Prev = pPrev;
 begintPosition(yyt->MPC_FunctionType.EndPos)
 yyt->MPC_FunctionType.Flag = pFlag;
 beginbool(yyt->MPC_FunctionType.Buffer)
 beginMPC_unsigned_short(yyt->MPC_FunctionType.UniqueNumber)
 begintTree(yyt->MPC_FunctionType.EquivType)
 beginpVoid(yyt->MPC_FunctionType.pType)
 yyt->MPC_FunctionType.NumberOfComponents = pNumberOfComponents;
 yyt->MPC_FunctionType.Kind = pKind;
 yyt->MPC_FunctionType.ResultType = pResultType;
 yyt->MPC_FunctionType.NetParamType = pNetParamType;
 yyt->MPC_FunctionType.NetParam = pNetParam;
 yyt->MPC_FunctionType.NetworkParamList = pNetworkParamList;
 yyt->MPC_FunctionType.ParamList = pParamList;
 return yyt;
}

tTree mMPC_VarDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tClass pClass, tDeclFlags pFlag, tTree pDeclSpecifier, tTree pVar)
# else
(pPos, pNext, pPrev, pClass, pFlag, pDeclSpecifier, pVar)
tPosition pPos;
tTree pNext;
tTree pPrev;
tClass pClass;
tDeclFlags pFlag;
tTree pDeclSpecifier;
tTree pVar;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_VarDecl])
 yyt->Kind = kMPC_VarDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_VarDecl.Pos = pPos;
 yyt->MPC_VarDecl.Next = pNext;
 yyt->MPC_VarDecl.Prev = pPrev;
 begintPosition(yyt->MPC_VarDecl.EndPos)
 yyt->MPC_VarDecl.Class = pClass;
 yyt->MPC_VarDecl.Flag = pFlag;
 yyt->MPC_VarDecl.DeclSpecifier = pDeclSpecifier;
 yyt->MPC_VarDecl.Var = pVar;
 return yyt;
}

tTree mMPC_Function
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, short pKind, tDeclFlags pFlag, tTree pDistribution, tTree pName, tTree pType, tTree pParamList, tTree pStats)
# else
(pPos, pNext, pPrev, pKind, pFlag, pDistribution, pName, pType, pParamList, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
short pKind;
tDeclFlags pFlag;
tTree pDistribution;
tTree pName;
tTree pType;
tTree pParamList;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Function])
 yyt->Kind = kMPC_Function;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Function.Pos = pPos;
 yyt->MPC_Function.Next = pNext;
 yyt->MPC_Function.Prev = pPrev;
 begintPosition(yyt->MPC_Function.EndPos)
 yyt->MPC_Function.Kind = pKind;
 yyt->MPC_Function.Flag = pFlag;
 yyt->MPC_Function.Distribution = pDistribution;
 yyt->MPC_Function.Name = pName;
 yyt->MPC_Function.Type = pType;
 yyt->MPC_Function.ParamList = pParamList;
 yyt->MPC_Function.Stats = pStats;
 begintTree(yyt->MPC_Function.LabelList)
 return yyt;
}

tTree mMPC_Ellipsis
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Ellipsis])
 yyt->Kind = kMPC_Ellipsis;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Ellipsis.Pos = pPos;
 yyt->MPC_Ellipsis.Next = pNext;
 yyt->MPC_Ellipsis.Prev = pPrev;
 begintPosition(yyt->MPC_Ellipsis.EndPos)
 return yyt;
}

tTree mMPC_NetDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tClass pNetClass, tDeclFlags pFlag, tTree pNetTypeSpecifier, tTree pNet)
# else
(pPos, pNext, pPrev, pNetClass, pFlag, pNetTypeSpecifier, pNet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tClass pNetClass;
tDeclFlags pFlag;
tTree pNetTypeSpecifier;
tTree pNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetDecl])
 yyt->Kind = kMPC_NetDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetDecl.Pos = pPos;
 yyt->MPC_NetDecl.Next = pNext;
 yyt->MPC_NetDecl.Prev = pPrev;
 begintPosition(yyt->MPC_NetDecl.EndPos)
 yyt->MPC_NetDecl.NetClass = pNetClass;
 yyt->MPC_NetDecl.Flag = pFlag;
 yyt->MPC_NetDecl.NetTypeSpecifier = pNetTypeSpecifier;
 yyt->MPC_NetDecl.Net = pNet;
 return yyt;
}

tTree mMPC_SubnetDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tClass pSubnetClass, tDeclFlags pFlag, tTree pSubnet)
# else
(pPos, pNext, pPrev, pSubnetClass, pFlag, pSubnet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tClass pSubnetClass;
tDeclFlags pFlag;
tTree pSubnet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SubnetDecl])
 yyt->Kind = kMPC_SubnetDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_SubnetDecl.Pos = pPos;
 yyt->MPC_SubnetDecl.Next = pNext;
 yyt->MPC_SubnetDecl.Prev = pPrev;
 begintPosition(yyt->MPC_SubnetDecl.EndPos)
 yyt->MPC_SubnetDecl.SubnetClass = pSubnetClass;
 yyt->MPC_SubnetDecl.Flag = pFlag;
 yyt->MPC_SubnetDecl.Subnet = pSubnet;
 return yyt;
}

tTree mMPC_RelDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTree pRelation)
# else
(pPos, pNext, pPrev, pRelation)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTree pRelation;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_RelDecl])
 yyt->Kind = kMPC_RelDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_RelDecl.Pos = pPos;
 yyt->MPC_RelDecl.Next = pNext;
 yyt->MPC_RelDecl.Prev = pPrev;
 begintPosition(yyt->MPC_RelDecl.EndPos)
 yyt->MPC_RelDecl.Relation = pRelation;
 return yyt;
}

tTree mMPC_NetTypeDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent)
# else
(pPos, pNext, pPrev, pIdent)
tPosition pPos;
tTree pNext;
tTree pPrev;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetTypeDecl])
 yyt->Kind = kMPC_NetTypeDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetTypeDecl.Pos = pPos;
 yyt->MPC_NetTypeDecl.Next = pNext;
 yyt->MPC_NetTypeDecl.Prev = pPrev;
 begintPosition(yyt->MPC_NetTypeDecl.EndPos)
 yyt->MPC_NetTypeDecl.Ident = pIdent;
 return yyt;
}

tTree mMPC_NetType
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent, tClass pClass, tTree pParamList, tTree pCoordDecl, tTree pNodeDecl, tTree pLinkDecl, tTree pStartDecl, tTree pSchemeDecl)
# else
(pPos, pNext, pPrev, pIdent, pClass, pParamList, pCoordDecl, pNodeDecl, pLinkDecl, pStartDecl, pSchemeDecl)
tPosition pPos;
tTree pNext;
tTree pPrev;
tIdent pIdent;
tClass pClass;
tTree pParamList;
tTree pCoordDecl;
tTree pNodeDecl;
tTree pLinkDecl;
tTree pStartDecl;
tTree pSchemeDecl;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetType])
 yyt->Kind = kMPC_NetType;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetType.Pos = pPos;
 yyt->MPC_NetType.Next = pNext;
 yyt->MPC_NetType.Prev = pPrev;
 begintPosition(yyt->MPC_NetType.EndPos)
 yyt->MPC_NetType.Ident = pIdent;
 yyt->MPC_NetType.Class = pClass;
 yyt->MPC_NetType.ParamList = pParamList;
 yyt->MPC_NetType.CoordDecl = pCoordDecl;
 yyt->MPC_NetType.NodeDecl = pNodeDecl;
 yyt->MPC_NetType.LinkDecl = pLinkDecl;
 yyt->MPC_NetType.StartDecl = pStartDecl;
 yyt->MPC_NetType.SchemeDecl = pSchemeDecl;
 beginbool(yyt->MPC_NetType.Bench)
 begintTree(yyt->MPC_NetType.TopoFunctions)
 return yyt;
}

tTree mMPC_NetTypeSpecifier
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent, tTree pNetType, tTree pArgList)
# else
(pPos, pNext, pPrev, pIdent, pNetType, pArgList)
tPosition pPos;
tTree pNext;
tTree pPrev;
tIdent pIdent;
tTree pNetType;
tTree pArgList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetTypeSpecifier])
 yyt->Kind = kMPC_NetTypeSpecifier;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetTypeSpecifier.Pos = pPos;
 yyt->MPC_NetTypeSpecifier.Next = pNext;
 yyt->MPC_NetTypeSpecifier.Prev = pPrev;
 begintPosition(yyt->MPC_NetTypeSpecifier.EndPos)
 yyt->MPC_NetTypeSpecifier.Ident = pIdent;
 yyt->MPC_NetTypeSpecifier.NetType = pNetType;
 yyt->MPC_NetTypeSpecifier.ArgList = pArgList;
 return yyt;
}

tTree mMPC_TopoFunctions
# if defined __STDC__ | defined __cplusplus
(tTree pNode_Def, tTree pLink_Def, tTree pMain_Node_Def, tTree pPower_Def, tTree pNode_Coord_Def, tTree pNode_Number_Def, tTree pMapping_Def)
# else
(pNode_Def, pLink_Def, pMain_Node_Def, pPower_Def, pNode_Coord_Def, pNode_Number_Def, pMapping_Def)
tTree pNode_Def;
tTree pLink_Def;
tTree pMain_Node_Def;
tTree pPower_Def;
tTree pNode_Coord_Def;
tTree pNode_Number_Def;
tTree pMapping_Def;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TopoFunctions])
 yyt->Kind = kMPC_TopoFunctions;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_TopoFunctions.Node_Def = pNode_Def;
 yyt->MPC_TopoFunctions.Link_Def = pLink_Def;
 yyt->MPC_TopoFunctions.Main_Node_Def = pMain_Node_Def;
 yyt->MPC_TopoFunctions.Power_Def = pPower_Def;
 yyt->MPC_TopoFunctions.Node_Coord_Def = pNode_Coord_Def;
 yyt->MPC_TopoFunctions.Node_Number_Def = pNode_Number_Def;
 yyt->MPC_TopoFunctions.Mapping_Def = pMapping_Def;
 return yyt;
}

tTree mMPC_EnumConst
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pName, bool pWithValue, int pValue, tTree pNext, tTree pPrev)
# else
(pPos, pName, pWithValue, pValue, pNext, pPrev)
tPosition pPos;
tIdent pName;
bool pWithValue;
int pValue;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_EnumConst])
 yyt->Kind = kMPC_EnumConst;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_EnumConst.Pos = pPos;
 yyt->MPC_EnumConst.Name = pName;
 yyt->MPC_EnumConst.WithValue = pWithValue;
 yyt->MPC_EnumConst.Value = pValue;
 yyt->MPC_EnumConst.Next = pNext;
 yyt->MPC_EnumConst.Prev = pPrev;
 begintPosition(yyt->MPC_EnumConst.EndPos)
 return yyt;
}

tTree mMPC_SU_MemberDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTree pMember)
# else
(pPos, pNext, pPrev, pMember)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTree pMember;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SU_MemberDecl])
 yyt->Kind = kMPC_SU_MemberDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_SU_MemberDecl.Pos = pPos;
 yyt->MPC_SU_MemberDecl.Next = pNext;
 yyt->MPC_SU_MemberDecl.Prev = pPrev;
 yyt->MPC_SU_MemberDecl.Member = pMember;
 begintPosition(yyt->MPC_SU_MemberDecl.EndPos)
 return yyt;
}

tTree mMPC_SU_Member
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pName, short pBitFieldLength, tTree pNext, tTree pPrev, tTree pType, tTree pBitFieldSize)
# else
(pPos, pName, pBitFieldLength, pNext, pPrev, pType, pBitFieldSize)
tPosition pPos;
tIdent pName;
short pBitFieldLength;
tTree pNext;
tTree pPrev;
tTree pType;
tTree pBitFieldSize;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SU_Member])
 yyt->Kind = kMPC_SU_Member;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_SU_Member.Pos = pPos;
 yyt->MPC_SU_Member.Name = pName;
 yyt->MPC_SU_Member.BitFieldLength = pBitFieldLength;
 yyt->MPC_SU_Member.Next = pNext;
 yyt->MPC_SU_Member.Prev = pPrev;
 yyt->MPC_SU_Member.Type = pType;
 yyt->MPC_SU_Member.BitFieldSize = pBitFieldSize;
 begintPosition(yyt->MPC_SU_Member.EndPos)
 beginMPC_unsigned_short(yyt->MPC_SU_Member.UniqueNumber)
 return yyt;
}

tTree mMPC_Var
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pIdent, tDeclFlags pFlag, tTree pNext, tTree pPrev, tTree pType, tTree pDistribution, tTree pInit)
# else
(pPos, pIdent, pFlag, pNext, pPrev, pType, pDistribution, pInit)
tPosition pPos;
tIdent pIdent;
tDeclFlags pFlag;
tTree pNext;
tTree pPrev;
tTree pType;
tTree pDistribution;
tTree pInit;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Var])
 yyt->Kind = kMPC_Var;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Var.Pos = pPos;
 yyt->MPC_Var.Ident = pIdent;
 yyt->MPC_Var.Flag = pFlag;
 yyt->MPC_Var.Next = pNext;
 yyt->MPC_Var.Prev = pPrev;
 yyt->MPC_Var.Type = pType;
 yyt->MPC_Var.Distribution = pDistribution;
 yyt->MPC_Var.Init = pInit;
 begintPosition(yyt->MPC_Var.EndPos)
 return yyt;
}

tTree mMPC_CoordDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pIdent, tTree pNext, tTree pPrev, tTree pRange)
# else
(pPos, pIdent, pNext, pPrev, pRange)
tPosition pPos;
tIdent pIdent;
tTree pNext;
tTree pPrev;
tTree pRange;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CoordDecl])
 yyt->Kind = kMPC_CoordDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CoordDecl.Pos = pPos;
 yyt->MPC_CoordDecl.Ident = pIdent;
 yyt->MPC_CoordDecl.Next = pNext;
 yyt->MPC_CoordDecl.Prev = pPrev;
 yyt->MPC_CoordDecl.Range = pRange;
 begintPosition(yyt->MPC_CoordDecl.EndPos)
 beginshort(yyt->MPC_CoordDecl.CoordNumber)
 return yyt;
}

tTree mMPC_Node
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tNodeType pNodeType, bool pDynamicType, tTree pNext, tTree pPrev, tTree pPredicate, tTree pNodeQual)
# else
(pPos, pNodeType, pDynamicType, pNext, pPrev, pPredicate, pNodeQual)
tPosition pPos;
tNodeType pNodeType;
bool pDynamicType;
tTree pNext;
tTree pPrev;
tTree pPredicate;
tTree pNodeQual;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Node])
 yyt->Kind = kMPC_Node;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Node.Pos = pPos;
 yyt->MPC_Node.NodeType = pNodeType;
 yyt->MPC_Node.DynamicType = pDynamicType;
 yyt->MPC_Node.Next = pNext;
 yyt->MPC_Node.Prev = pPrev;
 yyt->MPC_Node.Predicate = pPredicate;
 yyt->MPC_Node.NodeQual = pNodeQual;
 begintPosition(yyt->MPC_Node.EndPos)
 return yyt;
}

tTree mMPC_NodeQual
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pCapacityExpr)
# else
(pPos, pCapacityExpr)
tPosition pPos;
tTree pCapacityExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NodeQual])
 yyt->Kind = kMPC_NodeQual;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NodeQual.Pos = pPos;
 yyt->MPC_NodeQual.CapacityExpr = pCapacityExpr;
 begintPosition(yyt->MPC_NodeQual.EndPos)
 return yyt;
}

tTree mMPC_NodeTypeQual
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pCapacityExpr, bool pFast, int pCapacity)
# else
(pPos, pCapacityExpr, pFast, pCapacity)
tPosition pPos;
tTree pCapacityExpr;
bool pFast;
int pCapacity;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NodeTypeQual])
 yyt->Kind = kMPC_NodeTypeQual;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NodeTypeQual.Pos = pPos;
 yyt->MPC_NodeTypeQual.CapacityExpr = pCapacityExpr;
 begintPosition(yyt->MPC_NodeTypeQual.EndPos)
 yyt->MPC_NodeTypeQual.Fast = pFast;
 yyt->MPC_NodeTypeQual.Capacity = pCapacity;
 return yyt;
}

tTree mMPC_BenchQual
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pCapacityExpr, double pCapacity)
# else
(pPos, pCapacityExpr, pCapacity)
tPosition pPos;
tTree pCapacityExpr;
double pCapacity;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BenchQual])
 yyt->Kind = kMPC_BenchQual;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_BenchQual.Pos = pPos;
 yyt->MPC_BenchQual.CapacityExpr = pCapacityExpr;
 begintPosition(yyt->MPC_BenchQual.EndPos)
 yyt->MPC_BenchQual.Capacity = pCapacity;
 return yyt;
}

tTree mMPC_LinkDecl
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pFreeCoord, tTree pLinkDeclaringList)
# else
(pPos, pFreeCoord, pLinkDeclaringList)
tPosition pPos;
tTree pFreeCoord;
tTree pLinkDeclaringList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDecl])
 yyt->Kind = kMPC_LinkDecl;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_LinkDecl.Pos = pPos;
 yyt->MPC_LinkDecl.FreeCoord = pFreeCoord;
 yyt->MPC_LinkDecl.LinkDeclaringList = pLinkDeclaringList;
 begintPosition(yyt->MPC_LinkDecl.EndPos)
 return yyt;
}

tTree mMPC_LinkDeclaringList
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tLinkType pLinkType, bool pDynamicLength, tTree pNext, tTree pPrev, tTree pPredicate, tTree pLinkLengthSpecifier, tTree pLinkDeclarator)
# else
(pPos, pLinkType, pDynamicLength, pNext, pPrev, pPredicate, pLinkLengthSpecifier, pLinkDeclarator)
tPosition pPos;
tLinkType pLinkType;
bool pDynamicLength;
tTree pNext;
tTree pPrev;
tTree pPredicate;
tTree pLinkLengthSpecifier;
tTree pLinkDeclarator;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDeclaringList])
 yyt->Kind = kMPC_LinkDeclaringList;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_LinkDeclaringList.Pos = pPos;
 yyt->MPC_LinkDeclaringList.LinkType = pLinkType;
 yyt->MPC_LinkDeclaringList.DynamicLength = pDynamicLength;
 yyt->MPC_LinkDeclaringList.Next = pNext;
 yyt->MPC_LinkDeclaringList.Prev = pPrev;
 yyt->MPC_LinkDeclaringList.Predicate = pPredicate;
 yyt->MPC_LinkDeclaringList.LinkLengthSpecifier = pLinkLengthSpecifier;
 yyt->MPC_LinkDeclaringList.LinkDeclarator = pLinkDeclarator;
 begintPosition(yyt->MPC_LinkDeclaringList.EndPos)
 return yyt;
}

tTree mMPC_LinkDeclarator
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTree pLeftNode, tTree pRightNode)
# else
(pPos, pNext, pPrev, pLeftNode, pRightNode)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTree pLeftNode;
tTree pRightNode;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkDeclarator])
 yyt->Kind = kMPC_LinkDeclarator;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_LinkDeclarator.Pos = pPos;
 yyt->MPC_LinkDeclarator.Next = pNext;
 yyt->MPC_LinkDeclarator.Prev = pPrev;
 yyt->MPC_LinkDeclarator.LeftNode = pLeftNode;
 yyt->MPC_LinkDeclarator.RightNode = pRightNode;
 begintPosition(yyt->MPC_LinkDeclarator.EndPos)
 return yyt;
}

tTree mMPC_LinkLengthSpecifier
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tLinkType pLinkLength, tTree pLinkLengthExpr)
# else
(pPos, pLinkLength, pLinkLengthExpr)
tPosition pPos;
tLinkType pLinkLength;
tTree pLinkLengthExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_LinkLengthSpecifier])
 yyt->Kind = kMPC_LinkLengthSpecifier;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_LinkLengthSpecifier.Pos = pPos;
 yyt->MPC_LinkLengthSpecifier.LinkLength = pLinkLength;
 yyt->MPC_LinkLengthSpecifier.LinkLengthExpr = pLinkLengthExpr;
 begintPosition(yyt->MPC_LinkLengthSpecifier.EndPos)
 return yyt;
}

tTree mMPC_Scheme
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pBody)
# else
(pPos, pBody)
tPosition pPos;
tTree pBody;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Scheme])
 yyt->Kind = kMPC_Scheme;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Scheme.Pos = pPos;
 yyt->MPC_Scheme.Body = pBody;
 begintPosition(yyt->MPC_Scheme.EndPos)
 return yyt;
}

tTree mMPC_NetList
# if defined __STDC__ | defined __cplusplus
(tTree pNext, tTree pPrev, tTree pNet)
# else
(pNext, pPrev, pNet)
tTree pNext;
tTree pPrev;
tTree pNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetList])
 yyt->Kind = kMPC_NetList;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetList.Next = pNext;
 yyt->MPC_NetList.Prev = pPrev;
 yyt->MPC_NetList.Net = pNet;
 begintPosition(yyt->MPC_NetList.Pos)
 beginbool(yyt->MPC_NetList.UnReduceable)
 return yyt;
}

tTree mMPC_NetOrSubnet
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev)
# else
(pPos, pIdent, pBigCreate, pDistribution, pNext, pPrev)
tPosition pPos;
tIdent pIdent;
bool pBigCreate;
tTree pDistribution;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetOrSubnet])
 yyt->Kind = kMPC_NetOrSubnet;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetOrSubnet.Pos = pPos;
 yyt->MPC_NetOrSubnet.Ident = pIdent;
 yyt->MPC_NetOrSubnet.BigCreate = pBigCreate;
 yyt->MPC_NetOrSubnet.Distribution = pDistribution;
 yyt->MPC_NetOrSubnet.Next = pNext;
 yyt->MPC_NetOrSubnet.Prev = pPrev;
 begintPosition(yyt->MPC_NetOrSubnet.EndPos)
 beginMPC_unsigned_short(yyt->MPC_NetOrSubnet.UniqueNumber)
 beginbool(yyt->MPC_NetOrSubnet.WithNumber)
 beginbool(yyt->MPC_NetOrSubnet.SingleNode)
 beginbool(yyt->MPC_NetOrSubnet.IsParent)
 beginpVoid(yyt->MPC_NetOrSubnet.pGen)
 begintTree(yyt->MPC_NetOrSubnet.NextUse)
 begintTree(yyt->MPC_NetOrSubnet.PrevUse)
 begintTree(yyt->MPC_NetOrSubnet.MyList)
 return yyt;
}

tTree mMPC_Net
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev, short pTopology, tTree pNetType)
# else
(pPos, pIdent, pBigCreate, pDistribution, pNext, pPrev, pTopology, pNetType)
tPosition pPos;
tIdent pIdent;
bool pBigCreate;
tTree pDistribution;
tTree pNext;
tTree pPrev;
short pTopology;
tTree pNetType;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Net])
 yyt->Kind = kMPC_Net;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Net.Pos = pPos;
 yyt->MPC_Net.Ident = pIdent;
 yyt->MPC_Net.BigCreate = pBigCreate;
 yyt->MPC_Net.Distribution = pDistribution;
 yyt->MPC_Net.Next = pNext;
 yyt->MPC_Net.Prev = pPrev;
 begintPosition(yyt->MPC_Net.EndPos)
 beginMPC_unsigned_short(yyt->MPC_Net.UniqueNumber)
 beginbool(yyt->MPC_Net.WithNumber)
 beginbool(yyt->MPC_Net.SingleNode)
 beginbool(yyt->MPC_Net.IsParent)
 beginpVoid(yyt->MPC_Net.pGen)
 begintTree(yyt->MPC_Net.NextUse)
 begintTree(yyt->MPC_Net.PrevUse)
 begintTree(yyt->MPC_Net.MyList)
 yyt->MPC_Net.Topology = pTopology;
 yyt->MPC_Net.NetType = pNetType;
 return yyt;
}

tTree mMPC_Subnet
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tIdent pIdent, bool pBigCreate, tTree pDistribution, tTree pNext, tTree pPrev, tIdent pNetOrSubnetName, bool pFlexible, tTree pPredicate)
# else
(pPos, pIdent, pBigCreate, pDistribution, pNext, pPrev, pNetOrSubnetName, pFlexible, pPredicate)
tPosition pPos;
tIdent pIdent;
bool pBigCreate;
tTree pDistribution;
tTree pNext;
tTree pPrev;
tIdent pNetOrSubnetName;
bool pFlexible;
tTree pPredicate;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Subnet])
 yyt->Kind = kMPC_Subnet;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Subnet.Pos = pPos;
 yyt->MPC_Subnet.Ident = pIdent;
 yyt->MPC_Subnet.BigCreate = pBigCreate;
 yyt->MPC_Subnet.Distribution = pDistribution;
 yyt->MPC_Subnet.Next = pNext;
 yyt->MPC_Subnet.Prev = pPrev;
 begintPosition(yyt->MPC_Subnet.EndPos)
 beginMPC_unsigned_short(yyt->MPC_Subnet.UniqueNumber)
 beginbool(yyt->MPC_Subnet.WithNumber)
 beginbool(yyt->MPC_Subnet.SingleNode)
 beginbool(yyt->MPC_Subnet.IsParent)
 beginpVoid(yyt->MPC_Subnet.pGen)
 begintTree(yyt->MPC_Subnet.NextUse)
 begintTree(yyt->MPC_Subnet.PrevUse)
 begintTree(yyt->MPC_Subnet.MyList)
 yyt->MPC_Subnet.NetOrSubnetName = pNetOrSubnetName;
 yyt->MPC_Subnet.Flexible = pFlexible;
 yyt->MPC_Subnet.Predicate = pPredicate;
 return yyt;
}

tTree mMPC_Relation
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, int pRelCode, tTree pNext, tTree pPrev, tTree pLNet, tTree pRNet)
# else
(pPos, pRelCode, pNext, pPrev, pLNet, pRNet)
tPosition pPos;
int pRelCode;
tTree pNext;
tTree pPrev;
tTree pLNet;
tTree pRNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Relation])
 yyt->Kind = kMPC_Relation;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Relation.Pos = pPos;
 yyt->MPC_Relation.RelCode = pRelCode;
 yyt->MPC_Relation.Next = pNext;
 yyt->MPC_Relation.Prev = pPrev;
 yyt->MPC_Relation.LNet = pLNet;
 yyt->MPC_Relation.RNet = pRNet;
 begintPosition(yyt->MPC_Relation.EndPos)
 return yyt;
}

tTree mMPC_Stats
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Stats])
 yyt->Kind = kMPC_Stats;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Stats.Pos = pPos;
 yyt->MPC_Stats.Next = pNext;
 yyt->MPC_Stats.Prev = pPrev;
 begintPosition(yyt->MPC_Stats.EndPos)
 return yyt;
}

tTree mMPC_Stat
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet)
# else
(pPos, pNext, pPrev, pFlag, pExecNet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Stat])
 yyt->Kind = kMPC_Stat;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Stat.Pos = pPos;
 yyt->MPC_Stat.Next = pNext;
 yyt->MPC_Stat.Prev = pPrev;
 begintPosition(yyt->MPC_Stat.EndPos)
 yyt->MPC_Stat.Flag = pFlag;
 yyt->MPC_Stat.ExecNet = pExecNet;
 begintTree(yyt->MPC_Stat.ActualExecNet)
 begintTree(yyt->MPC_Stat.RootNet)
 begintTree(yyt->MPC_Stat.PropNet)
 beginbool(yyt->MPC_Stat.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Stat.UniqueNumber)
 return yyt;
}

tTree mMPC_ExprStat
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ExprStat])
 yyt->Kind = kMPC_ExprStat;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_ExprStat.Pos = pPos;
 yyt->MPC_ExprStat.Next = pNext;
 yyt->MPC_ExprStat.Prev = pPrev;
 begintPosition(yyt->MPC_ExprStat.EndPos)
 yyt->MPC_ExprStat.Flag = pFlag;
 yyt->MPC_ExprStat.ExecNet = pExecNet;
 begintTree(yyt->MPC_ExprStat.ActualExecNet)
 begintTree(yyt->MPC_ExprStat.RootNet)
 begintTree(yyt->MPC_ExprStat.PropNet)
 beginbool(yyt->MPC_ExprStat.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_ExprStat.UniqueNumber)
 yyt->MPC_ExprStat.Expr = pExpr;
 return yyt;
}

tTree mMPC_If
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_If])
 yyt->Kind = kMPC_If;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_If.Pos = pPos;
 yyt->MPC_If.Next = pNext;
 yyt->MPC_If.Prev = pPrev;
 begintPosition(yyt->MPC_If.EndPos)
 yyt->MPC_If.Flag = pFlag;
 yyt->MPC_If.ExecNet = pExecNet;
 begintTree(yyt->MPC_If.ActualExecNet)
 begintTree(yyt->MPC_If.RootNet)
 begintTree(yyt->MPC_If.PropNet)
 beginbool(yyt->MPC_If.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_If.UniqueNumber)
 yyt->MPC_If.Expr = pExpr;
 yyt->MPC_If.Stats = pStats;
 return yyt;
}

tTree mMPC_IfElse
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pThen, tTree pElse)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pThen, pElse)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pThen;
tTree pElse;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IfElse])
 yyt->Kind = kMPC_IfElse;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_IfElse.Pos = pPos;
 yyt->MPC_IfElse.Next = pNext;
 yyt->MPC_IfElse.Prev = pPrev;
 begintPosition(yyt->MPC_IfElse.EndPos)
 yyt->MPC_IfElse.Flag = pFlag;
 yyt->MPC_IfElse.ExecNet = pExecNet;
 begintTree(yyt->MPC_IfElse.ActualExecNet)
 begintTree(yyt->MPC_IfElse.RootNet)
 begintTree(yyt->MPC_IfElse.PropNet)
 beginbool(yyt->MPC_IfElse.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_IfElse.UniqueNumber)
 yyt->MPC_IfElse.Expr = pExpr;
 yyt->MPC_IfElse.Then = pThen;
 yyt->MPC_IfElse.Else = pElse;
 return yyt;
}

tTree mMPC_Switch
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Switch])
 yyt->Kind = kMPC_Switch;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Switch.Pos = pPos;
 yyt->MPC_Switch.Next = pNext;
 yyt->MPC_Switch.Prev = pPrev;
 begintPosition(yyt->MPC_Switch.EndPos)
 yyt->MPC_Switch.Flag = pFlag;
 yyt->MPC_Switch.ExecNet = pExecNet;
 begintTree(yyt->MPC_Switch.ActualExecNet)
 begintTree(yyt->MPC_Switch.RootNet)
 begintTree(yyt->MPC_Switch.PropNet)
 beginbool(yyt->MPC_Switch.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Switch.UniqueNumber)
 yyt->MPC_Switch.Expr = pExpr;
 yyt->MPC_Switch.Stats = pStats;
 return yyt;
}

tTree mMPC_While
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_While])
 yyt->Kind = kMPC_While;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_While.Pos = pPos;
 yyt->MPC_While.Next = pNext;
 yyt->MPC_While.Prev = pPrev;
 begintPosition(yyt->MPC_While.EndPos)
 yyt->MPC_While.Flag = pFlag;
 yyt->MPC_While.ExecNet = pExecNet;
 begintTree(yyt->MPC_While.ActualExecNet)
 begintTree(yyt->MPC_While.RootNet)
 begintTree(yyt->MPC_While.PropNet)
 beginbool(yyt->MPC_While.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_While.UniqueNumber)
 yyt->MPC_While.Expr = pExpr;
 yyt->MPC_While.Stats = pStats;
 return yyt;
}

tTree mMPC_DoWhile
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pStats, tTree pExpr)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pStats, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pStats;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_DoWhile])
 yyt->Kind = kMPC_DoWhile;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_DoWhile.Pos = pPos;
 yyt->MPC_DoWhile.Next = pNext;
 yyt->MPC_DoWhile.Prev = pPrev;
 begintPosition(yyt->MPC_DoWhile.EndPos)
 yyt->MPC_DoWhile.Flag = pFlag;
 yyt->MPC_DoWhile.ExecNet = pExecNet;
 begintTree(yyt->MPC_DoWhile.ActualExecNet)
 begintTree(yyt->MPC_DoWhile.RootNet)
 begintTree(yyt->MPC_DoWhile.PropNet)
 beginbool(yyt->MPC_DoWhile.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_DoWhile.UniqueNumber)
 yyt->MPC_DoWhile.Stats = pStats;
 yyt->MPC_DoWhile.Expr = pExpr;
 return yyt;
}

tTree mMPC_For
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pInit, tTree pCond, tTree pReinit, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pInit, pCond, pReinit, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pInit;
tTree pCond;
tTree pReinit;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_For])
 yyt->Kind = kMPC_For;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_For.Pos = pPos;
 yyt->MPC_For.Next = pNext;
 yyt->MPC_For.Prev = pPrev;
 begintPosition(yyt->MPC_For.EndPos)
 yyt->MPC_For.Flag = pFlag;
 yyt->MPC_For.ExecNet = pExecNet;
 begintTree(yyt->MPC_For.ActualExecNet)
 begintTree(yyt->MPC_For.RootNet)
 begintTree(yyt->MPC_For.PropNet)
 beginbool(yyt->MPC_For.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_For.UniqueNumber)
 yyt->MPC_For.Init = pInit;
 yyt->MPC_For.Cond = pCond;
 yyt->MPC_For.Reinit = pReinit;
 yyt->MPC_For.Stats = pStats;
 return yyt;
}

tTree mMPC_Goto
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tIdent pIdent)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pIdent)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Goto])
 yyt->Kind = kMPC_Goto;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Goto.Pos = pPos;
 yyt->MPC_Goto.Next = pNext;
 yyt->MPC_Goto.Prev = pPrev;
 begintPosition(yyt->MPC_Goto.EndPos)
 yyt->MPC_Goto.Flag = pFlag;
 yyt->MPC_Goto.ExecNet = pExecNet;
 begintTree(yyt->MPC_Goto.ActualExecNet)
 begintTree(yyt->MPC_Goto.RootNet)
 begintTree(yyt->MPC_Goto.PropNet)
 beginbool(yyt->MPC_Goto.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Goto.UniqueNumber)
 yyt->MPC_Goto.Ident = pIdent;
 begintTree(yyt->MPC_Goto.LabelDef)
 begintTree(yyt->MPC_Goto.NextUse)
 begintTree(yyt->MPC_Goto.PrevUse)
 return yyt;
}

tTree mMPC_Continue
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet)
# else
(pPos, pNext, pPrev, pFlag, pExecNet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Continue])
 yyt->Kind = kMPC_Continue;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Continue.Pos = pPos;
 yyt->MPC_Continue.Next = pNext;
 yyt->MPC_Continue.Prev = pPrev;
 begintPosition(yyt->MPC_Continue.EndPos)
 yyt->MPC_Continue.Flag = pFlag;
 yyt->MPC_Continue.ExecNet = pExecNet;
 begintTree(yyt->MPC_Continue.ActualExecNet)
 begintTree(yyt->MPC_Continue.RootNet)
 begintTree(yyt->MPC_Continue.PropNet)
 beginbool(yyt->MPC_Continue.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Continue.UniqueNumber)
 return yyt;
}

tTree mMPC_Break
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet)
# else
(pPos, pNext, pPrev, pFlag, pExecNet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Break])
 yyt->Kind = kMPC_Break;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Break.Pos = pPos;
 yyt->MPC_Break.Next = pNext;
 yyt->MPC_Break.Prev = pPrev;
 begintPosition(yyt->MPC_Break.EndPos)
 yyt->MPC_Break.Flag = pFlag;
 yyt->MPC_Break.ExecNet = pExecNet;
 begintTree(yyt->MPC_Break.ActualExecNet)
 begintTree(yyt->MPC_Break.RootNet)
 begintTree(yyt->MPC_Break.PropNet)
 beginbool(yyt->MPC_Break.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Break.UniqueNumber)
 return yyt;
}

tTree mMPC_BreakFan
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet)
# else
(pPos, pNext, pPrev, pFlag, pExecNet)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BreakFan])
 yyt->Kind = kMPC_BreakFan;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_BreakFan.Pos = pPos;
 yyt->MPC_BreakFan.Next = pNext;
 yyt->MPC_BreakFan.Prev = pPrev;
 begintPosition(yyt->MPC_BreakFan.EndPos)
 yyt->MPC_BreakFan.Flag = pFlag;
 yyt->MPC_BreakFan.ExecNet = pExecNet;
 begintTree(yyt->MPC_BreakFan.ActualExecNet)
 begintTree(yyt->MPC_BreakFan.RootNet)
 begintTree(yyt->MPC_BreakFan.PropNet)
 beginbool(yyt->MPC_BreakFan.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_BreakFan.UniqueNumber)
 return yyt;
}

tTree mMPC_Return
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Return])
 yyt->Kind = kMPC_Return;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Return.Pos = pPos;
 yyt->MPC_Return.Next = pNext;
 yyt->MPC_Return.Prev = pPrev;
 begintPosition(yyt->MPC_Return.EndPos)
 yyt->MPC_Return.Flag = pFlag;
 yyt->MPC_Return.ExecNet = pExecNet;
 begintTree(yyt->MPC_Return.ActualExecNet)
 begintTree(yyt->MPC_Return.RootNet)
 begintTree(yyt->MPC_Return.PropNet)
 beginbool(yyt->MPC_Return.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Return.UniqueNumber)
 yyt->MPC_Return.Expr = pExpr;
 return yyt;
}

tTree mMPC_Compound
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, int pFunctionBody, tTree pDecls, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pFunctionBody, pDecls, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
int pFunctionBody;
tTree pDecls;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Compound])
 yyt->Kind = kMPC_Compound;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Compound.Pos = pPos;
 yyt->MPC_Compound.Next = pNext;
 yyt->MPC_Compound.Prev = pPrev;
 begintPosition(yyt->MPC_Compound.EndPos)
 yyt->MPC_Compound.Flag = pFlag;
 yyt->MPC_Compound.ExecNet = pExecNet;
 begintTree(yyt->MPC_Compound.ActualExecNet)
 begintTree(yyt->MPC_Compound.RootNet)
 begintTree(yyt->MPC_Compound.PropNet)
 beginbool(yyt->MPC_Compound.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Compound.UniqueNumber)
 yyt->MPC_Compound.FunctionBody = pFunctionBody;
 yyt->MPC_Compound.Decls = pDecls;
 yyt->MPC_Compound.Stats = pStats;
 return yyt;
}

tTree mMPC_CompScheme
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pNode)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pNode)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pNode;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CompScheme])
 yyt->Kind = kMPC_CompScheme;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CompScheme.Pos = pPos;
 yyt->MPC_CompScheme.Next = pNext;
 yyt->MPC_CompScheme.Prev = pPrev;
 begintPosition(yyt->MPC_CompScheme.EndPos)
 yyt->MPC_CompScheme.Flag = pFlag;
 yyt->MPC_CompScheme.ExecNet = pExecNet;
 begintTree(yyt->MPC_CompScheme.ActualExecNet)
 begintTree(yyt->MPC_CompScheme.RootNet)
 begintTree(yyt->MPC_CompScheme.PropNet)
 beginbool(yyt->MPC_CompScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_CompScheme.UniqueNumber)
 yyt->MPC_CompScheme.Expr = pExpr;
 yyt->MPC_CompScheme.Node = pNode;
 return yyt;
}

tTree mMPC_CommScheme
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pExpr, tTree pFrom, tTree pTo)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pExpr, pFrom, pTo)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pExpr;
tTree pFrom;
tTree pTo;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CommScheme])
 yyt->Kind = kMPC_CommScheme;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CommScheme.Pos = pPos;
 yyt->MPC_CommScheme.Next = pNext;
 yyt->MPC_CommScheme.Prev = pPrev;
 begintPosition(yyt->MPC_CommScheme.EndPos)
 yyt->MPC_CommScheme.Flag = pFlag;
 yyt->MPC_CommScheme.ExecNet = pExecNet;
 begintTree(yyt->MPC_CommScheme.ActualExecNet)
 begintTree(yyt->MPC_CommScheme.RootNet)
 begintTree(yyt->MPC_CommScheme.PropNet)
 beginbool(yyt->MPC_CommScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_CommScheme.UniqueNumber)
 yyt->MPC_CommScheme.Expr = pExpr;
 yyt->MPC_CommScheme.From = pFrom;
 yyt->MPC_CommScheme.To = pTo;
 return yyt;
}

tTree mMPC_ParScheme
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pInit, tTree pCond, tTree pReinit, tTree pStats)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pInit, pCond, pReinit, pStats)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pInit;
tTree pCond;
tTree pReinit;
tTree pStats;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_ParScheme])
 yyt->Kind = kMPC_ParScheme;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_ParScheme.Pos = pPos;
 yyt->MPC_ParScheme.Next = pNext;
 yyt->MPC_ParScheme.Prev = pPrev;
 begintPosition(yyt->MPC_ParScheme.EndPos)
 yyt->MPC_ParScheme.Flag = pFlag;
 yyt->MPC_ParScheme.ExecNet = pExecNet;
 begintTree(yyt->MPC_ParScheme.ActualExecNet)
 begintTree(yyt->MPC_ParScheme.RootNet)
 begintTree(yyt->MPC_ParScheme.PropNet)
 beginbool(yyt->MPC_ParScheme.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_ParScheme.UniqueNumber)
 yyt->MPC_ParScheme.Init = pInit;
 yyt->MPC_ParScheme.Cond = pCond;
 yyt->MPC_ParScheme.Reinit = pReinit;
 yyt->MPC_ParScheme.Stats = pStats;
 return yyt;
}

tTree mMPC_Fan
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tStatFlags pFlag, tTree pExecNet, tTree pBody)
# else
(pPos, pNext, pPrev, pFlag, pExecNet, pBody)
tPosition pPos;
tTree pNext;
tTree pPrev;
tStatFlags pFlag;
tTree pExecNet;
tTree pBody;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Fan])
 yyt->Kind = kMPC_Fan;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Fan.Pos = pPos;
 yyt->MPC_Fan.Next = pNext;
 yyt->MPC_Fan.Prev = pPrev;
 begintPosition(yyt->MPC_Fan.EndPos)
 yyt->MPC_Fan.Flag = pFlag;
 yyt->MPC_Fan.ExecNet = pExecNet;
 begintTree(yyt->MPC_Fan.ActualExecNet)
 begintTree(yyt->MPC_Fan.RootNet)
 begintTree(yyt->MPC_Fan.PropNet)
 beginbool(yyt->MPC_Fan.Benchmark)
 beginMPC_unsigned_short(yyt->MPC_Fan.UniqueNumber)
 yyt->MPC_Fan.Body = pBody;
 return yyt;
}

tTree mMPC_Label
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Label])
 yyt->Kind = kMPC_Label;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Label.Pos = pPos;
 yyt->MPC_Label.Next = pNext;
 yyt->MPC_Label.Prev = pPrev;
 begintPosition(yyt->MPC_Label.EndPos)
 begintTree(yyt->MPC_Label.NextLabel)
 begintTree(yyt->MPC_Label.PrevLabel)
 return yyt;
}

tTree mMPC_IdentLabel
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tIdent pIdent)
# else
(pPos, pNext, pPrev, pIdent)
tPosition pPos;
tTree pNext;
tTree pPrev;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IdentLabel])
 yyt->Kind = kMPC_IdentLabel;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_IdentLabel.Pos = pPos;
 yyt->MPC_IdentLabel.Next = pNext;
 yyt->MPC_IdentLabel.Prev = pPrev;
 begintPosition(yyt->MPC_IdentLabel.EndPos)
 begintTree(yyt->MPC_IdentLabel.NextLabel)
 begintTree(yyt->MPC_IdentLabel.PrevLabel)
 yyt->MPC_IdentLabel.Ident = pIdent;
 begintTree(yyt->MPC_IdentLabel.NextUse)
 beginbool(yyt->MPC_IdentLabel.Used)
 return yyt;
}

tTree mMPC_CaseLabel
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, long pCaseValue, tTree pExpr)
# else
(pPos, pNext, pPrev, pCaseValue, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
long pCaseValue;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CaseLabel])
 yyt->Kind = kMPC_CaseLabel;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CaseLabel.Pos = pPos;
 yyt->MPC_CaseLabel.Next = pNext;
 yyt->MPC_CaseLabel.Prev = pPrev;
 begintPosition(yyt->MPC_CaseLabel.EndPos)
 begintTree(yyt->MPC_CaseLabel.NextLabel)
 begintTree(yyt->MPC_CaseLabel.PrevLabel)
 yyt->MPC_CaseLabel.CaseValue = pCaseValue;
 yyt->MPC_CaseLabel.Expr = pExpr;
 return yyt;
}

tTree mMPC_Default
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Default])
 yyt->Kind = kMPC_Default;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Default.Pos = pPos;
 yyt->MPC_Default.Next = pNext;
 yyt->MPC_Default.Prev = pPrev;
 begintPosition(yyt->MPC_Default.EndPos)
 begintTree(yyt->MPC_Default.NextLabel)
 begintTree(yyt->MPC_Default.PrevLabel)
 return yyt;
}

tTree mMPC_Expr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Expr])
 yyt->Kind = kMPC_Expr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Expr.Pos = pPos;
 yyt->MPC_Expr.Flag = pFlag;
 yyt->MPC_Expr.TmpName = pTmpName;
 yyt->MPC_Expr.Type = pType;
 yyt->MPC_Expr.EvalNet = pEvalNet;
 yyt->MPC_Expr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_Expr.BegPos)
 begintPosition(yyt->MPC_Expr.EndPos)
 begintTree(yyt->MPC_Expr.ActualEvalNet)
 beginchar(yyt->MPC_Expr.Pass)
 beginbool(yyt->MPC_Expr.Repl)
 begintOptm_Attribute(yyt->MPC_Expr.Optm_Attribute)
 return yyt;
}

tTree mMPC_Const
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pSymbolicForm)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tString pSymbolicForm;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Const])
 yyt->Kind = kMPC_Const;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Const.Pos = pPos;
 yyt->MPC_Const.Flag = pFlag;
 yyt->MPC_Const.TmpName = pTmpName;
 yyt->MPC_Const.Type = pType;
 yyt->MPC_Const.EvalNet = pEvalNet;
 yyt->MPC_Const.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_Const.BegPos)
 begintPosition(yyt->MPC_Const.EndPos)
 begintTree(yyt->MPC_Const.ActualEvalNet)
 beginchar(yyt->MPC_Const.Pass)
 beginbool(yyt->MPC_Const.Repl)
 begintOptm_Attribute(yyt->MPC_Const.Optm_Attribute)
 yyt->MPC_Const.SymbolicForm = pSymbolicForm;
 return yyt;
}

tTree mMPC_IntConst
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, long pValue)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pSymbolicForm, pValue)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tString pSymbolicForm;
long pValue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_IntConst])
 yyt->Kind = kMPC_IntConst;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_IntConst.Pos = pPos;
 yyt->MPC_IntConst.Flag = pFlag;
 yyt->MPC_IntConst.TmpName = pTmpName;
 yyt->MPC_IntConst.Type = pType;
 yyt->MPC_IntConst.EvalNet = pEvalNet;
 yyt->MPC_IntConst.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_IntConst.BegPos)
 begintPosition(yyt->MPC_IntConst.EndPos)
 begintTree(yyt->MPC_IntConst.ActualEvalNet)
 beginchar(yyt->MPC_IntConst.Pass)
 beginbool(yyt->MPC_IntConst.Repl)
 begintOptm_Attribute(yyt->MPC_IntConst.Optm_Attribute)
 yyt->MPC_IntConst.SymbolicForm = pSymbolicForm;
 yyt->MPC_IntConst.Value = pValue;
 return yyt;
}

tTree mMPC_UIntConst
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, MPC_long_unsigned pValue)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pSymbolicForm, pValue)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tString pSymbolicForm;
MPC_long_unsigned pValue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UIntConst])
 yyt->Kind = kMPC_UIntConst;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_UIntConst.Pos = pPos;
 yyt->MPC_UIntConst.Flag = pFlag;
 yyt->MPC_UIntConst.TmpName = pTmpName;
 yyt->MPC_UIntConst.Type = pType;
 yyt->MPC_UIntConst.EvalNet = pEvalNet;
 yyt->MPC_UIntConst.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_UIntConst.BegPos)
 begintPosition(yyt->MPC_UIntConst.EndPos)
 begintTree(yyt->MPC_UIntConst.ActualEvalNet)
 beginchar(yyt->MPC_UIntConst.Pass)
 beginbool(yyt->MPC_UIntConst.Repl)
 begintOptm_Attribute(yyt->MPC_UIntConst.Optm_Attribute)
 yyt->MPC_UIntConst.SymbolicForm = pSymbolicForm;
 yyt->MPC_UIntConst.Value = pValue;
 return yyt;
}

tTree mMPC_FloatConst
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pSymbolicForm, MPC_long_double pValue)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pSymbolicForm, pValue)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tString pSymbolicForm;
MPC_long_double pValue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_FloatConst])
 yyt->Kind = kMPC_FloatConst;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_FloatConst.Pos = pPos;
 yyt->MPC_FloatConst.Flag = pFlag;
 yyt->MPC_FloatConst.TmpName = pTmpName;
 yyt->MPC_FloatConst.Type = pType;
 yyt->MPC_FloatConst.EvalNet = pEvalNet;
 yyt->MPC_FloatConst.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_FloatConst.BegPos)
 begintPosition(yyt->MPC_FloatConst.EndPos)
 begintTree(yyt->MPC_FloatConst.ActualEvalNet)
 beginchar(yyt->MPC_FloatConst.Pass)
 beginbool(yyt->MPC_FloatConst.Repl)
 begintOptm_Attribute(yyt->MPC_FloatConst.Optm_Attribute)
 yyt->MPC_FloatConst.SymbolicForm = pSymbolicForm;
 yyt->MPC_FloatConst.Value = pValue;
 return yyt;
}

tTree mMPC_StringLiteral
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tString pString, short pFullSize, tTree pNext, tTree pPrev)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pString, pFullSize, pNext, pPrev)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tString pString;
short pFullSize;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_StringLiteral])
 yyt->Kind = kMPC_StringLiteral;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_StringLiteral.Pos = pPos;
 yyt->MPC_StringLiteral.Flag = pFlag;
 yyt->MPC_StringLiteral.TmpName = pTmpName;
 yyt->MPC_StringLiteral.Type = pType;
 yyt->MPC_StringLiteral.EvalNet = pEvalNet;
 yyt->MPC_StringLiteral.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_StringLiteral.BegPos)
 begintPosition(yyt->MPC_StringLiteral.EndPos)
 begintTree(yyt->MPC_StringLiteral.ActualEvalNet)
 beginchar(yyt->MPC_StringLiteral.Pass)
 beginbool(yyt->MPC_StringLiteral.Repl)
 begintOptm_Attribute(yyt->MPC_StringLiteral.Optm_Attribute)
 yyt->MPC_StringLiteral.String = pString;
 yyt->MPC_StringLiteral.FullSize = pFullSize;
 yyt->MPC_StringLiteral.Next = pNext;
 yyt->MPC_StringLiteral.Prev = pPrev;
 return yyt;
}

tTree mMPC_Ident
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tIdent pIdent, tTree pStore)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pIdent, pStore)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tIdent pIdent;
tTree pStore;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Ident])
 yyt->Kind = kMPC_Ident;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Ident.Pos = pPos;
 yyt->MPC_Ident.Flag = pFlag;
 yyt->MPC_Ident.TmpName = pTmpName;
 yyt->MPC_Ident.Type = pType;
 yyt->MPC_Ident.EvalNet = pEvalNet;
 yyt->MPC_Ident.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_Ident.BegPos)
 begintPosition(yyt->MPC_Ident.EndPos)
 begintTree(yyt->MPC_Ident.ActualEvalNet)
 beginchar(yyt->MPC_Ident.Pass)
 beginbool(yyt->MPC_Ident.Repl)
 begintOptm_Attribute(yyt->MPC_Ident.Optm_Attribute)
 yyt->MPC_Ident.Ident = pIdent;
 yyt->MPC_Ident.Store = pStore;
 begintTree(yyt->MPC_Ident.NextUse)
 begintTree(yyt->MPC_Ident.PrevUse)
 return yyt;
}

tTree mMPC_CastExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pTypeName, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pTypeName, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tTree pTypeName;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CastExpr])
 yyt->Kind = kMPC_CastExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CastExpr.Pos = pPos;
 yyt->MPC_CastExpr.Flag = pFlag;
 yyt->MPC_CastExpr.TmpName = pTmpName;
 yyt->MPC_CastExpr.Type = pType;
 yyt->MPC_CastExpr.EvalNet = pEvalNet;
 yyt->MPC_CastExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_CastExpr.BegPos)
 begintPosition(yyt->MPC_CastExpr.EndPos)
 begintTree(yyt->MPC_CastExpr.ActualEvalNet)
 beginchar(yyt->MPC_CastExpr.Pass)
 beginbool(yyt->MPC_CastExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CastExpr.Optm_Attribute)
 yyt->MPC_CastExpr.TypeName = pTypeName;
 yyt->MPC_CastExpr.Operand = pOperand;
 return yyt;
}

tTree mMPC_NetCastExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pFlexible, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pFlexible, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
bool pFlexible;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_NetCastExpr])
 yyt->Kind = kMPC_NetCastExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_NetCastExpr.Pos = pPos;
 yyt->MPC_NetCastExpr.Flag = pFlag;
 yyt->MPC_NetCastExpr.TmpName = pTmpName;
 yyt->MPC_NetCastExpr.Type = pType;
 yyt->MPC_NetCastExpr.EvalNet = pEvalNet;
 yyt->MPC_NetCastExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_NetCastExpr.BegPos)
 begintPosition(yyt->MPC_NetCastExpr.EndPos)
 begintTree(yyt->MPC_NetCastExpr.ActualEvalNet)
 beginchar(yyt->MPC_NetCastExpr.Pass)
 beginbool(yyt->MPC_NetCastExpr.Repl)
 begintOptm_Attribute(yyt->MPC_NetCastExpr.Optm_Attribute)
 yyt->MPC_NetCastExpr.Flexible = pFlexible;
 yyt->MPC_NetCastExpr.Operand = pOperand;
 beginpVoid(yyt->MPC_NetCastExpr.ExprPtr)
 return yyt;
}

tTree mMPC_CoordExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tIdent pCoordName, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pCoordName, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tIdent pCoordName;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CoordExpr])
 yyt->Kind = kMPC_CoordExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CoordExpr.Pos = pPos;
 yyt->MPC_CoordExpr.Flag = pFlag;
 yyt->MPC_CoordExpr.TmpName = pTmpName;
 yyt->MPC_CoordExpr.Type = pType;
 yyt->MPC_CoordExpr.EvalNet = pEvalNet;
 yyt->MPC_CoordExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_CoordExpr.BegPos)
 begintPosition(yyt->MPC_CoordExpr.EndPos)
 begintTree(yyt->MPC_CoordExpr.ActualEvalNet)
 beginchar(yyt->MPC_CoordExpr.Pass)
 beginbool(yyt->MPC_CoordExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CoordExpr.Optm_Attribute)
 yyt->MPC_CoordExpr.CoordName = pCoordName;
 yyt->MPC_CoordExpr.Operand = pOperand;
 beginshort(yyt->MPC_CoordExpr.CoordNumber)
 return yyt;
}

tTree mMPC_SizeofExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pCompileTime, pValue)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
bool pCompileTime;
int pValue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SizeofExpr])
 yyt->Kind = kMPC_SizeofExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_SizeofExpr.Pos = pPos;
 yyt->MPC_SizeofExpr.Flag = pFlag;
 yyt->MPC_SizeofExpr.TmpName = pTmpName;
 yyt->MPC_SizeofExpr.Type = pType;
 yyt->MPC_SizeofExpr.EvalNet = pEvalNet;
 yyt->MPC_SizeofExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_SizeofExpr.BegPos)
 begintPosition(yyt->MPC_SizeofExpr.EndPos)
 begintTree(yyt->MPC_SizeofExpr.ActualEvalNet)
 beginchar(yyt->MPC_SizeofExpr.Pass)
 beginbool(yyt->MPC_SizeofExpr.Repl)
 begintOptm_Attribute(yyt->MPC_SizeofExpr.Optm_Attribute)
 yyt->MPC_SizeofExpr.CompileTime = pCompileTime;
 yyt->MPC_SizeofExpr.Value = pValue;
 return yyt;
}

tTree mMPC_Size_Of_Value
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pCompileTime, pValue, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
bool pCompileTime;
int pValue;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Size_Of_Value])
 yyt->Kind = kMPC_Size_Of_Value;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Size_Of_Value.Pos = pPos;
 yyt->MPC_Size_Of_Value.Flag = pFlag;
 yyt->MPC_Size_Of_Value.TmpName = pTmpName;
 yyt->MPC_Size_Of_Value.Type = pType;
 yyt->MPC_Size_Of_Value.EvalNet = pEvalNet;
 yyt->MPC_Size_Of_Value.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_Size_Of_Value.BegPos)
 begintPosition(yyt->MPC_Size_Of_Value.EndPos)
 begintTree(yyt->MPC_Size_Of_Value.ActualEvalNet)
 beginchar(yyt->MPC_Size_Of_Value.Pass)
 beginbool(yyt->MPC_Size_Of_Value.Repl)
 begintOptm_Attribute(yyt->MPC_Size_Of_Value.Optm_Attribute)
 yyt->MPC_Size_Of_Value.CompileTime = pCompileTime;
 yyt->MPC_Size_Of_Value.Value = pValue;
 yyt->MPC_Size_Of_Value.Operand = pOperand;
 return yyt;
}

tTree mMPC_Size_Of_Type
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, bool pCompileTime, int pValue, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pCompileTime, pValue, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
bool pCompileTime;
int pValue;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Size_Of_Type])
 yyt->Kind = kMPC_Size_Of_Type;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Size_Of_Type.Pos = pPos;
 yyt->MPC_Size_Of_Type.Flag = pFlag;
 yyt->MPC_Size_Of_Type.TmpName = pTmpName;
 yyt->MPC_Size_Of_Type.Type = pType;
 yyt->MPC_Size_Of_Type.EvalNet = pEvalNet;
 yyt->MPC_Size_Of_Type.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_Size_Of_Type.BegPos)
 begintPosition(yyt->MPC_Size_Of_Type.EndPos)
 begintTree(yyt->MPC_Size_Of_Type.ActualEvalNet)
 beginchar(yyt->MPC_Size_Of_Type.Pass)
 beginbool(yyt->MPC_Size_Of_Type.Repl)
 begintOptm_Attribute(yyt->MPC_Size_Of_Type.Optm_Attribute)
 yyt->MPC_Size_Of_Type.CompileTime = pCompileTime;
 yyt->MPC_Size_Of_Type.Value = pValue;
 yyt->MPC_Size_Of_Type.Operand = pOperand;
 return yyt;
}

tTree mMPC_TimeofExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pNetDecl)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pNetDecl)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tTree pNetDecl;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TimeofExpr])
 yyt->Kind = kMPC_TimeofExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_TimeofExpr.Pos = pPos;
 yyt->MPC_TimeofExpr.Flag = pFlag;
 yyt->MPC_TimeofExpr.TmpName = pTmpName;
 yyt->MPC_TimeofExpr.Type = pType;
 yyt->MPC_TimeofExpr.EvalNet = pEvalNet;
 yyt->MPC_TimeofExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_TimeofExpr.BegPos)
 begintPosition(yyt->MPC_TimeofExpr.EndPos)
 begintTree(yyt->MPC_TimeofExpr.ActualEvalNet)
 beginchar(yyt->MPC_TimeofExpr.Pass)
 beginbool(yyt->MPC_TimeofExpr.Repl)
 begintOptm_Attribute(yyt->MPC_TimeofExpr.Optm_Attribute)
 yyt->MPC_TimeofExpr.NetDecl = pNetDecl;
 return yyt;
}

tTree mMPC_UnaryExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pOperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pOpCode, pOperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
short pOpCode;
tTree pOperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_UnaryExpr])
 yyt->Kind = kMPC_UnaryExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_UnaryExpr.Pos = pPos;
 yyt->MPC_UnaryExpr.Flag = pFlag;
 yyt->MPC_UnaryExpr.TmpName = pTmpName;
 yyt->MPC_UnaryExpr.Type = pType;
 yyt->MPC_UnaryExpr.EvalNet = pEvalNet;
 yyt->MPC_UnaryExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_UnaryExpr.BegPos)
 begintPosition(yyt->MPC_UnaryExpr.EndPos)
 begintTree(yyt->MPC_UnaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_UnaryExpr.Pass)
 beginbool(yyt->MPC_UnaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_UnaryExpr.Optm_Attribute)
 yyt->MPC_UnaryExpr.OpCode = pOpCode;
 yyt->MPC_UnaryExpr.Operand = pOperand;
 return yyt;
}

tTree mMPC_BinaryExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pLoperand, tTree pRoperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pOpCode, pLoperand, pRoperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
short pOpCode;
tTree pLoperand;
tTree pRoperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_BinaryExpr])
 yyt->Kind = kMPC_BinaryExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_BinaryExpr.Pos = pPos;
 yyt->MPC_BinaryExpr.Flag = pFlag;
 yyt->MPC_BinaryExpr.TmpName = pTmpName;
 yyt->MPC_BinaryExpr.Type = pType;
 yyt->MPC_BinaryExpr.EvalNet = pEvalNet;
 yyt->MPC_BinaryExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_BinaryExpr.BegPos)
 begintPosition(yyt->MPC_BinaryExpr.EndPos)
 begintTree(yyt->MPC_BinaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_BinaryExpr.Pass)
 beginbool(yyt->MPC_BinaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_BinaryExpr.Optm_Attribute)
 yyt->MPC_BinaryExpr.OpCode = pOpCode;
 yyt->MPC_BinaryExpr.Loperand = pLoperand;
 yyt->MPC_BinaryExpr.Roperand = pRoperand;
 return yyt;
}

tTree mMPC_TernaryExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pFoperand, tTree pSoperand, tTree pToperand)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pOpCode, pFoperand, pSoperand, pToperand)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
short pOpCode;
tTree pFoperand;
tTree pSoperand;
tTree pToperand;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_TernaryExpr])
 yyt->Kind = kMPC_TernaryExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_TernaryExpr.Pos = pPos;
 yyt->MPC_TernaryExpr.Flag = pFlag;
 yyt->MPC_TernaryExpr.TmpName = pTmpName;
 yyt->MPC_TernaryExpr.Type = pType;
 yyt->MPC_TernaryExpr.EvalNet = pEvalNet;
 yyt->MPC_TernaryExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_TernaryExpr.BegPos)
 begintPosition(yyt->MPC_TernaryExpr.EndPos)
 begintTree(yyt->MPC_TernaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_TernaryExpr.Pass)
 beginbool(yyt->MPC_TernaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_TernaryExpr.Optm_Attribute)
 yyt->MPC_TernaryExpr.OpCode = pOpCode;
 yyt->MPC_TernaryExpr.Foperand = pFoperand;
 yyt->MPC_TernaryExpr.Soperand = pSoperand;
 yyt->MPC_TernaryExpr.Toperand = pToperand;
 return yyt;
}

tTree mMPC_QuaternaryExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, short pOpCode, tTree pOperand1, tTree pOperand2, tTree pOperand3, tTree pOperand4)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pOpCode, pOperand1, pOperand2, pOperand3, pOperand4)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
short pOpCode;
tTree pOperand1;
tTree pOperand2;
tTree pOperand3;
tTree pOperand4;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_QuaternaryExpr])
 yyt->Kind = kMPC_QuaternaryExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_QuaternaryExpr.Pos = pPos;
 yyt->MPC_QuaternaryExpr.Flag = pFlag;
 yyt->MPC_QuaternaryExpr.TmpName = pTmpName;
 yyt->MPC_QuaternaryExpr.Type = pType;
 yyt->MPC_QuaternaryExpr.EvalNet = pEvalNet;
 yyt->MPC_QuaternaryExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_QuaternaryExpr.BegPos)
 begintPosition(yyt->MPC_QuaternaryExpr.EndPos)
 begintTree(yyt->MPC_QuaternaryExpr.ActualEvalNet)
 beginchar(yyt->MPC_QuaternaryExpr.Pass)
 beginbool(yyt->MPC_QuaternaryExpr.Repl)
 begintOptm_Attribute(yyt->MPC_QuaternaryExpr.Optm_Attribute)
 yyt->MPC_QuaternaryExpr.OpCode = pOpCode;
 yyt->MPC_QuaternaryExpr.Operand1 = pOperand1;
 yyt->MPC_QuaternaryExpr.Operand2 = pOperand2;
 yyt->MPC_QuaternaryExpr.Operand3 = pOperand3;
 yyt->MPC_QuaternaryExpr.Operand4 = pOperand4;
 return yyt;
}

tTree mMPC_CallExpr
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tExprFlags pFlag, tString pTmpName, tTree pType, tTree pEvalNet, tTree pStoreNet, tTree pFunction, tTree pArgList, tTree pNetworkArgList)
# else
(pPos, pFlag, pTmpName, pType, pEvalNet, pStoreNet, pFunction, pArgList, pNetworkArgList)
tPosition pPos;
tExprFlags pFlag;
tString pTmpName;
tTree pType;
tTree pEvalNet;
tTree pStoreNet;
tTree pFunction;
tTree pArgList;
tTree pNetworkArgList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_CallExpr])
 yyt->Kind = kMPC_CallExpr;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_CallExpr.Pos = pPos;
 yyt->MPC_CallExpr.Flag = pFlag;
 yyt->MPC_CallExpr.TmpName = pTmpName;
 yyt->MPC_CallExpr.Type = pType;
 yyt->MPC_CallExpr.EvalNet = pEvalNet;
 yyt->MPC_CallExpr.StoreNet = pStoreNet;
 begintPosition(yyt->MPC_CallExpr.BegPos)
 begintPosition(yyt->MPC_CallExpr.EndPos)
 begintTree(yyt->MPC_CallExpr.ActualEvalNet)
 beginchar(yyt->MPC_CallExpr.Pass)
 beginbool(yyt->MPC_CallExpr.Repl)
 begintOptm_Attribute(yyt->MPC_CallExpr.Optm_Attribute)
 yyt->MPC_CallExpr.Function = pFunction;
 yyt->MPC_CallExpr.ArgList = pArgList;
 yyt->MPC_CallExpr.NetworkArgList = pNetworkArgList;
 return yyt;
}

tTree mMPC_Exprs
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTree pExpr)
# else
(pPos, pNext, pPrev, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Exprs])
 yyt->Kind = kMPC_Exprs;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Exprs.Pos = pPos;
 yyt->MPC_Exprs.Next = pNext;
 yyt->MPC_Exprs.Prev = pPrev;
 yyt->MPC_Exprs.Expr = pExpr;
 begintPosition(yyt->MPC_Exprs.BegPos)
 begintPosition(yyt->MPC_Exprs.EndPos)
 return yyt;
}

tTree mMPC_Initializer
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev)
# else
(pPos, pNext, pPrev)
tPosition pPos;
tTree pNext;
tTree pPrev;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_Initializer])
 yyt->Kind = kMPC_Initializer;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_Initializer.Pos = pPos;
 yyt->MPC_Initializer.Next = pNext;
 yyt->MPC_Initializer.Prev = pPrev;
 begintPosition(yyt->MPC_Initializer.EndPos)
 return yyt;
}

tTree mMPC_SimpleInit
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, tTree pExpr)
# else
(pPos, pNext, pPrev, pExpr)
tPosition pPos;
tTree pNext;
tTree pPrev;
tTree pExpr;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_SimpleInit])
 yyt->Kind = kMPC_SimpleInit;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_SimpleInit.Pos = pPos;
 yyt->MPC_SimpleInit.Next = pNext;
 yyt->MPC_SimpleInit.Prev = pPrev;
 begintPosition(yyt->MPC_SimpleInit.EndPos)
 yyt->MPC_SimpleInit.Expr = pExpr;
 return yyt;
}

tTree mMPC_InitList
# if defined __STDC__ | defined __cplusplus
(tPosition pPos, tTree pNext, tTree pPrev, int pLength, tTree pList)
# else
(pPos, pNext, pPrev, pLength, pList)
tPosition pPos;
tTree pNext;
tTree pPrev;
int pLength;
tTree pList;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMPC_InitList])
 yyt->Kind = kMPC_InitList;
 yyt->yyHead.yyMark = 0;
 yyt->MPC_InitList.Pos = pPos;
 yyt->MPC_InitList.Next = pNext;
 yyt->MPC_InitList.Prev = pPrev;
 begintPosition(yyt->MPC_InitList.EndPos)
 yyt->MPC_InitList.Length = pLength;
 yyt->MPC_InitList.List = pList;
 return yyt;
}

typedef tTree * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kMPC_Root:
yyMark (yyt->MPC_Root.Decls);
yyMark (yyt->MPC_Root.Source);
yyMark (yyt->MPC_Root.Messages);
yyMark (yyt->MPC_Root.Host);
yyMark (yyt->MPC_Root.SingleNode);
yyMark (yyt->MPC_Root.ComputingSpace);
yyMark (yyt->MPC_Root.Const);
yyMark (yyt->MPC_Root.Recon);
yyMark (yyt->MPC_Root.HostList);
yyMark (yyt->MPC_Root.SingleNodeList);
yyMark (yyt->MPC_Root.ComputingSpaceList);
yyMark (yyt->MPC_Root.ConstList);
yyt = yyt->MPC_Root.ReconList; break;
case kMPC_Source:
yyMark (yyt->MPC_Source.Prev);
yyt = yyt->MPC_Source.Next; break;
case kMPC_Messages:
yyMark (yyt->MPC_Messages.Prev);
yyMark (yyt->MPC_Messages.Tree);
yyt = yyt->MPC_Messages.Next; break;
case kMPC_ErrorMessage:
yyMark (yyt->MPC_ErrorMessage.Prev);
yyMark (yyt->MPC_ErrorMessage.Tree);
yyt = yyt->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI:
yyMark (yyt->MPC_ErrorMessageI.Prev);
yyMark (yyt->MPC_ErrorMessageI.Tree);
yyt = yyt->MPC_ErrorMessageI.Next; break;
case kMPC_Message:
yyMark (yyt->MPC_Message.Prev);
yyMark (yyt->MPC_Message.Tree);
yyt = yyt->MPC_Message.Next; break;
case kMPC_MessageI:
yyMark (yyt->MPC_MessageI.Prev);
yyMark (yyt->MPC_MessageI.Tree);
yyt = yyt->MPC_MessageI.Next; break;
case kMPC_FreeNode:
yyt = yyt->MPC_FreeNode.Parent; break;
case kMPC_Decls:
yyMark (yyt->MPC_Decls.Prev);
yyt = yyt->MPC_Decls.Next; break;
case kMPC_UncompString:
yyMark (yyt->MPC_UncompString.Prev);
yyt = yyt->MPC_UncompString.Next; break;
case kMPC_Type:
yyMark (yyt->MPC_Type.Prev);
yyMark (yyt->MPC_Type.EquivType);
yyt = yyt->MPC_Type.Next; break;
case kMPC_BasicType:
yyMark (yyt->MPC_BasicType.Prev);
yyMark (yyt->MPC_BasicType.EquivType);
yyt = yyt->MPC_BasicType.Next; break;
case kMPC_EnumType:
yyMark (yyt->MPC_EnumType.Prev);
yyMark (yyt->MPC_EnumType.EquivType);
yyMark (yyt->MPC_EnumType.EnumList);
yyt = yyt->MPC_EnumType.Next; break;
case kMPC_Typedef:
yyMark (yyt->MPC_Typedef.Prev);
yyMark (yyt->MPC_Typedef.EquivType);
yyMark (yyt->MPC_Typedef.Type);
yyt = yyt->MPC_Typedef.Next; break;
case kMPC_DerivedType:
yyMark (yyt->MPC_DerivedType.Prev);
yyMark (yyt->MPC_DerivedType.EquivType);
yyt = yyt->MPC_DerivedType.Next; break;
case kMPC_ArrayType:
yyMark (yyt->MPC_ArrayType.Prev);
yyMark (yyt->MPC_ArrayType.EquivType);
yyMark (yyt->MPC_ArrayType.ElementType);
yyMark (yyt->MPC_ArrayType.ArraySize);
yyMark (yyt->MPC_ArrayType.DynStep);
yyt = yyt->MPC_ArrayType.Next; break;
case kMPC_VectorType:
yyMark (yyt->MPC_VectorType.Prev);
yyMark (yyt->MPC_VectorType.EquivType);
yyMark (yyt->MPC_VectorType.ElementType);
yyMark (yyt->MPC_VectorType.VectorSize);
yyt = yyt->MPC_VectorType.Next; break;
case kMPC_PointerType:
yyMark (yyt->MPC_PointerType.Prev);
yyMark (yyt->MPC_PointerType.EquivType);
yyMark (yyt->MPC_PointerType.ElementType);
yyMark (yyt->MPC_PointerType.DynStep);
yyMark (yyt->MPC_PointerType.GeneratedFrom);
yyt = yyt->MPC_PointerType.Next; break;
case kMPC_StructType:
yyMark (yyt->MPC_StructType.Prev);
yyMark (yyt->MPC_StructType.EquivType);
yyMark (yyt->MPC_StructType.MemberDecls);
yyt = yyt->MPC_StructType.Next; break;
case kMPC_UnionType:
yyMark (yyt->MPC_UnionType.Prev);
yyMark (yyt->MPC_UnionType.EquivType);
yyMark (yyt->MPC_UnionType.MemberDecls);
yyt = yyt->MPC_UnionType.Next; break;
case kMPC_FunctionType:
yyMark (yyt->MPC_FunctionType.Prev);
yyMark (yyt->MPC_FunctionType.EquivType);
yyMark (yyt->MPC_FunctionType.ResultType);
yyMark (yyt->MPC_FunctionType.NetParamType);
yyMark (yyt->MPC_FunctionType.NetParam);
yyMark (yyt->MPC_FunctionType.NetworkParamList);
yyMark (yyt->MPC_FunctionType.ParamList);
yyt = yyt->MPC_FunctionType.Next; break;
case kMPC_VarDecl:
yyMark (yyt->MPC_VarDecl.Prev);
yyMark (yyt->MPC_VarDecl.DeclSpecifier);
yyMark (yyt->MPC_VarDecl.Var);
yyt = yyt->MPC_VarDecl.Next; break;
case kMPC_Function:
yyMark (yyt->MPC_Function.Prev);
yyMark (yyt->MPC_Function.Distribution);
yyMark (yyt->MPC_Function.Name);
yyMark (yyt->MPC_Function.Type);
yyMark (yyt->MPC_Function.ParamList);
yyMark (yyt->MPC_Function.Stats);
yyMark (yyt->MPC_Function.LabelList);
yyt = yyt->MPC_Function.Next; break;
case kMPC_Ellipsis:
yyMark (yyt->MPC_Ellipsis.Prev);
yyt = yyt->MPC_Ellipsis.Next; break;
case kMPC_NetDecl:
yyMark (yyt->MPC_NetDecl.Prev);
yyMark (yyt->MPC_NetDecl.NetTypeSpecifier);
yyMark (yyt->MPC_NetDecl.Net);
yyt = yyt->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl:
yyMark (yyt->MPC_SubnetDecl.Prev);
yyMark (yyt->MPC_SubnetDecl.Subnet);
yyt = yyt->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl:
yyMark (yyt->MPC_RelDecl.Prev);
yyMark (yyt->MPC_RelDecl.Relation);
yyt = yyt->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl:
yyMark (yyt->MPC_NetTypeDecl.Prev);
yyt = yyt->MPC_NetTypeDecl.Next; break;
case kMPC_NetType:
yyMark (yyt->MPC_NetType.Prev);
yyMark (yyt->MPC_NetType.ParamList);
yyMark (yyt->MPC_NetType.CoordDecl);
yyMark (yyt->MPC_NetType.NodeDecl);
yyMark (yyt->MPC_NetType.LinkDecl);
yyMark (yyt->MPC_NetType.StartDecl);
yyMark (yyt->MPC_NetType.SchemeDecl);
yyMark (yyt->MPC_NetType.TopoFunctions);
yyt = yyt->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier:
yyMark (yyt->MPC_NetTypeSpecifier.Prev);
yyMark (yyt->MPC_NetTypeSpecifier.NetType);
yyMark (yyt->MPC_NetTypeSpecifier.ArgList);
yyt = yyt->MPC_NetTypeSpecifier.Next; break;
case kMPC_TopoFunctions:
yyMark (yyt->MPC_TopoFunctions.Node_Def);
yyMark (yyt->MPC_TopoFunctions.Link_Def);
yyMark (yyt->MPC_TopoFunctions.Main_Node_Def);
yyMark (yyt->MPC_TopoFunctions.Power_Def);
yyMark (yyt->MPC_TopoFunctions.Node_Coord_Def);
yyMark (yyt->MPC_TopoFunctions.Node_Number_Def);
yyt = yyt->MPC_TopoFunctions.Mapping_Def; break;
case kMPC_EnumConst:
yyMark (yyt->MPC_EnumConst.Prev);
yyt = yyt->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl:
yyMark (yyt->MPC_SU_MemberDecl.Prev);
yyMark (yyt->MPC_SU_MemberDecl.Member);
yyt = yyt->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member:
yyMark (yyt->MPC_SU_Member.Prev);
yyMark (yyt->MPC_SU_Member.Type);
yyMark (yyt->MPC_SU_Member.BitFieldSize);
yyt = yyt->MPC_SU_Member.Next; break;
case kMPC_Var:
yyMark (yyt->MPC_Var.Prev);
yyMark (yyt->MPC_Var.Type);
yyMark (yyt->MPC_Var.Distribution);
yyMark (yyt->MPC_Var.Init);
yyt = yyt->MPC_Var.Next; break;
case kMPC_CoordDecl:
yyMark (yyt->MPC_CoordDecl.Prev);
yyMark (yyt->MPC_CoordDecl.Range);
yyt = yyt->MPC_CoordDecl.Next; break;
case kMPC_Node:
yyMark (yyt->MPC_Node.Prev);
yyMark (yyt->MPC_Node.Predicate);
yyMark (yyt->MPC_Node.NodeQual);
yyt = yyt->MPC_Node.Next; break;
case kMPC_NodeQual:
yyt = yyt->MPC_NodeQual.CapacityExpr; break;
case kMPC_NodeTypeQual:
yyt = yyt->MPC_NodeTypeQual.CapacityExpr; break;
case kMPC_BenchQual:
yyt = yyt->MPC_BenchQual.CapacityExpr; break;
case kMPC_LinkDecl:
yyMark (yyt->MPC_LinkDecl.FreeCoord);
yyt = yyt->MPC_LinkDecl.LinkDeclaringList; break;
case kMPC_LinkDeclaringList:
yyMark (yyt->MPC_LinkDeclaringList.Prev);
yyMark (yyt->MPC_LinkDeclaringList.Predicate);
yyMark (yyt->MPC_LinkDeclaringList.LinkLengthSpecifier);
yyMark (yyt->MPC_LinkDeclaringList.LinkDeclarator);
yyt = yyt->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator:
yyMark (yyt->MPC_LinkDeclarator.Prev);
yyMark (yyt->MPC_LinkDeclarator.LeftNode);
yyMark (yyt->MPC_LinkDeclarator.RightNode);
yyt = yyt->MPC_LinkDeclarator.Next; break;
case kMPC_LinkLengthSpecifier:
yyt = yyt->MPC_LinkLengthSpecifier.LinkLengthExpr; break;
case kMPC_Scheme:
yyt = yyt->MPC_Scheme.Body; break;
case kMPC_NetList:
yyMark (yyt->MPC_NetList.Prev);
yyMark (yyt->MPC_NetList.Net);
yyt = yyt->MPC_NetList.Next; break;
case kMPC_NetOrSubnet:
yyMark (yyt->MPC_NetOrSubnet.Distribution);
yyMark (yyt->MPC_NetOrSubnet.Prev);
yyMark (yyt->MPC_NetOrSubnet.NextUse);
yyMark (yyt->MPC_NetOrSubnet.PrevUse);
yyMark (yyt->MPC_NetOrSubnet.MyList);
yyt = yyt->MPC_NetOrSubnet.Next; break;
case kMPC_Net:
yyMark (yyt->MPC_Net.Distribution);
yyMark (yyt->MPC_Net.Prev);
yyMark (yyt->MPC_Net.NextUse);
yyMark (yyt->MPC_Net.PrevUse);
yyMark (yyt->MPC_Net.MyList);
yyMark (yyt->MPC_Net.NetType);
yyt = yyt->MPC_Net.Next; break;
case kMPC_Subnet:
yyMark (yyt->MPC_Subnet.Distribution);
yyMark (yyt->MPC_Subnet.Prev);
yyMark (yyt->MPC_Subnet.NextUse);
yyMark (yyt->MPC_Subnet.PrevUse);
yyMark (yyt->MPC_Subnet.MyList);
yyMark (yyt->MPC_Subnet.Predicate);
yyt = yyt->MPC_Subnet.Next; break;
case kMPC_Relation:
yyMark (yyt->MPC_Relation.Prev);
yyMark (yyt->MPC_Relation.LNet);
yyMark (yyt->MPC_Relation.RNet);
yyt = yyt->MPC_Relation.Next; break;
case kMPC_Stats:
yyMark (yyt->MPC_Stats.Prev);
yyt = yyt->MPC_Stats.Next; break;
case kMPC_Stat:
yyMark (yyt->MPC_Stat.Prev);
yyMark (yyt->MPC_Stat.ExecNet);
yyMark (yyt->MPC_Stat.ActualExecNet);
yyMark (yyt->MPC_Stat.RootNet);
yyMark (yyt->MPC_Stat.PropNet);
yyt = yyt->MPC_Stat.Next; break;
case kMPC_ExprStat:
yyMark (yyt->MPC_ExprStat.Prev);
yyMark (yyt->MPC_ExprStat.ExecNet);
yyMark (yyt->MPC_ExprStat.ActualExecNet);
yyMark (yyt->MPC_ExprStat.RootNet);
yyMark (yyt->MPC_ExprStat.PropNet);
yyMark (yyt->MPC_ExprStat.Expr);
yyt = yyt->MPC_ExprStat.Next; break;
case kMPC_If:
yyMark (yyt->MPC_If.Prev);
yyMark (yyt->MPC_If.ExecNet);
yyMark (yyt->MPC_If.ActualExecNet);
yyMark (yyt->MPC_If.RootNet);
yyMark (yyt->MPC_If.PropNet);
yyMark (yyt->MPC_If.Expr);
yyMark (yyt->MPC_If.Stats);
yyt = yyt->MPC_If.Next; break;
case kMPC_IfElse:
yyMark (yyt->MPC_IfElse.Prev);
yyMark (yyt->MPC_IfElse.ExecNet);
yyMark (yyt->MPC_IfElse.ActualExecNet);
yyMark (yyt->MPC_IfElse.RootNet);
yyMark (yyt->MPC_IfElse.PropNet);
yyMark (yyt->MPC_IfElse.Expr);
yyMark (yyt->MPC_IfElse.Then);
yyMark (yyt->MPC_IfElse.Else);
yyt = yyt->MPC_IfElse.Next; break;
case kMPC_Switch:
yyMark (yyt->MPC_Switch.Prev);
yyMark (yyt->MPC_Switch.ExecNet);
yyMark (yyt->MPC_Switch.ActualExecNet);
yyMark (yyt->MPC_Switch.RootNet);
yyMark (yyt->MPC_Switch.PropNet);
yyMark (yyt->MPC_Switch.Expr);
yyMark (yyt->MPC_Switch.Stats);
yyt = yyt->MPC_Switch.Next; break;
case kMPC_While:
yyMark (yyt->MPC_While.Prev);
yyMark (yyt->MPC_While.ExecNet);
yyMark (yyt->MPC_While.ActualExecNet);
yyMark (yyt->MPC_While.RootNet);
yyMark (yyt->MPC_While.PropNet);
yyMark (yyt->MPC_While.Expr);
yyMark (yyt->MPC_While.Stats);
yyt = yyt->MPC_While.Next; break;
case kMPC_DoWhile:
yyMark (yyt->MPC_DoWhile.Prev);
yyMark (yyt->MPC_DoWhile.ExecNet);
yyMark (yyt->MPC_DoWhile.ActualExecNet);
yyMark (yyt->MPC_DoWhile.RootNet);
yyMark (yyt->MPC_DoWhile.PropNet);
yyMark (yyt->MPC_DoWhile.Stats);
yyMark (yyt->MPC_DoWhile.Expr);
yyt = yyt->MPC_DoWhile.Next; break;
case kMPC_For:
yyMark (yyt->MPC_For.Prev);
yyMark (yyt->MPC_For.ExecNet);
yyMark (yyt->MPC_For.ActualExecNet);
yyMark (yyt->MPC_For.RootNet);
yyMark (yyt->MPC_For.PropNet);
yyMark (yyt->MPC_For.Init);
yyMark (yyt->MPC_For.Cond);
yyMark (yyt->MPC_For.Reinit);
yyMark (yyt->MPC_For.Stats);
yyt = yyt->MPC_For.Next; break;
case kMPC_Goto:
yyMark (yyt->MPC_Goto.Prev);
yyMark (yyt->MPC_Goto.ExecNet);
yyMark (yyt->MPC_Goto.ActualExecNet);
yyMark (yyt->MPC_Goto.RootNet);
yyMark (yyt->MPC_Goto.PropNet);
yyMark (yyt->MPC_Goto.LabelDef);
yyMark (yyt->MPC_Goto.NextUse);
yyMark (yyt->MPC_Goto.PrevUse);
yyt = yyt->MPC_Goto.Next; break;
case kMPC_Continue:
yyMark (yyt->MPC_Continue.Prev);
yyMark (yyt->MPC_Continue.ExecNet);
yyMark (yyt->MPC_Continue.ActualExecNet);
yyMark (yyt->MPC_Continue.RootNet);
yyMark (yyt->MPC_Continue.PropNet);
yyt = yyt->MPC_Continue.Next; break;
case kMPC_Break:
yyMark (yyt->MPC_Break.Prev);
yyMark (yyt->MPC_Break.ExecNet);
yyMark (yyt->MPC_Break.ActualExecNet);
yyMark (yyt->MPC_Break.RootNet);
yyMark (yyt->MPC_Break.PropNet);
yyt = yyt->MPC_Break.Next; break;
case kMPC_BreakFan:
yyMark (yyt->MPC_BreakFan.Prev);
yyMark (yyt->MPC_BreakFan.ExecNet);
yyMark (yyt->MPC_BreakFan.ActualExecNet);
yyMark (yyt->MPC_BreakFan.RootNet);
yyMark (yyt->MPC_BreakFan.PropNet);
yyt = yyt->MPC_BreakFan.Next; break;
case kMPC_Return:
yyMark (yyt->MPC_Return.Prev);
yyMark (yyt->MPC_Return.ExecNet);
yyMark (yyt->MPC_Return.ActualExecNet);
yyMark (yyt->MPC_Return.RootNet);
yyMark (yyt->MPC_Return.PropNet);
yyMark (yyt->MPC_Return.Expr);
yyt = yyt->MPC_Return.Next; break;
case kMPC_Compound:
yyMark (yyt->MPC_Compound.Prev);
yyMark (yyt->MPC_Compound.ExecNet);
yyMark (yyt->MPC_Compound.ActualExecNet);
yyMark (yyt->MPC_Compound.RootNet);
yyMark (yyt->MPC_Compound.PropNet);
yyMark (yyt->MPC_Compound.Decls);
yyMark (yyt->MPC_Compound.Stats);
yyt = yyt->MPC_Compound.Next; break;
case kMPC_CompScheme:
yyMark (yyt->MPC_CompScheme.Prev);
yyMark (yyt->MPC_CompScheme.ExecNet);
yyMark (yyt->MPC_CompScheme.ActualExecNet);
yyMark (yyt->MPC_CompScheme.RootNet);
yyMark (yyt->MPC_CompScheme.PropNet);
yyMark (yyt->MPC_CompScheme.Expr);
yyMark (yyt->MPC_CompScheme.Node);
yyt = yyt->MPC_CompScheme.Next; break;
case kMPC_CommScheme:
yyMark (yyt->MPC_CommScheme.Prev);
yyMark (yyt->MPC_CommScheme.ExecNet);
yyMark (yyt->MPC_CommScheme.ActualExecNet);
yyMark (yyt->MPC_CommScheme.RootNet);
yyMark (yyt->MPC_CommScheme.PropNet);
yyMark (yyt->MPC_CommScheme.Expr);
yyMark (yyt->MPC_CommScheme.From);
yyMark (yyt->MPC_CommScheme.To);
yyt = yyt->MPC_CommScheme.Next; break;
case kMPC_ParScheme:
yyMark (yyt->MPC_ParScheme.Prev);
yyMark (yyt->MPC_ParScheme.ExecNet);
yyMark (yyt->MPC_ParScheme.ActualExecNet);
yyMark (yyt->MPC_ParScheme.RootNet);
yyMark (yyt->MPC_ParScheme.PropNet);
yyMark (yyt->MPC_ParScheme.Init);
yyMark (yyt->MPC_ParScheme.Cond);
yyMark (yyt->MPC_ParScheme.Reinit);
yyMark (yyt->MPC_ParScheme.Stats);
yyt = yyt->MPC_ParScheme.Next; break;
case kMPC_Fan:
yyMark (yyt->MPC_Fan.Prev);
yyMark (yyt->MPC_Fan.ExecNet);
yyMark (yyt->MPC_Fan.ActualExecNet);
yyMark (yyt->MPC_Fan.RootNet);
yyMark (yyt->MPC_Fan.PropNet);
yyMark (yyt->MPC_Fan.Body);
yyt = yyt->MPC_Fan.Next; break;
case kMPC_Label:
yyMark (yyt->MPC_Label.Prev);
yyMark (yyt->MPC_Label.NextLabel);
yyMark (yyt->MPC_Label.PrevLabel);
yyt = yyt->MPC_Label.Next; break;
case kMPC_IdentLabel:
yyMark (yyt->MPC_IdentLabel.Prev);
yyMark (yyt->MPC_IdentLabel.NextLabel);
yyMark (yyt->MPC_IdentLabel.PrevLabel);
yyMark (yyt->MPC_IdentLabel.NextUse);
yyt = yyt->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel:
yyMark (yyt->MPC_CaseLabel.Prev);
yyMark (yyt->MPC_CaseLabel.NextLabel);
yyMark (yyt->MPC_CaseLabel.PrevLabel);
yyMark (yyt->MPC_CaseLabel.Expr);
yyt = yyt->MPC_CaseLabel.Next; break;
case kMPC_Default:
yyMark (yyt->MPC_Default.Prev);
yyMark (yyt->MPC_Default.NextLabel);
yyMark (yyt->MPC_Default.PrevLabel);
yyt = yyt->MPC_Default.Next; break;
case kMPC_Expr:
yyMark (yyt->MPC_Expr.Type);
yyMark (yyt->MPC_Expr.EvalNet);
yyMark (yyt->MPC_Expr.StoreNet);
yyt = yyt->MPC_Expr.ActualEvalNet; break;
case kMPC_Const:
yyMark (yyt->MPC_Const.Type);
yyMark (yyt->MPC_Const.EvalNet);
yyMark (yyt->MPC_Const.StoreNet);
yyt = yyt->MPC_Const.ActualEvalNet; break;
case kMPC_IntConst:
yyMark (yyt->MPC_IntConst.Type);
yyMark (yyt->MPC_IntConst.EvalNet);
yyMark (yyt->MPC_IntConst.StoreNet);
yyt = yyt->MPC_IntConst.ActualEvalNet; break;
case kMPC_UIntConst:
yyMark (yyt->MPC_UIntConst.Type);
yyMark (yyt->MPC_UIntConst.EvalNet);
yyMark (yyt->MPC_UIntConst.StoreNet);
yyt = yyt->MPC_UIntConst.ActualEvalNet; break;
case kMPC_FloatConst:
yyMark (yyt->MPC_FloatConst.Type);
yyMark (yyt->MPC_FloatConst.EvalNet);
yyMark (yyt->MPC_FloatConst.StoreNet);
yyt = yyt->MPC_FloatConst.ActualEvalNet; break;
case kMPC_StringLiteral:
yyMark (yyt->MPC_StringLiteral.Type);
yyMark (yyt->MPC_StringLiteral.EvalNet);
yyMark (yyt->MPC_StringLiteral.StoreNet);
yyMark (yyt->MPC_StringLiteral.ActualEvalNet);
yyMark (yyt->MPC_StringLiteral.Prev);
yyt = yyt->MPC_StringLiteral.Next; break;
case kMPC_Ident:
yyMark (yyt->MPC_Ident.Type);
yyMark (yyt->MPC_Ident.EvalNet);
yyMark (yyt->MPC_Ident.StoreNet);
yyMark (yyt->MPC_Ident.ActualEvalNet);
yyMark (yyt->MPC_Ident.Store);
yyMark (yyt->MPC_Ident.NextUse);
yyt = yyt->MPC_Ident.PrevUse; break;
case kMPC_CastExpr:
yyMark (yyt->MPC_CastExpr.Type);
yyMark (yyt->MPC_CastExpr.EvalNet);
yyMark (yyt->MPC_CastExpr.StoreNet);
yyMark (yyt->MPC_CastExpr.ActualEvalNet);
yyMark (yyt->MPC_CastExpr.TypeName);
yyt = yyt->MPC_CastExpr.Operand; break;
case kMPC_NetCastExpr:
yyMark (yyt->MPC_NetCastExpr.Type);
yyMark (yyt->MPC_NetCastExpr.EvalNet);
yyMark (yyt->MPC_NetCastExpr.StoreNet);
yyMark (yyt->MPC_NetCastExpr.ActualEvalNet);
yyt = yyt->MPC_NetCastExpr.Operand; break;
case kMPC_CoordExpr:
yyMark (yyt->MPC_CoordExpr.Type);
yyMark (yyt->MPC_CoordExpr.EvalNet);
yyMark (yyt->MPC_CoordExpr.StoreNet);
yyMark (yyt->MPC_CoordExpr.ActualEvalNet);
yyt = yyt->MPC_CoordExpr.Operand; break;
case kMPC_SizeofExpr:
yyMark (yyt->MPC_SizeofExpr.Type);
yyMark (yyt->MPC_SizeofExpr.EvalNet);
yyMark (yyt->MPC_SizeofExpr.StoreNet);
yyt = yyt->MPC_SizeofExpr.ActualEvalNet; break;
case kMPC_Size_Of_Value:
yyMark (yyt->MPC_Size_Of_Value.Type);
yyMark (yyt->MPC_Size_Of_Value.EvalNet);
yyMark (yyt->MPC_Size_Of_Value.StoreNet);
yyMark (yyt->MPC_Size_Of_Value.ActualEvalNet);
yyt = yyt->MPC_Size_Of_Value.Operand; break;
case kMPC_Size_Of_Type:
yyMark (yyt->MPC_Size_Of_Type.Type);
yyMark (yyt->MPC_Size_Of_Type.EvalNet);
yyMark (yyt->MPC_Size_Of_Type.StoreNet);
yyMark (yyt->MPC_Size_Of_Type.ActualEvalNet);
yyt = yyt->MPC_Size_Of_Type.Operand; break;
case kMPC_TimeofExpr:
yyMark (yyt->MPC_TimeofExpr.Type);
yyMark (yyt->MPC_TimeofExpr.EvalNet);
yyMark (yyt->MPC_TimeofExpr.StoreNet);
yyMark (yyt->MPC_TimeofExpr.ActualEvalNet);
yyt = yyt->MPC_TimeofExpr.NetDecl; break;
case kMPC_UnaryExpr:
yyMark (yyt->MPC_UnaryExpr.Type);
yyMark (yyt->MPC_UnaryExpr.EvalNet);
yyMark (yyt->MPC_UnaryExpr.StoreNet);
yyMark (yyt->MPC_UnaryExpr.ActualEvalNet);
yyt = yyt->MPC_UnaryExpr.Operand; break;
case kMPC_BinaryExpr:
yyMark (yyt->MPC_BinaryExpr.Type);
yyMark (yyt->MPC_BinaryExpr.EvalNet);
yyMark (yyt->MPC_BinaryExpr.StoreNet);
yyMark (yyt->MPC_BinaryExpr.ActualEvalNet);
yyMark (yyt->MPC_BinaryExpr.Loperand);
yyt = yyt->MPC_BinaryExpr.Roperand; break;
case kMPC_TernaryExpr:
yyMark (yyt->MPC_TernaryExpr.Type);
yyMark (yyt->MPC_TernaryExpr.EvalNet);
yyMark (yyt->MPC_TernaryExpr.StoreNet);
yyMark (yyt->MPC_TernaryExpr.ActualEvalNet);
yyMark (yyt->MPC_TernaryExpr.Foperand);
yyMark (yyt->MPC_TernaryExpr.Soperand);
yyt = yyt->MPC_TernaryExpr.Toperand; break;
case kMPC_QuaternaryExpr:
yyMark (yyt->MPC_QuaternaryExpr.Type);
yyMark (yyt->MPC_QuaternaryExpr.EvalNet);
yyMark (yyt->MPC_QuaternaryExpr.StoreNet);
yyMark (yyt->MPC_QuaternaryExpr.ActualEvalNet);
yyMark (yyt->MPC_QuaternaryExpr.Operand1);
yyMark (yyt->MPC_QuaternaryExpr.Operand2);
yyMark (yyt->MPC_QuaternaryExpr.Operand3);
yyt = yyt->MPC_QuaternaryExpr.Operand4; break;
case kMPC_CallExpr:
yyMark (yyt->MPC_CallExpr.Type);
yyMark (yyt->MPC_CallExpr.EvalNet);
yyMark (yyt->MPC_CallExpr.StoreNet);
yyMark (yyt->MPC_CallExpr.ActualEvalNet);
yyMark (yyt->MPC_CallExpr.Function);
yyMark (yyt->MPC_CallExpr.ArgList);
yyt = yyt->MPC_CallExpr.NetworkArgList; break;
case kMPC_Exprs:
yyMark (yyt->MPC_Exprs.Prev);
yyMark (yyt->MPC_Exprs.Expr);
yyt = yyt->MPC_Exprs.Next; break;
case kMPC_Initializer:
yyMark (yyt->MPC_Initializer.Prev);
yyt = yyt->MPC_Initializer.Next; break;
case kMPC_SimpleInit:
yyMark (yyt->MPC_SimpleInit.Prev);
yyMark (yyt->MPC_SimpleInit.Expr);
yyt = yyt->MPC_SimpleInit.Next; break;
case kMPC_InitList:
yyMark (yyt->MPC_InitList.Prev);
yyMark (yyt->MPC_InitList.List);
yyt = yyt->MPC_InitList.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tTree yyTreeStore [yyInitTreeStoreSize];
static tTree * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static Tree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteTree ARGS((tTree yyt));

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static short yyIndentLevel;

void WriteTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tTree yyt)
# else
 (yys, yyt) char * yys; tTree yyt;
# endif
{ yyIndentSelector (yys); writetTree (yyt) }

static void yWriteMPC_Root
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Root], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Decls", yyt->MPC_Root.Decls);
 yyIndentSelectorTree ("Source", yyt->MPC_Root.Source);
 yyIndentSelectorTree ("Messages", yyt->MPC_Root.Messages);
 yyIndentSelectorTree ("Host", yyt->MPC_Root.Host);
 yyIndentSelectorTree ("SingleNode", yyt->MPC_Root.SingleNode);
 yyIndentSelectorTree ("ComputingSpace", yyt->MPC_Root.ComputingSpace);
 yyIndentSelectorTree ("Const", yyt->MPC_Root.Const);
 yyIndentSelectorTree ("Recon", yyt->MPC_Root.Recon);
 yyIndentSelectorTree ("HostList", yyt->MPC_Root.HostList);
 yyIndentSelectorTree ("SingleNodeList", yyt->MPC_Root.SingleNodeList);
 yyIndentSelectorTree ("ComputingSpaceList", yyt->MPC_Root.ComputingSpaceList);
 yyIndentSelectorTree ("ConstList", yyt->MPC_Root.ConstList);
}

static void yWriteMPC_Source
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Source], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("FileName"); writetString (yyt->MPC_Source.FileName) yyWriteNl ();
 yyIndentSelector ("VirtPos"); writetPosition (yyt->MPC_Source.VirtPos) yyWriteNl ();
 yyIndentSelector ("RealPos"); writetPosition (yyt->MPC_Source.RealPos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Source.Prev);
}

static void yWriteMPC_Messages
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Messages], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ErrorClass"); writeint (yyt->MPC_Messages.ErrorClass) yyWriteNl ();
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Messages.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Messages.Prev);
 yyIndentSelectorTree ("Tree", yyt->MPC_Messages.Tree);
}

static void yWriteMPC_ErrorMessage
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_ErrorMessage], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ErrorClass"); writeint (yyt->MPC_ErrorMessage.ErrorClass) yyWriteNl ();
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_ErrorMessage.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_ErrorMessage.Prev);
 yyIndentSelectorTree ("Tree", yyt->MPC_ErrorMessage.Tree);
 yyIndentSelector ("ErrorCode"); writeint (yyt->MPC_ErrorMessage.ErrorCode) yyWriteNl ();
}

static void yWriteMPC_ErrorMessageI
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_ErrorMessageI], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ErrorClass"); writeint (yyt->MPC_ErrorMessageI.ErrorClass) yyWriteNl ();
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_ErrorMessageI.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_ErrorMessageI.Prev);
 yyIndentSelectorTree ("Tree", yyt->MPC_ErrorMessageI.Tree);
 yyIndentSelector ("ErrorCode"); writeint (yyt->MPC_ErrorMessageI.ErrorCode) yyWriteNl ();
 yyIndentSelector ("InfoClass"); writeint (yyt->MPC_ErrorMessageI.InfoClass) yyWriteNl ();
 yyIndentSelector ("Info"); writetString (yyt->MPC_ErrorMessageI.Info) yyWriteNl ();
}

static void yWriteMPC_Message
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Message], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ErrorClass"); writeint (yyt->MPC_Message.ErrorClass) yyWriteNl ();
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Message.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Message.Prev);
 yyIndentSelectorTree ("Tree", yyt->MPC_Message.Tree);
 yyIndentSelector ("MessageNumber"); writeshort (yyt->MPC_Message.MessageNumber) yyWriteNl ();
}

static void yWriteMPC_MessageI
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_MessageI], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("ErrorClass"); writeint (yyt->MPC_MessageI.ErrorClass) yyWriteNl ();
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_MessageI.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_MessageI.Prev);
 yyIndentSelectorTree ("Tree", yyt->MPC_MessageI.Tree);
 yyIndentSelector ("MessageNumber"); writeshort (yyt->MPC_MessageI.MessageNumber) yyWriteNl ();
 yyIndentSelector ("InfoClass"); writeint (yyt->MPC_MessageI.InfoClass) yyWriteNl ();
 yyIndentSelector ("Info"); writetString (yyt->MPC_MessageI.Info) yyWriteNl ();
}

static void yWriteMPC_FreeNode
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_FreeNode], yyf); (void) fputc ('\n', yyf);
}

static void yWriteMPC_Decls
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Decls], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Decls.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Decls.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Decls.EndPos) yyWriteNl ();
}

static void yWriteMPC_UncompString
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_UncompString], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_UncompString.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_UncompString.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_UncompString.EndPos) yyWriteNl ();
 yyIndentSelector ("uString"); writetString (yyt->MPC_UncompString.uString) yyWriteNl ();
}

static void yWriteMPC_Type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Type], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Type.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Type.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Type.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_Type.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_Type.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Type.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_Type.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_Type.pType) yyWriteNl ();
}

static void yWriteMPC_BasicType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_BasicType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_BasicType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_BasicType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_BasicType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_BasicType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_BasicType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_BasicType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_BasicType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_BasicType.pType) yyWriteNl ();
 yyIndentSelector ("TypeConstructor"); writeshort (yyt->MPC_BasicType.TypeConstructor) yyWriteNl ();
}

static void yWriteMPC_EnumType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_EnumType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_EnumType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_EnumType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_EnumType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_EnumType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_EnumType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_EnumType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_EnumType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_EnumType.pType) yyWriteNl ();
 yyIndentSelector ("EnumTag"); writetIdent (yyt->MPC_EnumType.EnumTag) yyWriteNl ();
 yyIndentSelectorTree ("EnumList", yyt->MPC_EnumType.EnumList);
}

static void yWriteMPC_Typedef
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Typedef], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Typedef.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Typedef.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Typedef.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_Typedef.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_Typedef.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Typedef.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_Typedef.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_Typedef.pType) yyWriteNl ();
 yyIndentSelector ("TypedefName"); writetIdent (yyt->MPC_Typedef.TypedefName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Typedef.Type);
}

static void yWriteMPC_DerivedType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_DerivedType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_DerivedType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_DerivedType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_DerivedType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_DerivedType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_DerivedType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_DerivedType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_DerivedType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_DerivedType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_DerivedType.NumberOfComponents) yyWriteNl ();
}

static void yWriteMPC_ArrayType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_ArrayType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_ArrayType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_ArrayType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_ArrayType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_ArrayType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_ArrayType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_ArrayType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_ArrayType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_ArrayType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_ArrayType.NumberOfComponents) yyWriteNl ();
 yyIndentSelector ("Step"); writeshort (yyt->MPC_ArrayType.Step) yyWriteNl ();
 yyIndentSelectorTree ("ElementType", yyt->MPC_ArrayType.ElementType);
 yyIndentSelectorTree ("ArraySize", yyt->MPC_ArrayType.ArraySize);
 yyIndentSelectorTree ("DynStep", yyt->MPC_ArrayType.DynStep);
}

static void yWriteMPC_VectorType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_VectorType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_VectorType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_VectorType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_VectorType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_VectorType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_VectorType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_VectorType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_VectorType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_VectorType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_VectorType.NumberOfComponents) yyWriteNl ();
 yyIndentSelectorTree ("ElementType", yyt->MPC_VectorType.ElementType);
 yyIndentSelectorTree ("VectorSize", yyt->MPC_VectorType.VectorSize);
}

static void yWriteMPC_PointerType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_PointerType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_PointerType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_PointerType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_PointerType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_PointerType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_PointerType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_PointerType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_PointerType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_PointerType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_PointerType.NumberOfComponents) yyWriteNl ();
 yyIndentSelector ("Step"); writeshort (yyt->MPC_PointerType.Step) yyWriteNl ();
 yyIndentSelectorTree ("ElementType", yyt->MPC_PointerType.ElementType);
 yyIndentSelectorTree ("DynStep", yyt->MPC_PointerType.DynStep);
 yyIndentSelectorTree ("GeneratedFrom", yyt->MPC_PointerType.GeneratedFrom);
}

static void yWriteMPC_StructType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_StructType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_StructType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_StructType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_StructType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_StructType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_StructType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_StructType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_StructType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_StructType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_StructType.NumberOfComponents) yyWriteNl ();
 yyIndentSelector ("SU_Tag"); writetIdent (yyt->MPC_StructType.SU_Tag) yyWriteNl ();
 yyIndentSelectorTree ("MemberDecls", yyt->MPC_StructType.MemberDecls);
}

static void yWriteMPC_UnionType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_UnionType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_UnionType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_UnionType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_UnionType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_UnionType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_UnionType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_UnionType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_UnionType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_UnionType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_UnionType.NumberOfComponents) yyWriteNl ();
 yyIndentSelector ("SU_Tag"); writetIdent (yyt->MPC_UnionType.SU_Tag) yyWriteNl ();
 yyIndentSelectorTree ("MemberDecls", yyt->MPC_UnionType.MemberDecls);
}

static void yWriteMPC_FunctionType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_FunctionType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_FunctionType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_FunctionType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_FunctionType.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetTypeFlags (yyt->MPC_FunctionType.Flag) yyWriteNl ();
 yyIndentSelector ("Buffer"); writebool (yyt->MPC_FunctionType.Buffer) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_FunctionType.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("EquivType", yyt->MPC_FunctionType.EquivType);
 yyIndentSelector ("pType"); writepVoid (yyt->MPC_FunctionType.pType) yyWriteNl ();
 yyIndentSelector ("NumberOfComponents"); writeint (yyt->MPC_FunctionType.NumberOfComponents) yyWriteNl ();
 yyIndentSelector ("Kind"); writeshort (yyt->MPC_FunctionType.Kind) yyWriteNl ();
 yyIndentSelectorTree ("ResultType", yyt->MPC_FunctionType.ResultType);
 yyIndentSelectorTree ("NetParamType", yyt->MPC_FunctionType.NetParamType);
 yyIndentSelectorTree ("NetParam", yyt->MPC_FunctionType.NetParam);
 yyIndentSelectorTree ("NetworkParamList", yyt->MPC_FunctionType.NetworkParamList);
 yyIndentSelectorTree ("ParamList", yyt->MPC_FunctionType.ParamList);
}

static void yWriteMPC_VarDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_VarDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_VarDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_VarDecl.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_VarDecl.EndPos) yyWriteNl ();
 yyIndentSelector ("Class"); writetClass (yyt->MPC_VarDecl.Class) yyWriteNl ();
 yyIndentSelector ("Flag"); writetDeclFlags (yyt->MPC_VarDecl.Flag) yyWriteNl ();
 yyIndentSelectorTree ("DeclSpecifier", yyt->MPC_VarDecl.DeclSpecifier);
 yyIndentSelectorTree ("Var", yyt->MPC_VarDecl.Var);
}

static void yWriteMPC_Function
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Function], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Function.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Function.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Function.EndPos) yyWriteNl ();
 yyIndentSelector ("Kind"); writeshort (yyt->MPC_Function.Kind) yyWriteNl ();
 yyIndentSelector ("Flag"); writetDeclFlags (yyt->MPC_Function.Flag) yyWriteNl ();
 yyIndentSelectorTree ("Distribution", yyt->MPC_Function.Distribution);
 yyIndentSelectorTree ("Name", yyt->MPC_Function.Name);
 yyIndentSelectorTree ("Type", yyt->MPC_Function.Type);
 yyIndentSelectorTree ("ParamList", yyt->MPC_Function.ParamList);
 yyIndentSelectorTree ("Stats", yyt->MPC_Function.Stats);
 yyIndentSelectorTree ("LabelList", yyt->MPC_Function.LabelList);
}

static void yWriteMPC_Ellipsis
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Ellipsis], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Ellipsis.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Ellipsis.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Ellipsis.EndPos) yyWriteNl ();
}

static void yWriteMPC_NetDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_NetDecl.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetDecl.EndPos) yyWriteNl ();
 yyIndentSelector ("NetClass"); writetClass (yyt->MPC_NetDecl.NetClass) yyWriteNl ();
 yyIndentSelector ("Flag"); writetDeclFlags (yyt->MPC_NetDecl.Flag) yyWriteNl ();
 yyIndentSelectorTree ("NetTypeSpecifier", yyt->MPC_NetDecl.NetTypeSpecifier);
 yyIndentSelectorTree ("Net", yyt->MPC_NetDecl.Net);
}

static void yWriteMPC_SubnetDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_SubnetDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_SubnetDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_SubnetDecl.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_SubnetDecl.EndPos) yyWriteNl ();
 yyIndentSelector ("SubnetClass"); writetClass (yyt->MPC_SubnetDecl.SubnetClass) yyWriteNl ();
 yyIndentSelector ("Flag"); writetDeclFlags (yyt->MPC_SubnetDecl.Flag) yyWriteNl ();
 yyIndentSelectorTree ("Subnet", yyt->MPC_SubnetDecl.Subnet);
}

static void yWriteMPC_RelDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_RelDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_RelDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_RelDecl.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_RelDecl.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("Relation", yyt->MPC_RelDecl.Relation);
}

static void yWriteMPC_NetTypeDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetTypeDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetTypeDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_NetTypeDecl.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetTypeDecl.EndPos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_NetTypeDecl.Ident) yyWriteNl ();
}

static void yWriteMPC_NetType
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetType], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetType.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_NetType.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetType.EndPos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_NetType.Ident) yyWriteNl ();
 yyIndentSelector ("Class"); writetClass (yyt->MPC_NetType.Class) yyWriteNl ();
 yyIndentSelectorTree ("ParamList", yyt->MPC_NetType.ParamList);
 yyIndentSelectorTree ("CoordDecl", yyt->MPC_NetType.CoordDecl);
 yyIndentSelectorTree ("NodeDecl", yyt->MPC_NetType.NodeDecl);
 yyIndentSelectorTree ("LinkDecl", yyt->MPC_NetType.LinkDecl);
 yyIndentSelectorTree ("StartDecl", yyt->MPC_NetType.StartDecl);
 yyIndentSelectorTree ("SchemeDecl", yyt->MPC_NetType.SchemeDecl);
 yyIndentSelector ("Bench"); writebool (yyt->MPC_NetType.Bench) yyWriteNl ();
 yyIndentSelectorTree ("TopoFunctions", yyt->MPC_NetType.TopoFunctions);
}

static void yWriteMPC_NetTypeSpecifier
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetTypeSpecifier], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetTypeSpecifier.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_NetTypeSpecifier.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetTypeSpecifier.EndPos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_NetTypeSpecifier.Ident) yyWriteNl ();
 yyIndentSelectorTree ("NetType", yyt->MPC_NetTypeSpecifier.NetType);
 yyIndentSelectorTree ("ArgList", yyt->MPC_NetTypeSpecifier.ArgList);
}

static void yWriteMPC_TopoFunctions
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_TopoFunctions], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Node_Def", yyt->MPC_TopoFunctions.Node_Def);
 yyIndentSelectorTree ("Link_Def", yyt->MPC_TopoFunctions.Link_Def);
 yyIndentSelectorTree ("Main_Node_Def", yyt->MPC_TopoFunctions.Main_Node_Def);
 yyIndentSelectorTree ("Power_Def", yyt->MPC_TopoFunctions.Power_Def);
 yyIndentSelectorTree ("Node_Coord_Def", yyt->MPC_TopoFunctions.Node_Coord_Def);
 yyIndentSelectorTree ("Node_Number_Def", yyt->MPC_TopoFunctions.Node_Number_Def);
}

static void yWriteMPC_EnumConst
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_EnumConst], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_EnumConst.Pos) yyWriteNl ();
 yyIndentSelector ("Name"); writetIdent (yyt->MPC_EnumConst.Name) yyWriteNl ();
 yyIndentSelector ("WithValue"); writebool (yyt->MPC_EnumConst.WithValue) yyWriteNl ();
 yyIndentSelector ("Value"); writeint (yyt->MPC_EnumConst.Value) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_EnumConst.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_EnumConst.EndPos) yyWriteNl ();
}

static void yWriteMPC_SU_MemberDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_SU_MemberDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_SU_MemberDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_SU_MemberDecl.Prev);
 yyIndentSelectorTree ("Member", yyt->MPC_SU_MemberDecl.Member);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_SU_MemberDecl.EndPos) yyWriteNl ();
}

static void yWriteMPC_SU_Member
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_SU_Member], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_SU_Member.Pos) yyWriteNl ();
 yyIndentSelector ("Name"); writetIdent (yyt->MPC_SU_Member.Name) yyWriteNl ();
 yyIndentSelector ("BitFieldLength"); writeshort (yyt->MPC_SU_Member.BitFieldLength) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_SU_Member.Prev);
 yyIndentSelectorTree ("Type", yyt->MPC_SU_Member.Type);
 yyIndentSelectorTree ("BitFieldSize", yyt->MPC_SU_Member.BitFieldSize);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_SU_Member.EndPos) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_SU_Member.UniqueNumber) yyWriteNl ();
}

static void yWriteMPC_Var
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Var], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Var.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_Var.Ident) yyWriteNl ();
 yyIndentSelector ("Flag"); writetDeclFlags (yyt->MPC_Var.Flag) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Var.Prev);
 yyIndentSelectorTree ("Type", yyt->MPC_Var.Type);
 yyIndentSelectorTree ("Distribution", yyt->MPC_Var.Distribution);
 yyIndentSelectorTree ("Init", yyt->MPC_Var.Init);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Var.EndPos) yyWriteNl ();
}

static void yWriteMPC_CoordDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CoordDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CoordDecl.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_CoordDecl.Ident) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_CoordDecl.Prev);
 yyIndentSelectorTree ("Range", yyt->MPC_CoordDecl.Range);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CoordDecl.EndPos) yyWriteNl ();
 yyIndentSelector ("CoordNumber"); writeshort (yyt->MPC_CoordDecl.CoordNumber) yyWriteNl ();
}

static void yWriteMPC_Node
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Node], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Node.Pos) yyWriteNl ();
 yyIndentSelector ("NodeType"); writetNodeType (yyt->MPC_Node.NodeType) yyWriteNl ();
 yyIndentSelector ("DynamicType"); writebool (yyt->MPC_Node.DynamicType) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Node.Prev);
 yyIndentSelectorTree ("Predicate", yyt->MPC_Node.Predicate);
 yyIndentSelectorTree ("NodeQual", yyt->MPC_Node.NodeQual);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Node.EndPos) yyWriteNl ();
}

static void yWriteMPC_NodeQual
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NodeQual], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NodeQual.Pos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NodeQual.EndPos) yyWriteNl ();
}

static void yWriteMPC_NodeTypeQual
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NodeTypeQual], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NodeTypeQual.Pos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NodeTypeQual.EndPos) yyWriteNl ();
 yyIndentSelector ("Fast"); writebool (yyt->MPC_NodeTypeQual.Fast) yyWriteNl ();
 yyIndentSelector ("Capacity"); writeint (yyt->MPC_NodeTypeQual.Capacity) yyWriteNl ();
}

static void yWriteMPC_BenchQual
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_BenchQual], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_BenchQual.Pos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_BenchQual.EndPos) yyWriteNl ();
 yyIndentSelector ("Capacity"); writedouble (yyt->MPC_BenchQual.Capacity) yyWriteNl ();
}

static void yWriteMPC_LinkDecl
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_LinkDecl], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_LinkDecl.Pos) yyWriteNl ();
 yyIndentSelectorTree ("FreeCoord", yyt->MPC_LinkDecl.FreeCoord);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_LinkDecl.EndPos) yyWriteNl ();
}

static void yWriteMPC_LinkDeclaringList
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_LinkDeclaringList], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_LinkDeclaringList.Pos) yyWriteNl ();
 yyIndentSelector ("LinkType"); writetLinkType (yyt->MPC_LinkDeclaringList.LinkType) yyWriteNl ();
 yyIndentSelector ("DynamicLength"); writebool (yyt->MPC_LinkDeclaringList.DynamicLength) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_LinkDeclaringList.Prev);
 yyIndentSelectorTree ("Predicate", yyt->MPC_LinkDeclaringList.Predicate);
 yyIndentSelectorTree ("LinkLengthSpecifier", yyt->MPC_LinkDeclaringList.LinkLengthSpecifier);
 yyIndentSelectorTree ("LinkDeclarator", yyt->MPC_LinkDeclaringList.LinkDeclarator);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_LinkDeclaringList.EndPos) yyWriteNl ();
}

static void yWriteMPC_LinkDeclarator
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_LinkDeclarator], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_LinkDeclarator.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_LinkDeclarator.Prev);
 yyIndentSelectorTree ("LeftNode", yyt->MPC_LinkDeclarator.LeftNode);
 yyIndentSelectorTree ("RightNode", yyt->MPC_LinkDeclarator.RightNode);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_LinkDeclarator.EndPos) yyWriteNl ();
}

static void yWriteMPC_LinkLengthSpecifier
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_LinkLengthSpecifier], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_LinkLengthSpecifier.Pos) yyWriteNl ();
 yyIndentSelector ("LinkLength"); writetLinkType (yyt->MPC_LinkLengthSpecifier.LinkLength) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_LinkLengthSpecifier.EndPos) yyWriteNl ();
}

static void yWriteMPC_Scheme
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Scheme], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Scheme.Pos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Scheme.EndPos) yyWriteNl ();
}

static void yWriteMPC_NetList
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetList], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Prev", yyt->MPC_NetList.Prev);
 yyIndentSelectorTree ("Net", yyt->MPC_NetList.Net);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetList.Pos) yyWriteNl ();
 yyIndentSelector ("UnReduceable"); writebool (yyt->MPC_NetList.UnReduceable) yyWriteNl ();
}

static void yWriteMPC_NetOrSubnet
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetOrSubnet], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetOrSubnet.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_NetOrSubnet.Ident) yyWriteNl ();
 yyIndentSelector ("BigCreate"); writebool (yyt->MPC_NetOrSubnet.BigCreate) yyWriteNl ();
 yyIndentSelectorTree ("Distribution", yyt->MPC_NetOrSubnet.Distribution);
 yyIndentSelectorTree ("Prev", yyt->MPC_NetOrSubnet.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetOrSubnet.EndPos) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_NetOrSubnet.UniqueNumber) yyWriteNl ();
 yyIndentSelector ("WithNumber"); writebool (yyt->MPC_NetOrSubnet.WithNumber) yyWriteNl ();
 yyIndentSelector ("SingleNode"); writebool (yyt->MPC_NetOrSubnet.SingleNode) yyWriteNl ();
 yyIndentSelector ("IsParent"); writebool (yyt->MPC_NetOrSubnet.IsParent) yyWriteNl ();
 yyIndentSelector ("pGen"); writepVoid (yyt->MPC_NetOrSubnet.pGen) yyWriteNl ();
 yyIndentSelectorTree ("NextUse", yyt->MPC_NetOrSubnet.NextUse);
 yyIndentSelectorTree ("PrevUse", yyt->MPC_NetOrSubnet.PrevUse);
 yyIndentSelectorTree ("MyList", yyt->MPC_NetOrSubnet.MyList);
}

static void yWriteMPC_Net
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Net], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Net.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_Net.Ident) yyWriteNl ();
 yyIndentSelector ("BigCreate"); writebool (yyt->MPC_Net.BigCreate) yyWriteNl ();
 yyIndentSelectorTree ("Distribution", yyt->MPC_Net.Distribution);
 yyIndentSelectorTree ("Prev", yyt->MPC_Net.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Net.EndPos) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Net.UniqueNumber) yyWriteNl ();
 yyIndentSelector ("WithNumber"); writebool (yyt->MPC_Net.WithNumber) yyWriteNl ();
 yyIndentSelector ("SingleNode"); writebool (yyt->MPC_Net.SingleNode) yyWriteNl ();
 yyIndentSelector ("IsParent"); writebool (yyt->MPC_Net.IsParent) yyWriteNl ();
 yyIndentSelector ("pGen"); writepVoid (yyt->MPC_Net.pGen) yyWriteNl ();
 yyIndentSelectorTree ("NextUse", yyt->MPC_Net.NextUse);
 yyIndentSelectorTree ("PrevUse", yyt->MPC_Net.PrevUse);
 yyIndentSelectorTree ("MyList", yyt->MPC_Net.MyList);
 yyIndentSelector ("Topology"); writeshort (yyt->MPC_Net.Topology) yyWriteNl ();
 yyIndentSelectorTree ("NetType", yyt->MPC_Net.NetType);
}

static void yWriteMPC_Subnet
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Subnet], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Subnet.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_Subnet.Ident) yyWriteNl ();
 yyIndentSelector ("BigCreate"); writebool (yyt->MPC_Subnet.BigCreate) yyWriteNl ();
 yyIndentSelectorTree ("Distribution", yyt->MPC_Subnet.Distribution);
 yyIndentSelectorTree ("Prev", yyt->MPC_Subnet.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Subnet.EndPos) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Subnet.UniqueNumber) yyWriteNl ();
 yyIndentSelector ("WithNumber"); writebool (yyt->MPC_Subnet.WithNumber) yyWriteNl ();
 yyIndentSelector ("SingleNode"); writebool (yyt->MPC_Subnet.SingleNode) yyWriteNl ();
 yyIndentSelector ("IsParent"); writebool (yyt->MPC_Subnet.IsParent) yyWriteNl ();
 yyIndentSelector ("pGen"); writepVoid (yyt->MPC_Subnet.pGen) yyWriteNl ();
 yyIndentSelectorTree ("NextUse", yyt->MPC_Subnet.NextUse);
 yyIndentSelectorTree ("PrevUse", yyt->MPC_Subnet.PrevUse);
 yyIndentSelectorTree ("MyList", yyt->MPC_Subnet.MyList);
 yyIndentSelector ("NetOrSubnetName"); writetIdent (yyt->MPC_Subnet.NetOrSubnetName) yyWriteNl ();
 yyIndentSelector ("Flexible"); writebool (yyt->MPC_Subnet.Flexible) yyWriteNl ();
 yyIndentSelectorTree ("Predicate", yyt->MPC_Subnet.Predicate);
}

static void yWriteMPC_Relation
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Relation], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Relation.Pos) yyWriteNl ();
 yyIndentSelector ("RelCode"); writeint (yyt->MPC_Relation.RelCode) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Relation.Prev);
 yyIndentSelectorTree ("LNet", yyt->MPC_Relation.LNet);
 yyIndentSelectorTree ("RNet", yyt->MPC_Relation.RNet);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Relation.EndPos) yyWriteNl ();
}

static void yWriteMPC_Stats
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Stats], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Stats.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Stats.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Stats.EndPos) yyWriteNl ();
}

static void yWriteMPC_Stat
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Stat], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Stat.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Stat.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Stat.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Stat.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Stat.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Stat.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Stat.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Stat.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Stat.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Stat.UniqueNumber) yyWriteNl ();
}

static void yWriteMPC_ExprStat
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_ExprStat], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_ExprStat.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_ExprStat.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_ExprStat.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_ExprStat.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_ExprStat.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_ExprStat.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_ExprStat.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_ExprStat.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_ExprStat.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_ExprStat.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_ExprStat.Expr);
}

static void yWriteMPC_If
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_If], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_If.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_If.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_If.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_If.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_If.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_If.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_If.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_If.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_If.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_If.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_If.Expr);
 yyIndentSelectorTree ("Stats", yyt->MPC_If.Stats);
}

static void yWriteMPC_IfElse
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_IfElse], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_IfElse.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_IfElse.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_IfElse.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_IfElse.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_IfElse.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_IfElse.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_IfElse.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_IfElse.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_IfElse.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_IfElse.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_IfElse.Expr);
 yyIndentSelectorTree ("Then", yyt->MPC_IfElse.Then);
 yyIndentSelectorTree ("Else", yyt->MPC_IfElse.Else);
}

static void yWriteMPC_Switch
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Switch], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Switch.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Switch.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Switch.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Switch.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Switch.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Switch.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Switch.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Switch.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Switch.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Switch.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_Switch.Expr);
 yyIndentSelectorTree ("Stats", yyt->MPC_Switch.Stats);
}

static void yWriteMPC_While
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_While], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_While.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_While.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_While.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_While.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_While.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_While.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_While.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_While.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_While.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_While.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_While.Expr);
 yyIndentSelectorTree ("Stats", yyt->MPC_While.Stats);
}

static void yWriteMPC_DoWhile
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_DoWhile], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_DoWhile.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_DoWhile.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_DoWhile.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_DoWhile.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_DoWhile.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_DoWhile.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_DoWhile.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_DoWhile.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_DoWhile.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_DoWhile.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Stats", yyt->MPC_DoWhile.Stats);
 yyIndentSelectorTree ("Expr", yyt->MPC_DoWhile.Expr);
}

static void yWriteMPC_For
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_For], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_For.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_For.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_For.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_For.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_For.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_For.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_For.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_For.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_For.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_For.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Init", yyt->MPC_For.Init);
 yyIndentSelectorTree ("Cond", yyt->MPC_For.Cond);
 yyIndentSelectorTree ("Reinit", yyt->MPC_For.Reinit);
 yyIndentSelectorTree ("Stats", yyt->MPC_For.Stats);
}

static void yWriteMPC_Goto
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Goto], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Goto.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Goto.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Goto.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Goto.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Goto.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Goto.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Goto.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Goto.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Goto.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Goto.UniqueNumber) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_Goto.Ident) yyWriteNl ();
 yyIndentSelectorTree ("LabelDef", yyt->MPC_Goto.LabelDef);
 yyIndentSelectorTree ("NextUse", yyt->MPC_Goto.NextUse);
 yyIndentSelectorTree ("PrevUse", yyt->MPC_Goto.PrevUse);
}

static void yWriteMPC_Continue
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Continue], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Continue.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Continue.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Continue.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Continue.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Continue.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Continue.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Continue.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Continue.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Continue.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Continue.UniqueNumber) yyWriteNl ();
}

static void yWriteMPC_Break
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Break], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Break.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Break.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Break.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Break.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Break.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Break.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Break.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Break.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Break.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Break.UniqueNumber) yyWriteNl ();
}

static void yWriteMPC_BreakFan
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_BreakFan], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_BreakFan.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_BreakFan.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_BreakFan.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_BreakFan.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_BreakFan.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_BreakFan.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_BreakFan.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_BreakFan.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_BreakFan.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_BreakFan.UniqueNumber) yyWriteNl ();
}

static void yWriteMPC_Return
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Return], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Return.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Return.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Return.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Return.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Return.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Return.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Return.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Return.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Return.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Return.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_Return.Expr);
}

static void yWriteMPC_Compound
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Compound], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Compound.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Compound.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Compound.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Compound.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Compound.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Compound.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Compound.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Compound.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Compound.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Compound.UniqueNumber) yyWriteNl ();
 yyIndentSelector ("FunctionBody"); writeint (yyt->MPC_Compound.FunctionBody) yyWriteNl ();
 yyIndentSelectorTree ("Decls", yyt->MPC_Compound.Decls);
 yyIndentSelectorTree ("Stats", yyt->MPC_Compound.Stats);
}

static void yWriteMPC_CompScheme
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CompScheme], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CompScheme.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_CompScheme.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CompScheme.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_CompScheme.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_CompScheme.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_CompScheme.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_CompScheme.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_CompScheme.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_CompScheme.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_CompScheme.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_CompScheme.Expr);
 yyIndentSelectorTree ("Node", yyt->MPC_CompScheme.Node);
}

static void yWriteMPC_CommScheme
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CommScheme], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CommScheme.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_CommScheme.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CommScheme.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_CommScheme.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_CommScheme.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_CommScheme.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_CommScheme.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_CommScheme.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_CommScheme.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_CommScheme.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_CommScheme.Expr);
 yyIndentSelectorTree ("From", yyt->MPC_CommScheme.From);
 yyIndentSelectorTree ("To", yyt->MPC_CommScheme.To);
}

static void yWriteMPC_ParScheme
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_ParScheme], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_ParScheme.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_ParScheme.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_ParScheme.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_ParScheme.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_ParScheme.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_ParScheme.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_ParScheme.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_ParScheme.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_ParScheme.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_ParScheme.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Init", yyt->MPC_ParScheme.Init);
 yyIndentSelectorTree ("Cond", yyt->MPC_ParScheme.Cond);
 yyIndentSelectorTree ("Reinit", yyt->MPC_ParScheme.Reinit);
 yyIndentSelectorTree ("Stats", yyt->MPC_ParScheme.Stats);
}

static void yWriteMPC_Fan
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Fan], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Fan.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Fan.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Fan.EndPos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetStatFlags (yyt->MPC_Fan.Flag) yyWriteNl ();
 yyIndentSelectorTree ("ExecNet", yyt->MPC_Fan.ExecNet);
 yyIndentSelectorTree ("ActualExecNet", yyt->MPC_Fan.ActualExecNet);
 yyIndentSelectorTree ("RootNet", yyt->MPC_Fan.RootNet);
 yyIndentSelectorTree ("PropNet", yyt->MPC_Fan.PropNet);
 yyIndentSelector ("Benchmark"); writebool (yyt->MPC_Fan.Benchmark) yyWriteNl ();
 yyIndentSelector ("UniqueNumber"); writeMPC_unsigned_short (yyt->MPC_Fan.UniqueNumber) yyWriteNl ();
 yyIndentSelectorTree ("Body", yyt->MPC_Fan.Body);
}

static void yWriteMPC_Label
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Label], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Label.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Label.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Label.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("NextLabel", yyt->MPC_Label.NextLabel);
 yyIndentSelectorTree ("PrevLabel", yyt->MPC_Label.PrevLabel);
}

static void yWriteMPC_IdentLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_IdentLabel], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_IdentLabel.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_IdentLabel.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_IdentLabel.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("NextLabel", yyt->MPC_IdentLabel.NextLabel);
 yyIndentSelectorTree ("PrevLabel", yyt->MPC_IdentLabel.PrevLabel);
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_IdentLabel.Ident) yyWriteNl ();
 yyIndentSelectorTree ("NextUse", yyt->MPC_IdentLabel.NextUse);
 yyIndentSelector ("Used"); writebool (yyt->MPC_IdentLabel.Used) yyWriteNl ();
}

static void yWriteMPC_CaseLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CaseLabel], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CaseLabel.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_CaseLabel.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CaseLabel.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("NextLabel", yyt->MPC_CaseLabel.NextLabel);
 yyIndentSelectorTree ("PrevLabel", yyt->MPC_CaseLabel.PrevLabel);
 yyIndentSelector ("CaseValue"); writelong (yyt->MPC_CaseLabel.CaseValue) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_CaseLabel.Expr);
}

static void yWriteMPC_Default
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Default], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Default.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Default.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Default.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("NextLabel", yyt->MPC_Default.NextLabel);
 yyIndentSelectorTree ("PrevLabel", yyt->MPC_Default.PrevLabel);
}

static void yWriteMPC_Expr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Expr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Expr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_Expr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_Expr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Expr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_Expr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_Expr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Expr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Expr.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_Expr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_Expr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_Expr.Optm_Attribute) yyWriteNl ();
}

static void yWriteMPC_Const
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Const], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Const.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_Const.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_Const.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Const.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_Const.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_Const.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Const.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Const.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_Const.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_Const.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_Const.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("SymbolicForm"); writetString (yyt->MPC_Const.SymbolicForm) yyWriteNl ();
}

static void yWriteMPC_IntConst
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_IntConst], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_IntConst.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_IntConst.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_IntConst.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_IntConst.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_IntConst.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_IntConst.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_IntConst.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_IntConst.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_IntConst.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_IntConst.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_IntConst.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("SymbolicForm"); writetString (yyt->MPC_IntConst.SymbolicForm) yyWriteNl ();
 yyIndentSelector ("Value"); writelong (yyt->MPC_IntConst.Value) yyWriteNl ();
}

static void yWriteMPC_UIntConst
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_UIntConst], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_UIntConst.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_UIntConst.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_UIntConst.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_UIntConst.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_UIntConst.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_UIntConst.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_UIntConst.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_UIntConst.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_UIntConst.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_UIntConst.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_UIntConst.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("SymbolicForm"); writetString (yyt->MPC_UIntConst.SymbolicForm) yyWriteNl ();
 yyIndentSelector ("Value"); writeMPC_long_unsigned (yyt->MPC_UIntConst.Value) yyWriteNl ();
}

static void yWriteMPC_FloatConst
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_FloatConst], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_FloatConst.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_FloatConst.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_FloatConst.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_FloatConst.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_FloatConst.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_FloatConst.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_FloatConst.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_FloatConst.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_FloatConst.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_FloatConst.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_FloatConst.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("SymbolicForm"); writetString (yyt->MPC_FloatConst.SymbolicForm) yyWriteNl ();
 yyIndentSelector ("Value"); writeMPC_long_double (yyt->MPC_FloatConst.Value) yyWriteNl ();
}

static void yWriteMPC_StringLiteral
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_StringLiteral], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_StringLiteral.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_StringLiteral.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_StringLiteral.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_StringLiteral.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_StringLiteral.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_StringLiteral.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_StringLiteral.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_StringLiteral.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_StringLiteral.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_StringLiteral.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_StringLiteral.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_StringLiteral.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("String"); writetString (yyt->MPC_StringLiteral.String) yyWriteNl ();
 yyIndentSelector ("FullSize"); writeshort (yyt->MPC_StringLiteral.FullSize) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_StringLiteral.Prev);
}

static void yWriteMPC_Ident
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Ident], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Ident.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_Ident.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_Ident.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Ident.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_Ident.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_Ident.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Ident.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Ident.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_Ident.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_Ident.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_Ident.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_Ident.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->MPC_Ident.Ident) yyWriteNl ();
 yyIndentSelectorTree ("Store", yyt->MPC_Ident.Store);
 yyIndentSelectorTree ("NextUse", yyt->MPC_Ident.NextUse);
}

static void yWriteMPC_CastExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CastExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CastExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_CastExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_CastExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_CastExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_CastExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_CastExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_CastExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CastExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_CastExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_CastExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_CastExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_CastExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelectorTree ("TypeName", yyt->MPC_CastExpr.TypeName);
}

static void yWriteMPC_NetCastExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_NetCastExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_NetCastExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_NetCastExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_NetCastExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_NetCastExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_NetCastExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_NetCastExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_NetCastExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_NetCastExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_NetCastExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_NetCastExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_NetCastExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_NetCastExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("Flexible"); writebool (yyt->MPC_NetCastExpr.Flexible) yyWriteNl ();
 yyIndentSelector ("ExprPtr"); writepVoid (yyt->MPC_NetCastExpr.ExprPtr) yyWriteNl ();
}

static void yWriteMPC_CoordExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CoordExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CoordExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_CoordExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_CoordExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_CoordExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_CoordExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_CoordExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_CoordExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CoordExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_CoordExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_CoordExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_CoordExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_CoordExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("CoordName"); writetIdent (yyt->MPC_CoordExpr.CoordName) yyWriteNl ();
 yyIndentSelector ("CoordNumber"); writeshort (yyt->MPC_CoordExpr.CoordNumber) yyWriteNl ();
}

static void yWriteMPC_SizeofExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_SizeofExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_SizeofExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_SizeofExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_SizeofExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_SizeofExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_SizeofExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_SizeofExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_SizeofExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_SizeofExpr.EndPos) yyWriteNl ();
 yyIndentSelector ("Pass"); writechar (yyt->MPC_SizeofExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_SizeofExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_SizeofExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("CompileTime"); writebool (yyt->MPC_SizeofExpr.CompileTime) yyWriteNl ();
 yyIndentSelector ("Value"); writeint (yyt->MPC_SizeofExpr.Value) yyWriteNl ();
}

static void yWriteMPC_Size_Of_Value
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Size_Of_Value], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Size_Of_Value.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_Size_Of_Value.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_Size_Of_Value.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Size_Of_Value.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_Size_Of_Value.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_Size_Of_Value.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Size_Of_Value.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Size_Of_Value.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_Size_Of_Value.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_Size_Of_Value.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_Size_Of_Value.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_Size_Of_Value.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("CompileTime"); writebool (yyt->MPC_Size_Of_Value.CompileTime) yyWriteNl ();
 yyIndentSelector ("Value"); writeint (yyt->MPC_Size_Of_Value.Value) yyWriteNl ();
}

static void yWriteMPC_Size_Of_Type
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Size_Of_Type], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Size_Of_Type.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_Size_Of_Type.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_Size_Of_Type.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_Size_Of_Type.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_Size_Of_Type.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_Size_Of_Type.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Size_Of_Type.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Size_Of_Type.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_Size_Of_Type.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_Size_Of_Type.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_Size_Of_Type.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_Size_Of_Type.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("CompileTime"); writebool (yyt->MPC_Size_Of_Type.CompileTime) yyWriteNl ();
 yyIndentSelector ("Value"); writeint (yyt->MPC_Size_Of_Type.Value) yyWriteNl ();
}

static void yWriteMPC_TimeofExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_TimeofExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_TimeofExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_TimeofExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_TimeofExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_TimeofExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_TimeofExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_TimeofExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_TimeofExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_TimeofExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_TimeofExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_TimeofExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_TimeofExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_TimeofExpr.Optm_Attribute) yyWriteNl ();
}

static void yWriteMPC_UnaryExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_UnaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_UnaryExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_UnaryExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_UnaryExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_UnaryExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_UnaryExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_UnaryExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_UnaryExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_UnaryExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_UnaryExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_UnaryExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_UnaryExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_UnaryExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("OpCode"); writeshort (yyt->MPC_UnaryExpr.OpCode) yyWriteNl ();
}

static void yWriteMPC_BinaryExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_BinaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_BinaryExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_BinaryExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_BinaryExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_BinaryExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_BinaryExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_BinaryExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_BinaryExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_BinaryExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_BinaryExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_BinaryExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_BinaryExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_BinaryExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("OpCode"); writeshort (yyt->MPC_BinaryExpr.OpCode) yyWriteNl ();
 yyIndentSelectorTree ("Loperand", yyt->MPC_BinaryExpr.Loperand);
}

static void yWriteMPC_TernaryExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_TernaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_TernaryExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_TernaryExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_TernaryExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_TernaryExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_TernaryExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_TernaryExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_TernaryExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_TernaryExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_TernaryExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_TernaryExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_TernaryExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_TernaryExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("OpCode"); writeshort (yyt->MPC_TernaryExpr.OpCode) yyWriteNl ();
 yyIndentSelectorTree ("Foperand", yyt->MPC_TernaryExpr.Foperand);
 yyIndentSelectorTree ("Soperand", yyt->MPC_TernaryExpr.Soperand);
}

static void yWriteMPC_QuaternaryExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_QuaternaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_QuaternaryExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_QuaternaryExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_QuaternaryExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_QuaternaryExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_QuaternaryExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_QuaternaryExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_QuaternaryExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_QuaternaryExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_QuaternaryExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_QuaternaryExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_QuaternaryExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_QuaternaryExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelector ("OpCode"); writeshort (yyt->MPC_QuaternaryExpr.OpCode) yyWriteNl ();
 yyIndentSelectorTree ("Operand1", yyt->MPC_QuaternaryExpr.Operand1);
 yyIndentSelectorTree ("Operand2", yyt->MPC_QuaternaryExpr.Operand2);
 yyIndentSelectorTree ("Operand3", yyt->MPC_QuaternaryExpr.Operand3);
}

static void yWriteMPC_CallExpr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_CallExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_CallExpr.Pos) yyWriteNl ();
 yyIndentSelector ("Flag"); writetExprFlags (yyt->MPC_CallExpr.Flag) yyWriteNl ();
 yyIndentSelector ("TmpName"); writetString (yyt->MPC_CallExpr.TmpName) yyWriteNl ();
 yyIndentSelectorTree ("Type", yyt->MPC_CallExpr.Type);
 yyIndentSelectorTree ("EvalNet", yyt->MPC_CallExpr.EvalNet);
 yyIndentSelectorTree ("StoreNet", yyt->MPC_CallExpr.StoreNet);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_CallExpr.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_CallExpr.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("ActualEvalNet", yyt->MPC_CallExpr.ActualEvalNet);
 yyIndentSelector ("Pass"); writechar (yyt->MPC_CallExpr.Pass) yyWriteNl ();
 yyIndentSelector ("Repl"); writebool (yyt->MPC_CallExpr.Repl) yyWriteNl ();
 yyIndentSelector ("Optm_Attribute"); writetOptm_Attribute (yyt->MPC_CallExpr.Optm_Attribute) yyWriteNl ();
 yyIndentSelectorTree ("Function", yyt->MPC_CallExpr.Function);
 yyIndentSelectorTree ("ArgList", yyt->MPC_CallExpr.ArgList);
}

static void yWriteMPC_Exprs
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Exprs], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Exprs.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Exprs.Prev);
 yyIndentSelectorTree ("Expr", yyt->MPC_Exprs.Expr);
 yyIndentSelector ("BegPos"); writetPosition (yyt->MPC_Exprs.BegPos) yyWriteNl ();
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Exprs.EndPos) yyWriteNl ();
}

static void yWriteMPC_Initializer
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_Initializer], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_Initializer.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_Initializer.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_Initializer.EndPos) yyWriteNl ();
}

static void yWriteMPC_SimpleInit
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_SimpleInit], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_SimpleInit.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_SimpleInit.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_SimpleInit.EndPos) yyWriteNl ();
 yyIndentSelectorTree ("Expr", yyt->MPC_SimpleInit.Expr);
}

static void yWriteMPC_InitList
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMPC_InitList], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writetPosition (yyt->MPC_InitList.Pos) yyWriteNl ();
 yyIndentSelectorTree ("Prev", yyt->MPC_InitList.Prev);
 yyIndentSelector ("EndPos"); writetPosition (yyt->MPC_InitList.EndPos) yyWriteNl ();
 yyIndentSelector ("Length"); writeint (yyt->MPC_InitList.Length) yyWriteNl ();
 yyIndentSelectorTree ("List", yyt->MPC_InitList.List);
}

static void yyWriteTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoTree) { (void) fputs (" NoTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kMPC_AstNode: (void) fputs (Tree_NodeName [kMPC_AstNode], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kMPC_Root: yWriteMPC_Root (yyt); yyIndentSelector ("ReconList"); yyt = yyt->MPC_Root.ReconList; break;
case kMPC_Source: yWriteMPC_Source (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Source.Next; break;
case kMPC_Messages: yWriteMPC_Messages (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Messages.Next; break;
case kMPC_ErrorMessage: yWriteMPC_ErrorMessage (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI: yWriteMPC_ErrorMessageI (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_ErrorMessageI.Next; break;
case kMPC_Message: yWriteMPC_Message (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Message.Next; break;
case kMPC_MessageI: yWriteMPC_MessageI (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_MessageI.Next; break;
case kMPC_FreeNode: yWriteMPC_FreeNode (yyt); yyIndentSelector ("Parent"); yyt = yyt->MPC_FreeNode.Parent; break;
case kMPC_Decls: yWriteMPC_Decls (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Decls.Next; break;
case kMPC_UncompString: yWriteMPC_UncompString (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_UncompString.Next; break;
case kMPC_Type: yWriteMPC_Type (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Type.Next; break;
case kMPC_BasicType: yWriteMPC_BasicType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_BasicType.Next; break;
case kMPC_EnumType: yWriteMPC_EnumType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_EnumType.Next; break;
case kMPC_Typedef: yWriteMPC_Typedef (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Typedef.Next; break;
case kMPC_DerivedType: yWriteMPC_DerivedType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_DerivedType.Next; break;
case kMPC_ArrayType: yWriteMPC_ArrayType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_ArrayType.Next; break;
case kMPC_VectorType: yWriteMPC_VectorType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_VectorType.Next; break;
case kMPC_PointerType: yWriteMPC_PointerType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_PointerType.Next; break;
case kMPC_StructType: yWriteMPC_StructType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_StructType.Next; break;
case kMPC_UnionType: yWriteMPC_UnionType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_UnionType.Next; break;
case kMPC_FunctionType: yWriteMPC_FunctionType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_FunctionType.Next; break;
case kMPC_VarDecl: yWriteMPC_VarDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_VarDecl.Next; break;
case kMPC_Function: yWriteMPC_Function (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Function.Next; break;
case kMPC_Ellipsis: yWriteMPC_Ellipsis (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Ellipsis.Next; break;
case kMPC_NetDecl: yWriteMPC_NetDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl: yWriteMPC_SubnetDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl: yWriteMPC_RelDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl: yWriteMPC_NetTypeDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetTypeDecl.Next; break;
case kMPC_NetType: yWriteMPC_NetType (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier: yWriteMPC_NetTypeSpecifier (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetTypeSpecifier.Next; break;
case kMPC_TopoFunctions: yWriteMPC_TopoFunctions (yyt); yyIndentSelector ("Mapping_Def"); yyt = yyt->MPC_TopoFunctions.Mapping_Def; break;
case kMPC_EnumConst: yWriteMPC_EnumConst (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl: yWriteMPC_SU_MemberDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member: yWriteMPC_SU_Member (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_SU_Member.Next; break;
case kMPC_Var: yWriteMPC_Var (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Var.Next; break;
case kMPC_CoordDecl: yWriteMPC_CoordDecl (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_CoordDecl.Next; break;
case kMPC_Node: yWriteMPC_Node (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Node.Next; break;
case kMPC_NodeQual: yWriteMPC_NodeQual (yyt); yyIndentSelector ("CapacityExpr"); yyt = yyt->MPC_NodeQual.CapacityExpr; break;
case kMPC_NodeTypeQual: yWriteMPC_NodeTypeQual (yyt); yyIndentSelector ("CapacityExpr"); yyt = yyt->MPC_NodeTypeQual.CapacityExpr; break;
case kMPC_BenchQual: yWriteMPC_BenchQual (yyt); yyIndentSelector ("CapacityExpr"); yyt = yyt->MPC_BenchQual.CapacityExpr; break;
case kMPC_LinkDecl: yWriteMPC_LinkDecl (yyt); yyIndentSelector ("LinkDeclaringList"); yyt = yyt->MPC_LinkDecl.LinkDeclaringList; break;
case kMPC_LinkDeclaringList: yWriteMPC_LinkDeclaringList (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator: yWriteMPC_LinkDeclarator (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_LinkDeclarator.Next; break;
case kMPC_LinkLengthSpecifier: yWriteMPC_LinkLengthSpecifier (yyt); yyIndentSelector ("LinkLengthExpr"); yyt = yyt->MPC_LinkLengthSpecifier.LinkLengthExpr; break;
case kMPC_Scheme: yWriteMPC_Scheme (yyt); yyIndentSelector ("Body"); yyt = yyt->MPC_Scheme.Body; break;
case kMPC_NetList: yWriteMPC_NetList (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetList.Next; break;
case kMPC_NetOrSubnet: yWriteMPC_NetOrSubnet (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_NetOrSubnet.Next; break;
case kMPC_Net: yWriteMPC_Net (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Net.Next; break;
case kMPC_Subnet: yWriteMPC_Subnet (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Subnet.Next; break;
case kMPC_Relation: yWriteMPC_Relation (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Relation.Next; break;
case kMPC_Stats: yWriteMPC_Stats (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Stats.Next; break;
case kMPC_Stat: yWriteMPC_Stat (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Stat.Next; break;
case kMPC_ExprStat: yWriteMPC_ExprStat (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_ExprStat.Next; break;
case kMPC_If: yWriteMPC_If (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_If.Next; break;
case kMPC_IfElse: yWriteMPC_IfElse (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_IfElse.Next; break;
case kMPC_Switch: yWriteMPC_Switch (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Switch.Next; break;
case kMPC_While: yWriteMPC_While (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_While.Next; break;
case kMPC_DoWhile: yWriteMPC_DoWhile (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_DoWhile.Next; break;
case kMPC_For: yWriteMPC_For (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_For.Next; break;
case kMPC_Goto: yWriteMPC_Goto (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Goto.Next; break;
case kMPC_Continue: yWriteMPC_Continue (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Continue.Next; break;
case kMPC_Break: yWriteMPC_Break (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Break.Next; break;
case kMPC_BreakFan: yWriteMPC_BreakFan (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_BreakFan.Next; break;
case kMPC_Return: yWriteMPC_Return (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Return.Next; break;
case kMPC_Compound: yWriteMPC_Compound (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Compound.Next; break;
case kMPC_CompScheme: yWriteMPC_CompScheme (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_CompScheme.Next; break;
case kMPC_CommScheme: yWriteMPC_CommScheme (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_CommScheme.Next; break;
case kMPC_ParScheme: yWriteMPC_ParScheme (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_ParScheme.Next; break;
case kMPC_Fan: yWriteMPC_Fan (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Fan.Next; break;
case kMPC_Label: yWriteMPC_Label (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Label.Next; break;
case kMPC_IdentLabel: yWriteMPC_IdentLabel (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel: yWriteMPC_CaseLabel (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_CaseLabel.Next; break;
case kMPC_Default: yWriteMPC_Default (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Default.Next; break;
case kMPC_Expr: yWriteMPC_Expr (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_Expr.ActualEvalNet; break;
case kMPC_Const: yWriteMPC_Const (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_Const.ActualEvalNet; break;
case kMPC_IntConst: yWriteMPC_IntConst (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_IntConst.ActualEvalNet; break;
case kMPC_UIntConst: yWriteMPC_UIntConst (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_UIntConst.ActualEvalNet; break;
case kMPC_FloatConst: yWriteMPC_FloatConst (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_FloatConst.ActualEvalNet; break;
case kMPC_StringLiteral: yWriteMPC_StringLiteral (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_StringLiteral.Next; break;
case kMPC_Ident: yWriteMPC_Ident (yyt); yyIndentSelector ("PrevUse"); yyt = yyt->MPC_Ident.PrevUse; break;
case kMPC_CastExpr: yWriteMPC_CastExpr (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_CastExpr.Operand; break;
case kMPC_NetCastExpr: yWriteMPC_NetCastExpr (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_NetCastExpr.Operand; break;
case kMPC_CoordExpr: yWriteMPC_CoordExpr (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_CoordExpr.Operand; break;
case kMPC_SizeofExpr: yWriteMPC_SizeofExpr (yyt); yyIndentSelector ("ActualEvalNet"); yyt = yyt->MPC_SizeofExpr.ActualEvalNet; break;
case kMPC_Size_Of_Value: yWriteMPC_Size_Of_Value (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_Size_Of_Value.Operand; break;
case kMPC_Size_Of_Type: yWriteMPC_Size_Of_Type (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_Size_Of_Type.Operand; break;
case kMPC_TimeofExpr: yWriteMPC_TimeofExpr (yyt); yyIndentSelector ("NetDecl"); yyt = yyt->MPC_TimeofExpr.NetDecl; break;
case kMPC_UnaryExpr: yWriteMPC_UnaryExpr (yyt); yyIndentSelector ("Operand"); yyt = yyt->MPC_UnaryExpr.Operand; break;
case kMPC_BinaryExpr: yWriteMPC_BinaryExpr (yyt); yyIndentSelector ("Roperand"); yyt = yyt->MPC_BinaryExpr.Roperand; break;
case kMPC_TernaryExpr: yWriteMPC_TernaryExpr (yyt); yyIndentSelector ("Toperand"); yyt = yyt->MPC_TernaryExpr.Toperand; break;
case kMPC_QuaternaryExpr: yWriteMPC_QuaternaryExpr (yyt); yyIndentSelector ("Operand4"); yyt = yyt->MPC_QuaternaryExpr.Operand4; break;
case kMPC_CallExpr: yWriteMPC_CallExpr (yyt); yyIndentSelector ("NetworkArgList"); yyt = yyt->MPC_CallExpr.NetworkArgList; break;
case kMPC_Exprs: yWriteMPC_Exprs (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Exprs.Next; break;
case kMPC_Initializer: yWriteMPC_Initializer (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_Initializer.Next; break;
case kMPC_SimpleInit: yWriteMPC_SimpleInit (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_SimpleInit.Next; break;
case kMPC_InitList: yWriteMPC_InitList (yyt); yyIndentSelector ("Next"); yyt = yyt->MPC_InitList.Next; break;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

static tIdent yyKindToIdent [97 + 1];
static bool yyIsInitialized = false;

static short yyMapToKind
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyk;
 register tIdent yyi = MakeIdent ((tString) yys, strlen (yys));
 for (yyk = 0; yyk <= 97; yyk ++) {
  if (yyKindToIdent [yyk] == yyi) return yyk;
 }
 return 0;
}

static void yyReadNl () { (void) fscanf (yyf, "\n"); }

static tIdent yyReadIdent ()
{
 char yys [256];
 yys [0] = fgetc (yyf); ungetc (yys [0], yyf);
 if (yys [0] == '\n') return NoIdent;
 (void) fscanf (yyf, "%s", yys);
 return MakeIdent ((tString) yys, strlen (yys));
}

static void yyReadHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{
 register int yyi; int yyk;
 for (yyi = 0; yyi < yysize; yyi ++) { (void) fscanf (yyf, "%x ", & yyk); yyx [yyi] = yyk; }
}

static void yySkip () { (void) fscanf (yyf, " %*s =%*c"); }

static void yyReadTree
# if defined __STDC__ | defined __cplusplus
 (yyPtrtTree yyt)
# else
 (yyt) yyPtrtTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 static Tree_tKind yyKind;
 static char yys [256];
 for (;;) {
  switch (getc (yyf)) {
  case '^': (void) fscanf (yyf, "%hd\n", & yyLabel); * yyt = yyMapToTree (yyLabel); return;
  case '\n': case '0': (void) fscanf (yyf, "%hd%*c %s\n", & yyLabel, yys);
   yyKind = yyMapToKind (yys); * yyt = MakeTree (yyKind);
   if (yyLabel != yyMapToLabel (* yyt)) { (void) fputs ("Tree: error in ReadTree\n", stderr); Tree_Exit (); } break;
  default: ;
   (void) fscanf (yyf, "%s", yys);
   yyKind = yyMapToKind (yys);
   if (yyKind == 0) { * yyt = NoTree; return; }
   * yyt = MakeTree (yyKind);
  }

  switch (yyKind) {
case kMPC_Root:
yySkip (); readtTree (& ((* yyt)->MPC_Root.Decls))
yySkip (); readtTree (& ((* yyt)->MPC_Root.Source))
yySkip (); readtTree (& ((* yyt)->MPC_Root.Messages))
yySkip (); readtTree (& ((* yyt)->MPC_Root.Host))
yySkip (); readtTree (& ((* yyt)->MPC_Root.SingleNode))
yySkip (); readtTree (& ((* yyt)->MPC_Root.ComputingSpace))
yySkip (); readtTree (& ((* yyt)->MPC_Root.Const))
yySkip (); readtTree (& ((* yyt)->MPC_Root.Recon))
yySkip (); readtTree (& ((* yyt)->MPC_Root.HostList))
yySkip (); readtTree (& ((* yyt)->MPC_Root.SingleNodeList))
yySkip (); readtTree (& ((* yyt)->MPC_Root.ComputingSpaceList))
yySkip (); readtTree (& ((* yyt)->MPC_Root.ConstList))
yySkip (); yyt = & ((* yyt)->MPC_Root.ReconList); break;
case kMPC_Source:
yySkip (); readtString ((* yyt)->MPC_Source.FileName) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Source.VirtPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Source.RealPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Source.Prev))
yySkip (); yyt = & ((* yyt)->MPC_Source.Next); break;
case kMPC_Messages:
yySkip (); readint ((* yyt)->MPC_Messages.ErrorClass) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Messages.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Messages.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Messages.Tree))
yySkip (); yyt = & ((* yyt)->MPC_Messages.Next); break;
case kMPC_ErrorMessage:
yySkip (); readint ((* yyt)->MPC_ErrorMessage.ErrorClass) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_ErrorMessage.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ErrorMessage.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_ErrorMessage.Tree))
yySkip (); readint ((* yyt)->MPC_ErrorMessage.ErrorCode) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_ErrorMessage.Next); break;
case kMPC_ErrorMessageI:
yySkip (); readint ((* yyt)->MPC_ErrorMessageI.ErrorClass) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_ErrorMessageI.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ErrorMessageI.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_ErrorMessageI.Tree))
yySkip (); readint ((* yyt)->MPC_ErrorMessageI.ErrorCode) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_ErrorMessageI.InfoClass) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_ErrorMessageI.Info) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_ErrorMessageI.Next); break;
case kMPC_Message:
yySkip (); readint ((* yyt)->MPC_Message.ErrorClass) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Message.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Message.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Message.Tree))
yySkip (); readshort ((* yyt)->MPC_Message.MessageNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Message.Next); break;
case kMPC_MessageI:
yySkip (); readint ((* yyt)->MPC_MessageI.ErrorClass) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_MessageI.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_MessageI.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_MessageI.Tree))
yySkip (); readshort ((* yyt)->MPC_MessageI.MessageNumber) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_MessageI.InfoClass) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_MessageI.Info) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_MessageI.Next); break;
case kMPC_FreeNode:
yySkip (); yyt = & ((* yyt)->MPC_FreeNode.Parent); break;
case kMPC_Decls:
yySkip (); readtPosition ((* yyt)->MPC_Decls.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Decls.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Decls.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Decls.Next); break;
case kMPC_UncompString:
yySkip (); readtPosition ((* yyt)->MPC_UncompString.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UncompString.Prev))
yySkip (); readtPosition ((* yyt)->MPC_UncompString.EndPos) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_UncompString.uString) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_UncompString.Next); break;
case kMPC_Type:
yySkip (); readtPosition ((* yyt)->MPC_Type.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Type.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Type.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_Type.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Type.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Type.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Type.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_Type.pType) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Type.Next); break;
case kMPC_BasicType:
yySkip (); readtPosition ((* yyt)->MPC_BasicType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BasicType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_BasicType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_BasicType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_BasicType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_BasicType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BasicType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_BasicType.pType) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_BasicType.TypeConstructor) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_BasicType.Next); break;
case kMPC_EnumType:
yySkip (); readtPosition ((* yyt)->MPC_EnumType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_EnumType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_EnumType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_EnumType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_EnumType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_EnumType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_EnumType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_EnumType.pType) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_EnumType.EnumTag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_EnumType.EnumList))
yySkip (); yyt = & ((* yyt)->MPC_EnumType.Next); break;
case kMPC_Typedef:
yySkip (); readtPosition ((* yyt)->MPC_Typedef.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Typedef.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Typedef.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_Typedef.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Typedef.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Typedef.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Typedef.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_Typedef.pType) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Typedef.TypedefName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Typedef.Type))
yySkip (); yyt = & ((* yyt)->MPC_Typedef.Next); break;
case kMPC_DerivedType:
yySkip (); readtPosition ((* yyt)->MPC_DerivedType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_DerivedType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_DerivedType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_DerivedType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_DerivedType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_DerivedType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_DerivedType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_DerivedType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_DerivedType.NumberOfComponents) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_DerivedType.Next); break;
case kMPC_ArrayType:
yySkip (); readtPosition ((* yyt)->MPC_ArrayType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ArrayType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_ArrayType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_ArrayType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_ArrayType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_ArrayType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ArrayType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_ArrayType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_ArrayType.NumberOfComponents) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_ArrayType.Step) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ArrayType.ElementType))
yySkip (); readtTree (& ((* yyt)->MPC_ArrayType.ArraySize))
yySkip (); readtTree (& ((* yyt)->MPC_ArrayType.DynStep))
yySkip (); yyt = & ((* yyt)->MPC_ArrayType.Next); break;
case kMPC_VectorType:
yySkip (); readtPosition ((* yyt)->MPC_VectorType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_VectorType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_VectorType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_VectorType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_VectorType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_VectorType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_VectorType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_VectorType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_VectorType.NumberOfComponents) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_VectorType.ElementType))
yySkip (); readtTree (& ((* yyt)->MPC_VectorType.VectorSize))
yySkip (); yyt = & ((* yyt)->MPC_VectorType.Next); break;
case kMPC_PointerType:
yySkip (); readtPosition ((* yyt)->MPC_PointerType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_PointerType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_PointerType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_PointerType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_PointerType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_PointerType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_PointerType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_PointerType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_PointerType.NumberOfComponents) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_PointerType.Step) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_PointerType.ElementType))
yySkip (); readtTree (& ((* yyt)->MPC_PointerType.DynStep))
yySkip (); readtTree (& ((* yyt)->MPC_PointerType.GeneratedFrom))
yySkip (); yyt = & ((* yyt)->MPC_PointerType.Next); break;
case kMPC_StructType:
yySkip (); readtPosition ((* yyt)->MPC_StructType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StructType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_StructType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_StructType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_StructType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_StructType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StructType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_StructType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_StructType.NumberOfComponents) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_StructType.SU_Tag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StructType.MemberDecls))
yySkip (); yyt = & ((* yyt)->MPC_StructType.Next); break;
case kMPC_UnionType:
yySkip (); readtPosition ((* yyt)->MPC_UnionType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UnionType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_UnionType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_UnionType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_UnionType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_UnionType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UnionType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_UnionType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_UnionType.NumberOfComponents) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_UnionType.SU_Tag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UnionType.MemberDecls))
yySkip (); yyt = & ((* yyt)->MPC_UnionType.Next); break;
case kMPC_FunctionType:
yySkip (); readtPosition ((* yyt)->MPC_FunctionType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_FunctionType.EndPos) yyReadNl ();
yySkip (); readtTypeFlags ((* yyt)->MPC_FunctionType.Flag) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_FunctionType.Buffer) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_FunctionType.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.EquivType))
yySkip (); readpVoid ((* yyt)->MPC_FunctionType.pType) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_FunctionType.NumberOfComponents) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_FunctionType.Kind) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.ResultType))
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.NetParamType))
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.NetParam))
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.NetworkParamList))
yySkip (); readtTree (& ((* yyt)->MPC_FunctionType.ParamList))
yySkip (); yyt = & ((* yyt)->MPC_FunctionType.Next); break;
case kMPC_VarDecl:
yySkip (); readtPosition ((* yyt)->MPC_VarDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_VarDecl.Prev))
yySkip (); readtPosition ((* yyt)->MPC_VarDecl.EndPos) yyReadNl ();
yySkip (); readtClass ((* yyt)->MPC_VarDecl.Class) yyReadNl ();
yySkip (); readtDeclFlags ((* yyt)->MPC_VarDecl.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_VarDecl.DeclSpecifier))
yySkip (); readtTree (& ((* yyt)->MPC_VarDecl.Var))
yySkip (); yyt = & ((* yyt)->MPC_VarDecl.Next); break;
case kMPC_Function:
yySkip (); readtPosition ((* yyt)->MPC_Function.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Function.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Function.EndPos) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_Function.Kind) yyReadNl ();
yySkip (); readtDeclFlags ((* yyt)->MPC_Function.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Function.Distribution))
yySkip (); readtTree (& ((* yyt)->MPC_Function.Name))
yySkip (); readtTree (& ((* yyt)->MPC_Function.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Function.ParamList))
yySkip (); readtTree (& ((* yyt)->MPC_Function.Stats))
yySkip (); readtTree (& ((* yyt)->MPC_Function.LabelList))
yySkip (); yyt = & ((* yyt)->MPC_Function.Next); break;
case kMPC_Ellipsis:
yySkip (); readtPosition ((* yyt)->MPC_Ellipsis.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Ellipsis.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Ellipsis.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Ellipsis.Next); break;
case kMPC_NetDecl:
yySkip (); readtPosition ((* yyt)->MPC_NetDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetDecl.Prev))
yySkip (); readtPosition ((* yyt)->MPC_NetDecl.EndPos) yyReadNl ();
yySkip (); readtClass ((* yyt)->MPC_NetDecl.NetClass) yyReadNl ();
yySkip (); readtDeclFlags ((* yyt)->MPC_NetDecl.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetDecl.NetTypeSpecifier))
yySkip (); readtTree (& ((* yyt)->MPC_NetDecl.Net))
yySkip (); yyt = & ((* yyt)->MPC_NetDecl.Next); break;
case kMPC_SubnetDecl:
yySkip (); readtPosition ((* yyt)->MPC_SubnetDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SubnetDecl.Prev))
yySkip (); readtPosition ((* yyt)->MPC_SubnetDecl.EndPos) yyReadNl ();
yySkip (); readtClass ((* yyt)->MPC_SubnetDecl.SubnetClass) yyReadNl ();
yySkip (); readtDeclFlags ((* yyt)->MPC_SubnetDecl.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SubnetDecl.Subnet))
yySkip (); yyt = & ((* yyt)->MPC_SubnetDecl.Next); break;
case kMPC_RelDecl:
yySkip (); readtPosition ((* yyt)->MPC_RelDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_RelDecl.Prev))
yySkip (); readtPosition ((* yyt)->MPC_RelDecl.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_RelDecl.Relation))
yySkip (); yyt = & ((* yyt)->MPC_RelDecl.Next); break;
case kMPC_NetTypeDecl:
yySkip (); readtPosition ((* yyt)->MPC_NetTypeDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetTypeDecl.Prev))
yySkip (); readtPosition ((* yyt)->MPC_NetTypeDecl.EndPos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_NetTypeDecl.Ident) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_NetTypeDecl.Next); break;
case kMPC_NetType:
yySkip (); readtPosition ((* yyt)->MPC_NetType.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetType.Prev))
yySkip (); readtPosition ((* yyt)->MPC_NetType.EndPos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_NetType.Ident) yyReadNl ();
yySkip (); readtClass ((* yyt)->MPC_NetType.Class) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetType.ParamList))
yySkip (); readtTree (& ((* yyt)->MPC_NetType.CoordDecl))
yySkip (); readtTree (& ((* yyt)->MPC_NetType.NodeDecl))
yySkip (); readtTree (& ((* yyt)->MPC_NetType.LinkDecl))
yySkip (); readtTree (& ((* yyt)->MPC_NetType.StartDecl))
yySkip (); readtTree (& ((* yyt)->MPC_NetType.SchemeDecl))
yySkip (); readbool ((* yyt)->MPC_NetType.Bench) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetType.TopoFunctions))
yySkip (); yyt = & ((* yyt)->MPC_NetType.Next); break;
case kMPC_NetTypeSpecifier:
yySkip (); readtPosition ((* yyt)->MPC_NetTypeSpecifier.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetTypeSpecifier.Prev))
yySkip (); readtPosition ((* yyt)->MPC_NetTypeSpecifier.EndPos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_NetTypeSpecifier.Ident) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetTypeSpecifier.NetType))
yySkip (); readtTree (& ((* yyt)->MPC_NetTypeSpecifier.ArgList))
yySkip (); yyt = & ((* yyt)->MPC_NetTypeSpecifier.Next); break;
case kMPC_TopoFunctions:
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Node_Def))
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Link_Def))
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Main_Node_Def))
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Power_Def))
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Node_Coord_Def))
yySkip (); readtTree (& ((* yyt)->MPC_TopoFunctions.Node_Number_Def))
yySkip (); yyt = & ((* yyt)->MPC_TopoFunctions.Mapping_Def); break;
case kMPC_EnumConst:
yySkip (); readtPosition ((* yyt)->MPC_EnumConst.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_EnumConst.Name) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_EnumConst.WithValue) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_EnumConst.Value) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_EnumConst.Prev))
yySkip (); readtPosition ((* yyt)->MPC_EnumConst.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_EnumConst.Next); break;
case kMPC_SU_MemberDecl:
yySkip (); readtPosition ((* yyt)->MPC_SU_MemberDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SU_MemberDecl.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_SU_MemberDecl.Member))
yySkip (); readtPosition ((* yyt)->MPC_SU_MemberDecl.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_SU_MemberDecl.Next); break;
case kMPC_SU_Member:
yySkip (); readtPosition ((* yyt)->MPC_SU_Member.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_SU_Member.Name) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_SU_Member.BitFieldLength) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SU_Member.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_SU_Member.Type))
yySkip (); readtTree (& ((* yyt)->MPC_SU_Member.BitFieldSize))
yySkip (); readtPosition ((* yyt)->MPC_SU_Member.EndPos) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_SU_Member.UniqueNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_SU_Member.Next); break;
case kMPC_Var:
yySkip (); readtPosition ((* yyt)->MPC_Var.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Var.Ident) yyReadNl ();
yySkip (); readtDeclFlags ((* yyt)->MPC_Var.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Var.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Var.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Var.Distribution))
yySkip (); readtTree (& ((* yyt)->MPC_Var.Init))
yySkip (); readtPosition ((* yyt)->MPC_Var.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Var.Next); break;
case kMPC_CoordDecl:
yySkip (); readtPosition ((* yyt)->MPC_CoordDecl.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_CoordDecl.Ident) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CoordDecl.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_CoordDecl.Range))
yySkip (); readtPosition ((* yyt)->MPC_CoordDecl.EndPos) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_CoordDecl.CoordNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_CoordDecl.Next); break;
case kMPC_Node:
yySkip (); readtPosition ((* yyt)->MPC_Node.Pos) yyReadNl ();
yySkip (); readtNodeType ((* yyt)->MPC_Node.NodeType) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Node.DynamicType) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Node.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Node.Predicate))
yySkip (); readtTree (& ((* yyt)->MPC_Node.NodeQual))
yySkip (); readtPosition ((* yyt)->MPC_Node.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Node.Next); break;
case kMPC_NodeQual:
yySkip (); readtPosition ((* yyt)->MPC_NodeQual.Pos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_NodeQual.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_NodeQual.CapacityExpr); break;
case kMPC_NodeTypeQual:
yySkip (); readtPosition ((* yyt)->MPC_NodeTypeQual.Pos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_NodeTypeQual.EndPos) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NodeTypeQual.Fast) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_NodeTypeQual.Capacity) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_NodeTypeQual.CapacityExpr); break;
case kMPC_BenchQual:
yySkip (); readtPosition ((* yyt)->MPC_BenchQual.Pos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_BenchQual.EndPos) yyReadNl ();
yySkip (); readdouble ((* yyt)->MPC_BenchQual.Capacity) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_BenchQual.CapacityExpr); break;
case kMPC_LinkDecl:
yySkip (); readtPosition ((* yyt)->MPC_LinkDecl.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_LinkDecl.FreeCoord))
yySkip (); readtPosition ((* yyt)->MPC_LinkDecl.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_LinkDecl.LinkDeclaringList); break;
case kMPC_LinkDeclaringList:
yySkip (); readtPosition ((* yyt)->MPC_LinkDeclaringList.Pos) yyReadNl ();
yySkip (); readtLinkType ((* yyt)->MPC_LinkDeclaringList.LinkType) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_LinkDeclaringList.DynamicLength) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclaringList.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclaringList.Predicate))
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclaringList.LinkLengthSpecifier))
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclaringList.LinkDeclarator))
yySkip (); readtPosition ((* yyt)->MPC_LinkDeclaringList.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_LinkDeclaringList.Next); break;
case kMPC_LinkDeclarator:
yySkip (); readtPosition ((* yyt)->MPC_LinkDeclarator.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclarator.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclarator.LeftNode))
yySkip (); readtTree (& ((* yyt)->MPC_LinkDeclarator.RightNode))
yySkip (); readtPosition ((* yyt)->MPC_LinkDeclarator.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_LinkDeclarator.Next); break;
case kMPC_LinkLengthSpecifier:
yySkip (); readtPosition ((* yyt)->MPC_LinkLengthSpecifier.Pos) yyReadNl ();
yySkip (); readtLinkType ((* yyt)->MPC_LinkLengthSpecifier.LinkLength) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_LinkLengthSpecifier.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_LinkLengthSpecifier.LinkLengthExpr); break;
case kMPC_Scheme:
yySkip (); readtPosition ((* yyt)->MPC_Scheme.Pos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Scheme.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Scheme.Body); break;
case kMPC_NetList:
yySkip (); readtTree (& ((* yyt)->MPC_NetList.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_NetList.Net))
yySkip (); readtPosition ((* yyt)->MPC_NetList.Pos) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetList.UnReduceable) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_NetList.Next); break;
case kMPC_NetOrSubnet:
yySkip (); readtPosition ((* yyt)->MPC_NetOrSubnet.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_NetOrSubnet.Ident) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetOrSubnet.BigCreate) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetOrSubnet.Distribution))
yySkip (); readtTree (& ((* yyt)->MPC_NetOrSubnet.Prev))
yySkip (); readtPosition ((* yyt)->MPC_NetOrSubnet.EndPos) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_NetOrSubnet.UniqueNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetOrSubnet.WithNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetOrSubnet.SingleNode) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetOrSubnet.IsParent) yyReadNl ();
yySkip (); readpVoid ((* yyt)->MPC_NetOrSubnet.pGen) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetOrSubnet.NextUse))
yySkip (); readtTree (& ((* yyt)->MPC_NetOrSubnet.PrevUse))
yySkip (); readtTree (& ((* yyt)->MPC_NetOrSubnet.MyList))
yySkip (); yyt = & ((* yyt)->MPC_NetOrSubnet.Next); break;
case kMPC_Net:
yySkip (); readtPosition ((* yyt)->MPC_Net.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Net.Ident) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Net.BigCreate) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Net.Distribution))
yySkip (); readtTree (& ((* yyt)->MPC_Net.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Net.EndPos) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Net.UniqueNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Net.WithNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Net.SingleNode) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Net.IsParent) yyReadNl ();
yySkip (); readpVoid ((* yyt)->MPC_Net.pGen) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Net.NextUse))
yySkip (); readtTree (& ((* yyt)->MPC_Net.PrevUse))
yySkip (); readtTree (& ((* yyt)->MPC_Net.MyList))
yySkip (); readshort ((* yyt)->MPC_Net.Topology) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Net.NetType))
yySkip (); yyt = & ((* yyt)->MPC_Net.Next); break;
case kMPC_Subnet:
yySkip (); readtPosition ((* yyt)->MPC_Subnet.Pos) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Subnet.Ident) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Subnet.BigCreate) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.Distribution))
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Subnet.EndPos) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Subnet.UniqueNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Subnet.WithNumber) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Subnet.SingleNode) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Subnet.IsParent) yyReadNl ();
yySkip (); readpVoid ((* yyt)->MPC_Subnet.pGen) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.NextUse))
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.PrevUse))
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.MyList))
yySkip (); readtIdent ((* yyt)->MPC_Subnet.NetOrSubnetName) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Subnet.Flexible) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Subnet.Predicate))
yySkip (); yyt = & ((* yyt)->MPC_Subnet.Next); break;
case kMPC_Relation:
yySkip (); readtPosition ((* yyt)->MPC_Relation.Pos) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_Relation.RelCode) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Relation.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Relation.LNet))
yySkip (); readtTree (& ((* yyt)->MPC_Relation.RNet))
yySkip (); readtPosition ((* yyt)->MPC_Relation.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Relation.Next); break;
case kMPC_Stats:
yySkip (); readtPosition ((* yyt)->MPC_Stats.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Stats.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Stats.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Stats.Next); break;
case kMPC_Stat:
yySkip (); readtPosition ((* yyt)->MPC_Stat.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Stat.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Stat.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Stat.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Stat.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Stat.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Stat.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Stat.PropNet))
yySkip (); readbool ((* yyt)->MPC_Stat.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Stat.UniqueNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Stat.Next); break;
case kMPC_ExprStat:
yySkip (); readtPosition ((* yyt)->MPC_ExprStat.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.Prev))
yySkip (); readtPosition ((* yyt)->MPC_ExprStat.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_ExprStat.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.PropNet))
yySkip (); readbool ((* yyt)->MPC_ExprStat.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_ExprStat.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ExprStat.Expr))
yySkip (); yyt = & ((* yyt)->MPC_ExprStat.Next); break;
case kMPC_If:
yySkip (); readtPosition ((* yyt)->MPC_If.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_If.Prev))
yySkip (); readtPosition ((* yyt)->MPC_If.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_If.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_If.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_If.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_If.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_If.PropNet))
yySkip (); readbool ((* yyt)->MPC_If.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_If.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_If.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_If.Stats))
yySkip (); yyt = & ((* yyt)->MPC_If.Next); break;
case kMPC_IfElse:
yySkip (); readtPosition ((* yyt)->MPC_IfElse.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.Prev))
yySkip (); readtPosition ((* yyt)->MPC_IfElse.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_IfElse.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.PropNet))
yySkip (); readbool ((* yyt)->MPC_IfElse.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_IfElse.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.Then))
yySkip (); readtTree (& ((* yyt)->MPC_IfElse.Else))
yySkip (); yyt = & ((* yyt)->MPC_IfElse.Next); break;
case kMPC_Switch:
yySkip (); readtPosition ((* yyt)->MPC_Switch.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Switch.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Switch.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Switch.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Switch.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Switch.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Switch.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Switch.PropNet))
yySkip (); readbool ((* yyt)->MPC_Switch.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Switch.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Switch.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_Switch.Stats))
yySkip (); yyt = & ((* yyt)->MPC_Switch.Next); break;
case kMPC_While:
yySkip (); readtPosition ((* yyt)->MPC_While.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_While.Prev))
yySkip (); readtPosition ((* yyt)->MPC_While.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_While.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_While.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_While.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_While.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_While.PropNet))
yySkip (); readbool ((* yyt)->MPC_While.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_While.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_While.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_While.Stats))
yySkip (); yyt = & ((* yyt)->MPC_While.Next); break;
case kMPC_DoWhile:
yySkip (); readtPosition ((* yyt)->MPC_DoWhile.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.Prev))
yySkip (); readtPosition ((* yyt)->MPC_DoWhile.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_DoWhile.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.PropNet))
yySkip (); readbool ((* yyt)->MPC_DoWhile.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_DoWhile.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.Stats))
yySkip (); readtTree (& ((* yyt)->MPC_DoWhile.Expr))
yySkip (); yyt = & ((* yyt)->MPC_DoWhile.Next); break;
case kMPC_For:
yySkip (); readtPosition ((* yyt)->MPC_For.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_For.Prev))
yySkip (); readtPosition ((* yyt)->MPC_For.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_For.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_For.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_For.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_For.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_For.PropNet))
yySkip (); readbool ((* yyt)->MPC_For.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_For.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_For.Init))
yySkip (); readtTree (& ((* yyt)->MPC_For.Cond))
yySkip (); readtTree (& ((* yyt)->MPC_For.Reinit))
yySkip (); readtTree (& ((* yyt)->MPC_For.Stats))
yySkip (); yyt = & ((* yyt)->MPC_For.Next); break;
case kMPC_Goto:
yySkip (); readtPosition ((* yyt)->MPC_Goto.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Goto.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Goto.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Goto.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Goto.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Goto.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Goto.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Goto.PropNet))
yySkip (); readbool ((* yyt)->MPC_Goto.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Goto.UniqueNumber) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Goto.Ident) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Goto.LabelDef))
yySkip (); readtTree (& ((* yyt)->MPC_Goto.NextUse))
yySkip (); readtTree (& ((* yyt)->MPC_Goto.PrevUse))
yySkip (); yyt = & ((* yyt)->MPC_Goto.Next); break;
case kMPC_Continue:
yySkip (); readtPosition ((* yyt)->MPC_Continue.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Continue.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Continue.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Continue.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Continue.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Continue.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Continue.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Continue.PropNet))
yySkip (); readbool ((* yyt)->MPC_Continue.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Continue.UniqueNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Continue.Next); break;
case kMPC_Break:
yySkip (); readtPosition ((* yyt)->MPC_Break.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Break.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Break.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Break.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Break.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Break.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Break.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Break.PropNet))
yySkip (); readbool ((* yyt)->MPC_Break.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Break.UniqueNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Break.Next); break;
case kMPC_BreakFan:
yySkip (); readtPosition ((* yyt)->MPC_BreakFan.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BreakFan.Prev))
yySkip (); readtPosition ((* yyt)->MPC_BreakFan.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_BreakFan.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BreakFan.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_BreakFan.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_BreakFan.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_BreakFan.PropNet))
yySkip (); readbool ((* yyt)->MPC_BreakFan.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_BreakFan.UniqueNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_BreakFan.Next); break;
case kMPC_Return:
yySkip (); readtPosition ((* yyt)->MPC_Return.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Return.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Return.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Return.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Return.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Return.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Return.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Return.PropNet))
yySkip (); readbool ((* yyt)->MPC_Return.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Return.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Return.Expr))
yySkip (); yyt = & ((* yyt)->MPC_Return.Next); break;
case kMPC_Compound:
yySkip (); readtPosition ((* yyt)->MPC_Compound.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Compound.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Compound.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Compound.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Compound.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Compound.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Compound.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Compound.PropNet))
yySkip (); readbool ((* yyt)->MPC_Compound.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Compound.UniqueNumber) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_Compound.FunctionBody) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Compound.Decls))
yySkip (); readtTree (& ((* yyt)->MPC_Compound.Stats))
yySkip (); yyt = & ((* yyt)->MPC_Compound.Next); break;
case kMPC_CompScheme:
yySkip (); readtPosition ((* yyt)->MPC_CompScheme.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.Prev))
yySkip (); readtPosition ((* yyt)->MPC_CompScheme.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_CompScheme.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.PropNet))
yySkip (); readbool ((* yyt)->MPC_CompScheme.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_CompScheme.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_CompScheme.Node))
yySkip (); yyt = & ((* yyt)->MPC_CompScheme.Next); break;
case kMPC_CommScheme:
yySkip (); readtPosition ((* yyt)->MPC_CommScheme.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.Prev))
yySkip (); readtPosition ((* yyt)->MPC_CommScheme.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_CommScheme.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.PropNet))
yySkip (); readbool ((* yyt)->MPC_CommScheme.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_CommScheme.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.Expr))
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.From))
yySkip (); readtTree (& ((* yyt)->MPC_CommScheme.To))
yySkip (); yyt = & ((* yyt)->MPC_CommScheme.Next); break;
case kMPC_ParScheme:
yySkip (); readtPosition ((* yyt)->MPC_ParScheme.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.Prev))
yySkip (); readtPosition ((* yyt)->MPC_ParScheme.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_ParScheme.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.PropNet))
yySkip (); readbool ((* yyt)->MPC_ParScheme.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_ParScheme.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.Init))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.Cond))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.Reinit))
yySkip (); readtTree (& ((* yyt)->MPC_ParScheme.Stats))
yySkip (); yyt = & ((* yyt)->MPC_ParScheme.Next); break;
case kMPC_Fan:
yySkip (); readtPosition ((* yyt)->MPC_Fan.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Fan.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Fan.EndPos) yyReadNl ();
yySkip (); readtStatFlags ((* yyt)->MPC_Fan.Flag) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Fan.ExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Fan.ActualExecNet))
yySkip (); readtTree (& ((* yyt)->MPC_Fan.RootNet))
yySkip (); readtTree (& ((* yyt)->MPC_Fan.PropNet))
yySkip (); readbool ((* yyt)->MPC_Fan.Benchmark) yyReadNl ();
yySkip (); readMPC_unsigned_short ((* yyt)->MPC_Fan.UniqueNumber) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Fan.Body))
yySkip (); yyt = & ((* yyt)->MPC_Fan.Next); break;
case kMPC_Label:
yySkip (); readtPosition ((* yyt)->MPC_Label.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Label.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Label.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Label.NextLabel))
yySkip (); readtTree (& ((* yyt)->MPC_Label.PrevLabel))
yySkip (); yyt = & ((* yyt)->MPC_Label.Next); break;
case kMPC_IdentLabel:
yySkip (); readtPosition ((* yyt)->MPC_IdentLabel.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IdentLabel.Prev))
yySkip (); readtPosition ((* yyt)->MPC_IdentLabel.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IdentLabel.NextLabel))
yySkip (); readtTree (& ((* yyt)->MPC_IdentLabel.PrevLabel))
yySkip (); readtIdent ((* yyt)->MPC_IdentLabel.Ident) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IdentLabel.NextUse))
yySkip (); readbool ((* yyt)->MPC_IdentLabel.Used) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_IdentLabel.Next); break;
case kMPC_CaseLabel:
yySkip (); readtPosition ((* yyt)->MPC_CaseLabel.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CaseLabel.Prev))
yySkip (); readtPosition ((* yyt)->MPC_CaseLabel.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CaseLabel.NextLabel))
yySkip (); readtTree (& ((* yyt)->MPC_CaseLabel.PrevLabel))
yySkip (); readlong ((* yyt)->MPC_CaseLabel.CaseValue) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CaseLabel.Expr))
yySkip (); yyt = & ((* yyt)->MPC_CaseLabel.Next); break;
case kMPC_Default:
yySkip (); readtPosition ((* yyt)->MPC_Default.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Default.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Default.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Default.NextLabel))
yySkip (); readtTree (& ((* yyt)->MPC_Default.PrevLabel))
yySkip (); yyt = & ((* yyt)->MPC_Default.Next); break;
case kMPC_Expr:
yySkip (); readtPosition ((* yyt)->MPC_Expr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_Expr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Expr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Expr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Expr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_Expr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_Expr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Expr.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_Expr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Expr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_Expr.Optm_Attribute) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Expr.ActualEvalNet); break;
case kMPC_Const:
yySkip (); readtPosition ((* yyt)->MPC_Const.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_Const.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Const.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Const.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Const.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_Const.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_Const.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Const.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_Const.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Const.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_Const.Optm_Attribute) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Const.SymbolicForm) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Const.ActualEvalNet); break;
case kMPC_IntConst:
yySkip (); readtPosition ((* yyt)->MPC_IntConst.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_IntConst.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_IntConst.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_IntConst.Type))
yySkip (); readtTree (& ((* yyt)->MPC_IntConst.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_IntConst.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_IntConst.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_IntConst.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_IntConst.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_IntConst.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_IntConst.Optm_Attribute) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_IntConst.SymbolicForm) yyReadNl ();
yySkip (); readlong ((* yyt)->MPC_IntConst.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_IntConst.ActualEvalNet); break;
case kMPC_UIntConst:
yySkip (); readtPosition ((* yyt)->MPC_UIntConst.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_UIntConst.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_UIntConst.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UIntConst.Type))
yySkip (); readtTree (& ((* yyt)->MPC_UIntConst.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_UIntConst.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_UIntConst.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_UIntConst.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_UIntConst.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_UIntConst.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_UIntConst.Optm_Attribute) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_UIntConst.SymbolicForm) yyReadNl ();
yySkip (); readMPC_long_unsigned ((* yyt)->MPC_UIntConst.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_UIntConst.ActualEvalNet); break;
case kMPC_FloatConst:
yySkip (); readtPosition ((* yyt)->MPC_FloatConst.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_FloatConst.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_FloatConst.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_FloatConst.Type))
yySkip (); readtTree (& ((* yyt)->MPC_FloatConst.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_FloatConst.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_FloatConst.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_FloatConst.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_FloatConst.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_FloatConst.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_FloatConst.Optm_Attribute) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_FloatConst.SymbolicForm) yyReadNl ();
yySkip (); readMPC_long_double ((* yyt)->MPC_FloatConst.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_FloatConst.ActualEvalNet); break;
case kMPC_StringLiteral:
yySkip (); readtPosition ((* yyt)->MPC_StringLiteral.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_StringLiteral.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_StringLiteral.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StringLiteral.Type))
yySkip (); readtTree (& ((* yyt)->MPC_StringLiteral.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_StringLiteral.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_StringLiteral.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_StringLiteral.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StringLiteral.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_StringLiteral.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_StringLiteral.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_StringLiteral.Optm_Attribute) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_StringLiteral.String) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_StringLiteral.FullSize) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_StringLiteral.Prev))
yySkip (); yyt = & ((* yyt)->MPC_StringLiteral.Next); break;
case kMPC_Ident:
yySkip (); readtPosition ((* yyt)->MPC_Ident.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_Ident.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Ident.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Ident.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Ident.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_Ident.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_Ident.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Ident.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Ident.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_Ident.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Ident.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_Ident.Optm_Attribute) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_Ident.Ident) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Ident.Store))
yySkip (); readtTree (& ((* yyt)->MPC_Ident.NextUse))
yySkip (); yyt = & ((* yyt)->MPC_Ident.PrevUse); break;
case kMPC_CastExpr:
yySkip (); readtPosition ((* yyt)->MPC_CastExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_CastExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_CastExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CastExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_CastExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_CastExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_CastExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_CastExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CastExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_CastExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_CastExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_CastExpr.Optm_Attribute) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CastExpr.TypeName))
yySkip (); yyt = & ((* yyt)->MPC_CastExpr.Operand); break;
case kMPC_NetCastExpr:
yySkip (); readtPosition ((* yyt)->MPC_NetCastExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_NetCastExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_NetCastExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetCastExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_NetCastExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_NetCastExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_NetCastExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_NetCastExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_NetCastExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_NetCastExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetCastExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_NetCastExpr.Optm_Attribute) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_NetCastExpr.Flexible) yyReadNl ();
yySkip (); readpVoid ((* yyt)->MPC_NetCastExpr.ExprPtr) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_NetCastExpr.Operand); break;
case kMPC_CoordExpr:
yySkip (); readtPosition ((* yyt)->MPC_CoordExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_CoordExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_CoordExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CoordExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_CoordExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_CoordExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_CoordExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_CoordExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CoordExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_CoordExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_CoordExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_CoordExpr.Optm_Attribute) yyReadNl ();
yySkip (); readtIdent ((* yyt)->MPC_CoordExpr.CoordName) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_CoordExpr.CoordNumber) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_CoordExpr.Operand); break;
case kMPC_SizeofExpr:
yySkip (); readtPosition ((* yyt)->MPC_SizeofExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_SizeofExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_SizeofExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SizeofExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_SizeofExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_SizeofExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_SizeofExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_SizeofExpr.EndPos) yyReadNl ();
yySkip (); readchar ((* yyt)->MPC_SizeofExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_SizeofExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_SizeofExpr.Optm_Attribute) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_SizeofExpr.CompileTime) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_SizeofExpr.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_SizeofExpr.ActualEvalNet); break;
case kMPC_Size_Of_Value:
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Value.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_Size_Of_Value.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Size_Of_Value.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Value.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Value.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Value.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Value.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Value.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Value.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_Size_Of_Value.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Size_Of_Value.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_Size_Of_Value.Optm_Attribute) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Size_Of_Value.CompileTime) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_Size_Of_Value.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Size_Of_Value.Operand); break;
case kMPC_Size_Of_Type:
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Type.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_Size_Of_Type.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_Size_Of_Type.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Type.Type))
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Type.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Type.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Type.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Size_Of_Type.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Size_Of_Type.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_Size_Of_Type.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Size_Of_Type.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_Size_Of_Type.Optm_Attribute) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_Size_Of_Type.CompileTime) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_Size_Of_Type.Value) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Size_Of_Type.Operand); break;
case kMPC_TimeofExpr:
yySkip (); readtPosition ((* yyt)->MPC_TimeofExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_TimeofExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_TimeofExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_TimeofExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_TimeofExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_TimeofExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_TimeofExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_TimeofExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_TimeofExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_TimeofExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_TimeofExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_TimeofExpr.Optm_Attribute) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_TimeofExpr.NetDecl); break;
case kMPC_UnaryExpr:
yySkip (); readtPosition ((* yyt)->MPC_UnaryExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_UnaryExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_UnaryExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UnaryExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_UnaryExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_UnaryExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_UnaryExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_UnaryExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_UnaryExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_UnaryExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_UnaryExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_UnaryExpr.Optm_Attribute) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_UnaryExpr.OpCode) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_UnaryExpr.Operand); break;
case kMPC_BinaryExpr:
yySkip (); readtPosition ((* yyt)->MPC_BinaryExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_BinaryExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_BinaryExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BinaryExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_BinaryExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_BinaryExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_BinaryExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_BinaryExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BinaryExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_BinaryExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_BinaryExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_BinaryExpr.Optm_Attribute) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_BinaryExpr.OpCode) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_BinaryExpr.Loperand))
yySkip (); yyt = & ((* yyt)->MPC_BinaryExpr.Roperand); break;
case kMPC_TernaryExpr:
yySkip (); readtPosition ((* yyt)->MPC_TernaryExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_TernaryExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_TernaryExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_TernaryExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_TernaryExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_TernaryExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_TernaryExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_TernaryExpr.Optm_Attribute) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_TernaryExpr.OpCode) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.Foperand))
yySkip (); readtTree (& ((* yyt)->MPC_TernaryExpr.Soperand))
yySkip (); yyt = & ((* yyt)->MPC_TernaryExpr.Toperand); break;
case kMPC_QuaternaryExpr:
yySkip (); readtPosition ((* yyt)->MPC_QuaternaryExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_QuaternaryExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_QuaternaryExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_QuaternaryExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_QuaternaryExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_QuaternaryExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_QuaternaryExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_QuaternaryExpr.Optm_Attribute) yyReadNl ();
yySkip (); readshort ((* yyt)->MPC_QuaternaryExpr.OpCode) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.Operand1))
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.Operand2))
yySkip (); readtTree (& ((* yyt)->MPC_QuaternaryExpr.Operand3))
yySkip (); yyt = & ((* yyt)->MPC_QuaternaryExpr.Operand4); break;
case kMPC_CallExpr:
yySkip (); readtPosition ((* yyt)->MPC_CallExpr.Pos) yyReadNl ();
yySkip (); readtExprFlags ((* yyt)->MPC_CallExpr.Flag) yyReadNl ();
yySkip (); readtString ((* yyt)->MPC_CallExpr.TmpName) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.Type))
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.EvalNet))
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.StoreNet))
yySkip (); readtPosition ((* yyt)->MPC_CallExpr.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_CallExpr.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.ActualEvalNet))
yySkip (); readchar ((* yyt)->MPC_CallExpr.Pass) yyReadNl ();
yySkip (); readbool ((* yyt)->MPC_CallExpr.Repl) yyReadNl ();
yySkip (); readtOptm_Attribute ((* yyt)->MPC_CallExpr.Optm_Attribute) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.Function))
yySkip (); readtTree (& ((* yyt)->MPC_CallExpr.ArgList))
yySkip (); yyt = & ((* yyt)->MPC_CallExpr.NetworkArgList); break;
case kMPC_Exprs:
yySkip (); readtPosition ((* yyt)->MPC_Exprs.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Exprs.Prev))
yySkip (); readtTree (& ((* yyt)->MPC_Exprs.Expr))
yySkip (); readtPosition ((* yyt)->MPC_Exprs.BegPos) yyReadNl ();
yySkip (); readtPosition ((* yyt)->MPC_Exprs.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Exprs.Next); break;
case kMPC_Initializer:
yySkip (); readtPosition ((* yyt)->MPC_Initializer.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_Initializer.Prev))
yySkip (); readtPosition ((* yyt)->MPC_Initializer.EndPos) yyReadNl ();
yySkip (); yyt = & ((* yyt)->MPC_Initializer.Next); break;
case kMPC_SimpleInit:
yySkip (); readtPosition ((* yyt)->MPC_SimpleInit.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SimpleInit.Prev))
yySkip (); readtPosition ((* yyt)->MPC_SimpleInit.EndPos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_SimpleInit.Expr))
yySkip (); yyt = & ((* yyt)->MPC_SimpleInit.Next); break;
case kMPC_InitList:
yySkip (); readtPosition ((* yyt)->MPC_InitList.Pos) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_InitList.Prev))
yySkip (); readtPosition ((* yyt)->MPC_InitList.EndPos) yyReadNl ();
yySkip (); readint ((* yyt)->MPC_InitList.Length) yyReadNl ();
yySkip (); readtTree (& ((* yyt)->MPC_InitList.List))
yySkip (); yyt = & ((* yyt)->MPC_InitList.Next); break;
  default: return;
  }
 }
}

tTree ReadTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf)
# else
 (yyyf) FILE * yyyf;
# endif
{
 tTree yyt;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 if (! yyIsInitialized) {
  register int yyi;
  for (yyi = 0; yyi <= 97; yyi ++)
   yyKindToIdent [yyi] = MakeIdent ((tString) Tree_NodeName [yyi], strlen (Tree_NodeName [yyi]));
  yyIsInitialized = true;
 }
 yyReadTree (& yyt);
 yyRecursionLevel --;
 return yyt;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static void yyPut
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fwrite (yyx, 1, yysize, yyf); }

static void yyPutIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent yyi)
# else
 (yyi) tIdent yyi;
# endif
{
 char yys [256];
 GetString (yyi, (tString) yys);
 (void) fprintf (yyf, "%s\n", yys);
}

static void yyPutTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 for (;;) {
  if (yyt == NoTree) {
   (void) putc (yyNil, yyf); return;
  } else if (yyt->yyHead.yyMark == 0) {
   (void) putc (yyLabelUse, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel)); return;
  } else if (yyt->yyHead.yyMark > 1) {
   (void) putc (yyLabelDef, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel));
   (void) putc ((char) yyt->Kind, yyf);
  } else {
   (void) putc ((char) yyt->Kind, yyf);
  }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kMPC_Root:
puttTree (yyt->MPC_Root.Decls)
puttTree (yyt->MPC_Root.Source)
puttTree (yyt->MPC_Root.Messages)
puttTree (yyt->MPC_Root.Host)
puttTree (yyt->MPC_Root.SingleNode)
puttTree (yyt->MPC_Root.ComputingSpace)
puttTree (yyt->MPC_Root.Const)
puttTree (yyt->MPC_Root.Recon)
puttTree (yyt->MPC_Root.HostList)
puttTree (yyt->MPC_Root.SingleNodeList)
puttTree (yyt->MPC_Root.ComputingSpaceList)
puttTree (yyt->MPC_Root.ConstList)
yyt = yyt->MPC_Root.ReconList; break;
case kMPC_Source:
puttString (yyt->MPC_Source.FileName)
puttPosition (yyt->MPC_Source.VirtPos)
puttPosition (yyt->MPC_Source.RealPos)
puttTree (yyt->MPC_Source.Prev)
yyt = yyt->MPC_Source.Next; break;
case kMPC_Messages:
putint (yyt->MPC_Messages.ErrorClass)
puttPosition (yyt->MPC_Messages.Pos)
puttTree (yyt->MPC_Messages.Prev)
puttTree (yyt->MPC_Messages.Tree)
yyt = yyt->MPC_Messages.Next; break;
case kMPC_ErrorMessage:
putint (yyt->MPC_ErrorMessage.ErrorClass)
puttPosition (yyt->MPC_ErrorMessage.Pos)
puttTree (yyt->MPC_ErrorMessage.Prev)
puttTree (yyt->MPC_ErrorMessage.Tree)
putint (yyt->MPC_ErrorMessage.ErrorCode)
yyt = yyt->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI:
putint (yyt->MPC_ErrorMessageI.ErrorClass)
puttPosition (yyt->MPC_ErrorMessageI.Pos)
puttTree (yyt->MPC_ErrorMessageI.Prev)
puttTree (yyt->MPC_ErrorMessageI.Tree)
putint (yyt->MPC_ErrorMessageI.ErrorCode)
putint (yyt->MPC_ErrorMessageI.InfoClass)
puttString (yyt->MPC_ErrorMessageI.Info)
yyt = yyt->MPC_ErrorMessageI.Next; break;
case kMPC_Message:
putint (yyt->MPC_Message.ErrorClass)
puttPosition (yyt->MPC_Message.Pos)
puttTree (yyt->MPC_Message.Prev)
puttTree (yyt->MPC_Message.Tree)
putshort (yyt->MPC_Message.MessageNumber)
yyt = yyt->MPC_Message.Next; break;
case kMPC_MessageI:
putint (yyt->MPC_MessageI.ErrorClass)
puttPosition (yyt->MPC_MessageI.Pos)
puttTree (yyt->MPC_MessageI.Prev)
puttTree (yyt->MPC_MessageI.Tree)
putshort (yyt->MPC_MessageI.MessageNumber)
putint (yyt->MPC_MessageI.InfoClass)
puttString (yyt->MPC_MessageI.Info)
yyt = yyt->MPC_MessageI.Next; break;
case kMPC_FreeNode:
yyt = yyt->MPC_FreeNode.Parent; break;
case kMPC_Decls:
puttPosition (yyt->MPC_Decls.Pos)
puttTree (yyt->MPC_Decls.Prev)
puttPosition (yyt->MPC_Decls.EndPos)
yyt = yyt->MPC_Decls.Next; break;
case kMPC_UncompString:
puttPosition (yyt->MPC_UncompString.Pos)
puttTree (yyt->MPC_UncompString.Prev)
puttPosition (yyt->MPC_UncompString.EndPos)
puttString (yyt->MPC_UncompString.uString)
yyt = yyt->MPC_UncompString.Next; break;
case kMPC_Type:
puttPosition (yyt->MPC_Type.Pos)
puttTree (yyt->MPC_Type.Prev)
puttPosition (yyt->MPC_Type.EndPos)
puttTypeFlags (yyt->MPC_Type.Flag)
putbool (yyt->MPC_Type.Buffer)
putMPC_unsigned_short (yyt->MPC_Type.UniqueNumber)
puttTree (yyt->MPC_Type.EquivType)
putpVoid (yyt->MPC_Type.pType)
yyt = yyt->MPC_Type.Next; break;
case kMPC_BasicType:
puttPosition (yyt->MPC_BasicType.Pos)
puttTree (yyt->MPC_BasicType.Prev)
puttPosition (yyt->MPC_BasicType.EndPos)
puttTypeFlags (yyt->MPC_BasicType.Flag)
putbool (yyt->MPC_BasicType.Buffer)
putMPC_unsigned_short (yyt->MPC_BasicType.UniqueNumber)
puttTree (yyt->MPC_BasicType.EquivType)
putpVoid (yyt->MPC_BasicType.pType)
putshort (yyt->MPC_BasicType.TypeConstructor)
yyt = yyt->MPC_BasicType.Next; break;
case kMPC_EnumType:
puttPosition (yyt->MPC_EnumType.Pos)
puttTree (yyt->MPC_EnumType.Prev)
puttPosition (yyt->MPC_EnumType.EndPos)
puttTypeFlags (yyt->MPC_EnumType.Flag)
putbool (yyt->MPC_EnumType.Buffer)
putMPC_unsigned_short (yyt->MPC_EnumType.UniqueNumber)
puttTree (yyt->MPC_EnumType.EquivType)
putpVoid (yyt->MPC_EnumType.pType)
puttIdent (yyt->MPC_EnumType.EnumTag)
puttTree (yyt->MPC_EnumType.EnumList)
yyt = yyt->MPC_EnumType.Next; break;
case kMPC_Typedef:
puttPosition (yyt->MPC_Typedef.Pos)
puttTree (yyt->MPC_Typedef.Prev)
puttPosition (yyt->MPC_Typedef.EndPos)
puttTypeFlags (yyt->MPC_Typedef.Flag)
putbool (yyt->MPC_Typedef.Buffer)
putMPC_unsigned_short (yyt->MPC_Typedef.UniqueNumber)
puttTree (yyt->MPC_Typedef.EquivType)
putpVoid (yyt->MPC_Typedef.pType)
puttIdent (yyt->MPC_Typedef.TypedefName)
puttTree (yyt->MPC_Typedef.Type)
yyt = yyt->MPC_Typedef.Next; break;
case kMPC_DerivedType:
puttPosition (yyt->MPC_DerivedType.Pos)
puttTree (yyt->MPC_DerivedType.Prev)
puttPosition (yyt->MPC_DerivedType.EndPos)
puttTypeFlags (yyt->MPC_DerivedType.Flag)
putbool (yyt->MPC_DerivedType.Buffer)
putMPC_unsigned_short (yyt->MPC_DerivedType.UniqueNumber)
puttTree (yyt->MPC_DerivedType.EquivType)
putpVoid (yyt->MPC_DerivedType.pType)
putint (yyt->MPC_DerivedType.NumberOfComponents)
yyt = yyt->MPC_DerivedType.Next; break;
case kMPC_ArrayType:
puttPosition (yyt->MPC_ArrayType.Pos)
puttTree (yyt->MPC_ArrayType.Prev)
puttPosition (yyt->MPC_ArrayType.EndPos)
puttTypeFlags (yyt->MPC_ArrayType.Flag)
putbool (yyt->MPC_ArrayType.Buffer)
putMPC_unsigned_short (yyt->MPC_ArrayType.UniqueNumber)
puttTree (yyt->MPC_ArrayType.EquivType)
putpVoid (yyt->MPC_ArrayType.pType)
putint (yyt->MPC_ArrayType.NumberOfComponents)
putshort (yyt->MPC_ArrayType.Step)
puttTree (yyt->MPC_ArrayType.ElementType)
puttTree (yyt->MPC_ArrayType.ArraySize)
puttTree (yyt->MPC_ArrayType.DynStep)
yyt = yyt->MPC_ArrayType.Next; break;
case kMPC_VectorType:
puttPosition (yyt->MPC_VectorType.Pos)
puttTree (yyt->MPC_VectorType.Prev)
puttPosition (yyt->MPC_VectorType.EndPos)
puttTypeFlags (yyt->MPC_VectorType.Flag)
putbool (yyt->MPC_VectorType.Buffer)
putMPC_unsigned_short (yyt->MPC_VectorType.UniqueNumber)
puttTree (yyt->MPC_VectorType.EquivType)
putpVoid (yyt->MPC_VectorType.pType)
putint (yyt->MPC_VectorType.NumberOfComponents)
puttTree (yyt->MPC_VectorType.ElementType)
puttTree (yyt->MPC_VectorType.VectorSize)
yyt = yyt->MPC_VectorType.Next; break;
case kMPC_PointerType:
puttPosition (yyt->MPC_PointerType.Pos)
puttTree (yyt->MPC_PointerType.Prev)
puttPosition (yyt->MPC_PointerType.EndPos)
puttTypeFlags (yyt->MPC_PointerType.Flag)
putbool (yyt->MPC_PointerType.Buffer)
putMPC_unsigned_short (yyt->MPC_PointerType.UniqueNumber)
puttTree (yyt->MPC_PointerType.EquivType)
putpVoid (yyt->MPC_PointerType.pType)
putint (yyt->MPC_PointerType.NumberOfComponents)
putshort (yyt->MPC_PointerType.Step)
puttTree (yyt->MPC_PointerType.ElementType)
puttTree (yyt->MPC_PointerType.DynStep)
puttTree (yyt->MPC_PointerType.GeneratedFrom)
yyt = yyt->MPC_PointerType.Next; break;
case kMPC_StructType:
puttPosition (yyt->MPC_StructType.Pos)
puttTree (yyt->MPC_StructType.Prev)
puttPosition (yyt->MPC_StructType.EndPos)
puttTypeFlags (yyt->MPC_StructType.Flag)
putbool (yyt->MPC_StructType.Buffer)
putMPC_unsigned_short (yyt->MPC_StructType.UniqueNumber)
puttTree (yyt->MPC_StructType.EquivType)
putpVoid (yyt->MPC_StructType.pType)
putint (yyt->MPC_StructType.NumberOfComponents)
puttIdent (yyt->MPC_StructType.SU_Tag)
puttTree (yyt->MPC_StructType.MemberDecls)
yyt = yyt->MPC_StructType.Next; break;
case kMPC_UnionType:
puttPosition (yyt->MPC_UnionType.Pos)
puttTree (yyt->MPC_UnionType.Prev)
puttPosition (yyt->MPC_UnionType.EndPos)
puttTypeFlags (yyt->MPC_UnionType.Flag)
putbool (yyt->MPC_UnionType.Buffer)
putMPC_unsigned_short (yyt->MPC_UnionType.UniqueNumber)
puttTree (yyt->MPC_UnionType.EquivType)
putpVoid (yyt->MPC_UnionType.pType)
putint (yyt->MPC_UnionType.NumberOfComponents)
puttIdent (yyt->MPC_UnionType.SU_Tag)
puttTree (yyt->MPC_UnionType.MemberDecls)
yyt = yyt->MPC_UnionType.Next; break;
case kMPC_FunctionType:
puttPosition (yyt->MPC_FunctionType.Pos)
puttTree (yyt->MPC_FunctionType.Prev)
puttPosition (yyt->MPC_FunctionType.EndPos)
puttTypeFlags (yyt->MPC_FunctionType.Flag)
putbool (yyt->MPC_FunctionType.Buffer)
putMPC_unsigned_short (yyt->MPC_FunctionType.UniqueNumber)
puttTree (yyt->MPC_FunctionType.EquivType)
putpVoid (yyt->MPC_FunctionType.pType)
putint (yyt->MPC_FunctionType.NumberOfComponents)
putshort (yyt->MPC_FunctionType.Kind)
puttTree (yyt->MPC_FunctionType.ResultType)
puttTree (yyt->MPC_FunctionType.NetParamType)
puttTree (yyt->MPC_FunctionType.NetParam)
puttTree (yyt->MPC_FunctionType.NetworkParamList)
puttTree (yyt->MPC_FunctionType.ParamList)
yyt = yyt->MPC_FunctionType.Next; break;
case kMPC_VarDecl:
puttPosition (yyt->MPC_VarDecl.Pos)
puttTree (yyt->MPC_VarDecl.Prev)
puttPosition (yyt->MPC_VarDecl.EndPos)
puttClass (yyt->MPC_VarDecl.Class)
puttDeclFlags (yyt->MPC_VarDecl.Flag)
puttTree (yyt->MPC_VarDecl.DeclSpecifier)
puttTree (yyt->MPC_VarDecl.Var)
yyt = yyt->MPC_VarDecl.Next; break;
case kMPC_Function:
puttPosition (yyt->MPC_Function.Pos)
puttTree (yyt->MPC_Function.Prev)
puttPosition (yyt->MPC_Function.EndPos)
putshort (yyt->MPC_Function.Kind)
puttDeclFlags (yyt->MPC_Function.Flag)
puttTree (yyt->MPC_Function.Distribution)
puttTree (yyt->MPC_Function.Name)
puttTree (yyt->MPC_Function.Type)
puttTree (yyt->MPC_Function.ParamList)
puttTree (yyt->MPC_Function.Stats)
puttTree (yyt->MPC_Function.LabelList)
yyt = yyt->MPC_Function.Next; break;
case kMPC_Ellipsis:
puttPosition (yyt->MPC_Ellipsis.Pos)
puttTree (yyt->MPC_Ellipsis.Prev)
puttPosition (yyt->MPC_Ellipsis.EndPos)
yyt = yyt->MPC_Ellipsis.Next; break;
case kMPC_NetDecl:
puttPosition (yyt->MPC_NetDecl.Pos)
puttTree (yyt->MPC_NetDecl.Prev)
puttPosition (yyt->MPC_NetDecl.EndPos)
puttClass (yyt->MPC_NetDecl.NetClass)
puttDeclFlags (yyt->MPC_NetDecl.Flag)
puttTree (yyt->MPC_NetDecl.NetTypeSpecifier)
puttTree (yyt->MPC_NetDecl.Net)
yyt = yyt->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl:
puttPosition (yyt->MPC_SubnetDecl.Pos)
puttTree (yyt->MPC_SubnetDecl.Prev)
puttPosition (yyt->MPC_SubnetDecl.EndPos)
puttClass (yyt->MPC_SubnetDecl.SubnetClass)
puttDeclFlags (yyt->MPC_SubnetDecl.Flag)
puttTree (yyt->MPC_SubnetDecl.Subnet)
yyt = yyt->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl:
puttPosition (yyt->MPC_RelDecl.Pos)
puttTree (yyt->MPC_RelDecl.Prev)
puttPosition (yyt->MPC_RelDecl.EndPos)
puttTree (yyt->MPC_RelDecl.Relation)
yyt = yyt->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl:
puttPosition (yyt->MPC_NetTypeDecl.Pos)
puttTree (yyt->MPC_NetTypeDecl.Prev)
puttPosition (yyt->MPC_NetTypeDecl.EndPos)
puttIdent (yyt->MPC_NetTypeDecl.Ident)
yyt = yyt->MPC_NetTypeDecl.Next; break;
case kMPC_NetType:
puttPosition (yyt->MPC_NetType.Pos)
puttTree (yyt->MPC_NetType.Prev)
puttPosition (yyt->MPC_NetType.EndPos)
puttIdent (yyt->MPC_NetType.Ident)
puttClass (yyt->MPC_NetType.Class)
puttTree (yyt->MPC_NetType.ParamList)
puttTree (yyt->MPC_NetType.CoordDecl)
puttTree (yyt->MPC_NetType.NodeDecl)
puttTree (yyt->MPC_NetType.LinkDecl)
puttTree (yyt->MPC_NetType.StartDecl)
puttTree (yyt->MPC_NetType.SchemeDecl)
putbool (yyt->MPC_NetType.Bench)
puttTree (yyt->MPC_NetType.TopoFunctions)
yyt = yyt->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier:
puttPosition (yyt->MPC_NetTypeSpecifier.Pos)
puttTree (yyt->MPC_NetTypeSpecifier.Prev)
puttPosition (yyt->MPC_NetTypeSpecifier.EndPos)
puttIdent (yyt->MPC_NetTypeSpecifier.Ident)
puttTree (yyt->MPC_NetTypeSpecifier.NetType)
puttTree (yyt->MPC_NetTypeSpecifier.ArgList)
yyt = yyt->MPC_NetTypeSpecifier.Next; break;
case kMPC_TopoFunctions:
puttTree (yyt->MPC_TopoFunctions.Node_Def)
puttTree (yyt->MPC_TopoFunctions.Link_Def)
puttTree (yyt->MPC_TopoFunctions.Main_Node_Def)
puttTree (yyt->MPC_TopoFunctions.Power_Def)
puttTree (yyt->MPC_TopoFunctions.Node_Coord_Def)
puttTree (yyt->MPC_TopoFunctions.Node_Number_Def)
yyt = yyt->MPC_TopoFunctions.Mapping_Def; break;
case kMPC_EnumConst:
puttPosition (yyt->MPC_EnumConst.Pos)
puttIdent (yyt->MPC_EnumConst.Name)
putbool (yyt->MPC_EnumConst.WithValue)
putint (yyt->MPC_EnumConst.Value)
puttTree (yyt->MPC_EnumConst.Prev)
puttPosition (yyt->MPC_EnumConst.EndPos)
yyt = yyt->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl:
puttPosition (yyt->MPC_SU_MemberDecl.Pos)
puttTree (yyt->MPC_SU_MemberDecl.Prev)
puttTree (yyt->MPC_SU_MemberDecl.Member)
puttPosition (yyt->MPC_SU_MemberDecl.EndPos)
yyt = yyt->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member:
puttPosition (yyt->MPC_SU_Member.Pos)
puttIdent (yyt->MPC_SU_Member.Name)
putshort (yyt->MPC_SU_Member.BitFieldLength)
puttTree (yyt->MPC_SU_Member.Prev)
puttTree (yyt->MPC_SU_Member.Type)
puttTree (yyt->MPC_SU_Member.BitFieldSize)
puttPosition (yyt->MPC_SU_Member.EndPos)
putMPC_unsigned_short (yyt->MPC_SU_Member.UniqueNumber)
yyt = yyt->MPC_SU_Member.Next; break;
case kMPC_Var:
puttPosition (yyt->MPC_Var.Pos)
puttIdent (yyt->MPC_Var.Ident)
puttDeclFlags (yyt->MPC_Var.Flag)
puttTree (yyt->MPC_Var.Prev)
puttTree (yyt->MPC_Var.Type)
puttTree (yyt->MPC_Var.Distribution)
puttTree (yyt->MPC_Var.Init)
puttPosition (yyt->MPC_Var.EndPos)
yyt = yyt->MPC_Var.Next; break;
case kMPC_CoordDecl:
puttPosition (yyt->MPC_CoordDecl.Pos)
puttIdent (yyt->MPC_CoordDecl.Ident)
puttTree (yyt->MPC_CoordDecl.Prev)
puttTree (yyt->MPC_CoordDecl.Range)
puttPosition (yyt->MPC_CoordDecl.EndPos)
putshort (yyt->MPC_CoordDecl.CoordNumber)
yyt = yyt->MPC_CoordDecl.Next; break;
case kMPC_Node:
puttPosition (yyt->MPC_Node.Pos)
puttNodeType (yyt->MPC_Node.NodeType)
putbool (yyt->MPC_Node.DynamicType)
puttTree (yyt->MPC_Node.Prev)
puttTree (yyt->MPC_Node.Predicate)
puttTree (yyt->MPC_Node.NodeQual)
puttPosition (yyt->MPC_Node.EndPos)
yyt = yyt->MPC_Node.Next; break;
case kMPC_NodeQual:
puttPosition (yyt->MPC_NodeQual.Pos)
puttPosition (yyt->MPC_NodeQual.EndPos)
yyt = yyt->MPC_NodeQual.CapacityExpr; break;
case kMPC_NodeTypeQual:
puttPosition (yyt->MPC_NodeTypeQual.Pos)
puttPosition (yyt->MPC_NodeTypeQual.EndPos)
putbool (yyt->MPC_NodeTypeQual.Fast)
putint (yyt->MPC_NodeTypeQual.Capacity)
yyt = yyt->MPC_NodeTypeQual.CapacityExpr; break;
case kMPC_BenchQual:
puttPosition (yyt->MPC_BenchQual.Pos)
puttPosition (yyt->MPC_BenchQual.EndPos)
putdouble (yyt->MPC_BenchQual.Capacity)
yyt = yyt->MPC_BenchQual.CapacityExpr; break;
case kMPC_LinkDecl:
puttPosition (yyt->MPC_LinkDecl.Pos)
puttTree (yyt->MPC_LinkDecl.FreeCoord)
puttPosition (yyt->MPC_LinkDecl.EndPos)
yyt = yyt->MPC_LinkDecl.LinkDeclaringList; break;
case kMPC_LinkDeclaringList:
puttPosition (yyt->MPC_LinkDeclaringList.Pos)
puttLinkType (yyt->MPC_LinkDeclaringList.LinkType)
putbool (yyt->MPC_LinkDeclaringList.DynamicLength)
puttTree (yyt->MPC_LinkDeclaringList.Prev)
puttTree (yyt->MPC_LinkDeclaringList.Predicate)
puttTree (yyt->MPC_LinkDeclaringList.LinkLengthSpecifier)
puttTree (yyt->MPC_LinkDeclaringList.LinkDeclarator)
puttPosition (yyt->MPC_LinkDeclaringList.EndPos)
yyt = yyt->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator:
puttPosition (yyt->MPC_LinkDeclarator.Pos)
puttTree (yyt->MPC_LinkDeclarator.Prev)
puttTree (yyt->MPC_LinkDeclarator.LeftNode)
puttTree (yyt->MPC_LinkDeclarator.RightNode)
puttPosition (yyt->MPC_LinkDeclarator.EndPos)
yyt = yyt->MPC_LinkDeclarator.Next; break;
case kMPC_LinkLengthSpecifier:
puttPosition (yyt->MPC_LinkLengthSpecifier.Pos)
puttLinkType (yyt->MPC_LinkLengthSpecifier.LinkLength)
puttPosition (yyt->MPC_LinkLengthSpecifier.EndPos)
yyt = yyt->MPC_LinkLengthSpecifier.LinkLengthExpr; break;
case kMPC_Scheme:
puttPosition (yyt->MPC_Scheme.Pos)
puttPosition (yyt->MPC_Scheme.EndPos)
yyt = yyt->MPC_Scheme.Body; break;
case kMPC_NetList:
puttTree (yyt->MPC_NetList.Prev)
puttTree (yyt->MPC_NetList.Net)
puttPosition (yyt->MPC_NetList.Pos)
putbool (yyt->MPC_NetList.UnReduceable)
yyt = yyt->MPC_NetList.Next; break;
case kMPC_NetOrSubnet:
puttPosition (yyt->MPC_NetOrSubnet.Pos)
puttIdent (yyt->MPC_NetOrSubnet.Ident)
putbool (yyt->MPC_NetOrSubnet.BigCreate)
puttTree (yyt->MPC_NetOrSubnet.Distribution)
puttTree (yyt->MPC_NetOrSubnet.Prev)
puttPosition (yyt->MPC_NetOrSubnet.EndPos)
putMPC_unsigned_short (yyt->MPC_NetOrSubnet.UniqueNumber)
putbool (yyt->MPC_NetOrSubnet.WithNumber)
putbool (yyt->MPC_NetOrSubnet.SingleNode)
putbool (yyt->MPC_NetOrSubnet.IsParent)
putpVoid (yyt->MPC_NetOrSubnet.pGen)
puttTree (yyt->MPC_NetOrSubnet.NextUse)
puttTree (yyt->MPC_NetOrSubnet.PrevUse)
puttTree (yyt->MPC_NetOrSubnet.MyList)
yyt = yyt->MPC_NetOrSubnet.Next; break;
case kMPC_Net:
puttPosition (yyt->MPC_Net.Pos)
puttIdent (yyt->MPC_Net.Ident)
putbool (yyt->MPC_Net.BigCreate)
puttTree (yyt->MPC_Net.Distribution)
puttTree (yyt->MPC_Net.Prev)
puttPosition (yyt->MPC_Net.EndPos)
putMPC_unsigned_short (yyt->MPC_Net.UniqueNumber)
putbool (yyt->MPC_Net.WithNumber)
putbool (yyt->MPC_Net.SingleNode)
putbool (yyt->MPC_Net.IsParent)
putpVoid (yyt->MPC_Net.pGen)
puttTree (yyt->MPC_Net.NextUse)
puttTree (yyt->MPC_Net.PrevUse)
puttTree (yyt->MPC_Net.MyList)
putshort (yyt->MPC_Net.Topology)
puttTree (yyt->MPC_Net.NetType)
yyt = yyt->MPC_Net.Next; break;
case kMPC_Subnet:
puttPosition (yyt->MPC_Subnet.Pos)
puttIdent (yyt->MPC_Subnet.Ident)
putbool (yyt->MPC_Subnet.BigCreate)
puttTree (yyt->MPC_Subnet.Distribution)
puttTree (yyt->MPC_Subnet.Prev)
puttPosition (yyt->MPC_Subnet.EndPos)
putMPC_unsigned_short (yyt->MPC_Subnet.UniqueNumber)
putbool (yyt->MPC_Subnet.WithNumber)
putbool (yyt->MPC_Subnet.SingleNode)
putbool (yyt->MPC_Subnet.IsParent)
putpVoid (yyt->MPC_Subnet.pGen)
puttTree (yyt->MPC_Subnet.NextUse)
puttTree (yyt->MPC_Subnet.PrevUse)
puttTree (yyt->MPC_Subnet.MyList)
puttIdent (yyt->MPC_Subnet.NetOrSubnetName)
putbool (yyt->MPC_Subnet.Flexible)
puttTree (yyt->MPC_Subnet.Predicate)
yyt = yyt->MPC_Subnet.Next; break;
case kMPC_Relation:
puttPosition (yyt->MPC_Relation.Pos)
putint (yyt->MPC_Relation.RelCode)
puttTree (yyt->MPC_Relation.Prev)
puttTree (yyt->MPC_Relation.LNet)
puttTree (yyt->MPC_Relation.RNet)
puttPosition (yyt->MPC_Relation.EndPos)
yyt = yyt->MPC_Relation.Next; break;
case kMPC_Stats:
puttPosition (yyt->MPC_Stats.Pos)
puttTree (yyt->MPC_Stats.Prev)
puttPosition (yyt->MPC_Stats.EndPos)
yyt = yyt->MPC_Stats.Next; break;
case kMPC_Stat:
puttPosition (yyt->MPC_Stat.Pos)
puttTree (yyt->MPC_Stat.Prev)
puttPosition (yyt->MPC_Stat.EndPos)
puttStatFlags (yyt->MPC_Stat.Flag)
puttTree (yyt->MPC_Stat.ExecNet)
puttTree (yyt->MPC_Stat.ActualExecNet)
puttTree (yyt->MPC_Stat.RootNet)
puttTree (yyt->MPC_Stat.PropNet)
putbool (yyt->MPC_Stat.Benchmark)
putMPC_unsigned_short (yyt->MPC_Stat.UniqueNumber)
yyt = yyt->MPC_Stat.Next; break;
case kMPC_ExprStat:
puttPosition (yyt->MPC_ExprStat.Pos)
puttTree (yyt->MPC_ExprStat.Prev)
puttPosition (yyt->MPC_ExprStat.EndPos)
puttStatFlags (yyt->MPC_ExprStat.Flag)
puttTree (yyt->MPC_ExprStat.ExecNet)
puttTree (yyt->MPC_ExprStat.ActualExecNet)
puttTree (yyt->MPC_ExprStat.RootNet)
puttTree (yyt->MPC_ExprStat.PropNet)
putbool (yyt->MPC_ExprStat.Benchmark)
putMPC_unsigned_short (yyt->MPC_ExprStat.UniqueNumber)
puttTree (yyt->MPC_ExprStat.Expr)
yyt = yyt->MPC_ExprStat.Next; break;
case kMPC_If:
puttPosition (yyt->MPC_If.Pos)
puttTree (yyt->MPC_If.Prev)
puttPosition (yyt->MPC_If.EndPos)
puttStatFlags (yyt->MPC_If.Flag)
puttTree (yyt->MPC_If.ExecNet)
puttTree (yyt->MPC_If.ActualExecNet)
puttTree (yyt->MPC_If.RootNet)
puttTree (yyt->MPC_If.PropNet)
putbool (yyt->MPC_If.Benchmark)
putMPC_unsigned_short (yyt->MPC_If.UniqueNumber)
puttTree (yyt->MPC_If.Expr)
puttTree (yyt->MPC_If.Stats)
yyt = yyt->MPC_If.Next; break;
case kMPC_IfElse:
puttPosition (yyt->MPC_IfElse.Pos)
puttTree (yyt->MPC_IfElse.Prev)
puttPosition (yyt->MPC_IfElse.EndPos)
puttStatFlags (yyt->MPC_IfElse.Flag)
puttTree (yyt->MPC_IfElse.ExecNet)
puttTree (yyt->MPC_IfElse.ActualExecNet)
puttTree (yyt->MPC_IfElse.RootNet)
puttTree (yyt->MPC_IfElse.PropNet)
putbool (yyt->MPC_IfElse.Benchmark)
putMPC_unsigned_short (yyt->MPC_IfElse.UniqueNumber)
puttTree (yyt->MPC_IfElse.Expr)
puttTree (yyt->MPC_IfElse.Then)
puttTree (yyt->MPC_IfElse.Else)
yyt = yyt->MPC_IfElse.Next; break;
case kMPC_Switch:
puttPosition (yyt->MPC_Switch.Pos)
puttTree (yyt->MPC_Switch.Prev)
puttPosition (yyt->MPC_Switch.EndPos)
puttStatFlags (yyt->MPC_Switch.Flag)
puttTree (yyt->MPC_Switch.ExecNet)
puttTree (yyt->MPC_Switch.ActualExecNet)
puttTree (yyt->MPC_Switch.RootNet)
puttTree (yyt->MPC_Switch.PropNet)
putbool (yyt->MPC_Switch.Benchmark)
putMPC_unsigned_short (yyt->MPC_Switch.UniqueNumber)
puttTree (yyt->MPC_Switch.Expr)
puttTree (yyt->MPC_Switch.Stats)
yyt = yyt->MPC_Switch.Next; break;
case kMPC_While:
puttPosition (yyt->MPC_While.Pos)
puttTree (yyt->MPC_While.Prev)
puttPosition (yyt->MPC_While.EndPos)
puttStatFlags (yyt->MPC_While.Flag)
puttTree (yyt->MPC_While.ExecNet)
puttTree (yyt->MPC_While.ActualExecNet)
puttTree (yyt->MPC_While.RootNet)
puttTree (yyt->MPC_While.PropNet)
putbool (yyt->MPC_While.Benchmark)
putMPC_unsigned_short (yyt->MPC_While.UniqueNumber)
puttTree (yyt->MPC_While.Expr)
puttTree (yyt->MPC_While.Stats)
yyt = yyt->MPC_While.Next; break;
case kMPC_DoWhile:
puttPosition (yyt->MPC_DoWhile.Pos)
puttTree (yyt->MPC_DoWhile.Prev)
puttPosition (yyt->MPC_DoWhile.EndPos)
puttStatFlags (yyt->MPC_DoWhile.Flag)
puttTree (yyt->MPC_DoWhile.ExecNet)
puttTree (yyt->MPC_DoWhile.ActualExecNet)
puttTree (yyt->MPC_DoWhile.RootNet)
puttTree (yyt->MPC_DoWhile.PropNet)
putbool (yyt->MPC_DoWhile.Benchmark)
putMPC_unsigned_short (yyt->MPC_DoWhile.UniqueNumber)
puttTree (yyt->MPC_DoWhile.Stats)
puttTree (yyt->MPC_DoWhile.Expr)
yyt = yyt->MPC_DoWhile.Next; break;
case kMPC_For:
puttPosition (yyt->MPC_For.Pos)
puttTree (yyt->MPC_For.Prev)
puttPosition (yyt->MPC_For.EndPos)
puttStatFlags (yyt->MPC_For.Flag)
puttTree (yyt->MPC_For.ExecNet)
puttTree (yyt->MPC_For.ActualExecNet)
puttTree (yyt->MPC_For.RootNet)
puttTree (yyt->MPC_For.PropNet)
putbool (yyt->MPC_For.Benchmark)
putMPC_unsigned_short (yyt->MPC_For.UniqueNumber)
puttTree (yyt->MPC_For.Init)
puttTree (yyt->MPC_For.Cond)
puttTree (yyt->MPC_For.Reinit)
puttTree (yyt->MPC_For.Stats)
yyt = yyt->MPC_For.Next; break;
case kMPC_Goto:
puttPosition (yyt->MPC_Goto.Pos)
puttTree (yyt->MPC_Goto.Prev)
puttPosition (yyt->MPC_Goto.EndPos)
puttStatFlags (yyt->MPC_Goto.Flag)
puttTree (yyt->MPC_Goto.ExecNet)
puttTree (yyt->MPC_Goto.ActualExecNet)
puttTree (yyt->MPC_Goto.RootNet)
puttTree (yyt->MPC_Goto.PropNet)
putbool (yyt->MPC_Goto.Benchmark)
putMPC_unsigned_short (yyt->MPC_Goto.UniqueNumber)
puttIdent (yyt->MPC_Goto.Ident)
puttTree (yyt->MPC_Goto.LabelDef)
puttTree (yyt->MPC_Goto.NextUse)
puttTree (yyt->MPC_Goto.PrevUse)
yyt = yyt->MPC_Goto.Next; break;
case kMPC_Continue:
puttPosition (yyt->MPC_Continue.Pos)
puttTree (yyt->MPC_Continue.Prev)
puttPosition (yyt->MPC_Continue.EndPos)
puttStatFlags (yyt->MPC_Continue.Flag)
puttTree (yyt->MPC_Continue.ExecNet)
puttTree (yyt->MPC_Continue.ActualExecNet)
puttTree (yyt->MPC_Continue.RootNet)
puttTree (yyt->MPC_Continue.PropNet)
putbool (yyt->MPC_Continue.Benchmark)
putMPC_unsigned_short (yyt->MPC_Continue.UniqueNumber)
yyt = yyt->MPC_Continue.Next; break;
case kMPC_Break:
puttPosition (yyt->MPC_Break.Pos)
puttTree (yyt->MPC_Break.Prev)
puttPosition (yyt->MPC_Break.EndPos)
puttStatFlags (yyt->MPC_Break.Flag)
puttTree (yyt->MPC_Break.ExecNet)
puttTree (yyt->MPC_Break.ActualExecNet)
puttTree (yyt->MPC_Break.RootNet)
puttTree (yyt->MPC_Break.PropNet)
putbool (yyt->MPC_Break.Benchmark)
putMPC_unsigned_short (yyt->MPC_Break.UniqueNumber)
yyt = yyt->MPC_Break.Next; break;
case kMPC_BreakFan:
puttPosition (yyt->MPC_BreakFan.Pos)
puttTree (yyt->MPC_BreakFan.Prev)
puttPosition (yyt->MPC_BreakFan.EndPos)
puttStatFlags (yyt->MPC_BreakFan.Flag)
puttTree (yyt->MPC_BreakFan.ExecNet)
puttTree (yyt->MPC_BreakFan.ActualExecNet)
puttTree (yyt->MPC_BreakFan.RootNet)
puttTree (yyt->MPC_BreakFan.PropNet)
putbool (yyt->MPC_BreakFan.Benchmark)
putMPC_unsigned_short (yyt->MPC_BreakFan.UniqueNumber)
yyt = yyt->MPC_BreakFan.Next; break;
case kMPC_Return:
puttPosition (yyt->MPC_Return.Pos)
puttTree (yyt->MPC_Return.Prev)
puttPosition (yyt->MPC_Return.EndPos)
puttStatFlags (yyt->MPC_Return.Flag)
puttTree (yyt->MPC_Return.ExecNet)
puttTree (yyt->MPC_Return.ActualExecNet)
puttTree (yyt->MPC_Return.RootNet)
puttTree (yyt->MPC_Return.PropNet)
putbool (yyt->MPC_Return.Benchmark)
putMPC_unsigned_short (yyt->MPC_Return.UniqueNumber)
puttTree (yyt->MPC_Return.Expr)
yyt = yyt->MPC_Return.Next; break;
case kMPC_Compound:
puttPosition (yyt->MPC_Compound.Pos)
puttTree (yyt->MPC_Compound.Prev)
puttPosition (yyt->MPC_Compound.EndPos)
puttStatFlags (yyt->MPC_Compound.Flag)
puttTree (yyt->MPC_Compound.ExecNet)
puttTree (yyt->MPC_Compound.ActualExecNet)
puttTree (yyt->MPC_Compound.RootNet)
puttTree (yyt->MPC_Compound.PropNet)
putbool (yyt->MPC_Compound.Benchmark)
putMPC_unsigned_short (yyt->MPC_Compound.UniqueNumber)
putint (yyt->MPC_Compound.FunctionBody)
puttTree (yyt->MPC_Compound.Decls)
puttTree (yyt->MPC_Compound.Stats)
yyt = yyt->MPC_Compound.Next; break;
case kMPC_CompScheme:
puttPosition (yyt->MPC_CompScheme.Pos)
puttTree (yyt->MPC_CompScheme.Prev)
puttPosition (yyt->MPC_CompScheme.EndPos)
puttStatFlags (yyt->MPC_CompScheme.Flag)
puttTree (yyt->MPC_CompScheme.ExecNet)
puttTree (yyt->MPC_CompScheme.ActualExecNet)
puttTree (yyt->MPC_CompScheme.RootNet)
puttTree (yyt->MPC_CompScheme.PropNet)
putbool (yyt->MPC_CompScheme.Benchmark)
putMPC_unsigned_short (yyt->MPC_CompScheme.UniqueNumber)
puttTree (yyt->MPC_CompScheme.Expr)
puttTree (yyt->MPC_CompScheme.Node)
yyt = yyt->MPC_CompScheme.Next; break;
case kMPC_CommScheme:
puttPosition (yyt->MPC_CommScheme.Pos)
puttTree (yyt->MPC_CommScheme.Prev)
puttPosition (yyt->MPC_CommScheme.EndPos)
puttStatFlags (yyt->MPC_CommScheme.Flag)
puttTree (yyt->MPC_CommScheme.ExecNet)
puttTree (yyt->MPC_CommScheme.ActualExecNet)
puttTree (yyt->MPC_CommScheme.RootNet)
puttTree (yyt->MPC_CommScheme.PropNet)
putbool (yyt->MPC_CommScheme.Benchmark)
putMPC_unsigned_short (yyt->MPC_CommScheme.UniqueNumber)
puttTree (yyt->MPC_CommScheme.Expr)
puttTree (yyt->MPC_CommScheme.From)
puttTree (yyt->MPC_CommScheme.To)
yyt = yyt->MPC_CommScheme.Next; break;
case kMPC_ParScheme:
puttPosition (yyt->MPC_ParScheme.Pos)
puttTree (yyt->MPC_ParScheme.Prev)
puttPosition (yyt->MPC_ParScheme.EndPos)
puttStatFlags (yyt->MPC_ParScheme.Flag)
puttTree (yyt->MPC_ParScheme.ExecNet)
puttTree (yyt->MPC_ParScheme.ActualExecNet)
puttTree (yyt->MPC_ParScheme.RootNet)
puttTree (yyt->MPC_ParScheme.PropNet)
putbool (yyt->MPC_ParScheme.Benchmark)
putMPC_unsigned_short (yyt->MPC_ParScheme.UniqueNumber)
puttTree (yyt->MPC_ParScheme.Init)
puttTree (yyt->MPC_ParScheme.Cond)
puttTree (yyt->MPC_ParScheme.Reinit)
puttTree (yyt->MPC_ParScheme.Stats)
yyt = yyt->MPC_ParScheme.Next; break;
case kMPC_Fan:
puttPosition (yyt->MPC_Fan.Pos)
puttTree (yyt->MPC_Fan.Prev)
puttPosition (yyt->MPC_Fan.EndPos)
puttStatFlags (yyt->MPC_Fan.Flag)
puttTree (yyt->MPC_Fan.ExecNet)
puttTree (yyt->MPC_Fan.ActualExecNet)
puttTree (yyt->MPC_Fan.RootNet)
puttTree (yyt->MPC_Fan.PropNet)
putbool (yyt->MPC_Fan.Benchmark)
putMPC_unsigned_short (yyt->MPC_Fan.UniqueNumber)
puttTree (yyt->MPC_Fan.Body)
yyt = yyt->MPC_Fan.Next; break;
case kMPC_Label:
puttPosition (yyt->MPC_Label.Pos)
puttTree (yyt->MPC_Label.Prev)
puttPosition (yyt->MPC_Label.EndPos)
puttTree (yyt->MPC_Label.NextLabel)
puttTree (yyt->MPC_Label.PrevLabel)
yyt = yyt->MPC_Label.Next; break;
case kMPC_IdentLabel:
puttPosition (yyt->MPC_IdentLabel.Pos)
puttTree (yyt->MPC_IdentLabel.Prev)
puttPosition (yyt->MPC_IdentLabel.EndPos)
puttTree (yyt->MPC_IdentLabel.NextLabel)
puttTree (yyt->MPC_IdentLabel.PrevLabel)
puttIdent (yyt->MPC_IdentLabel.Ident)
puttTree (yyt->MPC_IdentLabel.NextUse)
putbool (yyt->MPC_IdentLabel.Used)
yyt = yyt->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel:
puttPosition (yyt->MPC_CaseLabel.Pos)
puttTree (yyt->MPC_CaseLabel.Prev)
puttPosition (yyt->MPC_CaseLabel.EndPos)
puttTree (yyt->MPC_CaseLabel.NextLabel)
puttTree (yyt->MPC_CaseLabel.PrevLabel)
putlong (yyt->MPC_CaseLabel.CaseValue)
puttTree (yyt->MPC_CaseLabel.Expr)
yyt = yyt->MPC_CaseLabel.Next; break;
case kMPC_Default:
puttPosition (yyt->MPC_Default.Pos)
puttTree (yyt->MPC_Default.Prev)
puttPosition (yyt->MPC_Default.EndPos)
puttTree (yyt->MPC_Default.NextLabel)
puttTree (yyt->MPC_Default.PrevLabel)
yyt = yyt->MPC_Default.Next; break;
case kMPC_Expr:
puttPosition (yyt->MPC_Expr.Pos)
puttExprFlags (yyt->MPC_Expr.Flag)
puttString (yyt->MPC_Expr.TmpName)
puttTree (yyt->MPC_Expr.Type)
puttTree (yyt->MPC_Expr.EvalNet)
puttTree (yyt->MPC_Expr.StoreNet)
puttPosition (yyt->MPC_Expr.BegPos)
puttPosition (yyt->MPC_Expr.EndPos)
putchar (yyt->MPC_Expr.Pass)
putbool (yyt->MPC_Expr.Repl)
puttOptm_Attribute (yyt->MPC_Expr.Optm_Attribute)
yyt = yyt->MPC_Expr.ActualEvalNet; break;
case kMPC_Const:
puttPosition (yyt->MPC_Const.Pos)
puttExprFlags (yyt->MPC_Const.Flag)
puttString (yyt->MPC_Const.TmpName)
puttTree (yyt->MPC_Const.Type)
puttTree (yyt->MPC_Const.EvalNet)
puttTree (yyt->MPC_Const.StoreNet)
puttPosition (yyt->MPC_Const.BegPos)
puttPosition (yyt->MPC_Const.EndPos)
putchar (yyt->MPC_Const.Pass)
putbool (yyt->MPC_Const.Repl)
puttOptm_Attribute (yyt->MPC_Const.Optm_Attribute)
puttString (yyt->MPC_Const.SymbolicForm)
yyt = yyt->MPC_Const.ActualEvalNet; break;
case kMPC_IntConst:
puttPosition (yyt->MPC_IntConst.Pos)
puttExprFlags (yyt->MPC_IntConst.Flag)
puttString (yyt->MPC_IntConst.TmpName)
puttTree (yyt->MPC_IntConst.Type)
puttTree (yyt->MPC_IntConst.EvalNet)
puttTree (yyt->MPC_IntConst.StoreNet)
puttPosition (yyt->MPC_IntConst.BegPos)
puttPosition (yyt->MPC_IntConst.EndPos)
putchar (yyt->MPC_IntConst.Pass)
putbool (yyt->MPC_IntConst.Repl)
puttOptm_Attribute (yyt->MPC_IntConst.Optm_Attribute)
puttString (yyt->MPC_IntConst.SymbolicForm)
putlong (yyt->MPC_IntConst.Value)
yyt = yyt->MPC_IntConst.ActualEvalNet; break;
case kMPC_UIntConst:
puttPosition (yyt->MPC_UIntConst.Pos)
puttExprFlags (yyt->MPC_UIntConst.Flag)
puttString (yyt->MPC_UIntConst.TmpName)
puttTree (yyt->MPC_UIntConst.Type)
puttTree (yyt->MPC_UIntConst.EvalNet)
puttTree (yyt->MPC_UIntConst.StoreNet)
puttPosition (yyt->MPC_UIntConst.BegPos)
puttPosition (yyt->MPC_UIntConst.EndPos)
putchar (yyt->MPC_UIntConst.Pass)
putbool (yyt->MPC_UIntConst.Repl)
puttOptm_Attribute (yyt->MPC_UIntConst.Optm_Attribute)
puttString (yyt->MPC_UIntConst.SymbolicForm)
putMPC_long_unsigned (yyt->MPC_UIntConst.Value)
yyt = yyt->MPC_UIntConst.ActualEvalNet; break;
case kMPC_FloatConst:
puttPosition (yyt->MPC_FloatConst.Pos)
puttExprFlags (yyt->MPC_FloatConst.Flag)
puttString (yyt->MPC_FloatConst.TmpName)
puttTree (yyt->MPC_FloatConst.Type)
puttTree (yyt->MPC_FloatConst.EvalNet)
puttTree (yyt->MPC_FloatConst.StoreNet)
puttPosition (yyt->MPC_FloatConst.BegPos)
puttPosition (yyt->MPC_FloatConst.EndPos)
putchar (yyt->MPC_FloatConst.Pass)
putbool (yyt->MPC_FloatConst.Repl)
puttOptm_Attribute (yyt->MPC_FloatConst.Optm_Attribute)
puttString (yyt->MPC_FloatConst.SymbolicForm)
putMPC_long_double (yyt->MPC_FloatConst.Value)
yyt = yyt->MPC_FloatConst.ActualEvalNet; break;
case kMPC_StringLiteral:
puttPosition (yyt->MPC_StringLiteral.Pos)
puttExprFlags (yyt->MPC_StringLiteral.Flag)
puttString (yyt->MPC_StringLiteral.TmpName)
puttTree (yyt->MPC_StringLiteral.Type)
puttTree (yyt->MPC_StringLiteral.EvalNet)
puttTree (yyt->MPC_StringLiteral.StoreNet)
puttPosition (yyt->MPC_StringLiteral.BegPos)
puttPosition (yyt->MPC_StringLiteral.EndPos)
puttTree (yyt->MPC_StringLiteral.ActualEvalNet)
putchar (yyt->MPC_StringLiteral.Pass)
putbool (yyt->MPC_StringLiteral.Repl)
puttOptm_Attribute (yyt->MPC_StringLiteral.Optm_Attribute)
puttString (yyt->MPC_StringLiteral.String)
putshort (yyt->MPC_StringLiteral.FullSize)
puttTree (yyt->MPC_StringLiteral.Prev)
yyt = yyt->MPC_StringLiteral.Next; break;
case kMPC_Ident:
puttPosition (yyt->MPC_Ident.Pos)
puttExprFlags (yyt->MPC_Ident.Flag)
puttString (yyt->MPC_Ident.TmpName)
puttTree (yyt->MPC_Ident.Type)
puttTree (yyt->MPC_Ident.EvalNet)
puttTree (yyt->MPC_Ident.StoreNet)
puttPosition (yyt->MPC_Ident.BegPos)
puttPosition (yyt->MPC_Ident.EndPos)
puttTree (yyt->MPC_Ident.ActualEvalNet)
putchar (yyt->MPC_Ident.Pass)
putbool (yyt->MPC_Ident.Repl)
puttOptm_Attribute (yyt->MPC_Ident.Optm_Attribute)
puttIdent (yyt->MPC_Ident.Ident)
puttTree (yyt->MPC_Ident.Store)
puttTree (yyt->MPC_Ident.NextUse)
yyt = yyt->MPC_Ident.PrevUse; break;
case kMPC_CastExpr:
puttPosition (yyt->MPC_CastExpr.Pos)
puttExprFlags (yyt->MPC_CastExpr.Flag)
puttString (yyt->MPC_CastExpr.TmpName)
puttTree (yyt->MPC_CastExpr.Type)
puttTree (yyt->MPC_CastExpr.EvalNet)
puttTree (yyt->MPC_CastExpr.StoreNet)
puttPosition (yyt->MPC_CastExpr.BegPos)
puttPosition (yyt->MPC_CastExpr.EndPos)
puttTree (yyt->MPC_CastExpr.ActualEvalNet)
putchar (yyt->MPC_CastExpr.Pass)
putbool (yyt->MPC_CastExpr.Repl)
puttOptm_Attribute (yyt->MPC_CastExpr.Optm_Attribute)
puttTree (yyt->MPC_CastExpr.TypeName)
yyt = yyt->MPC_CastExpr.Operand; break;
case kMPC_NetCastExpr:
puttPosition (yyt->MPC_NetCastExpr.Pos)
puttExprFlags (yyt->MPC_NetCastExpr.Flag)
puttString (yyt->MPC_NetCastExpr.TmpName)
puttTree (yyt->MPC_NetCastExpr.Type)
puttTree (yyt->MPC_NetCastExpr.EvalNet)
puttTree (yyt->MPC_NetCastExpr.StoreNet)
puttPosition (yyt->MPC_NetCastExpr.BegPos)
puttPosition (yyt->MPC_NetCastExpr.EndPos)
puttTree (yyt->MPC_NetCastExpr.ActualEvalNet)
putchar (yyt->MPC_NetCastExpr.Pass)
putbool (yyt->MPC_NetCastExpr.Repl)
puttOptm_Attribute (yyt->MPC_NetCastExpr.Optm_Attribute)
putbool (yyt->MPC_NetCastExpr.Flexible)
putpVoid (yyt->MPC_NetCastExpr.ExprPtr)
yyt = yyt->MPC_NetCastExpr.Operand; break;
case kMPC_CoordExpr:
puttPosition (yyt->MPC_CoordExpr.Pos)
puttExprFlags (yyt->MPC_CoordExpr.Flag)
puttString (yyt->MPC_CoordExpr.TmpName)
puttTree (yyt->MPC_CoordExpr.Type)
puttTree (yyt->MPC_CoordExpr.EvalNet)
puttTree (yyt->MPC_CoordExpr.StoreNet)
puttPosition (yyt->MPC_CoordExpr.BegPos)
puttPosition (yyt->MPC_CoordExpr.EndPos)
puttTree (yyt->MPC_CoordExpr.ActualEvalNet)
putchar (yyt->MPC_CoordExpr.Pass)
putbool (yyt->MPC_CoordExpr.Repl)
puttOptm_Attribute (yyt->MPC_CoordExpr.Optm_Attribute)
puttIdent (yyt->MPC_CoordExpr.CoordName)
putshort (yyt->MPC_CoordExpr.CoordNumber)
yyt = yyt->MPC_CoordExpr.Operand; break;
case kMPC_SizeofExpr:
puttPosition (yyt->MPC_SizeofExpr.Pos)
puttExprFlags (yyt->MPC_SizeofExpr.Flag)
puttString (yyt->MPC_SizeofExpr.TmpName)
puttTree (yyt->MPC_SizeofExpr.Type)
puttTree (yyt->MPC_SizeofExpr.EvalNet)
puttTree (yyt->MPC_SizeofExpr.StoreNet)
puttPosition (yyt->MPC_SizeofExpr.BegPos)
puttPosition (yyt->MPC_SizeofExpr.EndPos)
putchar (yyt->MPC_SizeofExpr.Pass)
putbool (yyt->MPC_SizeofExpr.Repl)
puttOptm_Attribute (yyt->MPC_SizeofExpr.Optm_Attribute)
putbool (yyt->MPC_SizeofExpr.CompileTime)
putint (yyt->MPC_SizeofExpr.Value)
yyt = yyt->MPC_SizeofExpr.ActualEvalNet; break;
case kMPC_Size_Of_Value:
puttPosition (yyt->MPC_Size_Of_Value.Pos)
puttExprFlags (yyt->MPC_Size_Of_Value.Flag)
puttString (yyt->MPC_Size_Of_Value.TmpName)
puttTree (yyt->MPC_Size_Of_Value.Type)
puttTree (yyt->MPC_Size_Of_Value.EvalNet)
puttTree (yyt->MPC_Size_Of_Value.StoreNet)
puttPosition (yyt->MPC_Size_Of_Value.BegPos)
puttPosition (yyt->MPC_Size_Of_Value.EndPos)
puttTree (yyt->MPC_Size_Of_Value.ActualEvalNet)
putchar (yyt->MPC_Size_Of_Value.Pass)
putbool (yyt->MPC_Size_Of_Value.Repl)
puttOptm_Attribute (yyt->MPC_Size_Of_Value.Optm_Attribute)
putbool (yyt->MPC_Size_Of_Value.CompileTime)
putint (yyt->MPC_Size_Of_Value.Value)
yyt = yyt->MPC_Size_Of_Value.Operand; break;
case kMPC_Size_Of_Type:
puttPosition (yyt->MPC_Size_Of_Type.Pos)
puttExprFlags (yyt->MPC_Size_Of_Type.Flag)
puttString (yyt->MPC_Size_Of_Type.TmpName)
puttTree (yyt->MPC_Size_Of_Type.Type)
puttTree (yyt->MPC_Size_Of_Type.EvalNet)
puttTree (yyt->MPC_Size_Of_Type.StoreNet)
puttPosition (yyt->MPC_Size_Of_Type.BegPos)
puttPosition (yyt->MPC_Size_Of_Type.EndPos)
puttTree (yyt->MPC_Size_Of_Type.ActualEvalNet)
putchar (yyt->MPC_Size_Of_Type.Pass)
putbool (yyt->MPC_Size_Of_Type.Repl)
puttOptm_Attribute (yyt->MPC_Size_Of_Type.Optm_Attribute)
putbool (yyt->MPC_Size_Of_Type.CompileTime)
putint (yyt->MPC_Size_Of_Type.Value)
yyt = yyt->MPC_Size_Of_Type.Operand; break;
case kMPC_TimeofExpr:
puttPosition (yyt->MPC_TimeofExpr.Pos)
puttExprFlags (yyt->MPC_TimeofExpr.Flag)
puttString (yyt->MPC_TimeofExpr.TmpName)
puttTree (yyt->MPC_TimeofExpr.Type)
puttTree (yyt->MPC_TimeofExpr.EvalNet)
puttTree (yyt->MPC_TimeofExpr.StoreNet)
puttPosition (yyt->MPC_TimeofExpr.BegPos)
puttPosition (yyt->MPC_TimeofExpr.EndPos)
puttTree (yyt->MPC_TimeofExpr.ActualEvalNet)
putchar (yyt->MPC_TimeofExpr.Pass)
putbool (yyt->MPC_TimeofExpr.Repl)
puttOptm_Attribute (yyt->MPC_TimeofExpr.Optm_Attribute)
yyt = yyt->MPC_TimeofExpr.NetDecl; break;
case kMPC_UnaryExpr:
puttPosition (yyt->MPC_UnaryExpr.Pos)
puttExprFlags (yyt->MPC_UnaryExpr.Flag)
puttString (yyt->MPC_UnaryExpr.TmpName)
puttTree (yyt->MPC_UnaryExpr.Type)
puttTree (yyt->MPC_UnaryExpr.EvalNet)
puttTree (yyt->MPC_UnaryExpr.StoreNet)
puttPosition (yyt->MPC_UnaryExpr.BegPos)
puttPosition (yyt->MPC_UnaryExpr.EndPos)
puttTree (yyt->MPC_UnaryExpr.ActualEvalNet)
putchar (yyt->MPC_UnaryExpr.Pass)
putbool (yyt->MPC_UnaryExpr.Repl)
puttOptm_Attribute (yyt->MPC_UnaryExpr.Optm_Attribute)
putshort (yyt->MPC_UnaryExpr.OpCode)
yyt = yyt->MPC_UnaryExpr.Operand; break;
case kMPC_BinaryExpr:
puttPosition (yyt->MPC_BinaryExpr.Pos)
puttExprFlags (yyt->MPC_BinaryExpr.Flag)
puttString (yyt->MPC_BinaryExpr.TmpName)
puttTree (yyt->MPC_BinaryExpr.Type)
puttTree (yyt->MPC_BinaryExpr.EvalNet)
puttTree (yyt->MPC_BinaryExpr.StoreNet)
puttPosition (yyt->MPC_BinaryExpr.BegPos)
puttPosition (yyt->MPC_BinaryExpr.EndPos)
puttTree (yyt->MPC_BinaryExpr.ActualEvalNet)
putchar (yyt->MPC_BinaryExpr.Pass)
putbool (yyt->MPC_BinaryExpr.Repl)
puttOptm_Attribute (yyt->MPC_BinaryExpr.Optm_Attribute)
putshort (yyt->MPC_BinaryExpr.OpCode)
puttTree (yyt->MPC_BinaryExpr.Loperand)
yyt = yyt->MPC_BinaryExpr.Roperand; break;
case kMPC_TernaryExpr:
puttPosition (yyt->MPC_TernaryExpr.Pos)
puttExprFlags (yyt->MPC_TernaryExpr.Flag)
puttString (yyt->MPC_TernaryExpr.TmpName)
puttTree (yyt->MPC_TernaryExpr.Type)
puttTree (yyt->MPC_TernaryExpr.EvalNet)
puttTree (yyt->MPC_TernaryExpr.StoreNet)
puttPosition (yyt->MPC_TernaryExpr.BegPos)
puttPosition (yyt->MPC_TernaryExpr.EndPos)
puttTree (yyt->MPC_TernaryExpr.ActualEvalNet)
putchar (yyt->MPC_TernaryExpr.Pass)
putbool (yyt->MPC_TernaryExpr.Repl)
puttOptm_Attribute (yyt->MPC_TernaryExpr.Optm_Attribute)
putshort (yyt->MPC_TernaryExpr.OpCode)
puttTree (yyt->MPC_TernaryExpr.Foperand)
puttTree (yyt->MPC_TernaryExpr.Soperand)
yyt = yyt->MPC_TernaryExpr.Toperand; break;
case kMPC_QuaternaryExpr:
puttPosition (yyt->MPC_QuaternaryExpr.Pos)
puttExprFlags (yyt->MPC_QuaternaryExpr.Flag)
puttString (yyt->MPC_QuaternaryExpr.TmpName)
puttTree (yyt->MPC_QuaternaryExpr.Type)
puttTree (yyt->MPC_QuaternaryExpr.EvalNet)
puttTree (yyt->MPC_QuaternaryExpr.StoreNet)
puttPosition (yyt->MPC_QuaternaryExpr.BegPos)
puttPosition (yyt->MPC_QuaternaryExpr.EndPos)
puttTree (yyt->MPC_QuaternaryExpr.ActualEvalNet)
putchar (yyt->MPC_QuaternaryExpr.Pass)
putbool (yyt->MPC_QuaternaryExpr.Repl)
puttOptm_Attribute (yyt->MPC_QuaternaryExpr.Optm_Attribute)
putshort (yyt->MPC_QuaternaryExpr.OpCode)
puttTree (yyt->MPC_QuaternaryExpr.Operand1)
puttTree (yyt->MPC_QuaternaryExpr.Operand2)
puttTree (yyt->MPC_QuaternaryExpr.Operand3)
yyt = yyt->MPC_QuaternaryExpr.Operand4; break;
case kMPC_CallExpr:
puttPosition (yyt->MPC_CallExpr.Pos)
puttExprFlags (yyt->MPC_CallExpr.Flag)
puttString (yyt->MPC_CallExpr.TmpName)
puttTree (yyt->MPC_CallExpr.Type)
puttTree (yyt->MPC_CallExpr.EvalNet)
puttTree (yyt->MPC_CallExpr.StoreNet)
puttPosition (yyt->MPC_CallExpr.BegPos)
puttPosition (yyt->MPC_CallExpr.EndPos)
puttTree (yyt->MPC_CallExpr.ActualEvalNet)
putchar (yyt->MPC_CallExpr.Pass)
putbool (yyt->MPC_CallExpr.Repl)
puttOptm_Attribute (yyt->MPC_CallExpr.Optm_Attribute)
puttTree (yyt->MPC_CallExpr.Function)
puttTree (yyt->MPC_CallExpr.ArgList)
yyt = yyt->MPC_CallExpr.NetworkArgList; break;
case kMPC_Exprs:
puttPosition (yyt->MPC_Exprs.Pos)
puttTree (yyt->MPC_Exprs.Prev)
puttTree (yyt->MPC_Exprs.Expr)
puttPosition (yyt->MPC_Exprs.BegPos)
puttPosition (yyt->MPC_Exprs.EndPos)
yyt = yyt->MPC_Exprs.Next; break;
case kMPC_Initializer:
puttPosition (yyt->MPC_Initializer.Pos)
puttTree (yyt->MPC_Initializer.Prev)
puttPosition (yyt->MPC_Initializer.EndPos)
yyt = yyt->MPC_Initializer.Next; break;
case kMPC_SimpleInit:
puttPosition (yyt->MPC_SimpleInit.Pos)
puttTree (yyt->MPC_SimpleInit.Prev)
puttPosition (yyt->MPC_SimpleInit.EndPos)
puttTree (yyt->MPC_SimpleInit.Expr)
yyt = yyt->MPC_SimpleInit.Next; break;
case kMPC_InitList:
puttPosition (yyt->MPC_InitList.Pos)
puttTree (yyt->MPC_InitList.Prev)
puttPosition (yyt->MPC_InitList.EndPos)
putint (yyt->MPC_InitList.Length)
puttTree (yyt->MPC_InitList.List)
yyt = yyt->MPC_InitList.Next; break;
  default: return;
  }
 }
}

void PutTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyPutTree (yyt);
 yyRecursionLevel --;
}

static void yyGet
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fread (yyx, 1, yysize, yyf); }

static void yyGetIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent * yyi)
# else
 (yyi) tIdent * yyi;
# endif
{
 char yys [256];
 (void) fscanf (yyf, "%s%*c", yys);
 * yyi = MakeIdent ((tString) yys, strlen (yys));
}

static void yyGetTree
# if defined __STDC__ | defined __cplusplus
 (yyPtrtTree yyt)
# else
 (yyt) yyPtrtTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 static Tree_tKind yyKind;
 for (;;) {
  switch (yyKind = getc (yyf)) {
  case yyNil		: * yyt = NoTree; return;
  case yyLabelUse	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   * yyt = yyMapToTree (yyLabel); return;
  case yyLabelDef	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   yyKind = getc (yyf);   * yyt = MakeTree (yyKind);
   if (yyLabel != yyMapToLabel (* yyt)) { (void) fputs ("Tree: error in GetTree\n", stderr); Tree_Exit (); } break;
  default	: * yyt = MakeTree (yyKind);
  }

  switch (yyKind) {
case kMPC_Root:
gettTree (& ((* yyt)->MPC_Root.Decls))
gettTree (& ((* yyt)->MPC_Root.Source))
gettTree (& ((* yyt)->MPC_Root.Messages))
gettTree (& ((* yyt)->MPC_Root.Host))
gettTree (& ((* yyt)->MPC_Root.SingleNode))
gettTree (& ((* yyt)->MPC_Root.ComputingSpace))
gettTree (& ((* yyt)->MPC_Root.Const))
gettTree (& ((* yyt)->MPC_Root.Recon))
gettTree (& ((* yyt)->MPC_Root.HostList))
gettTree (& ((* yyt)->MPC_Root.SingleNodeList))
gettTree (& ((* yyt)->MPC_Root.ComputingSpaceList))
gettTree (& ((* yyt)->MPC_Root.ConstList))
yyt = & ((* yyt)->MPC_Root.ReconList); break;
case kMPC_Source:
gettString ((* yyt)->MPC_Source.FileName)
gettPosition ((* yyt)->MPC_Source.VirtPos)
gettPosition ((* yyt)->MPC_Source.RealPos)
gettTree (& ((* yyt)->MPC_Source.Prev))
yyt = & ((* yyt)->MPC_Source.Next); break;
case kMPC_Messages:
getint ((* yyt)->MPC_Messages.ErrorClass)
gettPosition ((* yyt)->MPC_Messages.Pos)
gettTree (& ((* yyt)->MPC_Messages.Prev))
gettTree (& ((* yyt)->MPC_Messages.Tree))
yyt = & ((* yyt)->MPC_Messages.Next); break;
case kMPC_ErrorMessage:
getint ((* yyt)->MPC_ErrorMessage.ErrorClass)
gettPosition ((* yyt)->MPC_ErrorMessage.Pos)
gettTree (& ((* yyt)->MPC_ErrorMessage.Prev))
gettTree (& ((* yyt)->MPC_ErrorMessage.Tree))
getint ((* yyt)->MPC_ErrorMessage.ErrorCode)
yyt = & ((* yyt)->MPC_ErrorMessage.Next); break;
case kMPC_ErrorMessageI:
getint ((* yyt)->MPC_ErrorMessageI.ErrorClass)
gettPosition ((* yyt)->MPC_ErrorMessageI.Pos)
gettTree (& ((* yyt)->MPC_ErrorMessageI.Prev))
gettTree (& ((* yyt)->MPC_ErrorMessageI.Tree))
getint ((* yyt)->MPC_ErrorMessageI.ErrorCode)
getint ((* yyt)->MPC_ErrorMessageI.InfoClass)
gettString ((* yyt)->MPC_ErrorMessageI.Info)
yyt = & ((* yyt)->MPC_ErrorMessageI.Next); break;
case kMPC_Message:
getint ((* yyt)->MPC_Message.ErrorClass)
gettPosition ((* yyt)->MPC_Message.Pos)
gettTree (& ((* yyt)->MPC_Message.Prev))
gettTree (& ((* yyt)->MPC_Message.Tree))
getshort ((* yyt)->MPC_Message.MessageNumber)
yyt = & ((* yyt)->MPC_Message.Next); break;
case kMPC_MessageI:
getint ((* yyt)->MPC_MessageI.ErrorClass)
gettPosition ((* yyt)->MPC_MessageI.Pos)
gettTree (& ((* yyt)->MPC_MessageI.Prev))
gettTree (& ((* yyt)->MPC_MessageI.Tree))
getshort ((* yyt)->MPC_MessageI.MessageNumber)
getint ((* yyt)->MPC_MessageI.InfoClass)
gettString ((* yyt)->MPC_MessageI.Info)
yyt = & ((* yyt)->MPC_MessageI.Next); break;
case kMPC_FreeNode:
yyt = & ((* yyt)->MPC_FreeNode.Parent); break;
case kMPC_Decls:
gettPosition ((* yyt)->MPC_Decls.Pos)
gettTree (& ((* yyt)->MPC_Decls.Prev))
gettPosition ((* yyt)->MPC_Decls.EndPos)
yyt = & ((* yyt)->MPC_Decls.Next); break;
case kMPC_UncompString:
gettPosition ((* yyt)->MPC_UncompString.Pos)
gettTree (& ((* yyt)->MPC_UncompString.Prev))
gettPosition ((* yyt)->MPC_UncompString.EndPos)
gettString ((* yyt)->MPC_UncompString.uString)
yyt = & ((* yyt)->MPC_UncompString.Next); break;
case kMPC_Type:
gettPosition ((* yyt)->MPC_Type.Pos)
gettTree (& ((* yyt)->MPC_Type.Prev))
gettPosition ((* yyt)->MPC_Type.EndPos)
gettTypeFlags ((* yyt)->MPC_Type.Flag)
getbool ((* yyt)->MPC_Type.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_Type.UniqueNumber)
gettTree (& ((* yyt)->MPC_Type.EquivType))
getpVoid ((* yyt)->MPC_Type.pType)
yyt = & ((* yyt)->MPC_Type.Next); break;
case kMPC_BasicType:
gettPosition ((* yyt)->MPC_BasicType.Pos)
gettTree (& ((* yyt)->MPC_BasicType.Prev))
gettPosition ((* yyt)->MPC_BasicType.EndPos)
gettTypeFlags ((* yyt)->MPC_BasicType.Flag)
getbool ((* yyt)->MPC_BasicType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_BasicType.UniqueNumber)
gettTree (& ((* yyt)->MPC_BasicType.EquivType))
getpVoid ((* yyt)->MPC_BasicType.pType)
getshort ((* yyt)->MPC_BasicType.TypeConstructor)
yyt = & ((* yyt)->MPC_BasicType.Next); break;
case kMPC_EnumType:
gettPosition ((* yyt)->MPC_EnumType.Pos)
gettTree (& ((* yyt)->MPC_EnumType.Prev))
gettPosition ((* yyt)->MPC_EnumType.EndPos)
gettTypeFlags ((* yyt)->MPC_EnumType.Flag)
getbool ((* yyt)->MPC_EnumType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_EnumType.UniqueNumber)
gettTree (& ((* yyt)->MPC_EnumType.EquivType))
getpVoid ((* yyt)->MPC_EnumType.pType)
gettIdent ((* yyt)->MPC_EnumType.EnumTag)
gettTree (& ((* yyt)->MPC_EnumType.EnumList))
yyt = & ((* yyt)->MPC_EnumType.Next); break;
case kMPC_Typedef:
gettPosition ((* yyt)->MPC_Typedef.Pos)
gettTree (& ((* yyt)->MPC_Typedef.Prev))
gettPosition ((* yyt)->MPC_Typedef.EndPos)
gettTypeFlags ((* yyt)->MPC_Typedef.Flag)
getbool ((* yyt)->MPC_Typedef.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_Typedef.UniqueNumber)
gettTree (& ((* yyt)->MPC_Typedef.EquivType))
getpVoid ((* yyt)->MPC_Typedef.pType)
gettIdent ((* yyt)->MPC_Typedef.TypedefName)
gettTree (& ((* yyt)->MPC_Typedef.Type))
yyt = & ((* yyt)->MPC_Typedef.Next); break;
case kMPC_DerivedType:
gettPosition ((* yyt)->MPC_DerivedType.Pos)
gettTree (& ((* yyt)->MPC_DerivedType.Prev))
gettPosition ((* yyt)->MPC_DerivedType.EndPos)
gettTypeFlags ((* yyt)->MPC_DerivedType.Flag)
getbool ((* yyt)->MPC_DerivedType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_DerivedType.UniqueNumber)
gettTree (& ((* yyt)->MPC_DerivedType.EquivType))
getpVoid ((* yyt)->MPC_DerivedType.pType)
getint ((* yyt)->MPC_DerivedType.NumberOfComponents)
yyt = & ((* yyt)->MPC_DerivedType.Next); break;
case kMPC_ArrayType:
gettPosition ((* yyt)->MPC_ArrayType.Pos)
gettTree (& ((* yyt)->MPC_ArrayType.Prev))
gettPosition ((* yyt)->MPC_ArrayType.EndPos)
gettTypeFlags ((* yyt)->MPC_ArrayType.Flag)
getbool ((* yyt)->MPC_ArrayType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_ArrayType.UniqueNumber)
gettTree (& ((* yyt)->MPC_ArrayType.EquivType))
getpVoid ((* yyt)->MPC_ArrayType.pType)
getint ((* yyt)->MPC_ArrayType.NumberOfComponents)
getshort ((* yyt)->MPC_ArrayType.Step)
gettTree (& ((* yyt)->MPC_ArrayType.ElementType))
gettTree (& ((* yyt)->MPC_ArrayType.ArraySize))
gettTree (& ((* yyt)->MPC_ArrayType.DynStep))
yyt = & ((* yyt)->MPC_ArrayType.Next); break;
case kMPC_VectorType:
gettPosition ((* yyt)->MPC_VectorType.Pos)
gettTree (& ((* yyt)->MPC_VectorType.Prev))
gettPosition ((* yyt)->MPC_VectorType.EndPos)
gettTypeFlags ((* yyt)->MPC_VectorType.Flag)
getbool ((* yyt)->MPC_VectorType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_VectorType.UniqueNumber)
gettTree (& ((* yyt)->MPC_VectorType.EquivType))
getpVoid ((* yyt)->MPC_VectorType.pType)
getint ((* yyt)->MPC_VectorType.NumberOfComponents)
gettTree (& ((* yyt)->MPC_VectorType.ElementType))
gettTree (& ((* yyt)->MPC_VectorType.VectorSize))
yyt = & ((* yyt)->MPC_VectorType.Next); break;
case kMPC_PointerType:
gettPosition ((* yyt)->MPC_PointerType.Pos)
gettTree (& ((* yyt)->MPC_PointerType.Prev))
gettPosition ((* yyt)->MPC_PointerType.EndPos)
gettTypeFlags ((* yyt)->MPC_PointerType.Flag)
getbool ((* yyt)->MPC_PointerType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_PointerType.UniqueNumber)
gettTree (& ((* yyt)->MPC_PointerType.EquivType))
getpVoid ((* yyt)->MPC_PointerType.pType)
getint ((* yyt)->MPC_PointerType.NumberOfComponents)
getshort ((* yyt)->MPC_PointerType.Step)
gettTree (& ((* yyt)->MPC_PointerType.ElementType))
gettTree (& ((* yyt)->MPC_PointerType.DynStep))
gettTree (& ((* yyt)->MPC_PointerType.GeneratedFrom))
yyt = & ((* yyt)->MPC_PointerType.Next); break;
case kMPC_StructType:
gettPosition ((* yyt)->MPC_StructType.Pos)
gettTree (& ((* yyt)->MPC_StructType.Prev))
gettPosition ((* yyt)->MPC_StructType.EndPos)
gettTypeFlags ((* yyt)->MPC_StructType.Flag)
getbool ((* yyt)->MPC_StructType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_StructType.UniqueNumber)
gettTree (& ((* yyt)->MPC_StructType.EquivType))
getpVoid ((* yyt)->MPC_StructType.pType)
getint ((* yyt)->MPC_StructType.NumberOfComponents)
gettIdent ((* yyt)->MPC_StructType.SU_Tag)
gettTree (& ((* yyt)->MPC_StructType.MemberDecls))
yyt = & ((* yyt)->MPC_StructType.Next); break;
case kMPC_UnionType:
gettPosition ((* yyt)->MPC_UnionType.Pos)
gettTree (& ((* yyt)->MPC_UnionType.Prev))
gettPosition ((* yyt)->MPC_UnionType.EndPos)
gettTypeFlags ((* yyt)->MPC_UnionType.Flag)
getbool ((* yyt)->MPC_UnionType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_UnionType.UniqueNumber)
gettTree (& ((* yyt)->MPC_UnionType.EquivType))
getpVoid ((* yyt)->MPC_UnionType.pType)
getint ((* yyt)->MPC_UnionType.NumberOfComponents)
gettIdent ((* yyt)->MPC_UnionType.SU_Tag)
gettTree (& ((* yyt)->MPC_UnionType.MemberDecls))
yyt = & ((* yyt)->MPC_UnionType.Next); break;
case kMPC_FunctionType:
gettPosition ((* yyt)->MPC_FunctionType.Pos)
gettTree (& ((* yyt)->MPC_FunctionType.Prev))
gettPosition ((* yyt)->MPC_FunctionType.EndPos)
gettTypeFlags ((* yyt)->MPC_FunctionType.Flag)
getbool ((* yyt)->MPC_FunctionType.Buffer)
getMPC_unsigned_short ((* yyt)->MPC_FunctionType.UniqueNumber)
gettTree (& ((* yyt)->MPC_FunctionType.EquivType))
getpVoid ((* yyt)->MPC_FunctionType.pType)
getint ((* yyt)->MPC_FunctionType.NumberOfComponents)
getshort ((* yyt)->MPC_FunctionType.Kind)
gettTree (& ((* yyt)->MPC_FunctionType.ResultType))
gettTree (& ((* yyt)->MPC_FunctionType.NetParamType))
gettTree (& ((* yyt)->MPC_FunctionType.NetParam))
gettTree (& ((* yyt)->MPC_FunctionType.NetworkParamList))
gettTree (& ((* yyt)->MPC_FunctionType.ParamList))
yyt = & ((* yyt)->MPC_FunctionType.Next); break;
case kMPC_VarDecl:
gettPosition ((* yyt)->MPC_VarDecl.Pos)
gettTree (& ((* yyt)->MPC_VarDecl.Prev))
gettPosition ((* yyt)->MPC_VarDecl.EndPos)
gettClass ((* yyt)->MPC_VarDecl.Class)
gettDeclFlags ((* yyt)->MPC_VarDecl.Flag)
gettTree (& ((* yyt)->MPC_VarDecl.DeclSpecifier))
gettTree (& ((* yyt)->MPC_VarDecl.Var))
yyt = & ((* yyt)->MPC_VarDecl.Next); break;
case kMPC_Function:
gettPosition ((* yyt)->MPC_Function.Pos)
gettTree (& ((* yyt)->MPC_Function.Prev))
gettPosition ((* yyt)->MPC_Function.EndPos)
getshort ((* yyt)->MPC_Function.Kind)
gettDeclFlags ((* yyt)->MPC_Function.Flag)
gettTree (& ((* yyt)->MPC_Function.Distribution))
gettTree (& ((* yyt)->MPC_Function.Name))
gettTree (& ((* yyt)->MPC_Function.Type))
gettTree (& ((* yyt)->MPC_Function.ParamList))
gettTree (& ((* yyt)->MPC_Function.Stats))
gettTree (& ((* yyt)->MPC_Function.LabelList))
yyt = & ((* yyt)->MPC_Function.Next); break;
case kMPC_Ellipsis:
gettPosition ((* yyt)->MPC_Ellipsis.Pos)
gettTree (& ((* yyt)->MPC_Ellipsis.Prev))
gettPosition ((* yyt)->MPC_Ellipsis.EndPos)
yyt = & ((* yyt)->MPC_Ellipsis.Next); break;
case kMPC_NetDecl:
gettPosition ((* yyt)->MPC_NetDecl.Pos)
gettTree (& ((* yyt)->MPC_NetDecl.Prev))
gettPosition ((* yyt)->MPC_NetDecl.EndPos)
gettClass ((* yyt)->MPC_NetDecl.NetClass)
gettDeclFlags ((* yyt)->MPC_NetDecl.Flag)
gettTree (& ((* yyt)->MPC_NetDecl.NetTypeSpecifier))
gettTree (& ((* yyt)->MPC_NetDecl.Net))
yyt = & ((* yyt)->MPC_NetDecl.Next); break;
case kMPC_SubnetDecl:
gettPosition ((* yyt)->MPC_SubnetDecl.Pos)
gettTree (& ((* yyt)->MPC_SubnetDecl.Prev))
gettPosition ((* yyt)->MPC_SubnetDecl.EndPos)
gettClass ((* yyt)->MPC_SubnetDecl.SubnetClass)
gettDeclFlags ((* yyt)->MPC_SubnetDecl.Flag)
gettTree (& ((* yyt)->MPC_SubnetDecl.Subnet))
yyt = & ((* yyt)->MPC_SubnetDecl.Next); break;
case kMPC_RelDecl:
gettPosition ((* yyt)->MPC_RelDecl.Pos)
gettTree (& ((* yyt)->MPC_RelDecl.Prev))
gettPosition ((* yyt)->MPC_RelDecl.EndPos)
gettTree (& ((* yyt)->MPC_RelDecl.Relation))
yyt = & ((* yyt)->MPC_RelDecl.Next); break;
case kMPC_NetTypeDecl:
gettPosition ((* yyt)->MPC_NetTypeDecl.Pos)
gettTree (& ((* yyt)->MPC_NetTypeDecl.Prev))
gettPosition ((* yyt)->MPC_NetTypeDecl.EndPos)
gettIdent ((* yyt)->MPC_NetTypeDecl.Ident)
yyt = & ((* yyt)->MPC_NetTypeDecl.Next); break;
case kMPC_NetType:
gettPosition ((* yyt)->MPC_NetType.Pos)
gettTree (& ((* yyt)->MPC_NetType.Prev))
gettPosition ((* yyt)->MPC_NetType.EndPos)
gettIdent ((* yyt)->MPC_NetType.Ident)
gettClass ((* yyt)->MPC_NetType.Class)
gettTree (& ((* yyt)->MPC_NetType.ParamList))
gettTree (& ((* yyt)->MPC_NetType.CoordDecl))
gettTree (& ((* yyt)->MPC_NetType.NodeDecl))
gettTree (& ((* yyt)->MPC_NetType.LinkDecl))
gettTree (& ((* yyt)->MPC_NetType.StartDecl))
gettTree (& ((* yyt)->MPC_NetType.SchemeDecl))
getbool ((* yyt)->MPC_NetType.Bench)
gettTree (& ((* yyt)->MPC_NetType.TopoFunctions))
yyt = & ((* yyt)->MPC_NetType.Next); break;
case kMPC_NetTypeSpecifier:
gettPosition ((* yyt)->MPC_NetTypeSpecifier.Pos)
gettTree (& ((* yyt)->MPC_NetTypeSpecifier.Prev))
gettPosition ((* yyt)->MPC_NetTypeSpecifier.EndPos)
gettIdent ((* yyt)->MPC_NetTypeSpecifier.Ident)
gettTree (& ((* yyt)->MPC_NetTypeSpecifier.NetType))
gettTree (& ((* yyt)->MPC_NetTypeSpecifier.ArgList))
yyt = & ((* yyt)->MPC_NetTypeSpecifier.Next); break;
case kMPC_TopoFunctions:
gettTree (& ((* yyt)->MPC_TopoFunctions.Node_Def))
gettTree (& ((* yyt)->MPC_TopoFunctions.Link_Def))
gettTree (& ((* yyt)->MPC_TopoFunctions.Main_Node_Def))
gettTree (& ((* yyt)->MPC_TopoFunctions.Power_Def))
gettTree (& ((* yyt)->MPC_TopoFunctions.Node_Coord_Def))
gettTree (& ((* yyt)->MPC_TopoFunctions.Node_Number_Def))
yyt = & ((* yyt)->MPC_TopoFunctions.Mapping_Def); break;
case kMPC_EnumConst:
gettPosition ((* yyt)->MPC_EnumConst.Pos)
gettIdent ((* yyt)->MPC_EnumConst.Name)
getbool ((* yyt)->MPC_EnumConst.WithValue)
getint ((* yyt)->MPC_EnumConst.Value)
gettTree (& ((* yyt)->MPC_EnumConst.Prev))
gettPosition ((* yyt)->MPC_EnumConst.EndPos)
yyt = & ((* yyt)->MPC_EnumConst.Next); break;
case kMPC_SU_MemberDecl:
gettPosition ((* yyt)->MPC_SU_MemberDecl.Pos)
gettTree (& ((* yyt)->MPC_SU_MemberDecl.Prev))
gettTree (& ((* yyt)->MPC_SU_MemberDecl.Member))
gettPosition ((* yyt)->MPC_SU_MemberDecl.EndPos)
yyt = & ((* yyt)->MPC_SU_MemberDecl.Next); break;
case kMPC_SU_Member:
gettPosition ((* yyt)->MPC_SU_Member.Pos)
gettIdent ((* yyt)->MPC_SU_Member.Name)
getshort ((* yyt)->MPC_SU_Member.BitFieldLength)
gettTree (& ((* yyt)->MPC_SU_Member.Prev))
gettTree (& ((* yyt)->MPC_SU_Member.Type))
gettTree (& ((* yyt)->MPC_SU_Member.BitFieldSize))
gettPosition ((* yyt)->MPC_SU_Member.EndPos)
getMPC_unsigned_short ((* yyt)->MPC_SU_Member.UniqueNumber)
yyt = & ((* yyt)->MPC_SU_Member.Next); break;
case kMPC_Var:
gettPosition ((* yyt)->MPC_Var.Pos)
gettIdent ((* yyt)->MPC_Var.Ident)
gettDeclFlags ((* yyt)->MPC_Var.Flag)
gettTree (& ((* yyt)->MPC_Var.Prev))
gettTree (& ((* yyt)->MPC_Var.Type))
gettTree (& ((* yyt)->MPC_Var.Distribution))
gettTree (& ((* yyt)->MPC_Var.Init))
gettPosition ((* yyt)->MPC_Var.EndPos)
yyt = & ((* yyt)->MPC_Var.Next); break;
case kMPC_CoordDecl:
gettPosition ((* yyt)->MPC_CoordDecl.Pos)
gettIdent ((* yyt)->MPC_CoordDecl.Ident)
gettTree (& ((* yyt)->MPC_CoordDecl.Prev))
gettTree (& ((* yyt)->MPC_CoordDecl.Range))
gettPosition ((* yyt)->MPC_CoordDecl.EndPos)
getshort ((* yyt)->MPC_CoordDecl.CoordNumber)
yyt = & ((* yyt)->MPC_CoordDecl.Next); break;
case kMPC_Node:
gettPosition ((* yyt)->MPC_Node.Pos)
gettNodeType ((* yyt)->MPC_Node.NodeType)
getbool ((* yyt)->MPC_Node.DynamicType)
gettTree (& ((* yyt)->MPC_Node.Prev))
gettTree (& ((* yyt)->MPC_Node.Predicate))
gettTree (& ((* yyt)->MPC_Node.NodeQual))
gettPosition ((* yyt)->MPC_Node.EndPos)
yyt = & ((* yyt)->MPC_Node.Next); break;
case kMPC_NodeQual:
gettPosition ((* yyt)->MPC_NodeQual.Pos)
gettPosition ((* yyt)->MPC_NodeQual.EndPos)
yyt = & ((* yyt)->MPC_NodeQual.CapacityExpr); break;
case kMPC_NodeTypeQual:
gettPosition ((* yyt)->MPC_NodeTypeQual.Pos)
gettPosition ((* yyt)->MPC_NodeTypeQual.EndPos)
getbool ((* yyt)->MPC_NodeTypeQual.Fast)
getint ((* yyt)->MPC_NodeTypeQual.Capacity)
yyt = & ((* yyt)->MPC_NodeTypeQual.CapacityExpr); break;
case kMPC_BenchQual:
gettPosition ((* yyt)->MPC_BenchQual.Pos)
gettPosition ((* yyt)->MPC_BenchQual.EndPos)
getdouble ((* yyt)->MPC_BenchQual.Capacity)
yyt = & ((* yyt)->MPC_BenchQual.CapacityExpr); break;
case kMPC_LinkDecl:
gettPosition ((* yyt)->MPC_LinkDecl.Pos)
gettTree (& ((* yyt)->MPC_LinkDecl.FreeCoord))
gettPosition ((* yyt)->MPC_LinkDecl.EndPos)
yyt = & ((* yyt)->MPC_LinkDecl.LinkDeclaringList); break;
case kMPC_LinkDeclaringList:
gettPosition ((* yyt)->MPC_LinkDeclaringList.Pos)
gettLinkType ((* yyt)->MPC_LinkDeclaringList.LinkType)
getbool ((* yyt)->MPC_LinkDeclaringList.DynamicLength)
gettTree (& ((* yyt)->MPC_LinkDeclaringList.Prev))
gettTree (& ((* yyt)->MPC_LinkDeclaringList.Predicate))
gettTree (& ((* yyt)->MPC_LinkDeclaringList.LinkLengthSpecifier))
gettTree (& ((* yyt)->MPC_LinkDeclaringList.LinkDeclarator))
gettPosition ((* yyt)->MPC_LinkDeclaringList.EndPos)
yyt = & ((* yyt)->MPC_LinkDeclaringList.Next); break;
case kMPC_LinkDeclarator:
gettPosition ((* yyt)->MPC_LinkDeclarator.Pos)
gettTree (& ((* yyt)->MPC_LinkDeclarator.Prev))
gettTree (& ((* yyt)->MPC_LinkDeclarator.LeftNode))
gettTree (& ((* yyt)->MPC_LinkDeclarator.RightNode))
gettPosition ((* yyt)->MPC_LinkDeclarator.EndPos)
yyt = & ((* yyt)->MPC_LinkDeclarator.Next); break;
case kMPC_LinkLengthSpecifier:
gettPosition ((* yyt)->MPC_LinkLengthSpecifier.Pos)
gettLinkType ((* yyt)->MPC_LinkLengthSpecifier.LinkLength)
gettPosition ((* yyt)->MPC_LinkLengthSpecifier.EndPos)
yyt = & ((* yyt)->MPC_LinkLengthSpecifier.LinkLengthExpr); break;
case kMPC_Scheme:
gettPosition ((* yyt)->MPC_Scheme.Pos)
gettPosition ((* yyt)->MPC_Scheme.EndPos)
yyt = & ((* yyt)->MPC_Scheme.Body); break;
case kMPC_NetList:
gettTree (& ((* yyt)->MPC_NetList.Prev))
gettTree (& ((* yyt)->MPC_NetList.Net))
gettPosition ((* yyt)->MPC_NetList.Pos)
getbool ((* yyt)->MPC_NetList.UnReduceable)
yyt = & ((* yyt)->MPC_NetList.Next); break;
case kMPC_NetOrSubnet:
gettPosition ((* yyt)->MPC_NetOrSubnet.Pos)
gettIdent ((* yyt)->MPC_NetOrSubnet.Ident)
getbool ((* yyt)->MPC_NetOrSubnet.BigCreate)
gettTree (& ((* yyt)->MPC_NetOrSubnet.Distribution))
gettTree (& ((* yyt)->MPC_NetOrSubnet.Prev))
gettPosition ((* yyt)->MPC_NetOrSubnet.EndPos)
getMPC_unsigned_short ((* yyt)->MPC_NetOrSubnet.UniqueNumber)
getbool ((* yyt)->MPC_NetOrSubnet.WithNumber)
getbool ((* yyt)->MPC_NetOrSubnet.SingleNode)
getbool ((* yyt)->MPC_NetOrSubnet.IsParent)
getpVoid ((* yyt)->MPC_NetOrSubnet.pGen)
gettTree (& ((* yyt)->MPC_NetOrSubnet.NextUse))
gettTree (& ((* yyt)->MPC_NetOrSubnet.PrevUse))
gettTree (& ((* yyt)->MPC_NetOrSubnet.MyList))
yyt = & ((* yyt)->MPC_NetOrSubnet.Next); break;
case kMPC_Net:
gettPosition ((* yyt)->MPC_Net.Pos)
gettIdent ((* yyt)->MPC_Net.Ident)
getbool ((* yyt)->MPC_Net.BigCreate)
gettTree (& ((* yyt)->MPC_Net.Distribution))
gettTree (& ((* yyt)->MPC_Net.Prev))
gettPosition ((* yyt)->MPC_Net.EndPos)
getMPC_unsigned_short ((* yyt)->MPC_Net.UniqueNumber)
getbool ((* yyt)->MPC_Net.WithNumber)
getbool ((* yyt)->MPC_Net.SingleNode)
getbool ((* yyt)->MPC_Net.IsParent)
getpVoid ((* yyt)->MPC_Net.pGen)
gettTree (& ((* yyt)->MPC_Net.NextUse))
gettTree (& ((* yyt)->MPC_Net.PrevUse))
gettTree (& ((* yyt)->MPC_Net.MyList))
getshort ((* yyt)->MPC_Net.Topology)
gettTree (& ((* yyt)->MPC_Net.NetType))
yyt = & ((* yyt)->MPC_Net.Next); break;
case kMPC_Subnet:
gettPosition ((* yyt)->MPC_Subnet.Pos)
gettIdent ((* yyt)->MPC_Subnet.Ident)
getbool ((* yyt)->MPC_Subnet.BigCreate)
gettTree (& ((* yyt)->MPC_Subnet.Distribution))
gettTree (& ((* yyt)->MPC_Subnet.Prev))
gettPosition ((* yyt)->MPC_Subnet.EndPos)
getMPC_unsigned_short ((* yyt)->MPC_Subnet.UniqueNumber)
getbool ((* yyt)->MPC_Subnet.WithNumber)
getbool ((* yyt)->MPC_Subnet.SingleNode)
getbool ((* yyt)->MPC_Subnet.IsParent)
getpVoid ((* yyt)->MPC_Subnet.pGen)
gettTree (& ((* yyt)->MPC_Subnet.NextUse))
gettTree (& ((* yyt)->MPC_Subnet.PrevUse))
gettTree (& ((* yyt)->MPC_Subnet.MyList))
gettIdent ((* yyt)->MPC_Subnet.NetOrSubnetName)
getbool ((* yyt)->MPC_Subnet.Flexible)
gettTree (& ((* yyt)->MPC_Subnet.Predicate))
yyt = & ((* yyt)->MPC_Subnet.Next); break;
case kMPC_Relation:
gettPosition ((* yyt)->MPC_Relation.Pos)
getint ((* yyt)->MPC_Relation.RelCode)
gettTree (& ((* yyt)->MPC_Relation.Prev))
gettTree (& ((* yyt)->MPC_Relation.LNet))
gettTree (& ((* yyt)->MPC_Relation.RNet))
gettPosition ((* yyt)->MPC_Relation.EndPos)
yyt = & ((* yyt)->MPC_Relation.Next); break;
case kMPC_Stats:
gettPosition ((* yyt)->MPC_Stats.Pos)
gettTree (& ((* yyt)->MPC_Stats.Prev))
gettPosition ((* yyt)->MPC_Stats.EndPos)
yyt = & ((* yyt)->MPC_Stats.Next); break;
case kMPC_Stat:
gettPosition ((* yyt)->MPC_Stat.Pos)
gettTree (& ((* yyt)->MPC_Stat.Prev))
gettPosition ((* yyt)->MPC_Stat.EndPos)
gettStatFlags ((* yyt)->MPC_Stat.Flag)
gettTree (& ((* yyt)->MPC_Stat.ExecNet))
gettTree (& ((* yyt)->MPC_Stat.ActualExecNet))
gettTree (& ((* yyt)->MPC_Stat.RootNet))
gettTree (& ((* yyt)->MPC_Stat.PropNet))
getbool ((* yyt)->MPC_Stat.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Stat.UniqueNumber)
yyt = & ((* yyt)->MPC_Stat.Next); break;
case kMPC_ExprStat:
gettPosition ((* yyt)->MPC_ExprStat.Pos)
gettTree (& ((* yyt)->MPC_ExprStat.Prev))
gettPosition ((* yyt)->MPC_ExprStat.EndPos)
gettStatFlags ((* yyt)->MPC_ExprStat.Flag)
gettTree (& ((* yyt)->MPC_ExprStat.ExecNet))
gettTree (& ((* yyt)->MPC_ExprStat.ActualExecNet))
gettTree (& ((* yyt)->MPC_ExprStat.RootNet))
gettTree (& ((* yyt)->MPC_ExprStat.PropNet))
getbool ((* yyt)->MPC_ExprStat.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_ExprStat.UniqueNumber)
gettTree (& ((* yyt)->MPC_ExprStat.Expr))
yyt = & ((* yyt)->MPC_ExprStat.Next); break;
case kMPC_If:
gettPosition ((* yyt)->MPC_If.Pos)
gettTree (& ((* yyt)->MPC_If.Prev))
gettPosition ((* yyt)->MPC_If.EndPos)
gettStatFlags ((* yyt)->MPC_If.Flag)
gettTree (& ((* yyt)->MPC_If.ExecNet))
gettTree (& ((* yyt)->MPC_If.ActualExecNet))
gettTree (& ((* yyt)->MPC_If.RootNet))
gettTree (& ((* yyt)->MPC_If.PropNet))
getbool ((* yyt)->MPC_If.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_If.UniqueNumber)
gettTree (& ((* yyt)->MPC_If.Expr))
gettTree (& ((* yyt)->MPC_If.Stats))
yyt = & ((* yyt)->MPC_If.Next); break;
case kMPC_IfElse:
gettPosition ((* yyt)->MPC_IfElse.Pos)
gettTree (& ((* yyt)->MPC_IfElse.Prev))
gettPosition ((* yyt)->MPC_IfElse.EndPos)
gettStatFlags ((* yyt)->MPC_IfElse.Flag)
gettTree (& ((* yyt)->MPC_IfElse.ExecNet))
gettTree (& ((* yyt)->MPC_IfElse.ActualExecNet))
gettTree (& ((* yyt)->MPC_IfElse.RootNet))
gettTree (& ((* yyt)->MPC_IfElse.PropNet))
getbool ((* yyt)->MPC_IfElse.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_IfElse.UniqueNumber)
gettTree (& ((* yyt)->MPC_IfElse.Expr))
gettTree (& ((* yyt)->MPC_IfElse.Then))
gettTree (& ((* yyt)->MPC_IfElse.Else))
yyt = & ((* yyt)->MPC_IfElse.Next); break;
case kMPC_Switch:
gettPosition ((* yyt)->MPC_Switch.Pos)
gettTree (& ((* yyt)->MPC_Switch.Prev))
gettPosition ((* yyt)->MPC_Switch.EndPos)
gettStatFlags ((* yyt)->MPC_Switch.Flag)
gettTree (& ((* yyt)->MPC_Switch.ExecNet))
gettTree (& ((* yyt)->MPC_Switch.ActualExecNet))
gettTree (& ((* yyt)->MPC_Switch.RootNet))
gettTree (& ((* yyt)->MPC_Switch.PropNet))
getbool ((* yyt)->MPC_Switch.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Switch.UniqueNumber)
gettTree (& ((* yyt)->MPC_Switch.Expr))
gettTree (& ((* yyt)->MPC_Switch.Stats))
yyt = & ((* yyt)->MPC_Switch.Next); break;
case kMPC_While:
gettPosition ((* yyt)->MPC_While.Pos)
gettTree (& ((* yyt)->MPC_While.Prev))
gettPosition ((* yyt)->MPC_While.EndPos)
gettStatFlags ((* yyt)->MPC_While.Flag)
gettTree (& ((* yyt)->MPC_While.ExecNet))
gettTree (& ((* yyt)->MPC_While.ActualExecNet))
gettTree (& ((* yyt)->MPC_While.RootNet))
gettTree (& ((* yyt)->MPC_While.PropNet))
getbool ((* yyt)->MPC_While.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_While.UniqueNumber)
gettTree (& ((* yyt)->MPC_While.Expr))
gettTree (& ((* yyt)->MPC_While.Stats))
yyt = & ((* yyt)->MPC_While.Next); break;
case kMPC_DoWhile:
gettPosition ((* yyt)->MPC_DoWhile.Pos)
gettTree (& ((* yyt)->MPC_DoWhile.Prev))
gettPosition ((* yyt)->MPC_DoWhile.EndPos)
gettStatFlags ((* yyt)->MPC_DoWhile.Flag)
gettTree (& ((* yyt)->MPC_DoWhile.ExecNet))
gettTree (& ((* yyt)->MPC_DoWhile.ActualExecNet))
gettTree (& ((* yyt)->MPC_DoWhile.RootNet))
gettTree (& ((* yyt)->MPC_DoWhile.PropNet))
getbool ((* yyt)->MPC_DoWhile.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_DoWhile.UniqueNumber)
gettTree (& ((* yyt)->MPC_DoWhile.Stats))
gettTree (& ((* yyt)->MPC_DoWhile.Expr))
yyt = & ((* yyt)->MPC_DoWhile.Next); break;
case kMPC_For:
gettPosition ((* yyt)->MPC_For.Pos)
gettTree (& ((* yyt)->MPC_For.Prev))
gettPosition ((* yyt)->MPC_For.EndPos)
gettStatFlags ((* yyt)->MPC_For.Flag)
gettTree (& ((* yyt)->MPC_For.ExecNet))
gettTree (& ((* yyt)->MPC_For.ActualExecNet))
gettTree (& ((* yyt)->MPC_For.RootNet))
gettTree (& ((* yyt)->MPC_For.PropNet))
getbool ((* yyt)->MPC_For.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_For.UniqueNumber)
gettTree (& ((* yyt)->MPC_For.Init))
gettTree (& ((* yyt)->MPC_For.Cond))
gettTree (& ((* yyt)->MPC_For.Reinit))
gettTree (& ((* yyt)->MPC_For.Stats))
yyt = & ((* yyt)->MPC_For.Next); break;
case kMPC_Goto:
gettPosition ((* yyt)->MPC_Goto.Pos)
gettTree (& ((* yyt)->MPC_Goto.Prev))
gettPosition ((* yyt)->MPC_Goto.EndPos)
gettStatFlags ((* yyt)->MPC_Goto.Flag)
gettTree (& ((* yyt)->MPC_Goto.ExecNet))
gettTree (& ((* yyt)->MPC_Goto.ActualExecNet))
gettTree (& ((* yyt)->MPC_Goto.RootNet))
gettTree (& ((* yyt)->MPC_Goto.PropNet))
getbool ((* yyt)->MPC_Goto.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Goto.UniqueNumber)
gettIdent ((* yyt)->MPC_Goto.Ident)
gettTree (& ((* yyt)->MPC_Goto.LabelDef))
gettTree (& ((* yyt)->MPC_Goto.NextUse))
gettTree (& ((* yyt)->MPC_Goto.PrevUse))
yyt = & ((* yyt)->MPC_Goto.Next); break;
case kMPC_Continue:
gettPosition ((* yyt)->MPC_Continue.Pos)
gettTree (& ((* yyt)->MPC_Continue.Prev))
gettPosition ((* yyt)->MPC_Continue.EndPos)
gettStatFlags ((* yyt)->MPC_Continue.Flag)
gettTree (& ((* yyt)->MPC_Continue.ExecNet))
gettTree (& ((* yyt)->MPC_Continue.ActualExecNet))
gettTree (& ((* yyt)->MPC_Continue.RootNet))
gettTree (& ((* yyt)->MPC_Continue.PropNet))
getbool ((* yyt)->MPC_Continue.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Continue.UniqueNumber)
yyt = & ((* yyt)->MPC_Continue.Next); break;
case kMPC_Break:
gettPosition ((* yyt)->MPC_Break.Pos)
gettTree (& ((* yyt)->MPC_Break.Prev))
gettPosition ((* yyt)->MPC_Break.EndPos)
gettStatFlags ((* yyt)->MPC_Break.Flag)
gettTree (& ((* yyt)->MPC_Break.ExecNet))
gettTree (& ((* yyt)->MPC_Break.ActualExecNet))
gettTree (& ((* yyt)->MPC_Break.RootNet))
gettTree (& ((* yyt)->MPC_Break.PropNet))
getbool ((* yyt)->MPC_Break.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Break.UniqueNumber)
yyt = & ((* yyt)->MPC_Break.Next); break;
case kMPC_BreakFan:
gettPosition ((* yyt)->MPC_BreakFan.Pos)
gettTree (& ((* yyt)->MPC_BreakFan.Prev))
gettPosition ((* yyt)->MPC_BreakFan.EndPos)
gettStatFlags ((* yyt)->MPC_BreakFan.Flag)
gettTree (& ((* yyt)->MPC_BreakFan.ExecNet))
gettTree (& ((* yyt)->MPC_BreakFan.ActualExecNet))
gettTree (& ((* yyt)->MPC_BreakFan.RootNet))
gettTree (& ((* yyt)->MPC_BreakFan.PropNet))
getbool ((* yyt)->MPC_BreakFan.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_BreakFan.UniqueNumber)
yyt = & ((* yyt)->MPC_BreakFan.Next); break;
case kMPC_Return:
gettPosition ((* yyt)->MPC_Return.Pos)
gettTree (& ((* yyt)->MPC_Return.Prev))
gettPosition ((* yyt)->MPC_Return.EndPos)
gettStatFlags ((* yyt)->MPC_Return.Flag)
gettTree (& ((* yyt)->MPC_Return.ExecNet))
gettTree (& ((* yyt)->MPC_Return.ActualExecNet))
gettTree (& ((* yyt)->MPC_Return.RootNet))
gettTree (& ((* yyt)->MPC_Return.PropNet))
getbool ((* yyt)->MPC_Return.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Return.UniqueNumber)
gettTree (& ((* yyt)->MPC_Return.Expr))
yyt = & ((* yyt)->MPC_Return.Next); break;
case kMPC_Compound:
gettPosition ((* yyt)->MPC_Compound.Pos)
gettTree (& ((* yyt)->MPC_Compound.Prev))
gettPosition ((* yyt)->MPC_Compound.EndPos)
gettStatFlags ((* yyt)->MPC_Compound.Flag)
gettTree (& ((* yyt)->MPC_Compound.ExecNet))
gettTree (& ((* yyt)->MPC_Compound.ActualExecNet))
gettTree (& ((* yyt)->MPC_Compound.RootNet))
gettTree (& ((* yyt)->MPC_Compound.PropNet))
getbool ((* yyt)->MPC_Compound.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Compound.UniqueNumber)
getint ((* yyt)->MPC_Compound.FunctionBody)
gettTree (& ((* yyt)->MPC_Compound.Decls))
gettTree (& ((* yyt)->MPC_Compound.Stats))
yyt = & ((* yyt)->MPC_Compound.Next); break;
case kMPC_CompScheme:
gettPosition ((* yyt)->MPC_CompScheme.Pos)
gettTree (& ((* yyt)->MPC_CompScheme.Prev))
gettPosition ((* yyt)->MPC_CompScheme.EndPos)
gettStatFlags ((* yyt)->MPC_CompScheme.Flag)
gettTree (& ((* yyt)->MPC_CompScheme.ExecNet))
gettTree (& ((* yyt)->MPC_CompScheme.ActualExecNet))
gettTree (& ((* yyt)->MPC_CompScheme.RootNet))
gettTree (& ((* yyt)->MPC_CompScheme.PropNet))
getbool ((* yyt)->MPC_CompScheme.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_CompScheme.UniqueNumber)
gettTree (& ((* yyt)->MPC_CompScheme.Expr))
gettTree (& ((* yyt)->MPC_CompScheme.Node))
yyt = & ((* yyt)->MPC_CompScheme.Next); break;
case kMPC_CommScheme:
gettPosition ((* yyt)->MPC_CommScheme.Pos)
gettTree (& ((* yyt)->MPC_CommScheme.Prev))
gettPosition ((* yyt)->MPC_CommScheme.EndPos)
gettStatFlags ((* yyt)->MPC_CommScheme.Flag)
gettTree (& ((* yyt)->MPC_CommScheme.ExecNet))
gettTree (& ((* yyt)->MPC_CommScheme.ActualExecNet))
gettTree (& ((* yyt)->MPC_CommScheme.RootNet))
gettTree (& ((* yyt)->MPC_CommScheme.PropNet))
getbool ((* yyt)->MPC_CommScheme.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_CommScheme.UniqueNumber)
gettTree (& ((* yyt)->MPC_CommScheme.Expr))
gettTree (& ((* yyt)->MPC_CommScheme.From))
gettTree (& ((* yyt)->MPC_CommScheme.To))
yyt = & ((* yyt)->MPC_CommScheme.Next); break;
case kMPC_ParScheme:
gettPosition ((* yyt)->MPC_ParScheme.Pos)
gettTree (& ((* yyt)->MPC_ParScheme.Prev))
gettPosition ((* yyt)->MPC_ParScheme.EndPos)
gettStatFlags ((* yyt)->MPC_ParScheme.Flag)
gettTree (& ((* yyt)->MPC_ParScheme.ExecNet))
gettTree (& ((* yyt)->MPC_ParScheme.ActualExecNet))
gettTree (& ((* yyt)->MPC_ParScheme.RootNet))
gettTree (& ((* yyt)->MPC_ParScheme.PropNet))
getbool ((* yyt)->MPC_ParScheme.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_ParScheme.UniqueNumber)
gettTree (& ((* yyt)->MPC_ParScheme.Init))
gettTree (& ((* yyt)->MPC_ParScheme.Cond))
gettTree (& ((* yyt)->MPC_ParScheme.Reinit))
gettTree (& ((* yyt)->MPC_ParScheme.Stats))
yyt = & ((* yyt)->MPC_ParScheme.Next); break;
case kMPC_Fan:
gettPosition ((* yyt)->MPC_Fan.Pos)
gettTree (& ((* yyt)->MPC_Fan.Prev))
gettPosition ((* yyt)->MPC_Fan.EndPos)
gettStatFlags ((* yyt)->MPC_Fan.Flag)
gettTree (& ((* yyt)->MPC_Fan.ExecNet))
gettTree (& ((* yyt)->MPC_Fan.ActualExecNet))
gettTree (& ((* yyt)->MPC_Fan.RootNet))
gettTree (& ((* yyt)->MPC_Fan.PropNet))
getbool ((* yyt)->MPC_Fan.Benchmark)
getMPC_unsigned_short ((* yyt)->MPC_Fan.UniqueNumber)
gettTree (& ((* yyt)->MPC_Fan.Body))
yyt = & ((* yyt)->MPC_Fan.Next); break;
case kMPC_Label:
gettPosition ((* yyt)->MPC_Label.Pos)
gettTree (& ((* yyt)->MPC_Label.Prev))
gettPosition ((* yyt)->MPC_Label.EndPos)
gettTree (& ((* yyt)->MPC_Label.NextLabel))
gettTree (& ((* yyt)->MPC_Label.PrevLabel))
yyt = & ((* yyt)->MPC_Label.Next); break;
case kMPC_IdentLabel:
gettPosition ((* yyt)->MPC_IdentLabel.Pos)
gettTree (& ((* yyt)->MPC_IdentLabel.Prev))
gettPosition ((* yyt)->MPC_IdentLabel.EndPos)
gettTree (& ((* yyt)->MPC_IdentLabel.NextLabel))
gettTree (& ((* yyt)->MPC_IdentLabel.PrevLabel))
gettIdent ((* yyt)->MPC_IdentLabel.Ident)
gettTree (& ((* yyt)->MPC_IdentLabel.NextUse))
getbool ((* yyt)->MPC_IdentLabel.Used)
yyt = & ((* yyt)->MPC_IdentLabel.Next); break;
case kMPC_CaseLabel:
gettPosition ((* yyt)->MPC_CaseLabel.Pos)
gettTree (& ((* yyt)->MPC_CaseLabel.Prev))
gettPosition ((* yyt)->MPC_CaseLabel.EndPos)
gettTree (& ((* yyt)->MPC_CaseLabel.NextLabel))
gettTree (& ((* yyt)->MPC_CaseLabel.PrevLabel))
getlong ((* yyt)->MPC_CaseLabel.CaseValue)
gettTree (& ((* yyt)->MPC_CaseLabel.Expr))
yyt = & ((* yyt)->MPC_CaseLabel.Next); break;
case kMPC_Default:
gettPosition ((* yyt)->MPC_Default.Pos)
gettTree (& ((* yyt)->MPC_Default.Prev))
gettPosition ((* yyt)->MPC_Default.EndPos)
gettTree (& ((* yyt)->MPC_Default.NextLabel))
gettTree (& ((* yyt)->MPC_Default.PrevLabel))
yyt = & ((* yyt)->MPC_Default.Next); break;
case kMPC_Expr:
gettPosition ((* yyt)->MPC_Expr.Pos)
gettExprFlags ((* yyt)->MPC_Expr.Flag)
gettString ((* yyt)->MPC_Expr.TmpName)
gettTree (& ((* yyt)->MPC_Expr.Type))
gettTree (& ((* yyt)->MPC_Expr.EvalNet))
gettTree (& ((* yyt)->MPC_Expr.StoreNet))
gettPosition ((* yyt)->MPC_Expr.BegPos)
gettPosition ((* yyt)->MPC_Expr.EndPos)
getchar ((* yyt)->MPC_Expr.Pass)
getbool ((* yyt)->MPC_Expr.Repl)
gettOptm_Attribute ((* yyt)->MPC_Expr.Optm_Attribute)
yyt = & ((* yyt)->MPC_Expr.ActualEvalNet); break;
case kMPC_Const:
gettPosition ((* yyt)->MPC_Const.Pos)
gettExprFlags ((* yyt)->MPC_Const.Flag)
gettString ((* yyt)->MPC_Const.TmpName)
gettTree (& ((* yyt)->MPC_Const.Type))
gettTree (& ((* yyt)->MPC_Const.EvalNet))
gettTree (& ((* yyt)->MPC_Const.StoreNet))
gettPosition ((* yyt)->MPC_Const.BegPos)
gettPosition ((* yyt)->MPC_Const.EndPos)
getchar ((* yyt)->MPC_Const.Pass)
getbool ((* yyt)->MPC_Const.Repl)
gettOptm_Attribute ((* yyt)->MPC_Const.Optm_Attribute)
gettString ((* yyt)->MPC_Const.SymbolicForm)
yyt = & ((* yyt)->MPC_Const.ActualEvalNet); break;
case kMPC_IntConst:
gettPosition ((* yyt)->MPC_IntConst.Pos)
gettExprFlags ((* yyt)->MPC_IntConst.Flag)
gettString ((* yyt)->MPC_IntConst.TmpName)
gettTree (& ((* yyt)->MPC_IntConst.Type))
gettTree (& ((* yyt)->MPC_IntConst.EvalNet))
gettTree (& ((* yyt)->MPC_IntConst.StoreNet))
gettPosition ((* yyt)->MPC_IntConst.BegPos)
gettPosition ((* yyt)->MPC_IntConst.EndPos)
getchar ((* yyt)->MPC_IntConst.Pass)
getbool ((* yyt)->MPC_IntConst.Repl)
gettOptm_Attribute ((* yyt)->MPC_IntConst.Optm_Attribute)
gettString ((* yyt)->MPC_IntConst.SymbolicForm)
getlong ((* yyt)->MPC_IntConst.Value)
yyt = & ((* yyt)->MPC_IntConst.ActualEvalNet); break;
case kMPC_UIntConst:
gettPosition ((* yyt)->MPC_UIntConst.Pos)
gettExprFlags ((* yyt)->MPC_UIntConst.Flag)
gettString ((* yyt)->MPC_UIntConst.TmpName)
gettTree (& ((* yyt)->MPC_UIntConst.Type))
gettTree (& ((* yyt)->MPC_UIntConst.EvalNet))
gettTree (& ((* yyt)->MPC_UIntConst.StoreNet))
gettPosition ((* yyt)->MPC_UIntConst.BegPos)
gettPosition ((* yyt)->MPC_UIntConst.EndPos)
getchar ((* yyt)->MPC_UIntConst.Pass)
getbool ((* yyt)->MPC_UIntConst.Repl)
gettOptm_Attribute ((* yyt)->MPC_UIntConst.Optm_Attribute)
gettString ((* yyt)->MPC_UIntConst.SymbolicForm)
getMPC_long_unsigned ((* yyt)->MPC_UIntConst.Value)
yyt = & ((* yyt)->MPC_UIntConst.ActualEvalNet); break;
case kMPC_FloatConst:
gettPosition ((* yyt)->MPC_FloatConst.Pos)
gettExprFlags ((* yyt)->MPC_FloatConst.Flag)
gettString ((* yyt)->MPC_FloatConst.TmpName)
gettTree (& ((* yyt)->MPC_FloatConst.Type))
gettTree (& ((* yyt)->MPC_FloatConst.EvalNet))
gettTree (& ((* yyt)->MPC_FloatConst.StoreNet))
gettPosition ((* yyt)->MPC_FloatConst.BegPos)
gettPosition ((* yyt)->MPC_FloatConst.EndPos)
getchar ((* yyt)->MPC_FloatConst.Pass)
getbool ((* yyt)->MPC_FloatConst.Repl)
gettOptm_Attribute ((* yyt)->MPC_FloatConst.Optm_Attribute)
gettString ((* yyt)->MPC_FloatConst.SymbolicForm)
getMPC_long_double ((* yyt)->MPC_FloatConst.Value)
yyt = & ((* yyt)->MPC_FloatConst.ActualEvalNet); break;
case kMPC_StringLiteral:
gettPosition ((* yyt)->MPC_StringLiteral.Pos)
gettExprFlags ((* yyt)->MPC_StringLiteral.Flag)
gettString ((* yyt)->MPC_StringLiteral.TmpName)
gettTree (& ((* yyt)->MPC_StringLiteral.Type))
gettTree (& ((* yyt)->MPC_StringLiteral.EvalNet))
gettTree (& ((* yyt)->MPC_StringLiteral.StoreNet))
gettPosition ((* yyt)->MPC_StringLiteral.BegPos)
gettPosition ((* yyt)->MPC_StringLiteral.EndPos)
gettTree (& ((* yyt)->MPC_StringLiteral.ActualEvalNet))
getchar ((* yyt)->MPC_StringLiteral.Pass)
getbool ((* yyt)->MPC_StringLiteral.Repl)
gettOptm_Attribute ((* yyt)->MPC_StringLiteral.Optm_Attribute)
gettString ((* yyt)->MPC_StringLiteral.String)
getshort ((* yyt)->MPC_StringLiteral.FullSize)
gettTree (& ((* yyt)->MPC_StringLiteral.Prev))
yyt = & ((* yyt)->MPC_StringLiteral.Next); break;
case kMPC_Ident:
gettPosition ((* yyt)->MPC_Ident.Pos)
gettExprFlags ((* yyt)->MPC_Ident.Flag)
gettString ((* yyt)->MPC_Ident.TmpName)
gettTree (& ((* yyt)->MPC_Ident.Type))
gettTree (& ((* yyt)->MPC_Ident.EvalNet))
gettTree (& ((* yyt)->MPC_Ident.StoreNet))
gettPosition ((* yyt)->MPC_Ident.BegPos)
gettPosition ((* yyt)->MPC_Ident.EndPos)
gettTree (& ((* yyt)->MPC_Ident.ActualEvalNet))
getchar ((* yyt)->MPC_Ident.Pass)
getbool ((* yyt)->MPC_Ident.Repl)
gettOptm_Attribute ((* yyt)->MPC_Ident.Optm_Attribute)
gettIdent ((* yyt)->MPC_Ident.Ident)
gettTree (& ((* yyt)->MPC_Ident.Store))
gettTree (& ((* yyt)->MPC_Ident.NextUse))
yyt = & ((* yyt)->MPC_Ident.PrevUse); break;
case kMPC_CastExpr:
gettPosition ((* yyt)->MPC_CastExpr.Pos)
gettExprFlags ((* yyt)->MPC_CastExpr.Flag)
gettString ((* yyt)->MPC_CastExpr.TmpName)
gettTree (& ((* yyt)->MPC_CastExpr.Type))
gettTree (& ((* yyt)->MPC_CastExpr.EvalNet))
gettTree (& ((* yyt)->MPC_CastExpr.StoreNet))
gettPosition ((* yyt)->MPC_CastExpr.BegPos)
gettPosition ((* yyt)->MPC_CastExpr.EndPos)
gettTree (& ((* yyt)->MPC_CastExpr.ActualEvalNet))
getchar ((* yyt)->MPC_CastExpr.Pass)
getbool ((* yyt)->MPC_CastExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_CastExpr.Optm_Attribute)
gettTree (& ((* yyt)->MPC_CastExpr.TypeName))
yyt = & ((* yyt)->MPC_CastExpr.Operand); break;
case kMPC_NetCastExpr:
gettPosition ((* yyt)->MPC_NetCastExpr.Pos)
gettExprFlags ((* yyt)->MPC_NetCastExpr.Flag)
gettString ((* yyt)->MPC_NetCastExpr.TmpName)
gettTree (& ((* yyt)->MPC_NetCastExpr.Type))
gettTree (& ((* yyt)->MPC_NetCastExpr.EvalNet))
gettTree (& ((* yyt)->MPC_NetCastExpr.StoreNet))
gettPosition ((* yyt)->MPC_NetCastExpr.BegPos)
gettPosition ((* yyt)->MPC_NetCastExpr.EndPos)
gettTree (& ((* yyt)->MPC_NetCastExpr.ActualEvalNet))
getchar ((* yyt)->MPC_NetCastExpr.Pass)
getbool ((* yyt)->MPC_NetCastExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_NetCastExpr.Optm_Attribute)
getbool ((* yyt)->MPC_NetCastExpr.Flexible)
getpVoid ((* yyt)->MPC_NetCastExpr.ExprPtr)
yyt = & ((* yyt)->MPC_NetCastExpr.Operand); break;
case kMPC_CoordExpr:
gettPosition ((* yyt)->MPC_CoordExpr.Pos)
gettExprFlags ((* yyt)->MPC_CoordExpr.Flag)
gettString ((* yyt)->MPC_CoordExpr.TmpName)
gettTree (& ((* yyt)->MPC_CoordExpr.Type))
gettTree (& ((* yyt)->MPC_CoordExpr.EvalNet))
gettTree (& ((* yyt)->MPC_CoordExpr.StoreNet))
gettPosition ((* yyt)->MPC_CoordExpr.BegPos)
gettPosition ((* yyt)->MPC_CoordExpr.EndPos)
gettTree (& ((* yyt)->MPC_CoordExpr.ActualEvalNet))
getchar ((* yyt)->MPC_CoordExpr.Pass)
getbool ((* yyt)->MPC_CoordExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_CoordExpr.Optm_Attribute)
gettIdent ((* yyt)->MPC_CoordExpr.CoordName)
getshort ((* yyt)->MPC_CoordExpr.CoordNumber)
yyt = & ((* yyt)->MPC_CoordExpr.Operand); break;
case kMPC_SizeofExpr:
gettPosition ((* yyt)->MPC_SizeofExpr.Pos)
gettExprFlags ((* yyt)->MPC_SizeofExpr.Flag)
gettString ((* yyt)->MPC_SizeofExpr.TmpName)
gettTree (& ((* yyt)->MPC_SizeofExpr.Type))
gettTree (& ((* yyt)->MPC_SizeofExpr.EvalNet))
gettTree (& ((* yyt)->MPC_SizeofExpr.StoreNet))
gettPosition ((* yyt)->MPC_SizeofExpr.BegPos)
gettPosition ((* yyt)->MPC_SizeofExpr.EndPos)
getchar ((* yyt)->MPC_SizeofExpr.Pass)
getbool ((* yyt)->MPC_SizeofExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_SizeofExpr.Optm_Attribute)
getbool ((* yyt)->MPC_SizeofExpr.CompileTime)
getint ((* yyt)->MPC_SizeofExpr.Value)
yyt = & ((* yyt)->MPC_SizeofExpr.ActualEvalNet); break;
case kMPC_Size_Of_Value:
gettPosition ((* yyt)->MPC_Size_Of_Value.Pos)
gettExprFlags ((* yyt)->MPC_Size_Of_Value.Flag)
gettString ((* yyt)->MPC_Size_Of_Value.TmpName)
gettTree (& ((* yyt)->MPC_Size_Of_Value.Type))
gettTree (& ((* yyt)->MPC_Size_Of_Value.EvalNet))
gettTree (& ((* yyt)->MPC_Size_Of_Value.StoreNet))
gettPosition ((* yyt)->MPC_Size_Of_Value.BegPos)
gettPosition ((* yyt)->MPC_Size_Of_Value.EndPos)
gettTree (& ((* yyt)->MPC_Size_Of_Value.ActualEvalNet))
getchar ((* yyt)->MPC_Size_Of_Value.Pass)
getbool ((* yyt)->MPC_Size_Of_Value.Repl)
gettOptm_Attribute ((* yyt)->MPC_Size_Of_Value.Optm_Attribute)
getbool ((* yyt)->MPC_Size_Of_Value.CompileTime)
getint ((* yyt)->MPC_Size_Of_Value.Value)
yyt = & ((* yyt)->MPC_Size_Of_Value.Operand); break;
case kMPC_Size_Of_Type:
gettPosition ((* yyt)->MPC_Size_Of_Type.Pos)
gettExprFlags ((* yyt)->MPC_Size_Of_Type.Flag)
gettString ((* yyt)->MPC_Size_Of_Type.TmpName)
gettTree (& ((* yyt)->MPC_Size_Of_Type.Type))
gettTree (& ((* yyt)->MPC_Size_Of_Type.EvalNet))
gettTree (& ((* yyt)->MPC_Size_Of_Type.StoreNet))
gettPosition ((* yyt)->MPC_Size_Of_Type.BegPos)
gettPosition ((* yyt)->MPC_Size_Of_Type.EndPos)
gettTree (& ((* yyt)->MPC_Size_Of_Type.ActualEvalNet))
getchar ((* yyt)->MPC_Size_Of_Type.Pass)
getbool ((* yyt)->MPC_Size_Of_Type.Repl)
gettOptm_Attribute ((* yyt)->MPC_Size_Of_Type.Optm_Attribute)
getbool ((* yyt)->MPC_Size_Of_Type.CompileTime)
getint ((* yyt)->MPC_Size_Of_Type.Value)
yyt = & ((* yyt)->MPC_Size_Of_Type.Operand); break;
case kMPC_TimeofExpr:
gettPosition ((* yyt)->MPC_TimeofExpr.Pos)
gettExprFlags ((* yyt)->MPC_TimeofExpr.Flag)
gettString ((* yyt)->MPC_TimeofExpr.TmpName)
gettTree (& ((* yyt)->MPC_TimeofExpr.Type))
gettTree (& ((* yyt)->MPC_TimeofExpr.EvalNet))
gettTree (& ((* yyt)->MPC_TimeofExpr.StoreNet))
gettPosition ((* yyt)->MPC_TimeofExpr.BegPos)
gettPosition ((* yyt)->MPC_TimeofExpr.EndPos)
gettTree (& ((* yyt)->MPC_TimeofExpr.ActualEvalNet))
getchar ((* yyt)->MPC_TimeofExpr.Pass)
getbool ((* yyt)->MPC_TimeofExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_TimeofExpr.Optm_Attribute)
yyt = & ((* yyt)->MPC_TimeofExpr.NetDecl); break;
case kMPC_UnaryExpr:
gettPosition ((* yyt)->MPC_UnaryExpr.Pos)
gettExprFlags ((* yyt)->MPC_UnaryExpr.Flag)
gettString ((* yyt)->MPC_UnaryExpr.TmpName)
gettTree (& ((* yyt)->MPC_UnaryExpr.Type))
gettTree (& ((* yyt)->MPC_UnaryExpr.EvalNet))
gettTree (& ((* yyt)->MPC_UnaryExpr.StoreNet))
gettPosition ((* yyt)->MPC_UnaryExpr.BegPos)
gettPosition ((* yyt)->MPC_UnaryExpr.EndPos)
gettTree (& ((* yyt)->MPC_UnaryExpr.ActualEvalNet))
getchar ((* yyt)->MPC_UnaryExpr.Pass)
getbool ((* yyt)->MPC_UnaryExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_UnaryExpr.Optm_Attribute)
getshort ((* yyt)->MPC_UnaryExpr.OpCode)
yyt = & ((* yyt)->MPC_UnaryExpr.Operand); break;
case kMPC_BinaryExpr:
gettPosition ((* yyt)->MPC_BinaryExpr.Pos)
gettExprFlags ((* yyt)->MPC_BinaryExpr.Flag)
gettString ((* yyt)->MPC_BinaryExpr.TmpName)
gettTree (& ((* yyt)->MPC_BinaryExpr.Type))
gettTree (& ((* yyt)->MPC_BinaryExpr.EvalNet))
gettTree (& ((* yyt)->MPC_BinaryExpr.StoreNet))
gettPosition ((* yyt)->MPC_BinaryExpr.BegPos)
gettPosition ((* yyt)->MPC_BinaryExpr.EndPos)
gettTree (& ((* yyt)->MPC_BinaryExpr.ActualEvalNet))
getchar ((* yyt)->MPC_BinaryExpr.Pass)
getbool ((* yyt)->MPC_BinaryExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_BinaryExpr.Optm_Attribute)
getshort ((* yyt)->MPC_BinaryExpr.OpCode)
gettTree (& ((* yyt)->MPC_BinaryExpr.Loperand))
yyt = & ((* yyt)->MPC_BinaryExpr.Roperand); break;
case kMPC_TernaryExpr:
gettPosition ((* yyt)->MPC_TernaryExpr.Pos)
gettExprFlags ((* yyt)->MPC_TernaryExpr.Flag)
gettString ((* yyt)->MPC_TernaryExpr.TmpName)
gettTree (& ((* yyt)->MPC_TernaryExpr.Type))
gettTree (& ((* yyt)->MPC_TernaryExpr.EvalNet))
gettTree (& ((* yyt)->MPC_TernaryExpr.StoreNet))
gettPosition ((* yyt)->MPC_TernaryExpr.BegPos)
gettPosition ((* yyt)->MPC_TernaryExpr.EndPos)
gettTree (& ((* yyt)->MPC_TernaryExpr.ActualEvalNet))
getchar ((* yyt)->MPC_TernaryExpr.Pass)
getbool ((* yyt)->MPC_TernaryExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_TernaryExpr.Optm_Attribute)
getshort ((* yyt)->MPC_TernaryExpr.OpCode)
gettTree (& ((* yyt)->MPC_TernaryExpr.Foperand))
gettTree (& ((* yyt)->MPC_TernaryExpr.Soperand))
yyt = & ((* yyt)->MPC_TernaryExpr.Toperand); break;
case kMPC_QuaternaryExpr:
gettPosition ((* yyt)->MPC_QuaternaryExpr.Pos)
gettExprFlags ((* yyt)->MPC_QuaternaryExpr.Flag)
gettString ((* yyt)->MPC_QuaternaryExpr.TmpName)
gettTree (& ((* yyt)->MPC_QuaternaryExpr.Type))
gettTree (& ((* yyt)->MPC_QuaternaryExpr.EvalNet))
gettTree (& ((* yyt)->MPC_QuaternaryExpr.StoreNet))
gettPosition ((* yyt)->MPC_QuaternaryExpr.BegPos)
gettPosition ((* yyt)->MPC_QuaternaryExpr.EndPos)
gettTree (& ((* yyt)->MPC_QuaternaryExpr.ActualEvalNet))
getchar ((* yyt)->MPC_QuaternaryExpr.Pass)
getbool ((* yyt)->MPC_QuaternaryExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_QuaternaryExpr.Optm_Attribute)
getshort ((* yyt)->MPC_QuaternaryExpr.OpCode)
gettTree (& ((* yyt)->MPC_QuaternaryExpr.Operand1))
gettTree (& ((* yyt)->MPC_QuaternaryExpr.Operand2))
gettTree (& ((* yyt)->MPC_QuaternaryExpr.Operand3))
yyt = & ((* yyt)->MPC_QuaternaryExpr.Operand4); break;
case kMPC_CallExpr:
gettPosition ((* yyt)->MPC_CallExpr.Pos)
gettExprFlags ((* yyt)->MPC_CallExpr.Flag)
gettString ((* yyt)->MPC_CallExpr.TmpName)
gettTree (& ((* yyt)->MPC_CallExpr.Type))
gettTree (& ((* yyt)->MPC_CallExpr.EvalNet))
gettTree (& ((* yyt)->MPC_CallExpr.StoreNet))
gettPosition ((* yyt)->MPC_CallExpr.BegPos)
gettPosition ((* yyt)->MPC_CallExpr.EndPos)
gettTree (& ((* yyt)->MPC_CallExpr.ActualEvalNet))
getchar ((* yyt)->MPC_CallExpr.Pass)
getbool ((* yyt)->MPC_CallExpr.Repl)
gettOptm_Attribute ((* yyt)->MPC_CallExpr.Optm_Attribute)
gettTree (& ((* yyt)->MPC_CallExpr.Function))
gettTree (& ((* yyt)->MPC_CallExpr.ArgList))
yyt = & ((* yyt)->MPC_CallExpr.NetworkArgList); break;
case kMPC_Exprs:
gettPosition ((* yyt)->MPC_Exprs.Pos)
gettTree (& ((* yyt)->MPC_Exprs.Prev))
gettTree (& ((* yyt)->MPC_Exprs.Expr))
gettPosition ((* yyt)->MPC_Exprs.BegPos)
gettPosition ((* yyt)->MPC_Exprs.EndPos)
yyt = & ((* yyt)->MPC_Exprs.Next); break;
case kMPC_Initializer:
gettPosition ((* yyt)->MPC_Initializer.Pos)
gettTree (& ((* yyt)->MPC_Initializer.Prev))
gettPosition ((* yyt)->MPC_Initializer.EndPos)
yyt = & ((* yyt)->MPC_Initializer.Next); break;
case kMPC_SimpleInit:
gettPosition ((* yyt)->MPC_SimpleInit.Pos)
gettTree (& ((* yyt)->MPC_SimpleInit.Prev))
gettPosition ((* yyt)->MPC_SimpleInit.EndPos)
gettTree (& ((* yyt)->MPC_SimpleInit.Expr))
yyt = & ((* yyt)->MPC_SimpleInit.Next); break;
case kMPC_InitList:
gettPosition ((* yyt)->MPC_InitList.Pos)
gettTree (& ((* yyt)->MPC_InitList.Prev))
gettPosition ((* yyt)->MPC_InitList.EndPos)
getint ((* yyt)->MPC_InitList.Length)
gettTree (& ((* yyt)->MPC_InitList.List))
yyt = & ((* yyt)->MPC_InitList.Next); break;
  default: return;
  }
 }
}

tTree GetTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf)
# else
 (yyyf) FILE * yyyf;
# endif
{
 tTree yyt;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyGetTree (& yyt);
 yyRecursionLevel --;
 return yyt;
}

static tTree yyChild;

static void yyReleaseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) return;
 switch (yyt->Kind) {
case kMPC_Root:
closetTree (yyt->MPC_Root.Decls)
closetTree (yyt->MPC_Root.Source)
closetTree (yyt->MPC_Root.Messages)
closetTree (yyt->MPC_Root.Host)
closetTree (yyt->MPC_Root.SingleNode)
closetTree (yyt->MPC_Root.ComputingSpace)
closetTree (yyt->MPC_Root.Const)
closetTree (yyt->MPC_Root.Recon)
closetTree (yyt->MPC_Root.HostList)
closetTree (yyt->MPC_Root.SingleNodeList)
closetTree (yyt->MPC_Root.ComputingSpaceList)
closetTree (yyt->MPC_Root.ConstList)
closetTree (yyt->MPC_Root.ReconList)
break;
case kMPC_Source:
closetTree (yyt->MPC_Source.Next)
closetTree (yyt->MPC_Source.Prev)
break;
case kMPC_Messages:
closetTree (yyt->MPC_Messages.Next)
closetTree (yyt->MPC_Messages.Prev)
closetTree (yyt->MPC_Messages.Tree)
break;
case kMPC_ErrorMessage:
closetTree (yyt->MPC_ErrorMessage.Next)
closetTree (yyt->MPC_ErrorMessage.Prev)
closetTree (yyt->MPC_ErrorMessage.Tree)
break;
case kMPC_ErrorMessageI:
closetTree (yyt->MPC_ErrorMessageI.Next)
closetTree (yyt->MPC_ErrorMessageI.Prev)
closetTree (yyt->MPC_ErrorMessageI.Tree)
break;
case kMPC_Message:
closetTree (yyt->MPC_Message.Next)
closetTree (yyt->MPC_Message.Prev)
closetTree (yyt->MPC_Message.Tree)
break;
case kMPC_MessageI:
closetTree (yyt->MPC_MessageI.Next)
closetTree (yyt->MPC_MessageI.Prev)
closetTree (yyt->MPC_MessageI.Tree)
break;
case kMPC_FreeNode:
closetTree (yyt->MPC_FreeNode.Parent)
break;
case kMPC_Decls:
closetTree (yyt->MPC_Decls.Next)
closetTree (yyt->MPC_Decls.Prev)
break;
case kMPC_UncompString:
closetTree (yyt->MPC_UncompString.Next)
closetTree (yyt->MPC_UncompString.Prev)
break;
case kMPC_Type:
closetTree (yyt->MPC_Type.Next)
closetTree (yyt->MPC_Type.Prev)
closetTree (yyt->MPC_Type.EquivType)
break;
case kMPC_BasicType:
closetTree (yyt->MPC_BasicType.Next)
closetTree (yyt->MPC_BasicType.Prev)
closetTree (yyt->MPC_BasicType.EquivType)
break;
case kMPC_EnumType:
closetTree (yyt->MPC_EnumType.Next)
closetTree (yyt->MPC_EnumType.Prev)
closetTree (yyt->MPC_EnumType.EquivType)
closetTree (yyt->MPC_EnumType.EnumList)
break;
case kMPC_Typedef:
closetTree (yyt->MPC_Typedef.Next)
closetTree (yyt->MPC_Typedef.Prev)
closetTree (yyt->MPC_Typedef.EquivType)
closetTree (yyt->MPC_Typedef.Type)
break;
case kMPC_DerivedType:
closetTree (yyt->MPC_DerivedType.Next)
closetTree (yyt->MPC_DerivedType.Prev)
closetTree (yyt->MPC_DerivedType.EquivType)
break;
case kMPC_ArrayType:
closetTree (yyt->MPC_ArrayType.Next)
closetTree (yyt->MPC_ArrayType.Prev)
closetTree (yyt->MPC_ArrayType.EquivType)
closetTree (yyt->MPC_ArrayType.ElementType)
closetTree (yyt->MPC_ArrayType.ArraySize)
closetTree (yyt->MPC_ArrayType.DynStep)
break;
case kMPC_VectorType:
closetTree (yyt->MPC_VectorType.Next)
closetTree (yyt->MPC_VectorType.Prev)
closetTree (yyt->MPC_VectorType.EquivType)
closetTree (yyt->MPC_VectorType.ElementType)
closetTree (yyt->MPC_VectorType.VectorSize)
break;
case kMPC_PointerType:
closetTree (yyt->MPC_PointerType.Next)
closetTree (yyt->MPC_PointerType.Prev)
closetTree (yyt->MPC_PointerType.EquivType)
closetTree (yyt->MPC_PointerType.ElementType)
closetTree (yyt->MPC_PointerType.DynStep)
closetTree (yyt->MPC_PointerType.GeneratedFrom)
break;
case kMPC_StructType:
closetTree (yyt->MPC_StructType.Next)
closetTree (yyt->MPC_StructType.Prev)
closetTree (yyt->MPC_StructType.EquivType)
closetTree (yyt->MPC_StructType.MemberDecls)
break;
case kMPC_UnionType:
closetTree (yyt->MPC_UnionType.Next)
closetTree (yyt->MPC_UnionType.Prev)
closetTree (yyt->MPC_UnionType.EquivType)
closetTree (yyt->MPC_UnionType.MemberDecls)
break;
case kMPC_FunctionType:
closetTree (yyt->MPC_FunctionType.Next)
closetTree (yyt->MPC_FunctionType.Prev)
closetTree (yyt->MPC_FunctionType.EquivType)
closetTree (yyt->MPC_FunctionType.ResultType)
closetTree (yyt->MPC_FunctionType.NetParamType)
closetTree (yyt->MPC_FunctionType.NetParam)
closetTree (yyt->MPC_FunctionType.NetworkParamList)
closetTree (yyt->MPC_FunctionType.ParamList)
break;
case kMPC_VarDecl:
closetTree (yyt->MPC_VarDecl.Next)
closetTree (yyt->MPC_VarDecl.Prev)
closetTree (yyt->MPC_VarDecl.DeclSpecifier)
closetTree (yyt->MPC_VarDecl.Var)
break;
case kMPC_Function:
closetTree (yyt->MPC_Function.Next)
closetTree (yyt->MPC_Function.Prev)
closetTree (yyt->MPC_Function.Distribution)
closetTree (yyt->MPC_Function.Name)
closetTree (yyt->MPC_Function.Type)
closetTree (yyt->MPC_Function.ParamList)
closetTree (yyt->MPC_Function.Stats)
closetTree (yyt->MPC_Function.LabelList)
break;
case kMPC_Ellipsis:
closetTree (yyt->MPC_Ellipsis.Next)
closetTree (yyt->MPC_Ellipsis.Prev)
break;
case kMPC_NetDecl:
closetTree (yyt->MPC_NetDecl.Next)
closetTree (yyt->MPC_NetDecl.Prev)
closetTree (yyt->MPC_NetDecl.NetTypeSpecifier)
closetTree (yyt->MPC_NetDecl.Net)
break;
case kMPC_SubnetDecl:
closetTree (yyt->MPC_SubnetDecl.Next)
closetTree (yyt->MPC_SubnetDecl.Prev)
closetTree (yyt->MPC_SubnetDecl.Subnet)
break;
case kMPC_RelDecl:
closetTree (yyt->MPC_RelDecl.Next)
closetTree (yyt->MPC_RelDecl.Prev)
closetTree (yyt->MPC_RelDecl.Relation)
break;
case kMPC_NetTypeDecl:
closetTree (yyt->MPC_NetTypeDecl.Next)
closetTree (yyt->MPC_NetTypeDecl.Prev)
break;
case kMPC_NetType:
closetTree (yyt->MPC_NetType.Next)
closetTree (yyt->MPC_NetType.Prev)
closetTree (yyt->MPC_NetType.ParamList)
closetTree (yyt->MPC_NetType.CoordDecl)
closetTree (yyt->MPC_NetType.NodeDecl)
closetTree (yyt->MPC_NetType.LinkDecl)
closetTree (yyt->MPC_NetType.StartDecl)
closetTree (yyt->MPC_NetType.SchemeDecl)
closetTree (yyt->MPC_NetType.TopoFunctions)
break;
case kMPC_NetTypeSpecifier:
closetTree (yyt->MPC_NetTypeSpecifier.Next)
closetTree (yyt->MPC_NetTypeSpecifier.Prev)
closetTree (yyt->MPC_NetTypeSpecifier.NetType)
closetTree (yyt->MPC_NetTypeSpecifier.ArgList)
break;
case kMPC_TopoFunctions:
closetTree (yyt->MPC_TopoFunctions.Node_Def)
closetTree (yyt->MPC_TopoFunctions.Link_Def)
closetTree (yyt->MPC_TopoFunctions.Main_Node_Def)
closetTree (yyt->MPC_TopoFunctions.Power_Def)
closetTree (yyt->MPC_TopoFunctions.Node_Coord_Def)
closetTree (yyt->MPC_TopoFunctions.Node_Number_Def)
closetTree (yyt->MPC_TopoFunctions.Mapping_Def)
break;
case kMPC_EnumConst:
closetTree (yyt->MPC_EnumConst.Next)
closetTree (yyt->MPC_EnumConst.Prev)
break;
case kMPC_SU_MemberDecl:
closetTree (yyt->MPC_SU_MemberDecl.Next)
closetTree (yyt->MPC_SU_MemberDecl.Prev)
closetTree (yyt->MPC_SU_MemberDecl.Member)
break;
case kMPC_SU_Member:
closetTree (yyt->MPC_SU_Member.Next)
closetTree (yyt->MPC_SU_Member.Prev)
closetTree (yyt->MPC_SU_Member.Type)
closetTree (yyt->MPC_SU_Member.BitFieldSize)
break;
case kMPC_Var:
closetTree (yyt->MPC_Var.Next)
closetTree (yyt->MPC_Var.Prev)
closetTree (yyt->MPC_Var.Type)
closetTree (yyt->MPC_Var.Distribution)
closetTree (yyt->MPC_Var.Init)
break;
case kMPC_CoordDecl:
closetTree (yyt->MPC_CoordDecl.Next)
closetTree (yyt->MPC_CoordDecl.Prev)
closetTree (yyt->MPC_CoordDecl.Range)
break;
case kMPC_Node:
closetTree (yyt->MPC_Node.Next)
closetTree (yyt->MPC_Node.Prev)
closetTree (yyt->MPC_Node.Predicate)
closetTree (yyt->MPC_Node.NodeQual)
break;
case kMPC_NodeQual:
closetTree (yyt->MPC_NodeQual.CapacityExpr)
break;
case kMPC_NodeTypeQual:
closetTree (yyt->MPC_NodeTypeQual.CapacityExpr)
break;
case kMPC_BenchQual:
closetTree (yyt->MPC_BenchQual.CapacityExpr)
break;
case kMPC_LinkDecl:
closetTree (yyt->MPC_LinkDecl.FreeCoord)
closetTree (yyt->MPC_LinkDecl.LinkDeclaringList)
break;
case kMPC_LinkDeclaringList:
closetTree (yyt->MPC_LinkDeclaringList.Next)
closetTree (yyt->MPC_LinkDeclaringList.Prev)
closetTree (yyt->MPC_LinkDeclaringList.Predicate)
closetTree (yyt->MPC_LinkDeclaringList.LinkLengthSpecifier)
closetTree (yyt->MPC_LinkDeclaringList.LinkDeclarator)
break;
case kMPC_LinkDeclarator:
closetTree (yyt->MPC_LinkDeclarator.Next)
closetTree (yyt->MPC_LinkDeclarator.Prev)
closetTree (yyt->MPC_LinkDeclarator.LeftNode)
closetTree (yyt->MPC_LinkDeclarator.RightNode)
break;
case kMPC_LinkLengthSpecifier:
closetTree (yyt->MPC_LinkLengthSpecifier.LinkLengthExpr)
break;
case kMPC_Scheme:
closetTree (yyt->MPC_Scheme.Body)
break;
case kMPC_NetList:
closetTree (yyt->MPC_NetList.Next)
closetTree (yyt->MPC_NetList.Prev)
closetTree (yyt->MPC_NetList.Net)
break;
case kMPC_NetOrSubnet:
closetTree (yyt->MPC_NetOrSubnet.Distribution)
closetTree (yyt->MPC_NetOrSubnet.Next)
closetTree (yyt->MPC_NetOrSubnet.Prev)
closetTree (yyt->MPC_NetOrSubnet.NextUse)
closetTree (yyt->MPC_NetOrSubnet.PrevUse)
closetTree (yyt->MPC_NetOrSubnet.MyList)
break;
case kMPC_Net:
closetTree (yyt->MPC_Net.Distribution)
closetTree (yyt->MPC_Net.Next)
closetTree (yyt->MPC_Net.Prev)
closetTree (yyt->MPC_Net.NextUse)
closetTree (yyt->MPC_Net.PrevUse)
closetTree (yyt->MPC_Net.MyList)
closetTree (yyt->MPC_Net.NetType)
break;
case kMPC_Subnet:
closetTree (yyt->MPC_Subnet.Distribution)
closetTree (yyt->MPC_Subnet.Next)
closetTree (yyt->MPC_Subnet.Prev)
closetTree (yyt->MPC_Subnet.NextUse)
closetTree (yyt->MPC_Subnet.PrevUse)
closetTree (yyt->MPC_Subnet.MyList)
closetTree (yyt->MPC_Subnet.Predicate)
break;
case kMPC_Relation:
closetTree (yyt->MPC_Relation.Next)
closetTree (yyt->MPC_Relation.Prev)
closetTree (yyt->MPC_Relation.LNet)
closetTree (yyt->MPC_Relation.RNet)
break;
case kMPC_Stats:
closetTree (yyt->MPC_Stats.Next)
closetTree (yyt->MPC_Stats.Prev)
break;
case kMPC_Stat:
closetTree (yyt->MPC_Stat.Next)
closetTree (yyt->MPC_Stat.Prev)
closetTree (yyt->MPC_Stat.ExecNet)
closetTree (yyt->MPC_Stat.ActualExecNet)
closetTree (yyt->MPC_Stat.RootNet)
closetTree (yyt->MPC_Stat.PropNet)
break;
case kMPC_ExprStat:
closetTree (yyt->MPC_ExprStat.Next)
closetTree (yyt->MPC_ExprStat.Prev)
closetTree (yyt->MPC_ExprStat.ExecNet)
closetTree (yyt->MPC_ExprStat.ActualExecNet)
closetTree (yyt->MPC_ExprStat.RootNet)
closetTree (yyt->MPC_ExprStat.PropNet)
closetTree (yyt->MPC_ExprStat.Expr)
break;
case kMPC_If:
closetTree (yyt->MPC_If.Next)
closetTree (yyt->MPC_If.Prev)
closetTree (yyt->MPC_If.ExecNet)
closetTree (yyt->MPC_If.ActualExecNet)
closetTree (yyt->MPC_If.RootNet)
closetTree (yyt->MPC_If.PropNet)
closetTree (yyt->MPC_If.Expr)
closetTree (yyt->MPC_If.Stats)
break;
case kMPC_IfElse:
closetTree (yyt->MPC_IfElse.Next)
closetTree (yyt->MPC_IfElse.Prev)
closetTree (yyt->MPC_IfElse.ExecNet)
closetTree (yyt->MPC_IfElse.ActualExecNet)
closetTree (yyt->MPC_IfElse.RootNet)
closetTree (yyt->MPC_IfElse.PropNet)
closetTree (yyt->MPC_IfElse.Expr)
closetTree (yyt->MPC_IfElse.Then)
closetTree (yyt->MPC_IfElse.Else)
break;
case kMPC_Switch:
closetTree (yyt->MPC_Switch.Next)
closetTree (yyt->MPC_Switch.Prev)
closetTree (yyt->MPC_Switch.ExecNet)
closetTree (yyt->MPC_Switch.ActualExecNet)
closetTree (yyt->MPC_Switch.RootNet)
closetTree (yyt->MPC_Switch.PropNet)
closetTree (yyt->MPC_Switch.Expr)
closetTree (yyt->MPC_Switch.Stats)
break;
case kMPC_While:
closetTree (yyt->MPC_While.Next)
closetTree (yyt->MPC_While.Prev)
closetTree (yyt->MPC_While.ExecNet)
closetTree (yyt->MPC_While.ActualExecNet)
closetTree (yyt->MPC_While.RootNet)
closetTree (yyt->MPC_While.PropNet)
closetTree (yyt->MPC_While.Expr)
closetTree (yyt->MPC_While.Stats)
break;
case kMPC_DoWhile:
closetTree (yyt->MPC_DoWhile.Next)
closetTree (yyt->MPC_DoWhile.Prev)
closetTree (yyt->MPC_DoWhile.ExecNet)
closetTree (yyt->MPC_DoWhile.ActualExecNet)
closetTree (yyt->MPC_DoWhile.RootNet)
closetTree (yyt->MPC_DoWhile.PropNet)
closetTree (yyt->MPC_DoWhile.Stats)
closetTree (yyt->MPC_DoWhile.Expr)
break;
case kMPC_For:
closetTree (yyt->MPC_For.Next)
closetTree (yyt->MPC_For.Prev)
closetTree (yyt->MPC_For.ExecNet)
closetTree (yyt->MPC_For.ActualExecNet)
closetTree (yyt->MPC_For.RootNet)
closetTree (yyt->MPC_For.PropNet)
closetTree (yyt->MPC_For.Init)
closetTree (yyt->MPC_For.Cond)
closetTree (yyt->MPC_For.Reinit)
closetTree (yyt->MPC_For.Stats)
break;
case kMPC_Goto:
closetTree (yyt->MPC_Goto.Next)
closetTree (yyt->MPC_Goto.Prev)
closetTree (yyt->MPC_Goto.ExecNet)
closetTree (yyt->MPC_Goto.ActualExecNet)
closetTree (yyt->MPC_Goto.RootNet)
closetTree (yyt->MPC_Goto.PropNet)
closetTree (yyt->MPC_Goto.LabelDef)
closetTree (yyt->MPC_Goto.NextUse)
closetTree (yyt->MPC_Goto.PrevUse)
break;
case kMPC_Continue:
closetTree (yyt->MPC_Continue.Next)
closetTree (yyt->MPC_Continue.Prev)
closetTree (yyt->MPC_Continue.ExecNet)
closetTree (yyt->MPC_Continue.ActualExecNet)
closetTree (yyt->MPC_Continue.RootNet)
closetTree (yyt->MPC_Continue.PropNet)
break;
case kMPC_Break:
closetTree (yyt->MPC_Break.Next)
closetTree (yyt->MPC_Break.Prev)
closetTree (yyt->MPC_Break.ExecNet)
closetTree (yyt->MPC_Break.ActualExecNet)
closetTree (yyt->MPC_Break.RootNet)
closetTree (yyt->MPC_Break.PropNet)
break;
case kMPC_BreakFan:
closetTree (yyt->MPC_BreakFan.Next)
closetTree (yyt->MPC_BreakFan.Prev)
closetTree (yyt->MPC_BreakFan.ExecNet)
closetTree (yyt->MPC_BreakFan.ActualExecNet)
closetTree (yyt->MPC_BreakFan.RootNet)
closetTree (yyt->MPC_BreakFan.PropNet)
break;
case kMPC_Return:
closetTree (yyt->MPC_Return.Next)
closetTree (yyt->MPC_Return.Prev)
closetTree (yyt->MPC_Return.ExecNet)
closetTree (yyt->MPC_Return.ActualExecNet)
closetTree (yyt->MPC_Return.RootNet)
closetTree (yyt->MPC_Return.PropNet)
closetTree (yyt->MPC_Return.Expr)
break;
case kMPC_Compound:
closetTree (yyt->MPC_Compound.Next)
closetTree (yyt->MPC_Compound.Prev)
closetTree (yyt->MPC_Compound.ExecNet)
closetTree (yyt->MPC_Compound.ActualExecNet)
closetTree (yyt->MPC_Compound.RootNet)
closetTree (yyt->MPC_Compound.PropNet)
closetTree (yyt->MPC_Compound.Decls)
closetTree (yyt->MPC_Compound.Stats)
break;
case kMPC_CompScheme:
closetTree (yyt->MPC_CompScheme.Next)
closetTree (yyt->MPC_CompScheme.Prev)
closetTree (yyt->MPC_CompScheme.ExecNet)
closetTree (yyt->MPC_CompScheme.ActualExecNet)
closetTree (yyt->MPC_CompScheme.RootNet)
closetTree (yyt->MPC_CompScheme.PropNet)
closetTree (yyt->MPC_CompScheme.Expr)
closetTree (yyt->MPC_CompScheme.Node)
break;
case kMPC_CommScheme:
closetTree (yyt->MPC_CommScheme.Next)
closetTree (yyt->MPC_CommScheme.Prev)
closetTree (yyt->MPC_CommScheme.ExecNet)
closetTree (yyt->MPC_CommScheme.ActualExecNet)
closetTree (yyt->MPC_CommScheme.RootNet)
closetTree (yyt->MPC_CommScheme.PropNet)
closetTree (yyt->MPC_CommScheme.Expr)
closetTree (yyt->MPC_CommScheme.From)
closetTree (yyt->MPC_CommScheme.To)
break;
case kMPC_ParScheme:
closetTree (yyt->MPC_ParScheme.Next)
closetTree (yyt->MPC_ParScheme.Prev)
closetTree (yyt->MPC_ParScheme.ExecNet)
closetTree (yyt->MPC_ParScheme.ActualExecNet)
closetTree (yyt->MPC_ParScheme.RootNet)
closetTree (yyt->MPC_ParScheme.PropNet)
closetTree (yyt->MPC_ParScheme.Init)
closetTree (yyt->MPC_ParScheme.Cond)
closetTree (yyt->MPC_ParScheme.Reinit)
closetTree (yyt->MPC_ParScheme.Stats)
break;
case kMPC_Fan:
closetTree (yyt->MPC_Fan.Next)
closetTree (yyt->MPC_Fan.Prev)
closetTree (yyt->MPC_Fan.ExecNet)
closetTree (yyt->MPC_Fan.ActualExecNet)
closetTree (yyt->MPC_Fan.RootNet)
closetTree (yyt->MPC_Fan.PropNet)
closetTree (yyt->MPC_Fan.Body)
break;
case kMPC_Label:
closetTree (yyt->MPC_Label.Next)
closetTree (yyt->MPC_Label.Prev)
closetTree (yyt->MPC_Label.NextLabel)
closetTree (yyt->MPC_Label.PrevLabel)
break;
case kMPC_IdentLabel:
closetTree (yyt->MPC_IdentLabel.Next)
closetTree (yyt->MPC_IdentLabel.Prev)
closetTree (yyt->MPC_IdentLabel.NextLabel)
closetTree (yyt->MPC_IdentLabel.PrevLabel)
closetTree (yyt->MPC_IdentLabel.NextUse)
break;
case kMPC_CaseLabel:
closetTree (yyt->MPC_CaseLabel.Next)
closetTree (yyt->MPC_CaseLabel.Prev)
closetTree (yyt->MPC_CaseLabel.NextLabel)
closetTree (yyt->MPC_CaseLabel.PrevLabel)
closetTree (yyt->MPC_CaseLabel.Expr)
break;
case kMPC_Default:
closetTree (yyt->MPC_Default.Next)
closetTree (yyt->MPC_Default.Prev)
closetTree (yyt->MPC_Default.NextLabel)
closetTree (yyt->MPC_Default.PrevLabel)
break;
case kMPC_Expr:
closetTree (yyt->MPC_Expr.Type)
closetTree (yyt->MPC_Expr.EvalNet)
closetTree (yyt->MPC_Expr.StoreNet)
closetTree (yyt->MPC_Expr.ActualEvalNet)
break;
case kMPC_Const:
closetTree (yyt->MPC_Const.Type)
closetTree (yyt->MPC_Const.EvalNet)
closetTree (yyt->MPC_Const.StoreNet)
closetTree (yyt->MPC_Const.ActualEvalNet)
break;
case kMPC_IntConst:
closetTree (yyt->MPC_IntConst.Type)
closetTree (yyt->MPC_IntConst.EvalNet)
closetTree (yyt->MPC_IntConst.StoreNet)
closetTree (yyt->MPC_IntConst.ActualEvalNet)
break;
case kMPC_UIntConst:
closetTree (yyt->MPC_UIntConst.Type)
closetTree (yyt->MPC_UIntConst.EvalNet)
closetTree (yyt->MPC_UIntConst.StoreNet)
closetTree (yyt->MPC_UIntConst.ActualEvalNet)
break;
case kMPC_FloatConst:
closetTree (yyt->MPC_FloatConst.Type)
closetTree (yyt->MPC_FloatConst.EvalNet)
closetTree (yyt->MPC_FloatConst.StoreNet)
closetTree (yyt->MPC_FloatConst.ActualEvalNet)
break;
case kMPC_StringLiteral:
closetTree (yyt->MPC_StringLiteral.Type)
closetTree (yyt->MPC_StringLiteral.EvalNet)
closetTree (yyt->MPC_StringLiteral.StoreNet)
closetTree (yyt->MPC_StringLiteral.ActualEvalNet)
closetTree (yyt->MPC_StringLiteral.Next)
closetTree (yyt->MPC_StringLiteral.Prev)
break;
case kMPC_Ident:
closetTree (yyt->MPC_Ident.Type)
closetTree (yyt->MPC_Ident.EvalNet)
closetTree (yyt->MPC_Ident.StoreNet)
closetTree (yyt->MPC_Ident.ActualEvalNet)
closetTree (yyt->MPC_Ident.Store)
closetTree (yyt->MPC_Ident.NextUse)
closetTree (yyt->MPC_Ident.PrevUse)
break;
case kMPC_CastExpr:
closetTree (yyt->MPC_CastExpr.Type)
closetTree (yyt->MPC_CastExpr.EvalNet)
closetTree (yyt->MPC_CastExpr.StoreNet)
closetTree (yyt->MPC_CastExpr.ActualEvalNet)
closetTree (yyt->MPC_CastExpr.TypeName)
closetTree (yyt->MPC_CastExpr.Operand)
break;
case kMPC_NetCastExpr:
closetTree (yyt->MPC_NetCastExpr.Type)
closetTree (yyt->MPC_NetCastExpr.EvalNet)
closetTree (yyt->MPC_NetCastExpr.StoreNet)
closetTree (yyt->MPC_NetCastExpr.ActualEvalNet)
closetTree (yyt->MPC_NetCastExpr.Operand)
break;
case kMPC_CoordExpr:
closetTree (yyt->MPC_CoordExpr.Type)
closetTree (yyt->MPC_CoordExpr.EvalNet)
closetTree (yyt->MPC_CoordExpr.StoreNet)
closetTree (yyt->MPC_CoordExpr.ActualEvalNet)
closetTree (yyt->MPC_CoordExpr.Operand)
break;
case kMPC_SizeofExpr:
closetTree (yyt->MPC_SizeofExpr.Type)
closetTree (yyt->MPC_SizeofExpr.EvalNet)
closetTree (yyt->MPC_SizeofExpr.StoreNet)
closetTree (yyt->MPC_SizeofExpr.ActualEvalNet)
break;
case kMPC_Size_Of_Value:
closetTree (yyt->MPC_Size_Of_Value.Type)
closetTree (yyt->MPC_Size_Of_Value.EvalNet)
closetTree (yyt->MPC_Size_Of_Value.StoreNet)
closetTree (yyt->MPC_Size_Of_Value.ActualEvalNet)
closetTree (yyt->MPC_Size_Of_Value.Operand)
break;
case kMPC_Size_Of_Type:
closetTree (yyt->MPC_Size_Of_Type.Type)
closetTree (yyt->MPC_Size_Of_Type.EvalNet)
closetTree (yyt->MPC_Size_Of_Type.StoreNet)
closetTree (yyt->MPC_Size_Of_Type.ActualEvalNet)
closetTree (yyt->MPC_Size_Of_Type.Operand)
break;
case kMPC_TimeofExpr:
closetTree (yyt->MPC_TimeofExpr.Type)
closetTree (yyt->MPC_TimeofExpr.EvalNet)
closetTree (yyt->MPC_TimeofExpr.StoreNet)
closetTree (yyt->MPC_TimeofExpr.ActualEvalNet)
closetTree (yyt->MPC_TimeofExpr.NetDecl)
break;
case kMPC_UnaryExpr:
closetTree (yyt->MPC_UnaryExpr.Type)
closetTree (yyt->MPC_UnaryExpr.EvalNet)
closetTree (yyt->MPC_UnaryExpr.StoreNet)
closetTree (yyt->MPC_UnaryExpr.ActualEvalNet)
closetTree (yyt->MPC_UnaryExpr.Operand)
break;
case kMPC_BinaryExpr:
closetTree (yyt->MPC_BinaryExpr.Type)
closetTree (yyt->MPC_BinaryExpr.EvalNet)
closetTree (yyt->MPC_BinaryExpr.StoreNet)
closetTree (yyt->MPC_BinaryExpr.ActualEvalNet)
closetTree (yyt->MPC_BinaryExpr.Loperand)
closetTree (yyt->MPC_BinaryExpr.Roperand)
break;
case kMPC_TernaryExpr:
closetTree (yyt->MPC_TernaryExpr.Type)
closetTree (yyt->MPC_TernaryExpr.EvalNet)
closetTree (yyt->MPC_TernaryExpr.StoreNet)
closetTree (yyt->MPC_TernaryExpr.ActualEvalNet)
closetTree (yyt->MPC_TernaryExpr.Foperand)
closetTree (yyt->MPC_TernaryExpr.Soperand)
closetTree (yyt->MPC_TernaryExpr.Toperand)
break;
case kMPC_QuaternaryExpr:
closetTree (yyt->MPC_QuaternaryExpr.Type)
closetTree (yyt->MPC_QuaternaryExpr.EvalNet)
closetTree (yyt->MPC_QuaternaryExpr.StoreNet)
closetTree (yyt->MPC_QuaternaryExpr.ActualEvalNet)
closetTree (yyt->MPC_QuaternaryExpr.Operand1)
closetTree (yyt->MPC_QuaternaryExpr.Operand2)
closetTree (yyt->MPC_QuaternaryExpr.Operand3)
closetTree (yyt->MPC_QuaternaryExpr.Operand4)
break;
case kMPC_CallExpr:
closetTree (yyt->MPC_CallExpr.Type)
closetTree (yyt->MPC_CallExpr.EvalNet)
closetTree (yyt->MPC_CallExpr.StoreNet)
closetTree (yyt->MPC_CallExpr.ActualEvalNet)
closetTree (yyt->MPC_CallExpr.Function)
closetTree (yyt->MPC_CallExpr.ArgList)
closetTree (yyt->MPC_CallExpr.NetworkArgList)
break;
case kMPC_Exprs:
closetTree (yyt->MPC_Exprs.Next)
closetTree (yyt->MPC_Exprs.Prev)
closetTree (yyt->MPC_Exprs.Expr)
break;
case kMPC_Initializer:
closetTree (yyt->MPC_Initializer.Next)
closetTree (yyt->MPC_Initializer.Prev)
break;
case kMPC_SimpleInit:
closetTree (yyt->MPC_SimpleInit.Next)
closetTree (yyt->MPC_SimpleInit.Prev)
closetTree (yyt->MPC_SimpleInit.Expr)
break;
case kMPC_InitList:
closetTree (yyt->MPC_InitList.Next)
closetTree (yyt->MPC_InitList.Prev)
closetTree (yyt->MPC_InitList.List)
break;
 default: ;
 }

 if (-- yyt->yyHead.yyMark == 0) {
  switch (yyt->Kind) {
case kMPC_Source:
closetString (yyt->MPC_Source.FileName)
closetPosition (yyt->MPC_Source.VirtPos)
closetPosition (yyt->MPC_Source.RealPos)
break;
case kMPC_Messages:
closeint (yyt->MPC_Messages.ErrorClass)
closetPosition (yyt->MPC_Messages.Pos)
break;
case kMPC_ErrorMessage:
closeint (yyt->MPC_ErrorMessage.ErrorClass)
closetPosition (yyt->MPC_ErrorMessage.Pos)
closeint (yyt->MPC_ErrorMessage.ErrorCode)
break;
case kMPC_ErrorMessageI:
closeint (yyt->MPC_ErrorMessageI.ErrorClass)
closetPosition (yyt->MPC_ErrorMessageI.Pos)
closeint (yyt->MPC_ErrorMessageI.ErrorCode)
closeint (yyt->MPC_ErrorMessageI.InfoClass)
closetString (yyt->MPC_ErrorMessageI.Info)
break;
case kMPC_Message:
closeint (yyt->MPC_Message.ErrorClass)
closetPosition (yyt->MPC_Message.Pos)
closeshort (yyt->MPC_Message.MessageNumber)
break;
case kMPC_MessageI:
closeint (yyt->MPC_MessageI.ErrorClass)
closetPosition (yyt->MPC_MessageI.Pos)
closeshort (yyt->MPC_MessageI.MessageNumber)
closeint (yyt->MPC_MessageI.InfoClass)
closetString (yyt->MPC_MessageI.Info)
break;
case kMPC_Decls:
closetPosition (yyt->MPC_Decls.Pos)
closetPosition (yyt->MPC_Decls.EndPos)
break;
case kMPC_UncompString:
closetPosition (yyt->MPC_UncompString.Pos)
closetPosition (yyt->MPC_UncompString.EndPos)
closetString (yyt->MPC_UncompString.uString)
break;
case kMPC_Type:
closetPosition (yyt->MPC_Type.Pos)
closetPosition (yyt->MPC_Type.EndPos)
closetTypeFlags (yyt->MPC_Type.Flag)
closebool (yyt->MPC_Type.Buffer)
closeMPC_unsigned_short (yyt->MPC_Type.UniqueNumber)
closepVoid (yyt->MPC_Type.pType)
break;
case kMPC_BasicType:
closetPosition (yyt->MPC_BasicType.Pos)
closetPosition (yyt->MPC_BasicType.EndPos)
closetTypeFlags (yyt->MPC_BasicType.Flag)
closebool (yyt->MPC_BasicType.Buffer)
closeMPC_unsigned_short (yyt->MPC_BasicType.UniqueNumber)
closepVoid (yyt->MPC_BasicType.pType)
closeshort (yyt->MPC_BasicType.TypeConstructor)
break;
case kMPC_EnumType:
closetPosition (yyt->MPC_EnumType.Pos)
closetPosition (yyt->MPC_EnumType.EndPos)
closetTypeFlags (yyt->MPC_EnumType.Flag)
closebool (yyt->MPC_EnumType.Buffer)
closeMPC_unsigned_short (yyt->MPC_EnumType.UniqueNumber)
closepVoid (yyt->MPC_EnumType.pType)
closetIdent (yyt->MPC_EnumType.EnumTag)
break;
case kMPC_Typedef:
closetPosition (yyt->MPC_Typedef.Pos)
closetPosition (yyt->MPC_Typedef.EndPos)
closetTypeFlags (yyt->MPC_Typedef.Flag)
closebool (yyt->MPC_Typedef.Buffer)
closeMPC_unsigned_short (yyt->MPC_Typedef.UniqueNumber)
closepVoid (yyt->MPC_Typedef.pType)
closetIdent (yyt->MPC_Typedef.TypedefName)
break;
case kMPC_DerivedType:
closetPosition (yyt->MPC_DerivedType.Pos)
closetPosition (yyt->MPC_DerivedType.EndPos)
closetTypeFlags (yyt->MPC_DerivedType.Flag)
closebool (yyt->MPC_DerivedType.Buffer)
closeMPC_unsigned_short (yyt->MPC_DerivedType.UniqueNumber)
closepVoid (yyt->MPC_DerivedType.pType)
closeint (yyt->MPC_DerivedType.NumberOfComponents)
break;
case kMPC_ArrayType:
closetPosition (yyt->MPC_ArrayType.Pos)
closetPosition (yyt->MPC_ArrayType.EndPos)
closetTypeFlags (yyt->MPC_ArrayType.Flag)
closebool (yyt->MPC_ArrayType.Buffer)
closeMPC_unsigned_short (yyt->MPC_ArrayType.UniqueNumber)
closepVoid (yyt->MPC_ArrayType.pType)
closeint (yyt->MPC_ArrayType.NumberOfComponents)
closeshort (yyt->MPC_ArrayType.Step)
break;
case kMPC_VectorType:
closetPosition (yyt->MPC_VectorType.Pos)
closetPosition (yyt->MPC_VectorType.EndPos)
closetTypeFlags (yyt->MPC_VectorType.Flag)
closebool (yyt->MPC_VectorType.Buffer)
closeMPC_unsigned_short (yyt->MPC_VectorType.UniqueNumber)
closepVoid (yyt->MPC_VectorType.pType)
closeint (yyt->MPC_VectorType.NumberOfComponents)
break;
case kMPC_PointerType:
closetPosition (yyt->MPC_PointerType.Pos)
closetPosition (yyt->MPC_PointerType.EndPos)
closetTypeFlags (yyt->MPC_PointerType.Flag)
closebool (yyt->MPC_PointerType.Buffer)
closeMPC_unsigned_short (yyt->MPC_PointerType.UniqueNumber)
closepVoid (yyt->MPC_PointerType.pType)
closeint (yyt->MPC_PointerType.NumberOfComponents)
closeshort (yyt->MPC_PointerType.Step)
break;
case kMPC_StructType:
closetPosition (yyt->MPC_StructType.Pos)
closetPosition (yyt->MPC_StructType.EndPos)
closetTypeFlags (yyt->MPC_StructType.Flag)
closebool (yyt->MPC_StructType.Buffer)
closeMPC_unsigned_short (yyt->MPC_StructType.UniqueNumber)
closepVoid (yyt->MPC_StructType.pType)
closeint (yyt->MPC_StructType.NumberOfComponents)
closetIdent (yyt->MPC_StructType.SU_Tag)
break;
case kMPC_UnionType:
closetPosition (yyt->MPC_UnionType.Pos)
closetPosition (yyt->MPC_UnionType.EndPos)
closetTypeFlags (yyt->MPC_UnionType.Flag)
closebool (yyt->MPC_UnionType.Buffer)
closeMPC_unsigned_short (yyt->MPC_UnionType.UniqueNumber)
closepVoid (yyt->MPC_UnionType.pType)
closeint (yyt->MPC_UnionType.NumberOfComponents)
closetIdent (yyt->MPC_UnionType.SU_Tag)
break;
case kMPC_FunctionType:
closetPosition (yyt->MPC_FunctionType.Pos)
closetPosition (yyt->MPC_FunctionType.EndPos)
closetTypeFlags (yyt->MPC_FunctionType.Flag)
closebool (yyt->MPC_FunctionType.Buffer)
closeMPC_unsigned_short (yyt->MPC_FunctionType.UniqueNumber)
closepVoid (yyt->MPC_FunctionType.pType)
closeint (yyt->MPC_FunctionType.NumberOfComponents)
closeshort (yyt->MPC_FunctionType.Kind)
break;
case kMPC_VarDecl:
closetPosition (yyt->MPC_VarDecl.Pos)
closetPosition (yyt->MPC_VarDecl.EndPos)
closetClass (yyt->MPC_VarDecl.Class)
closetDeclFlags (yyt->MPC_VarDecl.Flag)
break;
case kMPC_Function:
closetPosition (yyt->MPC_Function.Pos)
closetPosition (yyt->MPC_Function.EndPos)
closeshort (yyt->MPC_Function.Kind)
closetDeclFlags (yyt->MPC_Function.Flag)
break;
case kMPC_Ellipsis:
closetPosition (yyt->MPC_Ellipsis.Pos)
closetPosition (yyt->MPC_Ellipsis.EndPos)
break;
case kMPC_NetDecl:
closetPosition (yyt->MPC_NetDecl.Pos)
closetPosition (yyt->MPC_NetDecl.EndPos)
closetClass (yyt->MPC_NetDecl.NetClass)
closetDeclFlags (yyt->MPC_NetDecl.Flag)
break;
case kMPC_SubnetDecl:
closetPosition (yyt->MPC_SubnetDecl.Pos)
closetPosition (yyt->MPC_SubnetDecl.EndPos)
closetClass (yyt->MPC_SubnetDecl.SubnetClass)
closetDeclFlags (yyt->MPC_SubnetDecl.Flag)
break;
case kMPC_RelDecl:
closetPosition (yyt->MPC_RelDecl.Pos)
closetPosition (yyt->MPC_RelDecl.EndPos)
break;
case kMPC_NetTypeDecl:
closetPosition (yyt->MPC_NetTypeDecl.Pos)
closetPosition (yyt->MPC_NetTypeDecl.EndPos)
closetIdent (yyt->MPC_NetTypeDecl.Ident)
break;
case kMPC_NetType:
closetPosition (yyt->MPC_NetType.Pos)
closetPosition (yyt->MPC_NetType.EndPos)
closetIdent (yyt->MPC_NetType.Ident)
closetClass (yyt->MPC_NetType.Class)
closebool (yyt->MPC_NetType.Bench)
break;
case kMPC_NetTypeSpecifier:
closetPosition (yyt->MPC_NetTypeSpecifier.Pos)
closetPosition (yyt->MPC_NetTypeSpecifier.EndPos)
closetIdent (yyt->MPC_NetTypeSpecifier.Ident)
break;
case kMPC_EnumConst:
closetPosition (yyt->MPC_EnumConst.Pos)
closetIdent (yyt->MPC_EnumConst.Name)
closebool (yyt->MPC_EnumConst.WithValue)
closeint (yyt->MPC_EnumConst.Value)
closetPosition (yyt->MPC_EnumConst.EndPos)
break;
case kMPC_SU_MemberDecl:
closetPosition (yyt->MPC_SU_MemberDecl.Pos)
closetPosition (yyt->MPC_SU_MemberDecl.EndPos)
break;
case kMPC_SU_Member:
closetPosition (yyt->MPC_SU_Member.Pos)
closetIdent (yyt->MPC_SU_Member.Name)
closeshort (yyt->MPC_SU_Member.BitFieldLength)
closetPosition (yyt->MPC_SU_Member.EndPos)
closeMPC_unsigned_short (yyt->MPC_SU_Member.UniqueNumber)
break;
case kMPC_Var:
closetPosition (yyt->MPC_Var.Pos)
closetIdent (yyt->MPC_Var.Ident)
closetDeclFlags (yyt->MPC_Var.Flag)
closetPosition (yyt->MPC_Var.EndPos)
break;
case kMPC_CoordDecl:
closetPosition (yyt->MPC_CoordDecl.Pos)
closetIdent (yyt->MPC_CoordDecl.Ident)
closetPosition (yyt->MPC_CoordDecl.EndPos)
closeshort (yyt->MPC_CoordDecl.CoordNumber)
break;
case kMPC_Node:
closetPosition (yyt->MPC_Node.Pos)
closetNodeType (yyt->MPC_Node.NodeType)
closebool (yyt->MPC_Node.DynamicType)
closetPosition (yyt->MPC_Node.EndPos)
break;
case kMPC_NodeQual:
closetPosition (yyt->MPC_NodeQual.Pos)
closetPosition (yyt->MPC_NodeQual.EndPos)
break;
case kMPC_NodeTypeQual:
closetPosition (yyt->MPC_NodeTypeQual.Pos)
closetPosition (yyt->MPC_NodeTypeQual.EndPos)
closebool (yyt->MPC_NodeTypeQual.Fast)
closeint (yyt->MPC_NodeTypeQual.Capacity)
break;
case kMPC_BenchQual:
closetPosition (yyt->MPC_BenchQual.Pos)
closetPosition (yyt->MPC_BenchQual.EndPos)
closedouble (yyt->MPC_BenchQual.Capacity)
break;
case kMPC_LinkDecl:
closetPosition (yyt->MPC_LinkDecl.Pos)
closetPosition (yyt->MPC_LinkDecl.EndPos)
break;
case kMPC_LinkDeclaringList:
closetPosition (yyt->MPC_LinkDeclaringList.Pos)
closetLinkType (yyt->MPC_LinkDeclaringList.LinkType)
closebool (yyt->MPC_LinkDeclaringList.DynamicLength)
closetPosition (yyt->MPC_LinkDeclaringList.EndPos)
break;
case kMPC_LinkDeclarator:
closetPosition (yyt->MPC_LinkDeclarator.Pos)
closetPosition (yyt->MPC_LinkDeclarator.EndPos)
break;
case kMPC_LinkLengthSpecifier:
closetPosition (yyt->MPC_LinkLengthSpecifier.Pos)
closetLinkType (yyt->MPC_LinkLengthSpecifier.LinkLength)
closetPosition (yyt->MPC_LinkLengthSpecifier.EndPos)
break;
case kMPC_Scheme:
closetPosition (yyt->MPC_Scheme.Pos)
closetPosition (yyt->MPC_Scheme.EndPos)
break;
case kMPC_NetList:
closetPosition (yyt->MPC_NetList.Pos)
closebool (yyt->MPC_NetList.UnReduceable)
break;
case kMPC_NetOrSubnet:
closetPosition (yyt->MPC_NetOrSubnet.Pos)
closetIdent (yyt->MPC_NetOrSubnet.Ident)
closebool (yyt->MPC_NetOrSubnet.BigCreate)
closetPosition (yyt->MPC_NetOrSubnet.EndPos)
closeMPC_unsigned_short (yyt->MPC_NetOrSubnet.UniqueNumber)
closebool (yyt->MPC_NetOrSubnet.WithNumber)
closebool (yyt->MPC_NetOrSubnet.SingleNode)
closebool (yyt->MPC_NetOrSubnet.IsParent)
closepVoid (yyt->MPC_NetOrSubnet.pGen)
break;
case kMPC_Net:
closetPosition (yyt->MPC_Net.Pos)
closetIdent (yyt->MPC_Net.Ident)
closebool (yyt->MPC_Net.BigCreate)
closetPosition (yyt->MPC_Net.EndPos)
closeMPC_unsigned_short (yyt->MPC_Net.UniqueNumber)
closebool (yyt->MPC_Net.WithNumber)
closebool (yyt->MPC_Net.SingleNode)
closebool (yyt->MPC_Net.IsParent)
closepVoid (yyt->MPC_Net.pGen)
closeshort (yyt->MPC_Net.Topology)
break;
case kMPC_Subnet:
closetPosition (yyt->MPC_Subnet.Pos)
closetIdent (yyt->MPC_Subnet.Ident)
closebool (yyt->MPC_Subnet.BigCreate)
closetPosition (yyt->MPC_Subnet.EndPos)
closeMPC_unsigned_short (yyt->MPC_Subnet.UniqueNumber)
closebool (yyt->MPC_Subnet.WithNumber)
closebool (yyt->MPC_Subnet.SingleNode)
closebool (yyt->MPC_Subnet.IsParent)
closepVoid (yyt->MPC_Subnet.pGen)
closetIdent (yyt->MPC_Subnet.NetOrSubnetName)
closebool (yyt->MPC_Subnet.Flexible)
break;
case kMPC_Relation:
closetPosition (yyt->MPC_Relation.Pos)
closeint (yyt->MPC_Relation.RelCode)
closetPosition (yyt->MPC_Relation.EndPos)
break;
case kMPC_Stats:
closetPosition (yyt->MPC_Stats.Pos)
closetPosition (yyt->MPC_Stats.EndPos)
break;
case kMPC_Stat:
closetPosition (yyt->MPC_Stat.Pos)
closetPosition (yyt->MPC_Stat.EndPos)
closetStatFlags (yyt->MPC_Stat.Flag)
closebool (yyt->MPC_Stat.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Stat.UniqueNumber)
break;
case kMPC_ExprStat:
closetPosition (yyt->MPC_ExprStat.Pos)
closetPosition (yyt->MPC_ExprStat.EndPos)
closetStatFlags (yyt->MPC_ExprStat.Flag)
closebool (yyt->MPC_ExprStat.Benchmark)
closeMPC_unsigned_short (yyt->MPC_ExprStat.UniqueNumber)
break;
case kMPC_If:
closetPosition (yyt->MPC_If.Pos)
closetPosition (yyt->MPC_If.EndPos)
closetStatFlags (yyt->MPC_If.Flag)
closebool (yyt->MPC_If.Benchmark)
closeMPC_unsigned_short (yyt->MPC_If.UniqueNumber)
break;
case kMPC_IfElse:
closetPosition (yyt->MPC_IfElse.Pos)
closetPosition (yyt->MPC_IfElse.EndPos)
closetStatFlags (yyt->MPC_IfElse.Flag)
closebool (yyt->MPC_IfElse.Benchmark)
closeMPC_unsigned_short (yyt->MPC_IfElse.UniqueNumber)
break;
case kMPC_Switch:
closetPosition (yyt->MPC_Switch.Pos)
closetPosition (yyt->MPC_Switch.EndPos)
closetStatFlags (yyt->MPC_Switch.Flag)
closebool (yyt->MPC_Switch.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Switch.UniqueNumber)
break;
case kMPC_While:
closetPosition (yyt->MPC_While.Pos)
closetPosition (yyt->MPC_While.EndPos)
closetStatFlags (yyt->MPC_While.Flag)
closebool (yyt->MPC_While.Benchmark)
closeMPC_unsigned_short (yyt->MPC_While.UniqueNumber)
break;
case kMPC_DoWhile:
closetPosition (yyt->MPC_DoWhile.Pos)
closetPosition (yyt->MPC_DoWhile.EndPos)
closetStatFlags (yyt->MPC_DoWhile.Flag)
closebool (yyt->MPC_DoWhile.Benchmark)
closeMPC_unsigned_short (yyt->MPC_DoWhile.UniqueNumber)
break;
case kMPC_For:
closetPosition (yyt->MPC_For.Pos)
closetPosition (yyt->MPC_For.EndPos)
closetStatFlags (yyt->MPC_For.Flag)
closebool (yyt->MPC_For.Benchmark)
closeMPC_unsigned_short (yyt->MPC_For.UniqueNumber)
break;
case kMPC_Goto:
closetPosition (yyt->MPC_Goto.Pos)
closetPosition (yyt->MPC_Goto.EndPos)
closetStatFlags (yyt->MPC_Goto.Flag)
closebool (yyt->MPC_Goto.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Goto.UniqueNumber)
closetIdent (yyt->MPC_Goto.Ident)
break;
case kMPC_Continue:
closetPosition (yyt->MPC_Continue.Pos)
closetPosition (yyt->MPC_Continue.EndPos)
closetStatFlags (yyt->MPC_Continue.Flag)
closebool (yyt->MPC_Continue.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Continue.UniqueNumber)
break;
case kMPC_Break:
closetPosition (yyt->MPC_Break.Pos)
closetPosition (yyt->MPC_Break.EndPos)
closetStatFlags (yyt->MPC_Break.Flag)
closebool (yyt->MPC_Break.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Break.UniqueNumber)
break;
case kMPC_BreakFan:
closetPosition (yyt->MPC_BreakFan.Pos)
closetPosition (yyt->MPC_BreakFan.EndPos)
closetStatFlags (yyt->MPC_BreakFan.Flag)
closebool (yyt->MPC_BreakFan.Benchmark)
closeMPC_unsigned_short (yyt->MPC_BreakFan.UniqueNumber)
break;
case kMPC_Return:
closetPosition (yyt->MPC_Return.Pos)
closetPosition (yyt->MPC_Return.EndPos)
closetStatFlags (yyt->MPC_Return.Flag)
closebool (yyt->MPC_Return.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Return.UniqueNumber)
break;
case kMPC_Compound:
closetPosition (yyt->MPC_Compound.Pos)
closetPosition (yyt->MPC_Compound.EndPos)
closetStatFlags (yyt->MPC_Compound.Flag)
closebool (yyt->MPC_Compound.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Compound.UniqueNumber)
closeint (yyt->MPC_Compound.FunctionBody)
break;
case kMPC_CompScheme:
closetPosition (yyt->MPC_CompScheme.Pos)
closetPosition (yyt->MPC_CompScheme.EndPos)
closetStatFlags (yyt->MPC_CompScheme.Flag)
closebool (yyt->MPC_CompScheme.Benchmark)
closeMPC_unsigned_short (yyt->MPC_CompScheme.UniqueNumber)
break;
case kMPC_CommScheme:
closetPosition (yyt->MPC_CommScheme.Pos)
closetPosition (yyt->MPC_CommScheme.EndPos)
closetStatFlags (yyt->MPC_CommScheme.Flag)
closebool (yyt->MPC_CommScheme.Benchmark)
closeMPC_unsigned_short (yyt->MPC_CommScheme.UniqueNumber)
break;
case kMPC_ParScheme:
closetPosition (yyt->MPC_ParScheme.Pos)
closetPosition (yyt->MPC_ParScheme.EndPos)
closetStatFlags (yyt->MPC_ParScheme.Flag)
closebool (yyt->MPC_ParScheme.Benchmark)
closeMPC_unsigned_short (yyt->MPC_ParScheme.UniqueNumber)
break;
case kMPC_Fan:
closetPosition (yyt->MPC_Fan.Pos)
closetPosition (yyt->MPC_Fan.EndPos)
closetStatFlags (yyt->MPC_Fan.Flag)
closebool (yyt->MPC_Fan.Benchmark)
closeMPC_unsigned_short (yyt->MPC_Fan.UniqueNumber)
break;
case kMPC_Label:
closetPosition (yyt->MPC_Label.Pos)
closetPosition (yyt->MPC_Label.EndPos)
break;
case kMPC_IdentLabel:
closetPosition (yyt->MPC_IdentLabel.Pos)
closetPosition (yyt->MPC_IdentLabel.EndPos)
closetIdent (yyt->MPC_IdentLabel.Ident)
closebool (yyt->MPC_IdentLabel.Used)
break;
case kMPC_CaseLabel:
closetPosition (yyt->MPC_CaseLabel.Pos)
closetPosition (yyt->MPC_CaseLabel.EndPos)
closelong (yyt->MPC_CaseLabel.CaseValue)
break;
case kMPC_Default:
closetPosition (yyt->MPC_Default.Pos)
closetPosition (yyt->MPC_Default.EndPos)
break;
case kMPC_Expr:
closetPosition (yyt->MPC_Expr.Pos)
closetExprFlags (yyt->MPC_Expr.Flag)
closetString (yyt->MPC_Expr.TmpName)
closetPosition (yyt->MPC_Expr.BegPos)
closetPosition (yyt->MPC_Expr.EndPos)
closechar (yyt->MPC_Expr.Pass)
closebool (yyt->MPC_Expr.Repl)
closetOptm_Attribute (yyt->MPC_Expr.Optm_Attribute)
break;
case kMPC_Const:
closetPosition (yyt->MPC_Const.Pos)
closetExprFlags (yyt->MPC_Const.Flag)
closetString (yyt->MPC_Const.TmpName)
closetPosition (yyt->MPC_Const.BegPos)
closetPosition (yyt->MPC_Const.EndPos)
closechar (yyt->MPC_Const.Pass)
closebool (yyt->MPC_Const.Repl)
closetOptm_Attribute (yyt->MPC_Const.Optm_Attribute)
closetString (yyt->MPC_Const.SymbolicForm)
break;
case kMPC_IntConst:
closetPosition (yyt->MPC_IntConst.Pos)
closetExprFlags (yyt->MPC_IntConst.Flag)
closetString (yyt->MPC_IntConst.TmpName)
closetPosition (yyt->MPC_IntConst.BegPos)
closetPosition (yyt->MPC_IntConst.EndPos)
closechar (yyt->MPC_IntConst.Pass)
closebool (yyt->MPC_IntConst.Repl)
closetOptm_Attribute (yyt->MPC_IntConst.Optm_Attribute)
closetString (yyt->MPC_IntConst.SymbolicForm)
closelong (yyt->MPC_IntConst.Value)
break;
case kMPC_UIntConst:
closetPosition (yyt->MPC_UIntConst.Pos)
closetExprFlags (yyt->MPC_UIntConst.Flag)
closetString (yyt->MPC_UIntConst.TmpName)
closetPosition (yyt->MPC_UIntConst.BegPos)
closetPosition (yyt->MPC_UIntConst.EndPos)
closechar (yyt->MPC_UIntConst.Pass)
closebool (yyt->MPC_UIntConst.Repl)
closetOptm_Attribute (yyt->MPC_UIntConst.Optm_Attribute)
closetString (yyt->MPC_UIntConst.SymbolicForm)
closeMPC_long_unsigned (yyt->MPC_UIntConst.Value)
break;
case kMPC_FloatConst:
closetPosition (yyt->MPC_FloatConst.Pos)
closetExprFlags (yyt->MPC_FloatConst.Flag)
closetString (yyt->MPC_FloatConst.TmpName)
closetPosition (yyt->MPC_FloatConst.BegPos)
closetPosition (yyt->MPC_FloatConst.EndPos)
closechar (yyt->MPC_FloatConst.Pass)
closebool (yyt->MPC_FloatConst.Repl)
closetOptm_Attribute (yyt->MPC_FloatConst.Optm_Attribute)
closetString (yyt->MPC_FloatConst.SymbolicForm)
closeMPC_long_double (yyt->MPC_FloatConst.Value)
break;
case kMPC_StringLiteral:
closetPosition (yyt->MPC_StringLiteral.Pos)
closetExprFlags (yyt->MPC_StringLiteral.Flag)
closetString (yyt->MPC_StringLiteral.TmpName)
closetPosition (yyt->MPC_StringLiteral.BegPos)
closetPosition (yyt->MPC_StringLiteral.EndPos)
closechar (yyt->MPC_StringLiteral.Pass)
closebool (yyt->MPC_StringLiteral.Repl)
closetOptm_Attribute (yyt->MPC_StringLiteral.Optm_Attribute)
closetString (yyt->MPC_StringLiteral.String)
closeshort (yyt->MPC_StringLiteral.FullSize)
break;
case kMPC_Ident:
closetPosition (yyt->MPC_Ident.Pos)
closetExprFlags (yyt->MPC_Ident.Flag)
closetString (yyt->MPC_Ident.TmpName)
closetPosition (yyt->MPC_Ident.BegPos)
closetPosition (yyt->MPC_Ident.EndPos)
closechar (yyt->MPC_Ident.Pass)
closebool (yyt->MPC_Ident.Repl)
closetOptm_Attribute (yyt->MPC_Ident.Optm_Attribute)
closetIdent (yyt->MPC_Ident.Ident)
break;
case kMPC_CastExpr:
closetPosition (yyt->MPC_CastExpr.Pos)
closetExprFlags (yyt->MPC_CastExpr.Flag)
closetString (yyt->MPC_CastExpr.TmpName)
closetPosition (yyt->MPC_CastExpr.BegPos)
closetPosition (yyt->MPC_CastExpr.EndPos)
closechar (yyt->MPC_CastExpr.Pass)
closebool (yyt->MPC_CastExpr.Repl)
closetOptm_Attribute (yyt->MPC_CastExpr.Optm_Attribute)
break;
case kMPC_NetCastExpr:
closetPosition (yyt->MPC_NetCastExpr.Pos)
closetExprFlags (yyt->MPC_NetCastExpr.Flag)
closetString (yyt->MPC_NetCastExpr.TmpName)
closetPosition (yyt->MPC_NetCastExpr.BegPos)
closetPosition (yyt->MPC_NetCastExpr.EndPos)
closechar (yyt->MPC_NetCastExpr.Pass)
closebool (yyt->MPC_NetCastExpr.Repl)
closetOptm_Attribute (yyt->MPC_NetCastExpr.Optm_Attribute)
closebool (yyt->MPC_NetCastExpr.Flexible)
closepVoid (yyt->MPC_NetCastExpr.ExprPtr)
break;
case kMPC_CoordExpr:
closetPosition (yyt->MPC_CoordExpr.Pos)
closetExprFlags (yyt->MPC_CoordExpr.Flag)
closetString (yyt->MPC_CoordExpr.TmpName)
closetPosition (yyt->MPC_CoordExpr.BegPos)
closetPosition (yyt->MPC_CoordExpr.EndPos)
closechar (yyt->MPC_CoordExpr.Pass)
closebool (yyt->MPC_CoordExpr.Repl)
closetOptm_Attribute (yyt->MPC_CoordExpr.Optm_Attribute)
closetIdent (yyt->MPC_CoordExpr.CoordName)
closeshort (yyt->MPC_CoordExpr.CoordNumber)
break;
case kMPC_SizeofExpr:
closetPosition (yyt->MPC_SizeofExpr.Pos)
closetExprFlags (yyt->MPC_SizeofExpr.Flag)
closetString (yyt->MPC_SizeofExpr.TmpName)
closetPosition (yyt->MPC_SizeofExpr.BegPos)
closetPosition (yyt->MPC_SizeofExpr.EndPos)
closechar (yyt->MPC_SizeofExpr.Pass)
closebool (yyt->MPC_SizeofExpr.Repl)
closetOptm_Attribute (yyt->MPC_SizeofExpr.Optm_Attribute)
closebool (yyt->MPC_SizeofExpr.CompileTime)
closeint (yyt->MPC_SizeofExpr.Value)
break;
case kMPC_Size_Of_Value:
closetPosition (yyt->MPC_Size_Of_Value.Pos)
closetExprFlags (yyt->MPC_Size_Of_Value.Flag)
closetString (yyt->MPC_Size_Of_Value.TmpName)
closetPosition (yyt->MPC_Size_Of_Value.BegPos)
closetPosition (yyt->MPC_Size_Of_Value.EndPos)
closechar (yyt->MPC_Size_Of_Value.Pass)
closebool (yyt->MPC_Size_Of_Value.Repl)
closetOptm_Attribute (yyt->MPC_Size_Of_Value.Optm_Attribute)
closebool (yyt->MPC_Size_Of_Value.CompileTime)
closeint (yyt->MPC_Size_Of_Value.Value)
break;
case kMPC_Size_Of_Type:
closetPosition (yyt->MPC_Size_Of_Type.Pos)
closetExprFlags (yyt->MPC_Size_Of_Type.Flag)
closetString (yyt->MPC_Size_Of_Type.TmpName)
closetPosition (yyt->MPC_Size_Of_Type.BegPos)
closetPosition (yyt->MPC_Size_Of_Type.EndPos)
closechar (yyt->MPC_Size_Of_Type.Pass)
closebool (yyt->MPC_Size_Of_Type.Repl)
closetOptm_Attribute (yyt->MPC_Size_Of_Type.Optm_Attribute)
closebool (yyt->MPC_Size_Of_Type.CompileTime)
closeint (yyt->MPC_Size_Of_Type.Value)
break;
case kMPC_TimeofExpr:
closetPosition (yyt->MPC_TimeofExpr.Pos)
closetExprFlags (yyt->MPC_TimeofExpr.Flag)
closetString (yyt->MPC_TimeofExpr.TmpName)
closetPosition (yyt->MPC_TimeofExpr.BegPos)
closetPosition (yyt->MPC_TimeofExpr.EndPos)
closechar (yyt->MPC_TimeofExpr.Pass)
closebool (yyt->MPC_TimeofExpr.Repl)
closetOptm_Attribute (yyt->MPC_TimeofExpr.Optm_Attribute)
break;
case kMPC_UnaryExpr:
closetPosition (yyt->MPC_UnaryExpr.Pos)
closetExprFlags (yyt->MPC_UnaryExpr.Flag)
closetString (yyt->MPC_UnaryExpr.TmpName)
closetPosition (yyt->MPC_UnaryExpr.BegPos)
closetPosition (yyt->MPC_UnaryExpr.EndPos)
closechar (yyt->MPC_UnaryExpr.Pass)
closebool (yyt->MPC_UnaryExpr.Repl)
closetOptm_Attribute (yyt->MPC_UnaryExpr.Optm_Attribute)
closeshort (yyt->MPC_UnaryExpr.OpCode)
break;
case kMPC_BinaryExpr:
closetPosition (yyt->MPC_BinaryExpr.Pos)
closetExprFlags (yyt->MPC_BinaryExpr.Flag)
closetString (yyt->MPC_BinaryExpr.TmpName)
closetPosition (yyt->MPC_BinaryExpr.BegPos)
closetPosition (yyt->MPC_BinaryExpr.EndPos)
closechar (yyt->MPC_BinaryExpr.Pass)
closebool (yyt->MPC_BinaryExpr.Repl)
closetOptm_Attribute (yyt->MPC_BinaryExpr.Optm_Attribute)
closeshort (yyt->MPC_BinaryExpr.OpCode)
break;
case kMPC_TernaryExpr:
closetPosition (yyt->MPC_TernaryExpr.Pos)
closetExprFlags (yyt->MPC_TernaryExpr.Flag)
closetString (yyt->MPC_TernaryExpr.TmpName)
closetPosition (yyt->MPC_TernaryExpr.BegPos)
closetPosition (yyt->MPC_TernaryExpr.EndPos)
closechar (yyt->MPC_TernaryExpr.Pass)
closebool (yyt->MPC_TernaryExpr.Repl)
closetOptm_Attribute (yyt->MPC_TernaryExpr.Optm_Attribute)
closeshort (yyt->MPC_TernaryExpr.OpCode)
break;
case kMPC_QuaternaryExpr:
closetPosition (yyt->MPC_QuaternaryExpr.Pos)
closetExprFlags (yyt->MPC_QuaternaryExpr.Flag)
closetString (yyt->MPC_QuaternaryExpr.TmpName)
closetPosition (yyt->MPC_QuaternaryExpr.BegPos)
closetPosition (yyt->MPC_QuaternaryExpr.EndPos)
closechar (yyt->MPC_QuaternaryExpr.Pass)
closebool (yyt->MPC_QuaternaryExpr.Repl)
closetOptm_Attribute (yyt->MPC_QuaternaryExpr.Optm_Attribute)
closeshort (yyt->MPC_QuaternaryExpr.OpCode)
break;
case kMPC_CallExpr:
closetPosition (yyt->MPC_CallExpr.Pos)
closetExprFlags (yyt->MPC_CallExpr.Flag)
closetString (yyt->MPC_CallExpr.TmpName)
closetPosition (yyt->MPC_CallExpr.BegPos)
closetPosition (yyt->MPC_CallExpr.EndPos)
closechar (yyt->MPC_CallExpr.Pass)
closebool (yyt->MPC_CallExpr.Repl)
closetOptm_Attribute (yyt->MPC_CallExpr.Optm_Attribute)
break;
case kMPC_Exprs:
closetPosition (yyt->MPC_Exprs.Pos)
closetPosition (yyt->MPC_Exprs.BegPos)
closetPosition (yyt->MPC_Exprs.EndPos)
break;
case kMPC_Initializer:
closetPosition (yyt->MPC_Initializer.Pos)
closetPosition (yyt->MPC_Initializer.EndPos)
break;
case kMPC_SimpleInit:
closetPosition (yyt->MPC_SimpleInit.Pos)
closetPosition (yyt->MPC_SimpleInit.EndPos)
break;
case kMPC_InitList:
closetPosition (yyt->MPC_InitList.Pos)
closetPosition (yyt->MPC_InitList.EndPos)
closeint (yyt->MPC_InitList.Length)
break;
  default: ;
  }
  yyFREE (yyt, Tree_NodeSize [yyt->Kind])
 }
}

void ReleaseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyMark (yyt);
 yyReleaseTree (yyt);
}

void ReleaseTreeModule ()
{
 yytBlockPtr yyBlockPtr;
 while (yyBlockList != (yytBlockPtr) NoTree) {
  yyBlockPtr = yyBlockList;
  yyBlockList = yyBlockList->yySuccessor;
  Free (sizeof (yytBlock), (char *) yyBlockPtr);
 }
 Tree_PoolFreePtr = (char *) NoTree;
 Tree_PoolMaxPtr = (char *) NoTree;
 Tree_HeapUsed = 0;
}

static Tree_tProcTree yyProc;

static void yyTraverseTreeTD
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || yyt->yyHead.yyMark == 0) return;
  yyt->yyHead.yyMark = 0;
  yyProc (yyt);

  switch (yyt->Kind) {
case kMPC_Root:
yyTraverseTreeTD (yyt->MPC_Root.Decls);
yyTraverseTreeTD (yyt->MPC_Root.Source);
yyTraverseTreeTD (yyt->MPC_Root.Messages);
yyTraverseTreeTD (yyt->MPC_Root.Host);
yyTraverseTreeTD (yyt->MPC_Root.SingleNode);
yyTraverseTreeTD (yyt->MPC_Root.ComputingSpace);
yyTraverseTreeTD (yyt->MPC_Root.Const);
yyTraverseTreeTD (yyt->MPC_Root.Recon);
yyTraverseTreeTD (yyt->MPC_Root.HostList);
yyTraverseTreeTD (yyt->MPC_Root.SingleNodeList);
yyTraverseTreeTD (yyt->MPC_Root.ComputingSpaceList);
yyTraverseTreeTD (yyt->MPC_Root.ConstList);
yyt = yyt->MPC_Root.ReconList; break;
case kMPC_Source:
yyTraverseTreeTD (yyt->MPC_Source.Prev);
yyt = yyt->MPC_Source.Next; break;
case kMPC_Messages:
yyTraverseTreeTD (yyt->MPC_Messages.Prev);
yyTraverseTreeTD (yyt->MPC_Messages.Tree);
yyt = yyt->MPC_Messages.Next; break;
case kMPC_ErrorMessage:
yyTraverseTreeTD (yyt->MPC_ErrorMessage.Prev);
yyTraverseTreeTD (yyt->MPC_ErrorMessage.Tree);
yyt = yyt->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI:
yyTraverseTreeTD (yyt->MPC_ErrorMessageI.Prev);
yyTraverseTreeTD (yyt->MPC_ErrorMessageI.Tree);
yyt = yyt->MPC_ErrorMessageI.Next; break;
case kMPC_Message:
yyTraverseTreeTD (yyt->MPC_Message.Prev);
yyTraverseTreeTD (yyt->MPC_Message.Tree);
yyt = yyt->MPC_Message.Next; break;
case kMPC_MessageI:
yyTraverseTreeTD (yyt->MPC_MessageI.Prev);
yyTraverseTreeTD (yyt->MPC_MessageI.Tree);
yyt = yyt->MPC_MessageI.Next; break;
case kMPC_FreeNode:
yyt = yyt->MPC_FreeNode.Parent; break;
case kMPC_Decls:
yyTraverseTreeTD (yyt->MPC_Decls.Prev);
yyt = yyt->MPC_Decls.Next; break;
case kMPC_UncompString:
yyTraverseTreeTD (yyt->MPC_UncompString.Prev);
yyt = yyt->MPC_UncompString.Next; break;
case kMPC_Type:
yyTraverseTreeTD (yyt->MPC_Type.Prev);
yyTraverseTreeTD (yyt->MPC_Type.EquivType);
yyt = yyt->MPC_Type.Next; break;
case kMPC_BasicType:
yyTraverseTreeTD (yyt->MPC_BasicType.Prev);
yyTraverseTreeTD (yyt->MPC_BasicType.EquivType);
yyt = yyt->MPC_BasicType.Next; break;
case kMPC_EnumType:
yyTraverseTreeTD (yyt->MPC_EnumType.Prev);
yyTraverseTreeTD (yyt->MPC_EnumType.EquivType);
yyTraverseTreeTD (yyt->MPC_EnumType.EnumList);
yyt = yyt->MPC_EnumType.Next; break;
case kMPC_Typedef:
yyTraverseTreeTD (yyt->MPC_Typedef.Prev);
yyTraverseTreeTD (yyt->MPC_Typedef.EquivType);
yyTraverseTreeTD (yyt->MPC_Typedef.Type);
yyt = yyt->MPC_Typedef.Next; break;
case kMPC_DerivedType:
yyTraverseTreeTD (yyt->MPC_DerivedType.Prev);
yyTraverseTreeTD (yyt->MPC_DerivedType.EquivType);
yyt = yyt->MPC_DerivedType.Next; break;
case kMPC_ArrayType:
yyTraverseTreeTD (yyt->MPC_ArrayType.Prev);
yyTraverseTreeTD (yyt->MPC_ArrayType.EquivType);
yyTraverseTreeTD (yyt->MPC_ArrayType.ElementType);
yyTraverseTreeTD (yyt->MPC_ArrayType.ArraySize);
yyTraverseTreeTD (yyt->MPC_ArrayType.DynStep);
yyt = yyt->MPC_ArrayType.Next; break;
case kMPC_VectorType:
yyTraverseTreeTD (yyt->MPC_VectorType.Prev);
yyTraverseTreeTD (yyt->MPC_VectorType.EquivType);
yyTraverseTreeTD (yyt->MPC_VectorType.ElementType);
yyTraverseTreeTD (yyt->MPC_VectorType.VectorSize);
yyt = yyt->MPC_VectorType.Next; break;
case kMPC_PointerType:
yyTraverseTreeTD (yyt->MPC_PointerType.Prev);
yyTraverseTreeTD (yyt->MPC_PointerType.EquivType);
yyTraverseTreeTD (yyt->MPC_PointerType.ElementType);
yyTraverseTreeTD (yyt->MPC_PointerType.DynStep);
yyTraverseTreeTD (yyt->MPC_PointerType.GeneratedFrom);
yyt = yyt->MPC_PointerType.Next; break;
case kMPC_StructType:
yyTraverseTreeTD (yyt->MPC_StructType.Prev);
yyTraverseTreeTD (yyt->MPC_StructType.EquivType);
yyTraverseTreeTD (yyt->MPC_StructType.MemberDecls);
yyt = yyt->MPC_StructType.Next; break;
case kMPC_UnionType:
yyTraverseTreeTD (yyt->MPC_UnionType.Prev);
yyTraverseTreeTD (yyt->MPC_UnionType.EquivType);
yyTraverseTreeTD (yyt->MPC_UnionType.MemberDecls);
yyt = yyt->MPC_UnionType.Next; break;
case kMPC_FunctionType:
yyTraverseTreeTD (yyt->MPC_FunctionType.Prev);
yyTraverseTreeTD (yyt->MPC_FunctionType.EquivType);
yyTraverseTreeTD (yyt->MPC_FunctionType.ResultType);
yyTraverseTreeTD (yyt->MPC_FunctionType.NetParamType);
yyTraverseTreeTD (yyt->MPC_FunctionType.NetParam);
yyTraverseTreeTD (yyt->MPC_FunctionType.NetworkParamList);
yyTraverseTreeTD (yyt->MPC_FunctionType.ParamList);
yyt = yyt->MPC_FunctionType.Next; break;
case kMPC_VarDecl:
yyTraverseTreeTD (yyt->MPC_VarDecl.Prev);
yyTraverseTreeTD (yyt->MPC_VarDecl.DeclSpecifier);
yyTraverseTreeTD (yyt->MPC_VarDecl.Var);
yyt = yyt->MPC_VarDecl.Next; break;
case kMPC_Function:
yyTraverseTreeTD (yyt->MPC_Function.Prev);
yyTraverseTreeTD (yyt->MPC_Function.Distribution);
yyTraverseTreeTD (yyt->MPC_Function.Name);
yyTraverseTreeTD (yyt->MPC_Function.Type);
yyTraverseTreeTD (yyt->MPC_Function.ParamList);
yyTraverseTreeTD (yyt->MPC_Function.Stats);
yyTraverseTreeTD (yyt->MPC_Function.LabelList);
yyt = yyt->MPC_Function.Next; break;
case kMPC_Ellipsis:
yyTraverseTreeTD (yyt->MPC_Ellipsis.Prev);
yyt = yyt->MPC_Ellipsis.Next; break;
case kMPC_NetDecl:
yyTraverseTreeTD (yyt->MPC_NetDecl.Prev);
yyTraverseTreeTD (yyt->MPC_NetDecl.NetTypeSpecifier);
yyTraverseTreeTD (yyt->MPC_NetDecl.Net);
yyt = yyt->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl:
yyTraverseTreeTD (yyt->MPC_SubnetDecl.Prev);
yyTraverseTreeTD (yyt->MPC_SubnetDecl.Subnet);
yyt = yyt->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl:
yyTraverseTreeTD (yyt->MPC_RelDecl.Prev);
yyTraverseTreeTD (yyt->MPC_RelDecl.Relation);
yyt = yyt->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl:
yyTraverseTreeTD (yyt->MPC_NetTypeDecl.Prev);
yyt = yyt->MPC_NetTypeDecl.Next; break;
case kMPC_NetType:
yyTraverseTreeTD (yyt->MPC_NetType.Prev);
yyTraverseTreeTD (yyt->MPC_NetType.ParamList);
yyTraverseTreeTD (yyt->MPC_NetType.CoordDecl);
yyTraverseTreeTD (yyt->MPC_NetType.NodeDecl);
yyTraverseTreeTD (yyt->MPC_NetType.LinkDecl);
yyTraverseTreeTD (yyt->MPC_NetType.StartDecl);
yyTraverseTreeTD (yyt->MPC_NetType.SchemeDecl);
yyTraverseTreeTD (yyt->MPC_NetType.TopoFunctions);
yyt = yyt->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier:
yyTraverseTreeTD (yyt->MPC_NetTypeSpecifier.Prev);
yyTraverseTreeTD (yyt->MPC_NetTypeSpecifier.NetType);
yyTraverseTreeTD (yyt->MPC_NetTypeSpecifier.ArgList);
yyt = yyt->MPC_NetTypeSpecifier.Next; break;
case kMPC_TopoFunctions:
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Node_Def);
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Link_Def);
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Main_Node_Def);
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Power_Def);
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Node_Coord_Def);
yyTraverseTreeTD (yyt->MPC_TopoFunctions.Node_Number_Def);
yyt = yyt->MPC_TopoFunctions.Mapping_Def; break;
case kMPC_EnumConst:
yyTraverseTreeTD (yyt->MPC_EnumConst.Prev);
yyt = yyt->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl:
yyTraverseTreeTD (yyt->MPC_SU_MemberDecl.Prev);
yyTraverseTreeTD (yyt->MPC_SU_MemberDecl.Member);
yyt = yyt->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member:
yyTraverseTreeTD (yyt->MPC_SU_Member.Prev);
yyTraverseTreeTD (yyt->MPC_SU_Member.Type);
yyTraverseTreeTD (yyt->MPC_SU_Member.BitFieldSize);
yyt = yyt->MPC_SU_Member.Next; break;
case kMPC_Var:
yyTraverseTreeTD (yyt->MPC_Var.Prev);
yyTraverseTreeTD (yyt->MPC_Var.Type);
yyTraverseTreeTD (yyt->MPC_Var.Distribution);
yyTraverseTreeTD (yyt->MPC_Var.Init);
yyt = yyt->MPC_Var.Next; break;
case kMPC_CoordDecl:
yyTraverseTreeTD (yyt->MPC_CoordDecl.Prev);
yyTraverseTreeTD (yyt->MPC_CoordDecl.Range);
yyt = yyt->MPC_CoordDecl.Next; break;
case kMPC_Node:
yyTraverseTreeTD (yyt->MPC_Node.Prev);
yyTraverseTreeTD (yyt->MPC_Node.Predicate);
yyTraverseTreeTD (yyt->MPC_Node.NodeQual);
yyt = yyt->MPC_Node.Next; break;
case kMPC_NodeQual:
yyt = yyt->MPC_NodeQual.CapacityExpr; break;
case kMPC_NodeTypeQual:
yyt = yyt->MPC_NodeTypeQual.CapacityExpr; break;
case kMPC_BenchQual:
yyt = yyt->MPC_BenchQual.CapacityExpr; break;
case kMPC_LinkDecl:
yyTraverseTreeTD (yyt->MPC_LinkDecl.FreeCoord);
yyt = yyt->MPC_LinkDecl.LinkDeclaringList; break;
case kMPC_LinkDeclaringList:
yyTraverseTreeTD (yyt->MPC_LinkDeclaringList.Prev);
yyTraverseTreeTD (yyt->MPC_LinkDeclaringList.Predicate);
yyTraverseTreeTD (yyt->MPC_LinkDeclaringList.LinkLengthSpecifier);
yyTraverseTreeTD (yyt->MPC_LinkDeclaringList.LinkDeclarator);
yyt = yyt->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator:
yyTraverseTreeTD (yyt->MPC_LinkDeclarator.Prev);
yyTraverseTreeTD (yyt->MPC_LinkDeclarator.LeftNode);
yyTraverseTreeTD (yyt->MPC_LinkDeclarator.RightNode);
yyt = yyt->MPC_LinkDeclarator.Next; break;
case kMPC_LinkLengthSpecifier:
yyt = yyt->MPC_LinkLengthSpecifier.LinkLengthExpr; break;
case kMPC_Scheme:
yyt = yyt->MPC_Scheme.Body; break;
case kMPC_NetList:
yyTraverseTreeTD (yyt->MPC_NetList.Prev);
yyTraverseTreeTD (yyt->MPC_NetList.Net);
yyt = yyt->MPC_NetList.Next; break;
case kMPC_NetOrSubnet:
yyTraverseTreeTD (yyt->MPC_NetOrSubnet.Distribution);
yyTraverseTreeTD (yyt->MPC_NetOrSubnet.Prev);
yyTraverseTreeTD (yyt->MPC_NetOrSubnet.NextUse);
yyTraverseTreeTD (yyt->MPC_NetOrSubnet.PrevUse);
yyTraverseTreeTD (yyt->MPC_NetOrSubnet.MyList);
yyt = yyt->MPC_NetOrSubnet.Next; break;
case kMPC_Net:
yyTraverseTreeTD (yyt->MPC_Net.Distribution);
yyTraverseTreeTD (yyt->MPC_Net.Prev);
yyTraverseTreeTD (yyt->MPC_Net.NextUse);
yyTraverseTreeTD (yyt->MPC_Net.PrevUse);
yyTraverseTreeTD (yyt->MPC_Net.MyList);
yyTraverseTreeTD (yyt->MPC_Net.NetType);
yyt = yyt->MPC_Net.Next; break;
case kMPC_Subnet:
yyTraverseTreeTD (yyt->MPC_Subnet.Distribution);
yyTraverseTreeTD (yyt->MPC_Subnet.Prev);
yyTraverseTreeTD (yyt->MPC_Subnet.NextUse);
yyTraverseTreeTD (yyt->MPC_Subnet.PrevUse);
yyTraverseTreeTD (yyt->MPC_Subnet.MyList);
yyTraverseTreeTD (yyt->MPC_Subnet.Predicate);
yyt = yyt->MPC_Subnet.Next; break;
case kMPC_Relation:
yyTraverseTreeTD (yyt->MPC_Relation.Prev);
yyTraverseTreeTD (yyt->MPC_Relation.LNet);
yyTraverseTreeTD (yyt->MPC_Relation.RNet);
yyt = yyt->MPC_Relation.Next; break;
case kMPC_Stats:
yyTraverseTreeTD (yyt->MPC_Stats.Prev);
yyt = yyt->MPC_Stats.Next; break;
case kMPC_Stat:
yyTraverseTreeTD (yyt->MPC_Stat.Prev);
yyTraverseTreeTD (yyt->MPC_Stat.ExecNet);
yyTraverseTreeTD (yyt->MPC_Stat.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Stat.RootNet);
yyTraverseTreeTD (yyt->MPC_Stat.PropNet);
yyt = yyt->MPC_Stat.Next; break;
case kMPC_ExprStat:
yyTraverseTreeTD (yyt->MPC_ExprStat.Prev);
yyTraverseTreeTD (yyt->MPC_ExprStat.ExecNet);
yyTraverseTreeTD (yyt->MPC_ExprStat.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_ExprStat.RootNet);
yyTraverseTreeTD (yyt->MPC_ExprStat.PropNet);
yyTraverseTreeTD (yyt->MPC_ExprStat.Expr);
yyt = yyt->MPC_ExprStat.Next; break;
case kMPC_If:
yyTraverseTreeTD (yyt->MPC_If.Prev);
yyTraverseTreeTD (yyt->MPC_If.ExecNet);
yyTraverseTreeTD (yyt->MPC_If.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_If.RootNet);
yyTraverseTreeTD (yyt->MPC_If.PropNet);
yyTraverseTreeTD (yyt->MPC_If.Expr);
yyTraverseTreeTD (yyt->MPC_If.Stats);
yyt = yyt->MPC_If.Next; break;
case kMPC_IfElse:
yyTraverseTreeTD (yyt->MPC_IfElse.Prev);
yyTraverseTreeTD (yyt->MPC_IfElse.ExecNet);
yyTraverseTreeTD (yyt->MPC_IfElse.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_IfElse.RootNet);
yyTraverseTreeTD (yyt->MPC_IfElse.PropNet);
yyTraverseTreeTD (yyt->MPC_IfElse.Expr);
yyTraverseTreeTD (yyt->MPC_IfElse.Then);
yyTraverseTreeTD (yyt->MPC_IfElse.Else);
yyt = yyt->MPC_IfElse.Next; break;
case kMPC_Switch:
yyTraverseTreeTD (yyt->MPC_Switch.Prev);
yyTraverseTreeTD (yyt->MPC_Switch.ExecNet);
yyTraverseTreeTD (yyt->MPC_Switch.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Switch.RootNet);
yyTraverseTreeTD (yyt->MPC_Switch.PropNet);
yyTraverseTreeTD (yyt->MPC_Switch.Expr);
yyTraverseTreeTD (yyt->MPC_Switch.Stats);
yyt = yyt->MPC_Switch.Next; break;
case kMPC_While:
yyTraverseTreeTD (yyt->MPC_While.Prev);
yyTraverseTreeTD (yyt->MPC_While.ExecNet);
yyTraverseTreeTD (yyt->MPC_While.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_While.RootNet);
yyTraverseTreeTD (yyt->MPC_While.PropNet);
yyTraverseTreeTD (yyt->MPC_While.Expr);
yyTraverseTreeTD (yyt->MPC_While.Stats);
yyt = yyt->MPC_While.Next; break;
case kMPC_DoWhile:
yyTraverseTreeTD (yyt->MPC_DoWhile.Prev);
yyTraverseTreeTD (yyt->MPC_DoWhile.ExecNet);
yyTraverseTreeTD (yyt->MPC_DoWhile.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_DoWhile.RootNet);
yyTraverseTreeTD (yyt->MPC_DoWhile.PropNet);
yyTraverseTreeTD (yyt->MPC_DoWhile.Stats);
yyTraverseTreeTD (yyt->MPC_DoWhile.Expr);
yyt = yyt->MPC_DoWhile.Next; break;
case kMPC_For:
yyTraverseTreeTD (yyt->MPC_For.Prev);
yyTraverseTreeTD (yyt->MPC_For.ExecNet);
yyTraverseTreeTD (yyt->MPC_For.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_For.RootNet);
yyTraverseTreeTD (yyt->MPC_For.PropNet);
yyTraverseTreeTD (yyt->MPC_For.Init);
yyTraverseTreeTD (yyt->MPC_For.Cond);
yyTraverseTreeTD (yyt->MPC_For.Reinit);
yyTraverseTreeTD (yyt->MPC_For.Stats);
yyt = yyt->MPC_For.Next; break;
case kMPC_Goto:
yyTraverseTreeTD (yyt->MPC_Goto.Prev);
yyTraverseTreeTD (yyt->MPC_Goto.ExecNet);
yyTraverseTreeTD (yyt->MPC_Goto.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Goto.RootNet);
yyTraverseTreeTD (yyt->MPC_Goto.PropNet);
yyTraverseTreeTD (yyt->MPC_Goto.LabelDef);
yyTraverseTreeTD (yyt->MPC_Goto.NextUse);
yyTraverseTreeTD (yyt->MPC_Goto.PrevUse);
yyt = yyt->MPC_Goto.Next; break;
case kMPC_Continue:
yyTraverseTreeTD (yyt->MPC_Continue.Prev);
yyTraverseTreeTD (yyt->MPC_Continue.ExecNet);
yyTraverseTreeTD (yyt->MPC_Continue.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Continue.RootNet);
yyTraverseTreeTD (yyt->MPC_Continue.PropNet);
yyt = yyt->MPC_Continue.Next; break;
case kMPC_Break:
yyTraverseTreeTD (yyt->MPC_Break.Prev);
yyTraverseTreeTD (yyt->MPC_Break.ExecNet);
yyTraverseTreeTD (yyt->MPC_Break.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Break.RootNet);
yyTraverseTreeTD (yyt->MPC_Break.PropNet);
yyt = yyt->MPC_Break.Next; break;
case kMPC_BreakFan:
yyTraverseTreeTD (yyt->MPC_BreakFan.Prev);
yyTraverseTreeTD (yyt->MPC_BreakFan.ExecNet);
yyTraverseTreeTD (yyt->MPC_BreakFan.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_BreakFan.RootNet);
yyTraverseTreeTD (yyt->MPC_BreakFan.PropNet);
yyt = yyt->MPC_BreakFan.Next; break;
case kMPC_Return:
yyTraverseTreeTD (yyt->MPC_Return.Prev);
yyTraverseTreeTD (yyt->MPC_Return.ExecNet);
yyTraverseTreeTD (yyt->MPC_Return.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Return.RootNet);
yyTraverseTreeTD (yyt->MPC_Return.PropNet);
yyTraverseTreeTD (yyt->MPC_Return.Expr);
yyt = yyt->MPC_Return.Next; break;
case kMPC_Compound:
yyTraverseTreeTD (yyt->MPC_Compound.Prev);
yyTraverseTreeTD (yyt->MPC_Compound.ExecNet);
yyTraverseTreeTD (yyt->MPC_Compound.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Compound.RootNet);
yyTraverseTreeTD (yyt->MPC_Compound.PropNet);
yyTraverseTreeTD (yyt->MPC_Compound.Decls);
yyTraverseTreeTD (yyt->MPC_Compound.Stats);
yyt = yyt->MPC_Compound.Next; break;
case kMPC_CompScheme:
yyTraverseTreeTD (yyt->MPC_CompScheme.Prev);
yyTraverseTreeTD (yyt->MPC_CompScheme.ExecNet);
yyTraverseTreeTD (yyt->MPC_CompScheme.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_CompScheme.RootNet);
yyTraverseTreeTD (yyt->MPC_CompScheme.PropNet);
yyTraverseTreeTD (yyt->MPC_CompScheme.Expr);
yyTraverseTreeTD (yyt->MPC_CompScheme.Node);
yyt = yyt->MPC_CompScheme.Next; break;
case kMPC_CommScheme:
yyTraverseTreeTD (yyt->MPC_CommScheme.Prev);
yyTraverseTreeTD (yyt->MPC_CommScheme.ExecNet);
yyTraverseTreeTD (yyt->MPC_CommScheme.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_CommScheme.RootNet);
yyTraverseTreeTD (yyt->MPC_CommScheme.PropNet);
yyTraverseTreeTD (yyt->MPC_CommScheme.Expr);
yyTraverseTreeTD (yyt->MPC_CommScheme.From);
yyTraverseTreeTD (yyt->MPC_CommScheme.To);
yyt = yyt->MPC_CommScheme.Next; break;
case kMPC_ParScheme:
yyTraverseTreeTD (yyt->MPC_ParScheme.Prev);
yyTraverseTreeTD (yyt->MPC_ParScheme.ExecNet);
yyTraverseTreeTD (yyt->MPC_ParScheme.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_ParScheme.RootNet);
yyTraverseTreeTD (yyt->MPC_ParScheme.PropNet);
yyTraverseTreeTD (yyt->MPC_ParScheme.Init);
yyTraverseTreeTD (yyt->MPC_ParScheme.Cond);
yyTraverseTreeTD (yyt->MPC_ParScheme.Reinit);
yyTraverseTreeTD (yyt->MPC_ParScheme.Stats);
yyt = yyt->MPC_ParScheme.Next; break;
case kMPC_Fan:
yyTraverseTreeTD (yyt->MPC_Fan.Prev);
yyTraverseTreeTD (yyt->MPC_Fan.ExecNet);
yyTraverseTreeTD (yyt->MPC_Fan.ActualExecNet);
yyTraverseTreeTD (yyt->MPC_Fan.RootNet);
yyTraverseTreeTD (yyt->MPC_Fan.PropNet);
yyTraverseTreeTD (yyt->MPC_Fan.Body);
yyt = yyt->MPC_Fan.Next; break;
case kMPC_Label:
yyTraverseTreeTD (yyt->MPC_Label.Prev);
yyTraverseTreeTD (yyt->MPC_Label.NextLabel);
yyTraverseTreeTD (yyt->MPC_Label.PrevLabel);
yyt = yyt->MPC_Label.Next; break;
case kMPC_IdentLabel:
yyTraverseTreeTD (yyt->MPC_IdentLabel.Prev);
yyTraverseTreeTD (yyt->MPC_IdentLabel.NextLabel);
yyTraverseTreeTD (yyt->MPC_IdentLabel.PrevLabel);
yyTraverseTreeTD (yyt->MPC_IdentLabel.NextUse);
yyt = yyt->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel:
yyTraverseTreeTD (yyt->MPC_CaseLabel.Prev);
yyTraverseTreeTD (yyt->MPC_CaseLabel.NextLabel);
yyTraverseTreeTD (yyt->MPC_CaseLabel.PrevLabel);
yyTraverseTreeTD (yyt->MPC_CaseLabel.Expr);
yyt = yyt->MPC_CaseLabel.Next; break;
case kMPC_Default:
yyTraverseTreeTD (yyt->MPC_Default.Prev);
yyTraverseTreeTD (yyt->MPC_Default.NextLabel);
yyTraverseTreeTD (yyt->MPC_Default.PrevLabel);
yyt = yyt->MPC_Default.Next; break;
case kMPC_Expr:
yyTraverseTreeTD (yyt->MPC_Expr.Type);
yyTraverseTreeTD (yyt->MPC_Expr.EvalNet);
yyTraverseTreeTD (yyt->MPC_Expr.StoreNet);
yyt = yyt->MPC_Expr.ActualEvalNet; break;
case kMPC_Const:
yyTraverseTreeTD (yyt->MPC_Const.Type);
yyTraverseTreeTD (yyt->MPC_Const.EvalNet);
yyTraverseTreeTD (yyt->MPC_Const.StoreNet);
yyt = yyt->MPC_Const.ActualEvalNet; break;
case kMPC_IntConst:
yyTraverseTreeTD (yyt->MPC_IntConst.Type);
yyTraverseTreeTD (yyt->MPC_IntConst.EvalNet);
yyTraverseTreeTD (yyt->MPC_IntConst.StoreNet);
yyt = yyt->MPC_IntConst.ActualEvalNet; break;
case kMPC_UIntConst:
yyTraverseTreeTD (yyt->MPC_UIntConst.Type);
yyTraverseTreeTD (yyt->MPC_UIntConst.EvalNet);
yyTraverseTreeTD (yyt->MPC_UIntConst.StoreNet);
yyt = yyt->MPC_UIntConst.ActualEvalNet; break;
case kMPC_FloatConst:
yyTraverseTreeTD (yyt->MPC_FloatConst.Type);
yyTraverseTreeTD (yyt->MPC_FloatConst.EvalNet);
yyTraverseTreeTD (yyt->MPC_FloatConst.StoreNet);
yyt = yyt->MPC_FloatConst.ActualEvalNet; break;
case kMPC_StringLiteral:
yyTraverseTreeTD (yyt->MPC_StringLiteral.Type);
yyTraverseTreeTD (yyt->MPC_StringLiteral.EvalNet);
yyTraverseTreeTD (yyt->MPC_StringLiteral.StoreNet);
yyTraverseTreeTD (yyt->MPC_StringLiteral.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_StringLiteral.Prev);
yyt = yyt->MPC_StringLiteral.Next; break;
case kMPC_Ident:
yyTraverseTreeTD (yyt->MPC_Ident.Type);
yyTraverseTreeTD (yyt->MPC_Ident.EvalNet);
yyTraverseTreeTD (yyt->MPC_Ident.StoreNet);
yyTraverseTreeTD (yyt->MPC_Ident.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_Ident.Store);
yyTraverseTreeTD (yyt->MPC_Ident.NextUse);
yyt = yyt->MPC_Ident.PrevUse; break;
case kMPC_CastExpr:
yyTraverseTreeTD (yyt->MPC_CastExpr.Type);
yyTraverseTreeTD (yyt->MPC_CastExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_CastExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_CastExpr.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_CastExpr.TypeName);
yyt = yyt->MPC_CastExpr.Operand; break;
case kMPC_NetCastExpr:
yyTraverseTreeTD (yyt->MPC_NetCastExpr.Type);
yyTraverseTreeTD (yyt->MPC_NetCastExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_NetCastExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_NetCastExpr.ActualEvalNet);
yyt = yyt->MPC_NetCastExpr.Operand; break;
case kMPC_CoordExpr:
yyTraverseTreeTD (yyt->MPC_CoordExpr.Type);
yyTraverseTreeTD (yyt->MPC_CoordExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_CoordExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_CoordExpr.ActualEvalNet);
yyt = yyt->MPC_CoordExpr.Operand; break;
case kMPC_SizeofExpr:
yyTraverseTreeTD (yyt->MPC_SizeofExpr.Type);
yyTraverseTreeTD (yyt->MPC_SizeofExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_SizeofExpr.StoreNet);
yyt = yyt->MPC_SizeofExpr.ActualEvalNet; break;
case kMPC_Size_Of_Value:
yyTraverseTreeTD (yyt->MPC_Size_Of_Value.Type);
yyTraverseTreeTD (yyt->MPC_Size_Of_Value.EvalNet);
yyTraverseTreeTD (yyt->MPC_Size_Of_Value.StoreNet);
yyTraverseTreeTD (yyt->MPC_Size_Of_Value.ActualEvalNet);
yyt = yyt->MPC_Size_Of_Value.Operand; break;
case kMPC_Size_Of_Type:
yyTraverseTreeTD (yyt->MPC_Size_Of_Type.Type);
yyTraverseTreeTD (yyt->MPC_Size_Of_Type.EvalNet);
yyTraverseTreeTD (yyt->MPC_Size_Of_Type.StoreNet);
yyTraverseTreeTD (yyt->MPC_Size_Of_Type.ActualEvalNet);
yyt = yyt->MPC_Size_Of_Type.Operand; break;
case kMPC_TimeofExpr:
yyTraverseTreeTD (yyt->MPC_TimeofExpr.Type);
yyTraverseTreeTD (yyt->MPC_TimeofExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_TimeofExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_TimeofExpr.ActualEvalNet);
yyt = yyt->MPC_TimeofExpr.NetDecl; break;
case kMPC_UnaryExpr:
yyTraverseTreeTD (yyt->MPC_UnaryExpr.Type);
yyTraverseTreeTD (yyt->MPC_UnaryExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_UnaryExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_UnaryExpr.ActualEvalNet);
yyt = yyt->MPC_UnaryExpr.Operand; break;
case kMPC_BinaryExpr:
yyTraverseTreeTD (yyt->MPC_BinaryExpr.Type);
yyTraverseTreeTD (yyt->MPC_BinaryExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_BinaryExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_BinaryExpr.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_BinaryExpr.Loperand);
yyt = yyt->MPC_BinaryExpr.Roperand; break;
case kMPC_TernaryExpr:
yyTraverseTreeTD (yyt->MPC_TernaryExpr.Type);
yyTraverseTreeTD (yyt->MPC_TernaryExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_TernaryExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_TernaryExpr.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_TernaryExpr.Foperand);
yyTraverseTreeTD (yyt->MPC_TernaryExpr.Soperand);
yyt = yyt->MPC_TernaryExpr.Toperand; break;
case kMPC_QuaternaryExpr:
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.Type);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.Operand1);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.Operand2);
yyTraverseTreeTD (yyt->MPC_QuaternaryExpr.Operand3);
yyt = yyt->MPC_QuaternaryExpr.Operand4; break;
case kMPC_CallExpr:
yyTraverseTreeTD (yyt->MPC_CallExpr.Type);
yyTraverseTreeTD (yyt->MPC_CallExpr.EvalNet);
yyTraverseTreeTD (yyt->MPC_CallExpr.StoreNet);
yyTraverseTreeTD (yyt->MPC_CallExpr.ActualEvalNet);
yyTraverseTreeTD (yyt->MPC_CallExpr.Function);
yyTraverseTreeTD (yyt->MPC_CallExpr.ArgList);
yyt = yyt->MPC_CallExpr.NetworkArgList; break;
case kMPC_Exprs:
yyTraverseTreeTD (yyt->MPC_Exprs.Prev);
yyTraverseTreeTD (yyt->MPC_Exprs.Expr);
yyt = yyt->MPC_Exprs.Next; break;
case kMPC_Initializer:
yyTraverseTreeTD (yyt->MPC_Initializer.Prev);
yyt = yyt->MPC_Initializer.Next; break;
case kMPC_SimpleInit:
yyTraverseTreeTD (yyt->MPC_SimpleInit.Prev);
yyTraverseTreeTD (yyt->MPC_SimpleInit.Expr);
yyt = yyt->MPC_SimpleInit.Next; break;
case kMPC_InitList:
yyTraverseTreeTD (yyt->MPC_InitList.Prev);
yyTraverseTreeTD (yyt->MPC_InitList.List);
yyt = yyt->MPC_InitList.Next; break;
  default: return;
  }
 }
}

void TraverseTreeTD
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, Tree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tTree yyt; Tree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseTreeTD (yyt);
}

static void yyTraverseTreeBU
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree || yyt->yyHead.yyMark == 0) return;
 yyt->yyHead.yyMark = 0;

 switch (yyt->Kind) {
case kMPC_Root:
yyTraverseTreeBU (yyt->MPC_Root.Decls);
yyTraverseTreeBU (yyt->MPC_Root.Source);
yyTraverseTreeBU (yyt->MPC_Root.Messages);
yyTraverseTreeBU (yyt->MPC_Root.Host);
yyTraverseTreeBU (yyt->MPC_Root.SingleNode);
yyTraverseTreeBU (yyt->MPC_Root.ComputingSpace);
yyTraverseTreeBU (yyt->MPC_Root.Const);
yyTraverseTreeBU (yyt->MPC_Root.Recon);
yyTraverseTreeBU (yyt->MPC_Root.HostList);
yyTraverseTreeBU (yyt->MPC_Root.SingleNodeList);
yyTraverseTreeBU (yyt->MPC_Root.ComputingSpaceList);
yyTraverseTreeBU (yyt->MPC_Root.ConstList);
yyTraverseTreeBU (yyt->MPC_Root.ReconList); break;
case kMPC_Source:
yyTraverseTreeBU (yyt->MPC_Source.Prev);
yyTraverseTreeBU (yyt->MPC_Source.Next); break;
case kMPC_Messages:
yyTraverseTreeBU (yyt->MPC_Messages.Prev);
yyTraverseTreeBU (yyt->MPC_Messages.Tree);
yyTraverseTreeBU (yyt->MPC_Messages.Next); break;
case kMPC_ErrorMessage:
yyTraverseTreeBU (yyt->MPC_ErrorMessage.Prev);
yyTraverseTreeBU (yyt->MPC_ErrorMessage.Tree);
yyTraverseTreeBU (yyt->MPC_ErrorMessage.Next); break;
case kMPC_ErrorMessageI:
yyTraverseTreeBU (yyt->MPC_ErrorMessageI.Prev);
yyTraverseTreeBU (yyt->MPC_ErrorMessageI.Tree);
yyTraverseTreeBU (yyt->MPC_ErrorMessageI.Next); break;
case kMPC_Message:
yyTraverseTreeBU (yyt->MPC_Message.Prev);
yyTraverseTreeBU (yyt->MPC_Message.Tree);
yyTraverseTreeBU (yyt->MPC_Message.Next); break;
case kMPC_MessageI:
yyTraverseTreeBU (yyt->MPC_MessageI.Prev);
yyTraverseTreeBU (yyt->MPC_MessageI.Tree);
yyTraverseTreeBU (yyt->MPC_MessageI.Next); break;
case kMPC_FreeNode:
yyTraverseTreeBU (yyt->MPC_FreeNode.Parent); break;
case kMPC_Decls:
yyTraverseTreeBU (yyt->MPC_Decls.Prev);
yyTraverseTreeBU (yyt->MPC_Decls.Next); break;
case kMPC_UncompString:
yyTraverseTreeBU (yyt->MPC_UncompString.Prev);
yyTraverseTreeBU (yyt->MPC_UncompString.Next); break;
case kMPC_Type:
yyTraverseTreeBU (yyt->MPC_Type.Prev);
yyTraverseTreeBU (yyt->MPC_Type.EquivType);
yyTraverseTreeBU (yyt->MPC_Type.Next); break;
case kMPC_BasicType:
yyTraverseTreeBU (yyt->MPC_BasicType.Prev);
yyTraverseTreeBU (yyt->MPC_BasicType.EquivType);
yyTraverseTreeBU (yyt->MPC_BasicType.Next); break;
case kMPC_EnumType:
yyTraverseTreeBU (yyt->MPC_EnumType.Prev);
yyTraverseTreeBU (yyt->MPC_EnumType.EquivType);
yyTraverseTreeBU (yyt->MPC_EnumType.EnumList);
yyTraverseTreeBU (yyt->MPC_EnumType.Next); break;
case kMPC_Typedef:
yyTraverseTreeBU (yyt->MPC_Typedef.Prev);
yyTraverseTreeBU (yyt->MPC_Typedef.EquivType);
yyTraverseTreeBU (yyt->MPC_Typedef.Type);
yyTraverseTreeBU (yyt->MPC_Typedef.Next); break;
case kMPC_DerivedType:
yyTraverseTreeBU (yyt->MPC_DerivedType.Prev);
yyTraverseTreeBU (yyt->MPC_DerivedType.EquivType);
yyTraverseTreeBU (yyt->MPC_DerivedType.Next); break;
case kMPC_ArrayType:
yyTraverseTreeBU (yyt->MPC_ArrayType.Prev);
yyTraverseTreeBU (yyt->MPC_ArrayType.EquivType);
yyTraverseTreeBU (yyt->MPC_ArrayType.ElementType);
yyTraverseTreeBU (yyt->MPC_ArrayType.ArraySize);
yyTraverseTreeBU (yyt->MPC_ArrayType.DynStep);
yyTraverseTreeBU (yyt->MPC_ArrayType.Next); break;
case kMPC_VectorType:
yyTraverseTreeBU (yyt->MPC_VectorType.Prev);
yyTraverseTreeBU (yyt->MPC_VectorType.EquivType);
yyTraverseTreeBU (yyt->MPC_VectorType.ElementType);
yyTraverseTreeBU (yyt->MPC_VectorType.VectorSize);
yyTraverseTreeBU (yyt->MPC_VectorType.Next); break;
case kMPC_PointerType:
yyTraverseTreeBU (yyt->MPC_PointerType.Prev);
yyTraverseTreeBU (yyt->MPC_PointerType.EquivType);
yyTraverseTreeBU (yyt->MPC_PointerType.ElementType);
yyTraverseTreeBU (yyt->MPC_PointerType.DynStep);
yyTraverseTreeBU (yyt->MPC_PointerType.GeneratedFrom);
yyTraverseTreeBU (yyt->MPC_PointerType.Next); break;
case kMPC_StructType:
yyTraverseTreeBU (yyt->MPC_StructType.Prev);
yyTraverseTreeBU (yyt->MPC_StructType.EquivType);
yyTraverseTreeBU (yyt->MPC_StructType.MemberDecls);
yyTraverseTreeBU (yyt->MPC_StructType.Next); break;
case kMPC_UnionType:
yyTraverseTreeBU (yyt->MPC_UnionType.Prev);
yyTraverseTreeBU (yyt->MPC_UnionType.EquivType);
yyTraverseTreeBU (yyt->MPC_UnionType.MemberDecls);
yyTraverseTreeBU (yyt->MPC_UnionType.Next); break;
case kMPC_FunctionType:
yyTraverseTreeBU (yyt->MPC_FunctionType.Prev);
yyTraverseTreeBU (yyt->MPC_FunctionType.EquivType);
yyTraverseTreeBU (yyt->MPC_FunctionType.ResultType);
yyTraverseTreeBU (yyt->MPC_FunctionType.NetParamType);
yyTraverseTreeBU (yyt->MPC_FunctionType.NetParam);
yyTraverseTreeBU (yyt->MPC_FunctionType.NetworkParamList);
yyTraverseTreeBU (yyt->MPC_FunctionType.ParamList);
yyTraverseTreeBU (yyt->MPC_FunctionType.Next); break;
case kMPC_VarDecl:
yyTraverseTreeBU (yyt->MPC_VarDecl.Prev);
yyTraverseTreeBU (yyt->MPC_VarDecl.DeclSpecifier);
yyTraverseTreeBU (yyt->MPC_VarDecl.Var);
yyTraverseTreeBU (yyt->MPC_VarDecl.Next); break;
case kMPC_Function:
yyTraverseTreeBU (yyt->MPC_Function.Prev);
yyTraverseTreeBU (yyt->MPC_Function.Distribution);
yyTraverseTreeBU (yyt->MPC_Function.Name);
yyTraverseTreeBU (yyt->MPC_Function.Type);
yyTraverseTreeBU (yyt->MPC_Function.ParamList);
yyTraverseTreeBU (yyt->MPC_Function.Stats);
yyTraverseTreeBU (yyt->MPC_Function.LabelList);
yyTraverseTreeBU (yyt->MPC_Function.Next); break;
case kMPC_Ellipsis:
yyTraverseTreeBU (yyt->MPC_Ellipsis.Prev);
yyTraverseTreeBU (yyt->MPC_Ellipsis.Next); break;
case kMPC_NetDecl:
yyTraverseTreeBU (yyt->MPC_NetDecl.Prev);
yyTraverseTreeBU (yyt->MPC_NetDecl.NetTypeSpecifier);
yyTraverseTreeBU (yyt->MPC_NetDecl.Net);
yyTraverseTreeBU (yyt->MPC_NetDecl.Next); break;
case kMPC_SubnetDecl:
yyTraverseTreeBU (yyt->MPC_SubnetDecl.Prev);
yyTraverseTreeBU (yyt->MPC_SubnetDecl.Subnet);
yyTraverseTreeBU (yyt->MPC_SubnetDecl.Next); break;
case kMPC_RelDecl:
yyTraverseTreeBU (yyt->MPC_RelDecl.Prev);
yyTraverseTreeBU (yyt->MPC_RelDecl.Relation);
yyTraverseTreeBU (yyt->MPC_RelDecl.Next); break;
case kMPC_NetTypeDecl:
yyTraverseTreeBU (yyt->MPC_NetTypeDecl.Prev);
yyTraverseTreeBU (yyt->MPC_NetTypeDecl.Next); break;
case kMPC_NetType:
yyTraverseTreeBU (yyt->MPC_NetType.Prev);
yyTraverseTreeBU (yyt->MPC_NetType.ParamList);
yyTraverseTreeBU (yyt->MPC_NetType.CoordDecl);
yyTraverseTreeBU (yyt->MPC_NetType.NodeDecl);
yyTraverseTreeBU (yyt->MPC_NetType.LinkDecl);
yyTraverseTreeBU (yyt->MPC_NetType.StartDecl);
yyTraverseTreeBU (yyt->MPC_NetType.SchemeDecl);
yyTraverseTreeBU (yyt->MPC_NetType.TopoFunctions);
yyTraverseTreeBU (yyt->MPC_NetType.Next); break;
case kMPC_NetTypeSpecifier:
yyTraverseTreeBU (yyt->MPC_NetTypeSpecifier.Prev);
yyTraverseTreeBU (yyt->MPC_NetTypeSpecifier.NetType);
yyTraverseTreeBU (yyt->MPC_NetTypeSpecifier.ArgList);
yyTraverseTreeBU (yyt->MPC_NetTypeSpecifier.Next); break;
case kMPC_TopoFunctions:
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Node_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Link_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Main_Node_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Power_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Node_Coord_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Node_Number_Def);
yyTraverseTreeBU (yyt->MPC_TopoFunctions.Mapping_Def); break;
case kMPC_EnumConst:
yyTraverseTreeBU (yyt->MPC_EnumConst.Prev);
yyTraverseTreeBU (yyt->MPC_EnumConst.Next); break;
case kMPC_SU_MemberDecl:
yyTraverseTreeBU (yyt->MPC_SU_MemberDecl.Prev);
yyTraverseTreeBU (yyt->MPC_SU_MemberDecl.Member);
yyTraverseTreeBU (yyt->MPC_SU_MemberDecl.Next); break;
case kMPC_SU_Member:
yyTraverseTreeBU (yyt->MPC_SU_Member.Prev);
yyTraverseTreeBU (yyt->MPC_SU_Member.Type);
yyTraverseTreeBU (yyt->MPC_SU_Member.BitFieldSize);
yyTraverseTreeBU (yyt->MPC_SU_Member.Next); break;
case kMPC_Var:
yyTraverseTreeBU (yyt->MPC_Var.Prev);
yyTraverseTreeBU (yyt->MPC_Var.Type);
yyTraverseTreeBU (yyt->MPC_Var.Distribution);
yyTraverseTreeBU (yyt->MPC_Var.Init);
yyTraverseTreeBU (yyt->MPC_Var.Next); break;
case kMPC_CoordDecl:
yyTraverseTreeBU (yyt->MPC_CoordDecl.Prev);
yyTraverseTreeBU (yyt->MPC_CoordDecl.Range);
yyTraverseTreeBU (yyt->MPC_CoordDecl.Next); break;
case kMPC_Node:
yyTraverseTreeBU (yyt->MPC_Node.Prev);
yyTraverseTreeBU (yyt->MPC_Node.Predicate);
yyTraverseTreeBU (yyt->MPC_Node.NodeQual);
yyTraverseTreeBU (yyt->MPC_Node.Next); break;
case kMPC_NodeQual:
yyTraverseTreeBU (yyt->MPC_NodeQual.CapacityExpr); break;
case kMPC_NodeTypeQual:
yyTraverseTreeBU (yyt->MPC_NodeTypeQual.CapacityExpr); break;
case kMPC_BenchQual:
yyTraverseTreeBU (yyt->MPC_BenchQual.CapacityExpr); break;
case kMPC_LinkDecl:
yyTraverseTreeBU (yyt->MPC_LinkDecl.FreeCoord);
yyTraverseTreeBU (yyt->MPC_LinkDecl.LinkDeclaringList); break;
case kMPC_LinkDeclaringList:
yyTraverseTreeBU (yyt->MPC_LinkDeclaringList.Prev);
yyTraverseTreeBU (yyt->MPC_LinkDeclaringList.Predicate);
yyTraverseTreeBU (yyt->MPC_LinkDeclaringList.LinkLengthSpecifier);
yyTraverseTreeBU (yyt->MPC_LinkDeclaringList.LinkDeclarator);
yyTraverseTreeBU (yyt->MPC_LinkDeclaringList.Next); break;
case kMPC_LinkDeclarator:
yyTraverseTreeBU (yyt->MPC_LinkDeclarator.Prev);
yyTraverseTreeBU (yyt->MPC_LinkDeclarator.LeftNode);
yyTraverseTreeBU (yyt->MPC_LinkDeclarator.RightNode);
yyTraverseTreeBU (yyt->MPC_LinkDeclarator.Next); break;
case kMPC_LinkLengthSpecifier:
yyTraverseTreeBU (yyt->MPC_LinkLengthSpecifier.LinkLengthExpr); break;
case kMPC_Scheme:
yyTraverseTreeBU (yyt->MPC_Scheme.Body); break;
case kMPC_NetList:
yyTraverseTreeBU (yyt->MPC_NetList.Prev);
yyTraverseTreeBU (yyt->MPC_NetList.Net);
yyTraverseTreeBU (yyt->MPC_NetList.Next); break;
case kMPC_NetOrSubnet:
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.Distribution);
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.Prev);
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.NextUse);
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.PrevUse);
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.MyList);
yyTraverseTreeBU (yyt->MPC_NetOrSubnet.Next); break;
case kMPC_Net:
yyTraverseTreeBU (yyt->MPC_Net.Distribution);
yyTraverseTreeBU (yyt->MPC_Net.Prev);
yyTraverseTreeBU (yyt->MPC_Net.NextUse);
yyTraverseTreeBU (yyt->MPC_Net.PrevUse);
yyTraverseTreeBU (yyt->MPC_Net.MyList);
yyTraverseTreeBU (yyt->MPC_Net.NetType);
yyTraverseTreeBU (yyt->MPC_Net.Next); break;
case kMPC_Subnet:
yyTraverseTreeBU (yyt->MPC_Subnet.Distribution);
yyTraverseTreeBU (yyt->MPC_Subnet.Prev);
yyTraverseTreeBU (yyt->MPC_Subnet.NextUse);
yyTraverseTreeBU (yyt->MPC_Subnet.PrevUse);
yyTraverseTreeBU (yyt->MPC_Subnet.MyList);
yyTraverseTreeBU (yyt->MPC_Subnet.Predicate);
yyTraverseTreeBU (yyt->MPC_Subnet.Next); break;
case kMPC_Relation:
yyTraverseTreeBU (yyt->MPC_Relation.Prev);
yyTraverseTreeBU (yyt->MPC_Relation.LNet);
yyTraverseTreeBU (yyt->MPC_Relation.RNet);
yyTraverseTreeBU (yyt->MPC_Relation.Next); break;
case kMPC_Stats:
yyTraverseTreeBU (yyt->MPC_Stats.Prev);
yyTraverseTreeBU (yyt->MPC_Stats.Next); break;
case kMPC_Stat:
yyTraverseTreeBU (yyt->MPC_Stat.Prev);
yyTraverseTreeBU (yyt->MPC_Stat.ExecNet);
yyTraverseTreeBU (yyt->MPC_Stat.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Stat.RootNet);
yyTraverseTreeBU (yyt->MPC_Stat.PropNet);
yyTraverseTreeBU (yyt->MPC_Stat.Next); break;
case kMPC_ExprStat:
yyTraverseTreeBU (yyt->MPC_ExprStat.Prev);
yyTraverseTreeBU (yyt->MPC_ExprStat.ExecNet);
yyTraverseTreeBU (yyt->MPC_ExprStat.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_ExprStat.RootNet);
yyTraverseTreeBU (yyt->MPC_ExprStat.PropNet);
yyTraverseTreeBU (yyt->MPC_ExprStat.Expr);
yyTraverseTreeBU (yyt->MPC_ExprStat.Next); break;
case kMPC_If:
yyTraverseTreeBU (yyt->MPC_If.Prev);
yyTraverseTreeBU (yyt->MPC_If.ExecNet);
yyTraverseTreeBU (yyt->MPC_If.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_If.RootNet);
yyTraverseTreeBU (yyt->MPC_If.PropNet);
yyTraverseTreeBU (yyt->MPC_If.Expr);
yyTraverseTreeBU (yyt->MPC_If.Stats);
yyTraverseTreeBU (yyt->MPC_If.Next); break;
case kMPC_IfElse:
yyTraverseTreeBU (yyt->MPC_IfElse.Prev);
yyTraverseTreeBU (yyt->MPC_IfElse.ExecNet);
yyTraverseTreeBU (yyt->MPC_IfElse.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_IfElse.RootNet);
yyTraverseTreeBU (yyt->MPC_IfElse.PropNet);
yyTraverseTreeBU (yyt->MPC_IfElse.Expr);
yyTraverseTreeBU (yyt->MPC_IfElse.Then);
yyTraverseTreeBU (yyt->MPC_IfElse.Else);
yyTraverseTreeBU (yyt->MPC_IfElse.Next); break;
case kMPC_Switch:
yyTraverseTreeBU (yyt->MPC_Switch.Prev);
yyTraverseTreeBU (yyt->MPC_Switch.ExecNet);
yyTraverseTreeBU (yyt->MPC_Switch.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Switch.RootNet);
yyTraverseTreeBU (yyt->MPC_Switch.PropNet);
yyTraverseTreeBU (yyt->MPC_Switch.Expr);
yyTraverseTreeBU (yyt->MPC_Switch.Stats);
yyTraverseTreeBU (yyt->MPC_Switch.Next); break;
case kMPC_While:
yyTraverseTreeBU (yyt->MPC_While.Prev);
yyTraverseTreeBU (yyt->MPC_While.ExecNet);
yyTraverseTreeBU (yyt->MPC_While.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_While.RootNet);
yyTraverseTreeBU (yyt->MPC_While.PropNet);
yyTraverseTreeBU (yyt->MPC_While.Expr);
yyTraverseTreeBU (yyt->MPC_While.Stats);
yyTraverseTreeBU (yyt->MPC_While.Next); break;
case kMPC_DoWhile:
yyTraverseTreeBU (yyt->MPC_DoWhile.Prev);
yyTraverseTreeBU (yyt->MPC_DoWhile.ExecNet);
yyTraverseTreeBU (yyt->MPC_DoWhile.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_DoWhile.RootNet);
yyTraverseTreeBU (yyt->MPC_DoWhile.PropNet);
yyTraverseTreeBU (yyt->MPC_DoWhile.Stats);
yyTraverseTreeBU (yyt->MPC_DoWhile.Expr);
yyTraverseTreeBU (yyt->MPC_DoWhile.Next); break;
case kMPC_For:
yyTraverseTreeBU (yyt->MPC_For.Prev);
yyTraverseTreeBU (yyt->MPC_For.ExecNet);
yyTraverseTreeBU (yyt->MPC_For.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_For.RootNet);
yyTraverseTreeBU (yyt->MPC_For.PropNet);
yyTraverseTreeBU (yyt->MPC_For.Init);
yyTraverseTreeBU (yyt->MPC_For.Cond);
yyTraverseTreeBU (yyt->MPC_For.Reinit);
yyTraverseTreeBU (yyt->MPC_For.Stats);
yyTraverseTreeBU (yyt->MPC_For.Next); break;
case kMPC_Goto:
yyTraverseTreeBU (yyt->MPC_Goto.Prev);
yyTraverseTreeBU (yyt->MPC_Goto.ExecNet);
yyTraverseTreeBU (yyt->MPC_Goto.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Goto.RootNet);
yyTraverseTreeBU (yyt->MPC_Goto.PropNet);
yyTraverseTreeBU (yyt->MPC_Goto.LabelDef);
yyTraverseTreeBU (yyt->MPC_Goto.NextUse);
yyTraverseTreeBU (yyt->MPC_Goto.PrevUse);
yyTraverseTreeBU (yyt->MPC_Goto.Next); break;
case kMPC_Continue:
yyTraverseTreeBU (yyt->MPC_Continue.Prev);
yyTraverseTreeBU (yyt->MPC_Continue.ExecNet);
yyTraverseTreeBU (yyt->MPC_Continue.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Continue.RootNet);
yyTraverseTreeBU (yyt->MPC_Continue.PropNet);
yyTraverseTreeBU (yyt->MPC_Continue.Next); break;
case kMPC_Break:
yyTraverseTreeBU (yyt->MPC_Break.Prev);
yyTraverseTreeBU (yyt->MPC_Break.ExecNet);
yyTraverseTreeBU (yyt->MPC_Break.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Break.RootNet);
yyTraverseTreeBU (yyt->MPC_Break.PropNet);
yyTraverseTreeBU (yyt->MPC_Break.Next); break;
case kMPC_BreakFan:
yyTraverseTreeBU (yyt->MPC_BreakFan.Prev);
yyTraverseTreeBU (yyt->MPC_BreakFan.ExecNet);
yyTraverseTreeBU (yyt->MPC_BreakFan.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_BreakFan.RootNet);
yyTraverseTreeBU (yyt->MPC_BreakFan.PropNet);
yyTraverseTreeBU (yyt->MPC_BreakFan.Next); break;
case kMPC_Return:
yyTraverseTreeBU (yyt->MPC_Return.Prev);
yyTraverseTreeBU (yyt->MPC_Return.ExecNet);
yyTraverseTreeBU (yyt->MPC_Return.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Return.RootNet);
yyTraverseTreeBU (yyt->MPC_Return.PropNet);
yyTraverseTreeBU (yyt->MPC_Return.Expr);
yyTraverseTreeBU (yyt->MPC_Return.Next); break;
case kMPC_Compound:
yyTraverseTreeBU (yyt->MPC_Compound.Prev);
yyTraverseTreeBU (yyt->MPC_Compound.ExecNet);
yyTraverseTreeBU (yyt->MPC_Compound.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Compound.RootNet);
yyTraverseTreeBU (yyt->MPC_Compound.PropNet);
yyTraverseTreeBU (yyt->MPC_Compound.Decls);
yyTraverseTreeBU (yyt->MPC_Compound.Stats);
yyTraverseTreeBU (yyt->MPC_Compound.Next); break;
case kMPC_CompScheme:
yyTraverseTreeBU (yyt->MPC_CompScheme.Prev);
yyTraverseTreeBU (yyt->MPC_CompScheme.ExecNet);
yyTraverseTreeBU (yyt->MPC_CompScheme.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_CompScheme.RootNet);
yyTraverseTreeBU (yyt->MPC_CompScheme.PropNet);
yyTraverseTreeBU (yyt->MPC_CompScheme.Expr);
yyTraverseTreeBU (yyt->MPC_CompScheme.Node);
yyTraverseTreeBU (yyt->MPC_CompScheme.Next); break;
case kMPC_CommScheme:
yyTraverseTreeBU (yyt->MPC_CommScheme.Prev);
yyTraverseTreeBU (yyt->MPC_CommScheme.ExecNet);
yyTraverseTreeBU (yyt->MPC_CommScheme.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_CommScheme.RootNet);
yyTraverseTreeBU (yyt->MPC_CommScheme.PropNet);
yyTraverseTreeBU (yyt->MPC_CommScheme.Expr);
yyTraverseTreeBU (yyt->MPC_CommScheme.From);
yyTraverseTreeBU (yyt->MPC_CommScheme.To);
yyTraverseTreeBU (yyt->MPC_CommScheme.Next); break;
case kMPC_ParScheme:
yyTraverseTreeBU (yyt->MPC_ParScheme.Prev);
yyTraverseTreeBU (yyt->MPC_ParScheme.ExecNet);
yyTraverseTreeBU (yyt->MPC_ParScheme.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_ParScheme.RootNet);
yyTraverseTreeBU (yyt->MPC_ParScheme.PropNet);
yyTraverseTreeBU (yyt->MPC_ParScheme.Init);
yyTraverseTreeBU (yyt->MPC_ParScheme.Cond);
yyTraverseTreeBU (yyt->MPC_ParScheme.Reinit);
yyTraverseTreeBU (yyt->MPC_ParScheme.Stats);
yyTraverseTreeBU (yyt->MPC_ParScheme.Next); break;
case kMPC_Fan:
yyTraverseTreeBU (yyt->MPC_Fan.Prev);
yyTraverseTreeBU (yyt->MPC_Fan.ExecNet);
yyTraverseTreeBU (yyt->MPC_Fan.ActualExecNet);
yyTraverseTreeBU (yyt->MPC_Fan.RootNet);
yyTraverseTreeBU (yyt->MPC_Fan.PropNet);
yyTraverseTreeBU (yyt->MPC_Fan.Body);
yyTraverseTreeBU (yyt->MPC_Fan.Next); break;
case kMPC_Label:
yyTraverseTreeBU (yyt->MPC_Label.Prev);
yyTraverseTreeBU (yyt->MPC_Label.NextLabel);
yyTraverseTreeBU (yyt->MPC_Label.PrevLabel);
yyTraverseTreeBU (yyt->MPC_Label.Next); break;
case kMPC_IdentLabel:
yyTraverseTreeBU (yyt->MPC_IdentLabel.Prev);
yyTraverseTreeBU (yyt->MPC_IdentLabel.NextLabel);
yyTraverseTreeBU (yyt->MPC_IdentLabel.PrevLabel);
yyTraverseTreeBU (yyt->MPC_IdentLabel.NextUse);
yyTraverseTreeBU (yyt->MPC_IdentLabel.Next); break;
case kMPC_CaseLabel:
yyTraverseTreeBU (yyt->MPC_CaseLabel.Prev);
yyTraverseTreeBU (yyt->MPC_CaseLabel.NextLabel);
yyTraverseTreeBU (yyt->MPC_CaseLabel.PrevLabel);
yyTraverseTreeBU (yyt->MPC_CaseLabel.Expr);
yyTraverseTreeBU (yyt->MPC_CaseLabel.Next); break;
case kMPC_Default:
yyTraverseTreeBU (yyt->MPC_Default.Prev);
yyTraverseTreeBU (yyt->MPC_Default.NextLabel);
yyTraverseTreeBU (yyt->MPC_Default.PrevLabel);
yyTraverseTreeBU (yyt->MPC_Default.Next); break;
case kMPC_Expr:
yyTraverseTreeBU (yyt->MPC_Expr.Type);
yyTraverseTreeBU (yyt->MPC_Expr.EvalNet);
yyTraverseTreeBU (yyt->MPC_Expr.StoreNet);
yyTraverseTreeBU (yyt->MPC_Expr.ActualEvalNet); break;
case kMPC_Const:
yyTraverseTreeBU (yyt->MPC_Const.Type);
yyTraverseTreeBU (yyt->MPC_Const.EvalNet);
yyTraverseTreeBU (yyt->MPC_Const.StoreNet);
yyTraverseTreeBU (yyt->MPC_Const.ActualEvalNet); break;
case kMPC_IntConst:
yyTraverseTreeBU (yyt->MPC_IntConst.Type);
yyTraverseTreeBU (yyt->MPC_IntConst.EvalNet);
yyTraverseTreeBU (yyt->MPC_IntConst.StoreNet);
yyTraverseTreeBU (yyt->MPC_IntConst.ActualEvalNet); break;
case kMPC_UIntConst:
yyTraverseTreeBU (yyt->MPC_UIntConst.Type);
yyTraverseTreeBU (yyt->MPC_UIntConst.EvalNet);
yyTraverseTreeBU (yyt->MPC_UIntConst.StoreNet);
yyTraverseTreeBU (yyt->MPC_UIntConst.ActualEvalNet); break;
case kMPC_FloatConst:
yyTraverseTreeBU (yyt->MPC_FloatConst.Type);
yyTraverseTreeBU (yyt->MPC_FloatConst.EvalNet);
yyTraverseTreeBU (yyt->MPC_FloatConst.StoreNet);
yyTraverseTreeBU (yyt->MPC_FloatConst.ActualEvalNet); break;
case kMPC_StringLiteral:
yyTraverseTreeBU (yyt->MPC_StringLiteral.Type);
yyTraverseTreeBU (yyt->MPC_StringLiteral.EvalNet);
yyTraverseTreeBU (yyt->MPC_StringLiteral.StoreNet);
yyTraverseTreeBU (yyt->MPC_StringLiteral.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_StringLiteral.Prev);
yyTraverseTreeBU (yyt->MPC_StringLiteral.Next); break;
case kMPC_Ident:
yyTraverseTreeBU (yyt->MPC_Ident.Type);
yyTraverseTreeBU (yyt->MPC_Ident.EvalNet);
yyTraverseTreeBU (yyt->MPC_Ident.StoreNet);
yyTraverseTreeBU (yyt->MPC_Ident.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_Ident.Store);
yyTraverseTreeBU (yyt->MPC_Ident.NextUse);
yyTraverseTreeBU (yyt->MPC_Ident.PrevUse); break;
case kMPC_CastExpr:
yyTraverseTreeBU (yyt->MPC_CastExpr.Type);
yyTraverseTreeBU (yyt->MPC_CastExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_CastExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_CastExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_CastExpr.TypeName);
yyTraverseTreeBU (yyt->MPC_CastExpr.Operand); break;
case kMPC_NetCastExpr:
yyTraverseTreeBU (yyt->MPC_NetCastExpr.Type);
yyTraverseTreeBU (yyt->MPC_NetCastExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_NetCastExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_NetCastExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_NetCastExpr.Operand); break;
case kMPC_CoordExpr:
yyTraverseTreeBU (yyt->MPC_CoordExpr.Type);
yyTraverseTreeBU (yyt->MPC_CoordExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_CoordExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_CoordExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_CoordExpr.Operand); break;
case kMPC_SizeofExpr:
yyTraverseTreeBU (yyt->MPC_SizeofExpr.Type);
yyTraverseTreeBU (yyt->MPC_SizeofExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_SizeofExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_SizeofExpr.ActualEvalNet); break;
case kMPC_Size_Of_Value:
yyTraverseTreeBU (yyt->MPC_Size_Of_Value.Type);
yyTraverseTreeBU (yyt->MPC_Size_Of_Value.EvalNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Value.StoreNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Value.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Value.Operand); break;
case kMPC_Size_Of_Type:
yyTraverseTreeBU (yyt->MPC_Size_Of_Type.Type);
yyTraverseTreeBU (yyt->MPC_Size_Of_Type.EvalNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Type.StoreNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Type.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_Size_Of_Type.Operand); break;
case kMPC_TimeofExpr:
yyTraverseTreeBU (yyt->MPC_TimeofExpr.Type);
yyTraverseTreeBU (yyt->MPC_TimeofExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_TimeofExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_TimeofExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_TimeofExpr.NetDecl); break;
case kMPC_UnaryExpr:
yyTraverseTreeBU (yyt->MPC_UnaryExpr.Type);
yyTraverseTreeBU (yyt->MPC_UnaryExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_UnaryExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_UnaryExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_UnaryExpr.Operand); break;
case kMPC_BinaryExpr:
yyTraverseTreeBU (yyt->MPC_BinaryExpr.Type);
yyTraverseTreeBU (yyt->MPC_BinaryExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_BinaryExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_BinaryExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_BinaryExpr.Loperand);
yyTraverseTreeBU (yyt->MPC_BinaryExpr.Roperand); break;
case kMPC_TernaryExpr:
yyTraverseTreeBU (yyt->MPC_TernaryExpr.Type);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.Foperand);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.Soperand);
yyTraverseTreeBU (yyt->MPC_TernaryExpr.Toperand); break;
case kMPC_QuaternaryExpr:
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.Type);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.Operand1);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.Operand2);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.Operand3);
yyTraverseTreeBU (yyt->MPC_QuaternaryExpr.Operand4); break;
case kMPC_CallExpr:
yyTraverseTreeBU (yyt->MPC_CallExpr.Type);
yyTraverseTreeBU (yyt->MPC_CallExpr.EvalNet);
yyTraverseTreeBU (yyt->MPC_CallExpr.StoreNet);
yyTraverseTreeBU (yyt->MPC_CallExpr.ActualEvalNet);
yyTraverseTreeBU (yyt->MPC_CallExpr.Function);
yyTraverseTreeBU (yyt->MPC_CallExpr.ArgList);
yyTraverseTreeBU (yyt->MPC_CallExpr.NetworkArgList); break;
case kMPC_Exprs:
yyTraverseTreeBU (yyt->MPC_Exprs.Prev);
yyTraverseTreeBU (yyt->MPC_Exprs.Expr);
yyTraverseTreeBU (yyt->MPC_Exprs.Next); break;
case kMPC_Initializer:
yyTraverseTreeBU (yyt->MPC_Initializer.Prev);
yyTraverseTreeBU (yyt->MPC_Initializer.Next); break;
case kMPC_SimpleInit:
yyTraverseTreeBU (yyt->MPC_SimpleInit.Prev);
yyTraverseTreeBU (yyt->MPC_SimpleInit.Expr);
yyTraverseTreeBU (yyt->MPC_SimpleInit.Next); break;
case kMPC_InitList:
yyTraverseTreeBU (yyt->MPC_InitList.Prev);
yyTraverseTreeBU (yyt->MPC_InitList.List);
yyTraverseTreeBU (yyt->MPC_InitList.Next); break;
 default: ;
 }
 yyProc (yyt);
}

void TraverseTreeBU
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, Tree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tTree yyt; Tree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseTreeBU (yyt);
}

tTree ReverseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register tTree yyNew, yyNext, yyTail;
 yyNew = yyOld;
 yyTail = yyOld;
 for (;;) {
  switch (yyOld->Kind) {
case kMPC_Source: yyNext = yyOld->MPC_Source.Next; yyOld->MPC_Source.Next = yyNew; break;
case kMPC_Messages: yyNext = yyOld->MPC_Messages.Next; yyOld->MPC_Messages.Next = yyNew; break;
case kMPC_ErrorMessage: yyNext = yyOld->MPC_ErrorMessage.Next; yyOld->MPC_ErrorMessage.Next = yyNew; break;
case kMPC_ErrorMessageI: yyNext = yyOld->MPC_ErrorMessageI.Next; yyOld->MPC_ErrorMessageI.Next = yyNew; break;
case kMPC_Message: yyNext = yyOld->MPC_Message.Next; yyOld->MPC_Message.Next = yyNew; break;
case kMPC_MessageI: yyNext = yyOld->MPC_MessageI.Next; yyOld->MPC_MessageI.Next = yyNew; break;
case kMPC_Decls: yyNext = yyOld->MPC_Decls.Next; yyOld->MPC_Decls.Next = yyNew; break;
case kMPC_UncompString: yyNext = yyOld->MPC_UncompString.Next; yyOld->MPC_UncompString.Next = yyNew; break;
case kMPC_Type: yyNext = yyOld->MPC_Type.Next; yyOld->MPC_Type.Next = yyNew; break;
case kMPC_BasicType: yyNext = yyOld->MPC_BasicType.Next; yyOld->MPC_BasicType.Next = yyNew; break;
case kMPC_EnumType: yyNext = yyOld->MPC_EnumType.Next; yyOld->MPC_EnumType.Next = yyNew; break;
case kMPC_Typedef: yyNext = yyOld->MPC_Typedef.Next; yyOld->MPC_Typedef.Next = yyNew; break;
case kMPC_DerivedType: yyNext = yyOld->MPC_DerivedType.Next; yyOld->MPC_DerivedType.Next = yyNew; break;
case kMPC_ArrayType: yyNext = yyOld->MPC_ArrayType.Next; yyOld->MPC_ArrayType.Next = yyNew; break;
case kMPC_VectorType: yyNext = yyOld->MPC_VectorType.Next; yyOld->MPC_VectorType.Next = yyNew; break;
case kMPC_PointerType: yyNext = yyOld->MPC_PointerType.Next; yyOld->MPC_PointerType.Next = yyNew; break;
case kMPC_StructType: yyNext = yyOld->MPC_StructType.Next; yyOld->MPC_StructType.Next = yyNew; break;
case kMPC_UnionType: yyNext = yyOld->MPC_UnionType.Next; yyOld->MPC_UnionType.Next = yyNew; break;
case kMPC_FunctionType: yyNext = yyOld->MPC_FunctionType.Next; yyOld->MPC_FunctionType.Next = yyNew; break;
case kMPC_VarDecl: yyNext = yyOld->MPC_VarDecl.Next; yyOld->MPC_VarDecl.Next = yyNew; break;
case kMPC_Function: yyNext = yyOld->MPC_Function.Next; yyOld->MPC_Function.Next = yyNew; break;
case kMPC_Ellipsis: yyNext = yyOld->MPC_Ellipsis.Next; yyOld->MPC_Ellipsis.Next = yyNew; break;
case kMPC_NetDecl: yyNext = yyOld->MPC_NetDecl.Next; yyOld->MPC_NetDecl.Next = yyNew; break;
case kMPC_SubnetDecl: yyNext = yyOld->MPC_SubnetDecl.Next; yyOld->MPC_SubnetDecl.Next = yyNew; break;
case kMPC_RelDecl: yyNext = yyOld->MPC_RelDecl.Next; yyOld->MPC_RelDecl.Next = yyNew; break;
case kMPC_NetTypeDecl: yyNext = yyOld->MPC_NetTypeDecl.Next; yyOld->MPC_NetTypeDecl.Next = yyNew; break;
case kMPC_NetType: yyNext = yyOld->MPC_NetType.Next; yyOld->MPC_NetType.Next = yyNew; break;
case kMPC_NetTypeSpecifier: yyNext = yyOld->MPC_NetTypeSpecifier.Next; yyOld->MPC_NetTypeSpecifier.Next = yyNew; break;
case kMPC_EnumConst: yyNext = yyOld->MPC_EnumConst.Next; yyOld->MPC_EnumConst.Next = yyNew; break;
case kMPC_SU_MemberDecl: yyNext = yyOld->MPC_SU_MemberDecl.Next; yyOld->MPC_SU_MemberDecl.Next = yyNew; break;
case kMPC_SU_Member: yyNext = yyOld->MPC_SU_Member.Next; yyOld->MPC_SU_Member.Next = yyNew; break;
case kMPC_Var: yyNext = yyOld->MPC_Var.Next; yyOld->MPC_Var.Next = yyNew; break;
case kMPC_CoordDecl: yyNext = yyOld->MPC_CoordDecl.Next; yyOld->MPC_CoordDecl.Next = yyNew; break;
case kMPC_Node: yyNext = yyOld->MPC_Node.Next; yyOld->MPC_Node.Next = yyNew; break;
case kMPC_LinkDeclaringList: yyNext = yyOld->MPC_LinkDeclaringList.Next; yyOld->MPC_LinkDeclaringList.Next = yyNew; break;
case kMPC_LinkDeclarator: yyNext = yyOld->MPC_LinkDeclarator.Next; yyOld->MPC_LinkDeclarator.Next = yyNew; break;
case kMPC_NetList: yyNext = yyOld->MPC_NetList.Next; yyOld->MPC_NetList.Next = yyNew; break;
case kMPC_NetOrSubnet: yyNext = yyOld->MPC_NetOrSubnet.Next; yyOld->MPC_NetOrSubnet.Next = yyNew; break;
case kMPC_Net: yyNext = yyOld->MPC_Net.Next; yyOld->MPC_Net.Next = yyNew; break;
case kMPC_Subnet: yyNext = yyOld->MPC_Subnet.Next; yyOld->MPC_Subnet.Next = yyNew; break;
case kMPC_Relation: yyNext = yyOld->MPC_Relation.Next; yyOld->MPC_Relation.Next = yyNew; break;
case kMPC_Stats: yyNext = yyOld->MPC_Stats.Next; yyOld->MPC_Stats.Next = yyNew; break;
case kMPC_Stat: yyNext = yyOld->MPC_Stat.Next; yyOld->MPC_Stat.Next = yyNew; break;
case kMPC_ExprStat: yyNext = yyOld->MPC_ExprStat.Next; yyOld->MPC_ExprStat.Next = yyNew; break;
case kMPC_If: yyNext = yyOld->MPC_If.Next; yyOld->MPC_If.Next = yyNew; break;
case kMPC_IfElse: yyNext = yyOld->MPC_IfElse.Next; yyOld->MPC_IfElse.Next = yyNew; break;
case kMPC_Switch: yyNext = yyOld->MPC_Switch.Next; yyOld->MPC_Switch.Next = yyNew; break;
case kMPC_While: yyNext = yyOld->MPC_While.Next; yyOld->MPC_While.Next = yyNew; break;
case kMPC_DoWhile: yyNext = yyOld->MPC_DoWhile.Next; yyOld->MPC_DoWhile.Next = yyNew; break;
case kMPC_For: yyNext = yyOld->MPC_For.Next; yyOld->MPC_For.Next = yyNew; break;
case kMPC_Goto: yyNext = yyOld->MPC_Goto.Next; yyOld->MPC_Goto.Next = yyNew; break;
case kMPC_Continue: yyNext = yyOld->MPC_Continue.Next; yyOld->MPC_Continue.Next = yyNew; break;
case kMPC_Break: yyNext = yyOld->MPC_Break.Next; yyOld->MPC_Break.Next = yyNew; break;
case kMPC_BreakFan: yyNext = yyOld->MPC_BreakFan.Next; yyOld->MPC_BreakFan.Next = yyNew; break;
case kMPC_Return: yyNext = yyOld->MPC_Return.Next; yyOld->MPC_Return.Next = yyNew; break;
case kMPC_Compound: yyNext = yyOld->MPC_Compound.Next; yyOld->MPC_Compound.Next = yyNew; break;
case kMPC_CompScheme: yyNext = yyOld->MPC_CompScheme.Next; yyOld->MPC_CompScheme.Next = yyNew; break;
case kMPC_CommScheme: yyNext = yyOld->MPC_CommScheme.Next; yyOld->MPC_CommScheme.Next = yyNew; break;
case kMPC_ParScheme: yyNext = yyOld->MPC_ParScheme.Next; yyOld->MPC_ParScheme.Next = yyNew; break;
case kMPC_Fan: yyNext = yyOld->MPC_Fan.Next; yyOld->MPC_Fan.Next = yyNew; break;
case kMPC_Label: yyNext = yyOld->MPC_Label.Next; yyOld->MPC_Label.Next = yyNew; break;
case kMPC_IdentLabel: yyNext = yyOld->MPC_IdentLabel.Next; yyOld->MPC_IdentLabel.Next = yyNew; break;
case kMPC_CaseLabel: yyNext = yyOld->MPC_CaseLabel.Next; yyOld->MPC_CaseLabel.Next = yyNew; break;
case kMPC_Default: yyNext = yyOld->MPC_Default.Next; yyOld->MPC_Default.Next = yyNew; break;
case kMPC_StringLiteral: yyNext = yyOld->MPC_StringLiteral.Next; yyOld->MPC_StringLiteral.Next = yyNew; break;
case kMPC_Exprs: yyNext = yyOld->MPC_Exprs.Next; yyOld->MPC_Exprs.Next = yyNew; break;
case kMPC_Initializer: yyNext = yyOld->MPC_Initializer.Next; yyOld->MPC_Initializer.Next = yyNew; break;
case kMPC_SimpleInit: yyNext = yyOld->MPC_SimpleInit.Next; yyOld->MPC_SimpleInit.Next = yyNew; break;
case kMPC_InitList: yyNext = yyOld->MPC_InitList.Next; yyOld->MPC_InitList.Next = yyNew; break;
  default: goto yyExit;
  }
  yyNew = yyOld;
  yyOld = yyNext;
 }
yyExit:
 switch (yyTail->Kind) {
case kMPC_Source: yyTail->MPC_Source.Next = yyOld; break;
case kMPC_Messages: yyTail->MPC_Messages.Next = yyOld; break;
case kMPC_ErrorMessage: yyTail->MPC_ErrorMessage.Next = yyOld; break;
case kMPC_ErrorMessageI: yyTail->MPC_ErrorMessageI.Next = yyOld; break;
case kMPC_Message: yyTail->MPC_Message.Next = yyOld; break;
case kMPC_MessageI: yyTail->MPC_MessageI.Next = yyOld; break;
case kMPC_Decls: yyTail->MPC_Decls.Next = yyOld; break;
case kMPC_UncompString: yyTail->MPC_UncompString.Next = yyOld; break;
case kMPC_Type: yyTail->MPC_Type.Next = yyOld; break;
case kMPC_BasicType: yyTail->MPC_BasicType.Next = yyOld; break;
case kMPC_EnumType: yyTail->MPC_EnumType.Next = yyOld; break;
case kMPC_Typedef: yyTail->MPC_Typedef.Next = yyOld; break;
case kMPC_DerivedType: yyTail->MPC_DerivedType.Next = yyOld; break;
case kMPC_ArrayType: yyTail->MPC_ArrayType.Next = yyOld; break;
case kMPC_VectorType: yyTail->MPC_VectorType.Next = yyOld; break;
case kMPC_PointerType: yyTail->MPC_PointerType.Next = yyOld; break;
case kMPC_StructType: yyTail->MPC_StructType.Next = yyOld; break;
case kMPC_UnionType: yyTail->MPC_UnionType.Next = yyOld; break;
case kMPC_FunctionType: yyTail->MPC_FunctionType.Next = yyOld; break;
case kMPC_VarDecl: yyTail->MPC_VarDecl.Next = yyOld; break;
case kMPC_Function: yyTail->MPC_Function.Next = yyOld; break;
case kMPC_Ellipsis: yyTail->MPC_Ellipsis.Next = yyOld; break;
case kMPC_NetDecl: yyTail->MPC_NetDecl.Next = yyOld; break;
case kMPC_SubnetDecl: yyTail->MPC_SubnetDecl.Next = yyOld; break;
case kMPC_RelDecl: yyTail->MPC_RelDecl.Next = yyOld; break;
case kMPC_NetTypeDecl: yyTail->MPC_NetTypeDecl.Next = yyOld; break;
case kMPC_NetType: yyTail->MPC_NetType.Next = yyOld; break;
case kMPC_NetTypeSpecifier: yyTail->MPC_NetTypeSpecifier.Next = yyOld; break;
case kMPC_EnumConst: yyTail->MPC_EnumConst.Next = yyOld; break;
case kMPC_SU_MemberDecl: yyTail->MPC_SU_MemberDecl.Next = yyOld; break;
case kMPC_SU_Member: yyTail->MPC_SU_Member.Next = yyOld; break;
case kMPC_Var: yyTail->MPC_Var.Next = yyOld; break;
case kMPC_CoordDecl: yyTail->MPC_CoordDecl.Next = yyOld; break;
case kMPC_Node: yyTail->MPC_Node.Next = yyOld; break;
case kMPC_LinkDeclaringList: yyTail->MPC_LinkDeclaringList.Next = yyOld; break;
case kMPC_LinkDeclarator: yyTail->MPC_LinkDeclarator.Next = yyOld; break;
case kMPC_NetList: yyTail->MPC_NetList.Next = yyOld; break;
case kMPC_NetOrSubnet: yyTail->MPC_NetOrSubnet.Next = yyOld; break;
case kMPC_Net: yyTail->MPC_Net.Next = yyOld; break;
case kMPC_Subnet: yyTail->MPC_Subnet.Next = yyOld; break;
case kMPC_Relation: yyTail->MPC_Relation.Next = yyOld; break;
case kMPC_Stats: yyTail->MPC_Stats.Next = yyOld; break;
case kMPC_Stat: yyTail->MPC_Stat.Next = yyOld; break;
case kMPC_ExprStat: yyTail->MPC_ExprStat.Next = yyOld; break;
case kMPC_If: yyTail->MPC_If.Next = yyOld; break;
case kMPC_IfElse: yyTail->MPC_IfElse.Next = yyOld; break;
case kMPC_Switch: yyTail->MPC_Switch.Next = yyOld; break;
case kMPC_While: yyTail->MPC_While.Next = yyOld; break;
case kMPC_DoWhile: yyTail->MPC_DoWhile.Next = yyOld; break;
case kMPC_For: yyTail->MPC_For.Next = yyOld; break;
case kMPC_Goto: yyTail->MPC_Goto.Next = yyOld; break;
case kMPC_Continue: yyTail->MPC_Continue.Next = yyOld; break;
case kMPC_Break: yyTail->MPC_Break.Next = yyOld; break;
case kMPC_BreakFan: yyTail->MPC_BreakFan.Next = yyOld; break;
case kMPC_Return: yyTail->MPC_Return.Next = yyOld; break;
case kMPC_Compound: yyTail->MPC_Compound.Next = yyOld; break;
case kMPC_CompScheme: yyTail->MPC_CompScheme.Next = yyOld; break;
case kMPC_CommScheme: yyTail->MPC_CommScheme.Next = yyOld; break;
case kMPC_ParScheme: yyTail->MPC_ParScheme.Next = yyOld; break;
case kMPC_Fan: yyTail->MPC_Fan.Next = yyOld; break;
case kMPC_Label: yyTail->MPC_Label.Next = yyOld; break;
case kMPC_IdentLabel: yyTail->MPC_IdentLabel.Next = yyOld; break;
case kMPC_CaseLabel: yyTail->MPC_CaseLabel.Next = yyOld; break;
case kMPC_Default: yyTail->MPC_Default.Next = yyOld; break;
case kMPC_StringLiteral: yyTail->MPC_StringLiteral.Next = yyOld; break;
case kMPC_Exprs: yyTail->MPC_Exprs.Next = yyOld; break;
case kMPC_Initializer: yyTail->MPC_Initializer.Next = yyOld; break;
case kMPC_SimpleInit: yyTail->MPC_SimpleInit.Next = yyOld; break;
case kMPC_InitList: yyTail->MPC_InitList.Next = yyOld; break;
 default: ;
 }
 return yyNew;
}

void ForallTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, Tree_tProcTree yyProc)
# else
 (yyt, yyProc) tTree yyt; Tree_tProcTree yyProc;
# endif
{
 for (;;) {
  tTree yyyt;
  if ((yyyt = yyt) == NoTree) return;
  switch (yyt->Kind) {
case kMPC_Source: yyt = yyt->MPC_Source.Next; break;
case kMPC_Messages: yyt = yyt->MPC_Messages.Next; break;
case kMPC_ErrorMessage: yyt = yyt->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI: yyt = yyt->MPC_ErrorMessageI.Next; break;
case kMPC_Message: yyt = yyt->MPC_Message.Next; break;
case kMPC_MessageI: yyt = yyt->MPC_MessageI.Next; break;
case kMPC_Decls: yyt = yyt->MPC_Decls.Next; break;
case kMPC_UncompString: yyt = yyt->MPC_UncompString.Next; break;
case kMPC_Type: yyt = yyt->MPC_Type.Next; break;
case kMPC_BasicType: yyt = yyt->MPC_BasicType.Next; break;
case kMPC_EnumType: yyt = yyt->MPC_EnumType.Next; break;
case kMPC_Typedef: yyt = yyt->MPC_Typedef.Next; break;
case kMPC_DerivedType: yyt = yyt->MPC_DerivedType.Next; break;
case kMPC_ArrayType: yyt = yyt->MPC_ArrayType.Next; break;
case kMPC_VectorType: yyt = yyt->MPC_VectorType.Next; break;
case kMPC_PointerType: yyt = yyt->MPC_PointerType.Next; break;
case kMPC_StructType: yyt = yyt->MPC_StructType.Next; break;
case kMPC_UnionType: yyt = yyt->MPC_UnionType.Next; break;
case kMPC_FunctionType: yyt = yyt->MPC_FunctionType.Next; break;
case kMPC_VarDecl: yyt = yyt->MPC_VarDecl.Next; break;
case kMPC_Function: yyt = yyt->MPC_Function.Next; break;
case kMPC_Ellipsis: yyt = yyt->MPC_Ellipsis.Next; break;
case kMPC_NetDecl: yyt = yyt->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl: yyt = yyt->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl: yyt = yyt->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl: yyt = yyt->MPC_NetTypeDecl.Next; break;
case kMPC_NetType: yyt = yyt->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier: yyt = yyt->MPC_NetTypeSpecifier.Next; break;
case kMPC_EnumConst: yyt = yyt->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl: yyt = yyt->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member: yyt = yyt->MPC_SU_Member.Next; break;
case kMPC_Var: yyt = yyt->MPC_Var.Next; break;
case kMPC_CoordDecl: yyt = yyt->MPC_CoordDecl.Next; break;
case kMPC_Node: yyt = yyt->MPC_Node.Next; break;
case kMPC_LinkDeclaringList: yyt = yyt->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator: yyt = yyt->MPC_LinkDeclarator.Next; break;
case kMPC_NetList: yyt = yyt->MPC_NetList.Next; break;
case kMPC_NetOrSubnet: yyt = yyt->MPC_NetOrSubnet.Next; break;
case kMPC_Net: yyt = yyt->MPC_Net.Next; break;
case kMPC_Subnet: yyt = yyt->MPC_Subnet.Next; break;
case kMPC_Relation: yyt = yyt->MPC_Relation.Next; break;
case kMPC_Stats: yyt = yyt->MPC_Stats.Next; break;
case kMPC_Stat: yyt = yyt->MPC_Stat.Next; break;
case kMPC_ExprStat: yyt = yyt->MPC_ExprStat.Next; break;
case kMPC_If: yyt = yyt->MPC_If.Next; break;
case kMPC_IfElse: yyt = yyt->MPC_IfElse.Next; break;
case kMPC_Switch: yyt = yyt->MPC_Switch.Next; break;
case kMPC_While: yyt = yyt->MPC_While.Next; break;
case kMPC_DoWhile: yyt = yyt->MPC_DoWhile.Next; break;
case kMPC_For: yyt = yyt->MPC_For.Next; break;
case kMPC_Goto: yyt = yyt->MPC_Goto.Next; break;
case kMPC_Continue: yyt = yyt->MPC_Continue.Next; break;
case kMPC_Break: yyt = yyt->MPC_Break.Next; break;
case kMPC_BreakFan: yyt = yyt->MPC_BreakFan.Next; break;
case kMPC_Return: yyt = yyt->MPC_Return.Next; break;
case kMPC_Compound: yyt = yyt->MPC_Compound.Next; break;
case kMPC_CompScheme: yyt = yyt->MPC_CompScheme.Next; break;
case kMPC_CommScheme: yyt = yyt->MPC_CommScheme.Next; break;
case kMPC_ParScheme: yyt = yyt->MPC_ParScheme.Next; break;
case kMPC_Fan: yyt = yyt->MPC_Fan.Next; break;
case kMPC_Label: yyt = yyt->MPC_Label.Next; break;
case kMPC_IdentLabel: yyt = yyt->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel: yyt = yyt->MPC_CaseLabel.Next; break;
case kMPC_Default: yyt = yyt->MPC_Default.Next; break;
case kMPC_StringLiteral: yyt = yyt->MPC_StringLiteral.Next; break;
case kMPC_Exprs: yyt = yyt->MPC_Exprs.Next; break;
case kMPC_Initializer: yyt = yyt->MPC_Initializer.Next; break;
case kMPC_SimpleInit: yyt = yyt->MPC_SimpleInit.Next; break;
case kMPC_InitList: yyt = yyt->MPC_InitList.Next; break;
  default: return;
  }
  yyProc (yyyt);
 }
}

# define yyInitOldToNewStoreSize 32

typedef struct { tTree yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld, tTree yyNew)
# else
 (yyOld, yyNew) tTree yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tTree yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
 return NoTree;
}

static void yyCopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tTree yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoTree) { * yyNew = NoTree; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, Tree_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kMPC_AstNode: (* yyNew)->MPC_AstNode = yyt->MPC_AstNode;
return;
case kMPC_Root: (* yyNew)->MPC_Root = yyt->MPC_Root;
copytTree ((* yyNew)->MPC_Root.Decls, yyt->MPC_Root.Decls)
copytTree ((* yyNew)->MPC_Root.Source, yyt->MPC_Root.Source)
copytTree ((* yyNew)->MPC_Root.Messages, yyt->MPC_Root.Messages)
copytTree ((* yyNew)->MPC_Root.Host, yyt->MPC_Root.Host)
copytTree ((* yyNew)->MPC_Root.SingleNode, yyt->MPC_Root.SingleNode)
copytTree ((* yyNew)->MPC_Root.ComputingSpace, yyt->MPC_Root.ComputingSpace)
copytTree ((* yyNew)->MPC_Root.Const, yyt->MPC_Root.Const)
copytTree ((* yyNew)->MPC_Root.Recon, yyt->MPC_Root.Recon)
copytTree ((* yyNew)->MPC_Root.HostList, yyt->MPC_Root.HostList)
copytTree ((* yyNew)->MPC_Root.SingleNodeList, yyt->MPC_Root.SingleNodeList)
copytTree ((* yyNew)->MPC_Root.ComputingSpaceList, yyt->MPC_Root.ComputingSpaceList)
copytTree ((* yyNew)->MPC_Root.ConstList, yyt->MPC_Root.ConstList)
yyt = yyt->MPC_Root.ReconList;
yyNew = & (* yyNew)->MPC_Root.ReconList; break;
case kMPC_Source: (* yyNew)->MPC_Source = yyt->MPC_Source;
copytString ((* yyNew)->MPC_Source.FileName, yyt->MPC_Source.FileName)
copytPosition ((* yyNew)->MPC_Source.VirtPos, yyt->MPC_Source.VirtPos)
copytPosition ((* yyNew)->MPC_Source.RealPos, yyt->MPC_Source.RealPos)
copytTree ((* yyNew)->MPC_Source.Prev, yyt->MPC_Source.Prev)
yyt = yyt->MPC_Source.Next;
yyNew = & (* yyNew)->MPC_Source.Next; break;
case kMPC_Messages: (* yyNew)->MPC_Messages = yyt->MPC_Messages;
copyint ((* yyNew)->MPC_Messages.ErrorClass, yyt->MPC_Messages.ErrorClass)
copytPosition ((* yyNew)->MPC_Messages.Pos, yyt->MPC_Messages.Pos)
copytTree ((* yyNew)->MPC_Messages.Prev, yyt->MPC_Messages.Prev)
copytTree ((* yyNew)->MPC_Messages.Tree, yyt->MPC_Messages.Tree)
yyt = yyt->MPC_Messages.Next;
yyNew = & (* yyNew)->MPC_Messages.Next; break;
case kMPC_ErrorMessage: (* yyNew)->MPC_ErrorMessage = yyt->MPC_ErrorMessage;
copyint ((* yyNew)->MPC_ErrorMessage.ErrorClass, yyt->MPC_ErrorMessage.ErrorClass)
copytPosition ((* yyNew)->MPC_ErrorMessage.Pos, yyt->MPC_ErrorMessage.Pos)
copytTree ((* yyNew)->MPC_ErrorMessage.Prev, yyt->MPC_ErrorMessage.Prev)
copytTree ((* yyNew)->MPC_ErrorMessage.Tree, yyt->MPC_ErrorMessage.Tree)
copyint ((* yyNew)->MPC_ErrorMessage.ErrorCode, yyt->MPC_ErrorMessage.ErrorCode)
yyt = yyt->MPC_ErrorMessage.Next;
yyNew = & (* yyNew)->MPC_ErrorMessage.Next; break;
case kMPC_ErrorMessageI: (* yyNew)->MPC_ErrorMessageI = yyt->MPC_ErrorMessageI;
copyint ((* yyNew)->MPC_ErrorMessageI.ErrorClass, yyt->MPC_ErrorMessageI.ErrorClass)
copytPosition ((* yyNew)->MPC_ErrorMessageI.Pos, yyt->MPC_ErrorMessageI.Pos)
copytTree ((* yyNew)->MPC_ErrorMessageI.Prev, yyt->MPC_ErrorMessageI.Prev)
copytTree ((* yyNew)->MPC_ErrorMessageI.Tree, yyt->MPC_ErrorMessageI.Tree)
copyint ((* yyNew)->MPC_ErrorMessageI.ErrorCode, yyt->MPC_ErrorMessageI.ErrorCode)
copyint ((* yyNew)->MPC_ErrorMessageI.InfoClass, yyt->MPC_ErrorMessageI.InfoClass)
copytString ((* yyNew)->MPC_ErrorMessageI.Info, yyt->MPC_ErrorMessageI.Info)
yyt = yyt->MPC_ErrorMessageI.Next;
yyNew = & (* yyNew)->MPC_ErrorMessageI.Next; break;
case kMPC_Message: (* yyNew)->MPC_Message = yyt->MPC_Message;
copyint ((* yyNew)->MPC_Message.ErrorClass, yyt->MPC_Message.ErrorClass)
copytPosition ((* yyNew)->MPC_Message.Pos, yyt->MPC_Message.Pos)
copytTree ((* yyNew)->MPC_Message.Prev, yyt->MPC_Message.Prev)
copytTree ((* yyNew)->MPC_Message.Tree, yyt->MPC_Message.Tree)
copyshort ((* yyNew)->MPC_Message.MessageNumber, yyt->MPC_Message.MessageNumber)
yyt = yyt->MPC_Message.Next;
yyNew = & (* yyNew)->MPC_Message.Next; break;
case kMPC_MessageI: (* yyNew)->MPC_MessageI = yyt->MPC_MessageI;
copyint ((* yyNew)->MPC_MessageI.ErrorClass, yyt->MPC_MessageI.ErrorClass)
copytPosition ((* yyNew)->MPC_MessageI.Pos, yyt->MPC_MessageI.Pos)
copytTree ((* yyNew)->MPC_MessageI.Prev, yyt->MPC_MessageI.Prev)
copytTree ((* yyNew)->MPC_MessageI.Tree, yyt->MPC_MessageI.Tree)
copyshort ((* yyNew)->MPC_MessageI.MessageNumber, yyt->MPC_MessageI.MessageNumber)
copyint ((* yyNew)->MPC_MessageI.InfoClass, yyt->MPC_MessageI.InfoClass)
copytString ((* yyNew)->MPC_MessageI.Info, yyt->MPC_MessageI.Info)
yyt = yyt->MPC_MessageI.Next;
yyNew = & (* yyNew)->MPC_MessageI.Next; break;
case kMPC_FreeNode: (* yyNew)->MPC_FreeNode = yyt->MPC_FreeNode;
yyt = yyt->MPC_FreeNode.Parent;
yyNew = & (* yyNew)->MPC_FreeNode.Parent; break;
case kMPC_Decls: (* yyNew)->MPC_Decls = yyt->MPC_Decls;
copytPosition ((* yyNew)->MPC_Decls.Pos, yyt->MPC_Decls.Pos)
copytTree ((* yyNew)->MPC_Decls.Prev, yyt->MPC_Decls.Prev)
copytPosition ((* yyNew)->MPC_Decls.EndPos, yyt->MPC_Decls.EndPos)
yyt = yyt->MPC_Decls.Next;
yyNew = & (* yyNew)->MPC_Decls.Next; break;
case kMPC_UncompString: (* yyNew)->MPC_UncompString = yyt->MPC_UncompString;
copytPosition ((* yyNew)->MPC_UncompString.Pos, yyt->MPC_UncompString.Pos)
copytTree ((* yyNew)->MPC_UncompString.Prev, yyt->MPC_UncompString.Prev)
copytPosition ((* yyNew)->MPC_UncompString.EndPos, yyt->MPC_UncompString.EndPos)
copytString ((* yyNew)->MPC_UncompString.uString, yyt->MPC_UncompString.uString)
yyt = yyt->MPC_UncompString.Next;
yyNew = & (* yyNew)->MPC_UncompString.Next; break;
case kMPC_Type: (* yyNew)->MPC_Type = yyt->MPC_Type;
copytPosition ((* yyNew)->MPC_Type.Pos, yyt->MPC_Type.Pos)
copytTree ((* yyNew)->MPC_Type.Prev, yyt->MPC_Type.Prev)
copytPosition ((* yyNew)->MPC_Type.EndPos, yyt->MPC_Type.EndPos)
copytTypeFlags ((* yyNew)->MPC_Type.Flag, yyt->MPC_Type.Flag)
copybool ((* yyNew)->MPC_Type.Buffer, yyt->MPC_Type.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_Type.UniqueNumber, yyt->MPC_Type.UniqueNumber)
copytTree ((* yyNew)->MPC_Type.EquivType, yyt->MPC_Type.EquivType)
copypVoid ((* yyNew)->MPC_Type.pType, yyt->MPC_Type.pType)
yyt = yyt->MPC_Type.Next;
yyNew = & (* yyNew)->MPC_Type.Next; break;
case kMPC_BasicType: (* yyNew)->MPC_BasicType = yyt->MPC_BasicType;
copytPosition ((* yyNew)->MPC_BasicType.Pos, yyt->MPC_BasicType.Pos)
copytTree ((* yyNew)->MPC_BasicType.Prev, yyt->MPC_BasicType.Prev)
copytPosition ((* yyNew)->MPC_BasicType.EndPos, yyt->MPC_BasicType.EndPos)
copytTypeFlags ((* yyNew)->MPC_BasicType.Flag, yyt->MPC_BasicType.Flag)
copybool ((* yyNew)->MPC_BasicType.Buffer, yyt->MPC_BasicType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_BasicType.UniqueNumber, yyt->MPC_BasicType.UniqueNumber)
copytTree ((* yyNew)->MPC_BasicType.EquivType, yyt->MPC_BasicType.EquivType)
copypVoid ((* yyNew)->MPC_BasicType.pType, yyt->MPC_BasicType.pType)
copyshort ((* yyNew)->MPC_BasicType.TypeConstructor, yyt->MPC_BasicType.TypeConstructor)
yyt = yyt->MPC_BasicType.Next;
yyNew = & (* yyNew)->MPC_BasicType.Next; break;
case kMPC_EnumType: (* yyNew)->MPC_EnumType = yyt->MPC_EnumType;
copytPosition ((* yyNew)->MPC_EnumType.Pos, yyt->MPC_EnumType.Pos)
copytTree ((* yyNew)->MPC_EnumType.Prev, yyt->MPC_EnumType.Prev)
copytPosition ((* yyNew)->MPC_EnumType.EndPos, yyt->MPC_EnumType.EndPos)
copytTypeFlags ((* yyNew)->MPC_EnumType.Flag, yyt->MPC_EnumType.Flag)
copybool ((* yyNew)->MPC_EnumType.Buffer, yyt->MPC_EnumType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_EnumType.UniqueNumber, yyt->MPC_EnumType.UniqueNumber)
copytTree ((* yyNew)->MPC_EnumType.EquivType, yyt->MPC_EnumType.EquivType)
copypVoid ((* yyNew)->MPC_EnumType.pType, yyt->MPC_EnumType.pType)
copytIdent ((* yyNew)->MPC_EnumType.EnumTag, yyt->MPC_EnumType.EnumTag)
copytTree ((* yyNew)->MPC_EnumType.EnumList, yyt->MPC_EnumType.EnumList)
yyt = yyt->MPC_EnumType.Next;
yyNew = & (* yyNew)->MPC_EnumType.Next; break;
case kMPC_Typedef: (* yyNew)->MPC_Typedef = yyt->MPC_Typedef;
copytPosition ((* yyNew)->MPC_Typedef.Pos, yyt->MPC_Typedef.Pos)
copytTree ((* yyNew)->MPC_Typedef.Prev, yyt->MPC_Typedef.Prev)
copytPosition ((* yyNew)->MPC_Typedef.EndPos, yyt->MPC_Typedef.EndPos)
copytTypeFlags ((* yyNew)->MPC_Typedef.Flag, yyt->MPC_Typedef.Flag)
copybool ((* yyNew)->MPC_Typedef.Buffer, yyt->MPC_Typedef.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_Typedef.UniqueNumber, yyt->MPC_Typedef.UniqueNumber)
copytTree ((* yyNew)->MPC_Typedef.EquivType, yyt->MPC_Typedef.EquivType)
copypVoid ((* yyNew)->MPC_Typedef.pType, yyt->MPC_Typedef.pType)
copytIdent ((* yyNew)->MPC_Typedef.TypedefName, yyt->MPC_Typedef.TypedefName)
copytTree ((* yyNew)->MPC_Typedef.Type, yyt->MPC_Typedef.Type)
yyt = yyt->MPC_Typedef.Next;
yyNew = & (* yyNew)->MPC_Typedef.Next; break;
case kMPC_DerivedType: (* yyNew)->MPC_DerivedType = yyt->MPC_DerivedType;
copytPosition ((* yyNew)->MPC_DerivedType.Pos, yyt->MPC_DerivedType.Pos)
copytTree ((* yyNew)->MPC_DerivedType.Prev, yyt->MPC_DerivedType.Prev)
copytPosition ((* yyNew)->MPC_DerivedType.EndPos, yyt->MPC_DerivedType.EndPos)
copytTypeFlags ((* yyNew)->MPC_DerivedType.Flag, yyt->MPC_DerivedType.Flag)
copybool ((* yyNew)->MPC_DerivedType.Buffer, yyt->MPC_DerivedType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_DerivedType.UniqueNumber, yyt->MPC_DerivedType.UniqueNumber)
copytTree ((* yyNew)->MPC_DerivedType.EquivType, yyt->MPC_DerivedType.EquivType)
copypVoid ((* yyNew)->MPC_DerivedType.pType, yyt->MPC_DerivedType.pType)
copyint ((* yyNew)->MPC_DerivedType.NumberOfComponents, yyt->MPC_DerivedType.NumberOfComponents)
yyt = yyt->MPC_DerivedType.Next;
yyNew = & (* yyNew)->MPC_DerivedType.Next; break;
case kMPC_ArrayType: (* yyNew)->MPC_ArrayType = yyt->MPC_ArrayType;
copytPosition ((* yyNew)->MPC_ArrayType.Pos, yyt->MPC_ArrayType.Pos)
copytTree ((* yyNew)->MPC_ArrayType.Prev, yyt->MPC_ArrayType.Prev)
copytPosition ((* yyNew)->MPC_ArrayType.EndPos, yyt->MPC_ArrayType.EndPos)
copytTypeFlags ((* yyNew)->MPC_ArrayType.Flag, yyt->MPC_ArrayType.Flag)
copybool ((* yyNew)->MPC_ArrayType.Buffer, yyt->MPC_ArrayType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_ArrayType.UniqueNumber, yyt->MPC_ArrayType.UniqueNumber)
copytTree ((* yyNew)->MPC_ArrayType.EquivType, yyt->MPC_ArrayType.EquivType)
copypVoid ((* yyNew)->MPC_ArrayType.pType, yyt->MPC_ArrayType.pType)
copyint ((* yyNew)->MPC_ArrayType.NumberOfComponents, yyt->MPC_ArrayType.NumberOfComponents)
copyshort ((* yyNew)->MPC_ArrayType.Step, yyt->MPC_ArrayType.Step)
copytTree ((* yyNew)->MPC_ArrayType.ElementType, yyt->MPC_ArrayType.ElementType)
copytTree ((* yyNew)->MPC_ArrayType.ArraySize, yyt->MPC_ArrayType.ArraySize)
copytTree ((* yyNew)->MPC_ArrayType.DynStep, yyt->MPC_ArrayType.DynStep)
yyt = yyt->MPC_ArrayType.Next;
yyNew = & (* yyNew)->MPC_ArrayType.Next; break;
case kMPC_VectorType: (* yyNew)->MPC_VectorType = yyt->MPC_VectorType;
copytPosition ((* yyNew)->MPC_VectorType.Pos, yyt->MPC_VectorType.Pos)
copytTree ((* yyNew)->MPC_VectorType.Prev, yyt->MPC_VectorType.Prev)
copytPosition ((* yyNew)->MPC_VectorType.EndPos, yyt->MPC_VectorType.EndPos)
copytTypeFlags ((* yyNew)->MPC_VectorType.Flag, yyt->MPC_VectorType.Flag)
copybool ((* yyNew)->MPC_VectorType.Buffer, yyt->MPC_VectorType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_VectorType.UniqueNumber, yyt->MPC_VectorType.UniqueNumber)
copytTree ((* yyNew)->MPC_VectorType.EquivType, yyt->MPC_VectorType.EquivType)
copypVoid ((* yyNew)->MPC_VectorType.pType, yyt->MPC_VectorType.pType)
copyint ((* yyNew)->MPC_VectorType.NumberOfComponents, yyt->MPC_VectorType.NumberOfComponents)
copytTree ((* yyNew)->MPC_VectorType.ElementType, yyt->MPC_VectorType.ElementType)
copytTree ((* yyNew)->MPC_VectorType.VectorSize, yyt->MPC_VectorType.VectorSize)
yyt = yyt->MPC_VectorType.Next;
yyNew = & (* yyNew)->MPC_VectorType.Next; break;
case kMPC_PointerType: (* yyNew)->MPC_PointerType = yyt->MPC_PointerType;
copytPosition ((* yyNew)->MPC_PointerType.Pos, yyt->MPC_PointerType.Pos)
copytTree ((* yyNew)->MPC_PointerType.Prev, yyt->MPC_PointerType.Prev)
copytPosition ((* yyNew)->MPC_PointerType.EndPos, yyt->MPC_PointerType.EndPos)
copytTypeFlags ((* yyNew)->MPC_PointerType.Flag, yyt->MPC_PointerType.Flag)
copybool ((* yyNew)->MPC_PointerType.Buffer, yyt->MPC_PointerType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_PointerType.UniqueNumber, yyt->MPC_PointerType.UniqueNumber)
copytTree ((* yyNew)->MPC_PointerType.EquivType, yyt->MPC_PointerType.EquivType)
copypVoid ((* yyNew)->MPC_PointerType.pType, yyt->MPC_PointerType.pType)
copyint ((* yyNew)->MPC_PointerType.NumberOfComponents, yyt->MPC_PointerType.NumberOfComponents)
copyshort ((* yyNew)->MPC_PointerType.Step, yyt->MPC_PointerType.Step)
copytTree ((* yyNew)->MPC_PointerType.ElementType, yyt->MPC_PointerType.ElementType)
copytTree ((* yyNew)->MPC_PointerType.DynStep, yyt->MPC_PointerType.DynStep)
copytTree ((* yyNew)->MPC_PointerType.GeneratedFrom, yyt->MPC_PointerType.GeneratedFrom)
yyt = yyt->MPC_PointerType.Next;
yyNew = & (* yyNew)->MPC_PointerType.Next; break;
case kMPC_StructType: (* yyNew)->MPC_StructType = yyt->MPC_StructType;
copytPosition ((* yyNew)->MPC_StructType.Pos, yyt->MPC_StructType.Pos)
copytTree ((* yyNew)->MPC_StructType.Prev, yyt->MPC_StructType.Prev)
copytPosition ((* yyNew)->MPC_StructType.EndPos, yyt->MPC_StructType.EndPos)
copytTypeFlags ((* yyNew)->MPC_StructType.Flag, yyt->MPC_StructType.Flag)
copybool ((* yyNew)->MPC_StructType.Buffer, yyt->MPC_StructType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_StructType.UniqueNumber, yyt->MPC_StructType.UniqueNumber)
copytTree ((* yyNew)->MPC_StructType.EquivType, yyt->MPC_StructType.EquivType)
copypVoid ((* yyNew)->MPC_StructType.pType, yyt->MPC_StructType.pType)
copyint ((* yyNew)->MPC_StructType.NumberOfComponents, yyt->MPC_StructType.NumberOfComponents)
copytIdent ((* yyNew)->MPC_StructType.SU_Tag, yyt->MPC_StructType.SU_Tag)
copytTree ((* yyNew)->MPC_StructType.MemberDecls, yyt->MPC_StructType.MemberDecls)
yyt = yyt->MPC_StructType.Next;
yyNew = & (* yyNew)->MPC_StructType.Next; break;
case kMPC_UnionType: (* yyNew)->MPC_UnionType = yyt->MPC_UnionType;
copytPosition ((* yyNew)->MPC_UnionType.Pos, yyt->MPC_UnionType.Pos)
copytTree ((* yyNew)->MPC_UnionType.Prev, yyt->MPC_UnionType.Prev)
copytPosition ((* yyNew)->MPC_UnionType.EndPos, yyt->MPC_UnionType.EndPos)
copytTypeFlags ((* yyNew)->MPC_UnionType.Flag, yyt->MPC_UnionType.Flag)
copybool ((* yyNew)->MPC_UnionType.Buffer, yyt->MPC_UnionType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_UnionType.UniqueNumber, yyt->MPC_UnionType.UniqueNumber)
copytTree ((* yyNew)->MPC_UnionType.EquivType, yyt->MPC_UnionType.EquivType)
copypVoid ((* yyNew)->MPC_UnionType.pType, yyt->MPC_UnionType.pType)
copyint ((* yyNew)->MPC_UnionType.NumberOfComponents, yyt->MPC_UnionType.NumberOfComponents)
copytIdent ((* yyNew)->MPC_UnionType.SU_Tag, yyt->MPC_UnionType.SU_Tag)
copytTree ((* yyNew)->MPC_UnionType.MemberDecls, yyt->MPC_UnionType.MemberDecls)
yyt = yyt->MPC_UnionType.Next;
yyNew = & (* yyNew)->MPC_UnionType.Next; break;
case kMPC_FunctionType: (* yyNew)->MPC_FunctionType = yyt->MPC_FunctionType;
copytPosition ((* yyNew)->MPC_FunctionType.Pos, yyt->MPC_FunctionType.Pos)
copytTree ((* yyNew)->MPC_FunctionType.Prev, yyt->MPC_FunctionType.Prev)
copytPosition ((* yyNew)->MPC_FunctionType.EndPos, yyt->MPC_FunctionType.EndPos)
copytTypeFlags ((* yyNew)->MPC_FunctionType.Flag, yyt->MPC_FunctionType.Flag)
copybool ((* yyNew)->MPC_FunctionType.Buffer, yyt->MPC_FunctionType.Buffer)
copyMPC_unsigned_short ((* yyNew)->MPC_FunctionType.UniqueNumber, yyt->MPC_FunctionType.UniqueNumber)
copytTree ((* yyNew)->MPC_FunctionType.EquivType, yyt->MPC_FunctionType.EquivType)
copypVoid ((* yyNew)->MPC_FunctionType.pType, yyt->MPC_FunctionType.pType)
copyint ((* yyNew)->MPC_FunctionType.NumberOfComponents, yyt->MPC_FunctionType.NumberOfComponents)
copyshort ((* yyNew)->MPC_FunctionType.Kind, yyt->MPC_FunctionType.Kind)
copytTree ((* yyNew)->MPC_FunctionType.ResultType, yyt->MPC_FunctionType.ResultType)
copytTree ((* yyNew)->MPC_FunctionType.NetParamType, yyt->MPC_FunctionType.NetParamType)
copytTree ((* yyNew)->MPC_FunctionType.NetParam, yyt->MPC_FunctionType.NetParam)
copytTree ((* yyNew)->MPC_FunctionType.NetworkParamList, yyt->MPC_FunctionType.NetworkParamList)
copytTree ((* yyNew)->MPC_FunctionType.ParamList, yyt->MPC_FunctionType.ParamList)
yyt = yyt->MPC_FunctionType.Next;
yyNew = & (* yyNew)->MPC_FunctionType.Next; break;
case kMPC_VarDecl: (* yyNew)->MPC_VarDecl = yyt->MPC_VarDecl;
copytPosition ((* yyNew)->MPC_VarDecl.Pos, yyt->MPC_VarDecl.Pos)
copytTree ((* yyNew)->MPC_VarDecl.Prev, yyt->MPC_VarDecl.Prev)
copytPosition ((* yyNew)->MPC_VarDecl.EndPos, yyt->MPC_VarDecl.EndPos)
copytClass ((* yyNew)->MPC_VarDecl.Class, yyt->MPC_VarDecl.Class)
copytDeclFlags ((* yyNew)->MPC_VarDecl.Flag, yyt->MPC_VarDecl.Flag)
copytTree ((* yyNew)->MPC_VarDecl.DeclSpecifier, yyt->MPC_VarDecl.DeclSpecifier)
copytTree ((* yyNew)->MPC_VarDecl.Var, yyt->MPC_VarDecl.Var)
yyt = yyt->MPC_VarDecl.Next;
yyNew = & (* yyNew)->MPC_VarDecl.Next; break;
case kMPC_Function: (* yyNew)->MPC_Function = yyt->MPC_Function;
copytPosition ((* yyNew)->MPC_Function.Pos, yyt->MPC_Function.Pos)
copytTree ((* yyNew)->MPC_Function.Prev, yyt->MPC_Function.Prev)
copytPosition ((* yyNew)->MPC_Function.EndPos, yyt->MPC_Function.EndPos)
copyshort ((* yyNew)->MPC_Function.Kind, yyt->MPC_Function.Kind)
copytDeclFlags ((* yyNew)->MPC_Function.Flag, yyt->MPC_Function.Flag)
copytTree ((* yyNew)->MPC_Function.Distribution, yyt->MPC_Function.Distribution)
copytTree ((* yyNew)->MPC_Function.Name, yyt->MPC_Function.Name)
copytTree ((* yyNew)->MPC_Function.Type, yyt->MPC_Function.Type)
copytTree ((* yyNew)->MPC_Function.ParamList, yyt->MPC_Function.ParamList)
copytTree ((* yyNew)->MPC_Function.Stats, yyt->MPC_Function.Stats)
copytTree ((* yyNew)->MPC_Function.LabelList, yyt->MPC_Function.LabelList)
yyt = yyt->MPC_Function.Next;
yyNew = & (* yyNew)->MPC_Function.Next; break;
case kMPC_Ellipsis: (* yyNew)->MPC_Ellipsis = yyt->MPC_Ellipsis;
copytPosition ((* yyNew)->MPC_Ellipsis.Pos, yyt->MPC_Ellipsis.Pos)
copytTree ((* yyNew)->MPC_Ellipsis.Prev, yyt->MPC_Ellipsis.Prev)
copytPosition ((* yyNew)->MPC_Ellipsis.EndPos, yyt->MPC_Ellipsis.EndPos)
yyt = yyt->MPC_Ellipsis.Next;
yyNew = & (* yyNew)->MPC_Ellipsis.Next; break;
case kMPC_NetDecl: (* yyNew)->MPC_NetDecl = yyt->MPC_NetDecl;
copytPosition ((* yyNew)->MPC_NetDecl.Pos, yyt->MPC_NetDecl.Pos)
copytTree ((* yyNew)->MPC_NetDecl.Prev, yyt->MPC_NetDecl.Prev)
copytPosition ((* yyNew)->MPC_NetDecl.EndPos, yyt->MPC_NetDecl.EndPos)
copytClass ((* yyNew)->MPC_NetDecl.NetClass, yyt->MPC_NetDecl.NetClass)
copytDeclFlags ((* yyNew)->MPC_NetDecl.Flag, yyt->MPC_NetDecl.Flag)
copytTree ((* yyNew)->MPC_NetDecl.NetTypeSpecifier, yyt->MPC_NetDecl.NetTypeSpecifier)
copytTree ((* yyNew)->MPC_NetDecl.Net, yyt->MPC_NetDecl.Net)
yyt = yyt->MPC_NetDecl.Next;
yyNew = & (* yyNew)->MPC_NetDecl.Next; break;
case kMPC_SubnetDecl: (* yyNew)->MPC_SubnetDecl = yyt->MPC_SubnetDecl;
copytPosition ((* yyNew)->MPC_SubnetDecl.Pos, yyt->MPC_SubnetDecl.Pos)
copytTree ((* yyNew)->MPC_SubnetDecl.Prev, yyt->MPC_SubnetDecl.Prev)
copytPosition ((* yyNew)->MPC_SubnetDecl.EndPos, yyt->MPC_SubnetDecl.EndPos)
copytClass ((* yyNew)->MPC_SubnetDecl.SubnetClass, yyt->MPC_SubnetDecl.SubnetClass)
copytDeclFlags ((* yyNew)->MPC_SubnetDecl.Flag, yyt->MPC_SubnetDecl.Flag)
copytTree ((* yyNew)->MPC_SubnetDecl.Subnet, yyt->MPC_SubnetDecl.Subnet)
yyt = yyt->MPC_SubnetDecl.Next;
yyNew = & (* yyNew)->MPC_SubnetDecl.Next; break;
case kMPC_RelDecl: (* yyNew)->MPC_RelDecl = yyt->MPC_RelDecl;
copytPosition ((* yyNew)->MPC_RelDecl.Pos, yyt->MPC_RelDecl.Pos)
copytTree ((* yyNew)->MPC_RelDecl.Prev, yyt->MPC_RelDecl.Prev)
copytPosition ((* yyNew)->MPC_RelDecl.EndPos, yyt->MPC_RelDecl.EndPos)
copytTree ((* yyNew)->MPC_RelDecl.Relation, yyt->MPC_RelDecl.Relation)
yyt = yyt->MPC_RelDecl.Next;
yyNew = & (* yyNew)->MPC_RelDecl.Next; break;
case kMPC_NetTypeDecl: (* yyNew)->MPC_NetTypeDecl = yyt->MPC_NetTypeDecl;
copytPosition ((* yyNew)->MPC_NetTypeDecl.Pos, yyt->MPC_NetTypeDecl.Pos)
copytTree ((* yyNew)->MPC_NetTypeDecl.Prev, yyt->MPC_NetTypeDecl.Prev)
copytPosition ((* yyNew)->MPC_NetTypeDecl.EndPos, yyt->MPC_NetTypeDecl.EndPos)
copytIdent ((* yyNew)->MPC_NetTypeDecl.Ident, yyt->MPC_NetTypeDecl.Ident)
yyt = yyt->MPC_NetTypeDecl.Next;
yyNew = & (* yyNew)->MPC_NetTypeDecl.Next; break;
case kMPC_NetType: (* yyNew)->MPC_NetType = yyt->MPC_NetType;
copytPosition ((* yyNew)->MPC_NetType.Pos, yyt->MPC_NetType.Pos)
copytTree ((* yyNew)->MPC_NetType.Prev, yyt->MPC_NetType.Prev)
copytPosition ((* yyNew)->MPC_NetType.EndPos, yyt->MPC_NetType.EndPos)
copytIdent ((* yyNew)->MPC_NetType.Ident, yyt->MPC_NetType.Ident)
copytClass ((* yyNew)->MPC_NetType.Class, yyt->MPC_NetType.Class)
copytTree ((* yyNew)->MPC_NetType.ParamList, yyt->MPC_NetType.ParamList)
copytTree ((* yyNew)->MPC_NetType.CoordDecl, yyt->MPC_NetType.CoordDecl)
copytTree ((* yyNew)->MPC_NetType.NodeDecl, yyt->MPC_NetType.NodeDecl)
copytTree ((* yyNew)->MPC_NetType.LinkDecl, yyt->MPC_NetType.LinkDecl)
copytTree ((* yyNew)->MPC_NetType.StartDecl, yyt->MPC_NetType.StartDecl)
copytTree ((* yyNew)->MPC_NetType.SchemeDecl, yyt->MPC_NetType.SchemeDecl)
copybool ((* yyNew)->MPC_NetType.Bench, yyt->MPC_NetType.Bench)
copytTree ((* yyNew)->MPC_NetType.TopoFunctions, yyt->MPC_NetType.TopoFunctions)
yyt = yyt->MPC_NetType.Next;
yyNew = & (* yyNew)->MPC_NetType.Next; break;
case kMPC_NetTypeSpecifier: (* yyNew)->MPC_NetTypeSpecifier = yyt->MPC_NetTypeSpecifier;
copytPosition ((* yyNew)->MPC_NetTypeSpecifier.Pos, yyt->MPC_NetTypeSpecifier.Pos)
copytTree ((* yyNew)->MPC_NetTypeSpecifier.Prev, yyt->MPC_NetTypeSpecifier.Prev)
copytPosition ((* yyNew)->MPC_NetTypeSpecifier.EndPos, yyt->MPC_NetTypeSpecifier.EndPos)
copytIdent ((* yyNew)->MPC_NetTypeSpecifier.Ident, yyt->MPC_NetTypeSpecifier.Ident)
copytTree ((* yyNew)->MPC_NetTypeSpecifier.NetType, yyt->MPC_NetTypeSpecifier.NetType)
copytTree ((* yyNew)->MPC_NetTypeSpecifier.ArgList, yyt->MPC_NetTypeSpecifier.ArgList)
yyt = yyt->MPC_NetTypeSpecifier.Next;
yyNew = & (* yyNew)->MPC_NetTypeSpecifier.Next; break;
case kMPC_TopoFunctions: (* yyNew)->MPC_TopoFunctions = yyt->MPC_TopoFunctions;
copytTree ((* yyNew)->MPC_TopoFunctions.Node_Def, yyt->MPC_TopoFunctions.Node_Def)
copytTree ((* yyNew)->MPC_TopoFunctions.Link_Def, yyt->MPC_TopoFunctions.Link_Def)
copytTree ((* yyNew)->MPC_TopoFunctions.Main_Node_Def, yyt->MPC_TopoFunctions.Main_Node_Def)
copytTree ((* yyNew)->MPC_TopoFunctions.Power_Def, yyt->MPC_TopoFunctions.Power_Def)
copytTree ((* yyNew)->MPC_TopoFunctions.Node_Coord_Def, yyt->MPC_TopoFunctions.Node_Coord_Def)
copytTree ((* yyNew)->MPC_TopoFunctions.Node_Number_Def, yyt->MPC_TopoFunctions.Node_Number_Def)
yyt = yyt->MPC_TopoFunctions.Mapping_Def;
yyNew = & (* yyNew)->MPC_TopoFunctions.Mapping_Def; break;
case kMPC_EnumConst: (* yyNew)->MPC_EnumConst = yyt->MPC_EnumConst;
copytPosition ((* yyNew)->MPC_EnumConst.Pos, yyt->MPC_EnumConst.Pos)
copytIdent ((* yyNew)->MPC_EnumConst.Name, yyt->MPC_EnumConst.Name)
copybool ((* yyNew)->MPC_EnumConst.WithValue, yyt->MPC_EnumConst.WithValue)
copyint ((* yyNew)->MPC_EnumConst.Value, yyt->MPC_EnumConst.Value)
copytTree ((* yyNew)->MPC_EnumConst.Prev, yyt->MPC_EnumConst.Prev)
copytPosition ((* yyNew)->MPC_EnumConst.EndPos, yyt->MPC_EnumConst.EndPos)
yyt = yyt->MPC_EnumConst.Next;
yyNew = & (* yyNew)->MPC_EnumConst.Next; break;
case kMPC_SU_MemberDecl: (* yyNew)->MPC_SU_MemberDecl = yyt->MPC_SU_MemberDecl;
copytPosition ((* yyNew)->MPC_SU_MemberDecl.Pos, yyt->MPC_SU_MemberDecl.Pos)
copytTree ((* yyNew)->MPC_SU_MemberDecl.Prev, yyt->MPC_SU_MemberDecl.Prev)
copytTree ((* yyNew)->MPC_SU_MemberDecl.Member, yyt->MPC_SU_MemberDecl.Member)
copytPosition ((* yyNew)->MPC_SU_MemberDecl.EndPos, yyt->MPC_SU_MemberDecl.EndPos)
yyt = yyt->MPC_SU_MemberDecl.Next;
yyNew = & (* yyNew)->MPC_SU_MemberDecl.Next; break;
case kMPC_SU_Member: (* yyNew)->MPC_SU_Member = yyt->MPC_SU_Member;
copytPosition ((* yyNew)->MPC_SU_Member.Pos, yyt->MPC_SU_Member.Pos)
copytIdent ((* yyNew)->MPC_SU_Member.Name, yyt->MPC_SU_Member.Name)
copyshort ((* yyNew)->MPC_SU_Member.BitFieldLength, yyt->MPC_SU_Member.BitFieldLength)
copytTree ((* yyNew)->MPC_SU_Member.Prev, yyt->MPC_SU_Member.Prev)
copytTree ((* yyNew)->MPC_SU_Member.Type, yyt->MPC_SU_Member.Type)
copytTree ((* yyNew)->MPC_SU_Member.BitFieldSize, yyt->MPC_SU_Member.BitFieldSize)
copytPosition ((* yyNew)->MPC_SU_Member.EndPos, yyt->MPC_SU_Member.EndPos)
copyMPC_unsigned_short ((* yyNew)->MPC_SU_Member.UniqueNumber, yyt->MPC_SU_Member.UniqueNumber)
yyt = yyt->MPC_SU_Member.Next;
yyNew = & (* yyNew)->MPC_SU_Member.Next; break;
case kMPC_Var: (* yyNew)->MPC_Var = yyt->MPC_Var;
copytPosition ((* yyNew)->MPC_Var.Pos, yyt->MPC_Var.Pos)
copytIdent ((* yyNew)->MPC_Var.Ident, yyt->MPC_Var.Ident)
copytDeclFlags ((* yyNew)->MPC_Var.Flag, yyt->MPC_Var.Flag)
copytTree ((* yyNew)->MPC_Var.Prev, yyt->MPC_Var.Prev)
copytTree ((* yyNew)->MPC_Var.Type, yyt->MPC_Var.Type)
copytTree ((* yyNew)->MPC_Var.Distribution, yyt->MPC_Var.Distribution)
copytTree ((* yyNew)->MPC_Var.Init, yyt->MPC_Var.Init)
copytPosition ((* yyNew)->MPC_Var.EndPos, yyt->MPC_Var.EndPos)
yyt = yyt->MPC_Var.Next;
yyNew = & (* yyNew)->MPC_Var.Next; break;
case kMPC_CoordDecl: (* yyNew)->MPC_CoordDecl = yyt->MPC_CoordDecl;
copytPosition ((* yyNew)->MPC_CoordDecl.Pos, yyt->MPC_CoordDecl.Pos)
copytIdent ((* yyNew)->MPC_CoordDecl.Ident, yyt->MPC_CoordDecl.Ident)
copytTree ((* yyNew)->MPC_CoordDecl.Prev, yyt->MPC_CoordDecl.Prev)
copytTree ((* yyNew)->MPC_CoordDecl.Range, yyt->MPC_CoordDecl.Range)
copytPosition ((* yyNew)->MPC_CoordDecl.EndPos, yyt->MPC_CoordDecl.EndPos)
copyshort ((* yyNew)->MPC_CoordDecl.CoordNumber, yyt->MPC_CoordDecl.CoordNumber)
yyt = yyt->MPC_CoordDecl.Next;
yyNew = & (* yyNew)->MPC_CoordDecl.Next; break;
case kMPC_Node: (* yyNew)->MPC_Node = yyt->MPC_Node;
copytPosition ((* yyNew)->MPC_Node.Pos, yyt->MPC_Node.Pos)
copytNodeType ((* yyNew)->MPC_Node.NodeType, yyt->MPC_Node.NodeType)
copybool ((* yyNew)->MPC_Node.DynamicType, yyt->MPC_Node.DynamicType)
copytTree ((* yyNew)->MPC_Node.Prev, yyt->MPC_Node.Prev)
copytTree ((* yyNew)->MPC_Node.Predicate, yyt->MPC_Node.Predicate)
copytTree ((* yyNew)->MPC_Node.NodeQual, yyt->MPC_Node.NodeQual)
copytPosition ((* yyNew)->MPC_Node.EndPos, yyt->MPC_Node.EndPos)
yyt = yyt->MPC_Node.Next;
yyNew = & (* yyNew)->MPC_Node.Next; break;
case kMPC_NodeQual: (* yyNew)->MPC_NodeQual = yyt->MPC_NodeQual;
copytPosition ((* yyNew)->MPC_NodeQual.Pos, yyt->MPC_NodeQual.Pos)
copytPosition ((* yyNew)->MPC_NodeQual.EndPos, yyt->MPC_NodeQual.EndPos)
yyt = yyt->MPC_NodeQual.CapacityExpr;
yyNew = & (* yyNew)->MPC_NodeQual.CapacityExpr; break;
case kMPC_NodeTypeQual: (* yyNew)->MPC_NodeTypeQual = yyt->MPC_NodeTypeQual;
copytPosition ((* yyNew)->MPC_NodeTypeQual.Pos, yyt->MPC_NodeTypeQual.Pos)
copytPosition ((* yyNew)->MPC_NodeTypeQual.EndPos, yyt->MPC_NodeTypeQual.EndPos)
copybool ((* yyNew)->MPC_NodeTypeQual.Fast, yyt->MPC_NodeTypeQual.Fast)
copyint ((* yyNew)->MPC_NodeTypeQual.Capacity, yyt->MPC_NodeTypeQual.Capacity)
yyt = yyt->MPC_NodeTypeQual.CapacityExpr;
yyNew = & (* yyNew)->MPC_NodeTypeQual.CapacityExpr; break;
case kMPC_BenchQual: (* yyNew)->MPC_BenchQual = yyt->MPC_BenchQual;
copytPosition ((* yyNew)->MPC_BenchQual.Pos, yyt->MPC_BenchQual.Pos)
copytPosition ((* yyNew)->MPC_BenchQual.EndPos, yyt->MPC_BenchQual.EndPos)
copydouble ((* yyNew)->MPC_BenchQual.Capacity, yyt->MPC_BenchQual.Capacity)
yyt = yyt->MPC_BenchQual.CapacityExpr;
yyNew = & (* yyNew)->MPC_BenchQual.CapacityExpr; break;
case kMPC_LinkDecl: (* yyNew)->MPC_LinkDecl = yyt->MPC_LinkDecl;
copytPosition ((* yyNew)->MPC_LinkDecl.Pos, yyt->MPC_LinkDecl.Pos)
copytTree ((* yyNew)->MPC_LinkDecl.FreeCoord, yyt->MPC_LinkDecl.FreeCoord)
copytPosition ((* yyNew)->MPC_LinkDecl.EndPos, yyt->MPC_LinkDecl.EndPos)
yyt = yyt->MPC_LinkDecl.LinkDeclaringList;
yyNew = & (* yyNew)->MPC_LinkDecl.LinkDeclaringList; break;
case kMPC_LinkDeclaringList: (* yyNew)->MPC_LinkDeclaringList = yyt->MPC_LinkDeclaringList;
copytPosition ((* yyNew)->MPC_LinkDeclaringList.Pos, yyt->MPC_LinkDeclaringList.Pos)
copytLinkType ((* yyNew)->MPC_LinkDeclaringList.LinkType, yyt->MPC_LinkDeclaringList.LinkType)
copybool ((* yyNew)->MPC_LinkDeclaringList.DynamicLength, yyt->MPC_LinkDeclaringList.DynamicLength)
copytTree ((* yyNew)->MPC_LinkDeclaringList.Prev, yyt->MPC_LinkDeclaringList.Prev)
copytTree ((* yyNew)->MPC_LinkDeclaringList.Predicate, yyt->MPC_LinkDeclaringList.Predicate)
copytTree ((* yyNew)->MPC_LinkDeclaringList.LinkLengthSpecifier, yyt->MPC_LinkDeclaringList.LinkLengthSpecifier)
copytTree ((* yyNew)->MPC_LinkDeclaringList.LinkDeclarator, yyt->MPC_LinkDeclaringList.LinkDeclarator)
copytPosition ((* yyNew)->MPC_LinkDeclaringList.EndPos, yyt->MPC_LinkDeclaringList.EndPos)
yyt = yyt->MPC_LinkDeclaringList.Next;
yyNew = & (* yyNew)->MPC_LinkDeclaringList.Next; break;
case kMPC_LinkDeclarator: (* yyNew)->MPC_LinkDeclarator = yyt->MPC_LinkDeclarator;
copytPosition ((* yyNew)->MPC_LinkDeclarator.Pos, yyt->MPC_LinkDeclarator.Pos)
copytTree ((* yyNew)->MPC_LinkDeclarator.Prev, yyt->MPC_LinkDeclarator.Prev)
copytTree ((* yyNew)->MPC_LinkDeclarator.LeftNode, yyt->MPC_LinkDeclarator.LeftNode)
copytTree ((* yyNew)->MPC_LinkDeclarator.RightNode, yyt->MPC_LinkDeclarator.RightNode)
copytPosition ((* yyNew)->MPC_LinkDeclarator.EndPos, yyt->MPC_LinkDeclarator.EndPos)
yyt = yyt->MPC_LinkDeclarator.Next;
yyNew = & (* yyNew)->MPC_LinkDeclarator.Next; break;
case kMPC_LinkLengthSpecifier: (* yyNew)->MPC_LinkLengthSpecifier = yyt->MPC_LinkLengthSpecifier;
copytPosition ((* yyNew)->MPC_LinkLengthSpecifier.Pos, yyt->MPC_LinkLengthSpecifier.Pos)
copytLinkType ((* yyNew)->MPC_LinkLengthSpecifier.LinkLength, yyt->MPC_LinkLengthSpecifier.LinkLength)
copytPosition ((* yyNew)->MPC_LinkLengthSpecifier.EndPos, yyt->MPC_LinkLengthSpecifier.EndPos)
yyt = yyt->MPC_LinkLengthSpecifier.LinkLengthExpr;
yyNew = & (* yyNew)->MPC_LinkLengthSpecifier.LinkLengthExpr; break;
case kMPC_Scheme: (* yyNew)->MPC_Scheme = yyt->MPC_Scheme;
copytPosition ((* yyNew)->MPC_Scheme.Pos, yyt->MPC_Scheme.Pos)
copytPosition ((* yyNew)->MPC_Scheme.EndPos, yyt->MPC_Scheme.EndPos)
yyt = yyt->MPC_Scheme.Body;
yyNew = & (* yyNew)->MPC_Scheme.Body; break;
case kMPC_NetList: (* yyNew)->MPC_NetList = yyt->MPC_NetList;
copytTree ((* yyNew)->MPC_NetList.Prev, yyt->MPC_NetList.Prev)
copytTree ((* yyNew)->MPC_NetList.Net, yyt->MPC_NetList.Net)
copytPosition ((* yyNew)->MPC_NetList.Pos, yyt->MPC_NetList.Pos)
copybool ((* yyNew)->MPC_NetList.UnReduceable, yyt->MPC_NetList.UnReduceable)
yyt = yyt->MPC_NetList.Next;
yyNew = & (* yyNew)->MPC_NetList.Next; break;
case kMPC_NetOrSubnet: (* yyNew)->MPC_NetOrSubnet = yyt->MPC_NetOrSubnet;
copytPosition ((* yyNew)->MPC_NetOrSubnet.Pos, yyt->MPC_NetOrSubnet.Pos)
copytIdent ((* yyNew)->MPC_NetOrSubnet.Ident, yyt->MPC_NetOrSubnet.Ident)
copybool ((* yyNew)->MPC_NetOrSubnet.BigCreate, yyt->MPC_NetOrSubnet.BigCreate)
copytTree ((* yyNew)->MPC_NetOrSubnet.Distribution, yyt->MPC_NetOrSubnet.Distribution)
copytTree ((* yyNew)->MPC_NetOrSubnet.Prev, yyt->MPC_NetOrSubnet.Prev)
copytPosition ((* yyNew)->MPC_NetOrSubnet.EndPos, yyt->MPC_NetOrSubnet.EndPos)
copyMPC_unsigned_short ((* yyNew)->MPC_NetOrSubnet.UniqueNumber, yyt->MPC_NetOrSubnet.UniqueNumber)
copybool ((* yyNew)->MPC_NetOrSubnet.WithNumber, yyt->MPC_NetOrSubnet.WithNumber)
copybool ((* yyNew)->MPC_NetOrSubnet.SingleNode, yyt->MPC_NetOrSubnet.SingleNode)
copybool ((* yyNew)->MPC_NetOrSubnet.IsParent, yyt->MPC_NetOrSubnet.IsParent)
copypVoid ((* yyNew)->MPC_NetOrSubnet.pGen, yyt->MPC_NetOrSubnet.pGen)
copytTree ((* yyNew)->MPC_NetOrSubnet.NextUse, yyt->MPC_NetOrSubnet.NextUse)
copytTree ((* yyNew)->MPC_NetOrSubnet.PrevUse, yyt->MPC_NetOrSubnet.PrevUse)
copytTree ((* yyNew)->MPC_NetOrSubnet.MyList, yyt->MPC_NetOrSubnet.MyList)
yyt = yyt->MPC_NetOrSubnet.Next;
yyNew = & (* yyNew)->MPC_NetOrSubnet.Next; break;
case kMPC_Net: (* yyNew)->MPC_Net = yyt->MPC_Net;
copytPosition ((* yyNew)->MPC_Net.Pos, yyt->MPC_Net.Pos)
copytIdent ((* yyNew)->MPC_Net.Ident, yyt->MPC_Net.Ident)
copybool ((* yyNew)->MPC_Net.BigCreate, yyt->MPC_Net.BigCreate)
copytTree ((* yyNew)->MPC_Net.Distribution, yyt->MPC_Net.Distribution)
copytTree ((* yyNew)->MPC_Net.Prev, yyt->MPC_Net.Prev)
copytPosition ((* yyNew)->MPC_Net.EndPos, yyt->MPC_Net.EndPos)
copyMPC_unsigned_short ((* yyNew)->MPC_Net.UniqueNumber, yyt->MPC_Net.UniqueNumber)
copybool ((* yyNew)->MPC_Net.WithNumber, yyt->MPC_Net.WithNumber)
copybool ((* yyNew)->MPC_Net.SingleNode, yyt->MPC_Net.SingleNode)
copybool ((* yyNew)->MPC_Net.IsParent, yyt->MPC_Net.IsParent)
copypVoid ((* yyNew)->MPC_Net.pGen, yyt->MPC_Net.pGen)
copytTree ((* yyNew)->MPC_Net.NextUse, yyt->MPC_Net.NextUse)
copytTree ((* yyNew)->MPC_Net.PrevUse, yyt->MPC_Net.PrevUse)
copytTree ((* yyNew)->MPC_Net.MyList, yyt->MPC_Net.MyList)
copyshort ((* yyNew)->MPC_Net.Topology, yyt->MPC_Net.Topology)
copytTree ((* yyNew)->MPC_Net.NetType, yyt->MPC_Net.NetType)
yyt = yyt->MPC_Net.Next;
yyNew = & (* yyNew)->MPC_Net.Next; break;
case kMPC_Subnet: (* yyNew)->MPC_Subnet = yyt->MPC_Subnet;
copytPosition ((* yyNew)->MPC_Subnet.Pos, yyt->MPC_Subnet.Pos)
copytIdent ((* yyNew)->MPC_Subnet.Ident, yyt->MPC_Subnet.Ident)
copybool ((* yyNew)->MPC_Subnet.BigCreate, yyt->MPC_Subnet.BigCreate)
copytTree ((* yyNew)->MPC_Subnet.Distribution, yyt->MPC_Subnet.Distribution)
copytTree ((* yyNew)->MPC_Subnet.Prev, yyt->MPC_Subnet.Prev)
copytPosition ((* yyNew)->MPC_Subnet.EndPos, yyt->MPC_Subnet.EndPos)
copyMPC_unsigned_short ((* yyNew)->MPC_Subnet.UniqueNumber, yyt->MPC_Subnet.UniqueNumber)
copybool ((* yyNew)->MPC_Subnet.WithNumber, yyt->MPC_Subnet.WithNumber)
copybool ((* yyNew)->MPC_Subnet.SingleNode, yyt->MPC_Subnet.SingleNode)
copybool ((* yyNew)->MPC_Subnet.IsParent, yyt->MPC_Subnet.IsParent)
copypVoid ((* yyNew)->MPC_Subnet.pGen, yyt->MPC_Subnet.pGen)
copytTree ((* yyNew)->MPC_Subnet.NextUse, yyt->MPC_Subnet.NextUse)
copytTree ((* yyNew)->MPC_Subnet.PrevUse, yyt->MPC_Subnet.PrevUse)
copytTree ((* yyNew)->MPC_Subnet.MyList, yyt->MPC_Subnet.MyList)
copytIdent ((* yyNew)->MPC_Subnet.NetOrSubnetName, yyt->MPC_Subnet.NetOrSubnetName)
copybool ((* yyNew)->MPC_Subnet.Flexible, yyt->MPC_Subnet.Flexible)
copytTree ((* yyNew)->MPC_Subnet.Predicate, yyt->MPC_Subnet.Predicate)
yyt = yyt->MPC_Subnet.Next;
yyNew = & (* yyNew)->MPC_Subnet.Next; break;
case kMPC_Relation: (* yyNew)->MPC_Relation = yyt->MPC_Relation;
copytPosition ((* yyNew)->MPC_Relation.Pos, yyt->MPC_Relation.Pos)
copyint ((* yyNew)->MPC_Relation.RelCode, yyt->MPC_Relation.RelCode)
copytTree ((* yyNew)->MPC_Relation.Prev, yyt->MPC_Relation.Prev)
copytTree ((* yyNew)->MPC_Relation.LNet, yyt->MPC_Relation.LNet)
copytTree ((* yyNew)->MPC_Relation.RNet, yyt->MPC_Relation.RNet)
copytPosition ((* yyNew)->MPC_Relation.EndPos, yyt->MPC_Relation.EndPos)
yyt = yyt->MPC_Relation.Next;
yyNew = & (* yyNew)->MPC_Relation.Next; break;
case kMPC_Stats: (* yyNew)->MPC_Stats = yyt->MPC_Stats;
copytPosition ((* yyNew)->MPC_Stats.Pos, yyt->MPC_Stats.Pos)
copytTree ((* yyNew)->MPC_Stats.Prev, yyt->MPC_Stats.Prev)
copytPosition ((* yyNew)->MPC_Stats.EndPos, yyt->MPC_Stats.EndPos)
yyt = yyt->MPC_Stats.Next;
yyNew = & (* yyNew)->MPC_Stats.Next; break;
case kMPC_Stat: (* yyNew)->MPC_Stat = yyt->MPC_Stat;
copytPosition ((* yyNew)->MPC_Stat.Pos, yyt->MPC_Stat.Pos)
copytTree ((* yyNew)->MPC_Stat.Prev, yyt->MPC_Stat.Prev)
copytPosition ((* yyNew)->MPC_Stat.EndPos, yyt->MPC_Stat.EndPos)
copytStatFlags ((* yyNew)->MPC_Stat.Flag, yyt->MPC_Stat.Flag)
copytTree ((* yyNew)->MPC_Stat.ExecNet, yyt->MPC_Stat.ExecNet)
copytTree ((* yyNew)->MPC_Stat.ActualExecNet, yyt->MPC_Stat.ActualExecNet)
copytTree ((* yyNew)->MPC_Stat.RootNet, yyt->MPC_Stat.RootNet)
copytTree ((* yyNew)->MPC_Stat.PropNet, yyt->MPC_Stat.PropNet)
copybool ((* yyNew)->MPC_Stat.Benchmark, yyt->MPC_Stat.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Stat.UniqueNumber, yyt->MPC_Stat.UniqueNumber)
yyt = yyt->MPC_Stat.Next;
yyNew = & (* yyNew)->MPC_Stat.Next; break;
case kMPC_ExprStat: (* yyNew)->MPC_ExprStat = yyt->MPC_ExprStat;
copytPosition ((* yyNew)->MPC_ExprStat.Pos, yyt->MPC_ExprStat.Pos)
copytTree ((* yyNew)->MPC_ExprStat.Prev, yyt->MPC_ExprStat.Prev)
copytPosition ((* yyNew)->MPC_ExprStat.EndPos, yyt->MPC_ExprStat.EndPos)
copytStatFlags ((* yyNew)->MPC_ExprStat.Flag, yyt->MPC_ExprStat.Flag)
copytTree ((* yyNew)->MPC_ExprStat.ExecNet, yyt->MPC_ExprStat.ExecNet)
copytTree ((* yyNew)->MPC_ExprStat.ActualExecNet, yyt->MPC_ExprStat.ActualExecNet)
copytTree ((* yyNew)->MPC_ExprStat.RootNet, yyt->MPC_ExprStat.RootNet)
copytTree ((* yyNew)->MPC_ExprStat.PropNet, yyt->MPC_ExprStat.PropNet)
copybool ((* yyNew)->MPC_ExprStat.Benchmark, yyt->MPC_ExprStat.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_ExprStat.UniqueNumber, yyt->MPC_ExprStat.UniqueNumber)
copytTree ((* yyNew)->MPC_ExprStat.Expr, yyt->MPC_ExprStat.Expr)
yyt = yyt->MPC_ExprStat.Next;
yyNew = & (* yyNew)->MPC_ExprStat.Next; break;
case kMPC_If: (* yyNew)->MPC_If = yyt->MPC_If;
copytPosition ((* yyNew)->MPC_If.Pos, yyt->MPC_If.Pos)
copytTree ((* yyNew)->MPC_If.Prev, yyt->MPC_If.Prev)
copytPosition ((* yyNew)->MPC_If.EndPos, yyt->MPC_If.EndPos)
copytStatFlags ((* yyNew)->MPC_If.Flag, yyt->MPC_If.Flag)
copytTree ((* yyNew)->MPC_If.ExecNet, yyt->MPC_If.ExecNet)
copytTree ((* yyNew)->MPC_If.ActualExecNet, yyt->MPC_If.ActualExecNet)
copytTree ((* yyNew)->MPC_If.RootNet, yyt->MPC_If.RootNet)
copytTree ((* yyNew)->MPC_If.PropNet, yyt->MPC_If.PropNet)
copybool ((* yyNew)->MPC_If.Benchmark, yyt->MPC_If.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_If.UniqueNumber, yyt->MPC_If.UniqueNumber)
copytTree ((* yyNew)->MPC_If.Expr, yyt->MPC_If.Expr)
copytTree ((* yyNew)->MPC_If.Stats, yyt->MPC_If.Stats)
yyt = yyt->MPC_If.Next;
yyNew = & (* yyNew)->MPC_If.Next; break;
case kMPC_IfElse: (* yyNew)->MPC_IfElse = yyt->MPC_IfElse;
copytPosition ((* yyNew)->MPC_IfElse.Pos, yyt->MPC_IfElse.Pos)
copytTree ((* yyNew)->MPC_IfElse.Prev, yyt->MPC_IfElse.Prev)
copytPosition ((* yyNew)->MPC_IfElse.EndPos, yyt->MPC_IfElse.EndPos)
copytStatFlags ((* yyNew)->MPC_IfElse.Flag, yyt->MPC_IfElse.Flag)
copytTree ((* yyNew)->MPC_IfElse.ExecNet, yyt->MPC_IfElse.ExecNet)
copytTree ((* yyNew)->MPC_IfElse.ActualExecNet, yyt->MPC_IfElse.ActualExecNet)
copytTree ((* yyNew)->MPC_IfElse.RootNet, yyt->MPC_IfElse.RootNet)
copytTree ((* yyNew)->MPC_IfElse.PropNet, yyt->MPC_IfElse.PropNet)
copybool ((* yyNew)->MPC_IfElse.Benchmark, yyt->MPC_IfElse.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_IfElse.UniqueNumber, yyt->MPC_IfElse.UniqueNumber)
copytTree ((* yyNew)->MPC_IfElse.Expr, yyt->MPC_IfElse.Expr)
copytTree ((* yyNew)->MPC_IfElse.Then, yyt->MPC_IfElse.Then)
copytTree ((* yyNew)->MPC_IfElse.Else, yyt->MPC_IfElse.Else)
yyt = yyt->MPC_IfElse.Next;
yyNew = & (* yyNew)->MPC_IfElse.Next; break;
case kMPC_Switch: (* yyNew)->MPC_Switch = yyt->MPC_Switch;
copytPosition ((* yyNew)->MPC_Switch.Pos, yyt->MPC_Switch.Pos)
copytTree ((* yyNew)->MPC_Switch.Prev, yyt->MPC_Switch.Prev)
copytPosition ((* yyNew)->MPC_Switch.EndPos, yyt->MPC_Switch.EndPos)
copytStatFlags ((* yyNew)->MPC_Switch.Flag, yyt->MPC_Switch.Flag)
copytTree ((* yyNew)->MPC_Switch.ExecNet, yyt->MPC_Switch.ExecNet)
copytTree ((* yyNew)->MPC_Switch.ActualExecNet, yyt->MPC_Switch.ActualExecNet)
copytTree ((* yyNew)->MPC_Switch.RootNet, yyt->MPC_Switch.RootNet)
copytTree ((* yyNew)->MPC_Switch.PropNet, yyt->MPC_Switch.PropNet)
copybool ((* yyNew)->MPC_Switch.Benchmark, yyt->MPC_Switch.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Switch.UniqueNumber, yyt->MPC_Switch.UniqueNumber)
copytTree ((* yyNew)->MPC_Switch.Expr, yyt->MPC_Switch.Expr)
copytTree ((* yyNew)->MPC_Switch.Stats, yyt->MPC_Switch.Stats)
yyt = yyt->MPC_Switch.Next;
yyNew = & (* yyNew)->MPC_Switch.Next; break;
case kMPC_While: (* yyNew)->MPC_While = yyt->MPC_While;
copytPosition ((* yyNew)->MPC_While.Pos, yyt->MPC_While.Pos)
copytTree ((* yyNew)->MPC_While.Prev, yyt->MPC_While.Prev)
copytPosition ((* yyNew)->MPC_While.EndPos, yyt->MPC_While.EndPos)
copytStatFlags ((* yyNew)->MPC_While.Flag, yyt->MPC_While.Flag)
copytTree ((* yyNew)->MPC_While.ExecNet, yyt->MPC_While.ExecNet)
copytTree ((* yyNew)->MPC_While.ActualExecNet, yyt->MPC_While.ActualExecNet)
copytTree ((* yyNew)->MPC_While.RootNet, yyt->MPC_While.RootNet)
copytTree ((* yyNew)->MPC_While.PropNet, yyt->MPC_While.PropNet)
copybool ((* yyNew)->MPC_While.Benchmark, yyt->MPC_While.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_While.UniqueNumber, yyt->MPC_While.UniqueNumber)
copytTree ((* yyNew)->MPC_While.Expr, yyt->MPC_While.Expr)
copytTree ((* yyNew)->MPC_While.Stats, yyt->MPC_While.Stats)
yyt = yyt->MPC_While.Next;
yyNew = & (* yyNew)->MPC_While.Next; break;
case kMPC_DoWhile: (* yyNew)->MPC_DoWhile = yyt->MPC_DoWhile;
copytPosition ((* yyNew)->MPC_DoWhile.Pos, yyt->MPC_DoWhile.Pos)
copytTree ((* yyNew)->MPC_DoWhile.Prev, yyt->MPC_DoWhile.Prev)
copytPosition ((* yyNew)->MPC_DoWhile.EndPos, yyt->MPC_DoWhile.EndPos)
copytStatFlags ((* yyNew)->MPC_DoWhile.Flag, yyt->MPC_DoWhile.Flag)
copytTree ((* yyNew)->MPC_DoWhile.ExecNet, yyt->MPC_DoWhile.ExecNet)
copytTree ((* yyNew)->MPC_DoWhile.ActualExecNet, yyt->MPC_DoWhile.ActualExecNet)
copytTree ((* yyNew)->MPC_DoWhile.RootNet, yyt->MPC_DoWhile.RootNet)
copytTree ((* yyNew)->MPC_DoWhile.PropNet, yyt->MPC_DoWhile.PropNet)
copybool ((* yyNew)->MPC_DoWhile.Benchmark, yyt->MPC_DoWhile.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_DoWhile.UniqueNumber, yyt->MPC_DoWhile.UniqueNumber)
copytTree ((* yyNew)->MPC_DoWhile.Stats, yyt->MPC_DoWhile.Stats)
copytTree ((* yyNew)->MPC_DoWhile.Expr, yyt->MPC_DoWhile.Expr)
yyt = yyt->MPC_DoWhile.Next;
yyNew = & (* yyNew)->MPC_DoWhile.Next; break;
case kMPC_For: (* yyNew)->MPC_For = yyt->MPC_For;
copytPosition ((* yyNew)->MPC_For.Pos, yyt->MPC_For.Pos)
copytTree ((* yyNew)->MPC_For.Prev, yyt->MPC_For.Prev)
copytPosition ((* yyNew)->MPC_For.EndPos, yyt->MPC_For.EndPos)
copytStatFlags ((* yyNew)->MPC_For.Flag, yyt->MPC_For.Flag)
copytTree ((* yyNew)->MPC_For.ExecNet, yyt->MPC_For.ExecNet)
copytTree ((* yyNew)->MPC_For.ActualExecNet, yyt->MPC_For.ActualExecNet)
copytTree ((* yyNew)->MPC_For.RootNet, yyt->MPC_For.RootNet)
copytTree ((* yyNew)->MPC_For.PropNet, yyt->MPC_For.PropNet)
copybool ((* yyNew)->MPC_For.Benchmark, yyt->MPC_For.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_For.UniqueNumber, yyt->MPC_For.UniqueNumber)
copytTree ((* yyNew)->MPC_For.Init, yyt->MPC_For.Init)
copytTree ((* yyNew)->MPC_For.Cond, yyt->MPC_For.Cond)
copytTree ((* yyNew)->MPC_For.Reinit, yyt->MPC_For.Reinit)
copytTree ((* yyNew)->MPC_For.Stats, yyt->MPC_For.Stats)
yyt = yyt->MPC_For.Next;
yyNew = & (* yyNew)->MPC_For.Next; break;
case kMPC_Goto: (* yyNew)->MPC_Goto = yyt->MPC_Goto;
copytPosition ((* yyNew)->MPC_Goto.Pos, yyt->MPC_Goto.Pos)
copytTree ((* yyNew)->MPC_Goto.Prev, yyt->MPC_Goto.Prev)
copytPosition ((* yyNew)->MPC_Goto.EndPos, yyt->MPC_Goto.EndPos)
copytStatFlags ((* yyNew)->MPC_Goto.Flag, yyt->MPC_Goto.Flag)
copytTree ((* yyNew)->MPC_Goto.ExecNet, yyt->MPC_Goto.ExecNet)
copytTree ((* yyNew)->MPC_Goto.ActualExecNet, yyt->MPC_Goto.ActualExecNet)
copytTree ((* yyNew)->MPC_Goto.RootNet, yyt->MPC_Goto.RootNet)
copytTree ((* yyNew)->MPC_Goto.PropNet, yyt->MPC_Goto.PropNet)
copybool ((* yyNew)->MPC_Goto.Benchmark, yyt->MPC_Goto.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Goto.UniqueNumber, yyt->MPC_Goto.UniqueNumber)
copytIdent ((* yyNew)->MPC_Goto.Ident, yyt->MPC_Goto.Ident)
copytTree ((* yyNew)->MPC_Goto.LabelDef, yyt->MPC_Goto.LabelDef)
copytTree ((* yyNew)->MPC_Goto.NextUse, yyt->MPC_Goto.NextUse)
copytTree ((* yyNew)->MPC_Goto.PrevUse, yyt->MPC_Goto.PrevUse)
yyt = yyt->MPC_Goto.Next;
yyNew = & (* yyNew)->MPC_Goto.Next; break;
case kMPC_Continue: (* yyNew)->MPC_Continue = yyt->MPC_Continue;
copytPosition ((* yyNew)->MPC_Continue.Pos, yyt->MPC_Continue.Pos)
copytTree ((* yyNew)->MPC_Continue.Prev, yyt->MPC_Continue.Prev)
copytPosition ((* yyNew)->MPC_Continue.EndPos, yyt->MPC_Continue.EndPos)
copytStatFlags ((* yyNew)->MPC_Continue.Flag, yyt->MPC_Continue.Flag)
copytTree ((* yyNew)->MPC_Continue.ExecNet, yyt->MPC_Continue.ExecNet)
copytTree ((* yyNew)->MPC_Continue.ActualExecNet, yyt->MPC_Continue.ActualExecNet)
copytTree ((* yyNew)->MPC_Continue.RootNet, yyt->MPC_Continue.RootNet)
copytTree ((* yyNew)->MPC_Continue.PropNet, yyt->MPC_Continue.PropNet)
copybool ((* yyNew)->MPC_Continue.Benchmark, yyt->MPC_Continue.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Continue.UniqueNumber, yyt->MPC_Continue.UniqueNumber)
yyt = yyt->MPC_Continue.Next;
yyNew = & (* yyNew)->MPC_Continue.Next; break;
case kMPC_Break: (* yyNew)->MPC_Break = yyt->MPC_Break;
copytPosition ((* yyNew)->MPC_Break.Pos, yyt->MPC_Break.Pos)
copytTree ((* yyNew)->MPC_Break.Prev, yyt->MPC_Break.Prev)
copytPosition ((* yyNew)->MPC_Break.EndPos, yyt->MPC_Break.EndPos)
copytStatFlags ((* yyNew)->MPC_Break.Flag, yyt->MPC_Break.Flag)
copytTree ((* yyNew)->MPC_Break.ExecNet, yyt->MPC_Break.ExecNet)
copytTree ((* yyNew)->MPC_Break.ActualExecNet, yyt->MPC_Break.ActualExecNet)
copytTree ((* yyNew)->MPC_Break.RootNet, yyt->MPC_Break.RootNet)
copytTree ((* yyNew)->MPC_Break.PropNet, yyt->MPC_Break.PropNet)
copybool ((* yyNew)->MPC_Break.Benchmark, yyt->MPC_Break.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Break.UniqueNumber, yyt->MPC_Break.UniqueNumber)
yyt = yyt->MPC_Break.Next;
yyNew = & (* yyNew)->MPC_Break.Next; break;
case kMPC_BreakFan: (* yyNew)->MPC_BreakFan = yyt->MPC_BreakFan;
copytPosition ((* yyNew)->MPC_BreakFan.Pos, yyt->MPC_BreakFan.Pos)
copytTree ((* yyNew)->MPC_BreakFan.Prev, yyt->MPC_BreakFan.Prev)
copytPosition ((* yyNew)->MPC_BreakFan.EndPos, yyt->MPC_BreakFan.EndPos)
copytStatFlags ((* yyNew)->MPC_BreakFan.Flag, yyt->MPC_BreakFan.Flag)
copytTree ((* yyNew)->MPC_BreakFan.ExecNet, yyt->MPC_BreakFan.ExecNet)
copytTree ((* yyNew)->MPC_BreakFan.ActualExecNet, yyt->MPC_BreakFan.ActualExecNet)
copytTree ((* yyNew)->MPC_BreakFan.RootNet, yyt->MPC_BreakFan.RootNet)
copytTree ((* yyNew)->MPC_BreakFan.PropNet, yyt->MPC_BreakFan.PropNet)
copybool ((* yyNew)->MPC_BreakFan.Benchmark, yyt->MPC_BreakFan.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_BreakFan.UniqueNumber, yyt->MPC_BreakFan.UniqueNumber)
yyt = yyt->MPC_BreakFan.Next;
yyNew = & (* yyNew)->MPC_BreakFan.Next; break;
case kMPC_Return: (* yyNew)->MPC_Return = yyt->MPC_Return;
copytPosition ((* yyNew)->MPC_Return.Pos, yyt->MPC_Return.Pos)
copytTree ((* yyNew)->MPC_Return.Prev, yyt->MPC_Return.Prev)
copytPosition ((* yyNew)->MPC_Return.EndPos, yyt->MPC_Return.EndPos)
copytStatFlags ((* yyNew)->MPC_Return.Flag, yyt->MPC_Return.Flag)
copytTree ((* yyNew)->MPC_Return.ExecNet, yyt->MPC_Return.ExecNet)
copytTree ((* yyNew)->MPC_Return.ActualExecNet, yyt->MPC_Return.ActualExecNet)
copytTree ((* yyNew)->MPC_Return.RootNet, yyt->MPC_Return.RootNet)
copytTree ((* yyNew)->MPC_Return.PropNet, yyt->MPC_Return.PropNet)
copybool ((* yyNew)->MPC_Return.Benchmark, yyt->MPC_Return.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Return.UniqueNumber, yyt->MPC_Return.UniqueNumber)
copytTree ((* yyNew)->MPC_Return.Expr, yyt->MPC_Return.Expr)
yyt = yyt->MPC_Return.Next;
yyNew = & (* yyNew)->MPC_Return.Next; break;
case kMPC_Compound: (* yyNew)->MPC_Compound = yyt->MPC_Compound;
copytPosition ((* yyNew)->MPC_Compound.Pos, yyt->MPC_Compound.Pos)
copytTree ((* yyNew)->MPC_Compound.Prev, yyt->MPC_Compound.Prev)
copytPosition ((* yyNew)->MPC_Compound.EndPos, yyt->MPC_Compound.EndPos)
copytStatFlags ((* yyNew)->MPC_Compound.Flag, yyt->MPC_Compound.Flag)
copytTree ((* yyNew)->MPC_Compound.ExecNet, yyt->MPC_Compound.ExecNet)
copytTree ((* yyNew)->MPC_Compound.ActualExecNet, yyt->MPC_Compound.ActualExecNet)
copytTree ((* yyNew)->MPC_Compound.RootNet, yyt->MPC_Compound.RootNet)
copytTree ((* yyNew)->MPC_Compound.PropNet, yyt->MPC_Compound.PropNet)
copybool ((* yyNew)->MPC_Compound.Benchmark, yyt->MPC_Compound.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Compound.UniqueNumber, yyt->MPC_Compound.UniqueNumber)
copyint ((* yyNew)->MPC_Compound.FunctionBody, yyt->MPC_Compound.FunctionBody)
copytTree ((* yyNew)->MPC_Compound.Decls, yyt->MPC_Compound.Decls)
copytTree ((* yyNew)->MPC_Compound.Stats, yyt->MPC_Compound.Stats)
yyt = yyt->MPC_Compound.Next;
yyNew = & (* yyNew)->MPC_Compound.Next; break;
case kMPC_CompScheme: (* yyNew)->MPC_CompScheme = yyt->MPC_CompScheme;
copytPosition ((* yyNew)->MPC_CompScheme.Pos, yyt->MPC_CompScheme.Pos)
copytTree ((* yyNew)->MPC_CompScheme.Prev, yyt->MPC_CompScheme.Prev)
copytPosition ((* yyNew)->MPC_CompScheme.EndPos, yyt->MPC_CompScheme.EndPos)
copytStatFlags ((* yyNew)->MPC_CompScheme.Flag, yyt->MPC_CompScheme.Flag)
copytTree ((* yyNew)->MPC_CompScheme.ExecNet, yyt->MPC_CompScheme.ExecNet)
copytTree ((* yyNew)->MPC_CompScheme.ActualExecNet, yyt->MPC_CompScheme.ActualExecNet)
copytTree ((* yyNew)->MPC_CompScheme.RootNet, yyt->MPC_CompScheme.RootNet)
copytTree ((* yyNew)->MPC_CompScheme.PropNet, yyt->MPC_CompScheme.PropNet)
copybool ((* yyNew)->MPC_CompScheme.Benchmark, yyt->MPC_CompScheme.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_CompScheme.UniqueNumber, yyt->MPC_CompScheme.UniqueNumber)
copytTree ((* yyNew)->MPC_CompScheme.Expr, yyt->MPC_CompScheme.Expr)
copytTree ((* yyNew)->MPC_CompScheme.Node, yyt->MPC_CompScheme.Node)
yyt = yyt->MPC_CompScheme.Next;
yyNew = & (* yyNew)->MPC_CompScheme.Next; break;
case kMPC_CommScheme: (* yyNew)->MPC_CommScheme = yyt->MPC_CommScheme;
copytPosition ((* yyNew)->MPC_CommScheme.Pos, yyt->MPC_CommScheme.Pos)
copytTree ((* yyNew)->MPC_CommScheme.Prev, yyt->MPC_CommScheme.Prev)
copytPosition ((* yyNew)->MPC_CommScheme.EndPos, yyt->MPC_CommScheme.EndPos)
copytStatFlags ((* yyNew)->MPC_CommScheme.Flag, yyt->MPC_CommScheme.Flag)
copytTree ((* yyNew)->MPC_CommScheme.ExecNet, yyt->MPC_CommScheme.ExecNet)
copytTree ((* yyNew)->MPC_CommScheme.ActualExecNet, yyt->MPC_CommScheme.ActualExecNet)
copytTree ((* yyNew)->MPC_CommScheme.RootNet, yyt->MPC_CommScheme.RootNet)
copytTree ((* yyNew)->MPC_CommScheme.PropNet, yyt->MPC_CommScheme.PropNet)
copybool ((* yyNew)->MPC_CommScheme.Benchmark, yyt->MPC_CommScheme.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_CommScheme.UniqueNumber, yyt->MPC_CommScheme.UniqueNumber)
copytTree ((* yyNew)->MPC_CommScheme.Expr, yyt->MPC_CommScheme.Expr)
copytTree ((* yyNew)->MPC_CommScheme.From, yyt->MPC_CommScheme.From)
copytTree ((* yyNew)->MPC_CommScheme.To, yyt->MPC_CommScheme.To)
yyt = yyt->MPC_CommScheme.Next;
yyNew = & (* yyNew)->MPC_CommScheme.Next; break;
case kMPC_ParScheme: (* yyNew)->MPC_ParScheme = yyt->MPC_ParScheme;
copytPosition ((* yyNew)->MPC_ParScheme.Pos, yyt->MPC_ParScheme.Pos)
copytTree ((* yyNew)->MPC_ParScheme.Prev, yyt->MPC_ParScheme.Prev)
copytPosition ((* yyNew)->MPC_ParScheme.EndPos, yyt->MPC_ParScheme.EndPos)
copytStatFlags ((* yyNew)->MPC_ParScheme.Flag, yyt->MPC_ParScheme.Flag)
copytTree ((* yyNew)->MPC_ParScheme.ExecNet, yyt->MPC_ParScheme.ExecNet)
copytTree ((* yyNew)->MPC_ParScheme.ActualExecNet, yyt->MPC_ParScheme.ActualExecNet)
copytTree ((* yyNew)->MPC_ParScheme.RootNet, yyt->MPC_ParScheme.RootNet)
copytTree ((* yyNew)->MPC_ParScheme.PropNet, yyt->MPC_ParScheme.PropNet)
copybool ((* yyNew)->MPC_ParScheme.Benchmark, yyt->MPC_ParScheme.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_ParScheme.UniqueNumber, yyt->MPC_ParScheme.UniqueNumber)
copytTree ((* yyNew)->MPC_ParScheme.Init, yyt->MPC_ParScheme.Init)
copytTree ((* yyNew)->MPC_ParScheme.Cond, yyt->MPC_ParScheme.Cond)
copytTree ((* yyNew)->MPC_ParScheme.Reinit, yyt->MPC_ParScheme.Reinit)
copytTree ((* yyNew)->MPC_ParScheme.Stats, yyt->MPC_ParScheme.Stats)
yyt = yyt->MPC_ParScheme.Next;
yyNew = & (* yyNew)->MPC_ParScheme.Next; break;
case kMPC_Fan: (* yyNew)->MPC_Fan = yyt->MPC_Fan;
copytPosition ((* yyNew)->MPC_Fan.Pos, yyt->MPC_Fan.Pos)
copytTree ((* yyNew)->MPC_Fan.Prev, yyt->MPC_Fan.Prev)
copytPosition ((* yyNew)->MPC_Fan.EndPos, yyt->MPC_Fan.EndPos)
copytStatFlags ((* yyNew)->MPC_Fan.Flag, yyt->MPC_Fan.Flag)
copytTree ((* yyNew)->MPC_Fan.ExecNet, yyt->MPC_Fan.ExecNet)
copytTree ((* yyNew)->MPC_Fan.ActualExecNet, yyt->MPC_Fan.ActualExecNet)
copytTree ((* yyNew)->MPC_Fan.RootNet, yyt->MPC_Fan.RootNet)
copytTree ((* yyNew)->MPC_Fan.PropNet, yyt->MPC_Fan.PropNet)
copybool ((* yyNew)->MPC_Fan.Benchmark, yyt->MPC_Fan.Benchmark)
copyMPC_unsigned_short ((* yyNew)->MPC_Fan.UniqueNumber, yyt->MPC_Fan.UniqueNumber)
copytTree ((* yyNew)->MPC_Fan.Body, yyt->MPC_Fan.Body)
yyt = yyt->MPC_Fan.Next;
yyNew = & (* yyNew)->MPC_Fan.Next; break;
case kMPC_Label: (* yyNew)->MPC_Label = yyt->MPC_Label;
copytPosition ((* yyNew)->MPC_Label.Pos, yyt->MPC_Label.Pos)
copytTree ((* yyNew)->MPC_Label.Prev, yyt->MPC_Label.Prev)
copytPosition ((* yyNew)->MPC_Label.EndPos, yyt->MPC_Label.EndPos)
copytTree ((* yyNew)->MPC_Label.NextLabel, yyt->MPC_Label.NextLabel)
copytTree ((* yyNew)->MPC_Label.PrevLabel, yyt->MPC_Label.PrevLabel)
yyt = yyt->MPC_Label.Next;
yyNew = & (* yyNew)->MPC_Label.Next; break;
case kMPC_IdentLabel: (* yyNew)->MPC_IdentLabel = yyt->MPC_IdentLabel;
copytPosition ((* yyNew)->MPC_IdentLabel.Pos, yyt->MPC_IdentLabel.Pos)
copytTree ((* yyNew)->MPC_IdentLabel.Prev, yyt->MPC_IdentLabel.Prev)
copytPosition ((* yyNew)->MPC_IdentLabel.EndPos, yyt->MPC_IdentLabel.EndPos)
copytTree ((* yyNew)->MPC_IdentLabel.NextLabel, yyt->MPC_IdentLabel.NextLabel)
copytTree ((* yyNew)->MPC_IdentLabel.PrevLabel, yyt->MPC_IdentLabel.PrevLabel)
copytIdent ((* yyNew)->MPC_IdentLabel.Ident, yyt->MPC_IdentLabel.Ident)
copytTree ((* yyNew)->MPC_IdentLabel.NextUse, yyt->MPC_IdentLabel.NextUse)
copybool ((* yyNew)->MPC_IdentLabel.Used, yyt->MPC_IdentLabel.Used)
yyt = yyt->MPC_IdentLabel.Next;
yyNew = & (* yyNew)->MPC_IdentLabel.Next; break;
case kMPC_CaseLabel: (* yyNew)->MPC_CaseLabel = yyt->MPC_CaseLabel;
copytPosition ((* yyNew)->MPC_CaseLabel.Pos, yyt->MPC_CaseLabel.Pos)
copytTree ((* yyNew)->MPC_CaseLabel.Prev, yyt->MPC_CaseLabel.Prev)
copytPosition ((* yyNew)->MPC_CaseLabel.EndPos, yyt->MPC_CaseLabel.EndPos)
copytTree ((* yyNew)->MPC_CaseLabel.NextLabel, yyt->MPC_CaseLabel.NextLabel)
copytTree ((* yyNew)->MPC_CaseLabel.PrevLabel, yyt->MPC_CaseLabel.PrevLabel)
copylong ((* yyNew)->MPC_CaseLabel.CaseValue, yyt->MPC_CaseLabel.CaseValue)
copytTree ((* yyNew)->MPC_CaseLabel.Expr, yyt->MPC_CaseLabel.Expr)
yyt = yyt->MPC_CaseLabel.Next;
yyNew = & (* yyNew)->MPC_CaseLabel.Next; break;
case kMPC_Default: (* yyNew)->MPC_Default = yyt->MPC_Default;
copytPosition ((* yyNew)->MPC_Default.Pos, yyt->MPC_Default.Pos)
copytTree ((* yyNew)->MPC_Default.Prev, yyt->MPC_Default.Prev)
copytPosition ((* yyNew)->MPC_Default.EndPos, yyt->MPC_Default.EndPos)
copytTree ((* yyNew)->MPC_Default.NextLabel, yyt->MPC_Default.NextLabel)
copytTree ((* yyNew)->MPC_Default.PrevLabel, yyt->MPC_Default.PrevLabel)
yyt = yyt->MPC_Default.Next;
yyNew = & (* yyNew)->MPC_Default.Next; break;
case kMPC_Expr: (* yyNew)->MPC_Expr = yyt->MPC_Expr;
copytPosition ((* yyNew)->MPC_Expr.Pos, yyt->MPC_Expr.Pos)
copytExprFlags ((* yyNew)->MPC_Expr.Flag, yyt->MPC_Expr.Flag)
copytString ((* yyNew)->MPC_Expr.TmpName, yyt->MPC_Expr.TmpName)
copytTree ((* yyNew)->MPC_Expr.Type, yyt->MPC_Expr.Type)
copytTree ((* yyNew)->MPC_Expr.EvalNet, yyt->MPC_Expr.EvalNet)
copytTree ((* yyNew)->MPC_Expr.StoreNet, yyt->MPC_Expr.StoreNet)
copytPosition ((* yyNew)->MPC_Expr.BegPos, yyt->MPC_Expr.BegPos)
copytPosition ((* yyNew)->MPC_Expr.EndPos, yyt->MPC_Expr.EndPos)
copychar ((* yyNew)->MPC_Expr.Pass, yyt->MPC_Expr.Pass)
copybool ((* yyNew)->MPC_Expr.Repl, yyt->MPC_Expr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_Expr.Optm_Attribute, yyt->MPC_Expr.Optm_Attribute)
yyt = yyt->MPC_Expr.ActualEvalNet;
yyNew = & (* yyNew)->MPC_Expr.ActualEvalNet; break;
case kMPC_Const: (* yyNew)->MPC_Const = yyt->MPC_Const;
copytPosition ((* yyNew)->MPC_Const.Pos, yyt->MPC_Const.Pos)
copytExprFlags ((* yyNew)->MPC_Const.Flag, yyt->MPC_Const.Flag)
copytString ((* yyNew)->MPC_Const.TmpName, yyt->MPC_Const.TmpName)
copytTree ((* yyNew)->MPC_Const.Type, yyt->MPC_Const.Type)
copytTree ((* yyNew)->MPC_Const.EvalNet, yyt->MPC_Const.EvalNet)
copytTree ((* yyNew)->MPC_Const.StoreNet, yyt->MPC_Const.StoreNet)
copytPosition ((* yyNew)->MPC_Const.BegPos, yyt->MPC_Const.BegPos)
copytPosition ((* yyNew)->MPC_Const.EndPos, yyt->MPC_Const.EndPos)
copychar ((* yyNew)->MPC_Const.Pass, yyt->MPC_Const.Pass)
copybool ((* yyNew)->MPC_Const.Repl, yyt->MPC_Const.Repl)
copytOptm_Attribute ((* yyNew)->MPC_Const.Optm_Attribute, yyt->MPC_Const.Optm_Attribute)
copytString ((* yyNew)->MPC_Const.SymbolicForm, yyt->MPC_Const.SymbolicForm)
yyt = yyt->MPC_Const.ActualEvalNet;
yyNew = & (* yyNew)->MPC_Const.ActualEvalNet; break;
case kMPC_IntConst: (* yyNew)->MPC_IntConst = yyt->MPC_IntConst;
copytPosition ((* yyNew)->MPC_IntConst.Pos, yyt->MPC_IntConst.Pos)
copytExprFlags ((* yyNew)->MPC_IntConst.Flag, yyt->MPC_IntConst.Flag)
copytString ((* yyNew)->MPC_IntConst.TmpName, yyt->MPC_IntConst.TmpName)
copytTree ((* yyNew)->MPC_IntConst.Type, yyt->MPC_IntConst.Type)
copytTree ((* yyNew)->MPC_IntConst.EvalNet, yyt->MPC_IntConst.EvalNet)
copytTree ((* yyNew)->MPC_IntConst.StoreNet, yyt->MPC_IntConst.StoreNet)
copytPosition ((* yyNew)->MPC_IntConst.BegPos, yyt->MPC_IntConst.BegPos)
copytPosition ((* yyNew)->MPC_IntConst.EndPos, yyt->MPC_IntConst.EndPos)
copychar ((* yyNew)->MPC_IntConst.Pass, yyt->MPC_IntConst.Pass)
copybool ((* yyNew)->MPC_IntConst.Repl, yyt->MPC_IntConst.Repl)
copytOptm_Attribute ((* yyNew)->MPC_IntConst.Optm_Attribute, yyt->MPC_IntConst.Optm_Attribute)
copytString ((* yyNew)->MPC_IntConst.SymbolicForm, yyt->MPC_IntConst.SymbolicForm)
copylong ((* yyNew)->MPC_IntConst.Value, yyt->MPC_IntConst.Value)
yyt = yyt->MPC_IntConst.ActualEvalNet;
yyNew = & (* yyNew)->MPC_IntConst.ActualEvalNet; break;
case kMPC_UIntConst: (* yyNew)->MPC_UIntConst = yyt->MPC_UIntConst;
copytPosition ((* yyNew)->MPC_UIntConst.Pos, yyt->MPC_UIntConst.Pos)
copytExprFlags ((* yyNew)->MPC_UIntConst.Flag, yyt->MPC_UIntConst.Flag)
copytString ((* yyNew)->MPC_UIntConst.TmpName, yyt->MPC_UIntConst.TmpName)
copytTree ((* yyNew)->MPC_UIntConst.Type, yyt->MPC_UIntConst.Type)
copytTree ((* yyNew)->MPC_UIntConst.EvalNet, yyt->MPC_UIntConst.EvalNet)
copytTree ((* yyNew)->MPC_UIntConst.StoreNet, yyt->MPC_UIntConst.StoreNet)
copytPosition ((* yyNew)->MPC_UIntConst.BegPos, yyt->MPC_UIntConst.BegPos)
copytPosition ((* yyNew)->MPC_UIntConst.EndPos, yyt->MPC_UIntConst.EndPos)
copychar ((* yyNew)->MPC_UIntConst.Pass, yyt->MPC_UIntConst.Pass)
copybool ((* yyNew)->MPC_UIntConst.Repl, yyt->MPC_UIntConst.Repl)
copytOptm_Attribute ((* yyNew)->MPC_UIntConst.Optm_Attribute, yyt->MPC_UIntConst.Optm_Attribute)
copytString ((* yyNew)->MPC_UIntConst.SymbolicForm, yyt->MPC_UIntConst.SymbolicForm)
copyMPC_long_unsigned ((* yyNew)->MPC_UIntConst.Value, yyt->MPC_UIntConst.Value)
yyt = yyt->MPC_UIntConst.ActualEvalNet;
yyNew = & (* yyNew)->MPC_UIntConst.ActualEvalNet; break;
case kMPC_FloatConst: (* yyNew)->MPC_FloatConst = yyt->MPC_FloatConst;
copytPosition ((* yyNew)->MPC_FloatConst.Pos, yyt->MPC_FloatConst.Pos)
copytExprFlags ((* yyNew)->MPC_FloatConst.Flag, yyt->MPC_FloatConst.Flag)
copytString ((* yyNew)->MPC_FloatConst.TmpName, yyt->MPC_FloatConst.TmpName)
copytTree ((* yyNew)->MPC_FloatConst.Type, yyt->MPC_FloatConst.Type)
copytTree ((* yyNew)->MPC_FloatConst.EvalNet, yyt->MPC_FloatConst.EvalNet)
copytTree ((* yyNew)->MPC_FloatConst.StoreNet, yyt->MPC_FloatConst.StoreNet)
copytPosition ((* yyNew)->MPC_FloatConst.BegPos, yyt->MPC_FloatConst.BegPos)
copytPosition ((* yyNew)->MPC_FloatConst.EndPos, yyt->MPC_FloatConst.EndPos)
copychar ((* yyNew)->MPC_FloatConst.Pass, yyt->MPC_FloatConst.Pass)
copybool ((* yyNew)->MPC_FloatConst.Repl, yyt->MPC_FloatConst.Repl)
copytOptm_Attribute ((* yyNew)->MPC_FloatConst.Optm_Attribute, yyt->MPC_FloatConst.Optm_Attribute)
copytString ((* yyNew)->MPC_FloatConst.SymbolicForm, yyt->MPC_FloatConst.SymbolicForm)
copyMPC_long_double ((* yyNew)->MPC_FloatConst.Value, yyt->MPC_FloatConst.Value)
yyt = yyt->MPC_FloatConst.ActualEvalNet;
yyNew = & (* yyNew)->MPC_FloatConst.ActualEvalNet; break;
case kMPC_StringLiteral: (* yyNew)->MPC_StringLiteral = yyt->MPC_StringLiteral;
copytPosition ((* yyNew)->MPC_StringLiteral.Pos, yyt->MPC_StringLiteral.Pos)
copytExprFlags ((* yyNew)->MPC_StringLiteral.Flag, yyt->MPC_StringLiteral.Flag)
copytString ((* yyNew)->MPC_StringLiteral.TmpName, yyt->MPC_StringLiteral.TmpName)
copytTree ((* yyNew)->MPC_StringLiteral.Type, yyt->MPC_StringLiteral.Type)
copytTree ((* yyNew)->MPC_StringLiteral.EvalNet, yyt->MPC_StringLiteral.EvalNet)
copytTree ((* yyNew)->MPC_StringLiteral.StoreNet, yyt->MPC_StringLiteral.StoreNet)
copytPosition ((* yyNew)->MPC_StringLiteral.BegPos, yyt->MPC_StringLiteral.BegPos)
copytPosition ((* yyNew)->MPC_StringLiteral.EndPos, yyt->MPC_StringLiteral.EndPos)
copytTree ((* yyNew)->MPC_StringLiteral.ActualEvalNet, yyt->MPC_StringLiteral.ActualEvalNet)
copychar ((* yyNew)->MPC_StringLiteral.Pass, yyt->MPC_StringLiteral.Pass)
copybool ((* yyNew)->MPC_StringLiteral.Repl, yyt->MPC_StringLiteral.Repl)
copytOptm_Attribute ((* yyNew)->MPC_StringLiteral.Optm_Attribute, yyt->MPC_StringLiteral.Optm_Attribute)
copytString ((* yyNew)->MPC_StringLiteral.String, yyt->MPC_StringLiteral.String)
copyshort ((* yyNew)->MPC_StringLiteral.FullSize, yyt->MPC_StringLiteral.FullSize)
copytTree ((* yyNew)->MPC_StringLiteral.Prev, yyt->MPC_StringLiteral.Prev)
yyt = yyt->MPC_StringLiteral.Next;
yyNew = & (* yyNew)->MPC_StringLiteral.Next; break;
case kMPC_Ident: (* yyNew)->MPC_Ident = yyt->MPC_Ident;
copytPosition ((* yyNew)->MPC_Ident.Pos, yyt->MPC_Ident.Pos)
copytExprFlags ((* yyNew)->MPC_Ident.Flag, yyt->MPC_Ident.Flag)
copytString ((* yyNew)->MPC_Ident.TmpName, yyt->MPC_Ident.TmpName)
copytTree ((* yyNew)->MPC_Ident.Type, yyt->MPC_Ident.Type)
copytTree ((* yyNew)->MPC_Ident.EvalNet, yyt->MPC_Ident.EvalNet)
copytTree ((* yyNew)->MPC_Ident.StoreNet, yyt->MPC_Ident.StoreNet)
copytPosition ((* yyNew)->MPC_Ident.BegPos, yyt->MPC_Ident.BegPos)
copytPosition ((* yyNew)->MPC_Ident.EndPos, yyt->MPC_Ident.EndPos)
copytTree ((* yyNew)->MPC_Ident.ActualEvalNet, yyt->MPC_Ident.ActualEvalNet)
copychar ((* yyNew)->MPC_Ident.Pass, yyt->MPC_Ident.Pass)
copybool ((* yyNew)->MPC_Ident.Repl, yyt->MPC_Ident.Repl)
copytOptm_Attribute ((* yyNew)->MPC_Ident.Optm_Attribute, yyt->MPC_Ident.Optm_Attribute)
copytIdent ((* yyNew)->MPC_Ident.Ident, yyt->MPC_Ident.Ident)
copytTree ((* yyNew)->MPC_Ident.Store, yyt->MPC_Ident.Store)
copytTree ((* yyNew)->MPC_Ident.NextUse, yyt->MPC_Ident.NextUse)
yyt = yyt->MPC_Ident.PrevUse;
yyNew = & (* yyNew)->MPC_Ident.PrevUse; break;
case kMPC_CastExpr: (* yyNew)->MPC_CastExpr = yyt->MPC_CastExpr;
copytPosition ((* yyNew)->MPC_CastExpr.Pos, yyt->MPC_CastExpr.Pos)
copytExprFlags ((* yyNew)->MPC_CastExpr.Flag, yyt->MPC_CastExpr.Flag)
copytString ((* yyNew)->MPC_CastExpr.TmpName, yyt->MPC_CastExpr.TmpName)
copytTree ((* yyNew)->MPC_CastExpr.Type, yyt->MPC_CastExpr.Type)
copytTree ((* yyNew)->MPC_CastExpr.EvalNet, yyt->MPC_CastExpr.EvalNet)
copytTree ((* yyNew)->MPC_CastExpr.StoreNet, yyt->MPC_CastExpr.StoreNet)
copytPosition ((* yyNew)->MPC_CastExpr.BegPos, yyt->MPC_CastExpr.BegPos)
copytPosition ((* yyNew)->MPC_CastExpr.EndPos, yyt->MPC_CastExpr.EndPos)
copytTree ((* yyNew)->MPC_CastExpr.ActualEvalNet, yyt->MPC_CastExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_CastExpr.Pass, yyt->MPC_CastExpr.Pass)
copybool ((* yyNew)->MPC_CastExpr.Repl, yyt->MPC_CastExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_CastExpr.Optm_Attribute, yyt->MPC_CastExpr.Optm_Attribute)
copytTree ((* yyNew)->MPC_CastExpr.TypeName, yyt->MPC_CastExpr.TypeName)
yyt = yyt->MPC_CastExpr.Operand;
yyNew = & (* yyNew)->MPC_CastExpr.Operand; break;
case kMPC_NetCastExpr: (* yyNew)->MPC_NetCastExpr = yyt->MPC_NetCastExpr;
copytPosition ((* yyNew)->MPC_NetCastExpr.Pos, yyt->MPC_NetCastExpr.Pos)
copytExprFlags ((* yyNew)->MPC_NetCastExpr.Flag, yyt->MPC_NetCastExpr.Flag)
copytString ((* yyNew)->MPC_NetCastExpr.TmpName, yyt->MPC_NetCastExpr.TmpName)
copytTree ((* yyNew)->MPC_NetCastExpr.Type, yyt->MPC_NetCastExpr.Type)
copytTree ((* yyNew)->MPC_NetCastExpr.EvalNet, yyt->MPC_NetCastExpr.EvalNet)
copytTree ((* yyNew)->MPC_NetCastExpr.StoreNet, yyt->MPC_NetCastExpr.StoreNet)
copytPosition ((* yyNew)->MPC_NetCastExpr.BegPos, yyt->MPC_NetCastExpr.BegPos)
copytPosition ((* yyNew)->MPC_NetCastExpr.EndPos, yyt->MPC_NetCastExpr.EndPos)
copytTree ((* yyNew)->MPC_NetCastExpr.ActualEvalNet, yyt->MPC_NetCastExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_NetCastExpr.Pass, yyt->MPC_NetCastExpr.Pass)
copybool ((* yyNew)->MPC_NetCastExpr.Repl, yyt->MPC_NetCastExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_NetCastExpr.Optm_Attribute, yyt->MPC_NetCastExpr.Optm_Attribute)
copybool ((* yyNew)->MPC_NetCastExpr.Flexible, yyt->MPC_NetCastExpr.Flexible)
copypVoid ((* yyNew)->MPC_NetCastExpr.ExprPtr, yyt->MPC_NetCastExpr.ExprPtr)
yyt = yyt->MPC_NetCastExpr.Operand;
yyNew = & (* yyNew)->MPC_NetCastExpr.Operand; break;
case kMPC_CoordExpr: (* yyNew)->MPC_CoordExpr = yyt->MPC_CoordExpr;
copytPosition ((* yyNew)->MPC_CoordExpr.Pos, yyt->MPC_CoordExpr.Pos)
copytExprFlags ((* yyNew)->MPC_CoordExpr.Flag, yyt->MPC_CoordExpr.Flag)
copytString ((* yyNew)->MPC_CoordExpr.TmpName, yyt->MPC_CoordExpr.TmpName)
copytTree ((* yyNew)->MPC_CoordExpr.Type, yyt->MPC_CoordExpr.Type)
copytTree ((* yyNew)->MPC_CoordExpr.EvalNet, yyt->MPC_CoordExpr.EvalNet)
copytTree ((* yyNew)->MPC_CoordExpr.StoreNet, yyt->MPC_CoordExpr.StoreNet)
copytPosition ((* yyNew)->MPC_CoordExpr.BegPos, yyt->MPC_CoordExpr.BegPos)
copytPosition ((* yyNew)->MPC_CoordExpr.EndPos, yyt->MPC_CoordExpr.EndPos)
copytTree ((* yyNew)->MPC_CoordExpr.ActualEvalNet, yyt->MPC_CoordExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_CoordExpr.Pass, yyt->MPC_CoordExpr.Pass)
copybool ((* yyNew)->MPC_CoordExpr.Repl, yyt->MPC_CoordExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_CoordExpr.Optm_Attribute, yyt->MPC_CoordExpr.Optm_Attribute)
copytIdent ((* yyNew)->MPC_CoordExpr.CoordName, yyt->MPC_CoordExpr.CoordName)
copyshort ((* yyNew)->MPC_CoordExpr.CoordNumber, yyt->MPC_CoordExpr.CoordNumber)
yyt = yyt->MPC_CoordExpr.Operand;
yyNew = & (* yyNew)->MPC_CoordExpr.Operand; break;
case kMPC_SizeofExpr: (* yyNew)->MPC_SizeofExpr = yyt->MPC_SizeofExpr;
copytPosition ((* yyNew)->MPC_SizeofExpr.Pos, yyt->MPC_SizeofExpr.Pos)
copytExprFlags ((* yyNew)->MPC_SizeofExpr.Flag, yyt->MPC_SizeofExpr.Flag)
copytString ((* yyNew)->MPC_SizeofExpr.TmpName, yyt->MPC_SizeofExpr.TmpName)
copytTree ((* yyNew)->MPC_SizeofExpr.Type, yyt->MPC_SizeofExpr.Type)
copytTree ((* yyNew)->MPC_SizeofExpr.EvalNet, yyt->MPC_SizeofExpr.EvalNet)
copytTree ((* yyNew)->MPC_SizeofExpr.StoreNet, yyt->MPC_SizeofExpr.StoreNet)
copytPosition ((* yyNew)->MPC_SizeofExpr.BegPos, yyt->MPC_SizeofExpr.BegPos)
copytPosition ((* yyNew)->MPC_SizeofExpr.EndPos, yyt->MPC_SizeofExpr.EndPos)
copychar ((* yyNew)->MPC_SizeofExpr.Pass, yyt->MPC_SizeofExpr.Pass)
copybool ((* yyNew)->MPC_SizeofExpr.Repl, yyt->MPC_SizeofExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_SizeofExpr.Optm_Attribute, yyt->MPC_SizeofExpr.Optm_Attribute)
copybool ((* yyNew)->MPC_SizeofExpr.CompileTime, yyt->MPC_SizeofExpr.CompileTime)
copyint ((* yyNew)->MPC_SizeofExpr.Value, yyt->MPC_SizeofExpr.Value)
yyt = yyt->MPC_SizeofExpr.ActualEvalNet;
yyNew = & (* yyNew)->MPC_SizeofExpr.ActualEvalNet; break;
case kMPC_Size_Of_Value: (* yyNew)->MPC_Size_Of_Value = yyt->MPC_Size_Of_Value;
copytPosition ((* yyNew)->MPC_Size_Of_Value.Pos, yyt->MPC_Size_Of_Value.Pos)
copytExprFlags ((* yyNew)->MPC_Size_Of_Value.Flag, yyt->MPC_Size_Of_Value.Flag)
copytString ((* yyNew)->MPC_Size_Of_Value.TmpName, yyt->MPC_Size_Of_Value.TmpName)
copytTree ((* yyNew)->MPC_Size_Of_Value.Type, yyt->MPC_Size_Of_Value.Type)
copytTree ((* yyNew)->MPC_Size_Of_Value.EvalNet, yyt->MPC_Size_Of_Value.EvalNet)
copytTree ((* yyNew)->MPC_Size_Of_Value.StoreNet, yyt->MPC_Size_Of_Value.StoreNet)
copytPosition ((* yyNew)->MPC_Size_Of_Value.BegPos, yyt->MPC_Size_Of_Value.BegPos)
copytPosition ((* yyNew)->MPC_Size_Of_Value.EndPos, yyt->MPC_Size_Of_Value.EndPos)
copytTree ((* yyNew)->MPC_Size_Of_Value.ActualEvalNet, yyt->MPC_Size_Of_Value.ActualEvalNet)
copychar ((* yyNew)->MPC_Size_Of_Value.Pass, yyt->MPC_Size_Of_Value.Pass)
copybool ((* yyNew)->MPC_Size_Of_Value.Repl, yyt->MPC_Size_Of_Value.Repl)
copytOptm_Attribute ((* yyNew)->MPC_Size_Of_Value.Optm_Attribute, yyt->MPC_Size_Of_Value.Optm_Attribute)
copybool ((* yyNew)->MPC_Size_Of_Value.CompileTime, yyt->MPC_Size_Of_Value.CompileTime)
copyint ((* yyNew)->MPC_Size_Of_Value.Value, yyt->MPC_Size_Of_Value.Value)
yyt = yyt->MPC_Size_Of_Value.Operand;
yyNew = & (* yyNew)->MPC_Size_Of_Value.Operand; break;
case kMPC_Size_Of_Type: (* yyNew)->MPC_Size_Of_Type = yyt->MPC_Size_Of_Type;
copytPosition ((* yyNew)->MPC_Size_Of_Type.Pos, yyt->MPC_Size_Of_Type.Pos)
copytExprFlags ((* yyNew)->MPC_Size_Of_Type.Flag, yyt->MPC_Size_Of_Type.Flag)
copytString ((* yyNew)->MPC_Size_Of_Type.TmpName, yyt->MPC_Size_Of_Type.TmpName)
copytTree ((* yyNew)->MPC_Size_Of_Type.Type, yyt->MPC_Size_Of_Type.Type)
copytTree ((* yyNew)->MPC_Size_Of_Type.EvalNet, yyt->MPC_Size_Of_Type.EvalNet)
copytTree ((* yyNew)->MPC_Size_Of_Type.StoreNet, yyt->MPC_Size_Of_Type.StoreNet)
copytPosition ((* yyNew)->MPC_Size_Of_Type.BegPos, yyt->MPC_Size_Of_Type.BegPos)
copytPosition ((* yyNew)->MPC_Size_Of_Type.EndPos, yyt->MPC_Size_Of_Type.EndPos)
copytTree ((* yyNew)->MPC_Size_Of_Type.ActualEvalNet, yyt->MPC_Size_Of_Type.ActualEvalNet)
copychar ((* yyNew)->MPC_Size_Of_Type.Pass, yyt->MPC_Size_Of_Type.Pass)
copybool ((* yyNew)->MPC_Size_Of_Type.Repl, yyt->MPC_Size_Of_Type.Repl)
copytOptm_Attribute ((* yyNew)->MPC_Size_Of_Type.Optm_Attribute, yyt->MPC_Size_Of_Type.Optm_Attribute)
copybool ((* yyNew)->MPC_Size_Of_Type.CompileTime, yyt->MPC_Size_Of_Type.CompileTime)
copyint ((* yyNew)->MPC_Size_Of_Type.Value, yyt->MPC_Size_Of_Type.Value)
yyt = yyt->MPC_Size_Of_Type.Operand;
yyNew = & (* yyNew)->MPC_Size_Of_Type.Operand; break;
case kMPC_TimeofExpr: (* yyNew)->MPC_TimeofExpr = yyt->MPC_TimeofExpr;
copytPosition ((* yyNew)->MPC_TimeofExpr.Pos, yyt->MPC_TimeofExpr.Pos)
copytExprFlags ((* yyNew)->MPC_TimeofExpr.Flag, yyt->MPC_TimeofExpr.Flag)
copytString ((* yyNew)->MPC_TimeofExpr.TmpName, yyt->MPC_TimeofExpr.TmpName)
copytTree ((* yyNew)->MPC_TimeofExpr.Type, yyt->MPC_TimeofExpr.Type)
copytTree ((* yyNew)->MPC_TimeofExpr.EvalNet, yyt->MPC_TimeofExpr.EvalNet)
copytTree ((* yyNew)->MPC_TimeofExpr.StoreNet, yyt->MPC_TimeofExpr.StoreNet)
copytPosition ((* yyNew)->MPC_TimeofExpr.BegPos, yyt->MPC_TimeofExpr.BegPos)
copytPosition ((* yyNew)->MPC_TimeofExpr.EndPos, yyt->MPC_TimeofExpr.EndPos)
copytTree ((* yyNew)->MPC_TimeofExpr.ActualEvalNet, yyt->MPC_TimeofExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_TimeofExpr.Pass, yyt->MPC_TimeofExpr.Pass)
copybool ((* yyNew)->MPC_TimeofExpr.Repl, yyt->MPC_TimeofExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_TimeofExpr.Optm_Attribute, yyt->MPC_TimeofExpr.Optm_Attribute)
yyt = yyt->MPC_TimeofExpr.NetDecl;
yyNew = & (* yyNew)->MPC_TimeofExpr.NetDecl; break;
case kMPC_UnaryExpr: (* yyNew)->MPC_UnaryExpr = yyt->MPC_UnaryExpr;
copytPosition ((* yyNew)->MPC_UnaryExpr.Pos, yyt->MPC_UnaryExpr.Pos)
copytExprFlags ((* yyNew)->MPC_UnaryExpr.Flag, yyt->MPC_UnaryExpr.Flag)
copytString ((* yyNew)->MPC_UnaryExpr.TmpName, yyt->MPC_UnaryExpr.TmpName)
copytTree ((* yyNew)->MPC_UnaryExpr.Type, yyt->MPC_UnaryExpr.Type)
copytTree ((* yyNew)->MPC_UnaryExpr.EvalNet, yyt->MPC_UnaryExpr.EvalNet)
copytTree ((* yyNew)->MPC_UnaryExpr.StoreNet, yyt->MPC_UnaryExpr.StoreNet)
copytPosition ((* yyNew)->MPC_UnaryExpr.BegPos, yyt->MPC_UnaryExpr.BegPos)
copytPosition ((* yyNew)->MPC_UnaryExpr.EndPos, yyt->MPC_UnaryExpr.EndPos)
copytTree ((* yyNew)->MPC_UnaryExpr.ActualEvalNet, yyt->MPC_UnaryExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_UnaryExpr.Pass, yyt->MPC_UnaryExpr.Pass)
copybool ((* yyNew)->MPC_UnaryExpr.Repl, yyt->MPC_UnaryExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_UnaryExpr.Optm_Attribute, yyt->MPC_UnaryExpr.Optm_Attribute)
copyshort ((* yyNew)->MPC_UnaryExpr.OpCode, yyt->MPC_UnaryExpr.OpCode)
yyt = yyt->MPC_UnaryExpr.Operand;
yyNew = & (* yyNew)->MPC_UnaryExpr.Operand; break;
case kMPC_BinaryExpr: (* yyNew)->MPC_BinaryExpr = yyt->MPC_BinaryExpr;
copytPosition ((* yyNew)->MPC_BinaryExpr.Pos, yyt->MPC_BinaryExpr.Pos)
copytExprFlags ((* yyNew)->MPC_BinaryExpr.Flag, yyt->MPC_BinaryExpr.Flag)
copytString ((* yyNew)->MPC_BinaryExpr.TmpName, yyt->MPC_BinaryExpr.TmpName)
copytTree ((* yyNew)->MPC_BinaryExpr.Type, yyt->MPC_BinaryExpr.Type)
copytTree ((* yyNew)->MPC_BinaryExpr.EvalNet, yyt->MPC_BinaryExpr.EvalNet)
copytTree ((* yyNew)->MPC_BinaryExpr.StoreNet, yyt->MPC_BinaryExpr.StoreNet)
copytPosition ((* yyNew)->MPC_BinaryExpr.BegPos, yyt->MPC_BinaryExpr.BegPos)
copytPosition ((* yyNew)->MPC_BinaryExpr.EndPos, yyt->MPC_BinaryExpr.EndPos)
copytTree ((* yyNew)->MPC_BinaryExpr.ActualEvalNet, yyt->MPC_BinaryExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_BinaryExpr.Pass, yyt->MPC_BinaryExpr.Pass)
copybool ((* yyNew)->MPC_BinaryExpr.Repl, yyt->MPC_BinaryExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_BinaryExpr.Optm_Attribute, yyt->MPC_BinaryExpr.Optm_Attribute)
copyshort ((* yyNew)->MPC_BinaryExpr.OpCode, yyt->MPC_BinaryExpr.OpCode)
copytTree ((* yyNew)->MPC_BinaryExpr.Loperand, yyt->MPC_BinaryExpr.Loperand)
yyt = yyt->MPC_BinaryExpr.Roperand;
yyNew = & (* yyNew)->MPC_BinaryExpr.Roperand; break;
case kMPC_TernaryExpr: (* yyNew)->MPC_TernaryExpr = yyt->MPC_TernaryExpr;
copytPosition ((* yyNew)->MPC_TernaryExpr.Pos, yyt->MPC_TernaryExpr.Pos)
copytExprFlags ((* yyNew)->MPC_TernaryExpr.Flag, yyt->MPC_TernaryExpr.Flag)
copytString ((* yyNew)->MPC_TernaryExpr.TmpName, yyt->MPC_TernaryExpr.TmpName)
copytTree ((* yyNew)->MPC_TernaryExpr.Type, yyt->MPC_TernaryExpr.Type)
copytTree ((* yyNew)->MPC_TernaryExpr.EvalNet, yyt->MPC_TernaryExpr.EvalNet)
copytTree ((* yyNew)->MPC_TernaryExpr.StoreNet, yyt->MPC_TernaryExpr.StoreNet)
copytPosition ((* yyNew)->MPC_TernaryExpr.BegPos, yyt->MPC_TernaryExpr.BegPos)
copytPosition ((* yyNew)->MPC_TernaryExpr.EndPos, yyt->MPC_TernaryExpr.EndPos)
copytTree ((* yyNew)->MPC_TernaryExpr.ActualEvalNet, yyt->MPC_TernaryExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_TernaryExpr.Pass, yyt->MPC_TernaryExpr.Pass)
copybool ((* yyNew)->MPC_TernaryExpr.Repl, yyt->MPC_TernaryExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_TernaryExpr.Optm_Attribute, yyt->MPC_TernaryExpr.Optm_Attribute)
copyshort ((* yyNew)->MPC_TernaryExpr.OpCode, yyt->MPC_TernaryExpr.OpCode)
copytTree ((* yyNew)->MPC_TernaryExpr.Foperand, yyt->MPC_TernaryExpr.Foperand)
copytTree ((* yyNew)->MPC_TernaryExpr.Soperand, yyt->MPC_TernaryExpr.Soperand)
yyt = yyt->MPC_TernaryExpr.Toperand;
yyNew = & (* yyNew)->MPC_TernaryExpr.Toperand; break;
case kMPC_QuaternaryExpr: (* yyNew)->MPC_QuaternaryExpr = yyt->MPC_QuaternaryExpr;
copytPosition ((* yyNew)->MPC_QuaternaryExpr.Pos, yyt->MPC_QuaternaryExpr.Pos)
copytExprFlags ((* yyNew)->MPC_QuaternaryExpr.Flag, yyt->MPC_QuaternaryExpr.Flag)
copytString ((* yyNew)->MPC_QuaternaryExpr.TmpName, yyt->MPC_QuaternaryExpr.TmpName)
copytTree ((* yyNew)->MPC_QuaternaryExpr.Type, yyt->MPC_QuaternaryExpr.Type)
copytTree ((* yyNew)->MPC_QuaternaryExpr.EvalNet, yyt->MPC_QuaternaryExpr.EvalNet)
copytTree ((* yyNew)->MPC_QuaternaryExpr.StoreNet, yyt->MPC_QuaternaryExpr.StoreNet)
copytPosition ((* yyNew)->MPC_QuaternaryExpr.BegPos, yyt->MPC_QuaternaryExpr.BegPos)
copytPosition ((* yyNew)->MPC_QuaternaryExpr.EndPos, yyt->MPC_QuaternaryExpr.EndPos)
copytTree ((* yyNew)->MPC_QuaternaryExpr.ActualEvalNet, yyt->MPC_QuaternaryExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_QuaternaryExpr.Pass, yyt->MPC_QuaternaryExpr.Pass)
copybool ((* yyNew)->MPC_QuaternaryExpr.Repl, yyt->MPC_QuaternaryExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_QuaternaryExpr.Optm_Attribute, yyt->MPC_QuaternaryExpr.Optm_Attribute)
copyshort ((* yyNew)->MPC_QuaternaryExpr.OpCode, yyt->MPC_QuaternaryExpr.OpCode)
copytTree ((* yyNew)->MPC_QuaternaryExpr.Operand1, yyt->MPC_QuaternaryExpr.Operand1)
copytTree ((* yyNew)->MPC_QuaternaryExpr.Operand2, yyt->MPC_QuaternaryExpr.Operand2)
copytTree ((* yyNew)->MPC_QuaternaryExpr.Operand3, yyt->MPC_QuaternaryExpr.Operand3)
yyt = yyt->MPC_QuaternaryExpr.Operand4;
yyNew = & (* yyNew)->MPC_QuaternaryExpr.Operand4; break;
case kMPC_CallExpr: (* yyNew)->MPC_CallExpr = yyt->MPC_CallExpr;
copytPosition ((* yyNew)->MPC_CallExpr.Pos, yyt->MPC_CallExpr.Pos)
copytExprFlags ((* yyNew)->MPC_CallExpr.Flag, yyt->MPC_CallExpr.Flag)
copytString ((* yyNew)->MPC_CallExpr.TmpName, yyt->MPC_CallExpr.TmpName)
copytTree ((* yyNew)->MPC_CallExpr.Type, yyt->MPC_CallExpr.Type)
copytTree ((* yyNew)->MPC_CallExpr.EvalNet, yyt->MPC_CallExpr.EvalNet)
copytTree ((* yyNew)->MPC_CallExpr.StoreNet, yyt->MPC_CallExpr.StoreNet)
copytPosition ((* yyNew)->MPC_CallExpr.BegPos, yyt->MPC_CallExpr.BegPos)
copytPosition ((* yyNew)->MPC_CallExpr.EndPos, yyt->MPC_CallExpr.EndPos)
copytTree ((* yyNew)->MPC_CallExpr.ActualEvalNet, yyt->MPC_CallExpr.ActualEvalNet)
copychar ((* yyNew)->MPC_CallExpr.Pass, yyt->MPC_CallExpr.Pass)
copybool ((* yyNew)->MPC_CallExpr.Repl, yyt->MPC_CallExpr.Repl)
copytOptm_Attribute ((* yyNew)->MPC_CallExpr.Optm_Attribute, yyt->MPC_CallExpr.Optm_Attribute)
copytTree ((* yyNew)->MPC_CallExpr.Function, yyt->MPC_CallExpr.Function)
copytTree ((* yyNew)->MPC_CallExpr.ArgList, yyt->MPC_CallExpr.ArgList)
yyt = yyt->MPC_CallExpr.NetworkArgList;
yyNew = & (* yyNew)->MPC_CallExpr.NetworkArgList; break;
case kMPC_Exprs: (* yyNew)->MPC_Exprs = yyt->MPC_Exprs;
copytPosition ((* yyNew)->MPC_Exprs.Pos, yyt->MPC_Exprs.Pos)
copytTree ((* yyNew)->MPC_Exprs.Prev, yyt->MPC_Exprs.Prev)
copytTree ((* yyNew)->MPC_Exprs.Expr, yyt->MPC_Exprs.Expr)
copytPosition ((* yyNew)->MPC_Exprs.BegPos, yyt->MPC_Exprs.BegPos)
copytPosition ((* yyNew)->MPC_Exprs.EndPos, yyt->MPC_Exprs.EndPos)
yyt = yyt->MPC_Exprs.Next;
yyNew = & (* yyNew)->MPC_Exprs.Next; break;
case kMPC_Initializer: (* yyNew)->MPC_Initializer = yyt->MPC_Initializer;
copytPosition ((* yyNew)->MPC_Initializer.Pos, yyt->MPC_Initializer.Pos)
copytTree ((* yyNew)->MPC_Initializer.Prev, yyt->MPC_Initializer.Prev)
copytPosition ((* yyNew)->MPC_Initializer.EndPos, yyt->MPC_Initializer.EndPos)
yyt = yyt->MPC_Initializer.Next;
yyNew = & (* yyNew)->MPC_Initializer.Next; break;
case kMPC_SimpleInit: (* yyNew)->MPC_SimpleInit = yyt->MPC_SimpleInit;
copytPosition ((* yyNew)->MPC_SimpleInit.Pos, yyt->MPC_SimpleInit.Pos)
copytTree ((* yyNew)->MPC_SimpleInit.Prev, yyt->MPC_SimpleInit.Prev)
copytPosition ((* yyNew)->MPC_SimpleInit.EndPos, yyt->MPC_SimpleInit.EndPos)
copytTree ((* yyNew)->MPC_SimpleInit.Expr, yyt->MPC_SimpleInit.Expr)
yyt = yyt->MPC_SimpleInit.Next;
yyNew = & (* yyNew)->MPC_SimpleInit.Next; break;
case kMPC_InitList: (* yyNew)->MPC_InitList = yyt->MPC_InitList;
copytPosition ((* yyNew)->MPC_InitList.Pos, yyt->MPC_InitList.Pos)
copytTree ((* yyNew)->MPC_InitList.Prev, yyt->MPC_InitList.Prev)
copytPosition ((* yyNew)->MPC_InitList.EndPos, yyt->MPC_InitList.EndPos)
copyint ((* yyNew)->MPC_InitList.Length, yyt->MPC_InitList.Length)
copytTree ((* yyNew)->MPC_InitList.List, yyt->MPC_InitList.List)
yyt = yyt->MPC_InitList.Next;
yyNew = & (* yyNew)->MPC_InitList.Next; break;
  default: ;
  }
 }
}

tTree CopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 tTree yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyTree (yyt, & yyNew);
 return yyNew;
}

void BeginTree ()
{
}

void CloseTree ()
{
}
