#ifndef __cocktailIO_h__
#define __cocktailIO_h__

#include "Idents.h"
#include "StringMem.h"

extern void MyGetIdent(FILE *,tIdent *);
extern void MyCopyString(tString *dst ,tString *src);
extern void MyReadString(FILE*,tString*);
extern void MyCloseString(tString *);
extern void MyPutString(FILE*,tString*);
extern void MyGetString(FILE*,tString*);
extern void MyReadPosition(FILE*, tPosition*);

/*-----------------------------------------------*/

/* fairly standard stuff */
#define writechar(a)           (void) fputc(a, yyf);
#define writetString(a)        (void) fputs(a, yyf); 

/* stuff, not supported by Cocktail */
#define gettIdent(a)           MyGetIdent(yyf, & a );

#define readtString(a)         MyReadString(yyf, & a);
#define gettString(a)          MyGetString(yyf, & a);
#define puttString(a)	       MyPutString(yyf, & a );
#define copytString(a,b)       MyCopyString(&a,&b); 
#define closetString(a)        MyCloseString(&a);

#define readtPosition(a)       MyReadPosition(yyf,&a);

#endif


