/* Utility functions for various needs */

#include <stdio.h>
#include <string.h>
#include "Idents.h"
#include "Positions.h"
#include "Memory.h"
#include "DynArray.h"

void MyGetIdent( FILE *yyf, tIdent * yyi )
{
  char *p;
  unsigned long allocd=100;
  unsigned int i=0;

  MakeArray(&p,&allocd,1);

  while( (p[i]=fgetc( yyf )) != '\n' )
    {
      if(i+1 >= allocd)
	ExtendArray(&p,&allocd,1);
	i++;
    }
  p[i]='\0';
  * yyi = MakeIdent( (tString) p, i );
  ReleaseArray(&p,&allocd,1);
} 

void MyCopyString(tString *a,tString *b)
{
  *a = Alloc(strlen(*b)+1);
  strcpy(*a,*b);
}

void MyReadString( FILE* yyf, tString * yys )
{
  char *p;
  unsigned long allocd=100;
  unsigned int i=0;

  MakeArray(&p,&allocd,1);

  while( (p[i]=fgetc( yyf )) != '\n' )
    {
      if(i+1 >= allocd)
	ExtendArray(&p,&allocd,1);
	i++;
    }
  p[i]='\0';
  *yys = Alloc(i+1);strcpy(*yys,p);
  ReleaseArray(&p,&allocd,1);
}

void MyCloseString(tString *yys)
{
  Free(strlen(*yys),*yys);
  *yys = NULL;
}

void MyPutString( FILE*f, tString *yys )
{
  unsigned long l = strlen(*yys);
  fwrite(&l,sizeof(long),1,f);
  if(l>0) fwrite(*yys,l,1,f);
}

void MyGetString( FILE*f, tString *yys )
{
  unsigned long l;

  fread(&l,sizeof(long),1,f);
  *yys = Alloc(l+1);
  if(l>0) fread(*yys,l,1,f);
  (*yys)[l]=0;
}


void MyReadPosition( FILE* src, tPosition * pPos ) {
  int l,c;

  fscanf( src, "%d,%d",  &l,&c );
   pPos->Line=l;
   pPos->Column=c;
}

