#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFSIZE 8192
static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

int MPC_Is_comment(const char* buffer)
{
  if (strlen(buffer) == 0) return 1;
  while(isspace(*buffer))
    buffer++;
  if (*buffer== '#')
    return 1;
  else
    return 0;
}  

int MPC_Is_left_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='{')
    return 1;
  else
    return 0;
}

int MPC_Is_right_brace(char *buffer)
{
  while(isspace(*buffer))
    buffer++;
  if(*buffer=='}')
    return 1;
  else
    return 0;
}

void main(int argc, char **argv)
{
  char params[BUFSIZE];
  char buf[BUFSIZE], buf1[BUFSIZE], buf2[BUFSIZE], firsthost[BUFSIZE],
    rname[BUFSIZE], buf3[BUFSIZE/8];

  FILE *finput, *foutput, *fin, *fp;
  char *mpctopo, *whichmpi, *mpcload;
  int i, proccount;

  params[0]='\0';
  buf[0]='\0';

  whichmpi=getenv("WHICHMPI");
  if(whichmpi==NULL)
    {
      whichmpi=lam;
      printf("mpcrun: Environmental variable WHICHMPI not defined (LAM selected).\n");
    }
  if(strcmp(whichmpi,lam)&&strcmp(whichmpi,lam63)&&strcmp(whichmpi,mpich)
     &&strcmp(whichmpi,mpich_p4))
    {
      printf("mpcrun: unsupported MPI implementation %s\n", whichmpi);
      exit(-1);
    }
  if(argc<1)
    {
      printf("mpcrun: usage --> mpcrun <program> [-- <arguments>]\n");
      fflush(stdout);
      exit(-1);
    }

  mpcload=getenv("MPCLOAD");
  if(mpcload==NULL)
    {
      printf("mpcrun: MPCLOAD not defined.\n");
      exit(-1);
    }
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpcrun: MPCTOPO not defined.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((finput=fopen(buf, "r"))!=NULL)
    {
      fscanf(finput, "%s", buf);
      fclose(finput);
    }
  else
    {
      printf("mpcrun: no opened machine.\n");
      exit(-1);
    }
  if(argv[2]==NULL || strcmp(argv[2], "--")) {
    if(argv[2]!=NULL) {
      printf("mpcrun: usage --> mpcrun <program> [-- <arguments>]\n");
      exit(-1);
    }
  }
  else {
    if(!strcmp(whichmpi,lam))
      i=2;
    else if(!strcmp(whichmpi,lam63))
      i=3;
    else if(!strcmp(whichmpi,mpich))
      i=3;
    else if(!strcmp(whichmpi,mpich_p4))
      i=3;
    for(; argv[i]!=NULL; i++) {
      strcat(params, " ");
      strcat(params, argv[i]);
    }
  }
  strncpy(buf1, "", BUFSIZE);
  strcpy(buf1, mpctopo);
  strcat(buf1, "/");
  strcat(buf1, buf);
  if(!strcmp(whichmpi,mpich))
    {
      strncpy(buf2, "", BUFSIZE);
      strcat(buf2, buf1);
      strcat(buf2, ".def");      
      if((finput=fopen(buf2, "r"))==NULL) {
        printf("mpcrun: can't open '%s'.\n", buf2);
        exit(-1);
      }
    }
  if(!strcmp(whichmpi,mpich_p4))
    {
      strncpy(buf2, "", BUFSIZE);
      strcat(buf2, buf1);
      strcat(buf2, ".p43");      
      if((finput=fopen(buf2, "r"))==NULL) {
        printf("mpcrun: can't open '%s'.\n", buf2);
        exit(-1);
      }
    }
  if((fin=fopen(buf1, "r"))==NULL) {
    printf("mpcrun: can't open '%s'.\n", buf1);
    exit(-1);
  }
  else {
    strcat(buf1, "_");
    strcat(buf1, argv[1]);
    strcat(buf1, ".run");
    strcpy(rname, buf1);
    if((foutput=fopen(buf1, "w"))==NULL) {
      printf("mpcrun: can't create '%s'.\n", buf1);
      exit(-1);      
    }
    else {
      char *nprocs, *end;
      
      strcpy(buf3, mpcload);
      strcat(buf3, "/MPCzyuzya.1");
      fp=fopen(buf3, "w");
      if(fp==NULL)
        {
          printf("mpcrun: cannot create a working file in directory %s.\n",
                 mpcload);
          fclose(foutput);
          remove(buf1);
          exit(-1);
        }
      i=0;
      proccount=1;
      
      if(!strcmp(whichmpi,lam) || !strcmp(whichmpi,lam63) || !strcmp(whichmpi,mpich))
        while((fgets(buf1, BUFSIZE, fin))!=NULL) {
          if (MPC_Is_comment(buf1) ||
              MPC_Is_left_brace(buf1) || MPC_Is_right_brace(buf1))
            continue;
          for(nprocs=buf1;
              *nprocs==' '||*nprocs=='\t'||*nprocs=='\f'||*nprocs=='\v';
              nprocs++) ;
          for(; *nprocs!=' '; nprocs++) ;
          while(*nprocs==' ') nprocs++;
          for(end=nprocs; *end<='9'&&*end>='0'; end++) ;
          *end='\0';
          if(!strcmp(whichmpi,lam))
            fprintf(foutput, "%s -c %s -s n%d n%d%s\n", argv[1], nprocs,
                    i, i, params);
          else if(!strcmp(whichmpi,lam63))
            fprintf(foutput, "-np %s -s n%d n%d %s %s\n", nprocs,
                    i, i, argv[1], params);
          else if(!strcmp(whichmpi,mpich))
            {
              int np;
              np=atoi(nprocs);
              fgets(buf2, BUFSIZE, finput);
              if(proccount==1)
                strcpy(firsthost, buf2);
              proccount+=np;
              while(np--)
                fprintf(foutput, "%s", buf2);  
            }
          i++;
        }
      else if(!strcmp(whichmpi,mpich_p4))
        {
          char temp[BUFSIZE], *p;
          int i;
          
          i=0;
          while((fgets(temp, BUFSIZE, finput))!=NULL) {
            p=strstr(temp, "fignya");
            *p='\0';
            if(i==0)
              {
                strcpy(buf1, temp);
                p=strstr(buf1, " 0 ");
                p[1]='1';
                i=1;
              }
            fprintf(foutput, "%s%s\n", temp, argv[1]);
          }
          fprintf(foutput, "%s%s\n", buf1, argv[1]);
        }
      if(!strcmp(whichmpi,mpich_p4))
          if(getenv("MPCTOPOFILE"))
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPOFILE && $MPIDIR/bin/mpirun -p4pg %s $MPCLOAD/%s %s && rm %s", buf, rname, argv[1], params, rname);
          else
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPO/current.topo && $MPIDIR/bin/mpirun -p4pg %s $MPCLOAD/%s %s && rm %s", buf, rname, argv[1], params, rname);
      else if(!strcmp(whichmpi,lam) || !strcmp(whichmpi,lam63))
        {
          if(!strcmp(whichmpi,lam63))
            fprintf(foutput, "-np 1 -s n0 n0 %s\n", argv[1]);
          else
            fprintf(foutput, "%s -c 1 -s n0 n0\n", argv[1]);
          if(getenv("MPCTOPOFILE"))
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPOFILE && $MPIDIR/bin/mpirun -w $MPIFLAGS %s && rm %s", buf, rname, rname);
          else
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPO/current.topo && $MPIDIR/bin/mpirun -w $MPIFLAGS %s && rm %s", buf, rname, rname);
        }
      else if(!strcmp(whichmpi,mpich))
        {
          fprintf(foutput, "%s", firsthost);
          if(getenv("MPCTOPOFILE"))
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPOFILE && cp %s $MPIDIR/util/machines/machines.mpc && rm %s && $MPIDIR/bin/mpirun -arch mpc -np %d $MPCLOAD/%s %s ", buf, rname, rname, proccount, argv[1], params);
          else
            fprintf(fp, "cp $MPCTOPO/%s.topo $MPCTOPO/current.topo && cp %s $MPIDIR/util/machines/machines.mpc && rm %s && $MPIDIR/bin/mpirun -arch mpc -np %d $MPCLOAD/%s %s ", buf, rname, rname, proccount, argv[1], params);
        }
      exit(0);
    }
  }
}
