#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFSIZE 8192

void main(int argc, char **argv)
{
  char params[BUFSIZE];
  char buf[BUFSIZE], buf1[BUFSIZE];

  FILE *finput, *foutput, *fin;
  char *mpctopo;
  int i;

  params[0]='\0';
  buf[0]='\0';

  if(argc<1)
    {
      printf("mpcrun: usage --> mpcrun <program> [-- <arguments>]\n");
      fflush(stdout);
      exit(-1);
    }
  mpctopo=getenv("MPCTOPOFILE");
  if(mpctopo==NULL)
    {
      printf("mpcrun: cannot find environmental variable MPCTOPOFILE.\n");
      exit(-1);
    }  
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpcrun: cannot find environmental variable MPCTOPO.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((finput=fopen(buf, "r"))!=NULL)
    {
      fscanf(finput, "%s", buf);
      fclose(finput);
    }
  else
    {
      printf("mpcrun: no opened machine.\n");
      exit(-1);
    }
  if(argv[2]==NULL || strcmp(argv[2], "--")) {
    if(argv[2]!=NULL) {
      printf("mpcrun: usage --> mpcrun <program> [-- <arguments>]\n");
      exit(-1);
    }
  }
  else {
    for(i=2; argv[i]!=NULL; i++) {
      strcat(params, " ");
      strcat(params, argv[i]);
    }
  }
  strncpy(buf1, "", BUFSIZE);
  strcpy(buf1, mpctopo);
  strcat(buf1, "/");
  strcat(buf1, buf);
  if((fin=fopen(buf1, "r"))==NULL) {
    printf("mpcrun: can't open '%s'.\n", buf1);
    exit(-1);
  }
  else {
    strcat(buf1, "_");
    strcat(buf1, argv[1]);
    strcat(buf1, ".run");
    if((foutput=fopen(buf1, "w"))==NULL) {
      printf("mpcrun: can't create '%s'.\n", buf1);
      exit(-1);      
    }
    else {
      char *nprocs, *end;
      i=0;
      while((fgets(buf1, BUFSIZE, fin))!=NULL) {
        for(nprocs=buf1; *nprocs!=' '; nprocs++) ;
        while(*nprocs==' ') nprocs++;
        for(end=nprocs; *end<='9'&&*end>='0'; end++) ;
        *end='\0';
        fprintf(foutput, "%s -c %s -s n%d n%d%s\n", argv[1], nprocs, i, i, params);
        i++;
      }
      fprintf(foutput, "%s -c 1 -s n0 n0\n", argv[1]);
      strncpy(buf1, "", BUFSIZE);
      strcpy(buf1, "cp $MPCTOPO/");
      strcat(buf1, buf);
      strcat(buf1, " $MPCTOPOFILE");
      system(buf1);
      strncpy(buf1, "", BUFSIZE);
      strcpy(buf1, "mpirun $MPCTOPO/");
      strcat(buf1, buf);
      strcat(buf1, "_");
      strcat(buf1, argv[1]);
      strcat(buf1, ".run");
      system(buf1);
      exit(0);
    }
  }
}
