#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define BUFSIZE 256

char buf[BUFSIZE], buf1[BUFSIZE], buf2[BUFSIZE];
static char lam[]="LAM", mpich[]="MPICH", mpich_p4[]="MPICH_P4", lam63[]="LAM6.3";

main(int argc, char **argv)
{
  FILE *finput;
  char *mpctopo, *whichmpi;

  whichmpi=getenv("WHICHMPI");
  if(whichmpi==NULL)
    {
      whichmpi=lam;
      printf("mpcclose: WHICHMPI not defined (LAM selected).\n");
    }
  mpctopo=getenv("MPCTOPO");
  if(mpctopo==NULL)
    {
      printf("mpcclose: MPCTOPO not defined.\n");
      exit(-1);
    }  
  strcpy(buf, mpctopo);
  strcat(buf, "/log/current");
  if((finput=fopen(buf, "r"))!=NULL)
    {
      fscanf(finput, "%s", buf2);
      strncpy(buf1, "", BUFSIZE);
      strcat(buf1, "$MPIDIR/bin/wipe ");
      strcat(buf1, mpctopo);
      strcat(buf1, "/");
      strcat(buf1, buf2);
      strcat(buf1, ".def");
      printf("mpcclose: \'%s\' is now under closing.\n", buf2);
      if(!strcmp(whichmpi,lam) || !strcmp(whichmpi,lam63))
        system(buf1);
      else if(!strcmp(whichmpi,mpich) || !strcmp(whichmpi,mpich_p4))
          ;
      else
        {
          printf("mpcclose: unsupported MPI implementation %s\n", whichmpi);
          fclose(finput);
          remove(buf);
          exit(-1);
        }
      fclose(finput);
      remove(buf);
      exit(0);
    }
  else
    {
      printf("mpcclose: no opened machine.\n");
      exit(-1);
    }
}
