#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <mpi.h>
#include <limits.h>
#include <sys/utsname.h>
#include <string.h>

#define MAX_NNL 256
#define Kb 1024
#define BUFSIZE (2*Kb*Kb) /**/
#define HOST 0

static int myrank, N, error, sumerr, *numps, *ranks;

#define IF_HOST if(myrank==HOST)

static char (*nodenames)[MAX_NNL], myname[MAX_NNL];

static char *buf;
static char name[MAX_NNL];


main(int argc, char **argv)
{
  FILE *fp;
  char *mpctopo, *mpcload;
  int nprocs;
  /* Group data */
  MPI_Group MPI_GROUP_WORLD;
  struct utsname node_info;
  int i, hm=-1, filesize;
        
  mpctopo=getenv("MPCTOPO");
  mpcload=getenv("MPCLOAD");
  
  uname(&node_info);
  strcpy(myname, node_info.nodename);
  /*
   * Initialize the World.
   */
  MPI_Init( &argc, &argv);
  MPI_Comm_group(MPI_COMM_WORLD, &MPI_GROUP_WORLD);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
  N=nprocs;

  IF_HOST
    {
      buf=calloc(BUFSIZE, 1);
      nodenames=calloc(N, MAX_NNL);
      strcpy(name, mpctopo);
      strcat(name, "/");
      strcat(name, argv[2]);
      strcat(name, ".def");
      if((fp=fopen(name,"r"))==NULL)
        {
          sumerr=1;
          printf("mpcbcast: can't open file %s\n", name);
        }
      else
        {
          for(i=0; i<N; i++)
            fgets(nodenames[i], MAX_NNL, fp);
          fclose(fp);
        }
    }
  MPI_Bcast(&sumerr, 1, MPI_INT, HOST, MPI_COMM_WORLD);
  if(sumerr)
    {
      MPI_Finalize();
      exit(-1);
    }
    
  for(i=3; i<argc; i++)
    {
      filesize=1;
      strcpy(name, mpcload);
      strcat(name, "/");
      strcat(name, argv[i]);
      {
        if(myrank==HOST)
          {
            if((fp=fopen(name, "r"))==NULL)
              {
                error=1;
                hm=myrank;
                printf("mpcbcast:   Cannot open file %s.\n", name);
              }
            else
              {
                filesize=fread(buf, 1, BUFSIZE, fp);
                if(!feof(fp) || ferror(fp))
                  {
                    error=1;
                    hm=myrank;
                    printf("mpcbcast: file '%s' too big (>%d Kb).\n", name, BUFSIZE/Kb);
                  }
              }
          }
        else
          if((fp=fopen(name, "w"))==NULL)
            {
              error=1;
              hm=myrank;
            }
        MPI_Reduce(&error, &sumerr, 1, MPI_INT, MPI_SUM, HOST, MPI_COMM_WORLD);
        IF_HOST {
          int j;
          if(sumerr)
            printf("mpcbcast: problems with file %s on %d processors:\n", argv[i], sumerr);
          else
            printf("mpcbcast: broadcasting \'%s\'\n", argv[i]);
          ranks=calloc(N, sizeof(int));
          for(j=0; j<N; j++)
            ranks[j]=-1;
        }
        MPI_Gather(&hm, 1, MPI_INT, ranks, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        IF_HOST {
          int j;
          if(sumerr)
            for(j=0; j<N; j++)
              if(ranks[j]>=0)
                printf("          %s\n", nodenames[ranks[j]]);
          free(ranks);
        }
        MPI_Bcast(&sumerr, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        if(sumerr)
          {
            MPI_Finalize();
            exit(-1);
          }
        MPI_Bcast(&filesize, 1, MPI_INT, HOST, MPI_COMM_WORLD);
        if(myrank!=HOST)
          buf=calloc(filesize, 1);
        MPI_Bcast(buf, filesize, MPI_CHAR, HOST, MPI_COMM_WORLD);
        if(myrank!=HOST) {
          filesize=fwrite(buf, 1, filesize, fp);
          free(buf);
        }
      }
    }
  MPI_Finalize();
  exit(0);
}
