/*
 * $Id: tiling.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


#include "be_print.h"
#include "ress.h"


#define DEFAULT_TILE_SIZE 128

#define CYCLE_TIME "Mpc_tcycle"
#define MEMLEVELS "Mpc_memlevels"
#define L1CACHE_LEVEL "Mpc_L1CACHE_LEVEL"
#define MAINMEMORY_LEVEL "Mpc_MAIN_MEMORY_LEVEL"
#define READ_TIME "Mpc_tread"
#define WRITE_TIME "Mpc_twrite"
#define BLOCK_TIME "Mpc_block"
#define OPER_TIME "Mpc_toper"

int prelast_depth=0;

#ifndef FROM_DB

static void print_operation_time(tTree,int,int);
static int get_terminal_type_number(tTree pType);
static char* TypeMacroName(int);
static char* OperMacroName(int);


static void print_t_prelast(tTree pParentExpr,tTree pExpr) {
  tTree pType;
  
  PointerControl(pExpr);
  pType=pExpr->MPC_Expr.Type;

  if(expr_depth(pExpr)==prelast_depth) {
    if((pParentExpr!=NoTree)&&(expr_depth(pParentExpr)>expr_depth(pExpr))) 
      print_operation_time(pType,MEM_WRITE,MEM_OPER);
    if(pExpr->Kind==kMPC_BinaryExpr)
      print_operation_time(pType,pExpr->MPC_BinaryExpr.OpCode,BIN_OPER);
    if(pExpr->Kind==kMPC_UnaryExpr)
      print_operation_time(pType,pExpr->MPC_UnaryExpr.OpCode,UN_OPER);
  }
  else if(expr_depth(pExpr)==(prelast_depth-1)) {
    if((pParentExpr!=NoTree)&&(expr_depth(pParentExpr)>expr_depth(pExpr))) 
      print_operation_time(pType,MEM_READ,MEM_OPER);
  }
  else if(expr_depth(pExpr)==(prelast_depth+1)) {
    if((pExpr->Kind==kMPC_UnaryExpr)&&(pExpr->MPC_UnaryExpr.OpCode==BRACKETS))
      print_operation_time(pType,INDEX,UN_OPER);
  }
}

static void print_operation_time(tTree pType,int oper,int oper_class) {
  int TermType;

  TermType=get_terminal_type_number(pType);
  c_blank;
  blank(SKIP);
  switch(oper_class) {
  case MEM_OPER:
    switch (oper) {
    case MEM_READ:
      fprintf(file,"+" READ_TIME "[%s][" MAINMEMORY_LEVEL "]\n",TypeMacroName(TermType));
      break;
    case MEM_WRITE:
      fprintf(file,"+" WRITE_TIME "[%s][" MAINMEMORY_LEVEL "]\n",TypeMacroName(TermType));
      break;
    }
    break;
  case BIN_OPER:
  case UN_OPER:
    fprintf(file,"+" OPER_TIME "[%s][%s]\n",
            TypeMacroName(TermType),OperMacroName(oper));
    break;
  }

}
#endif


int calc_apply_tiling(tTree pExpr) {
  if((xopt == 1)&&(XOPT==0)) return 0;
  else return 1;
  /*
  return 1;
  */
}


void TileSize_print(tTree pExpr) {

#ifdef FROM_DB
  long tile_size;
  if(rs_get(RS_LONG,"TILE_SIZE",&tile_size)==RS_OPERATION_FAILED) tile_size=DEFAULT_TILE_SIZE;
  fprintf(file,"%ld;\n",tile_size);
  
#else
  int expr_depth;
  tTree pOperand;
  tTree pOpType;
  tTree pTerminalType;
  int TermType;
  
  pOperand=pExpr->MPC_UnaryExpr.Operand;
  PointerControl(pOperand);
  pOpType=pOperand->MPC_Expr.Type;
  PointerControl(pOpType);
  expr_depth=index_level(pOpType);
  prelast_depth=expr_depth-1;
  pTerminalType=get_TerminalType(pOpType);
  TermType=get_terminal_type_number(pOpType);
  fprintf(file,"Mpc_sqrt((" MEMLEVELS "[" L1CACHE_LEVEL"]/sizeof(");
  print_BasicTypeName(pTerminalType);
  fprintf(file,"))*(" CYCLE_TIME "\n");
  ExprPiece_traverse(NoTree,pOperand,print_t_prelast);
  c_blank;
  blank(SKIP);
  fprintf(file,"+" BLOCK_TIME "[%s][" MAINMEMORY_LEVEL "])/(" READ_TIME "[%s][" L1CACHE_LEVEL "+1]"
          "-" READ_TIME "[%s][" L1CACHE_LEVEL "]));\n",TypeMacroName(TermType),
          TypeMacroName(TermType),TypeMacroName(TermType));

  c_blank;
  if((xopt==1)&&(XOPT==1)) fprintf(file,"printf(\" Tile size: %%d \\n\",MPC_tile_size);\n");
#endif
}

#ifndef FROM_DB

static int get_terminal_type_number(tTree pType) {
  tTree  pTermType;
  int type;

  PointerControl(pType);
  pTermType=get_TerminalType(pType);
  PointerControl(pTermType);
  if(pTermType->Kind==kMPC_BasicType)
    type=pTermType->MPC_BasicType.TypeConstructor;
  else type=VOID;
  return type;
}

static char* TypeMacroName(int type) {
  char* name=NULL;
  switch(type) {
  case   NO_TYPE: name="Mpc_NO_TYPE"; break;
  case   VOID: name="Mpc_VOID"; break;            
  case   CHAR: name="Mpc_CHAR"; break;             
  case   SIGNED_CHAR: name="Mpc_SIGNED_CHAR"; break;      
  case   UNSIGNED_CHAR: name="Mpc_UNSIGNED_CHAR"; break;
  case   SHORT:  name="Mpc_SHORT";         
  case   UNSIGNED_SHORT: name="Mpc_UNSIGNED_SHORT"; break;   
  case   INT: name="Mpc_INT"; break;            
  case   UNSIGNED: name="Mpc_UNSIGNED"; break;       
  case   LONG: name="Mpc_LONG"; break;            
  case   UNSIGNED_LONG: name="Mpc_UNSIGNED_LONG"; break;
  case   FLOAT: name="Mpc_FLOAT"; break;
  case   DOUBLE: name="Mpc_DOUBLE"; break;
  case   LONG_DOUBLE: name="Mpc_LONG_DOUBLE"; break;
  default: internal_error();
  }
  return name;
}

static char* OperMacroName(int oper) {
  char* name=NULL;
  switch(oper) {
  case   NO_OPERATOR: name="Mpc_NO_OPERATOR"; break;
  case   VECT_CONCAT: name="Mpc_VECT_CONCAT"; break;
  case   VECT_EVAL: name="Mpc_VECT_EVAL"; break;
  case   VECT_VALUE: name="Mpc_VECT_VALUE"; break;
  case   BRACKETS: name="Mpc_BRACKETS"; break;
  case   INDEX: name="Mpc_INDEX"; break;
  case   GRID: name="Mpc_GRID"; break;
  case   DOT: name="Mpc_DOT"; break;                
  case   ARROW: name="Mpc_ARROW"; break;               
  case   POST_INC: name="Mpc_POST_INC"; break;             
  case   POST_DEC: name="Mpc_POST_DEC"; break;
  case   PRE_INC: name="Mpc_PRE_INC"; break;            
  case   PRE_DEC: name="Mpc_PRE_DEC"; break;        
  case   ADDRESS: name="Mpc_ADDRESS"; break;            
  case   STAR: name="Mpc_STAR"; break;               
  case   NEG: name="Mpc_NEG"; break;             
  case   NOT: name="Mpc_NOT"; break;                
  case   LOG_NOT: name="Mpc_LOG_NOT"; break;            
  case   MULT: name="Mpc_MULT"; break;               
  case   DIV: name="Mpc_DIV"; break;                
  case   MOD: name="Mpc_MOD"; break;                
  case   MAX: name="Mpc_MAX"; break;             
  case   MIN: name="Mpc_MIN"; break;                
  case   PLUS: name="Mpc_PLUS"; break;
  case   MINUS: name="Mpc_MINUS"; break;              
  case   LEFT_SHIFT: name="Mpc_LEFT_SHIFT"; break;
  case   RIGHT_SHIFT: name="Mpc_RIGHT_SHIFT"; break;        
  case   LESS_THEN: name="Mpc_LESS_THEN"; break;           
  case   GREAT_THEN: name="Mpc_GREAT_THEN"; break;         
  case   LESS_OR_EQ: name="Mpc_LESS_OR_EQ"; break;         
  case   GREAT_OR_EQ: name="Mpc_GREAT_OR_EQ"; break;      
  case   EQUAL: name="Mpc_EQUAL"; break;              
  case   NOT_EQUAL: name="Mpc_NOT_EQUAL"; break;        
  case   AND: name="Mpc_AND"; break;                
  case   EXCL_OR: name="Mpc_EXCL_OR"; break;
  case   INCL_OR: name="Mpc_INCL_OR"; break;           
  case   LOG_AND: name="Mpc_LOG_AND"; break;            
  case   LOG_OR: name="Mpc_LOG_OR"; break;              
  case   CONDITION: name="Mpc_CONDITION"; break;          
  case   ASSIGN: name="Mpc_ASSIGN"; break;           
  case   MULT_ASSIGN: name="Mpc_MULT_ASSIGN"; break;       
  case   DIV_ASSIGN: name="Mpc_DIV_ASSIGN"; break;         
  case   MOD_ASSIGN: name="Mpc_MOD_ASSIGN"; break;       
  case   PLUS_ASSIGN: name="Mpc_PLUS_ASSIGN"; break;      
  case   MINUS_ASSIGN: name="Mpc_MINUS_ASSIGN"; break;      
  case   LSHIFT_ASSIGN: name="Mpc_LSHIFT_ASSIGN"; break;
  case   RSHIFT_ASSIGN: name="Mpc_RSHIFT_ASSIGN"; break;      
  case   AND_ASSIGN: name="Mpc_AND_ASSIGN"; break;        
  case   EXCL_OR_ASSIGN: name="Mpc_EXCL_OR_ASSIGN"; break;     
  case   INCL_OR_ASSIGN: name="Mpc_INCL_OR_ASSIGN"; break;     
  case   COMMA: name="Mpc_COMMA"; break;
  default: internal_error();
  }
  return name;
}
#endif














