/*
 * $Id: ress.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


#include <stdlib.h>
#include <string.h>
#include "ress.h"

char resdb[RS_MAX_DB_LENGTH]={0};
int rs_ready=0;


int rs_init(char* filename) {
  int length=0;
  FILE* f;
  if(filename==NULL) return RS_OPERATION_FAILED;
  f=fopen(filename,"r");
  if(f==NULL) return RS_OPERATION_FAILED;
  length=fread(resdb,1,RS_MAX_DB_LENGTH-1,f);
  if(length==0) return RS_OPERATION_FAILED;
  resdb[length]=0;
  fclose(f);
  rs_ready=1;
  return RS_OPERATION_SUCCESS;
}

  
int rs_get(int resource_type, char* resource_name, void* resource) {
  char *rpos,*rend,*r_store;
  int length=0;
  
  if(resource==NULL) return  RS_OPERATION_FAILED;
  if(resource_name==NULL) return  RS_OPERATION_FAILED;

  rpos=strstr(resdb,resource_name);
  if(rpos==NULL) return  RS_OPERATION_FAILED;
  while((*rpos!='=')&&(*rpos!=0)) rpos++;
  if(*rpos==0) return  RS_OPERATION_FAILED;
  else rend=++rpos;
  while((*rend!=';')&&(*rend!=0)) rend++;
  if(*rend==0) return  RS_OPERATION_FAILED;
  length=rend-rpos+2;
  r_store=(char*)malloc(length);
  if(r_store==NULL) return  RS_OPERATION_FAILED;
  *rend=0;
  strcpy(r_store,rpos);
  *rend=';';

  switch(resource_type) {
  case RS_STRING:
    break;
  case RS_LONG:
    {
      char* ptr;
      *((long*)resource)=strtol(r_store,&ptr,10);
      if(ptr==r_store) return  RS_OPERATION_FAILED;
    }
    break;
  case RS_DOUBLE:
    {
      char* ptr;
      *((double*)resource)=strtod(r_store,&ptr);
      if(ptr==r_store) return  RS_OPERATION_FAILED;
    }
    break;
  default:
    return  RS_OPERATION_FAILED;
  }

  return RS_OPERATION_SUCCESS;
}
  
  
  
  
  
