/*
 * $Id: print_NetCreate.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


/* code generation for nets creation */
/* Coded by A.Kalinov 10.95 -  */
/* Version with undefined waiting point only 08.97 - */

#include "be_print.h"
#include "Memory.h"
#define NETS_CREATED "MPC_nets_created"
#define NETS_FREE "MPC_nets_free"

static char* NoBurst="Net";
/*static char* Burst="Burst_net";*/
static char* NetCurBurst;
static char* SubnetCurBurst;
static int voted_num;
static int the_blank;
static int first_var;
static int net_num;
static int subnet_num;
static tTree pExpr;
static int max_close_level;
static int close_level;
static int is_created_net_children;
static int is_closed_of_the_level;
static int is_with_the_level;
static int recv_end_num;
static int count_was_set;
static int barrier_needed;

void set_used_parent(tGen );
void print_subnet_create(tTree pParent, tTree pSubnet);
void print_VoteCount();
static tTree first_not_soft_flexible(tTree );
static int main_fun_block(tTree );
static void set_static_created(tGen );
static void max_level(tGen );
static void is_created_net_child(tGen );

int print_MemberAndPredicate(tTree pNet) {
  int ret;
  PointerControl(pNet);
  pExpr=NULL;
  /*  if(prt) printf("print_MemberAndPredicate pNet=%p Kind=%d\n",pNet,pNet->Kind);*/
  if(pNet != fun_distr) {
    if(pNet->Kind == kMPC_Net ||
       (pNet->Kind == kMPC_Subnet &&
        !(pNet->MPC_Subnet.Flexible == 1))) { 
      cur_pos+=fprintf(file,"if(");
      fprintf(file,"%s(&%s)",MEMBER,VarName(pNet));
      cur_pos+=fprintf(file,") {\n");
      cur_blank+=SKIP;
      ret=0;
    }
    else {
      tTree pParent;
      tTree old_act_net=cur_act_net;
      pParent=first_not_soft_flexible(pNet);
      PointerControl(pParent);
      cur_pos+=fprintf(file,"if(");
      fprintf(file,"%s(&%s)",MEMBER,VarName(pParent));
      cur_pos+=fprintf(file,") {\n");
      cur_blank+=SKIP;
      cur_act_net=pParent->MPC_NetOrSubnet.MyList;
      PointerControl(cur_act_net);
      ret=print_PredicateAndChangeNet(pNet,pParent);
      cur_act_net=old_act_net;
    }
  }
  else {
    ret=0;
  }
  return ret;
}
  
int print_MemberNotPredicate(tTree pNet) {
  int ret=0;
  PointerControl(pNet);
  fprintf(stderr,"Sorry, this kind of the predicate isn't supported now\n");
  internal_error();
  return ret;
}


int is_uncreated_child(tGen yyt) {
  int count=0;
  net_num=0;
  subnet_num=0;
  if(yyt == NoGen) return 0;
  if(yyt->Kind == kNets) {
    tGen pNets=yyt;
    while(pNets != NoGen) {
      tGen pNet=pNets->Nets.Net;
      if(pNet != NoGen && !pNet->Net.Created) {
        tTree pBlock=pNet->Net.Block;
        if(net_count_kind != CREATION) {
          if(!pNet->Net.Subnet && (pNet->Net.Num == point_num ||
              (pNet->Net.Num == EXTERNAL_NUM &&
               first_waiting_point_in_function))) {
            net_num+= (net_count_kind == FREE_NUMBER && pNet->Net.Auto &&
                       main_fun_block(pBlock)) ||
              net_count_kind == CREATED_NUMBER;
          }
          /*if(prt) printf("is_uncreated_child net=%s net_num=%d\n",
                         VarName(pNet->Net.pNet),net_num);*/
        }
        else {
          if((pNet->Net.Num == point_num && pBlock == cur_block) ||
             (pNet->Net.Num == EXTERNAL_NUM &&
               first_waiting_point_in_function)) {
            if(pNet->Net.Subnet == 0) {
              net_num++;
              /*if(prt) printf("is_uncreated_child yyt=%p pNets=%p pNet=%p net_num=%d\n",
                     yyt,pNets,pNet,net_num);*/
            }
            else {
              if(!(pNet->Net.Flexible == 1))
                subnet_num++;
            }
          }
        }
      }
      pNets=pNets->Nets.Next;
    }
  }
  count=net_num+subnet_num;
  /*if(prt) printf(" is_uncreated_child net_num=%d subnet_num=%d\n",
                     net_num,subnet_num);*/
  return count;
}
  
void net_create(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      tTree old_act_net=cur_act_net;
      int net_or_subnet_num;
      net_num=0;
      subnet_num=0;
      net_count_kind=CREATION;
      net_or_subnet_num=is_uncreated_child(yyt->Net.Children);
      if(prt) printf("net_or_subnet_num=%d net_num=%d subnet_num=%d\n",
	     net_or_subnet_num,net_num,subnet_num);
      if(net_or_subnet_num == 0) return;
      else {
	tGen pNets=yyt->Net.Children;
	tGen pNet;
	tTree pParent;
	pNets=yyt->Net.Children;
	pParent=yyt->Net.pNet;
	PointerControl(pParent);
	NetCurBurst=NoBurst;
	SubnetCurBurst=NoBurst;
	while(pNets != NoGen) {
	  tTree p_net;
          int i,braces;
	  pNet=pNets->Nets.Net;
	  if(pNet != NoGen && !pNet->Net.Created &&
             (pNet->Net.Block == cur_block ||
              (pNet->Net.Block == pRoot &&
               first_waiting_point_in_function))) {
	    if(!(pNet->Net.Flexible == 1)) {
              tPosition real_pos;
              cur_act_net=pParent->MPC_NetOrSubnet.MyList;
	      p_net=pNet->Net.pNet;
	      PointerControl(p_net);
              real_pos=RealPosition(p_net->MPC_NetOrSubnet.Pos);
              c_blank;
              fprintf(file,"MPC_Source_position_set(%d,%d);\n",
                      real_pos.Column,real_pos.Line);
              c_blank;
              braces=print_MemberAndPredicate(pParent);
	      if(p_net->Kind == kMPC_Net) {
                if(!pNet->Net.Auto) {
                  c_blank;
                  fprintf(file,"if(%s(&%s)) {\n",
                          IS_UNVOTED,VarName(p_net));
                  cur_blank+=SKIP;
                }
		if(p_net->MPC_Net.Topology != CONST) {
                  tTree pNetTypeSpec=p_net->MPC_Net.NetType;
                  tTree pNetType,pArgList,pParamList;
                  tTree old_pCurParamList=pCurParamList;
                  tTree old_pCurExprs=pCurExprs;
                  PointerControl(pNetTypeSpec);
                  pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
                  PointerControl(pNetType);
                  pParamList=pNetType->MPC_NetType.ParamList;
                  PointerControl(pParamList);
                  pCurParamList=pParamList;
                  pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
                  PointerControl(pArgList);
                  pCurExprs=pArgList;
                  if(pParamList->Kind != kMPC_FreeNode) {
                    c_blank;
                    fprintf(file,"%s.count=",VarName(p_net));
                    print_ParamNumber(pArgList,-1);
                    fprintf(file,";\n");
                    print_CopyParams(p_net,pNetType,pArgList);
                    /*print_topo_params(p_net);*/
                  }
                  pCurParamList=old_pCurParamList;
                  pCurExprs=old_pCurExprs;
		}
		c_blank;
		fprintf(file,"MPC_%s_create(%d,&%s);\n",
			NetCurBurst,p_net->MPC_Net.UniqueNumber,
			VarName(p_net));
                print_prop_to_created(p_net,cur_stat);
                if(!pNet->Net.Auto) {
                  b_end;
                }
                b_end;
                if(braces && !pNet->Net.Auto ) {
                  c_blank;
                  fprintf(file,"else {\n");
                  cur_blank+=SKIP;
                  c_blank;
                  fprintf(file,"if(%s(&%s)) {\n",
                          IS_UNVOTED,VarName(p_net));
                  cur_blank+=SKIP;
                  c_blank;
                  cur_pos+=fprintf(file,"MPC_Set_created(&%s);\n",
                                   VarName(p_net));
                  b_end;
                  b_end;
                }
	      }
	      else {
                if(!pNet->Net.Auto) {
                  c_blank;
                  fprintf(file,"if(%s(&%s)) {\n",
                          IS_UNVOTED,VarName(p_net));
                  cur_blank+=SKIP;
                }
                print_subnet_create(pParent,p_net);
                if(!pNet->Net.Auto) {
                  b_end;
                }
	      }
	      pNet->Net.Created=1;
              if(prt) printf("braces=%d\n",braces);
              for(i=0; i<braces; i++) {
                b_end;
              }
	    }
	  }
	  pNets=pNets->Nets.Next;
	}
      }
      cur_act_net=old_act_net;
    }
  }
}

void print_subnet_create(tTree pParent, tTree pSubnet) {
  int pos;
  int coord_num=0,coord_max;
  int old_not_check=not_check;
  tTree pParentNet;
  tTree pNetType;
  tTree pExpr;
  tTree old_act_net=cur_act_net;
  PointerControl(pParent);
  PointerControl(pSubnet);
  pParentNet=net_parent(pSubnet);
  PointerControl(pParentNet);
  if(prt) printf("print_subnet_create pParentNet=%s\n",VarName(pParentNet));
  if(function_kind == NETWORK && pParent == fun_distr) {
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;
  }
  cur_act_net=pParentNet->MPC_NetOrSubnet.MyList;
  PointerControl(cur_act_net);
  pNetType=pParentNet->MPC_Net.NetType;
  PointerControl(pNetType);
  coord_max=coord_number(pNetType);
  not_check=1;
  c_blank;
  if(!macro) {
    fprintf(file,"int MPC_ind=0, MPC_sub_pow=0, MPC_co[%d];\n",coord_max);
    c_blank;
    fprintf(file,"int* MPC_old_coord=%s.coord;\n",VarName(pParent));
    c_blank;
    fputs("int* MPC_map;\n",file);
    c_blank;
    fprintf(file,"MPC_map=(int*)MPC_Malloc(%s.power*sizeof(int));\n",
            VarName(pParent));
    c_blank;
    fprintf(file,"%s.coord=MPC_co;\n",VarName(pParent));
  }
  else {
    fprintf(file,"MPC_Subnet_create_prologue(%s);\n",
            VarName(pParent));
  }
  c_blank;
  fprintf(file,"for(; MPC_ind<%s.power; MPC_ind++) {\n",
	  VarName(pParent));
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",VarName(pParent));
  pExpr=pSubnet->MPC_Subnet.Predicate;
  PointerControl(pExpr);
  pred_print_Expr_begin(pExpr);
  c_blank;
  cur_pos+=fputs("if(",file);
  print_Expr(pExpr);
  cur_pos+=fputs(") {\n",file);
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_map[MPC_sub_pow]=MPC_Number(&%s,%s.coord);\n",
	  VarName(pParent),VarName(pParent));
  c_blank;
  pos=cur_blank+fputs("if(",file);
  for(coord_num=0; coord_num<coord_max; coord_num++) {
    if(coord_num != 0) {
      fprintf(file," && \n");
      blank(pos);
    }
    fprintf(file,"MPC_co[%d]==MPC_old_coord[%d]",coord_num,coord_num);
  }
  fprintf(file,") {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"%s.rank=MPC_sub_pow;\n",VarName(pSubnet));
  b_end;
  c_blank;
  fprintf(file,"MPC_sub_pow++;\n");
  b_end;
  pred_print_Expr_end(pExpr);
  b_end;
  c_blank;
  if(macro) {
    if(!pSubnet->MPC_Subnet.Flexible) {
      fprintf(file,"MPC_Subnet_create_not_flexible_epilogue(%s,",
              VarName(pSubnet));
    }
    else {
      fprintf(file,"MPC_Subnet_create_flexible_epilogue(%s,",
              VarName(pSubnet));
    }
    fprintf(file,"%s);\n",VarName(pParent));
  }
  else {
    fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pParent));
    c_blank;
    fprintf(file,"if(MPC_sub_pow) {\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,
            "MPC_map=(int*)MPC_Realloc(MPC_map,MPC_sub_pow*sizeof(int));\n");
    c_blank;
    fprintf(file,"%s.mapping=MPC_map;\n",VarName(pSubnet));
    c_blank;
    fprintf(file,"%s.power=MPC_sub_pow;\n",VarName(pSubnet));
    c_blank;
    /*fprintf(file,"MPC_%ssubnet_create(&%s);\n",
      SubnetCurBurst,VarName(pSubnet));*/
    if(!pSubnet->MPC_Subnet.Flexible) {
      fprintf(file,"MPC_Subnet_create(&%s,MPC_NOT_FLEXIBLE);\n",
              VarName(pSubnet));
    }
    else {
      fprintf(file,"MPC_Subnet_create(&%s,MPC_FLEXIBLE);\n",
              VarName(pSubnet));
    }
    b_end;
    c_blank;
    fprintf(file,"else {\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Error_raise(\"Empty subnet\");\n");
    b_end;
  }
  b_end;
  not_check=old_not_check;
  cur_act_net=old_act_net;
}

/*static int unknown_parent(tGen yyt) {
  int unknown=0;
  tGen pParent=yyt->Net.Parent;
  if(prt) printf("finding unknown_parent to %s\n",VarName(yyt->Net.pNet));
  while(pParent != int_gen_tree) {
    GenControl(pParent);
    if(prt) printf("unknown_parent %s\n",VarName(pParent->Net.pNet));
    unknown=pParent->Net.Kind == UNKNOWN  ||
      pParent->Net.Subnet || pParent->Net.Num == point_num;
    if(unknown) break;
    pParent=pParent->Net.Parent;
  }
  return unknown;
}*/
  
/*static int unknown_parent(tGen yyt) {
  int ret=0;
  int single=0;
  int unknown=0;
  tGen pParent=yyt->Net.Parent;
  if(prt) printf("finding unknown_parent to %s\n",VarName(yyt->Net.pNet));
  while(pParent != int_gen_tree) {
    GenControl(pParent);
    if(prt) printf("unknown_parent %s\n",VarName(pParent->Net.pNet));
    if(pParent->Net.SingleNode) {
      single=1;
    }
    else {
      unknown=pParent->Net.Kind == UNKNOWN  || pParent->Net.Subnet;
    }
    if(unknown) {
      if(single) {
        unknown=0;
        single=0;
      }
      else {
        ret=1;
        break;
      }
    }
    else {
      single=0;
    }
    pParent=pParent->Net.Parent;
  }
  return ret;
}*/
  
void print_vote_name(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(yyt->Net.Created == 0 && yyt->Net.Subnet == 0) {
	tTree pNet;
	pNet=yyt->Net.pNet;
	if(voted_num++) {
	  fputs(",",file);
	}
	fprintf(file,"%d",
		pNet->MPC_NetOrSubnet.UniqueNumber);
      }
    }
  }
}

void print_vote_case(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(yyt->Net.Created == 0 && yyt->Net.Subnet == 0) {
	tTree pNet;
	pNet=yyt->Net.pNet;
        c_blank;
	fprintf(file,"case %d: MPC_SetNet(&%s); break;\n",
		pNet->MPC_NetOrSubnet.UniqueNumber,VarName(pNet));
      }
    }
  }
}

void find_not_created(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(yyt->Net.Created == 0 && yyt->Net.Subnet == 0) {
	not_created_num++;
      }
    }
  }
}

void print_net_voted(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(yyt->Net.Created == 0 && yyt->Net.Subnet == 0) {
	tTree p_net;
	/*if(voted_num++) {
	  fputs(",\n",file);
	  blank(the_blank+cur_blank);
	}*/
	p_net=yyt->Net.pNet;
	PointerControl(p_net);
        c_blank;
        fprintf(file,"%s[%d]=&%s;\n",
                      NETS_VOTED,voted_num++,VarName(p_net));
	/*fprintf(file,"&%s",VarName(p_net));*/
      }
    }
  }
}

void set_predecessor_to_0(tGen yyt) {
  if(yyt != NoGen && yyt->Kind == kNet) {
    yyt->Net.Pred=0;
  }
}
  
void print_VoteSection(tTree pStats) {
  PointerControl(pStats);
  if(prt) printf("\n  print_VoteSection  pStats=%p pStats->Kind=%d\n",
         pStats,pStats->Kind);
  /*++point_num;*/
  creation_section_kind=UNKNOWN;
  state_kind=UNKNOWN; 
  block_list=NoBlock;
  fill_gen_tree(pStats);
  cur_block=pStats;
  not_created_num=0;
  if(function_kind == BASIC) {
    TraverseGenTD(int_gen_tree,find_not_created);
    if(prt) printf("VoteSection not_created_num=%d\n",not_created_num);
    if(not_created_num == 0) {
      if(prt) printf(" nothing to be create \n ");
      return;
    }
    else {
      /*TraverseGenTD(int_gen_tree->Net.Children,creation_section_sort);*/
    }
    TraverseGenTD(int_gen_tree,set_predecessor_to_0);
    TraverseGenTD(int_gen_tree->Net.Children,set_predecessor);
    /*c_blank;*/
    fprintf(file,"{\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Waiting_point_begin(");
    fprintf(file,"MPC_UNKNOWN_COUNT,MPC_UNKNOWN_COUNT);\n");
    fprintf(file,"%s_%d:\n",WAITING_POINT,point_num);
    c_blank;
    fputs("if(!MPC_Is_busy()) {\n",file);
    cur_blank+=SKIP;
    c_blank;
    the_blank=fprintf(file,"MPC_Name %s[%d]={",
                      NETS_NAMES,not_created_num);
    voted_num=0;
    TraverseGenTD(int_gen_tree->Net.Children,
                  print_vote_name);
    fputs("};\n",file);
    c_blank;
    the_blank=fprintf(file,"%s %s[%d];\n",
                      NET_POINTER_TYPE,NETS_VOTED,not_created_num);
    voted_num=0;
    TraverseGenTD(int_gen_tree,print_net_voted);
    c_blank;
    fprintf(file,"MPC_Offer(&MPC_command,%s,%s,%d);\n",
            NETS_NAMES,NETS_VOTED,not_created_num);
    b_end;  
    c_blank;
    fprintf(file,"if(MPC_Is_busy()) {\n");
    cur_blank+=SKIP;
    if(pStats->Kind == kMPC_Compound &&
       !pStats->MPC_Compound.FunctionBody) {
      blank_is_necessary=0;
    }
  }
}

static void print_local_barrier(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) 
      if(prt)
        printf("end_vote_barrier yyt=%s Pred=%d close_level=%d Closed=%d\n",
               VarName(yyt->Net.pNet),yyt->Net.Pred,close_level,
               yyt->Net.Closed);
    {
      tTree p_net=yyt->Net.pNet;
      tTree p_parent;
      tGen pParent;
      int braces,i;
      PointerControl(p_net);
      c_blank;
      braces=1+print_MemberAndPredicate(p_net);
      c_blank;
      fprintf(file,"MPC_Local_barrier(&%s);\n",VarName(p_net));
      yyt->Net.Used=0;
      p_parent=net_parent(p_net);
      PointerControl(p_parent);
      pParent=p_parent->MPC_NetOrSubnet.pGen;
      GenControl(pParent);
      if(pParent->Net.Pred == 0 && p_parent != HOST) {
        c_blank;
        fprintf(file,"if(%s(&%s)) MPC_Send_end();\n",PARENT,
                VarName(p_net));
      }
      for(i=0; i<braces; i++) {
        b_end;
      }
    }
  }
}

void end_vote_barrier(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) 
      if(prt)
        printf("end_vote_barrier yyt=%s Pred=%d close_level=%d Closed=%d\n",
               VarName(yyt->Net.pNet),yyt->Net.Pred,close_level,
               yyt->Net.Closed);
    if(yyt->Kind == kNet && !yyt->Net.Closed &&
       yyt->Net.Pred == close_level && !yyt->Net.Subnet &&
       (yyt->Net.pNet != HOST &&
        yyt->Net.pNet != SINGLE_NODE &&
        yyt->Net.pNet != COMPUTING_SPACE &&
        yyt->Net.pNet != CONST_NET) /*&&
       !(yyt->Net.Num == point_num || 
         (yyt->Net.Num == EXTERNAL_NUM &&
          first_waiting_point_in_function))*/) {
      tTree p_net=yyt->Net.pNet;
      tTree p_parent;
      tGen pParent;
      int braces,i;
      PointerControl(p_net);
      c_blank;
      braces=1+print_MemberAndPredicate(p_net);
      c_blank;
      is_with_the_level=1;
      fprintf(file,"MPC_Local_barrier(&%s);\n",VarName(p_net));
      yyt->Net.Used=0;
      p_parent=net_parent(p_net);
      PointerControl(p_parent);
      pParent=p_parent->MPC_NetOrSubnet.pGen;
      GenControl(pParent);
      if(pParent->Net.Pred == 0 && p_parent != HOST) {
        c_blank;
        fprintf(file,"if(%s(&%s)) MPC_Send_end();\n",PARENT,
                VarName(p_net));
        recv_end_num++;
      }
      for(i=0; i<braces; i++) {
        b_end;
      }
    }
    else if(yyt->Net.Pred >= close_level) {
      is_with_the_level=1;
    }
  }
}

/*static void print_end_of_unknown() {
  close_level=1;
  recv_end_num=0;
  while(1) {
    is_with_the_level=0;
    traverse_gen_tree(int_gen_tree->Net.Children,end_vote_barrier);
    if(!is_with_the_level) break;
    close_level++;
  }
  closing_needed=not_created_num;
  if(closing_needed != 0) {
    tTree old_cur_net=cur_act_net;
    cur_act_net=HOST_LIST;
    c_blank;
    fprintf(file,"if(MPC_Is_host()) {\n");
    cur_blank+=SKIP;
    if(recv_end_num>0) {
      c_blank;
      fprintf(file,"MPC_Recv_end(%d);\n",recv_end_num);
    }
    c_blank;
    fprintf(file ,"MPC_Host_out();\n");
    b_end;
    cur_act_net=old_cur_net;
  }
}*/

static void print_NetBarrier(tGen yyt) {
  if(yyt != NoGen && yyt->Kind == kNet && !yyt->Net.Closed) {
    if(prt)
    printf("print_NetBarrier net=%s block=%p cur_block=%p Level=%d close_level=%d\n",
           VarName(yyt->Net.pNet),yyt->Net.Block,cur_block,
           yyt->Net.Level,close_level);
    if(!yyt->Net.Subnet && yyt->Net.Level == close_level) {
      is_created_net_children=0;
      is_created_net_child(yyt->Net.Children);
      if(prt) printf("is_created_net_child=%d\n",is_created_net_children);  
      if(is_created_net_children) {
        print_local_barrier(yyt);
      }
    }
  }
}
void print_host_out() {
  c_blank;
  fprintf(file,"if(MPC_Is_host()) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file ,"MPC_Host_out();\n");
  /*b_end;*/
}

static void print_end_of_unknown() {
  if(not_created_num) {
    max_close_level=0;
    traverse_gen_tree(int_gen_tree->Net.Children,max_level);
    if(prt) printf("max_close_level=%d\n",max_close_level);
    for(close_level=max_close_level-1; close_level > 0; close_level--) {
      traverse_gen_tree(int_gen_tree->Net.Children,print_NetBarrier);
    }
    print_host_out();
  }
}

void print_VoteExit() {
  /*empty function*/
}
void print_BreakVoteExit() {
/* deletes nothing, marks and sets barriers, if necassary, only */    
  if(prt) printf("\n\n  print_BreakVoteExit \n");
  if(prt) printf("cur_block=%p block_number=%d not_created_num=%d\n",
                     cur_block,
                     cur_block != NoTree ?
                     cur_block->MPC_Compound.UniqueNumber:0,
                     not_created_num);
  if(not_created_num) {
    fprintf(file,"/* BreakVoteExit begin */\n");
    print_end_of_unknown();
    b_end;
    b_end;
    traverse_gen_tree(int_gen_tree->Net.Children,set_static_created);
    c_blank;
    fprintf(file,"MPC_Waiting_point_end();\n");
    b_end;
    fprintf(file,"/* BreakVoteExit end */\n");
  }
  /*not_created_num=0;*/
  state_kind=KNOWN;
  first_waiting_point_in_function=0;
}

void print_CommonVoteExit() {
/* deletes nothing, marks and sets barriers, if necassary, only */    
  if(prt) printf("\n\n  print_CommonVoteExit \n");
  if(prt) printf("cur_block=%p block_number=%d not_created_num=%d\n",
                     cur_block,
                     cur_block != NoTree ?
                     cur_block->MPC_Compound.UniqueNumber:0,
                     not_created_num);
  if(function_kind == BASIC)
    fprintf(file,"/* CommomVoteExit begin */\n");
  /*print_end_of_unknown();
      b_end;*/
  print_NetRelease();
  b_end;
  if(not_created_num) {
    b_end;
    traverse_gen_tree(int_gen_tree->Net.Children,set_static_created);
    c_blank;
    fprintf(file,"MPC_Waiting_point_end();\n");
    b_end;
    if(function_kind == BASIC)
      fprintf(file,"/* CommonVoteExit end */\n");
  }
  /*not_created_num=0;*/
  state_kind=KNOWN;
  first_waiting_point_in_function=0;
}

void print_EmptyOffer() {
  c_blank;
  fprintf(file,"if(!MPC_Is_busy()) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_Offer(&MPC_command,NULL,NULL,0);\n");
  b_end;
  c_blank;
  fprintf(file,"MPC_Waiting_point_end();\n");
}

void print_EndVoteExit() {
/* deletes nothing, marks and sets barriers, if necassary, only */    
  if(prt) printf("\n\n  print_CommonVoteExit \n");
  if(prt) printf("cur_block=%p block_number=%d not_created_num=%d\n",
                     cur_block,
                     cur_block != NoTree ?
                     cur_block->MPC_Compound.UniqueNumber:0,
                     not_created_num);
  if(function_kind == BASIC)
      fprintf(file,"/* EndVoteExit begin */\n");
    /*print_end_of_unknown();
      b_end;*/
  print_NetRelease();
  if(not_created_num) {
    b_end;
    /*c_blank;
      fprintf(file,"MPC_Waiting_point_end();\n");*/
    fprintf(file,"%s_%d:\n",
            RECONFIG_POINT,
            cur_block->MPC_Compound.UniqueNumber);
    print_EmptyOffer();
    /*    c_blank;
    fprintf(file,"if(!MPC_Is_busy()) {\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Offer(&MPC_command,NULL,NULL,0);\n");
    b_end;
    c_blank;
    fprintf(file,"MPC_Waiting_point_end();\n");*/
    /*b_end;*/
    if(function_kind == BASIC)
      fprintf(file,"/* EndVoteExit end */\n");
  }
  closing_needed=0;
  /*not_created_num=0;*/
  state_kind=KNOWN;
  first_waiting_point_in_function=0;
}

void null_parent(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      yyt->Net.Parent=NoGen;
    }
  }
}

void close_Children(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet && yyt->Net.Children != NoGen) {
      tGen pNets;
      tGen prev_Nets;
      tGen pNet;
/*      if(prt) printf(" close_Children begin\n"); */
      pNets=yyt->Net.Children;
      prev_Nets=NoGen;
      while(pNets != NoGen) {
	pNet=pNets->Nets.Net;
/*	printf("pNet=%p\n",pNet); */
	if(pNet != NoGen) {
	  if(pNet->Net.Block != cur_block || pNet->Net.Auto != 1) {
	    prev_Nets=pNets;
	    pNets=pNets->Nets.Next;
	  }
	  else {
	    tGen pDeleted;
	    pDeleted=pNets;
	    if(prev_Nets == NoGen) {
	      yyt->Net.Children=pNets->Nets.Next;
	      pNets=yyt->Net.Children;
	    }
	    else {
	      prev_Nets->Nets.Next=pNets->Nets.Next;
	      pNets=prev_Nets->Nets.Next;
	    }
	    pDeleted->Nets.Next=NoGen;
	    if(prt) printf(" before ReleaseGen tree deleted \n");
	    print_gen_tree(pDeleted,4);
	    /*TraverseGenTD(pDeleted,null_parent);
	    ReleaseGen(pDeleted);*/
	  }
	  if(prt) printf("pNets=%p\n",pNets);
	}
	else 
	  return;
      }
    }
  }
}

void close_gen_block() {
  if(prt) printf("\n\n close_gen_block  \n\n");
  if(prt) printf("\n internal gen tree before close_gen_block int_gen_tree=%p\n",
	 int_gen_tree);
  print_gen_tree(int_gen_tree,0);
  
  /*TraverseGenTD*/TraverseGenBU(int_gen_tree,close_Children);
  
  if(prt) printf("\n internal gen tree after close_gen_block int_gen_tree=%p\n",
	 int_gen_tree);
	  print_gen_tree(int_gen_tree,0);
}

/*void set_max_level(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(yyt->Net.Level > max_level) max_level=yyt->Net.Level;
    }
  }
}*/

void define_pow_var(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      tTree pBlock=yyt->Net.Block;
      PointerControl(pBlock);
      yyt->Net.Used=0;
      if(prt) printf("define_pow_var yyt=%s net_num=%d subnet_num=%d\n",
                     VarName(yyt->Net.pNet),net_num,subnet_num);
      if(is_uncreated_child(yyt->Net.Children)/* &&
         (net_count_kind == CREATED_NUMBER) ||
         (net_count_kind == FREE_NUMBER &&
          !yyt->Net.Subnet && yyt->Net.Auto &&
          main_fun_block(pBlock))*/) { 
	tString yys;
	yys=yyt->Net.Name;
	Free(strlen(yys),yys);
	yyt->Net.Name=make_pow_var_name(yyt->Net.pNet);
	c_blank;
        if(net_count_kind == CREATED_NUMBER) {
          fprintf(file,"int %s;\n",yyt->Net.Name);
        }
        else {
          fprintf(file,"int %s;\n",yyt->Net.Name);
        }
      }
    }
  }
}

int is_distributed_parent(tGen pNet) {
  if(pNet == NoGen) return 0;
  pNet=pNet->Net.Parent;
  while(pNet != NoGen) {
    if(pNet->Net.SingleNode) {
      pNet=pNet->Net.Parent;
    }
    else {
      return 1;
    }
  }
  return 0;
}

void set_used_parent(tGen pNet) {
  if(pNet == NoGen) return;
  pNet=pNet->Net.Parent;
  while(pNet != NoGen) {
    pNet->Net.Used=2;
    pNet=pNet->Net.Parent;
  }
}

void compute_topo_param_for_replicated(tGen pNet) {
  if(pNet == NoGen) return;
  pNet=pNet->Net.Parent;
  while(pNet != NoGen) {
    if(pNet->Net.Used==2) {
      tTree p_net=pNet->Net.pNet;
      PointerControl(p_net);
      if(p_net->MPC_Net.Topology == SPACE_REPLICATED) {
	print_topo_params(p_net);
      }
      pNet->Net.Used=1;
    }  
    pNet=pNet->Net.Parent;
  }
}

void set_pow_var(tGen yyt) {
  if(yyt != NoGen) {
    if(net_count_kind == CREATION) exit(0);
    if(yyt->Kind == kNet &&
              is_uncreated_child(yyt->Net.Children)) {
      tGen pNets;
      int first=1;
      pNets=yyt->Net.Children;
      c_blank;
      the_blank=fprintf(file,"%s=(",yyt->Net.Name);
      while(pNets != NoGen) {
        tGen pNet;
        pNet=pNets->Nets.Net;
        if(pNet != NoGen && !pNet->Net.Subnet) {
          tTree pBlock=pNet->Net.Block;
          PointerControl(pBlock);
          if((net_count_kind == CREATED_NUMBER) ||
             (net_count_kind == FREE_NUMBER && pNet->Net.Auto &&
              main_fun_block(pBlock))) {
            if(!pNet->Net.Created) {
              if(first) { 
                first=0;
              }
              else {
                fputs("+\n",file);
                blank(the_blank+cur_blank);
              }
              if(pNet->Net.Auto) {
                fprintf(file,"1");
              }
              else {
                tTree p_net;
                p_net=pNet->Net.pNet;
                PointerControl(p_net);
                fprintf(file,"%s(&%s)",IS_UNVOTED,VarName(p_net));
              }
            }
          }
        }
        pNets=pNets->Nets.Next;
      }
      fputs(")",file);
      if(!yyt->Net.SingleNode) {
        tTree p_net;
        p_net=yyt->Net.pNet;
        PointerControl(p_net);
        fputs("*\n",file);
        blank(the_blank+cur_blank);
        fprintf(file,"%s(&%s)",
                NET_POWER,VarName(p_net));
      }
      if(is_distributed_parent(yyt)) {
        tGen pLastParent=yyt;
        tGen pParent=yyt->Net.Parent;
        while(pParent != NoGen) {
          if(!pParent->Net.SingleNode && 
             !pLastParent->Net.SingleNode) {
            tTree p_net;
            p_net=pParent->Net.pNet;
            PointerControl(p_net);
            fputs("*\n",file);
            blank(the_blank+cur_blank);
            fprintf(file,"%s(&%s)",
                    NET_POWER,VarName(p_net));
            p_net=net_parent(p_net);
            PointerControl(p_net);
            pLastParent=p_net->MPC_NetOrSubnet.pGen;
          }
          else {
            pLastParent=pParent;
          }
          pParent=pLastParent->Net.Parent;
        }
      }
      fputs(";\n",file);
    }
  }
}

void sum_pow_var(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet &&
          is_uncreated_child(yyt->Net.Children)) {
      tTree pBlock=yyt->Net.Block;
      PointerControl(pBlock);
      if(first_var++ != 0) {
        fputs("+\n",file);
        blank(the_blank+cur_blank);
      }
      fprintf(file,"%s",yyt->Net.Name);
      count_was_set=1;
      /*if(prt) printf("sum_pow_var count_was_set=%d\n",count_was_set);*/
    }
  }
}

void print_VoteCount() {
  /* version with net only */
  if(prt) printf("     before define_pow_var\n");
  traverse_gen_tree(int_gen_tree,define_pow_var);
  if(prt) printf("     before set_used_parent\n");
  traverse_gen_tree(int_gen_tree->Net.Children,set_used_parent);
  if(prt) printf("\n     after set_used_parent\n");
  /*print_gen_tree(int_gen_tree,0);*/
  /*traverse_gen_tree(int_gen_tree->Net.Children,
		    compute_topo_param_for_replicated);
  if(prt) printf("\n     after compute_topo_param_for_replicated\n");*/
  /*print_gen_tree(int_gen_tree,0);*/
  first_var=0;
  if(prt) printf("     before set_pow_var\n");
  traverse_gen_tree(int_gen_tree,set_pow_var);
  first_var=0;
  c_blank;
  the_blank=fprintf(file,"%s=",net_count_kind == CREATED_NUMBER ?
                    NETS_CREATED : NETS_FREE);
  count_was_set=0;
  traverse_gen_tree(int_gen_tree,sum_pow_var);
  if(!count_was_set) fprintf(file,"0");
  fputs(";\n",file);
}

void print_close_net(tGen pNet) {
  tTree p_net=pNet->Net.pNet;
  PointerControl(p_net);
  if(prt) printf("print_close_net pNet=%p p_net=%p Single=%d Subnet=%d\n",
         pNet,p_net,pNet->Net.SingleNode,pNet->Net.Subnet);
  if(pNet->Net.Closed == 0 && !(pNet->Net.Flexible == 1)) {
    if(pNet->Net.Subnet) {
      tTree pParent=p_net->MPC_Subnet.Distribution;
      PointerControl(pParent);
      c_blank;
      fprintf(file,"if(%s(&%s)) {\n",MEMBER,VarName(pParent));
      cur_blank+=SKIP;
      c_blank;
      /*fprintf(file,"MPC_Free(%s.mapping);\n",VarName(p_net));*/
      fprintf(file,"MPC_Net_free(&%s);\n",VarName(p_net));
    }
    else {
      c_blank;
      fprintf(file,"if(%s(&%s)) {\n",MEMBER,VarName(p_net));
      cur_blank+=SKIP;
      if(creation_section_kind ==UNKNOWN) {
        /*c_blank;
        fprintf(file,"int MPC_parent;\n");
          c_blank;
        fprintf(file,"MPC_parent=%s(&%s);\n",PARENT,VarName(p_net));*/
        /*if(pNet->Net.Pred) {
          c_blank;
          fprintf(file,"MPC_Local_barrier(&%s);\n",VarName(p_net));
        }*/
      }
      {
        tTree pParent=p_net->MPC_NetOrSubnet.Distribution;
        tTree pNetType=p_net->MPC_Net.NetType;
        tTree pParamList;
        PointerControl(pParent);
        PointerControl(pNetType);
        if(pNetType->Kind == kMPC_NetTypeSpecifier) {
          pNetType=pNetType->MPC_NetTypeSpecifier.NetType;
          PointerControl(pNetType);
        }
        pParamList=pNetType->MPC_NetType.ParamList;
        if(pParamList != NoTree && pParamList->Kind != kMPC_FreeNode) {
          if(all_known_len(pParamList) > 0) {
            c_blank;
            fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(p_net));
            cur_blank+=SKIP;
            c_blank;
            fprintf(file,"MPC_Free(%s.params);\n",
                    VarName(p_net));
            b_end;
          }
        }
      }
      c_blank;
      fprintf(file,"MPC_Net_free(&%s);\n",VarName(p_net));
      closing_needed++;
      c_blank;
      fprintf(file,"if(!MPC_Is_busy()) \n");
      blank(cur_blank+SKIP);
      if(is_return) {
        fprintf(file,"goto %s_%d;\n",
                RETURN_POINT,is_return);
      }
      else {
        if(is_break) {
          fprintf(file,"goto %s_%d;\n",
                  RECONFIG_POINT,
                  cur_block->MPC_Compound.UniqueNumber);
        }
        else {
          fprintf(file,"goto %s_%d;\n",
                  WAITING_POINT,cur_block->MPC_Compound.UniqueNumber);
        }
      }
    }
    b_end;
  }
  if(!return_free) {
    pNet->Net.Closed=1;
    p_net->MPC_NetOrSubnet.pGen=NoGen;
  }
  is_closed_of_the_level=1;
}  

void print_ChildrenFree(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
    if(prt) printf("print_ChildrenFree net=%s \n",VarName(yyt->Net.pNet));
      print_close_net(yyt);
    }
  }
}

static void is_created_net_child(tGen yyt) {
  if(yyt == NoGen) return;
  if(yyt->Kind == kNets) {
    tGen pNets=yyt;
    while(pNets != NoGen) {
      tGen pNet=pNets->Nets.Net;
      if(prt) printf("pNet=%p pNet->Net.Created=%d pNet->Net.Subnet=%d \n",
             pNet,pNet->Net.Created,pNet->Net.Subnet);
      if(pNet != NoGen/* && pNet->Net.Created*/) {
        tTree pBlock=pNet->Net.Block;
        if(prt) printf("pBlock=%p cur_block=%p\n",pBlock,cur_block);
        if(pBlock == cur_block ||
           (pNet->Net.Num == EXTERNAL_NUM &&
            cur_block->MPC_Compound.FunctionBody)) {
          if(!pNet->Net.Subnet) {
            is_created_net_children++;
            return;
          }
        }
        is_created_net_child(pNet->Net.Children);
      }
      pNets=pNets->Nets.Next;
    }
  }
}

void print_NetFree(tGen yyt) {
  if(yyt != NoGen && yyt->Kind == kNet &&
     !yyt->Net.Closed && yyt->Net.Level == close_level &&
     !(yyt->Net.Flexible == 1)) {
    if(prt)
    printf("print_NetFree net=%s block=%p cur_block=%p Level=%d close_level=%d\n",
           VarName(yyt->Net.pNet),yyt->Net.Block,cur_block,
           yyt->Net.Level,close_level);
    if(yyt->Net.Block == cur_block && yyt->Net.Auto) {
      print_close_net(yyt);
    }
    else {
      if(!yyt->Net.Subnet && not_created_num) {
        is_created_net_children=0;
        is_created_net_child(yyt->Net.Children);
      if(prt) printf("is_created_net_child=%d\n",is_created_net_children);  
        if(is_created_net_children) {
          print_local_barrier(yyt);
        }
      }
    }
  }
}

static void max_level(tGen yyt) {
  if(yyt != NoGen && yyt->Net.Block == cur_block &&
     yyt->Net.Level > max_close_level)
    max_close_level=yyt->Net.Level;
}  

void print_NetRelease(){
  if(prt) printf("\n\n print_NetRelease not_created_num=%d \n\n",
                     not_created_num);
  barrier_needed=0;
  max_close_level=0;
  closing_needed=0;
  traverse_gen_tree(int_gen_tree->Net.Children,max_level);
  if(prt) printf("\n\n print_NetRelease max_close_level=%d \n\n",
                     max_close_level);
  for(close_level=max_close_level; close_level > 0; close_level--) {
    traverse_gen_tree(int_gen_tree->Net.Children,print_NetFree);
  }
  if(!is_return && not_created_num) {
    print_host_out();
  }
}

static tTree searched_net;
static tGen found_node;

void find_net(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet) {
      if(prt) printf("find_net yyt=%p yyt->Net.pNet=%p searched_net=%p\n",
             yyt,yyt->Net.pNet,searched_net);
      if(yyt->Net.pNet == searched_net) {
        found_node=yyt;
      }
    }
  }
}

int is_first_parent_of_second(tTree pFirstNet, tTree pSecondNet) {
  int ret=0;
  tGen node;
  PointerControl(pFirstNet);
  PointerControl(pSecondNet);
  if(prt) {
    printf("is_first %s ",VarName(pFirstNet));
    printf("parent_of_second %s",VarName(pSecondNet));
  }
  /*PrintNet(pFirstNet,"pFirstNet");
  PrintNet(pSecondNet,"pSecondNet");*/
  /*searched_net=pSecondNet;
  found_node=NoGen;*/
  if(pFirstNet == HOST && pSecondNet == COMPUTING_SPACE) ret=1;
  /*printf("is_first_parent_of_second before traverse\n");
  traverse_gen_tree(int_gen_tree,find_net);
  if(prt) printf("found_node=%p \n",found_node);
  if(found_node == NoGen) {
    fprintf(stderr,
            "SecondNet node wasn't found in the net genealogy tree\n");
    internal_error();
  }
  else {
    if(prt) printf(" found_node->Net.Parent=%p \n",found_node->Net.Parent);
    }*/
  else {
    node=pSecondNet->MPC_NetOrSubnet.pGen;
    if(prt) printf(" node=%p",node);
    if(node != NoGen) {
      tGen pParent=node->Net.Parent;
      if(prt) printf(" pParent=%p",pParent);
      while(pParent != NoGen) {
        if(pParent->Net.pNet == pFirstNet) {
          ret=1;
          break;
        }
        pParent=pParent->Net.Parent;
        if(prt) printf(" pParent=%p",pParent);
      }
    }
    /*tTree pParent=pSecondNet->MPC_NetOrSubnet.Distribution;
    while(pParent != NoTree) {
      if(pParent == pFirstNet) {
        ret=1;
        break;
      }
      pParent=pParent->MPC_NetOrSubnet.Distribution;
    }*/
  }
  if(prt) printf(" ? %s\n",ret ? "yes" : "no");
  return ret;
}

int print_Predicate(tTree pNet, int with) {
  tTree pExpr;
  int cur_pos;
  int ret=0;
  PointerControl(pNet);
  if(prt) printf("print_Predicate pNet=%s", VarName(pNet));
  if(prt) printf("  net_to_change=%s \n",
                 net_to_change == NoTree ? "" : VarName(net_to_change));
  while(pNet->Kind == kMPC_Subnet) {
    pExpr=pNet->MPC_Subnet.Predicate;
    PointerControl(pExpr);
    pred_print_Expr_begin(pExpr);
    c_blank;
    cur_pos=cur_blank+fprintf(file,"if(%s",with ? "" : "!(");
    print_Expr(pExpr);
    /* may be we need
       print_Expr_without_indexes(pExpr); */
    cur_pos+=fputs(") {\n",file);
    cur_blank+=SKIP;
    ret+=1;
    pNet=pNet->MPC_Subnet.Distribution;
    PointerControl(pNet);
    if(pNet == net_to_change) break;
  } 
  return ret;
}

static tTree first_not_soft_flexible(tTree pNet) {
  PointerControl(pNet);
  while(pNet->Kind == kMPC_Subnet && pNet->MPC_Subnet.Flexible == 1) {
    pNet=pNet->MPC_Subnet.Distribution;
    PointerControl(pNet);
  }
  return pNet;
}
    
static int main_fun_block(tTree pBlock) {
  int ret=0;
  PointerControl(pBlock);
  if(pBlock->Kind == kMPC_Compound) {
    ret=1;
    if(pBlock->MPC_Compound.FunctionBody && 
       is_main_function) ret=0;
  }
  return ret;
}

static void set_static_created(tGen pNet) {
  if(pNet != NoGen && pNet->Kind == kNet &&
     !pNet->Net.Subnet && !pNet->Net.Auto &&
     (pNet->Net.Num == point_num ||
      (pNet->Net.Num == EXTERNAL_NUM &&
       first_waiting_point_in_function))) {
    tTree p_net=pNet->Net.pNet;
    PointerControl(p_net);
    c_blank;
    fprintf(file,"MPC_Set_created(&%s);\n",VarName(p_net));
  }
}
       
