/*
 * $Id: mpCtree.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


/*****************************************************************************/
/* mpCtree - contains MPC_shell around stdlib functions                      */
/* Coded by A.Rflinov  for A.Lastovtsky 1995                                 */
/* Revised by D.Arapov, 1996                                                 */
/* Release 1.10.96                                                           */
/* 05.01.97 -- predefined types now are not commited                         */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mpC.h"
#include "mpCtree.h"

#define MPC_SIGN_CHAR_KIND 0
#define MPC_UNSIGN_CHAR_KIND 1
#define MPC_ENUM_KIND 0

/* Run time variables */
extern int MPC_count;
extern int MPC_num;
extern MPC_Command MPC_command;

int char_kind=MPC_SIGN_CHAR_KIND;
void MPC_Fill_datatype(MPC_Datatype );

static MPC_Rts_datatype* BasicDT[11]= { 
  &MPC_CHAR,
  &MPC_UNSIGNED_CHAR,
  &MPC_SHORT,
  &MPC_UNSIGNED_SHORT,
  &MPC_INT,
  &MPC_UNSIGNED,
  &MPC_LONG,
  &MPC_UNSIGNED_LONG,
  &MPC_FLOAT,
  &MPC_DOUBLE,
  &MPC_LONG_DOUBLE
};

/******************** MPC_Get_typename ***************************************/
char* MPC_Get_typename(MPC_Datatype datatype)
  {
    return datatype->Base.Name; 
  } /* MPC_Get_typename */

/******************** iMPC_Get_datatype **************************************/
MPC_Rts_datatype iMPC_Get_datatype(MPC_Datatype yyt) 
  {
    if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
    else {
      if(yyt->Base.Datatype == MPC_DATATYPE_NULL) MPC_Fill_datatype(yyt);
    } /* if */
    return yyt->Base.Datatype;
  } /* iMPC_Get_datatype */

/******************** MPC_Get_datatype *******************************************/
MPC_Rts_datatype MPC_Get_datatype(MPC_Datatype yyt)
  {
    MPC_Rts_datatype rts_datatype;
    rts_datatype = yyt->Base.Datatype;     
    if (MPC_DEBUG > 1) printf( "---[%2d]-> MPC_Get_Datatype, datatype = %p, name = %s, rts_datatype = %p\n", MPC_Global_rank(), yyt, yyt->Base.Name, rts_datatype );
    rts_datatype = iMPC_Get_datatype(yyt);
    if (MPC_DEBUG > 1) printf( "<--[%2d]-- MPC_Get_Datatype, datatype = %p, name = %s, rts_datatype = %p\n", MPC_Global_rank(), yyt, yyt->Base.Name, rts_datatype  );
    return rts_datatype;
  } /* MPC_Get_datatype */

/******************** MPC_Get_step *******************************************/
int MPC_Get_step(MPC_Datatype yyt) 
  {
    if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
    return yyt->MPC_array.Step;
  } /* MPC_Get_step */

/******************** MPC_Get_count ******************************************/
int MPC_Get_count(MPC_Datatype yyt) 
  {
    if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
    return yyt->MPC_array.Number;
  } /* MPC_Get_count */

/******************** MPC_Get_element ****************************************/
MPC_Datatype MPC_Get_element(MPC_Datatype yyt) 
  {
    if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
    return yyt->MPC_array.Type;
  } /* MPC_Get_element */

/******************** MPC_Type_size ******************************************/
int MPC_Type_size(MPC_Datatype yyt) 
  {
    if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
    return yyt->Base.Size;
  } /* MPC_Type_size */

/******************** MPC_Elem_copy ******************************************/
int MPC_Elem_copy(
  void* dest, 
  const void* source,
  MPC_Datatype datatype) 
  {
    memmove(dest,source,datatype->Base.Size);
    return MPC_OK;
  } /* MPC_Elem_copy */


/******************** MPC_Elem_copy_conv *************************************/
Int MPC_Elem_copy_conv( void* dest, const void* source, MPC_Datatype recv_datatype, MPC_Datatype send_datatype)
  {
    if(send_datatype == NoMPC_Type) return( MPC_ERR_TYPE );
    if(recv_datatype == NoMPC_Type) return( MPC_ERR_TYPE );
    if(((send_datatype->Base.Kind) !=  kMPC_Array )||
       ((recv_datatype->Base.Kind) !=  kMPC_Array)) MPC_Elem_copy( dest, source, send_datatype );
    else { 
      Int send_step;
      Int recv_step;
      Int send_count;
      Int recv_count;
      Int send_offset;
      Int recv_offset;
      MPC_Datatype elem_type;
      Int elem_size;
      Int i;

      send_count = MPC_Get_count(send_datatype);
      recv_count = MPC_Get_count(recv_datatype);
      if (send_count != recv_count) return( MPC_ERR_TYPE );
      send_offset = 0;
      recv_offset = 0;
      send_step = MPC_Get_step(send_datatype);
      recv_step = MPC_Get_step(recv_datatype);
      elem_type = MPC_Get_element(send_datatype);
      elem_size = MPC_Type_size(elem_type);
      for (i=0;i<send_count;i++) { 
        memmove( (char*)dest+recv_offset,(char*)source+send_offset, elem_size); 
        recv_offset += recv_step*elem_size;
        send_offset += send_step*elem_size;
      } /* for */
    } 
    return MPC_OK;
  } /* MPC_Elem_copy_conv */

/******************** MPC_Fill_datatype **************************************/
void MPC_Fill_datatype(MPC_Datatype yyt) {
  Int needcommit = 1;
  if(yyt == NoMPC_Type) MPC_Error_raise("invalid node of the datatype tree");
  else {
	if(yyt->Base.Datatype != MPC_DATATYPE_NULL) return;
  } /* if */
  switch(yyt->Base.Kind) {
  case kMPC_Basic:
    {
      int constr=yyt->MPC_basic.Constructor;
      if(constr == 1) {
        MPC_Error_raise("invalid basic type in datatype tree");
      }
      else if(constr == 2) {
        yyt->Base.Datatype=*BasicDT[char_kind];
      }
      else {
        yyt->Base.Datatype=*BasicDT[constr-3];
      }
    }
    needcommit = 0;
    break;
  case kMPC_Enum:
    yyt->Base.Datatype=*BasicDT[4+MPC_ENUM_KIND];
    needcommit = 0;
    break;
  case kMPC_Typedef:
    MPC_Fill_datatype(yyt->MPC_typedef.Type);
    yyt->Base.Datatype=MPC_Get_datatype(yyt->MPC_typedef.Type);
    needcommit = 0;
    break;
  case kMPC_Pointer:
    MPC_Fill_datatype(yyt->MPC_pointer.Type);
    yyt->Base.Datatype=MPC_Get_datatype(yyt->MPC_pointer.Type);
    break;
  case kMPC_BitField:
    MPC_Error_raise("sorry, sending of the bit fields isn't supported");
    break;
  case kMPC_Array:
    if(yyt->MPC_array.Bit) {
      MPC_Error_raise("sorry, sending of the bit arrays isn't supported");
    }
    else {
      MPC_Fill_datatype(yyt->MPC_array.Type);
      MPC_Datatype_array(yyt->MPC_array.Number,
                     yyt->MPC_array.Step,
                     yyt->MPC_array.Type,
                     &(yyt->MPC_array.Base.Datatype));
    }
    break;
  case kMPC_Union:
    MPC_Error_raise("sorry, sending of the unions isn't supported");
    break;
  case kMPC_Struct:
    {
      MPC_Datatype pList=yyt->MPC_struct.List;
      int count=0;
      MPC_Datatype* types;
      while(pList != NoMPC_Type) {
        count++;
        pList=pList->MPC_list.Next;
      }
      types = malloc(count*sizeof(MPC_Rts_datatype));
      pList=yyt->MPC_struct.List;
      count=0;
      while(pList != NoMPC_Type) {
        MPC_Fill_datatype(pList->MPC_list.Type);
        types[count++] = pList->MPC_list.Type;       
        pList=pList->MPC_list.Next;
      } /* while */
      MPC_Datatype_record(count, types, &(yyt->MPC_struct.Base.Datatype));
      free(types);
    }
    break;
  case kMPC_Function:
    yyt->Base.Datatype=MPC_UNSIGNED;
    break;
  default:
    MPC_Error_raise("sorry, sending of the unions isn't supported");
    break;
  } 
  if (needcommit) MPC_Type_commit(&(yyt->Base.Datatype));
}  /* MPC_Fill_datatype */
