/*
 * $Id: machdep.h,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


#define MEMORY_LEVELS 2
#define MAX_OPERS 128
#define MAX_TYPES 16
#define INDEX_OF_TYPE(t) (-t)
#define INDEX_OF_OPER(op) (op)

static long levels[MEMORY_LEVELS] = {8192};

static double tau[MEMORY_LEVELS] = {0.03,0.23};

static double tread[MEMORY_LEVELS] = {0.03,0.09};

static double twrite[MEMORY_LEVELS] = {0.08, 0.08};

static double topers[MAX_TYPES][MAX_OPERS];

static void duplicate_by_type(int source_type,int destination_type) {
  int i;
  
  for(i=0;i<MAX_OPERS;i++) topers[destination_type][i]=topers[source_type][i];
}

static void duplicate_by_oper(int source_oper,int destination_oper) {
  int i;
  
  for(i=0;i<MAX_OPERS;i++) topers[i][destination_oper]=topers[i][source_oper];
}


static void init_topers(void) {
  int i,j;
  for(i=0;i<MAX_TYPES;i++)
    for(j=0;j<MAX_OPERS;j++)
         else topers[i][j]=0.00;

  #include"evalar.out"

  duplicate_by_type(CHAR,UNSIGNED_CHAR);
  duplicate_by_type(SHORT,UNSIGNED_SHORT);
  duplicate_by_type(INT,UNSIGNED_INT);
  duplicate_by_type(LONG,UNSIGNED_LONG);
}
