/*
 * $Id: be_print.h,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


#include "context.h"
#include "options.h"
#include "tiling.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "Gen.h"
#include "Type.h"

#define BS 2048 /* Length of the buffer of the directory name */
#define DEFAULT_FILE_NAME "mpC"
#define MAX_IDENT_LEN 1024
#define MAX_NAME_LEN 1024
#define MAX_TYPE_LEN 1024

/* target language */ 
#define C_MODE 0  /* C   code is generated */
#define CV_MODE 1 /* C[] code is generated */

#define SKIP 2 /* Lenght of the structure listing skip */

/*#include <assert.h>
#define PointerControl(pointer) assert(pointer != NoTree)
#define GenControl(pointer) assert(pointer != NoGen)
#define TypeControl(pointer) assert(pointer != NoType)
#define IdentControl(ident) assert(ident != NoIdent)*/

#define PointerControl(pointer) \
  ((void) ((pointer != NoTree) ? 0 : \
   print_and_abort(pointer, __FILE__, __LINE__)))
#define GenControl(pointer) \
  ((void) ((pointer != NoGen) ? 0 : \
   print_and_abort(pointer, __FILE__, __LINE__)))
#define TypeControl(pointer) \
  ((void) ((pointer != NoType) ? 0 : \
   print_and_abort(pointer, __FILE__, __LINE__)))
#define IdentControl(pointer) \
  ((void) ((pointer != NoIdent) ? 0 : \
   print_and_abort(pointer, __FILE__, __LINE__)))

#define print_and_abort(expression, file, lineno)  \
  (printf ("%s:%u: failed assertion\n", file, lineno),	\
   internal_error (), 0)

#define c_blank blank(cur_blank)
#define file dummy_file()?dummy:not_dummy
#define b_end cur_blank-=SKIP; c_blank; fputs("}\n",file)
/*#define file not_dummy  */

/* topology function code */
#define NOT_TOPO_FUN -1
#define NODE 0
#define LINK 1
#define MAIN 2
#define POWER 3
#define COORD 4
#define NUMBER 5
#define MAPPING 6

#define TOPO_FUN_NUM 7

/* predefined names */
/*#define HOST_NAME "MPC_host"
#define ALL_NAME "MPC_All"*/
#define VOTE_COUNT "MPC_number_of_nets_free"
#define VOTE_NUMBER "MPC_num"
#define NET_POWER "MPC_Power"
#define MEMBER "MPC_Is_member"
#define PARENT "MPC_Is_parent"
#define MEMBER_NOT_PARENT "MPC_Is_member_not_parent"
#define UNVOTED_NET "MPC_NULL_WEB"
#define IS_UNVOTED "!MPC_Is_created"
#define TYPE_TREE_TYPE "tMPC_Type"
/*#define NULL_DATATYPE "MPC_DATATYPE_NULL"*/
#define NULL_DATATYPE "MPC_DTN"
#define NETS_VOTED "MPC_nets"
#define NETS_NAMES "MPC_names"
#define NET_MEMBERS "MPC_members"
#define NODE_COORD "MPC_coord"
/*#define DATATYPE "MPC_Datatype"*/
#define DATATYPE "MPC_Dt"
#define WAITING_POINT "MPC_waiting_point"
#define RECONFIG_POINT "MPC_reconfig_point"
#define RETURN_POINT "MPC_return_point"
#define NET_POINTER_TYPE "MPC_Net*"
#define NET_PARAMETER "MPC_Net_arg"
#define MEMBER_NAME "MPC_Member"
#define SCREEN_NAME "MPC_screen_"
#define ESTIMATION "MPC_estimation"
#define ALLOC_FLAG "MPC_alloc_flag_"
#define AUX_POINTER "MPC_aux_pointer"
#define SHIFT_SIZE_POSTFIX "_ss"
#define REDUCED_SIZE_POSTFIX "_rs"
#define VECTOR_POSTFIX "_v"
#define TMP_SLOT_PREFIX "MPC_ts"
#define INDEX_BOUND_PREFIX "MPC_index_bound"
#define REG_PREFIX "MPC_reg"
/* kind of the creation section and statement from this view */
#define KNOWN 1
#define UNKNOWN 0
#define EXTERNAL_NUM 0
#define PREDEFINE_NUM -1
#define CREATED_NUMBER 1
#define FREE_NUMBER 2
#define CREATION 3
#define NOT_DYNAMIC_TYPE 0
#define DYNAMIC_VECTOR 1
#define DYNAMIC_ARRAY 2
#define DYNAMIC_POINTER 3
#define DYNAMIC_STEP 1
#define STATIC_STEP 0
#define DYNAMIC_SIZE 1
#define STATIC_SIZE 0
#define PRTT_1PASS 30
#define PRTT_2PASS 31
#define STRICKTLY_DIFFERENT 1
#define POSSIBLY_DIFFERENT 2
#define ABSOLUTELY_EQUAL 3

#define IS_DYN_ARRAY_OR_VECTOR(t) ((is_dynamic_type(t)==DYNAMIC_ARRAY)||(is_dynamic_type(t)==DYNAMIC_VECTOR))
#define NUMBER_OF_COMPONENTS(t) (t->MPC_DerivedType.NumberOfComponents)
#define DYN_SIZE(t) ((t->Kind==kMPC_ArrayType)?t->MPC_ArrayType.ArraySize:t->MPC_VectorType.VectorSize)
#define STEP(t) ((t->Kind==kMPC_ArrayType)?t->MPC_ArrayType.Step:t->MPC_PointerType.Step)
#define DYN_STEP(t) ((t->Kind==kMPC_ArrayType)?t->MPC_ArrayType.DynStep:t->MPC_PointerType.DynStep)
#define IS_LINEAR_OPER(op) (((op)>=LIN_MULT)&&((op)<=LIN_LOG_OR))
#define IS_ARITHMETIC_OPER(op) ((op==POST_INC      )||\
                                (op==POST_DEC      )||\
                                (op==PRE_INC       )||\
                                (op==PRE_DEC       )||\
                                (op==NEG           )||\
                                (op==NOT           )||\
                                (op==LOG_NOT       )||\
                                (op==MULT          )||\
                                (op==DIV           )||\
                                (op==PLUS          )||\
                                (op==MINUS         )||\
                                (op==LEFT_SHIFT    )||\
                                (op==RIGHT_SHIFT   )||\
                                (op==LESS_THEN     )||\
                                (op==GREAT_THEN    )||\
                                (op==LESS_OR_EQ    )||\
                                (op==GREAT_OR_EQ   )||\
                                (op==EQUAL         )||\
                                (op==NOT_EQUAL     )||\
                                (op==AND           )||\
                                (op==EXCL_OR       )||\
                                (op==INCL_OR       )||\
                                (op==LOG_AND       )||\
                                (op==LOG_OR        )||\
                                (op==ASSIGN        )||\
                                (op==MULT_ASSIGN   )||\
                                (op==DIV_ASSIGN    )||\
                                (op==MOD_ASSIGN    )||\
                                (op==PLUS_ASSIGN   )||\
                                (op==MINUS_ASSIGN  )||\
                                (op==LSHIFT_ASSIGN )||\
                                (op==RSHIFT_ASSIGN )||\
                                (op==AND_ASSIGN    )||\
                                (op==EXCL_OR_ASSIGN)||\
                                (op==INCL_OR_ASSIGN))


/* external function */               
void internal_error();
void be_error(char* );

char* befilename();
int dummy_file();

void File_print(tTree );
void Decls_print(tTree );
void Decls_alloc(tTree );
void Decls_free(tTree );
void Break_free(tTree );
void Return_free(tTree );
void Goto_free(tTree);
void Label_alloc(tTree);
void RTS_init_print(tTree);
void Stats_print(tTree );
void print_RTSNodeDeclare(tTree);
void print_RTSNodeInit(tTree );

void print_TypeFlag(tTree , int );
void print_VarStorageClass(tDeclFlags );
void print_Decls(tTree );
void print_VarDecl(tTree );
void print_Type(tTree );
void print_BasicTypeName(tTree );
void print_Var(tTree );
void print_SourceType(tTree );
void print_LeftType(tTree ,tTree );
void print_RightType(tTree ,tTree );
void print_Expr(tTree );
void print_Expr_without_net_check(tTree);
void print_Function(tTree );    
/*void print_Initializer(tTree );*/
void print_NetType(tTree ); 
void print_NetDecl(tTree );
void print_SubnetDecl(tTree );
void pred_print_Expr(tTree ,int );
int pred_print_Expr_begin(tTree );
void pred_print_Expr_end(tTree );
void print_NetCreate(tTree );
void print_NetOrSubnet(tTree );
void print_VoteSection(tTree );
void print_VoteExit(void );
int print_MemberAndPredicate(tTree );
int print_MemberNotPredicate(tTree );
void print_Assign(tTree );
void print_PredAssign(tTree );
void print_Assign_OneToOne(tTree );
void print_Assign_ManyToOne(tTree );
void print_Assign_OneToMany(tTree );
int print_Assign_ManyToMany(tTree );
void  print_Alloc_Flags(tTree);
void print_CoordArray(tTree ,tTree ,tDeclFlags );
void print_Address(tTree ,int );
tTree next_type(tTree );
int is_basic_function_call(tTree );
int is_dynamic_type(tTree);
int is_dynamic_step(tTree);
int is_dynamic_size(tTree);
int is_pointer_on_dynamic(tTree);
int is_dynamic_pointer(tTree);
int is_not_c_pointer(tTree );
char* step_macro(tTree);
int same_type(tTree,tTree);
int is_optimizable_assign(tTree);
void print_PredAssignOptimized(tTree);
void print_AssignOptimized(tTree);





/*void print_NodeCoord(tTree ,tTree );*/ 

tTree element_type(tTree pType);
int index_level(tTree pType);
void set_index_boundary(tTree pType);
char* index_name(int index);
void print_index(tTree , int , int );

void open_c_file(char* , FILE** );
void blank(int );

char* VarName(tTree );
char* AuxPointerName(tTree ,tTree);
char* TypeName(tTree );
char* TopoFunName(tTree , int );
char* DataVarName(tTree );
char* VarNameInTopoFun(tTree , char* );
      
int pred_gen_is_necessary(tTree );
void print_NetRelease();
int param_number(tTree );
int coord_number(tTree );
/*int search_net_in_file();*/
void FileDecls_traverse(void (* )(tTree));
void StateDecls_traverse(tTree ,void (* )(tTree));
void Net_traverse(tTree ,void (* )(tTree));
void Decls_traverse(tTree ,void (* )(tTree ));
void Stat_traverse(tTree ,void (* )(tTree ));
void Expr_traverse(tTree ,void (* )(tTree ));
void ExprPiece_traverse(tTree ,tTree, void (* )(tTree,tTree ));
void PredExpr_traverse(tTree ,void (* )(tTree ));
void ArrayType_traverse(tTree , void (* ) (tTree));
void TypeTree_traverse(tType ,void (* )(tType ),int );
void AllTypeTree_traverse(tType,void (* proc)(tType ));
 
void VarDecl_traverse(tTree , void (* ) (tTree));


void HitchToGenTree(tTree);
void fill_gen_tree(tTree );
void print_gen_tree(tGen ,int );
void traverse_gen_tree(tGen ,void (* )(tGen));
void net_create(tGen );
void set_predecessor(tGen );
void close_gen_block(void );
void print_topo_params(tTree );
tTree net_parent(tTree );
void fill_be_type_tree(tTree );
int is_first_parent_of_second(tTree , tTree );
int is_subnet(tTree , tTree );
int is_parent(tTree , tTree );
int is_Assign_asynch(tTree );
int is_NetCast_asynch(tTree );
int IsSingleRegion(tTree );
tTree SingleRegion(tTree );
int IsInList(tTree , tTree );
int SameList(tTree ,tTree );
int SubList(tTree ,tTree );
int SubListOrParent(tTree ,tTree );
int print_Members(tTree );
void fill_ActualEvalNet(tTree );
int check_enclosed_net(tTree , tTree );
void PrintNetList(tTree , int , char* );
void PrintNet(tTree , char* );
int set_cur_act_net(tTree );
void create_MyList(tTree );
void set_defer_atribute(tTree );
int parent_is_good_assign(tTree );
int variable_len_array(tTree );
int ordinar_var(tTree );
void print_ParamNumber(tTree , int );
void print_CopyParams(tTree , tTree , tTree );
void add_host_to_NetList(tTree );
void print_rts_type(tTree ,int );
tTree tmp_var_type(tTree );
int end_is_needed(tTree );
int all_known_len(tTree );
void print_Type_in_sizeof(tTree );
tTree buffer_type(tTree );
void void_fun(tTree );
int is_built_in_fun(tTree );
tTree Decl_of_NetOrSubnet(tTree );
tTree real_net_type_param(tTree );
int StoreEqEval(tTree );
int NetEqList(tTree , tTree );
tTree ExprEvalNet(tTree );
int print_Predicate(tTree , int );
int print_PredicateAndChangeNet(tTree , tTree );
int is_auto_parent(tTree );
tTree first_not_flexible(tTree );
int equal_type(tTree ,tTree );
char* CtrlName(tTree );
tTree get_parent_stat(tTree );
void print_rts_type_tree(tType );
void print_rts_type_tree_2(tType );
void set_parent_used(tType );
void print_prop_to_created(tTree ,tTree );
void set_params(tTree );
void print_EmptyOffer();
void print_host_out();
void delete_c_file();
tTree Strip_Typedef(tTree);
int expr_depth(tTree);
void set_tmp_slots(tTree, tTree);
void declare_tmp_slots(tTree, tTree);
void calc_tmp_slots(tTree ,tTree );
void clear_generated(tTree ,tTree );
int is_trivial_expr(tTree );
tTree get_TerminalType(tTree );
tTree get_type_pattern(tTree ,int );
void declare_slot(tTree , int);
char*  BasicType_4_Num(int type_num);
void declareNewVectorTypes( tTree );
void initNewVectorTypes(tTree );


/* Addition to Cocktaile function */
tString make_string(char* ); 
tString empty_string(); 
tString make_pow_var_name(tTree ); 
tString make_int_name(int );
tPosition RealPosition	ARGS((tPosition VirtPos));
tString SourceFile	ARGS((tPosition VirtPos));

/* look for kind of the assign */
#define WRONG      -1
#define ASYNCH      0
#define ONE_ONE     1
#define ONE_MANY    2
#define MANY_ONE    3
#define MANY_MANY   4
#define GATHER      1
#define SCATTER     2
#define BCAST       3
int PredAssign_kind(tTree , tTree* , tTree* );
extern int one_to_one_kind;


char* cpyName(char* );
/*void test(tTree* );
void test_expr_my(tTree* );
void test_net_my(tTree* );*/

/* network stack */
#define NET_STACK_LEN 1
typedef struct {
  tTree Net;
  int braces;
} Net_rec;
typedef struct {
  Net_rec* base;
  int len;
  int head;
} Net_stack;
void Net_stack_Init(Net_stack* );
void Net_stack_Push(Net_stack* , Net_rec* );
Net_rec Net_stack_Pop(Net_stack* );
int Net_stack_Is_empty(Net_stack* );
void Net_stack_Free(Net_stack* );

/* statement stack */
#define STAT_STACK_LEN 1
typedef tTree  Stat_rec;
typedef struct {
  Stat_rec* base;
  int len;
  int head;
} Stat_stack;
void Stat_stack_Init();
void Stat_stack_Push(Stat_rec* );
void Stat_stack_Pop();
int Stat_stack_Is_empty();
void Stat_stack_Free();
int Stat_stack_Number();
Stat_rec Stat_stack_Element(int );
extern Stat_stack statement_stack;

/* blocks list */
typedef struct tBlock {
  tTree Block;
  struct tBlock* Next;
} Blocks;
extern Blocks* block_list;
#define NoBlock NULL
#define BlockControl(pointer) assert(pointer != NoBlock)

/* built-in function definitions */
#define BUILT_IN_FUN_NUM 5
extern char* built_in_source[BUILT_IN_FUN_NUM];
extern char* built_in_dest[BUILT_IN_FUN_NUM];
extern int source_pos[BUILT_IN_FUN_NUM];
extern int dest_pos[BUILT_IN_FUN_NUM];
extern int with_type[BUILT_IN_FUN_NUM];

/* code of the expressions */
#define OP_CODE_LEN 54
extern char* op_represent[];

/* extrnal variables */
extern char* output;  /* name of the output file */
extern int eargc;     
extern char** eargv;
extern int gen_topo_fun;
extern int not_host;
extern int null_init;
extern int prt;
extern int macro;

extern int cur_blank; 
extern int cur_pos;
extern FILE* not_dummy;
extern FILE* dummy;
extern int gen_mode; /* target language */
extern int char_kind; /* kind of the char: 1 - signed; 0 - unsigned */
extern char* IdentBuf;
extern char* NameBuf;
extern char* TypeBuf;
extern int print_base_type;
extern int is_not_parameter;
extern int topo_fun_code;
extern int is_topo_fun;
extern tTree cur_net_type;
extern int in_function;
extern int cur_net_param_num;
extern tTree pRoot;
extern tTree cur_FileDecls;
extern tTree pHost;
extern tTree pAll;
extern tGen int_gen_tree;
extern tGen ext_gen_tree;
extern tTree cur_block;
extern tTree creation_section_begin;
extern tTree creation_section_end;
extern int creation_section_kind;
extern int state_kind;
extern tGen cur_nets;
extern tTree cur_Decl;
extern int blank_is_necessary;
extern int is_main_function;
extern tTree cur_act_net;
extern tTree enclosed_net;
extern int end_statement_is_needed;
extern char* BasicDTName[];
extern int tmp_num;
extern tTree parent_expr;
extern int in_condition;
extern struct INDEX_BOUNDARY {int NumberOfComponents; tTree Type;}  *index_boundary;
extern int* steps;
extern int boundary_num;
extern int asynchr_mode;
extern int point_num;
extern tTree pCurDeclSpec;
extern int function_kind;
extern int not_created_num;
extern tTree tmp_var_expr;
extern tTree tmp_var_expr_left;
extern tTree general_type;
extern int loop_was_generated;
extern int root_index;
extern int expr_index; 
extern int is_argument;
extern int expr_level;
extern int not_pecul;
extern int post_gen;
extern int basic_fun_call;
extern int host_function;
extern int index_depth;
extern int not_index;
extern int not_change_net;
extern int ListNum;
extern int not_members;
extern int in_type;
extern int in_var_decl;
extern int not_check;
extern tTree fun_distr;
extern tTree tmp_coord_expr;
extern tTree tmp_coord_expr_left;
extern int source_only;
extern tPosition Position;
extern tTree var_param_net;
extern tTree var_fun_net;
extern tTree var_fun_net_type;
extern tTree var_fun_net_paramlist;
extern tTree var_fun_net_paramtype;
extern int pass_number;
extern int first_waiting_point_in_function;
extern int host_stat;
extern int host_expr;
extern int built_in_fun;
extern tTree pCurParamList;
extern tTree pCurExprs;
extern int real_param;
extern int return_free;
extern char* source_file;
extern tTree net_to_change;
extern int net_count_kind;
extern int stat_num;
extern tTree cur_stat;
extern int not_the_last_array;
extern char *file_names[2];
extern int in_assign;
extern int the_last_is_return;
extern tTree var_fun_net_type;
extern tTree var_fun_net_paramlist;
extern int is_break;
extern int is_return;
extern int closing_needed;
extern int in_return;
extern int in_net_param_list;
extern int in_sizeof;
extern int carefull_compare;
extern int in_post_gen;
extern int current_slot_number;
extern int global_index_level;
extern int use_slots;
extern int in_linear;
extern int global_shift;
extern int clear_level;
extern int set_gen;
extern int set_gen_2;
extern int in_sideeff;
extern int in_mapping;
extern int not_const;
extern int in_par;
