/*
 * $Id: VarName.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* Creation of the name to the auxiliary variables and etc */
/* Coded by A.Kalinov 10.95 - 11.95*/


#include "be_print.h"

void reduce_MPC_name(tIdent Ident) {
  IdentControl(Ident);
  GetString(Ident,IdentBuf);
  if(strncmp(IdentBuf,"MPC_",4)) 
    strcat(NameBuf,IdentBuf);
  else 
    strcat(NameBuf,IdentBuf+4);
}

char* VarName(tTree yyt) {
  tIdent Ident;
  PointerControl(yyt);
  /*if (prt) {
    printf("VarName yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind);
    fflush(stdout);
  }*/
  if(Tree_IsType(yyt,kMPC_NetTypeDecl)) {
    tTree pNetType;
    pNetType=(yyt->Kind == kMPC_NetTypeSpecifier) ?
      yyt->MPC_NetTypeSpecifier.NetType : yyt;
    PointerControl(pNetType);
    strcpy(NameBuf,"MPC_NetType_");
    Ident=pNetType->MPC_NetTypeDecl.Ident;
    IdentControl(Ident);
    GetString(Ident,NameBuf+strlen(NameBuf));
  }
  else if(Tree_IsType(yyt,kMPC_NetOrSubnet)) {
    if(yyt->Kind == kMPC_Subnet && yyt->MPC_Subnet.Flexible == 1) {
      strcpy(NameBuf,"flexible_subnet");
    }
    else {
      strcpy(NameBuf,"MPC_Net_");
      Ident=yyt->MPC_NetOrSubnet.Ident;
      reduce_MPC_name(Ident);
      if(yyt->MPC_NetOrSubnet.WithNumber) {
        sprintf(NameBuf+strlen(NameBuf),"_%d",
                yyt->MPC_NetOrSubnet.UniqueNumber);
      }
    }
  }
  else if(yyt->Kind == kMPC_Var) {
    Ident=yyt->MPC_Var.Ident;
    IdentControl(Ident);
    GetString(Ident,NameBuf);
    if(is_topo_fun) {
      return VarNameInTopoFun(cur_net_type,NameBuf);
    }
  }
  else {
    strcpy(NameBuf,"___");
  }
  return NameBuf;
}

char* TypeName(tTree yyt) {
  PointerControl(yyt);
  if(yyt->Kind == kMPC_NetType) {
    strcpy(TypeBuf,"MPC_NetType");
  }
  else if(Tree_IsType(yyt,kMPC_NetOrSubnet)) {
    strcpy(TypeBuf,"MPC_Net");
  }
  else {
    strcpy(TypeBuf,"MPC___");
  }
  return TypeBuf;
}
  
static char* topo_fun_name[TOPO_FUN_NUM]={"node","link","parent",
                               "power","number2coord","coord2number","mapping"};

char* TopoFunName(tTree pNetType, int topo_fun_code) {
  PointerControl(pNetType);
  if(topo_fun_code <0 || topo_fun_code >=TOPO_FUN_NUM) {
    fprintf(stderr,"invalid topology function code = %d\n",
	    topo_fun_code);
    internal_error();
  }
  VarName(pNetType);
  strcat(NameBuf,"_");
  return strcat(NameBuf,topo_fun_name[topo_fun_code]);
}

char* VarNameInTopoFun(tTree cur_net_type, char* IdentBuf) {
  int i;
  PointerControl(cur_net_type);
  for(i=0; i<TOPO_FUN_NUM; i++) {
    if(strcmp(IdentBuf,topo_fun_name[i]) == 0) {
      return TopoFunName(cur_net_type,i);
    }
  }
  return IdentBuf;
}


static char* PointerDTName="MPC_POINTER";

char* print_BasicDatatypeName(tTree pType) {
  int type_constr;
  PointerControl(pType);
  print_TypeFlag(pType,1);
  type_constr=-pType->MPC_BasicType.TypeConstructor;
  if(type_constr == 2) {
    return char_kind ? BasicDTName[2] :
      BasicDTName[3];
  }
  return BasicDTName[type_constr-1];
}

char* DatatypeName(tTree pType) {
  if(pType == NoTree) {
    fprintf(stderr,"Type pointer is Null\n");
    internal_error();
  }
  switch(pType->Kind) {
  case kMPC_BasicType:
    return print_BasicDatatypeName(pType);
    break;
  case kMPC_PointerType:
    return PointerDTName;
    break;
/*  case kMPC_EnumType:
  case kMPC_Typedef:
  case kMPC_StructType:
  case kMPC_UnionType:
    break;*/
default:
    break;
  }
return "_______";
}

static char* TreeNodeName[9]= {
  "enum","typedef","derived",
  "array","vector","pointer",
  "struct","union","function"};
  
char* DataVarName(tTree pType) {
  if(pType == NoTree) {
    fprintf(stderr,"Type pointer is Null\n");
    internal_error();
  }
  if(pType->Kind == kMPC_Typedef) {
    pType=pType->MPC_Typedef.Type;
    PointerControl(pType);
  }
  if(Tree_IsType(pType,kMPC_Type)) {
    if(prt) printf("DataVarName Type->Kind=%d\n",pType->Kind);
    if(Tree_IsType(pType,kMPC_BasicType)) {
      sprintf(NameBuf,"MPC_%s",
              BasicDTName[-pType->MPC_BasicType.TypeConstructor-1]);
    }
    else if(pType->Kind == kMPC_UnionType ||
            pType->Kind == kMPC_StructType) {
      tIdent Ident;
      tTree pOrigin;
      tType p_type=pType->MPC_Type.pType;
      TypeControl(p_type);
      pOrigin=p_type->Type.Origin;
      PointerControl(pOrigin);
      strcpy(NameBuf,"MPC_");
      Ident=pOrigin->Kind == kMPC_UnionType ?
        pOrigin->MPC_UnionType.SU_Tag :
        pOrigin->MPC_StructType.SU_Tag;
      if(Ident != NoIdent) {
        GetString(Ident,NameBuf+strlen(NameBuf));
        sprintf(NameBuf+strlen(NameBuf),"_%d",p_type->Type.Number);
      }
      else {
        sprintf(NameBuf+strlen(NameBuf),"NoName_%d",p_type->Type.Number);
      }
    }
    else {
      tType p_type=pType->MPC_Type.pType;
      TypeControl(p_type);
      sprintf(NameBuf,"MPC_%s_%d",
              TreeNodeName[pType->Kind-kMPC_EnumType],
              p_type->Type.Number);
    }
    return NameBuf;
  }
  else if(pType->Kind == kMPC_SU_Member) {
    sprintf(NameBuf,"%s_%d",
            MEMBER_NAME,pType->MPC_SU_Member.UniqueNumber);
    return NameBuf;
  } 
  return "______";
}    

char* index_name(int index) {
  if(in_sideeff) 
    sprintf(NameBuf,"MPC_i%d",index);
  else
    sprintf(NameBuf,"0");
  return NameBuf;
}
 
char* CtrlName(tTree pStat) {
  PointerControl(pStat);
  if(Tree_IsType(pStat,kMPC_Stat)) {
    sprintf(NameBuf,"MPC_ctrl_%d",pStat->MPC_Stat.UniqueNumber);
    return NameBuf;
  } 
  return "______";
}    
  
