/*
 * $Id: Prop.c,v 3.2 1999/11/10 14:54:53 scheme Exp ka $
 */


/* auxiliary function for code generation for MPC_Stats */
/* Coded by A.Kalinov 1.96 -  */

#include "be_print.h"

void print_to_root(tTree , tTree );
void print_from_root(tTree );
tTree first_not_flexible(tTree );

static int is_net_decl;

int IsInList(tTree pRegion, tTree pList) {
  /*printf("  IsInList pRegion=%p pList=%p\n",pRegion,pList);*/
  PointerControl(pRegion);
  PointerControl(pList);
  if(pRegion == CONST_NET || pRegion == SINGLE_NODE) return 1;
  while(pList->Kind != kMPC_FreeNode) {
    tTree pNet; 
    pNet=pList->MPC_NetList.Net;
    PointerControl(pNet);
    /*printf("    IsInList pRegion=%p pNet=%p pList=%p\n",pRegion,pNet,pList);*/
    if(pNet == pRegion || pNet == COMPUTING_SPACE ||
       is_subnet(pRegion,pNet) ||
       (pNet->Kind == kMPC_Net && is_parent(pRegion,pNet))) return 1;
    pList=pList->MPC_NetList.Next;
    PointerControl(pList);
  }
  return 0;
}

int SubList(tTree pSubList,tTree pList) {
  int ret=0;
  if(prt) printf("SubList  pSubList=%p pList=%p ",pSubList,pList);
  PointerControl(pSubList);
  PointerControl(pList);
  if(pSubList == pList || NetEqList(COMPUTING_SPACE,pList)) {
    ret=1;
  }
  else {
    while(pSubList->Kind != kMPC_FreeNode) {
      tTree pNet;
      pNet=pSubList->MPC_NetList.Net;
      /*printf("  SubList  pSubList=%p pNet=%p\n",pSubList,pNet);*/
      PointerControl(pNet);
      if(!IsInList(pNet,pList)) {
        ret=0;
        break;
      }
      pSubList=pSubList->MPC_NetList.Next;
      PointerControl(pSubList);
    }
    if(pSubList->Kind == kMPC_FreeNode) ret=1;
  }
  if(prt) printf(" ret=%d\n",ret);
  return ret;
}

int SubListOrParent(tTree pSubList,tTree pList) {
  int ret;
  if(prt) printf("SubListOrParent  pSubList=%p pList=%p\n",pSubList,pList);
  PointerControl(pSubList);
  PointerControl(pList);
  ret=SubList(pSubList,pList);
  if(!ret) {
    if(pSubList->MPC_NetList.Next->Kind == kMPC_FreeNode &&
       pList->MPC_NetList.Next->Kind == kMPC_FreeNode) {
      tTree pParent=pSubList->MPC_NetList.Net;
      tTree pNet=pList->MPC_NetList.Net;
      PointerControl(pNet);
      PointerControl(pParent);
      ret=is_parent(pParent,pNet);
    }
  }
  if(prt) printf("SubListOrParent=%d\n",ret);
  return ret;
}

int SameList(tTree pList1,tTree pList2) {
  int i;
  if(function_kind == NODAL || not_check) return 1;
  if(prt) printf("SameList pList1=%p pList2=%p\n",pList1,pList2);
  PointerControl(pList1);
  PointerControl(pList2);
  PrintNetList(pList1,0,"List1");
  PrintNetList(pList2,0,"List2");
  if(pList1 == pList2 ||
     pList1 == CONST_NET_LIST ||
     pList2 == SINGLE_NODE_LIST ||
     pList1 == SINGLE_NODE_LIST /*||
     (pass_number > 1 && IsSingleRegion(pList1) &&
     pList1->MPC_NetList.Net == HOST)*/) {
    /*(IsInList(fun_distr,pList1) &&
      IsSingleRegion(pList1) &&
      SubListOrParent(pList2,pList1))) {*/
    i=1;
  }
  else {
    i=SubList(pList1,pList2) && SubList(pList2,pList1);
  }
  if(prt) printf("SameList i=%d\n",i);
  return i;
}

int IsSingleRegion(tTree pList) {
  tTree pNext;
  PointerControl(pList);
  /*printf("IsSingleRegion pList=%p Kind=%d Net=%p Next=%p",
         pList,pList->Kind,
         pList->MPC_NetList.Net,pList->MPC_NetList.Next);*/ 
  pNext=pList->MPC_NetList.Next;
  PointerControl(pNext);
  /*printf(" Next->Kind=%d\n",pNext->Kind);*/
  return pNext->Kind == kMPC_FreeNode;
}
  
tTree SingleRegion(tTree pList) {
  tTree pNet;
  PointerControl(pList);
  if(!IsSingleRegion(pList)) {
    fprintf(stderr,"Not single region NetList\n");
    internal_error();
  }
  pNet=pList->MPC_NetList.Net;
  PointerControl(pNet);
  return pNet;
}
  
int NotFlexibleAndNumber(tTree pNetList) {
  tTree pNet;
  int num=0;
  if(prt) printf("NotFlexibleAndNumber pNetList=%p\n",pNetList);
  PointerControl(pNetList);
  while(pNetList->Kind != kMPC_FreeNode) {
    pNet=pNetList->MPC_NetList.Net;
    PointerControl(pNet);
    num++;
    if(prt) printf("  NotFlexibleAndNumber pNetList=%p pNetList->Kind=%d pNet=%p num=%d\n",pNetList,pNetList->Kind,pNet,num);
    if(pNet->Kind == kMPC_Subnet && pNet->MPC_Subnet.Flexible) break;
    pNetList=pNetList->MPC_NetList.Next;
    PointerControl(pNetList);
  }
  return pNetList->Kind == kMPC_FreeNode ? num : 0;
}

int CountsNetInNetList(tTree pNetList) {
  tTree pNet;
  int num=0;
  if(prt) printf("CountsNetInNetList pNetList=%p\n",pNetList);
  PointerControl(pNetList);
  while(pNetList->Kind != kMPC_FreeNode) {
    pNet=pNetList->MPC_NetList.Net;
    PointerControl(pNet);
    num++;
    if(prt) printf("  CountsNetInNetList pNetList=%p pNetList->Kind=%d pNet=%p num=%d\n",pNetList,pNetList->Kind,pNet,num);
    pNetList=pNetList->MPC_NetList.Next;
    PointerControl(pNetList);
  }
  return num;
}

int print_MembersList(tTree pNetList, int num) {
  tTree pNet;
  int i=0;
  if(prt) printf("print_MembersList pNetList=%p num=%d\n",pNetList,num);
  PointerControl(pNetList);
  c_blank;
  fprintf(file,"{\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"%s %s[%d];\n",NET_POINTER_TYPE,NET_MEMBERS,num);
  while(pNetList->Kind != kMPC_FreeNode) {
    pNet=pNetList->MPC_NetList.Net;
    PointerControl(pNet);
    pNet=first_not_flexible(pNet);
    c_blank;
    fprintf(file,"%s[%d]=&%s;\n",NET_MEMBERS,i++,VarName(pNet));
    pNetList=pNetList->MPC_NetList.Next;
    PointerControl(pNetList);
  }
  return 1;
}
  
void print_propagation(tTree pStat, tTree pExpr) {
  /*c_blank;
  fprintf(file,"/? propagation of the MPC_ctrl ?/\n");*/
  print_to_root(pStat,pExpr);
  print_from_root(pStat);
}

static void print_predicate_exprs(tTree pPredicate) {
  PointerControl(pPredicate);
  if(pPredicate->Kind == kMPC_BinaryExpr) {
    tTree pLop=pPredicate->MPC_BinaryExpr.Loperand;
    tTree pRop=pPredicate->MPC_BinaryExpr.Roperand;
    tTree pExpr;
    PointerControl(pLop);
    PointerControl(pRop);
    if(pPredicate->MPC_BinaryExpr.OpCode == LOG_AND) {
      print_predicate_exprs(pLop);
      print_predicate_exprs(pRop);
    }
    else if(pPredicate->MPC_BinaryExpr.OpCode == EQUAL) {
      int coord_num=-1;
      if(pLop->Kind == kMPC_CoordExpr) { 
        coord_num=pLop->MPC_CoordExpr.CoordNumber;
        pExpr=pRop;
      }
      else if(pRop->Kind == kMPC_CoordExpr) {
        coord_num=pRop->MPC_CoordExpr.CoordNumber;
        pExpr=pLop;
      }
      else {
        pExpr=NoTree;
      }
      if(pExpr != NoTree) {
        int braces,i;
        braces=pred_print_Expr_begin(pExpr);
        c_blank;
        fprintf(file,"MPC_co[%d]=",coord_num);
        print_Expr(pExpr);
        fprintf(file,";\n");
        pred_print_Expr_end(pExpr);
        for(i=0; i<braces; i++) {
          b_end;
        }
      }
    }
  }
}

void print_known_to_root(tTree pNet) {
  tTree pNetType,pParent,pCurNet;
  tTree old_act_net=cur_act_net;
  int coord_num,i;
  int braces;
  PointerControl(pNet);
  pParent=pNet->Kind == kMPC_Subnet ? net_parent(pNet) : pNet;
  pNetType=pParent->MPC_Net.NetType;
  PointerControl(pNetType);
  coord_num=coord_number(pNetType);
  c_blank;
  braces=1+print_MemberAndPredicate(pParent);
  cur_act_net=pParent->MPC_NetOrSubnet.MyList;
  PointerControl(cur_act_net);
  if(braces == 1 && pParent == fun_distr) {
    fputs("{\n",file);
    cur_blank+=SKIP;
  }
  c_blank;
  fprintf(file,"int MPC_co[%d];\n",coord_num);
  {
    pCurNet=pNet;
    while(pCurNet->Kind == kMPC_Subnet) {
      tTree pPredicate;
      pPredicate=pCurNet->MPC_Subnet.Predicate;
      PointerControl(pPredicate);
      print_predicate_exprs(pPredicate);
      pCurNet=pCurNet->MPC_Subnet.Distribution;
      PointerControl(pCurNet);
    }
  }
  {
    int pos;
    c_blank;
    pos=cur_blank+fprintf(file,"MPC_Ctrl_known(");
    fprintf(file,"&%s,",VarName(pParent));
    fprintf(file,"&%s,\n",CtrlName(cur_stat));
    blank(pos);
    fprintf(file,"MPC_Number(&%s,MPC_co));\n",VarName(pParent));
  }
    for(i=0; i<braces; i++) {
      b_end;
    }
  cur_act_net=old_act_net;
}
        

void print_unknown_to_root(tTree pNet) {
  tTree pParent;
  tTree old_act_net=cur_act_net;
  int braces,pos,i;
  PointerControl(pNet);
  pParent=pNet->Kind == kMPC_Subnet ? net_parent(pNet) : pNet;
  c_blank;
  braces=1+print_MemberAndPredicate(pParent);
  cur_act_net=pParent;
  c_blank;
  fprintf(file,"int MPC_is_sender=0;\n");
  {
    int braces;
    braces=1+print_MemberAndPredicate(pNet);
    c_blank;
    fprintf(file,"MPC_is_sender=1;\n");
    for(i=0; i<braces; i++) {
      b_end;
    }
  }
  c_blank;
  pos=cur_blank+fprintf(file,"MPC_Ctrl_any(&%s,\n",
          VarName(pParent));
  blank(pos);
  fprintf(file,"&%s,MPC_is_sender);\n",CtrlName(cur_stat));
  for(i=0; i<braces; i++) {
    b_end;
  }
  cur_act_net=old_act_net;
}


void print_to_root(tTree pStat, tTree pExpr) {
  tTree pRootNet;
  PointerControl(pStat);
  PointerControl(pExpr);
  pRootNet=pStat->MPC_Stat.RootNet;
  if(pRootNet != NoTree) {
    tTree pStoreNet=pExpr->MPC_Expr.StoreNet;
    PointerControl(pStoreNet);
    if(pStoreNet != pRootNet) {
      tTree pPredicate;
      tTree pParentNet,pPredNet;
      int known;
      /*c_blank;
      fprintf(file,"/? sending MPC_ctrl to root ?/\n");*/
      while(1) {
        pPredNet=pStoreNet;
        if(pStoreNet->Kind == kMPC_Net &&
           !pStoreNet->MPC_NetOrSubnet.SingleNode) {
          fprintf(stderr,"Distributed parent of undistributed subnet\n");
          internal_error();
        }
        pParentNet=pStoreNet->Kind == kMPC_Subnet ?
          net_parent(pStoreNet) : pStoreNet;
        known=1;
        while(pStoreNet->Kind == kMPC_Subnet) {
          pPredicate=pStoreNet->MPC_Subnet.Predicate;
          PointerControl(pPredicate);
          if(pPredicate->MPC_Expr.StoreNet != pParentNet) known=0;
          pStoreNet=pStoreNet->MPC_Subnet.Distribution;
          PointerControl(pStoreNet);
        }
        PrintNet(pPredNet,"PredNet");
        if(known) {
          print_known_to_root(pPredNet);
        }
        else {
          print_unknown_to_root(pPredNet);
        }
        if(pRootNet == pStoreNet){
          break;
        }
        else {
          pStoreNet=pStoreNet->MPC_Subnet.Distribution;
          PointerControl(pStoreNet);
          if(pStoreNet == HOST) break;
        }
      }
    }
  }
  else {
    fprintf(stderr,"RootNet is equal to NoTree\n");
    internal_error();
  }
}

tTree pPropNetList;
tTree pExtRootNet;

int internal_one_propagation(tTree pNet) {
  int i,braces=0,ret=0;
  PointerControl(pNet);
  if((pNet == fun_distr && function_kind != BASIC) ||
     (pNet != pExtRootNet && pNet->Kind == kMPC_Net &&
     pNet != SINGLE_NODE &&
     IsInList(pNet,pPropNetList))) {
    if(pNet != fun_distr) {
      c_blank;
      braces=1+print_MemberAndPredicate(pNet);
    }
    c_blank;
    fprintf(file,"MPC_Ctrl_prop(&%s,",VarName(pNet));
    fprintf(file,"&%s);\n",CtrlName(cur_stat));
    ret=1;
    for(i=0; i<braces; i++) {
      b_end;
    }
  }
  return ret;
}

void one_propagation(tGen yyt) {
  if(yyt != NoGen && yyt->Kind == kNet) {
    int call;
    tTree pNet=yyt->Net.pNet;
    PointerControl(pNet);
    call=internal_one_propagation(pNet);
    if(prt) printf("one_propagation Net=%s Created=%d Ctrl=%p cur_stat=%p\n",
                    VarName(pNet),yyt->Net.Created,yyt->Net.Ctrl,cur_stat);
    if(call && yyt->Net.Created == 0 && yyt->Net.Ctrl == NoTree)
      yyt->Net.Ctrl=cur_stat; 
    if(prt) printf("one_propagation after Net=%s Ctrl=%p \n",
                    VarName(pNet),yyt->Net.Ctrl);
  }
}

/*void set_ctrl_to_0(tGen yyt) {
  if(yyt != NoGen && yyt->Kind == kNet) {
    yyt->Net.Ctrl=NoTree; 
  }
}*/

void print_prop_to_created(tTree pNet,tTree pStat) {
  Blocks* pList=NoBlock;
  Blocks* pChain;
  tTree pFirstStat;
  tGen p_net;
  if(prt) printf("print_prop_to_created Net=%s Stat=%d\n",VarName(pNet),
                 pStat->MPC_Stat.UniqueNumber);
  PointerControl(pNet);
  PointerControl(pStat);
  p_net=pNet->MPC_Net.pGen;
  GenControl(p_net);
  pFirstStat=p_net->Net.Ctrl;
  if(prt) printf("print_prop_to_created FirstStat=%d Kind=%d\n",
                     pFirstStat != NoTree ?
                     pFirstStat->MPC_Stat.UniqueNumber : 0,
                     pFirstStat != NoTree ?
                     pFirstStat->Kind : 0);
  if(pFirstStat != NoTree) {
    while(pStat != pFirstStat) {
      pStat=get_parent_stat(pStat);
      PointerControl(pStat);
      if(prt) printf("print_prop_to_created ParentStat=%d CtrlSend=%d\n",
                 pStat->MPC_Stat.UniqueNumber,pStat->MPC_Stat.Flag.CtrlSend);
      if(pStat->MPC_Stat.Flag.CtrlSend) {
        pChain=malloc(sizeof(Blocks));
        pChain->Next=pList;
        pChain->Block=pStat;
        pList=pChain;
      }
    }
    while(pList != NoBlock) {
      pChain=pList->Next;
      c_blank;
      fprintf(file,"MPC_Ctrl_prop(&%s,",VarName(pNet));
      fprintf(file,"&%s);\n",CtrlName(pList->Block));
      free(pList);
      pList=pChain;
    }
  }
}

void print_from_root(tTree pStat) {
  tTree pRootNet;
  PointerControl(pStat);
  pRootNet=pStat->MPC_Stat.RootNet;
  PointerControl(pRootNet);
  pExtRootNet=pRootNet/* == fun_distr ? NoTree : pRootNet*/;
  pPropNetList=pStat->MPC_Stat.PropNet;
  if(pRootNet != NoTree && pRootNet != SINGLE_NODE &&
     pPropNetList != NoTree) {
    tGen pGenRoot=pRootNet->MPC_NetOrSubnet.pGen;
    /*c_blank;
    fprintf(file,"/? sending MPC_ctrl from root ?/\n");*/
    /*printf("pGenRoot=%p NpGen=%p pRootNet=%p fun_distr=%p\n",
           pGenRoot,NoGen,pRootNet,fun_distr);*/
    if(pGenRoot == NoGen && pRootNet == fun_distr) {
      internal_one_propagation(fun_distr);
    }
    else if(pRootNet == HOST && NetEqList(COMPUTING_SPACE,pPropNetList)) {
      tGen pGen=COMPUTING_SPACE->MPC_NetOrSubnet.pGen;
      GenControl(pGen);
      one_propagation(pGen);
    }
    else {
      traverse_gen_tree(pGenRoot,one_propagation);
    }
  }
}

void PrintNet(tTree pNet, char* name) {
  if(prt) printf("  region %s %p",name,pNet);
  if(pNet != NoTree) {
    if(prt) printf(" %s",pNet->Kind == kMPC_Net ? "net" : "subnet");
    if(prt) printf(" %s",VarName(pNet));
    if(prt) printf(" num=%d",pNet->MPC_NetOrSubnet.UniqueNumber);
    if(prt) printf(" %s",pNet->MPC_NetOrSubnet.SingleNode ? "single node" : "");
    if(pNet->Kind == kMPC_Subnet) {
      if(prt) printf(" %s",pNet->MPC_Subnet.Flexible ? "flexible" : "");
    }
  }
  if(prt) printf("\n");
}

void PrintNetList(tTree pNetList, int num, char* name) {
  int i;
  if(num == 0) {
    if(prt) printf("NetList %s %p\n",name,pNetList);
  }
  if(pNetList != NoTree) {
    if(pNetList->Kind != kMPC_FreeNode) {
      for(i=0; i<num; i++) {
        if(prt) printf(" ");
      }
      PrintNet(pNetList->MPC_NetList.Net,"");
      PrintNetList(pNetList->MPC_NetList.Next,++num,"");
    }
  }
}


tTree next_stat() {
  tTree pNext=NoTree;
  int num;
  int i;
  num=Stat_stack_Number();
  for(i=num; i>=0; i--) {
    pNext=Stat_stack_Element(i);
    PointerControl(pNext);
    if(pNext->Kind != kMPC_FreeNode) break;
  }
  if(prt) printf("next_state pNext=%p num=%d i=%d\n",pNext,num,i);
  return pNext;
}

void find_net_decl(tTree yyt) {
  if(yyt != NoTree && yyt->Kind == kMPC_NetDecl) is_net_decl=1;
}


void add_net_to_NetList(tTree pNet, tTree* ppNetList) {
  if(prt) printf("    add_net_to_NetList pNet=%p *ppNetList=%p\n",pNet,*ppNetList);
  PointerControl(pNet);
  if(pNet == CONST_NET) return;
  if(*ppNetList == NoTree) {
    *ppNetList=nMPC_NetList();
    (*ppNetList)->MPC_NetList.Net=pNet;
    (*ppNetList)->MPC_NetList.Next=mMPC_FreeNode(*ppNetList);
  }
  else {
    tTree pNext;
    tTree pIntList=*ppNetList;
    while(1) {
      tTree pCurNet;
      pCurNet=pIntList->MPC_NetList.Net;
      PointerControl(pCurNet);
      if(prt) printf("    add_net_to_NetList pCurNet=%p pNet=%p  pIntList=%p \n",
             pCurNet,pNet,pIntList);
      if(pNet == pCurNet ||
         (pNet->Kind == kMPC_Subnet && is_subnet(pNet,pCurNet)) ||
         is_parent(pNet,pCurNet)) break;
      pNext=pIntList->MPC_NetList.Next;
      PointerControl(pNext);
      if(pNext->Kind == kMPC_FreeNode) {
        tTree pNew;
        pNew=mMPC_NetList(pNext,pIntList,pNet);
        pIntList->MPC_NetList.Next=pNew;
        /*        if(prt) printf(" pIntList=%p: Kind=%d Prev=%p Net=%p Next=%p\n",
               pIntList,pIntList->Kind,pIntList->MPC_NetList.Prev,
               pIntList->MPC_NetList.Net,pIntList->MPC_NetList.Next);
        if(prt) printf(" pNew=%p:     Kind=%d Prev=%p Net=%p Next=%p\n",
               pNew,pNew->Kind,pNew->MPC_NetList.Prev,
               pNew->MPC_NetList.Net,pNew->MPC_NetList.Next);
        if(prt) printf(" pNext=%p:     Kind=%d               Parent=%p\n",
               pNext,pNext->Kind,pNext->Kind == kMPC_FreeNode ?
               pNext->MPC_FreeNode.Parent : NoTree);*/
        if(prt) printf("    add_net_to_NetList *ppNetList=%p pIntList=%p \n",
               *ppNetList,pIntList);
        break;
      }
      pIntList=pNext;
    }
  }
}

void add_NetList_to_NetList(tTree pFrom, tTree* ppTo) {
  /*if(pFrom!= NoTree)*/ PointerControl(pFrom);
  {
    while(pFrom->Kind != kMPC_FreeNode) {
      tTree pNet;
      pNet=pFrom->MPC_NetList.Net;
      PointerControl(pNet);
      add_net_to_NetList(pNet,ppTo);
      pFrom=pFrom->MPC_NetList.Next;
      PointerControl(pFrom);
    }
  }
}

void set_PropNet(tTree pRootNet, tTree pExecNetList, tTree* ppNetList) {
  if(prt) printf("  set_PropNet pRootNet=%p  pExecNetList=%p *ppNetList=%p\n",
         pRootNet,pExecNetList,*ppNetList);
  PointerControl(pRootNet);
  PointerControl(pExecNetList);
  if(pRootNet == CONST_NET) {
    *ppNetList=CONST_NET_LIST;
    return;
  }
  PrintNet(pRootNet,"pRootNet in set_PropNet");
  while(pExecNetList->Kind != kMPC_FreeNode) {
    tTree pNet=pExecNetList->MPC_NetList.Net;
    PointerControl(pNet);
    if(pNet->Kind == kMPC_Subnet) {
      pNet=net_parent(pNet);
      PointerControl(pNet);
    }
    add_net_to_NetList(pNet,ppNetList);
    while(pNet != pRootNet) {
      PointerControl(pNet);
      PrintNet(pNet,"pNet in set_PropNet");
      if(pNet->Kind == kMPC_Net) add_net_to_NetList(pNet,ppNetList);
      pNet=pNet->MPC_NetOrSubnet.Distribution;
    }
    pExecNetList=pExecNetList->MPC_NetList.Next;
    PointerControl(pExecNetList);
  }
  if(prt) printf("  set_PropNet *ppNetList=%p\n",*ppNetList);
}
  
int is_root(tTree pRootNet, tTree pNet) {
  if(prt) printf("is_root pRootNet=%p pNet=%p\n",pRootNet,pNet);
  PointerControl(pRootNet);
  PointerControl(pNet);
  if(pRootNet == pNet) return 1;
  while(pNet != HOST) {
    pNet=pNet->MPC_NetOrSubnet.Distribution;
    PointerControl(pNet);
    if(pRootNet == pNet) return 1;
  }
  return 0;
}

tTree find_root_net(tTree pStoreNet,tTree pExecNetList) {
  tTree pRootNet;
  tTree pNet;
  tTree pExList;
  int is_not_root=1;
  PointerControl(pExecNetList);
  if(prt) printf("find_root_net pExecNetList=%p  pStoreNet=%p\n",
         pExecNetList,pStoreNet);
  PrintNetList(pExecNetList,0,"ExecNetList");
  PrintNet(pStoreNet,"StoreNet");
  pRootNet=pStoreNet;
  PointerControl(pRootNet);
  while(is_not_root) {
    is_not_root=0;
    while(pRootNet->Kind != kMPC_Net) {
      pRootNet=pRootNet->MPC_NetOrSubnet.Distribution;
      PointerControl(pRootNet);
    }
    PrintNet(pRootNet,"current RootNet");
    pExList=pExecNetList;
    PointerControl(pExList);
    while(pExList->Kind != kMPC_FreeNode) {
      pNet=pExList->MPC_NetList.Net;
      PointerControl(pNet);
      is_not_root+=!is_root(pRootNet,pNet);
      pExList=pExList->MPC_NetList.Next;
      PointerControl(pExList);
    }
    /*if(pEvalNetList != NoTree) {
      pEvList=pEvalNetList;
      while(pEvList->Kind != kMPC_FreeNode) {
        pNet=pEvList->MPC_NetList.Net;
        PointerControl(pNet);
        is_not_root+=!is_root(pRootNet,pNet);
        pEvList=pEvList->MPC_NetList.Next;
        PointerControl(pEvList);
      }
    }*/
    if(pRootNet == HOST) {
      if(is_not_root) {
        fprintf(stderr,
                "RootNet is host but there is unmarked nodes\n");
        internal_error();
      }
      break;
    }
    if(is_not_root) {
      pRootNet=pRootNet->MPC_NetOrSubnet.Distribution;
      PointerControl(pRootNet);
    }
  }
  return pRootNet;
}  

/*tTree find_root_net(tTree pExecNetList, tTree pEvalNetList) {
  tTree pRootNet;
  tTree pNet;
  tTree pExList,pEvList;
  int is_not_root=1;
  PointerControl(pExecNetList);
  if(prt) printf("find_root_net pExecNetList=%p  pEvalNetList=%p\n",
         pExecNetList,pEvalNetList);
  PrintNetList(pExecNetList,0,"ExecNetList");
  PrintNetList(pEvalNetList,0,"EvalNetList");
  pRootNet=pExecNetList->MPC_NetList.Net;
  PointerControl(pRootNet);
  while(is_not_root) {
    is_not_root=0;
    while(pRootNet->Kind != kMPC_Net) {
      pRootNet=pRootNet->MPC_NetOrSubnet.Distribution;
      PointerControl(pRootNet);
    }
    PrintNet(pRootNet,"current RootNet");
    pExList=pExecNetList->MPC_NetList.Next;
    PointerControl(pExList);
    while(pExList->Kind != kMPC_FreeNode) {
      pNet=pExList->MPC_NetList.Net;
      PointerControl(pNet);
      is_not_root+=!is_root(pRootNet,pNet);
      pExList=pExList->MPC_NetList.Next;
      PointerControl(pExList);
    }
    if(pEvalNetList != NoTree) {
      pEvList=pEvalNetList;
      while(pEvList->Kind != kMPC_FreeNode) {
        pNet=pEvList->MPC_NetList.Net;
        PointerControl(pNet);
        is_not_root+=!is_root(pRootNet,pNet);
        pEvList=pEvList->MPC_NetList.Next;
        PointerControl(pEvList);
      }
    }
    if(pRootNet == HOST) {
      if(is_not_root) {
        fprintf(stderr,
                "RootNet is host but there is unmarked nodes\n");
        internal_error();
      }
      break;
    }
    if(is_not_root) {
      pRootNet=pRootNet->MPC_NetOrSubnet.Distribution;
      PointerControl(pRootNet);
    }
  }
  return pRootNet;
}*/  

int NetEqList(tTree pNet, tTree pList) {
  tTree pNext;
  PointerControl(pList);
  pNext=pList->MPC_NetList.Next;
  PointerControl(pNext);
  return (pNet == pList->MPC_NetList.Net) &&
    pNext->Kind == kMPC_FreeNode;
}

tTree first_not_flexible(tTree pNet) {
  PointerControl(pNet);
  while(pNet->Kind == kMPC_Subnet && pNet->MPC_Subnet.Flexible) {
    pNet=pNet->MPC_Subnet.Distribution;
    PointerControl(pNet);
  }
  return pNet;
}
