/*
 * $Id: NetType_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* code generation for MPC_NetTypeDecl and correspond nodes */
/* Coded by A.Kalinov 10.95 */

#include "be_print.h"

void print_TopoFunction(tTree );
static int class;

void print_NetType(tTree pNetType) {
  tIdent Ident;
  tTree pTopoFun;
  int pos;
  int i;
  PointerControl(pNetType);
  cur_net_type=pNetType;
  Ident=pNetType->MPC_NetType.Ident;
  IdentControl(Ident);
  GetString(Ident,IdentBuf);
  fprintf(file,"\n/* Net type %s declaration */\n",IdentBuf);
  pTopoFun=pNetType->MPC_NetType.TopoFunctions;
  class=pNetType->MPC_NetType.Class;
  PointerControl(pTopoFun);
  if(gen_topo_fun) {
    print_TopoFunction(pTopoFun);
  }
  if(class == STATIC) fputs("static ",file);
  else if(class == EXTERN) fputs("extern ",file);
  else if(class != UNDEFINED) {
    fprintf(stderr,"invalid network type class=%d\n",class);
    internal_error();
  }
  pos=fprintf(file,"%s %s",
	      TypeName(pNetType),VarName(pNetType));
  if(class != EXTERN) {
    fprintf(file,"={%d,\n",coord_number(pNetType));
    for(i=0; i<TOPO_FUN_NUM-1; i++) {
      blank(pos);
      fprintf(file,"%s,\n",TopoFunName(pNetType,i));
    }
    if(pTopoFun->MPC_TopoFunctions.Mapping_Def != NoTree) {
      blank(pos);
      fprintf(file,"%s}",TopoFunName(pNetType,TOPO_FUN_NUM-1));
    }
    else {
      blank(pos);
      fprintf(file,"NULL}");
    }
  }
  else fputs(";\n",file);
  cur_net_type=NoTree;
}

void print_TopoDecl(tTree pFun, int Num) {
  tTree pVar;
  PointerControl(pFun);
  topo_fun_code=Num;
  pVar=pFun->MPC_Function.Name;
  PointerControl(pVar);
  if(class == STATIC) fputs("static ",file);
  else if(class == EXTERN) fputs("extern ",file);
  /*fputs("static ",file);*/
  print_Var(pVar);
  fputs(";\n",file);
}
                    
void print_TopoDef(tTree pFun, int Num) {
  PointerControl(pFun);
  topo_fun_code=Num;
  if(class == STATIC) fputs("static ",file);
  else if(class == EXTERN) fputs("extern ",file);
  /*fputs("static ",file);*/
  print_Function(pFun);
}
                    

void print_TopoFunction(tTree pTopoFun) {
  is_topo_fun=1;
  print_base_type=1;
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Node_Def,NODE);
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Link_Def,LINK);
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Main_Node_Def,MAIN);
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Power_Def,POWER);
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Node_Coord_Def,COORD);
  print_TopoDecl(pTopoFun->MPC_TopoFunctions.Node_Number_Def,NUMBER);
  if(pTopoFun->MPC_TopoFunctions.Mapping_Def != NoTree) {
    print_TopoDecl(pTopoFun->MPC_TopoFunctions.Mapping_Def,MAPPING);
  }
  fprintf(file,"\n");
  if(class != EXTERN) {
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Node_Def,NODE);
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Link_Def,LINK);
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Main_Node_Def,MAIN);
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Power_Def,POWER);
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Node_Coord_Def,COORD);
    print_TopoDef(pTopoFun->MPC_TopoFunctions.Node_Number_Def,NUMBER);
    if(pTopoFun->MPC_TopoFunctions.Mapping_Def != NoTree) {
      in_mapping=1;
      print_TopoDef(pTopoFun->MPC_TopoFunctions.Mapping_Def,MAPPING);
      in_mapping=0;
    }
    fputs("\n",file);
  }
  topo_fun_code=NOT_TOPO_FUN;
  is_topo_fun=0;
}

int param_number(tTree pNetType) {
  int param_count=0;
  tTree pParam;
  pParam=pNetType->MPC_NetType.ParamList;
  if(pParam != NoTree) {
    if(prt) printf("param_number pParam->Kind=%d\n",pParam->Kind);
    while(pParam->Kind != kMPC_FreeNode) {
      param_count++;
      pParam=pParam->MPC_Var.Next;
      PointerControl(pParam);
    }
  }
  return param_count;
}

int coord_number(tTree pNetType) {
  int coord_count=0;
  tTree pCoordDecl;
  PointerControl(pNetType);
  if(prt) printf("coord_number pNetType=%p Kind=%d\n",pNetType,pNetType->Kind);
  if(pNetType->Kind == kMPC_NetTypeSpecifier) {
    pNetType=pNetType->MPC_NetTypeSpecifier.NetType;
    PointerControl(pNetType);
  }
  pCoordDecl=pNetType->MPC_NetType.CoordDecl;
  PointerControl(pCoordDecl);
  while(pCoordDecl->Kind != kMPC_FreeNode) {
    coord_count++;
    pCoordDecl=pCoordDecl->MPC_CoordDecl.Next;
    PointerControl(pCoordDecl);
  }
  return coord_count;
}

