/*
 * $Id: NetDecl_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* code generation for MPC_NetDecl, MPC_NetDecl and correspond nodes */
/* Coded by A.Kalinov 10.95 */

#include "be_print.h"

int is_param_list;
int var_pos;
void print_CoordArray(tTree ,tTree ,tDeclFlags );
void print_NetParamBlock(tTree ,tTree ,tTree ,tDeclFlags );
tGen p_net;
void print_NetDesc(tTree , tDeclFlags );
void print_SubnetDesc(tTree , tDeclFlags );
static int net_is_static(tTree , tDeclFlags );

void print_NetOrSubnet(tTree pDecl) {
  /*  if(prt) printf("print_NetOrSubnet begin\n");*/
  PointerControl(pDecl);
  if(pDecl->Kind == kMPC_NetDecl) {
    print_NetDecl(pDecl);
  }
  else if(pDecl->Kind == kMPC_SubnetDecl) {
    print_SubnetDecl(pDecl);
  }
  /*  if(prt) printf("print_NetOrSubnet end\n");*/
}

void print_NetDecl(tTree pNetDecl) {
  tTree pNet;
  tDeclFlags flag;
  tTree pNetTypeSpec;
  tTree pArgList;
  tTree pNetType;
  tTree pParamList;
  if(prt) printf("NetDecl generation is started \n");
  PointerControl(pNetDecl);
  pNet=pNetDecl->MPC_NetDecl.Net;
  PointerControl(pNet);
  cur_Decl=pNetDecl;
  pNetTypeSpec=pNetDecl->MPC_NetDecl.NetTypeSpecifier;
  PointerControl(pNetTypeSpec);
  flag=pNetDecl->MPC_NetDecl.Flag;
  is_param_list=0;
  if(!flag.Extern) {
    pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
    PointerControl(pNetType);
    print_CoordArray(pNet,pNetType,flag);
    pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
    pParamList=pNetType->MPC_NetType.ParamList;
    if(pParamList != NoTree) {
      if(prt) printf("pParamList->Kind=%d pArgList->Kind=%d pNetTypeSpec->Kind=%d all_known_len=%d\n",
                     pParamList->Kind,pArgList->Kind,pNetTypeSpec->Kind,
                     all_known_len(pParamList));
      while(pNet->Kind != kMPC_FreeNode) {
        if(all_known_len(pParamList) == 0) {
          print_NetParamBlock(pArgList,pNet,pNetType,flag);
        }
        else {
          c_blank;
          /*print_VarStorageClass(flag);
          printf("all_known_len=1\n");
          if(flag.Static || pNet->MPC_Net.Topology == CONST) {
            fprintf(file,"static ");
          }*/
          fprintf(file,"static MPC_Parameters* %s_params;\n",VarName(pNet));
        }
        pNet=pNet->MPC_Net.Next;
        PointerControl(pNet);
      }
    }
    else if(pArgList != NoTree && pArgList->Kind != kMPC_FreeNode) {
      fprintf(stderr,"pParamList == NoTree and Arglist != NoTree\n");
      internal_error();
    }
  }
  pNet=pNetDecl->MPC_NetDecl.Net;
  PointerControl(pNet);
  while(pNet->Kind != kMPC_FreeNode) {
    if(!in_function) HitchToGenTree(pNet);
    c_blank;
    print_VarStorageClass(flag);
    var_pos=cur_pos+fprintf(file,"%s ",TypeName(pNet));
    print_NetDesc(pNet,flag);
    pNet=pNet->MPC_Net.Next;
    PointerControl(pNet);
    fputs(";\n",file);
  } 
  if(prt) printf("NetDecl generation is ended \n");
}

void print_SubnetDecl(tTree pSubnetDecl) {
  tTree pSubnet;
  tDeclFlags flag;
  if(prt) printf("SubnetDecl generation is started \n");
  PointerControl(pSubnetDecl);
  pSubnet=pSubnetDecl->MPC_SubnetDecl.Subnet;
  PointerControl(pSubnet);
  cur_Decl=pSubnetDecl;
  flag=pSubnetDecl->MPC_SubnetDecl.Flag;
  while(pSubnet->Kind != kMPC_FreeNode) {
    if(!in_function) HitchToGenTree(pSubnet);
    if(!(pSubnet->MPC_Subnet.Flexible == 1)) {
      c_blank;
      print_VarStorageClass(flag);
      var_pos=cur_pos+fprintf(file,"%s ",TypeName(pSubnet));
      print_SubnetDesc(pSubnet,flag);
      fputs(";\n",file);
    }
    pSubnet=pSubnet->MPC_Subnet.Next;
    PointerControl(pSubnet);
  } 
  if(prt) printf("SubnetDecl generation is ended \n");
}

tTree Decl_of_NetOrSubnet(tTree pNet) {
  PointerControl(pNet);
  if(prt) printf("Decl_of_NetOrSubnet  enter pNet=%p Kind=%d Num=%d\n",
	 pNet,pNet->Kind,pNet->MPC_NetOrSubnet.UniqueNumber);
  while(pNet->Kind != kMPC_FreeNode) {
    pNet=pNet->MPC_NetOrSubnet.Next;
    PointerControl(pNet);
    if(prt) printf("        pNet=%p Kind=%d Num=%d\n",
	   pNet,pNet->Kind,pNet->MPC_NetOrSubnet.UniqueNumber);
  }
  if(prt) printf("Decl_of_NetOrSubnet return pNet=%p Kind=%d Parent=%p\n",
	 pNet,pNet->Kind,pNet->MPC_FreeNode.Parent);
  return pNet->MPC_FreeNode.Parent;
}
  
int is_auto_parent(tTree pNetOrSubnet) {
  tTree pNetOrSubnetDecl;
  tDeclFlags flag;
  PointerControl(pNetOrSubnet);
  pNetOrSubnet=pNetOrSubnet->MPC_Net.Distribution;
  while(pNetOrSubnet != NoTree) {
    if(pNetOrSubnet == HOST) return 0;
    if(!(pNetOrSubnet->Kind == kMPC_Subnet &&
         pNetOrSubnet->MPC_Subnet.Flexible)) {
      pNetOrSubnetDecl=Decl_of_NetOrSubnet(pNetOrSubnet);
      PointerControl(pNetOrSubnetDecl);
      switch(pNetOrSubnetDecl->Kind) {
      case kMPC_NetDecl:
        flag=pNetOrSubnetDecl->MPC_NetDecl.Flag;
        break;
      case kMPC_SubnetDecl:
        flag=pNetOrSubnetDecl->MPC_SubnetDecl.Flag;
        break;
      default:
        fprintf(stderr,"wrong Decls of the NetOrSubnetDecl Kind=%d\n",
                pNetOrSubnetDecl->Kind);
        internal_error();
      }
      if(flag.Auto) return 1;
    }
    pNetOrSubnet=pNetOrSubnet->MPC_NetOrSubnet.Distribution;
  }
  return 0;
}

void print_NetDesc(tTree pNet, tDeclFlags flag){
  int pos;
  tTree pNetTypeDecl,pNetTypeSpec;
  PointerControl(pNet);
  if(prt) printf("print_NetDesc pNet=%d Auto=%d Static=%d Extern=%d WithNumber=%d\n",
                 pNet->MPC_Net.UniqueNumber,flag.Auto,flag.Static,
                 flag.Extern,pNet->MPC_Net.WithNumber);
  pNetTypeSpec=pNet->MPC_Net.NetType;
  PointerControl(pNetTypeSpec);
  if(pNetTypeSpec->Kind == kMPC_NetTypeSpecifier) {
    pNetTypeDecl=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
  }
  else {
    pNetTypeDecl=pNetTypeSpec;
  }
  PointerControl(pNetTypeDecl);
  pos=var_pos+fputs(VarName(pNet),file);
  if(!flag.Extern) {
    tTree pParamList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
    pos+=fputs("={",file);
    fprintf(file,"%s,\n",UNVOTED_NET);
    blank(pos);
    fprintf(file,"&%s,\n",VarName(pNetTypeDecl));
    /* place for count of the parameters */
    blank(pos);
    if(pParamList != NoTree && pParamList -> Kind != kMPC_FreeNode &&
       pNet->MPC_Net.Topology == CONST && !in_function) {
      print_ParamNumber(pParamList,-1);
      fprintf(file,",\n");
      blank(pos);
      fprintf(file,"%s_params,\n",
              VarName(pNet/*TypeDecl*/)/*,cur_net_param_num*/);
    }
    else {
      fputs("0,\n",file);
      blank(pos);
      fputs("NULL,\n",file);
    }
    blank(pos);
    if((cur_block->MPC_Compound.FunctionBody &&
	 is_main_function) || !in_function) {
      fputs("MPC_STATIC_NET,\n",file);
    }
    else {
      if(flag.Auto || !(flag.Static || flag.Extern) ||
         is_auto_parent(pNet)) {
	fputs("MPC_AUTO_NET,\n",file);
      }
      else {
	fputs("MPC_STATIC_NET,\n",file);
      }
    }
    blank(pos);
    if(!in_function) {
      fprintf(file,"%s_coord,\n",VarName(pNet));
    }
    else {
      fputs("NULL,\n",file);
    }
    blank(pos);
    fprintf(file,"MPC_UNINITED_RANK,\n");
    blank(pos);
    fprintf(file,"MPC_INIT_POWER,NULL,\n");
    blank(pos);
    fprintf(file,"NULL,0,%s,\n","MPC_MULTI_ROOT");
            /*            cur_Decl->MPC_SubnetDecl.Strat ?
            "MPC_MULTI_ROOT" : "MPC_NULL_ROOT");*/
    blank(pos);
    fprintf(file,"NULL,NULL,NULL,NULL,NULL,NULL,");
    fprintf(file,"%s,0,NULL,NULL}",(pNetTypeDecl->MPC_NetType.Bench == 1) ?
            "MPC_BENCH" : "MPC_NOT_BENCH");
  }
}


tTree net_parent(tTree pNetOrSubnet) {
  PointerControl(pNetOrSubnet);
  if(pNetOrSubnet == HOST) {
    be_error("sorry, something wrong in the assignment");
  }
  pNetOrSubnet=pNetOrSubnet->MPC_Net.Distribution;
  PointerControl(pNetOrSubnet);
  while(pNetOrSubnet->Kind != kMPC_Net) {
    pNetOrSubnet=pNetOrSubnet->MPC_NetOrSubnet.Distribution;
    PointerControl(pNetOrSubnet);
  }
  return pNetOrSubnet;
}

void print_SubnetDesc(tTree pSubnet, tDeclFlags flag){
  int pos;
  tTree pParent;
  tTree pParentNet;
  PointerControl(pSubnet);
  pSubnet->MPC_Subnet.WithNumber=(!in_function || flag.Extern) ? 0 : 1;
  pParent=pSubnet->MPC_Subnet.Distribution;
  PointerControl(pParent);
  pParentNet=net_parent(pSubnet);
  PointerControl(pParentNet);
  pos=var_pos+fputs(VarName(pSubnet),file);
  if(!flag.Extern) {
    pos+=fputs("={",file);
    fprintf(file,"%s,\n",UNVOTED_NET);
    blank(pos);
    fputs("NULL,0,NULL,\n",file);
    blank(pos);
    if((cur_block->MPC_Compound.FunctionBody &&
	 is_main_function) || !in_function) {
      fputs("MPC_STATIC_NET,\n",file);
    }
    else {
      if(flag.Auto || !(flag.Static || flag.Extern) ||
         is_auto_parent(pSubnet)) {
	fputs("MPC_AUTO_NET,\n",file);
      }
      else {
	fputs("MPC_STATIC_NET,\n",file);
      }
    }
    blank(pos);
    fputs("NULL,\n",file);
    blank(pos);
    fprintf(file,"MPC_UNINITED_RANK,\n");
    blank(pos);
    if(!in_function || !flag.Auto) {
      fprintf(file,"0,&%s,\n",VarName(pParent));
    }
    else {
      fputs("0,NULL,\n",file);
    }      
    blank(pos);
    fprintf(file,"NULL,0,%s,\n","MPC_MULTI_ROOT");
    /*            cur_Decl->MPC_SubnetDecl.Strat ?
            "MPC_MULTI_ROOT" : "MPC_NULL_ROOT");*/
    blank(pos);
    fprintf(file,"NULL,NULL,NULL,NULL,NULL,NULL}");
  }
}

void print_CoordArray(tTree pNet,tTree pNetType,tDeclFlags flag) {
  int coord_num;
  PointerControl(pNet);
  PointerControl(pNetType);
  coord_num=coord_number(pNetType);
  while(pNet->Kind != kMPC_FreeNode) {
    c_blank;
    /*if(!in_function || !flag.Auto) {
      fputs("static ",file);
    }*/
    pNet->MPC_Net.WithNumber=(!in_function || flag.Extern) ? 0 : 1;
    fprintf(file,"%sint %s_coord[%d];\n",
            net_is_static(pNet,flag) ? "static " : "",
            VarName(pNet),coord_num);
    pNet=pNet->MPC_Net.Next;
    PointerControl(pNet);
  }
}

void print_NetParamBlock(tTree pArgList,tTree pNet,tTree pNetType,
			 tDeclFlags flag) {
  c_blank;
  /*if(!in_function || !flag.Auto) {
    fputs("static ",file);
  }*/
  if(pArgList->Kind != kMPC_FreeNode) {
    is_param_list=1;
    fprintf(file,"%sMPC_Parameters %s_params[",
            net_is_static(pNet,flag) ? "static " : "",
            VarName(pNet));
    print_ParamNumber(pArgList,-1);
    fprintf(file,"]");
    if(prt) printf("pNet=%p Topology=%d pArgList->Kind=%d\n",
           pNet,pNet->MPC_Net.Topology,pArgList->Kind);
    if(pNet->MPC_Net.Topology == CONST) {
      fputs("={",file);
      while(pArgList->Kind != kMPC_FreeNode) {
        tTree pExpr;
        pExpr=pArgList->Kind == kMPC_Exprs ? pArgList->MPC_Exprs.Expr :
          pArgList;
        PointerControl(pExpr);
        print_Expr(pExpr);
        pArgList=pArgList->Kind == kMPC_Exprs ? pArgList->MPC_Exprs.Next :
          pArgList->MPC_Var.Next;
        PointerControl(pArgList);
        if(pArgList->Kind != kMPC_FreeNode)
          fputs(",",file);
        else 
          fputs("}",file);
      }
    }
    fputs(";\n",file);
  }
  else {
    is_param_list=0;
  }
}

void create_MyList(tTree pNet) {
  tTree pMyList;
  if(pNet != NoTree && Tree_IsType(pNet,kMPC_NetOrSubnet)) {
    if(pNet->MPC_NetOrSubnet.MyList == NoTree) {
      if(prt) printf("create_MyList pNet=%p kind=%d",
                     pNet,pNet->Kind);
      if(!(pNet->Kind == kMPC_Subnet && pNet->MPC_Subnet.Flexible == 1)) {
        if(pNet->MPC_NetOrSubnet.Ident != NoIdent) {
          if(prt) printf(" name=%s",VarName(pNet));
        }
        else {
          if(prt) printf(" name=NoName\n");
        }
      }
      if(pNet == HOST) {
        pNet->MPC_NetOrSubnet.MyList=HOST_LIST;
      }
      else if(pNet == SINGLE_NODE) {
        pNet->MPC_NetOrSubnet.MyList=SINGLE_NODE_LIST;
      }
      else if(pNet == COMPUTING_SPACE) {
        pNet->MPC_NetOrSubnet.MyList=COMPUTING_SPACE_LIST;
        pNet->MPC_NetOrSubnet.Distribution=HOST;
      }
      else if(pNet == CONST_NET) {
        pNet->MPC_NetOrSubnet.MyList=CONST_NET_LIST;
      }
      else {
        pNet->MPC_NetOrSubnet.MyList=nMPC_NetList();
        pMyList=pNet->MPC_NetOrSubnet.MyList;
        PointerControl(pMyList);
        pMyList->MPC_NetList.Net=pNet;
        pMyList->MPC_NetList.Next=nMPC_FreeNode();
      }
      if(prt) printf(" pMyList=%p\n",pNet->MPC_NetOrSubnet.MyList);
    }
  }
}

void set_params(tTree pNetDecl) {
  tDeclFlags flag;
  PointerControl(pNetDecl);
  if(pNetDecl->Kind == kMPC_NetDecl) {
    tTree pNet;
    tTree pNetTypeSpec;
    tTree pArgList;
    tTree pNetType;
    /*tTree pParamList;*/
    PointerControl(pNetDecl);
    flag=pNetDecl->MPC_NetDecl.Flag;
    if(!flag.Extern && in_function) {
      pNetTypeSpec=pNetDecl->MPC_NetDecl.NetTypeSpecifier;
      PointerControl(pNetTypeSpec);
      pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
      PointerControl(pNetType);
      pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
      PointerControl(pArgList);
      pNet=pNetDecl->MPC_NetDecl.Net;
      PointerControl(pNet);
      while(pNet->Kind != kMPC_FreeNode) {
        c_blank;
        fprintf(file,"%s.coord=%s_coord;\n",VarName(pNet),VarName(pNet));
        if(pArgList->Kind != kMPC_FreeNode &&
           pNet->MPC_Net.Topology == CONST) {
          c_blank;
          fprintf(file,"%s.count=",VarName(pNet));
          print_ParamNumber(pArgList,-1);
          fputs(";\n",file);
          c_blank;
          fprintf(file,"%s.params=%s_params;\n",VarName(pNet),VarName(pNet));
        }
        pNet=pNet->MPC_Net.Next;
        PointerControl(pNet);
      }
    }
  }
  else if(pNetDecl->Kind == kMPC_SubnetDecl) {
    tTree pSubnet;
    tTree pParent;
    pSubnet=pNetDecl->MPC_SubnetDecl.Subnet;
    PointerControl(pSubnet);
    flag=pNetDecl->MPC_SubnetDecl.Flag;
    if(in_function/* && flag.Auto*/) {
      while(pSubnet->Kind != kMPC_FreeNode) {
        if(!(pSubnet->MPC_Subnet.Flexible == 1)) {
          pParent=pSubnet->MPC_Subnet.Distribution;
          PointerControl(pParent);
          c_blank;
          fprintf(file,"%s.supernet=",VarName(pSubnet));
          fprintf(file,"&%s;\n",VarName(pParent));
        }
        pSubnet=pSubnet->MPC_Subnet.Next;
        PointerControl(pSubnet);
      }
    }
  } 
}

static int net_is_static(tTree pNet, tDeclFlags flag) {
  int ret=0;
  PointerControl(pNet);
  if((cur_block->MPC_Compound.FunctionBody &&
      is_main_function) || !in_function) {
    ret=1;
  }
  else {
    if(flag.Auto || !(flag.Static || flag.Extern) ||
       is_auto_parent(pNet)) {
      ret=0;
    }
    else {
      ret=1;
    }
  }
  return ret;
}
