# ifndef yyIlpTree
# define yyIlpTree

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# include <stdio.h>

# ifndef bool
# define bool char
# endif
# define NoIlpTree (tIlpTree) 0L
# define kReg 1
# define kPointerReg 2
# define kVectorReg 3
# define kScalarReg 4
# define kIlpNode 5
# define kIlpAssignExpr 6
# define kIlpExpr 7
# define kIlpUnaryExpr 8
# define kIlpBinaryExpr 9

typedef unsigned char IlpTree_tKind;
typedef unsigned short IlpTree_tMark;
typedef unsigned short IlpTree_tLabel;
typedef union IlpTree_Node * tIlpTree;
typedef void (* IlpTree_tProcTree) ARGS((tIlpTree));

# ifndef IlpTree_NodeHead
# define IlpTree_NodeHead
# endif
typedef struct { IlpTree_tKind yyKind; IlpTree_tMark yyMark; IlpTree_NodeHead } IlpTree_tNodeHead;
typedef struct { IlpTree_tNodeHead yyHead; int num; int type; tIlpTree next; } yReg;
typedef struct { IlpTree_tNodeHead yyHead; int num; int type; tIlpTree next; } yPointerReg;
typedef struct { IlpTree_tNodeHead yyHead; int num; int type; tIlpTree next; } yVectorReg;
typedef struct { IlpTree_tNodeHead yyHead; int num; int type; tIlpTree next; } yScalarReg;
typedef struct { IlpTree_tNodeHead yyHead; tIlpTree Next; } yIlpNode;
typedef struct { IlpTree_tNodeHead yyHead; tIlpTree Next; tIlpTree operand; tIlpTree roperand; } yIlpAssignExpr;
typedef struct { IlpTree_tNodeHead yyHead; tIlpTree Next; int regQuant; tIlpTree regList; } yIlpExpr;
typedef struct { IlpTree_tNodeHead yyHead; tIlpTree Next; int regQuant; tIlpTree regList; short opCode; tIlpTree operand; } yIlpUnaryExpr;
typedef struct { IlpTree_tNodeHead yyHead; tIlpTree Next; int regQuant; tIlpTree regList; short opCode; tIlpTree loperand; tIlpTree roperand; } yIlpBinaryExpr;

union IlpTree_Node {
 IlpTree_tKind Kind;
 IlpTree_tNodeHead yyHead;
 yReg Reg;
 yPointerReg PointerReg;
 yVectorReg VectorReg;
 yScalarReg ScalarReg;
 yIlpNode IlpNode;
 yIlpAssignExpr IlpAssignExpr;
 yIlpExpr IlpExpr;
 yIlpUnaryExpr IlpUnaryExpr;
 yIlpBinaryExpr IlpBinaryExpr;
};

extern tIlpTree IlpTreeRoot;
extern unsigned long IlpTree_HeapUsed;
extern char * IlpTree_PoolFreePtr, * IlpTree_PoolMaxPtr;
extern unsigned short IlpTree_NodeSize [9 + 1];
extern char * IlpTree_NodeName [9 + 1];

extern void (* IlpTree_Exit) ();
extern tIlpTree IlpTree_Alloc ();
extern tIlpTree MakeIlpTree ARGS((IlpTree_tKind yyKind));
extern bool IlpTree_IsType ARGS((register tIlpTree yyt, register IlpTree_tKind yyKind));

extern tIlpTree nReg ();
extern tIlpTree nPointerReg ();
extern tIlpTree nVectorReg ();
extern tIlpTree nScalarReg ();
extern tIlpTree nIlpNode ();
extern tIlpTree nIlpAssignExpr ();
extern tIlpTree nIlpExpr ();
extern tIlpTree nIlpUnaryExpr ();
extern tIlpTree nIlpBinaryExpr ();

extern tIlpTree mReg ARGS((int pnum, int ptype));
extern tIlpTree mPointerReg ARGS((int pnum, int ptype));
extern tIlpTree mVectorReg ARGS((int pnum, int ptype));
extern tIlpTree mScalarReg ARGS((int pnum, int ptype));
extern tIlpTree mIlpNode ARGS(());
extern tIlpTree mIlpAssignExpr ARGS((tIlpTree poperand, tIlpTree properand));
extern tIlpTree mIlpExpr ARGS(());
extern tIlpTree mIlpUnaryExpr ARGS((short popCode, tIlpTree poperand));
extern tIlpTree mIlpBinaryExpr ARGS((short popCode, tIlpTree ploperand, tIlpTree properand));

extern void ReleaseIlpTree ARGS((tIlpTree yyt));
extern void WriteIlpTree ARGS((FILE * yyyf, tIlpTree yyt));
extern void TraverseIlpTreeTD ARGS((tIlpTree yyt, IlpTree_tProcTree yyyProc));
extern void TraverseIlpTreeBU ARGS((tIlpTree yyt, IlpTree_tProcTree yyyProc));
extern tIlpTree CopyIlpTree ARGS((tIlpTree yyt));
extern void BeginIlpTree ();
extern void CloseIlpTree ();

# endif
