/*
 * $Id: GenTree.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


/* support of the genealogic tree */
/* Coded by A.Kalinov 10.95 - */
/* Version with undefined waiting point only 08.97 - */

#include "be_print.h"
#include "Memory.h"

static tTree cur_parent;
static int const_expr;

void add_block_to_list() {
  Blocks* blk=block_list;
  /*printf("add_block_to_list block_list=%p cur_block=%p\n",
         block_list,cur_block);*/
  if(block_list == NoBlock) {
    block_list=malloc(sizeof(Blocks));
    block_list->Block=cur_block;
    block_list->Next=NoBlock;
  }
  else {
    while(blk->Next != NoBlock) {
      blk=blk->Next;
    }
    blk->Next=malloc(sizeof(Blocks));
    blk=blk->Next;
    blk->Block=cur_block;
    blk->Next=NoBlock;
    /*printf("                blk=%p blk->Block=%p blk->Next=%p\n",
           blk,blk->Block,blk->Next);*/
  }
}

tTree StatExecNet(tTree pStat) {
  tTree pExecNet;
  tTree pExpr;
  PointerControl(pStat);
  if(pStat->Kind == kMPC_ExprStat &&
     (pExpr=pStat->MPC_ExprStat.Expr) != NoTree) {
    /*PointerControl(pExpr);*/
    pExecNet=ExprEvalNet(pExpr);
  }
  else {
    pExecNet=pStat->MPC_Stat.ExecNet;
  }
  PointerControl(pExecNet);
  return pExecNet;
}

void fill_gen_tree(tTree yyt) {
  tTree yyn;
  if(prt) printf("fill_gen_tree yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind);
/*    WriteGen(stdout,int_gen_tree); */ 
  PointerControl(yyt);
  yyn=yyt->MPC_Compound.Decls;
  PointerControl(yyn);
  Net_traverse(yyn,HitchToGenTree);
}

tString empty_string() { 
  tString yys;
  yys=Alloc(strlen("")+1);
  return strcpy(yys,"");
}

tString make_string(char* s) { 
  tString yys;
  yys=Alloc(strlen(s)+1);
  return strcpy(yys,s);
}

tString make_pow_var_name(tTree yyt) { 
  tString yys;
  PointerControl(yyt);
  sprintf(NameBuf,"MPC_power_%d",yyt->MPC_Net.UniqueNumber);
  yys=Alloc(strlen(NameBuf)+1);
  return strcpy(yys,NameBuf);
}

tString make_int_name(int num) {
  tString yys;
  sprintf(NameBuf,"%d",num);
  yys=Alloc(strlen(NameBuf)+1);
  return strcpy(yys,NameBuf);
}

void print_topo_params(tTree pNet) {
  tTree pArgList;
  tTree pNetTypeSpec;
  tTree pNetType;
  int i;
  int old_change_net=not_change_net;
  PointerControl(pNet);
  if(prt) printf("print_topo_params pNet=%p cur_Decl=%p\n",pNet,cur_Decl);
  pNetTypeSpec=pNet->MPC_Net.NetType;
  PointerControl(pNetTypeSpec);
  pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
  PointerControl(pNetType);
  pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
  /*printf("*/
  if(pArgList != NoTree) {
    not_change_net=1;
    i=0;
    while(pArgList->Kind != kMPC_FreeNode) {
      c_blank;
      cur_pos+=fprintf(file,"%s.params[%d]=",
		       VarName(pNet),i++);
      print_Expr(pArgList->MPC_Exprs.Expr);
      cur_pos+=fputs(";\n",file);
      pArgList=pArgList->MPC_Exprs.Next;
      PointerControl(pArgList);
    }
  }
  not_change_net=old_change_net;
}

int net_topology(tTree pNetOrSubnet) {
  tTree pParent=pNetOrSubnet;
  PointerControl(pNetOrSubnet);
  while(pParent != HOST) {
    if(pParent->Kind == kMPC_Net) {
      return pParent->MPC_Net.Topology;
    }
    else {
      pParent=pParent->MPC_NetOrSubnet.Distribution;
      PointerControl(pParent);
    }
  }
  return DYNAMIC;
}

void check_const_expr(tTree yyt) {
  if(yyt!= NoTree) {
    if(Tree_IsType(yyt,kMPC_Expr)) {
      if(yyt->Kind == kMPC_CallExpr &&
         (yyt->Kind == kMPC_Ident &&
          (yyt->MPC_Ident.Store != NoTree &&
           yyt->MPC_Ident.Store->Kind != kMPC_CoordDecl))) {
        const_expr=0;
      }
    }
  }
}

int all_known(tTree pNetOrSubnet) {
  tTree pParent=pNetOrSubnet;
  int ret=1,local;
  PointerControl(pNetOrSubnet);
  /*pParent=pNetOrSubnet->MPC_NetOrSubnet.Distribution;*/
  while(pParent != HOST) {
    local=0;
    if(pParent->Kind == kMPC_Net) {
      local=pParent->MPC_Net.Topology == CONST;
    }
    else {
      tTree pPredicate=pParent->MPC_Subnet.Predicate;
      PointerControl(pPredicate);
      const_expr=1;
      Expr_traverse(pPredicate,check_const_expr);
      local=const_expr;
    }
    local+=pParent->MPC_NetOrSubnet.SingleNode;
    if(prt) printf("all_known net=%s kind=%d local=%d const_expr=%d \n",
                   VarName(pParent),pParent->Kind,local,const_expr);
    if(local == 0) {
      ret=0;
      break;
    }
    pParent=pParent->MPC_Net.Distribution;
    PointerControl(pParent);
  }
  return ret;
}

static predecessor_level;

void set_predecessor(tGen p_net) {
  predecessor_level=1;
  GenControl(p_net);
  if(p_net->Kind == kNet && !p_net->Net.Subnet &&
     !p_net->Net.Flexible && (p_net->Net.Num == point_num || 
              (p_net->Net.Num == EXTERNAL_NUM &&
               first_waiting_point_in_function))) {
    if(prt) printf("set_predecessor begin  p_net=%p %s\n",
                   p_net,VarName(p_net->Net.pNet));
    while(p_net != int_gen_tree) {
      p_net=p_net->Net.Parent;
      GenControl(p_net);
      if(!p_net->Net.Subnet) {
        if(p_net->Net.Pred < predecessor_level) {
          if(p_net->Net.Pred == 0 && predecessor_level > 1) break;
          p_net->Net.Pred+=1;
          predecessor_level++;
      if(prt)
        printf("  p_net=%s Subnet=%d Pred=%d predecessor_level=%d\n",
               VarName(p_net->Net.pNet),
               p_net->Net.Subnet,p_net->Net.Pred,predecessor_level);
        }
        else {
          break;
        }
      }
    }
  }
}

/*static int the_net_was_hitched(tTree pNet) {
  int ret=0;
  tTree pParent;
  tGen pWork;
  PointerControl(pNet);
  pParent=pNet->MPC_NetOrSubnet.Distribution;
  PointerControl(pParent);
  pWork=pParent->Net.Children;
  while(pWork != NoGen) {
    tGen p_net=pWork->Nets.Net;
    if(p_net != NoGen && pNet == p_net->Net.pNet) {
      ret=1;
      break;
    }
    pWork=pWork->Nets.Next;
  }
  if(prt) printf("the_net_was_hitched net=%s ret=%d\n",VarName(pNet),ret);
  return ret;
}*/

tTree Block_of_NetOrSubnet(tTree pNet) {
  tTree pDecls,pBlock;
  PointerControl(pNet);
  if(prt) printf("Block_of_NetOrSubnet pNet name=%s\n",VarName(pNet));
  if(pNet->Kind == kMPC_Subnet && pNet->MPC_Subnet.Flexible == 1) return pRoot;
  if(pNet == fun_distr) return pRoot;
  pDecls=Decl_of_NetOrSubnet(pNet);
  PointerControl(pDecls);
  while(pDecls->Kind != kMPC_FreeNode) {
    pDecls=pDecls->MPC_Decls.Next;
    PointerControl(pDecls);
  }
  pBlock=pDecls->MPC_FreeNode.Parent;
  PointerControl(pBlock);
  return pBlock;
}

void HitchToGenTree(tTree pNetOrSubnet) {
  tDeclFlags flag;
  tGen parent_node;
  PointerControl(pNetOrSubnet);
  if(prt) printf("HitchToGenTree in_function=%d Kind=%d name=%s\n",
	 in_function,pNetOrSubnet->Kind,VarName(pNetOrSubnet));
  if(prt) printf("HitchToGenTree cur_block=%p net_block=%p\n",
                 cur_block,Block_of_NetOrSubnet(pNetOrSubnet));
  if(prt) printf("\n     before hitching\n");
  print_gen_tree(int_gen_tree,0);
  PointerControl(pNetOrSubnet);
  cur_parent=pNetOrSubnet->MPC_NetOrSubnet.Distribution;
  PointerControl(cur_parent);
  PointerControl(cur_Decl);
  if(prt) printf("net=%s",VarName(pNetOrSubnet));
  if(prt) printf("  parent %s\n", VarName(cur_parent));
  parent_node=cur_parent->MPC_NetOrSubnet.pGen;
  if(parent_node == NoGen) {
    if(cur_parent->Kind == kMPC_Subnet &&
       cur_parent->MPC_Subnet.Flexible) {
      tTree old_cur_parent=cur_parent;
      tGen old_parent_node=parent_node;
      HitchToGenTree(cur_parent);
      cur_parent=old_cur_parent;
      parent_node=old_parent_node;
      parent_node=cur_parent->MPC_NetOrSubnet.pGen;
    }
    else {
      fprintf(stderr,
              "net parent was not found in genealogy tree\n");
      internal_error();
    }
  }
  switch(cur_Decl->Kind) {
  case kMPC_NetDecl:
    flag=cur_Decl->MPC_NetDecl.Flag;
    break;
  case kMPC_SubnetDecl:
    flag=cur_Decl->MPC_SubnetDecl.Flag;
    break;
  default:
    flag.Auto=1;
  }
  {
/*  hitch net node to the existing parent node */
    tGen pNetNode;
    int NodeKind=UNKNOWN;
    int topology;
    int flexible;
    flexible=pNetOrSubnet->Kind == kMPC_Net ? 0 :
      pNetOrSubnet->MPC_Subnet.Flexible;      
    topology=net_topology(pNetOrSubnet);
    if(prt) printf("before mNet %s flag.Auto=%d flexible=%d\n",
                   VarName(pNetOrSubnet),flag.Auto,flexible);  
    pNetNode=mNet(topology,NodeKind,
                  pNetOrSubnet->MPC_NetOrSubnet.SingleNode,
                  pNetOrSubnet->Kind == kMPC_Net ? 0 : 1,
                  !in_function ? 0 :
                  flexible || flag.Auto || !(flag.Static || flag.Extern) ||
                  is_auto_parent(pNetOrSubnet),
                  pNetOrSubnet,0,0,flexible,
                  /*cur_block*/Block_of_NetOrSubnet(pNetOrSubnet),
                  0,make_string(""),
                  NoGen,parent_node,0,
                  !in_function ? EXTERNAL_NUM : point_num,NoTree,
                  parent_node->Net.Level+1);
    pNetOrSubnet->MPC_NetOrSubnet.pGen=pNetNode;
    /*if(parent_node->Net.Children == NoGen) {
      parent_node->Net.Children=mNets(NoGen,NoGen);
    }*/
    parent_node->Net.Children=mNets(pNetNode,
                                   parent_node->Net.Children);
  }
  if(prt) printf("\n     after hitching\n");
  print_gen_tree(int_gen_tree,0);
}

void out_blank(int n) {
  int i;
  for(i=0; i<n; i++)
    if(prt) printf(" ");
}

void print_gen_tree(tGen yyt,int print_level) {
  if(yyt != NoGen) {
    tTree pBegin;
    switch(yyt->Kind) {
    case kNet:
      out_blank(print_level);
      if(prt) printf("Net:    yyt=%p Topology=%d Kind=%s UnDist=%d Subnet=%d Auto=%d \n",
	     yyt,yyt->Net.Topology,
	     yyt->Net.Kind == KNOWN ? "KNOWN" : "UNKNOWN",
	     yyt->Net.SingleNode,
	     yyt->Net.Subnet,
	     yyt->Net.Auto);
      out_blank(print_level);
      pBegin=yyt->Net.Block;
      if(prt) printf("        pNet=[%p %d] Created=%d Closed=%d Block=[%p %d] Used=%d\n",
	     yyt->Net.pNet,yyt->Net.pNet->MPC_NetOrSubnet.UniqueNumber,
	     yyt->Net.Created,
	     yyt->Net.Closed,
	     pBegin,
	     pBegin->Kind==kMPC_Compound ?
	     pBegin->MPC_Compound.UniqueNumber :0,
	     yyt->Net.Used);
      out_blank(print_level);
      if(prt) printf("        Children=%p Parent=%d Pred=%d Level=%d Name=%s\n",
	     yyt->Net.Children,
	     yyt->Net.Parent != NoGen ? 
	     yyt->Net.Parent->Net.pNet->MPC_NetOrSubnet.UniqueNumber : -1,
             yyt->Net.Pred,yyt->Net.Level,VarName(yyt->Net.pNet));
      print_gen_tree(yyt->Net.Children,print_level+2);
      break;
    case kNets:
      out_blank(print_level);
      if(prt) printf("Nets:   yyt=%p Net=%p Next=%p\n",
	     yyt,yyt->Nets.Net,
	     yyt->Nets.Next);
      print_gen_tree(yyt->Nets.Net,print_level+2);
      print_gen_tree(yyt->Nets.Next,print_level+2);
      break;
    default:
      break;
    }
  }
}

void traverse_gen_tree(tGen yyt,void (* proc)(tGen)) {
  if(yyt != NoGen) {
    switch(yyt->Kind) {
    case kNet:
      proc(yyt);
      traverse_gen_tree(yyt->Net.Children,proc);
      break;
    case kNets:
      traverse_gen_tree(yyt->Nets.Net,proc);
      traverse_gen_tree(yyt->Nets.Next,proc);
      break;
    default:
      break;
    }
  }
}

tTree real_net_type_param(tTree pVar) {
  tTree pRet=NoTree;
  PointerControl(pVar);
  if(prt) printf("real_net_type_param Var=%s pCurParamList=%p pCurExprs=%p",
                 VarName(pVar),pCurParamList,pCurExprs);
  if(pCurParamList != NoTree && pCurExprs != NoTree &&
     real_param) {
    tTree pParamList=pCurParamList;
    tTree pExprs=pCurExprs;
    if(!(pExprs->Kind == kMPC_Exprs || pExprs->Kind == kMPC_Var)) {
      fprintf(stderr,"wrong kind of the ExprList\n");
      internal_error();
    }
    if(pParamList->Kind != kMPC_Var) {
      fprintf(stderr,"wrong kind of the ParamList\n");
      internal_error();
    }
    while(pParamList->Kind != kMPC_FreeNode) {
      if(pExprs->Kind == kMPC_FreeNode) {
        fprintf(stderr,"not correspond ParamList and ExprList\n");
        internal_error();
      }
      if(pVar == pParamList) {
        if(prt) printf(" pExprs->Kind =%d",pExprs->Kind); 
        pRet=pExprs->Kind == kMPC_Exprs ?
          pExprs->MPC_Exprs.Expr : pExprs;
        PointerControl(pRet);
        break;
      }
      else {
        pParamList=pParamList->MPC_Var.Next;
        PointerControl(pParamList);
        pExprs=pExprs->Kind == kMPC_Exprs ?
          pExprs->MPC_Exprs.Next : pExprs->MPC_Var.Next;
        PointerControl(pExprs);
      }
    }
  }
  if(prt) printf(" pRet=%p\n",pRet);
  return pRet;
}
  
