/*
 * $Id: File_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* code generation for MPC_Root and MPC_Decls nodes */
/* Coded by A.Kalinov 10.95 .. */

#include "be_print.h"
#include "ress.h"

/*#include <time.h>*/

/* NAMES:    File_print
   PURPOSE:  Generates code for MPC_Root node
   SYNOPSYS: s 
   RETURNS:  void
   */
static void set_gen_trees();
static void set_type_to_zero(tTree yyt);
/*static void set_used_dynamic(tTree yyt);*/
static void set_used_dynamic(tType pType);
static void set_used_atribute(tTree yyt);
static void create_pred_var_tree();
static void create_coord_var_tree();
static void print_basic_type_rts_tree();
static void set_gen_to_0(tType );
static void clear_gen(tType );
static void find_same_vector(tType pVector, tType pArray);
static void find_same_pointer(tType pArray);
static void find_same_dyn_type(tType pType);

/*tString SourceFile(tPosition VirtPos);
static int have_to_generate(tTree );*/
static void print_header(tString );
static tGen pGlobal=NoGen;

void File_print(tTree yyt) {
  tTree pDecls;
  char* file_name;
  /*time_t timer; */
  PointerControl(yyt);
  /* Resource db preparing */
  rs_init(RS_DB_NAME);
  /* Initialization of the external variables */
  if(pass_number == 1) {
    IdentBuf=malloc(MAX_IDENT_LEN);
    NameBuf=malloc(MAX_NAME_LEN);
    TypeBuf=malloc(MAX_TYPE_LEN);
  }
  pRoot=yyt;
  topo_fun_code=NOT_TOPO_FUN;
  cur_net_type=NoTree;
  in_function=0;
  cur_net_param_num=0;
  is_not_parameter=1;
  point_num=0;
  ListNum=0;
  set_gen_trees();
  cur_block=pRoot;
  creation_section_end=NoTree;
  creation_section_begin=NoTree;
  state_kind=KNOWN;
  blank_is_necessary=0;
  if(pass_number == 1) {
    create_pred_var_tree();
    create_coord_var_tree();
    
    PointerControl(COMPUTING_SPACE_LIST);
    PointerControl(COMPUTING_SPACE);
    COMPUTING_SPACE->MPC_NetOrSubnet.MyList=COMPUTING_SPACE_LIST;
    COMPUTING_SPACE->MPC_NetOrSubnet.pGen=pGlobal;
    COMPUTING_SPACE->MPC_NetOrSubnet.Distribution=HOST;
    PointerControl(HOST_LIST);
    PointerControl(HOST);
    HOST->MPC_NetOrSubnet.MyList=HOST_LIST;
    PointerControl(SINGLE_NODE);
    PointerControl(SINGLE_NODE_LIST);
    SINGLE_NODE->MPC_NetOrSubnet.MyList=SINGLE_NODE_LIST;
  }
  cur_act_net=/*COMPUTING_SPACE_LIST*/SINGLE_NODE_LIST;
  enclosed_net=COMPUTING_SPACE_LIST;
  HOST->MPC_NetOrSubnet.pGen=int_gen_tree;
  ext_gen_tree=int_gen_tree;
  /*  Nets_stack_init();*/

  PointerControl(yyt->MPC_Root.Source);
  if(prt) printf("generation for file %s is started \n",
	 yyt->MPC_Root.Source->MPC_Source.FileName);
  if(pass_number == 1) {
    TraverseTreeTD(yyt,create_MyList);
  }
  file_name=yyt->MPC_Root.Source->MPC_Source.FileName;
  source_file=file_name;
  open_c_file(file_name,&not_dummy);
  if(prt) printf("before first writing to the file\n");
  fprintf(file,"/* This file was generated by mpC compiler\n");
  /*timer=time(NULL);*/
  fprintf(file,"   From file %s*/\n\n",file_name);
  fprintf(file,"\nstatic char* MPC_file_name=%s;\n\n",file_name);

  /*fprintf(file,"\n#ifdef __cplusplus\n");
  fprintf(file,"extern \"C\" {\n");
  fprintf(file,"#endif\n\n");*/
  
  /*fprintf(file,"   From file %s at %s\n\n",
	  file_name,ctime(&timer));
  fprintf(file,"#include <stddef.h>\n\n");*/

  fprintf(file,"#include <mpC.h>\n");
  if(!CBRACKETS) {
    fprintf(file,"#include <topo.h>\n");
    if(macro) fprintf(file,"#include <mpc_macro.h>\n");
  }
  /*fprintf(file,"#include \"addition.h\"\n");*/
  /*fprintf(file,"#include <subnet_create.h>\n");
  fprintf(file,"void* MPC_Realloc();\n");
  fprintf(file,"void* MPC_Subnet_free(MPC_Net* );\n");
  fprintf(file,"#ifndef NULL\n#define NULL (void*)(0)\n#endif\n\n");*/

  pDecls=yyt->MPC_Root.Decls;
  PointerControl(pDecls);
  cur_blank=0;
  cur_pos=cur_blank;
  if(pass_number == 1) {
    TypeRoot=mType(NoTree/*TreeRoot*/,NoType,0,NoType,0,0,0);
    TraverseTreeTD(pDecls,set_type_to_zero);
    {
      /*void ext_fill_be_type_tree(tTree yyt);
      TraverseTreeTD(pDecls,ext_fill_be_type_tree);*/
      TraverseTreeTD(pDecls,fill_be_type_tree);
     /*WriteType(stdout,TypeRoot);*/
      /*find_same_vector(TypeRoot,TypeRoot);*/
      AllTypeTree_traverse(TypeRoot,find_same_pointer);
      AllTypeTree_traverse(TypeRoot,find_same_dyn_type);
     /*WriteType(stdout,TypeRoot);*/
     }
    /*printf("before set_used_atribute\n");*/
    fflush(stdout);
    TraverseTreeTD(pDecls,set_used_atribute);
    /*TraverseTreeTD(pDecls,set_used_dynamic);*/
     AllTypeTree_traverse(TypeRoot,set_used_dynamic);
   }
  TraverseTypeTD(TypeRoot,clear_gen);
  print_basic_type_rts_tree();
  parent_expr=NoTree;
  end_statement_is_needed=1;
  Position=pDecls->MPC_Decls.Pos;
  Decls_print(pDecls);
  /*WriteType(stdout,TypeRoot);*/
  /*fprintf(file,"\n#ifdef __cplusplus\n");
  fprintf(file,"}\n");
  fprintf(file,"#endif\n");*/

  if(strcmp(output,"stdout")) fclose(not_dummy);
  if(prt) printf("file generation is ended \n");
 }

static int is_same_dyn_type(tTree pFType, tTree pSType)
{
  int ret;
  PointerControl(pFType);
  PointerControl(pSType);
  pFType=Strip_Typedef(pFType);
  pSType=Strip_Typedef(pSType);
  PointerControl(pFType);
  PointerControl(pSType);
  
  if(IS_DYN_ARRAY_OR_VECTOR(pFType)) {
    if(IS_DYN_ARRAY_OR_VECTOR(pSType)){
      if(NUMBER_OF_COMPONENTS(pFType)==0) 
        ret=((DYN_SIZE(pFType)==DYN_SIZE(pSType))
             &&is_same_dyn_type(element_type(pFType),element_type(pSType)));
      
      else 
        ret=((NUMBER_OF_COMPONENTS(pFType)==NUMBER_OF_COMPONENTS(pSType))
             &&is_same_dyn_type(element_type(pFType),element_type(pSType)));
      
      if((pFType->Kind==kMPC_ArrayType)&&(pSType->Kind==kMPC_ArrayType)) {
        if(STEP(pFType)==0) {
          if(STEP(pSType)==0) ret=ret&&(DYN_STEP(pSType)==DYN_STEP(pFType));
          else ret=0;
        }
        else ret=ret&&(STEP(pSType)==STEP(pFType));
      }   
    }
    else
      ret=0;
      
  }
  else    {
    if(IS_DYN_ARRAY_OR_VECTOR(pSType))
      ret=0;
    else
      ret=1;
  }
  
  return ret;
}


static int is_same_array_type(tTree pVType, tTree pType)
{
if((pVType->Kind!=kMPC_VectorType)||(pType->Kind!=kMPC_ArrayType))
  {
  /*
  printf("\n---- %d --- %d = %d ",pVType->Kind,pType->Kind,  same_type(pVType,pType));
  */
  return same_type(pVType,pType);
  }
else 
  {
  /*
  printf("\n %d %d \t %p %p\n", pVType->MPC_VectorType.NumberOfComponents,
                         pType->MPC_ArrayType.NumberOfComponents,
                         pVType->MPC_VectorType.VectorSize,
                         pType->MPC_ArrayType.ArraySize);
  print_Expr(pVType->MPC_VectorType.VectorSize);
  printf("\t");
  print_Expr(pType->MPC_ArrayType.ArraySize);
  */
                        
  if(pVType->MPC_VectorType.NumberOfComponents)
    {
    if(pVType->MPC_VectorType.NumberOfComponents==
       pType->MPC_ArrayType.NumberOfComponents)
      return is_same_array_type(pVType->MPC_VectorType.ElementType,
                       pType->MPC_ArrayType.ElementType);
    else 
      return 0;
    }
  else 
    {
    if(pVType->MPC_VectorType.VectorSize==pType->MPC_ArrayType.ArraySize)
      return is_same_array_type(pVType->MPC_VectorType.ElementType,
                       pType->MPC_ArrayType.ElementType);
    else 
      return 0;  
    }
  }
}

static void find_same_vector(tType pVector, tType pArray)
{
tType pNextVector=NoType, pAux , children;
tTree pVectorTree, pArrayTree=NoTree;

/*printf("\n%p %p\t",pVector,pArray);*/
TypeControl(pVector);
TypeControl(pArray);

/*printf("find_same_type : %d %d\n",pVector->Type.Number,pArray->Type.Number);*/

if(pArray!=TypeRoot)
  {
  pArrayTree=pArray->Type.Origin;
  PointerControl(pArrayTree);
  }

if((pArray==TypeRoot)||(pArrayTree->Kind!=kMPC_ArrayType))
  {
   /*printf("Default entry\n");*/
   children=pArray->Type.Children;
   pNextVector=pArray;
   if(children!=NoType) for(pAux=children;pAux!=NoType;pAux=pAux->Types.Next)
     {
     /*printf("#");*/
     find_same_vector(pNextVector,pAux->Types.Type);   
     }   
  }
else
  {
  /*printf("Array entry\n");*/
  children=pVector->Type.Children;

  if(children!=NoType) for(pAux=children;pAux!=NoType;pAux=pAux->Types.Next)
     {
     /*printf("$");*/
     TypeControl(pAux);
     pVectorTree=pAux->Types.Type->Type.Origin;
     PointerControl(pVectorTree);
     if(pVectorTree->Kind==kMPC_VectorType) 
       if(is_same_array_type(pVectorTree,pArrayTree)) 
         {
         /*printf("!");*/
         pArray->Type.VectorType=pAux->Types.Type;
         pNextVector=pAux->Types.Type;
         /*printf("\t%p\t",pNextVector);*/
         break;
         }
     }

  if(pNextVector==NoType) return;

  /*printf("Vector type found\n");*/
  children=pArray->Type.Children;
  if(children!=NoType) for(pAux=children;pAux!=NoType;pAux=pAux->Types.Next)
     {
     /*printf("^");*/
     TypeControl(pAux);
     pArrayTree=pAux->Types.Type->Type.Origin;
     PointerControl(pArrayTree);
     if(pArrayTree->Kind==kMPC_ArrayType) 
       {
       /*printf("!");*/
       find_same_vector(pNextVector,pAux->Types.Type);   
       }
     }   
 
  }
}


static tType find_pointer_on_type(tTree pArrayTree)
{
  tType pAux,p_ret=NoType;
  tTree pPointerTree;
  
  for(pAux=TypeRoot->Type.Children;pAux!=NoType;pAux=pAux->Types.Next) {
    TypeControl(pAux);
    pPointerTree=pAux->Types.Type->Type.Origin;
    PointerControl(pPointerTree);
    if(pPointerTree->Kind==kMPC_PointerType) {
      PointerControl(pPointerTree->MPC_PointerType.ElementType);
      if(same_type(pArrayTree,pPointerTree->MPC_PointerType.ElementType)) {
        p_ret=pAux->Types.Type;
        break;
      }
    }
  }

  return p_ret;
}


static void find_same_pointer(tType pArray)
{
  tTree pArrayTree;
  
  TypeControl(pArray);
  pArrayTree=pArray->Type.Origin;
  if((pArrayTree!=NoTree)&&(pArrayTree->Kind==kMPC_ArrayType)) {
      pArray->Type.PointerType=find_pointer_on_type(pArrayTree);
  }
}

static tType pCurrentArray=NoType;
static tType pCurrentChild=NoType;
static tTree pCurrentArrayTree=NoTree;

static void append_dyn_type(tType pType)
{
  if(pCurrentChild!=NoType) {
    pCurrentChild->Types.Next=mTypes(pType,NoType);
    pCurrentChild=pCurrentChild->Types.Next;
  }
  else {
    pCurrentArray->Type.EquivType=mTypes(pType,NoType);
    pCurrentChild=pCurrentArray->Type.EquivType;
  }
  TypeControl(pCurrentChild);
    
}

static void fill_same_dyn_type(tType pType)
{
  tTree pTree;
  TypeControl(pType);
  if(pType!=pCurrentArray) {
    pTree=pType->Type.Origin;
    if(pTree!=NoTree)   {
      if(is_same_dyn_type(pTree,pCurrentArrayTree)) append_dyn_type(pType);
    }
  }
  
}

static void find_same_dyn_type(tType pArray)
{
  tTree pArrayTree;
  
  TypeControl(pArray);
  pArrayTree=pArray->Type.Origin;
  if((pArrayTree!=NoTree)&&(pArrayTree->Kind==kMPC_ArrayType)&&(is_dynamic_type(pArrayTree))) {
    pCurrentArrayTree=pArrayTree;
    pCurrentArray=pArray;
    pCurrentChild=pArray->Type.EquivType;
    AllTypeTree_traverse(TypeRoot,fill_same_dyn_type);
  }
}


                                  
void print_RTSNodeDeclare(tTree pVar)
{
/*printf("print_RTSNodeDeclare entry");*/
PointerControl(pVar);

while(pVar->Kind != kMPC_FreeNode) 
  {
  tTree pType=pVar->MPC_Var.Type;
  tType p_type;
  /*printf("#");*/
  PointerControl(pType);
  p_type=pType->MPC_Type.pType;
  if(p_type != NoType) print_rts_type_tree(p_type);
  pVar=pVar->MPC_Var.Next;
  PointerControl(pVar);
  }
/*printf("\n");*/

}

void print_RTSNodeInit(tTree pVar)
{
/*printf("print_RTSNodeInit entry");*/
int old_change_net=not_change_net;
PointerControl(pVar);

while(pVar->Kind != kMPC_FreeNode) 
  {
  tTree pType=pVar->MPC_Var.Type;
  tType p_type;
  /*printf("#");*/
  PointerControl(pType);
  p_type=pType->MPC_Type.pType;
  not_change_net=1;
  if(p_type != NoType) print_rts_type_tree_2(p_type);
  not_change_net=old_change_net;
  pVar=pVar->MPC_Var.Next;
  PointerControl(pVar);
  }
/*printf("\n");*/

}

void Decls_print(tTree pDecls) {
  tString new_source;
  if(prt) printf("Decls generation is started \n");
  PointerControl(pDecls);
  while(pDecls->Kind != kMPC_FreeNode) {
    if(!in_function) cur_FileDecls=pDecls;
    Position=pDecls->MPC_Decls.Pos;
    new_source=SourceFile(Position);
    /*if(have_to_generate(pDecls)) print_Decls(pDecls);*/
    if(source_file != new_source) {
      print_header(new_source);
      /*c_blank;
      fprintf(file,"MPC_Source_filename_set(%s);\n",new_source);*/
      source_file=new_source; 
    }
    /*in_type=1;*/
    /*else {*/
    c_blank;
    print_Decls(pDecls);
    switch(pDecls->Kind) {
    case kMPC_Function:
    case kMPC_NetDecl:
    case kMPC_SubnetDecl:
    case kMPC_VarDecl:
      break;
    default:
      if(!Tree_IsType(pDecls,kMPC_Type)) {
        if(end_statement_is_needed) fputs(";\n",file);
      }
    }
    /*}*/
    if(Tree_IsType(pDecls,kMPC_Type)) {
      tType p_type=pDecls->MPC_Type.pType;
      /*TypeControl(p_type);
      TypeTree_traverse(pType,print_rts_type_tree,1);*/
      if(/*!in_function && */p_type != NoType) print_rts_type_tree(p_type);
      if((pDecls->Kind == kMPC_StructType &&
          pDecls->MPC_StructType.MemberDecls == NoTree) ||
         (pDecls->Kind == kMPC_UnionType &&
          pDecls->MPC_UnionType.MemberDecls == NoTree) ||
         (pDecls->Kind == kMPC_EnumType)) {
        fputs(";\n",file);
      }
    }
    else if(pDecls->Kind == kMPC_VarDecl) {
      tTree pVar=pDecls->MPC_VarDecl.Var;
      PointerControl(pVar);
      print_RTSNodeDeclare(pVar);
    }
    pDecls=pDecls->MPC_Decls.Next;
    PointerControl(pDecls);
  }
  if(prt) printf("Decls generation is ended \n");
}

static int have_dyn_t;

void check_dyn_t_var(tTree pVar)
{
tTree pType;
PointerControl(pVar);
pType=pVar->MPC_Var.Type;
PointerControl(pType);
if(is_dynamic_type(pType))
  {
  have_dyn_t=1;
  }          
}


static tTree pCompound4Alloc;


void print_VarAlloc(tTree pVar)
{
  tTree pType,pDistribution,pMyNet;
  int braces,i;
  int old_not_check;
  
  pType=pVar->MPC_Var.Type;
  PointerControl(pType);
  if(is_dynamic_type(pType)==DYNAMIC_ARRAY){
    pDistribution=pVar->MPC_Var.Distribution;
    PointerControl(pDistribution);
    pMyNet=pDistribution->MPC_NetOrSubnet.MyList;
    PointerControl(pMyNet);
    
    /*prt=1;
    PrintNet(pDistribution,"net");
    PrintNetList(pMyNet,0,"var");
    PrintNetList(cur_act_net,0,"current");
    prt=0;*/
    
    braces=check_enclosed_net(pMyNet,cur_act_net);
    old_not_check=not_check;
    not_check=1;
    c_blank;
    fprintf(file,"if(!(*%s = ", AuxPointerName(pVar,pCompound4Alloc));
    fprintf(file,"(void*)malloc(%s.Base.Size)))",DataVarName(pType));
    fprintf(file,"%s(\"\\\"%s\\\" array allocation failed.\\n\"),%s(1);\n", CBRACKETS ? "printf":"MPC_Printf",
              VarName(pVar), CBRACKETS ? "exit":"MPC_Exit");
    if(braces) {
      for(i=0;i<braces;i++) {
        b_end;
      }
    }
    not_check=old_not_check;
  }
}

void Decls_alloc(tTree pCompound) {
  tTree pDecls;
  if(prt) printf("Decls allocation generation is started \n");
  PointerControl(pCompound);
  pDecls=pCompound->MPC_Compound.Decls;
  PointerControl(pDecls);
  if(pDecls==NoTree) return;
  have_dyn_t=0;
  while(pDecls->Kind != kMPC_FreeNode) {
     
   if(pDecls->Kind == kMPC_VarDecl) {
     VarDecl_traverse(pDecls,check_dyn_t_var);
   }
   pDecls=pDecls->MPC_Decls.Next;
   PointerControl(pDecls);
  }
  if(have_dyn_t)
    {
    c_blank;
    fprintf(file,"if(!%s%d){\n",ALLOC_FLAG, pCompound->MPC_Compound.UniqueNumber);
    cur_blank+=SKIP;
    pDecls=pCompound->MPC_Compound.Decls;
    while(pDecls->Kind != kMPC_FreeNode) {
     
     if(pDecls->Kind == kMPC_VarDecl) {
       pCompound4Alloc=pCompound;
       VarDecl_traverse(pDecls,print_VarAlloc);
     }
     pDecls=pDecls->MPC_Decls.Next;
     PointerControl(pDecls);
    }
    c_blank;
    fprintf(file,"%s%d=1;\n",ALLOC_FLAG, pCompound->MPC_Compound.UniqueNumber);
    b_end;
    }
  if(prt) printf("Decls allocation generation is ended \n");
}


static tTree pCompound4Free;

void print_VarFree(tTree pVar)
{
  tTree pType,pDistribution,pMyNet;
  int braces,i;
  int old_not_check;
  
  pType=pVar->MPC_Var.Type;
  PointerControl(pType);
  
  if(is_dynamic_type(pType)==DYNAMIC_ARRAY){
    pDistribution=pVar->MPC_Var.Distribution;
    PointerControl(pDistribution);
    pMyNet=pDistribution->MPC_NetOrSubnet.MyList;
    PointerControl(pMyNet);
    braces=check_enclosed_net(pMyNet,cur_act_net);
    old_not_check=not_check;
    not_check=1;
    c_blank;
    fprintf(file,"free"); 
    fprintf(file,"( ");
    fprintf(file,"*%s",AuxPointerName(pVar,pCompound4Free));
    fprintf(file,");\n ");
    if(braces) {
      for(i=0;i<braces;i++) {
        b_end;
      }
    }
    not_check=old_not_check;
  }
}



void Decls_free(tTree pCompound) {
  tTree pDecls;
  if(prt) printf("Decls allocation generation is started \n");
  PointerControl(pCompound);
 
  pDecls=pCompound->MPC_Compound.Decls;
  if(pDecls==NoTree) return;

  have_dyn_t=0;
  while(pDecls->Kind != kMPC_FreeNode) {
     
   if(pDecls->Kind == kMPC_VarDecl) {
     VarDecl_traverse(pDecls,check_dyn_t_var);
   }
   pDecls=pDecls->MPC_Decls.Next;
   PointerControl(pDecls);
  }
  if(have_dyn_t){
    pDecls=pCompound->MPC_Compound.Decls;
    c_blank;
    fprintf(file,"if(%s%d){\n",ALLOC_FLAG, pCompound->MPC_Compound.UniqueNumber);
     cur_blank+=SKIP;
     while(pDecls->Kind != kMPC_FreeNode) {
     if(pDecls->Kind == kMPC_VarDecl) {
     pCompound4Free=pCompound;
     VarDecl_traverse(pDecls,print_VarFree);
     }
    pDecls=pDecls->MPC_Decls.Next;
    PointerControl(pDecls);
    }
    c_blank;
    fprintf(file,"%s%d=0;\n",ALLOC_FLAG, pCompound->MPC_Compound.UniqueNumber);
    b_end;
   }

  if(prt) printf("Decls allocation generation is ended \n");
}

int is_loop_or_switch(tTree yyt)
{
return 
  ((yyt->Kind==kMPC_While)||
   (yyt->Kind==kMPC_DoWhile)||
   (yyt->Kind==kMPC_ParScheme)||
   (yyt->Kind==kMPC_For)||
   (yyt->Kind==kMPC_Switch));
}  


void Break_free(tTree pBreak )
{
tTree yyt;
 
  PointerControl(pBreak);
 
  yyt=pBreak;
  while(1)
   {
   PointerControl(yyt);
   if(is_loop_or_switch(yyt)) 
     {
     break;
     }
   else if(yyt->Kind==kMPC_Compound)
    {
    Decls_free(yyt);
    yyt=get_parent_stat(yyt);
    }
   else yyt=get_parent_stat(yyt);
  } 
}

void Return_free(tTree pReturn )
{
tTree yyt;
 
  PointerControl(pReturn);
 
  yyt=pReturn;
  while(1)
   {
   PointerControl(yyt);
   if(yyt->Kind==kMPC_Compound)
    {
    Decls_free(yyt);
    if(yyt->MPC_Compound.FunctionBody) break;
    yyt=get_parent_stat(yyt);
    }
   else yyt=get_parent_stat(yyt);
  } 
}

static int label_found;
static int curr_label;

void check_label(tTree yyt)
{
if(yyt->Kind==kMPC_IdentLabel) 
  if(yyt->MPC_IdentLabel.Ident==curr_label) label_found=1;
}

void Goto_free(tTree pGoto)
{
tTree yyt;
 
PointerControl(pGoto);
yyt=pGoto;

while(1)
   {
   PointerControl(yyt);
   if(yyt->Kind==kMPC_Compound)
    {    
    if(yyt->MPC_Compound.FunctionBody) break;
    else 
      {
      tTree pStats;
      label_found=0;
      curr_label=pGoto->MPC_Goto.Ident;
      PointerControl(yyt->MPC_Compound.Stats);
      pStats=yyt->MPC_Compound.Stats;
      Stat_traverse(pStats,check_label);
      if(label_found) break;
      else Decls_free(yyt);
      yyt=get_parent_stat(yyt);
      } 
     }
   else yyt=get_parent_stat(yyt);
   } 
  
}


void Label_alloc(tTree pLabel)
{
tTree yyt;
 
PointerControl(pLabel);
yyt=pLabel;

  while(1)
   {
   PointerControl(yyt);
   if(yyt->Kind==kMPC_Compound)
    {
    if(yyt->MPC_Compound.FunctionBody) break;
    Decls_alloc(yyt);
    yyt=get_parent_stat(yyt);
    }
   else yyt=get_parent_stat(yyt);
  } 
}


  



void RTS_init_print(tTree pDecls) {
  tString new_source;
  if(prt) printf("RTS init generation is started \n");
  PointerControl(pDecls);
  while(pDecls->Kind != kMPC_FreeNode) {
    if(!in_function) cur_FileDecls=pDecls;
    Position=pDecls->MPC_Decls.Pos;
    new_source=SourceFile(Position);
    switch(pDecls->Kind) {
    case kMPC_Function:
    case kMPC_NetDecl:
    case kMPC_SubnetDecl:
    case kMPC_VarDecl:
      break;
    default:;
    }
    
    if(Tree_IsType(pDecls,kMPC_Type)) {
      tType p_type=pDecls->MPC_Type.pType;
      if(p_type != NoType) print_rts_type_tree_2(p_type);
    }
    else if(pDecls->Kind == kMPC_VarDecl) {
      tTree pVar=pDecls->MPC_VarDecl.Var;
      PointerControl(pVar);
      print_RTSNodeInit(pVar);

   }
    pDecls=pDecls->MPC_Decls.Next;
    PointerControl(pDecls);
  }
  if(prt) printf("RTS pass 2   generation is ended \n");
}

 
 

void check_dyn_t(tTree pDecls)
{
   if(pDecls->Kind == kMPC_VarDecl) {
     VarDecl_traverse(pDecls,check_dyn_t_var);   
   }
 
}

void print_Alloc_Flags(tTree yyt)
{

if(yyt->Kind==kMPC_Compound)
  {
  have_dyn_t=0;
  StateDecls_traverse(yyt,check_dyn_t);
  if(have_dyn_t) 
    {
    c_blank;
    fprintf(file,"int %s%d=0;\n",ALLOC_FLAG,yyt->MPC_Compound.UniqueNumber);
    }
  }

}

static void set_gen_to_0(tType yyt) {
  if(yyt != NoType && yyt->Kind == kType && yyt->Type.Gen == 1)
    yyt->Type.Gen=0;
}

static void clear_gen(tType yyt) {
  if(yyt != NoType && yyt->Kind == kType)
    yyt->Type.Gen=0;
}

void print_rts_type(tTree pType, int num) {
  int old_print_base_type=print_base_type;
  tType p_type;
  PointerControl(pType);
  p_type=pType->MPC_Type.pType;
  if(p_type != NoType) {
    if(num == 1) TraverseTypeTD(TypeRoot,set_gen_to_0);
    print_base_type=1;
    print_rts_type_tree(p_type);
    print_base_type=old_print_base_type;
  }
  else {
    fprintf(stderr,"not filled back_end type tree for type %s\n",
            TypeName(pType));
    internal_error();
  }
}

void print_Decls(tTree pDecls){
  int old_print_base_type;
  old_print_base_type=print_base_type;
  PointerControl(pDecls);
  if(Tree_IsType(pDecls,kMPC_Type)) {
    Position=pDecls->MPC_Decls.Pos;
    print_Type(pDecls);
    /*if(is_not_parameter) {
      print_rts_type(pDecls);
    }*/
  }
  else {
    switch(pDecls->Kind) {
    case kMPC_VarDecl:
      print_base_type=0;
      print_VarDecl(pDecls);
      if(is_not_parameter) {
        fputs(";\n",file);
        end_statement_is_needed=0;
      }
      /*{
        tTree pVar,pType;
        pVar=pDecls->MPC_VarDecl.Var;
        PointerControl(pVar);
        print_base_type=1;
        while(pVar->Kind != kMPC_FreeNode) {
          pType=pVar->MPC_Var.Type;
          PointerControl(pType);
          if(is_not_parameter) print_rts_type(pType);
          pVar=pVar->MPC_Var.Next;
          PointerControl(pVar);
        }
      }*/
      break;
    case kMPC_Function:
      print_base_type=1;
      print_Function(pDecls);
      break; 
    case kMPC_Ellipsis:
      cur_pos+=fputs("...",file);
      break; 
    case kMPC_NetType:
      print_NetType(pDecls);
      break;
    case kMPC_NetDecl:
      if(!in_function) print_NetDecl(pDecls);
      break;
    case kMPC_SubnetDecl:
      if(!in_function) print_SubnetDecl(pDecls);
      break;
    default:
      break;
    }
  }
  print_base_type=old_print_base_type;
}

static void set_gen_trees() {
  tGen pSingle;
  int_gen_tree=mNet(CONST,KNOWN,1,0,0,HOST,1,0,0,pRoot,0,
		    make_string("host"),NoGen,NoGen,0,
                    PREDEFINE_NUM,NoTree,0);
  pSingle=mNet(CONST,KNOWN,1,0,0,SINGLE_NODE,1,0,0,pRoot,0,
               make_string("single"),NoGen,int_gen_tree,0,
               PREDEFINE_NUM,NoTree,0);
  SINGLE_NODE->MPC_Net.pGen=pSingle;
  pGlobal=mNet(CONST,KNOWN,1,0,0,COMPUTING_SPACE,1,0,0,pRoot,0,
               make_string("global"),NoGen,int_gen_tree,0,
               PREDEFINE_NUM,NoTree,0);
  int_gen_tree->Net.Children=mNets(pSingle,mNets(pGlobal,NoGen));;
  if(prt) printf("int_gen_tree=%p pSingle=%p pGlobal=%p pGlobal->Parent=%p\n",
         int_gen_tree,pSingle,pGlobal,pGlobal->Net.Parent);
}

static void create_pred_var_tree() {
  tmp_var_expr=nMPC_BinaryExpr();
  tmp_var_expr->MPC_BinaryExpr.TmpName="";
  tmp_var_expr_left=nMPC_Expr();
  tmp_var_expr->MPC_BinaryExpr.OpCode=ASSIGN;
  tmp_var_expr->MPC_BinaryExpr.Loperand=tmp_var_expr_left;
  tmp_var_expr_left->MPC_Expr.Flag.Generated=1;
}

static void create_coord_var_tree() {
  tmp_coord_expr=nMPC_BinaryExpr();
  tmp_coord_expr->MPC_BinaryExpr.TmpName="";
  tmp_coord_expr_left=nMPC_Expr();
  tmp_coord_expr->MPC_BinaryExpr.OpCode=ASSIGN;
  tmp_coord_expr->MPC_BinaryExpr.Loperand=tmp_coord_expr_left;
  tmp_coord_expr_left->MPC_Expr.Flag.Generated=1;
  tmp_coord_expr_left->MPC_Expr.TmpName="MPC_coord[                    ";
  /*malloc(sizeof(char)*256);*/
}

/*#define INCLUDED_NUM 3
static int have_to_generate(tTree pDecls) {
  char* included_by_rts[INCLUDED_NUM]=
  {"stdlib.h","limits.h","mpi.h"};
  int i;
  tString source_file;
  PointerControl(pDecls);
  source_file=SourceFile(pDecls->MPC_Decls.Pos);
  for(i=0; i<INCLUDED_NUM; i++) {
    if(strstr(source_file,included_by_rts[i]) != NULL) break;
  }
  return i == INCLUDED_NUM;
}*/

static tString cur_header=" ";
static void print_header(tString source_file) {
  if(strcmp(source_file,cur_header)) {
    cur_header=source_file;
    c_blank;
    fprintf(file,"\n/*%s*/\n",source_file);
  }
}

static void set_type_to_zero(tTree yyt) {
  if(yyt != NoTree && Tree_IsType(yyt,kMPC_Type)) {
    yyt->MPC_Type.pType=NoType;
  }
  /* begin of the debuging insertion */
  /*if(yyt != NoTree && Tree_IsType(yyt,kMPC_Stat)) {
    if(prt) printf("set_type_to_zero yyt=%p yyt->Kind=%d ExecNet=%p\n",yyt,
                   yyt->Kind,yyt->MPC_Stat.ExecNet);
  }*/
  
}

static void print_basic_type_rts_tree() {
  tType pChildren;
  TypeControl(TypeRoot);
  pChildren=TypeRoot->Type.Children;
  while(pChildren != NoType) {
    tTree pOrigin;
    tType pChild=pChildren->Types.Type;
    TypeControl(pChild);
    pOrigin=pChild->Type.Origin;
    PointerControl(pOrigin);
    if(pOrigin->Kind == kMPC_BasicType) {
      TypeTree_traverse(pChild,print_rts_type_tree,1);
    }
    pChildren=pChildren->Types.Next;
  }
}


tTree get_true_type(tTree yyt)
{/*
  tTree r_tree;
  tType p_type=yyt->MPC_Type.pType;
  if(p_type==NoType) return NoTree;
  r_tree=p_type->Type.Origin;
  PointerControl(r_tree);
  return r_tree;
  */
  return Strip_Typedef(yyt);
}

int is_dynamic_step(tTree yyt) {

  PointerControl(yyt);
  /*if(yyt->Kind==kMPC_Typedef) yyt=get_true_type(yyt);*/
  yyt=Strip_Typedef(yyt);
  if(yyt==NoTree) return STATIC_STEP;
if(yyt->MPC_Type.Flag.DynStep)
    return DYNAMIC_STEP;
else return STATIC_STEP;
} 

int is_dynamic_size(tTree yyt) {

  PointerControl(yyt);
  /*if(yyt->Kind==kMPC_Typedef) yyt=get_true_type(yyt);*/
  yyt=Strip_Typedef(yyt);
  if(yyt==NoTree) return STATIC_SIZE;
  if(Tree_IsType(yyt,kMPC_DerivedType)&&(yyt->MPC_DerivedType.NumberOfComponents==0)) 
   return DYNAMIC_SIZE;
if(yyt->MPC_Type.Flag.DynArray)
    return DYNAMIC_SIZE;
else return STATIC_SIZE;
} 

int is_pointer_on_dynamic(tTree yyt)
{
PointerControl(yyt);
/*if(yyt->Kind==kMPC_Typedef) yyt=get_true_type*/
yyt=Strip_Typedef(yyt);
if(yyt==NoTree) return 0;
if((yyt->Kind==kMPC_PointerType)&&
   (is_dynamic_type(yyt->MPC_PointerType.ElementType)==DYNAMIC_ARRAY))
     
  return 1;
else return 0;
}

int is_dynamic_pointer(tTree yyt)
{
  PointerControl(yyt);
  /*  if(yyt->Kind==kMPC_Typedef) yyt=get_true_type(yyt);*/
  yyt=Strip_Typedef(yyt);
  if(yyt==NoTree) return 0;
  if((yyt->Kind==kMPC_PointerType)&&
     (yyt->MPC_PointerType.Step==0))
    return 1;
  else return 0;
}



int is_dynamic_type(tTree yyt) {

  PointerControl(yyt);
  /*if(yyt->Kind==kMPC_Typedef) yyt=get_true_type(yyt);*/
  yyt=Strip_Typedef(yyt);
  if(yyt==NoTree) return NOT_DYNAMIC_TYPE;
  

if(yyt->Kind==kMPC_ArrayType)
  {
  if(yyt->MPC_ArrayType.NumberOfComponents==0) return DYNAMIC_ARRAY;
  if(yyt->MPC_Type.Flag.DynArray||yyt->MPC_Type.Flag.DynStep)
    return DYNAMIC_ARRAY;
  else 
    return NOT_DYNAMIC_TYPE;
  }

else if(yyt->Kind==kMPC_VectorType)
  {
  if(yyt->MPC_VectorType.NumberOfComponents==0) return DYNAMIC_VECTOR;

  if(yyt->MPC_Type.Flag.DynArray||yyt->MPC_Type.Flag.DynStep)
    return DYNAMIC_VECTOR;
  else 
    return NOT_DYNAMIC_TYPE;
  }
else if(yyt->Kind==kMPC_PointerType) 
    {
    if(is_dynamic_pointer(yyt)||is_pointer_on_dynamic(yyt))
      return DYNAMIC_POINTER;
    else 
      return NOT_DYNAMIC_TYPE;
    }
else
  return NOT_DYNAMIC_TYPE;
}


/*
static void set_used_dynamic(tTree yyt) {

tType p_type;

if(is_dynamic_type(yyt))
  {
  p_type=yyt->MPC_Type.pType;
  TypeControl(p_type);
  p_type->Type.Used=1;
  set_parent_used(p_type);
  }
 
}
*/

static void set_used_dynamic(tType pType) {
tTree yyt;
/*printf("set_used_dynamic entry");*/
TypeControl(pType);
yyt=pType->Type.Origin;

if((yyt!=NoTree) && is_dynamic_type(yyt))
  {
  pType->Type.Used=1;
  set_parent_used(pType);
  }
 
}


static void set_used_atribute(tTree yyt) {
  if(yyt != NoTree) {
    tTree pLType,pRType,pType;
    tType p_type=NoType;
    if(yyt->Kind == kMPC_BinaryExpr) {
      int OpCode=yyt->MPC_BinaryExpr.OpCode;
      int kind;
      if(OpCode == ASSIGN) {
        kind=PredAssign_kind(yyt,&pLType,&pRType);
        if(kind != WRONG && kind != ASYNCH &&
           pLType != NoTree && pRType != NoTree) {
          if(prt) printf(" set Type.Used=1\n");
          p_type=pLType->MPC_Type.pType;
          TypeControl(p_type);
          p_type->Type.Used=1;
          set_parent_used(p_type);
          p_type=pRType->MPC_Type.pType;
          TypeControl(p_type);
          p_type->Type.Used=1;
          set_parent_used(p_type);
        }
      }
    }
    else if(yyt->Kind == kMPC_UnaryExpr &&
            yyt->MPC_UnaryExpr.OpCode >= DISTRIBUTED) {
      tTree pOperand=yyt->MPC_UnaryExpr.Operand;
      tTree pType;
      tType p_type;
      PointerControl(pOperand);
      pType=pOperand->MPC_Expr.Type;
      PointerControl(pType);
      p_type=pType->MPC_Type.pType;
      TypeControl(p_type);
      p_type->Type.Used=1;
      set_parent_used(p_type);
    }
    else if(yyt->Kind == kMPC_CallExpr) {
      built_in_fun=is_built_in_fun(yyt);
      if(built_in_fun && with_type[built_in_fun-1]) {
        tTree pArg=yyt->MPC_CallExpr.ArgList;
        PointerControl(pArg);
        pType=buffer_type(pArg);
        p_type=pType->MPC_Type.pType;
      }
      if(p_type != NoType) {
        p_type->Type.Used=1;
        set_parent_used(p_type);
      }
    }
  }
}

/*int print_be_type_root() {
  tType pChildren;
  TypeControl(TypeRoot);
  pChildren=TypeRoot->Type.Children;
  while(pChildren != NoType) {
    tTree pOrigin;
    tType pChild=pChildren->Types.Type;
    TypeControl(pChild);
    pOrigin=pChild->Type.Origin;
    PointerControl(pOrigin);
    printf("be_type_root Child=%p pOrigin=%p Kind=%d name=%s",
           pChild,pOrigin,pOrigin->Kind,DataVarName(pOrigin));
    if(pOrigin->Kind == kMPC_BasicType) {
      printf(" Constr=%d",pOrigin->MPC_BasicType.TypeConstructor);
    }
    printf("\n");
    pChildren=pChildren->Types.Next;
  }
}*/
