/*
 * $Id: ConvertType.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


/* converts Tree types to rts ones */
/* Coded by A.Kalinov 2.96 ... */

#include "be_print.h"

static void print_MemberList(tTree pMemberList, tTree yyt);
static void print_Type_in_rts(tTree yyt);
static int set_memcopy(tTree );
static tTree Not_Array_Type(tTree );
static tTree First_Static_Type(tTree );
static int type_num=0;

static int same_list(tTree pOrigin, tTree yyt) {
  int ret;
  PointerControl(pOrigin);
  PointerControl(yyt);
  if(prt) printf("  same_list pOrigin=%p yyt=%p\n",pOrigin,yyt);
  if(pOrigin->Kind != yyt->Kind) return 0;
  while(pOrigin->Kind != kMPC_FreeNode) {
    if(yyt->Kind == kMPC_FreeNode) {
      break;
    }
    else {
      tTree pOriginMember,yytMember;
      pOriginMember=pOrigin->MPC_SU_MemberDecl.Member;
      PointerControl(pOriginMember);
      yytMember=yyt->MPC_SU_MemberDecl.Member;
      PointerControl(yytMember);
      while(pOriginMember->Kind != kMPC_FreeNode &&
            yytMember->Kind != kMPC_FreeNode) {
        tTree pOriginType,yytType;
        /*printf("    pOrigin=%p pOrigin->Kind=%d yytMember=%p\n",
               pOrigin,pOrigin->Kind,yytMember);
        fflush(stdout);*/
        pOriginType=pOriginMember->MPC_SU_Member.Type;
        PointerControl(pOriginType);
        yytType=yytMember->MPC_SU_Member.Type;
        PointerControl(yytType);
        ret=same_type(pOriginType,yytType);
        if(ret == 0) return 0;
        else {
          tTree pOriginBit=pOriginMember->MPC_SU_Member.BitFieldSize;
          tTree yytBit=yytMember->MPC_SU_Member.BitFieldSize;
          if(pOriginBit != NoTree && pOriginBit != yytBit) {
            return 0;
          }
        }
        pOriginMember=pOriginMember->MPC_SU_Member.Next;
        PointerControl(pOriginMember);
        yytMember=yytMember->MPC_SU_Member.Next;
        PointerControl(yytMember);
      }
    } 
    pOrigin=pOrigin->MPC_SU_MemberDecl.Next;
    yyt=yyt->MPC_SU_MemberDecl.Next;
    PointerControl(pOrigin);
    PointerControl(yyt);
  }
  if((pOrigin->Kind != kMPC_FreeNode && yyt->Kind == kMPC_FreeNode) ||
     (pOrigin->Kind == kMPC_FreeNode && yyt->Kind != kMPC_FreeNode))
    ret=0;
  else
    ret=1;
  return ret;
}

int same_type(tTree pOrigin, tTree yyt) {
  int ret=0;
  tTree pEquivType;
  PointerControl(pOrigin);
  PointerControl(yyt);
  pEquivType=pOrigin->MPC_Type.EquivType;
  if(prt) {
    printf("  same_type pOrigin=%p pOrigin->Kind=%d yyt=%p yyt->Kind=%d\n",
           pOrigin,pOrigin->Kind,yyt,yyt->Kind);
    fflush(stdout);
  }    
  while(pEquivType != pOrigin ) {
    /*printf("same type equivalent checking pEquivType=%p\n",pEquivType);*/
    if(pEquivType == yyt) {
      ret=1;
      break;
    }
    if(pEquivType == NoTree) {
      ret=0;
      break;
    }
    pEquivType=pEquivType->MPC_Type.EquivType;
  }
  /*printf("same type after equivalent checking pEquivType=%p ret=%d\n",
         pEquivType,ret);*/
  /*if(yyt->Kind==kMPC_Typedef) {
    yyt=yyt->MPC_Typedef.Type;
    PointerControl(yyt);
  }*/
  
  if(ret != 1) {
    switch(pOrigin->Kind) {
    case kMPC_BasicType:
      ret=((yyt->Kind == kMPC_BasicType &&
           yyt->MPC_BasicType.TypeConstructor ==
            pOrigin->MPC_BasicType.TypeConstructor) ||
           (yyt->Kind == kMPC_EnumType &&
            pOrigin->MPC_BasicType.TypeConstructor == INT));
      break;
    case kMPC_EnumType:
      ret=( yyt->Kind == kMPC_EnumType);
      break;
    case kMPC_Typedef:
      {
        tTree pParent=pOrigin->MPC_Typedef.Type;
        PointerControl(pParent);
        ret=same_type(pParent,yyt);
      }
      break;
    case kMPC_ArrayType:
      if(is_dynamic_type(yyt) && carefull_compare) /*ret=(yyt->Kind == kMPC_ArrayType && 
           same_type(yyt->MPC_ArrayType.ElementType,
                     pOrigin->MPC_ArrayType.ElementType) &&
           yyt->MPC_ArrayType.DynStep ==
           pOrigin->MPC_ArrayType.DynStep &&
           yyt->MPC_ArrayType.ArraySize ==
           pOrigin->MPC_ArrayType.ArraySize);        */
        ret=(yyt==pOrigin);
   
      else ret=(yyt->Kind == kMPC_ArrayType &&
           same_type(yyt->MPC_ArrayType.ElementType,
                     pOrigin->MPC_ArrayType.ElementType) &&
           yyt->MPC_ArrayType.Step ==
           pOrigin->MPC_ArrayType.Step &&
           yyt->MPC_ArrayType.NumberOfComponents ==
           pOrigin->MPC_ArrayType.NumberOfComponents);         
      break;
           
    case kMPC_VectorType:
      if(is_dynamic_type(yyt)&& carefull_compare)
        ret=(pOrigin==yyt);
        /*
        ret=((yyt->Kind == kMPC_VectorType) &&
            same_type(yyt->MPC_VectorType.ElementType,
                     pOrigin->MPC_VectorType.ElementType) &&
           (yyt->MPC_VectorType.VectorSize ==
           pOrigin->MPC_VectorType.VectorSize));
           */
      else ret=(yyt->Kind == kMPC_VectorType &&
           same_type(yyt->MPC_VectorType.ElementType,
                     pOrigin->MPC_VectorType.ElementType) &&
           yyt->MPC_VectorType.NumberOfComponents ==
           pOrigin->MPC_VectorType.NumberOfComponents);         
      break;
    case kMPC_PointerType:
      /*
       if(yyt->Kind==kMPC_PointerType)
         if((is_dynamic_type(pOrigin->MPC_PointerType.ElementType)||
            is_dynamic_type(yyt->MPC_PointerType.ElementType))&& carefull_compare)
           ret=same_type(pOrigin->MPC_PointerType.ElementType,yyt->MPC_PointerType.ElementType);
         else ret=(yyt->Kind == kMPC_PointerType);  
         else ret=0;
         */
      if(yyt->Kind==kMPC_PointerType) {
        if(is_dynamic_pointer(pOrigin)) {
          if(is_dynamic_pointer(yyt))
            ret=(DYN_STEP(pOrigin)==DYN_STEP(yyt));
          else ret=0;
        }
        else {
          if(is_dynamic_pointer(yyt))
            ret=0;
          else
            ret=(STEP(pOrigin)==STEP(yyt));
        }
        
        if(is_pointer_on_dynamic(pOrigin))
          ret=ret&&same_type(element_type(pOrigin),element_type(yyt));
        else {
          if(is_pointer_on_dynamic(yyt)) ret=0;
        }
          if(!carefull_compare) ret=1;
      }
      else ret=0;
      break;
    case kMPC_StructType:
      if(yyt->Kind == kMPC_StructType) {
        tTree pOriginList=pOrigin->MPC_StructType.MemberDecls;
        tTree yytList=yyt->MPC_StructType.MemberDecls;
        if(yytList == NoTree) {
          tTree pEqType=yyt->MPC_StructType.EquivType;
          tTree pEqTypeList;
          while(pEqType != yyt) {
            /*printf("yytList == NoTree pEqType=%p\n",pEqType);*/
            if(pEqType ==NoTree) break;
            pEqTypeList=pEqType->MPC_StructType.MemberDecls;
            if(pEqTypeList != NoTree) {
              yytList=pEqTypeList;
              break;
            }
            pEqType=pEqType->MPC_StructType.EquivType;
          }
        }
        if(pOriginList == NoTree) {
          tTree pEqType=pOrigin->MPC_StructType.EquivType;
          tTree pEqTypeList;
          while(pEqType != pOrigin) {
            /*printf("pOriginList == NoTree pEqType=%p\n",pEqType);*/
            if(pEqType ==NoTree) break;
            pEqTypeList=pEqType->MPC_StructType.MemberDecls;
            if(pEqTypeList != NoTree) {
              pOriginList=pEqTypeList;
              break;
            }
            pEqType=pEqType->MPC_StructType.EquivType;
          }
        }
        ret = (pOriginList != NoTree) && (yytList != NoTree) &&
          same_list(pOriginList,yytList);
      }
      else {
        ret=0;
      }
      break;
    case kMPC_UnionType:
      if(yyt->Kind == kMPC_UnionType) {
        tTree pOriginList=pOrigin->MPC_UnionType.MemberDecls;
        tTree yytList=yyt->MPC_UnionType.MemberDecls;
        if(yytList == NoTree) {
          tTree pEqType=yyt->MPC_UnionType.EquivType;
          tTree pEqTypeList;
          while(pEqType != yyt) {
            /*printf("yytList == NoTree pEqType=%p\n",pEqType);*/
            if(pEqType ==NoTree) break;
            pEqTypeList=pEqType->MPC_UnionType.MemberDecls;
            if(pEqTypeList != NoTree) {
              yytList=pEqTypeList;
              break;
            }
            pEqType=pEqType->MPC_UnionType.EquivType;
          }
        }
        if(pOriginList == NoTree) {
          tTree pEqType=pOrigin->MPC_UnionType.EquivType;
          tTree pEqTypeList;
          while(pEqType != pOrigin) {
            /*printf("pOriginList == NoTree pEqType=%p\n",pEqType);*/
            if(pEqType ==NoTree) break;
            pEqTypeList=pEqType->MPC_UnionType.MemberDecls;
            if(pEqTypeList != NoTree) {
              pOriginList=pEqTypeList;
              break;
            }
            pEqType=pEqType->MPC_UnionType.EquivType;
          }
        }
        ret = (pOriginList != NoTree) && (yytList != NoTree) &&
          same_list(pOriginList,yytList);
      }
      else {
        ret=0;
      }
      break;
    case kMPC_FunctionType:
      {
        tTree pResultType=pOrigin->MPC_FunctionType.ResultType;
        PointerControl(pResultType);
        ret=(yyt->Kind == kMPC_FunctionType/* &&
                                              same_type(pResultType,yyt)*/);
      }
      break;
    default:
      fprintf(stderr,"Wrong Kind of the internal tree node\n");
      internal_error();
      break;
    }
  }
  if(prt) printf(" ret=%d\n",ret);
  return ret;
}

static tType new_type(tType pType, tTree yyt) {
  tType pNewType,pTypes;
  PointerControl(yyt);
  TypeControl(pType);
  if(prt) {
    printf("new_type pType=%p yyt=%p\n",pType,yyt);
    fflush(stdout);
  }
  pTypes=pType->Type.Children;
  while(pTypes != NoType) {
    tTree pOrigin;
    int the_same;
    pNewType=pTypes->Types.Type;
    TypeControl(pNewType);
    pOrigin=pNewType->Type.Origin;
    PointerControl(pOrigin);
    /*printf("new_type before same_type pOrigin=%p\n",pOrigin);
    fflush(stdout);*/
    the_same=same_type(pOrigin,yyt);
    /*if(same_type(pOrigin,yyt)) return pNewType;*/
    /*printf("new_type after same_type the_same=%d\n",the_same);
    fflush(stdout);*/
    if(the_same) return pNewType;
    /*printf("new_type after same_type\n");
    fflush(stdout);*/
    pTypes=pTypes->Types.Next;
    /*printf("pTypes=%p\n",pTypes);*/
  }
  /*printf("new_type before mType\n");
    fflush(stdout);*/
  pNewType=mType(yyt,pType,++type_num,NoType,0,0,set_memcopy(yyt));
  pTypes=mTypes(pNewType,pType->Type.Children);
  pType->Type.Children=pTypes;
  if(prt) printf("new_type pType=%p yyt=%p Kind=%d type_num=%d pNewType=%p\n",
         pType,yyt,yyt->Kind,type_num+1,pNewType);
  return pNewType;
}

tTree pPsevdoVoid=NoTree;
tTree before_equive=NoTree;

static void fill_eq_type(tTree yyt, tTree pMemberList, tTree pEquivType) {
  if(pMemberList == NoTree) {
    if(pEquivType != NoTree) {
      while(pEquivType != NoTree) {
        if(prt) printf("                                     pEquivType=%p\n",pEquivType);
      pEquivType= (pEquivType->Kind == kMPC_UnionType) ?
          pEquivType->MPC_UnionType.EquivType :
          pEquivType->MPC_StructType.EquivType;
        pMemberList= (pEquivType->Kind == kMPC_UnionType) ?
          pEquivType->MPC_UnionType.MemberDecls :
          pEquivType->MPC_StructType.MemberDecls;
        if(pEquivType != NoTree) {
          if(pEquivType == yyt) return;
          if(pMemberList != NoTree) {
            fill_be_type_tree(pEquivType);
            break;
          }
        }
      }
    }
    if(pEquivType != NoTree && pMemberList != NoTree) {
      yyt->MPC_Type.pType=pEquivType->MPC_Type.pType;
    }
    return;
  }
  else {
    while(pMemberList->Kind != kMPC_FreeNode) {
      tTree pMember=pMemberList->MPC_SU_MemberDecl.Member;
      PointerControl(pMember);
      while(pMember->Kind != kMPC_FreeNode) {
        tTree pMemberType=pMember->MPC_SU_Member.Type;
        PointerControl(pMemberType);
        fill_be_type_tree(pMemberType);
        pMember=pMember->MPC_SU_Member.Next;
        PointerControl(pMember);
      }  
      pMemberList=pMemberList->MPC_SU_MemberDecl.Next;
      PointerControl(pMemberList);
    }
  }
}
  
void ext_fill_be_type_tree(tTree yyt) {
  before_equive=NoTree;
  if(yyt != NoTree) {
    if(Tree_IsType(yyt,kMPC_Type) && yyt->MPC_Type.pType == NoType) {
      Position=yyt->MPC_Type.Pos;
      fprintf(stderr,"  source: %s line: %d\n",
              SourceFile(Position),RealPosition(Position).Line);
      fill_be_type_tree(yyt);
    }
  }
}

void fill_be_type_tree(tTree yyt) {
  tTree pParentType=NoTree;
  tType pParent=NoType;
  tTree pMemberList=NoTree,pEquivType=NoTree;
  if(prt) printf("fill_be_type_tree yyt=%p Kind=%d \n",
                     yyt,yyt != NoTree ? yyt->Kind : 0);
  
  if(yyt != NoTree) {
    if(Tree_IsType(yyt,kMPC_Type) && yyt->MPC_Type.pType == NoType) {
      if(prt) printf(" pType=%p\n",yyt->MPC_Type.pType);
      switch(yyt->Kind) {
      case kMPC_Typedef:
        pParentType=yyt->MPC_Typedef.Type;
        break;
      case kMPC_ArrayType:
        pParentType=yyt->MPC_ArrayType.ElementType;
        break;
      case kMPC_VectorType:
        pParentType=yyt->MPC_VectorType.ElementType;
        break;
      case kMPC_PointerType:
        pParentType=yyt->MPC_PointerType.ElementType;
        if(prt) printf("MPC_PointerType ElementType=%p\n",
                       yyt->MPC_PointerType.ElementType);
        yyt->MPC_Type.pType=new_type(TypeRoot,yyt);
        return;
        break;
      case kMPC_FunctionType:
        pParent=TypeRoot;
        break;
      case kMPC_StructType:
        pMemberList=yyt->MPC_StructType.MemberDecls;
        pEquivType =yyt->MPC_StructType.EquivType;
      case kMPC_UnionType:
        if(yyt->Kind == kMPC_UnionType) {
          pMemberList=yyt->MPC_UnionType.MemberDecls;
          pEquivType=yyt->MPC_UnionType.EquivType;
        }
        if(prt) {
          printf("yyt->Kind=%d EquivType=%p EquivType->Kind=%d\n",
                 yyt->Kind,pEquivType,
                 pEquivType == NoTree ? 0 : pEquivType->Kind);
          fflush(stdout);
        }
        fill_eq_type(yyt,pMemberList,pEquivType);
        pParent=TypeRoot;
        break;
      default:
        pParent=TypeRoot;
        break;
      }
      if(pParent == NoType) {
        PointerControl(pParentType);
        /*printf("pParentType=%p pParentType->Kind=%d pParentType->MPC_Type.pType=%p\n",
          pParentType,pParentType->Kind,pParentType->MPC_Type.pType);*/
        fill_be_type_tree(pParentType);
      }
      /*printf("yyt=%p yyt->Kind=%d pParentType=%p pParent=%p\n",
        yyt,yyt->Kind,pParentType,pParent);*/
      if(yyt->Kind == kMPC_Typedef) {
        /*printf("                         pParentType->MPC_Type.pType=%p\n",
          pParentType->MPC_Type.pType);*/
        yyt->MPC_Type.pType=pParentType->MPC_Type.pType;
      }  
      else {
        tType pPar;
        if(pParent == NoType) {
          TypeControl(pParentType->MPC_Type.pType);
          if(pParentType->Kind == kMPC_BasicType) {
            /*printf("                       pParentType->MPC_BasicType.TypeConstructor=%d \n",
              pParentType->MPC_BasicType.TypeConstructor);*/
          }
          /*printf("                       pType=%p\n",
            pParentType->MPC_Type.pType);*/
          pPar=pParentType->MPC_Type.pType;
        }
        else {
          pPar=pParent;
        }
        yyt->MPC_Type.pType=new_type(pPar,yyt);
      }  
      if(yyt->MPC_Type.pType == NoType) {
        fprintf(stderr,
                "wrong result of the be type tree generation yyt=%p\n",yyt);
        internal_error();
      }
    }
    else {
      if(prt) printf("\n");
    }
  }
}


void print_Expr_direct(tTree pExpr) {
  int old_not_check=not_check;
  int old_not_change_net=not_change_net;
  not_check=1;
  not_change_net=1;
  PointerControl(pExpr);
  print_Expr(pExpr);
  not_check=old_not_check;
  not_change_net=old_not_change_net;
}  

#define TypeTreeLen 10

static char* TypeTreeNames[TypeTreeLen]=
{"MPC_Basic","MPC_Enum",
 "MPC_Typedef"," MPC_BitField","MPC_Array","MPC_Pointer",
 "MPC_Struct","MPC_Union","MPC_Function","MPC_List"};
static char* EmptyString="";
static tType parent_type=NoType;



void print_rts_type_tree(tType yy) {
  int old_in_type=in_type;
  tType old_parent_type=parent_type;
  tType pAux;
  int old_not_check=not_check;
  not_check=1;
  
  /*return;*/
  in_type=1;
  TypeControl(yy);
  if(yy != NoType) {
    if(prt) printf("print_rts_type_tree yy=%p Gen=%d Used=%d \n",yy,yy->Type.Gen,yy->Type.Used);
    if(prt) printf("print_rts_type_tree Number: %d\n",yy->Type.Number);
  }

  if(yy->Kind == kType &&
     yy->Type.Gen == 0 &&
     yy->Type.Used == 0) {
    tTree yyt=yy->Type.Origin;
    PointerControl(yyt);
    switch(yyt->Kind) {
    case kMPC_PointerType:
      /*printf("print_rts_type_tree : pointer entry\n");*/
      if(yyt->MPC_PointerType.ElementType->MPC_Type.pType != parent_type) {
        if(prt) printf("print_rts_type_tree : going down with pointer entry\n");
        parent_type=yy;
        print_rts_type_tree(yyt->MPC_PointerType.ElementType->MPC_Type.pType);
      }
    break;
    }
  if(set_gen) yy->Type.Gen=1+1;
  }

  if(yy->Kind == kType &&
     yy->Type.Gen == 0 &&
     yy->Type.Used == 1) {
    tTree yyt=yy->Type.Origin;
    tIdent Ident;
    tTree pElement;
    PointerControl(yyt);
    /*printf("print_rts_type_tree catching -- %d -- type\n",yyt->Kind);*/
    switch(yyt->Kind) {
    case kMPC_BasicType:
      yyt->MPC_BasicType.UniqueNumber=++type_num;
      fprintf(file,"static %s %s={{k%s,\"",
              TypeTreeNames[0],DataVarName(yyt),
              TypeTreeNames[0]);
      print_Type_in_sizeof(yyt);
      fprintf(file,"\",%d,",yy->Type.Number);
      if(yyt->MPC_BasicType.TypeConstructor != VOID) {
        fprintf(file,"sizeof(");
        print_Type_in_sizeof(yyt);
        fprintf(file,")");
      }
      else {
        fprintf(file,"0");
      }
      fprintf(file,",1,%s},%d};\n",
              NULL_DATATYPE,
              -yyt->MPC_BasicType.TypeConstructor);
      break;
    case kMPC_EnumType:
      {
        yyt->MPC_BasicType.UniqueNumber=++type_num;
        fprintf(file,"static %s %s={k%s,",
                TypeTreeNames[1],DataVarName(yyt),
                TypeTreeNames[1]);
        Ident=yyt->MPC_EnumType.EnumTag;
        if(Ident != NoIdent) {
          GetString(Ident,NameBuf);
        }
        else {
          strcpy(NameBuf,"NoName");
        }
        fprintf(file,"\"%s\",%d,sizeof(",
                NameBuf,
                yy->Type.Number);
        if(Ident != NoIdent) {
          not_members=1;
          in_type=0;
        }
        print_Type_in_sizeof(yyt);
        not_members=0;
        fprintf(file,"),1,%s};\n",NULL_DATATYPE);
      }
      break;
    case kMPC_Typedef:
      fprintf(stderr,"typedef can not be in be_type_tree\n");
      internal_error();
      break;
    case kMPC_ArrayType:
      /*printf("print_rts_type_tree : array entry\n");*/
      parent_type=yy;
      if(set_gen) yy->Type.Gen=1;
      if(yy->Type.VectorType!=NoType) print_rts_type_tree(yy->Type.VectorType);
      if(yy->Type.PointerType!=NoType) print_rts_type_tree(yy->Type.PointerType);
      print_rts_type_tree(yyt->MPC_ArrayType.ElementType->MPC_Type.pType);
      if(yy->Type.EquivType)
        for(pAux=yy->Type.EquivType;pAux!=NoType;pAux=pAux->Types.Next) 
          print_rts_type_tree(pAux->Types.Type);

  
      c_blank;
      fprintf(file,"%s%s %s={{k%s,",
              is_dynamic_type(yyt) ? "" : "static ",
              TypeTreeNames[4],DataVarName(yyt),
              TypeTreeNames[4]);
      fprintf(file,"\"");
      print_Type_in_sizeof(yyt);
      fprintf(file,"\",%d,",yy->Type.Number);
      if(yyt->MPC_ArrayType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"MPC_UNDEFINED_SIZE");
      }
      else if(is_dynamic_type(yyt)) {
        fprintf(file,"0");
      }
      else {
        fprintf(file,"sizeof(");
        print_Type_in_rts(yyt);
        fprintf(file,")");
      }
      fprintf(file,",%d,%s},",
              yyt->MPC_ArrayType.Flag.MemCopy,NULL_DATATYPE);
      pElement=yyt->MPC_ArrayType.ElementType;
      PointerControl(pElement);
      if(is_dynamic_step(yyt)&&(yyt->MPC_ArrayType.Step==0))
        fprintf(file,"0,");
      else fprintf(file,"%d,",yyt->MPC_ArrayType.Step);
      if(yyt->MPC_ArrayType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"MPC_UNDEFINED_COUNT");
      }
      else if(is_dynamic_size(yyt)&&(yyt->MPC_ArrayType.NumberOfComponents==0))  {
        fprintf(file,"0");
      }
      else {
        fprintf(file,"%d",
                yyt->MPC_ArrayType.NumberOfComponents);
      }

      fprintf(file,",(%s)&%s,%d};\n",
              DATATYPE,DataVarName(pElement),
              yyt->MPC_ArrayType.Flag.BitArray);

      
      if(is_dynamic_type(yyt)) {
        c_blank;
        fprintf(file,"int %s%s;\n",DataVarName(yyt),SHIFT_SIZE_POSTFIX);
        c_blank;
        fprintf(file,"int %s%s;\n",DataVarName(yyt),REDUCED_SIZE_POSTFIX);
      }
/*
      c_blank;
      fprintf(file,"%s%s %s%s={{k%s,",
              is_dynamic_type(yyt) ? "" : "static ",
              TypeTreeNames[4],DataVarName(yyt),VECTOR_POSTFIX,
              TypeTreeNames[4]);
      fprintf(file,"\"");
      print_Type_in_sizeof(yyt);
      fprintf(file,"\",%d,",yy->Type.Number);
      if(yyt->MPC_ArrayType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"MPC_UNDEFINED_SIZE");
      }
      else if(is_dynamic_type(yyt)) {
        fprintf(file,"0");
      }
      else {
        fprintf(file,"sizeof(");
        print_Type_in_sizeof(yyt);
        fprintf(file,")");
      }
      fprintf(file,",%d,%s},",
              yyt->MPC_ArrayType.Flag.MemCopy,NULL_DATATYPE);
      pElement=yyt->MPC_ArrayType.ElementType;
      PointerControl(pElement);
      fprintf(file,"1,");
      if(yyt->MPC_ArrayType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"MPC_UNDEFINED_COUNT");
      }
      else if(is_dynamic_size(yyt)&&(yyt->MPC_ArrayType.NumberOfComponents==0))  {
        fprintf(file,"0");
      }
      else {
        fprintf(file,"%d",
                yyt->MPC_ArrayType.NumberOfComponents);
      }
      fprintf(file,",(%s)&%s,%d};\n",
              DATATYPE,DataVarName(pElement),
              yyt->MPC_ArrayType.Flag.BitArray);

*/
      break;
    case kMPC_VectorType:
      parent_type=yy;
      print_rts_type_tree(yyt->MPC_VectorType.ElementType->MPC_Type.pType);
        
      c_blank;
      fprintf(file,"%s%s %s={{k%s,", is_dynamic_type(yyt)?"":"static ",
              TypeTreeNames[4],DataVarName(yyt),
              TypeTreeNames[4]);
      fprintf(file,"\"");
      print_Type_in_sizeof(yyt);
      fprintf(file,"\",%d,",yy->Type.Number);
      if(yyt->MPC_VectorType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"MPC_UNDEFINED_SIZE,1,%s},},",NULL_DATATYPE);
      }
      else if(is_dynamic_size(yyt)){
         fprintf(file,"0,1,%s},",NULL_DATATYPE);
      }   
      else {
        fprintf(file,"sizeof(");
        print_Type_in_rts(yyt);
        fprintf(file,"),1,%s,},",NULL_DATATYPE);
      }
      PointerControl(yyt->MPC_VectorType.ElementType);
      if(yyt->MPC_VectorType.NumberOfComponents == UNDEFINED) {
        fprintf(file,"1,MPC_UNDEFINED_COUNT");
      }
      else if(is_dynamic_size(yyt)&&(yyt->MPC_VectorType.NumberOfComponents==0)) {
        fprintf(file,"1,0");
      }
       else {
        fprintf(file,"1,%d",
                yyt->MPC_VectorType.NumberOfComponents);
      }
      fprintf(file,",(%s)&%s,0};\n",
              DATATYPE,DataVarName(yyt->MPC_VectorType.ElementType));
      if(is_dynamic_type(yyt)) {
        c_blank;
        fprintf(file,"int %s%s;\n",DataVarName(yyt),SHIFT_SIZE_POSTFIX);
      }
     break;
 
    case kMPC_PointerType:
      if(set_gen) yy->Type.Gen=1;
      if(yyt->MPC_PointerType.ElementType->MPC_Type.pType != parent_type){
        parent_type=yy;
        print_rts_type_tree(yyt->MPC_PointerType.ElementType->MPC_Type.pType);
      }
      c_blank;

      fprintf(file,"%s%s %s={{k%s,",
              is_dynamic_type(yyt)?"":"static ",TypeTreeNames[5],DataVarName(yyt),
              TypeTreeNames[5]);
      fprintf(file,"\"");
      print_Type_in_sizeof(yyt);
      fprintf(file,"\",%d,",yy->Type.Number);
      fprintf(file,"sizeof(void* )");
      fprintf(file,",1,%s},1,NoMPC_Type};\n",NULL_DATATYPE);
      if(is_dynamic_type(yyt)){
          c_blank;
          fprintf(file,"int %s%s;\n",DataVarName(yyt),SHIFT_SIZE_POSTFIX);
      }
      break;
      /*case kMPC_FunctionType:
        break;*/
    case kMPC_StructType:
    case kMPC_UnionType:
      {
        tTree pEquivType=yyt;
        tTree pMemberList;
        tTree pMember;
        int k_type=yyt->Kind == kMPC_StructType ? 6 : 7;
        if(yyt->Kind == kMPC_StructType) {
          pMemberList=yyt->MPC_StructType.MemberDecls;
          Ident=yyt->MPC_StructType.SU_Tag;
        }
        else {
          pMemberList=yyt->MPC_UnionType.MemberDecls;
          Ident=yyt->MPC_UnionType.SU_Tag;
        }
        if(pMemberList == NoTree) {
          pEquivType=yyt->MPC_StructType.EquivType;
          PointerControl(pEquivType);
          pMemberList=pEquivType->MPC_StructType.MemberDecls;
          while(pMemberList == NoTree) {
            pEquivType=pEquivType->MPC_StructType.EquivType;
            if(pEquivType == yyt) {
              fprintf(stderr,
                      "there is not no null memberlist in struct ring\n");
              internal_error();
            }
            pMemberList=pEquivType->MPC_StructType.MemberDecls;
          }
        }
        PointerControl(pMemberList);
        pMember=pMemberList->MPC_SU_MemberDecl.Member;
        PointerControl(pMember);
        parent_type=yy;
        print_MemberList(pMemberList,pEquivType);
        fprintf(file,"static %s %s={{k%s,",
                TypeTreeNames[k_type],DataVarName(yyt),
                TypeTreeNames[k_type]);
        if(Ident != NoIdent) {
          GetString(Ident,NameBuf);
        }
        else {
          strcpy(NameBuf,"NoName");
        }
        fprintf(file,"\"%s\",%d,sizeof(",
                NameBuf,
                yy->Type.Number);
        if(Ident != NoIdent) {
          not_members=1;
          in_type=0;
        }
        print_Type_in_sizeof(yyt);
        not_members=0;
        fprintf(file,"),1,%s},(%s)&%s};\n",
                NULL_DATATYPE,DATATYPE,DataVarName(pMember));
      }
      break;
    case kMPC_FunctionType:
      fprintf(file,"static %s %s={k%s,",
              TypeTreeNames[8],DataVarName(yyt),
              TypeTreeNames[8]);
      fprintf(file,"\"%s\",%d,0,1,%s};\n",
              EmptyString,
              yyt->MPC_FunctionType.UniqueNumber,
              NULL_DATATYPE);
      break;
    default:
      break;
    }
    if(set_gen) yy->Type.Gen=1+1 /*!in_function*/;
  }
  
  not_check=old_not_check;
  in_type=old_in_type;
  parent_type=old_parent_type;
}


void print_rts_type_tree_2(tType yy) {
 tTree yyt;
 tTree pSize;
 tType pAux;
 int old_not_check=not_check;
 
 TypeControl(yy);
 not_check=1;
 if(yy != NoType) {
    if(prt) printf("print_rts_type_tree2 yy=%p Gen=%d\n",yy,yy->Type.Gen);
  }
 
 if((yy->Kind == kType) &&
    (yy->Type.Gen != PRTT_2PASS) &&
    (yy->Type.Used == 0)) {
    tTree yyt=yy->Type.Origin;
    PointerControl(yyt);
    switch(yyt->Kind) {
    case kMPC_PointerType:
      if(yyt->MPC_PointerType.ElementType->MPC_Type.pType != parent_type) {
        parent_type=yy;
        print_rts_type_tree_2(yyt->MPC_PointerType.ElementType->MPC_Type.pType);
      }
    break;
    }
  if(set_gen_2) yy->Type.Gen=PRTT_2PASS;
  }
 
 if((yy->Kind == kType) &&
    (yy->Type.Gen != PRTT_2PASS) &&
    (yy->Type.Used == 1)) {
    yyt=yy->Type.Origin;
    PointerControl(yyt);
    if(is_dynamic_type(yyt)) switch(yyt->Kind) {
    case kMPC_ArrayType:
      if(set_gen_2) yy->Type.Gen=PRTT_2PASS;
      print_rts_type_tree_2(yyt->MPC_ArrayType.ElementType->MPC_Type.pType);
      pSize=yyt->MPC_ArrayType.ArraySize;
      PointerControl(pSize);
         
      c_blank;
      fprintf(file,"%s.Base.Size=",DataVarName(yyt));
      fprintf(file,"%s.Base.Size*(",
              DataVarName(yyt->MPC_ArrayType.ElementType));
      fprintf(file,"(("); 
      if(is_dynamic_size(yyt)&&(yyt->MPC_ArrayType.NumberOfComponents==0))
        print_Expr(pSize);
      else 
        fprintf(file," %d ", yyt->MPC_ArrayType.NumberOfComponents);
      fprintf(file,")-1)");
          
 
      if(is_dynamic_step(yyt)&&(yyt->MPC_ArrayType.Step==0))
        {
          tTree pStep=yyt->MPC_ArrayType.DynStep;
          PointerControl(pStep);
          fprintf(file,"*(");
          print_Expr(pStep);
          fprintf(file,")");
        }
      else if(yyt->MPC_ArrayType.Step!=1)
        {
          fprintf(file,"*(");
          fprintf(file,"%d",yyt->MPC_ArrayType.Step);
          fprintf(file,")");
        }
        
      fprintf(file,"+1);\n");
        if(is_dynamic_size(yyt)&&(yyt->MPC_ArrayType.NumberOfComponents==0))
          {
          c_blank;
          fprintf(file,"%s.Number=",DataVarName(yyt));
          print_Expr(pSize);
          fprintf(file,";\n");
          }
        else 
          {
          c_blank;
          fprintf(file,"%s.Number=",DataVarName(yyt));
          fprintf(file,"%d",yyt->MPC_ArrayType.NumberOfComponents);
          fprintf(file,";\n");
          }
        
        if(is_dynamic_step(yyt)&&(yyt->MPC_ArrayType.Step==0)) {
          tTree pStep=yyt->MPC_ArrayType.DynStep;
          c_blank;
          fprintf(file,"%s.Step=",DataVarName(yyt));
          PointerControl(pStep);
          print_Expr(pStep);
          fprintf(file,";\n");
        }
        
        c_blank;
        fprintf(file,"%s%s=",DataVarName(yyt),SHIFT_SIZE_POSTFIX);

        if((yyt->MPC_ArrayType.ElementType->Kind==kMPC_ArrayType)||
           (yyt->MPC_ArrayType.ElementType->Kind==kMPC_VectorType))
          {
            fprintf(file,"(%s.Base.Size",DataVarName(yyt->MPC_ArrayType.ElementType));
            fprintf(file,"/"); 
            fprintf(file,"sizeof(");
            print_Type_in_rts(First_Static_Type(yyt));
            fprintf(file,"))");
            
            if(is_dynamic_step(yyt)&&(yyt->MPC_ArrayType.Step==0))
              {  
                fprintf(file,"*%s.Step",DataVarName(yyt));  
              }
            else if(yyt->MPC_ArrayType.Step!=1)
              {
                fprintf(file,"*%d",yyt->MPC_ArrayType.Step);
              }
          }
        else 
          {
            if(is_dynamic_step(yyt)&&(yyt->MPC_ArrayType.Step==0))
              {  
                fprintf(file,"%s.Step",DataVarName(yyt));  
              }
            else  
              {
                fprintf(file,"%d",yyt->MPC_ArrayType.Step);
              }
          }
        
        fprintf(file,";\n");
        
        c_blank;
        fprintf(file,"%s%s=%s.Base.Size/",DataVarName(yyt),REDUCED_SIZE_POSTFIX,
                DataVarName(yyt));
        
        fprintf(file,"sizeof(");
        print_Type_in_rts(First_Static_Type(yyt));
        fprintf(file,");\n");
        
        if(yy->Type.VectorType!=NoType) print_rts_type_tree_2(yy->Type.VectorType);
        if(yy->Type.PointerType!=NoType) print_rts_type_tree_2(yy->Type.PointerType);
        if(yy->Type.EquivType)
          for(pAux=yy->Type.EquivType;pAux!=NoType;pAux=pAux->Types.Next) 
            print_rts_type_tree_2(pAux->Types.Type);
        break;
    case kMPC_VectorType:
       if(set_gen_2) yy->Type.Gen=PRTT_2PASS;
       pSize=yyt->MPC_VectorType.VectorSize;
       print_rts_type_tree_2(yyt->MPC_VectorType.ElementType->MPC_Type.pType);
 
       
        c_blank;
        fprintf(file,"%s.Base.Size=",DataVarName(yyt));
        fprintf(file,"%s.Base.Size*(",
                     DataVarName(yyt->MPC_VectorType.ElementType));

        if(yyt->MPC_VectorType.NumberOfComponents==0)
           {
           PointerControl(pSize);
           print_Expr(pSize);
           }
        else 
           fprintf(file,"%d",yyt->MPC_VectorType.NumberOfComponents);

        fprintf(file,");\n");
        
        if(yyt->MPC_VectorType.NumberOfComponents==0){
             c_blank;
             fprintf(file,"%s.Number=",DataVarName(yyt));
             print_Expr(pSize);
             fprintf(file,";\n");
        }
        else {
             c_blank;
             fprintf(file,"%s.Number=",DataVarName(yyt));
             fprintf(file,"%d",yyt->MPC_VectorType.NumberOfComponents==0);
             fprintf(file,";\n");
        }
       
       
      c_blank;
       fprintf(file,"%s%s=",DataVarName(yyt),SHIFT_SIZE_POSTFIX);

       if((yyt->MPC_VectorType.ElementType->Kind==kMPC_VectorType)||
         (yyt->MPC_VectorType.ElementType->Kind==kMPC_VectorType))
        {
        fprintf(file,"(%s.Base.Size",DataVarName(yyt->MPC_VectorType.ElementType));
        fprintf(file,"/"); 
        fprintf(file,"sizeof(");
        print_Type_in_rts(First_Static_Type(yyt));
        fprintf(file,"))");
        }
      else 
        {
        fprintf(file,"1");
        }

        fprintf(file,";\n");
  
    break;
    case kMPC_PointerType:
        if(set_gen_2) yy->Type.Gen=PRTT_2PASS;
        print_rts_type_tree_2(yyt->MPC_PointerType.ElementType->MPC_Type.pType);
        c_blank;
        fprintf(file,"%s%s=(",DataVarName(yyt),SHIFT_SIZE_POSTFIX);
        if(is_dynamic_pointer(yyt)) 
          {
          tTree pStep=yyt->MPC_PointerType.DynStep;
          PointerControl(pStep);
          print_Expr/*_direct*/(pStep);
          }
        else 
          {
          fprintf(file,"%d",yyt->MPC_PointerType.Step);
          }
        fprintf(file,")");
        if(is_pointer_on_dynamic(yyt))
          {
          fprintf(file,"*%s%s",DataVarName(yyt->MPC_PointerType.ElementType),REDUCED_SIZE_POSTFIX);
          }
        fprintf(file,";\n");
    break;
    default:
    break;
    } 
 }
 not_check=old_not_check;
}

static tTree Not_Array_Type(tTree pType)
{
PointerControl(pType);
if(pType->Kind==kMPC_ArrayType) return Not_Array_Type(pType->MPC_ArrayType.ElementType);
else if(pType->Kind==kMPC_VectorType) return Not_Array_Type(pType->MPC_VectorType.ElementType);
else return pType; 
}

tTree Strip_Typedef(tTree pType)
{
  PointerControl(pType);
  if(pType->Kind==kMPC_Typedef) return Strip_Typedef(pType->MPC_Typedef.Type);
  else return pType;
}

static tTree First_Static_Type(tTree pType)
{
  PointerControl(pType);
  pType=Strip_Typedef(pType);
  if(IS_DYN_ARRAY_OR_VECTOR(pType)) return First_Static_Type(element_type(pType));
  else return pType; 
}




tTree last_member(tTree pMemberList) {
  tTree pMember,pNext;
  PointerControl(pMemberList);
  pMember=pMemberList->MPC_SU_MemberDecl.Member;
  PointerControl(pMember);
  while(1) {
    pNext=pMember->MPC_SU_Member.Next;
    PointerControl(pNext);
    if(prt) printf("last_member member=%d next=%d\n",
                       pMember->MPC_SU_Member.UniqueNumber,
                       pNext->Kind == kMPC_FreeNode ? -1 :
                       pNext->MPC_SU_Member.UniqueNumber);
    if(pNext->Kind == kMPC_FreeNode) 
      break;
    else
      pMember=pNext;
  }
  if(prt) printf("last_member=%d\n", pMember->MPC_SU_Member.UniqueNumber);
  return pMember;
}

tTree last_member_list(tTree pMemberList) {
  tTree pNext;
  PointerControl(pMemberList);
  while(1) {
    pNext=pMemberList->MPC_SU_MemberDecl.Next;
    PointerControl(pNext);
    if(pNext->Kind == kMPC_FreeNode) 
      break;
    else
      pMemberList=pNext;
  }
  return pMemberList;
}

tTree next_member(tTree pMemberList, tTree pMember) {
  tTree pNextMember,pNextMemberList=NoTree;
  PointerControl(pMemberList);
  PointerControl(pMember);
  pNextMember=pMember->MPC_SU_Member.Next;
  PointerControl(pNextMember);
  if(pNextMember->Kind == kMPC_FreeNode) {
    pNextMemberList=pMemberList->MPC_SU_MemberDecl.Next;
    PointerControl(pNextMemberList);
    if(pNextMemberList->Kind == kMPC_FreeNode) {
      fprintf(stderr,"wrong next member\n");
      internal_error();
    }
    else {
    /*pNextMember=last_member(pNextMemberList);*/
      pNextMember=pNextMemberList->MPC_SU_MemberDecl.Member;
    }
  }
  if(prt) printf("next_member Member.Num=%d Next.Num=%d list->num=%d next_list->num=%d\n",
                     pMember->MPC_SU_Member.UniqueNumber,
                     pNextMember->MPC_SU_Member.UniqueNumber,
                     pMemberList->MPC_SU_MemberDecl.Member->
                     MPC_SU_Member.UniqueNumber,
                     pNextMemberList->Kind == kMPC_SU_MemberDecl ?
                     pNextMemberList->MPC_SU_MemberDecl.Member->
                     MPC_SU_Member.UniqueNumber : -1);
  return pNextMember;
}

static void print_MemberList(tTree pMemberList, tTree yyt) {
  int last=1;
  tTree pMember;
  PointerControl(pMemberList);
  pMemberList=last_member_list(pMemberList);
  if(prt) printf("print_MemberList pMemberList=%p yyt=%p\n",pMemberList,yyt);
  while(pMemberList->Kind != kMPC_FreeNode) {
    pMember=last_member(pMemberList);
    PointerControl(pMember);
    while(pMember->Kind != kMPC_FreeNode) {
      tTree pType=pMember->MPC_SU_Member.Type;
      int LastListNum;
      LastListNum=ListNum-1;
      pMember->MPC_SU_Member.UniqueNumber=ListNum++;
      PointerControl(pType);
      print_rts_type_tree(pType->MPC_Type.pType);
      fprintf(file,"static %s %s_%d={",
              TypeTreeNames[9],MEMBER_NAME,
              pMember->MPC_SU_Member.UniqueNumber/*,TypeTreeNames[9]*/);
      fprintf(file,"(%s)&%s,",
              DATATYPE,DataVarName(pType));
      if(last) {
        last=0;
        fprintf(file,"NoMPC_Type};\n");
      }
      else {
        tTree pNextMember;
        pNextMember=next_member(pMemberList,pMember);
        PointerControl(pNextMember);
        fprintf(file,"(%s)&%s_%d};\n",DATATYPE,MEMBER_NAME,
                pNextMember->MPC_SU_Member.UniqueNumber);
      }
      pMember=pMember->MPC_SU_Member.Prev;
      PointerControl(pMember);
    }
    pMemberList=pMemberList->MPC_SU_MemberDecl.Prev;
    PointerControl(pMemberList);
  }
}


static void print_Type_in_rts(tTree yyt) {
  PointerControl(yyt);
  if(yyt->Kind==kMPC_PointerType) cur_pos+=fprintf(file,"void *");
  else print_Type_in_sizeof(yyt);
}

void print_Type_in_sizeof(tTree yyt) {
  int old_in_type=in_type;
  int old_source_only=source_only;
  int old_print_base_type=print_base_type;
  int old_in_sizeof=in_sizeof;
  in_sizeof=1;
  PointerControl(yyt);
    source_only=1;
    print_base_type=1;
    in_type=1;
    print_Type(yyt);
    source_only=0;
    print_base_type=0;
    print_LeftType(yyt,NoTree);
    print_RightType(yyt,NoTree);
    
    in_sizeof=old_in_sizeof;
    in_type=old_in_type;
    source_only=old_source_only;
    print_base_type=old_print_base_type;
}
  
void set_parent_used(tType pType) {
  if(pType != NoType) {
    while(pType != TypeRoot) {
      tTree p_type=pType->Type.Origin;
      PointerControl(p_type);
      pType->Type.Used=1;
      if(p_type->Kind == kMPC_StructType) {
        tTree pMemberList=p_type->MPC_StructType.MemberDecls;
        if(pMemberList == NoTree) {
          tTree pEquivType=p_type->MPC_StructType.EquivType;
          PointerControl(pEquivType);
          pMemberList=pEquivType->MPC_StructType.MemberDecls;
          while(pMemberList == NoTree) {
            pEquivType=pEquivType->MPC_StructType.EquivType;
            if(pEquivType == p_type) {
              fprintf(stderr,
                      "there is not no null memberlist in struct ring\n");
              internal_error();
            }
            pMemberList=pEquivType->MPC_StructType.MemberDecls;
          }
        }
        while(pMemberList->Kind != kMPC_FreeNode) {
          tTree pMember=pMemberList->MPC_SU_MemberDecl.Member;
            /*last_member(pMemberList);*/
          PointerControl(pMember);
          while(pMember->Kind != kMPC_FreeNode) {
            tTree pType=pMember->MPC_SU_Member.Type;
            PointerControl(pType);
            set_parent_used(pType->MPC_Type.pType);
            pMember=pMember->MPC_SU_Member.Next;
            PointerControl(pMember);
          }
          pMemberList=pMemberList->MPC_SU_MemberDecl.Next;
          PointerControl(pMemberList);
        }
      }
      if(p_type->Kind == kMPC_PointerType) break;
      pType=pType->Type.Parent;
      TypeControl(pType);
    }
  }
}

static tTree elem_type(tTree pExpr) {
  tTree pElemType,pType;
  PointerControl(pExpr);
  pType=pExpr->MPC_Expr.Type;
  PointerControl(pType);
  if(prt) printf("elem_type Type->Kind=%d\n",pType->Kind);
  if(pType->Kind == kMPC_ArrayType) {
    pElemType=pType->MPC_ArrayType.ElementType;
  }
  else if(pType->Kind == kMPC_PointerType) {
    pElemType=pType->MPC_PointerType.ElementType;
  }
  else if(pType->Kind == kMPC_VectorType) {
    pElemType=pType->MPC_VectorType.ElementType;
  }
  else {
    pElemType=NoTree;
  }
  return pElemType;
}

int compare_buffer_types(tType pS,tType pD)
{
  int ret;
  
  if(pS==pD) ret=ABSOLUTELY_EQUAL;
  else {
    carefull_compare=0;
    if(same_type(pS->Type.Origin,pD->Type.Origin)) ret=POSSIBLY_DIFFERENT;
    else ret=STRICKTLY_DIFFERENT;
    carefull_compare=1;
  }

  return ret;
}
     
tTree buffer_type(tTree pArg) {
  tTree pSource=NoTree,pDest=NoTree;
  tTree pSourceElType,pDestElType;
  tType pSEl,pDEl;
  int i=0;
  PointerControl(pArg);
  while(pArg->Kind != kMPC_FreeNode) {
    i++;
    if(i == source_pos[built_in_fun-1]) {
      pSource=pArg->MPC_Exprs.Expr;
      PointerControl(pSource);
      if(prt) printf("source pos=%d\n",i);
    }
    if(i == dest_pos[built_in_fun-1]) {
      pDest=pArg->MPC_Exprs.Expr;
      PointerControl(pDest);
      if(prt) printf("dest pos=%d\n",i);
      break;
    }
    pArg=pArg->MPC_Exprs.Next;
    PointerControl(pArg);
  }
  if(i < dest_pos[built_in_fun-1]) {
    fprintf(stderr,"wrong destination buffer position %d in built-in function list i=%d\n",dest_pos[built_in_fun-1],i);
    internal_error();
  }
  pSourceElType=elem_type(pSource);
  if(pSourceElType == NoTree) {
    be_error("wrong type of the source buffer in built-in function\n");
  }
  pDestElType=elem_type(pDest);
  if(pDestElType == NoTree) {
    be_error("wrong type of the destination buffer in built-in function\n");
  }
  pSEl=pSourceElType->MPC_Type.pType;
  TypeControl(pSEl);
  pDEl=pDestElType->MPC_Type.pType;
  TypeControl(pDEl);
  
    switch(compare_buffer_types(pSEl,pDEl)){
    case STRICKTLY_DIFFERENT:
    be_error("element type of the source buffer is not equal to \n"
    "element type of the destination buffer in built-in function\n");
    break;
    case POSSIBLY_DIFFERENT:
    break;
  }
 

    /*
  if(pSEl != pDEl) {
    be_error("element type of the source buffer is not equal to \n"
             "element type of the destination buffer in built-in function\n");
             }
             */
  return pSourceElType;
  /*fprintf(file,"(%s)(&%s)",
          DATATYPE,DataVarName(pSourceElType));*/
}

static int set_memcopy(tTree yyt) {
  PointerControl(yyt);
  return yyt->MPC_Type.Flag.MemCopy || yyt->Kind == kMPC_VectorType; 
}
