
   /************************************************/
   /* Partitioning interfaces for graphs           */
   /*                                              */
   /* Revision history                             */
   /* 22-04-2004  --      Initial version          */
   /************************************************/

   #include <hmpi.h>
   #include <metis.h>
   #include <hmetis.h>
   
   /*
    * Third Party Software METIS and hMETIS is used
    * for some of the partitioning problems.
    * In future, METIS and hMETIS and HMPI can be integrated
    * so that application programmers can provide the 
    * various options for multi-level partitioning of graphs.
    *
    * In METIS, there are two partitioning objectives:
    * (a) Minimizing the number of edges that straddle 
    *     partitions (edgecut)
    * (b) Minimizing the total communication volume.
    *
    * We use the objective b.
    *
    * Please refer to METIS & hMETIS documentation for 
    * more information on the usage of the graph partitioning
    * interfaces.
    */ 

   /*-----------------------------------------------------*/

   int METIS_PartGraphRecursive_w
   (
        int *nvtxs, 
        const int *xadj,
        const int* adjacency, 
        const int* vwgt, 
        const int* adjwgt, 
        int* wgtflag, 
        int* numflag, 
        int *nparts, 
        int *options,
        int *edgecut,
        int *part
   )
   {
       METIS_PartGraphRecursive(
            nvtxs,
            (int*)xadj,
            (int*)adjacency,
            (int*)vwgt,
            (int*)adjwgt,
            wgtflag,
            numflag,
            nparts,
            options,
            edgecut,
            part
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int METIS_PartGraphKway_w
   (
        int *nvtxs, 
        const int *xadj,
        const int* adjacency, 
        const int* vwgt, 
        const int* adjwgt, 
        int* wgtflag, 
        int* numflag, 
        int *nparts, 
        int *options,
        int *edgecut,
        int *part
   )
   {
       METIS_PartGraphKway(
            nvtxs,
            (int*)xadj,
            (int*)adjacency,
            (int*)vwgt,
            (int*)adjwgt,
            wgtflag,
            numflag,
            nparts,
            options,
            edgecut,
            part
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int METIS_WPartGraphRecursive_w
   (
        int *nvtxs, 
        const int *xadj,
        const int* adjacency, 
        const int* vwgt, 
        const int* adjwgt, 
        int* wgtflag, 
        int* numflag, 
        int *nparts, 
        float *tpwgts,
        int *options,
        int *edgecut,
        int *part
   )
   {
       METIS_WPartGraphRecursive(
            nvtxs,
            (int*)xadj,
            (int*)adjacency,
            (int*)vwgt,
            (int*)adjwgt,
            wgtflag,
            numflag,
            nparts,
            tpwgts,
            options,
            edgecut,
            part
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int METIS_WPartGraphKway_w
   (
        int *nvtxs, 
        const int *xadj,
        const int* adjacency, 
        const int* vwgt, 
        const int* adjwgt, 
        int* wgtflag, 
        int* numflag, 
        int *nparts, 
        float *tpwgts,
        int *options,
        int *edgecut,
        int *part
   )
   {
       METIS_WPartGraphKway(
            nvtxs,
            (int*)xadj,
            (int*)adjacency,
            (int*)vwgt,
            (int*)adjwgt,
            wgtflag,
            numflag,
            nparts,
            tpwgts,
            options,
            edgecut,
            part
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int HMETIS_PartRecursive_w
   (
        int nvtxs, 
        int nhedges,
        const int* vwgts, 
        const int* eptr, 
        const int* eind, 
        const int* hewgts, 
        int nparts, 
        int ubfactor, 
        int *options,
        int *part,
        int *edgecut
   )
   {
       HMETIS_PartRecursive(
            nvtxs,
            nhedges,
            (int*)vwgts,
            (int*)eptr,
            (int*)eind,
            (int*)hewgts,
            nparts,
            ubfactor,
            options,
            part,
            edgecut
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int HMETIS_PartKway_w
   (
       int nvtxs, 
       int nhedges,
       const int* vwgts, 
       const int* eptr, 
       const int* eind, 
       const int* hewgts, 
       int nparts, 
       int ubfactor, 
       int *options,
       int *part,
       int *edgecut
   )
   {
       HMETIS_PartKway(
            nvtxs,
            nhedges,
            (int*)vwgts,
            (int*)eptr,
            (int*)eind,
            (int*)hewgts,
            nparts,
            ubfactor,
            options,
            part,
            edgecut
       );

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

