
   #include <hmpi.h>

   /*
    *  Depends on the dimensions of 'coord' declaration
    * in nettypes/model definitions.
    */
   char _hmpi_vectors[] = { 'I', 'J', 'K', 'L' };
   int _hmpi_vectors_length = sizeof(_hmpi_vectors)/sizeof(char);
       
   /*-----------------------------------------------------*/

   int HMPI_modulus
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx % Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_equal_to
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx == Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_not_equal_to
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx != Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_greater
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx > Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_greater_equal
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx >= Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_less
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx < Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_less_equal
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx <= Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_logical_and
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx && Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_logical_or
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx || Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_logical_not
   (
       const int Tx
   )
   {
       return !Tx;
   }

   /*-----------------------------------------------------*/

   int HMPI_plus
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx + Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_minus
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx - Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_mult
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx * Ty);
   }

   /*-----------------------------------------------------*/

   int HMPI_div
   (
       const int Tx,
       const int Ty
   )
   {
       return (Tx / Ty);
   }

   /*-----------------------------------------------------*/

   HMPI_Binary_op_type _HMPI_binary_ops[] = {
	
       HMPI_modulus,       OpMOD,           "%",
       HMPI_equal_to,      OpEQ,            "==",
       HMPI_not_equal_to,  OpNEQ,           "!=",
       HMPI_greater,       OpGT,            ">",
       HMPI_greater_equal, OpGE,            ">=",
       HMPI_less,          OpLT,            "<",
       HMPI_less_equal,    OpLE,            "<=",
       HMPI_logical_and,   OpLAND,          "&&",
       HMPI_logical_or,    OpLOR,           "||",
       HMPI_plus,          OpPLUS,          "+",
       HMPI_minus,         OpMINUS,         "-",
       HMPI_mult,          OpMULT,          "*",
       HMPI_div,           OpDIV,           "/",
       NULL,               OpUNDEF,         NULL

   };

   HMPI_Unary_op_type _HMPI_unary_ops[] = {
	
       HMPI_logical_not,   OpLNOT,          "!",

   };

   /*-----------------------------------------------------*/

   int
   HMPI_Evaluate_bnode
   (
        const HMPI_Cond_t* hmpi_bnode,
        const int *coord
   )
   {
        int value;
        int lhs_value;
        int rhs_value;

        if (hmpi_bnode->op == OpUNDEF)
        {
           return HMPI_INVALID_OPERATOR;
        }

        lhs_value = HMPI_Get_value(
                        hmpi_bnode->lhs_value,
                        coord
        );

        if (lhs_value == HMPI_INVALID_OPERAND_TYPE)
        {
           return HMPI_INVALID_OPERAND_TYPE;
        }

        if (lhs_value == HMPI_INVALID_OPERATOR)
        {
           return HMPI_INVALID_OPERATOR;
        }

        rhs_value = HMPI_Get_value(
                        hmpi_bnode->rhs_value,
                        coord
        );

        if (rhs_value == HMPI_INVALID_OPERAND_TYPE)
        {
           return HMPI_INVALID_OPERAND_TYPE;
        }

        if (rhs_value == HMPI_INVALID_OPERATOR)
        {
           return HMPI_INVALID_OPERATOR;
        }

        value = (_HMPI_binary_ops[hmpi_bnode->op]._binary_op_func)
                (
                  lhs_value,
                  rhs_value
        );

        return value;
   }

   /*-----------------------------------------------------*/

   int 
   HMPI_Get_value
   (
       HMPI_Operand_t* val,
       const int* coord
   )
   {
       int value;

       switch (val->operand_type)
       {
          case VECTOR:
            {
               value = coord[val->operand_val];
            }
            break;
          case SCALAR:
            {
               value = val->operand_val;
            }
            break;
          case EXPR:
            {
               value = HMPI_Evaluate_conditions_i(
                          val->operand_bnode,
                          1,
                          NULL,
                          0,
                          coord
               );
            }
            break;
          default:
            {
               value = HMPI_INVALID_OPERAND_TYPE;
            }
            break;
       }

       return value;
   }

   /*-----------------------------------------------------*/

   int HMPI_Evaluate_conditions
   (
       const char* conditions,
       const int* coord
   )
   {
       int i = 0, rc;

       HMPI_Cond_t* cond;
       int cond_count;

       int* ops;
       int op_count;

       /* 
        * Evaluate the conditions passed by user. 
        * Is there a need to use lex and yacc here?
        */
       while (conditions[i++] != '\0')
       {
          int tmp;
          HMPI_Operand_t lhs_operand;
          HMPI_Operand_t rhs_operand;

          for (tmp = 0; tmp < _hmpi_vectors_length; tmp++)
          {
              if (conditions[i] == _hmpi_vectors[tmp])
              {
                 break;
              }
          }

          if (tmp == _hmpi_vectors_length)
          {
             /* check if its scalar, otherwise error */
          }
          else
          {
             /* Its a vector */
          }
       } 

       rc = HMPI_Evaluate_conditions_i(
                cond,
                cond_count,
                ops,
                op_count,
                coord
       );

       return rc;
   }

   /*-----------------------------------------------------*/

   int HMPI_Evaluate_conditions_i
   (
       const HMPI_Cond_t* hmpi_bnode,
       int cond_count,
       const int* ops,
       int op_count,
       const int* coord
   )
   {
       if (cond_count == 1)
       {
          return HMPI_Evaluate_bnode(
                    &hmpi_bnode[0],
                    coord
          );
       }

       {
          int i, j;
          int result = -1;
          int value[cond_count];

          for (i = 0; i < cond_count; i++)
          {
              value[i] = HMPI_Evaluate_bnode(
                             &hmpi_bnode[i],
                             coord
              );

          }

          for (i = 0, j = 0; j < op_count; j++)
          {
              if (result == -1)
              {
                 result = (_HMPI_binary_ops[ops[j]]._binary_op_func)
                          (
                                value[i++],
                                value[i++]
                 );
              }
              else
              {
                 result = (_HMPI_binary_ops[ops[j]]._binary_op_func)
                          (
                                result,
                                value[i++]
                 );
              }
          }

          return result;
       }

       return HMPI_ERROR_CONDITION;
   }

   /*-----------------------------------------------------*/

   int HMPI_Process_conditions
   (
       const HMPI_Cond_t* hmpi_bnode,
       const int* coord
   )
   {
       int value;
       int lhs_value;
       int rhs_value;

       if ((hmpi_bnode->lhs_node == NULL)
            && (hmpi_bnode->rhs_node == NULL
          )
       )
       {
          return HMPI_Evaluate_bnode(
                    hmpi_bnode,
                    coord
          );
       }

       {
           HMPI_Cond_t* HMPI_lhs_bnode = hmpi_bnode->lhs_node;
           HMPI_Cond_t* HMPI_rhs_bnode = hmpi_bnode->rhs_node;

           if ((HMPI_lhs_bnode != NULL)
                || (HMPI_rhs_bnode != NULL
              )
           )
           {
              {
                 lhs_value = HMPI_Process_conditions(
                                HMPI_lhs_bnode,
                                coord
                 );

                 if (lhs_value == HMPI_INVALID_OPERAND_TYPE)
                 {
                    return HMPI_INVALID_OPERAND_TYPE;
                 }

                 if (lhs_value == HMPI_INVALID_OPERATOR)
                 {
                    return HMPI_INVALID_OPERATOR;
                 }
              }

              {
                 rhs_value = HMPI_Process_conditions(
                                HMPI_rhs_bnode,
                                coord
                 );

                 if (rhs_value == HMPI_INVALID_OPERAND_TYPE)
                 {
                    return HMPI_INVALID_OPERAND_TYPE;
                 }

                 if (rhs_value == HMPI_INVALID_OPERATOR)
                 {
                    return HMPI_INVALID_OPERATOR;
                 }
              }

              value = (_HMPI_binary_ops[hmpi_bnode->op]._binary_op_func)
                      (
                        lhs_value,
                        rhs_value
              );
           }
        }

        return value;
   }

   /*-----------------------------------------------------*/

   int
   HMPI_Cond_create
   (
       HMPI_Cond_t* cond,
       const HMPI_Operand_t* lhs_operand,
       const HMPI_Operand_t* rhs_operand,
       int operator
   )
   {
       cond->lhs_value = (HMPI_Operand_t*)lhs_operand;
       cond->rhs_value = (HMPI_Operand_t*)rhs_operand;
       cond->op = operator;

       cond->lhs_node = NULL;
       cond->rhs_node = NULL;

       return HMPI_OK;
   }

   /*-----------------------------------------------------*/

   int
   HMPI_Operand_create
   (
       HMPI_Operand_t* hmpi_operand,
       const HMPI_Operand_type operand_type,
       void* operand_value
   )
   {
       int rc;
       hmpi_operand->operand_type = operand_type;

       switch (operand_type)
       {
       case VECTOR:
       case SCALAR:
         {
            rc = HMPI_OK;
            hmpi_operand->operand_val = *(int*)(operand_value);
            break;
         }
       case EXPR:
         {
            rc = HMPI_OK;
            hmpi_operand->operand_bnode = (HMPI_Cond_t*)(operand_value);
            break;
         }
       default:
         {
            rc = HMPI_INVALID_OPERAND_TYPE;
            break;
         }
       }

       return rc;
   }

   /*-----------------------------------------------------*/

