
/*************************************************************************
*                                                                       *
*                 Heterogeneous Data Partitioning Interface             *
*                 =========================================             *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /* Partitioning interfaces for graphs           */
   /*                                              */
   /* Revision history                             */
   /* 19-05-2003  --      Initial version          */
   /************************************************/

   #ifndef __HMPI_PARTITIONING_GRAPHS_WRAPPERS_HH
   #define __HMPI_PARTITIONING_GRAPHS_WRAPPERS_HH

/*
 * Wrappers for graph functions in METIS and hMETIS
 * 
 * Wrappers are to include sanity checks for checking
 * the correctness of partitioning and to ignore compiler
 * warnings because METIS functions does not accept 
 * const pointer to int arguments.
 */
int METIS_PartGraphRecursive_w
(
     int *nvtxs, 
     const int *xadj,
     const int* adjacency, 
     const int* vwgt, 
     const int* adjwgt, 
     int* wgtflag, 
     int* numflag, 
     int *nparts, 
     int *options,
     int *edgecut,
     int *part
);

int METIS_PartGraphKway_w
(
     int *nvtxs, 
     const int *xadj,
     const int* adjacency, 
     const int* vwgt, 
     const int* adjwgt, 
     int* wgtflag, 
     int* numflag, 
     int *nparts, 
     int *options,
     int *edgecut,
     int *part
);

int METIS_WPartGraphRecursive_w
(
     int *nvtxs, 
     const int *xadj,
     const int* adjacency, 
     const int* vwgt, 
     const int* adjwgt, 
     int* wgtflag, 
     int* numflag, 
     int *nparts, 
     float *tpwgts,
     int *options,
     int *edgecut,
     int *part
);

int METIS_WPartGraphKway_w
(
     int *nvtxs, 
     const int *xadj,
     const int* adjacency, 
     const int* vwgt, 
     const int* adjwgt, 
     int* wgtflag, 
     int* numflag, 
     int *nparts, 
     float *tpwgts,
     int *options,
     int *edgecut,
     int *part
);

int HMETIS_PartRecursive_w
(
     int nvtxs, 
     int nhedges,
     const int* vwgts, 
     const int* eptr, 
     const int* eind, 
     const int* hewgts, 
     int nparts, 
     int ubfactor, 
     int *options,
     int *part,
     int *edgecut
);

int HMETIS_PartKway_w
(
     int nvtxs, 
     int nhedges,
     const int* vwgts, 
     const int* eptr, 
     const int* eind, 
     const int* hewgts, 
     int nparts, 
     int ubfactor, 
     int *options,
     int *part,
     int *edgecut
);

#endif

