
/*************************************************************************
*                                                                       *
*                 Heterogeneous Data Partitioning Interface             *
*                 =========================================             *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /* Partitioning interfaces for graphs           */
   /*                                              */
   /* Revision history                             */
   /* 19-05-2003  --      Initial version          */
   /************************************************/

   #ifndef __HMPI_PARTITIONING_GRAPHS_HH
   #define __HMPI_PARTITIONING_GRAPHS_HH

   #define  PARTITION_SUBSET   1
   #define  PARTITION_OTHER    2

   int HMPI_Partition_graph(
           int p,
           int pn,
	   const double *speeds,
	   const int *psizes,
	   const int *mlimits,
	   int n,
	   int m,
	   const int *vwgt,
	   const int *xadj,
	   const int *adjacency,
	   const int *adjwgt,
	   int *vp,
	   int *edgecut
   );

   int HMPI_Partition_bipartite_graph(
           int p,
           int pn,
           const double *speeds,
           const int *psizes,
           const int *mlimits,
           int n,
           int m,
           const int *vtype,
           const int *vwgt,
           const int *xadj,
           const int *adjacency,
           const int *adjwgt,
           int type_of_partitioning,
           int *vp,
           int *edgecut
   );

   int HMPI_Partition_hypergraph(
           int p,
           int pn,
	   const double *speeds,
	   const int *psizes,
	   const int *mlimits,
	   int nv,
	   int nedges,
	   const int  *vwgt,
	   const int *hptr,
	   const int *hind,
	   const int  *hwgt,
	   int *vp,
	   int *edgecut
   );

   #endif  /* __HMPI_PARTITIONING_GRAPHS_HH */
