
/*************************************************************************
*                                                                       *
*                 HMPI Programming Environment                          *
*                 ============================                          *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /**************************************************/
   /* hmpi_ops - Strutures for the HeteroMPI library */
   /*            for creation of sub-networks.       */
   /*            (Compatibility with mpC)            */
   /*                                                */
   /* Revision history                               */
   /* 01-02-2002  --      Initial version            */
   /**************************************************/

   #ifndef __HMPI_OPS_HH
   #define __HMPI_OPS_HH

   #ifndef NULL
   #define NULL (void*)0
   #endif

   /* 
    * Binary operations 
    */
   #define OpMOD       0    /* %  */
   #define OpEQ        1    /* == */
   #define OpNEQ       2    /* != */
   #define OpGT        3    /* >  */
   #define OpGE        4    /* >= */
   #define OpLT        5    /* <  */
   #define OpLE        6    /* <= */
   #define OpLAND      7    /* && */
   #define OpLOR       8    /* || */
   #define OpPLUS      9    /* +  */
   #define OpMINUS     10   /* -  */
   #define OpMULT      11   /* *  */
   #define OpDIV       12   /* /  */
   #define OpUNDEF     13   /*    */

   /*
    * Unary operations
    */
   #define OpLNOT      0    /* !  */

   /*
    * If the condition is I >= 0,
    * then operand type of lhs is VECTOR and of rhs
    * is SCALAR.
    *
    * If the condition is I < J+2, 
    * then operand type of lhs is VECTOR and of rhs
    * is EXPR.
    *
    * If the condition is I+K < J+2, 
    * then operand type of lhs is EXPR and of rhs
    * is EXPR.
    */
   typedef enum
   {
        VECTOR,
        SCALAR,
        EXPR
   } HMPI_Operand_type;

   /*
    * operand_type  --- SCALAR,VECTOR or EXPR
    * operand_val   --- Value of the coordinate or scalar
    * operand_bnode --- Binary node representing the expr
    */
   struct _HMPI_operand
   {
       HMPI_Operand_type operand_type;
       
       union {
         int _operand_val;
         struct _HMPI_Condition* _operand_bnode;
       } _uoperand;

   #define operand_val   _uoperand._operand_val
   #define operand_bnode _uoperand._operand_bnode

   };

   typedef struct _HMPI_operand HMPI_Operand_t;

   struct _HMPI_Condition
   {
       int op;
       HMPI_Operand_t* lhs_value;
       HMPI_Operand_t* rhs_value;
       struct _HMPI_Condition *lhs_node;
       struct _HMPI_Condition *rhs_node;
   };

   typedef struct _HMPI_Condition HMPI_Cond_t;

   extern int
   HMPI_Cond_create
   (
       HMPI_Cond_t* cond,
       const HMPI_Operand_t* lhs_operand,
       const HMPI_Operand_t* rhs_operand,
       int operator
   );

   extern int
   HMPI_Operand_create
   (
       HMPI_Operand_t* hmpi_operand,
       const HMPI_Operand_type operand_type,
       void* operand_value
   );

   typedef struct _HMPI_BINARY_OP_TYPE
   {
       int  (*_binary_op_func)
            (
              const int Tx,
              const int Ty
       );
       const int _flags;
       const char* _op_string;
   } HMPI_Binary_op_type;

   typedef struct _HMPI_UNARY_OP_TYPE
   {
       int  (*_unary_op_func)
            (
              const int Tx
       );
       const int _flags;
       const char* _op_string;
   } HMPI_Unary_op_type;

   int HMPI_Process_conditions
   (
        const HMPI_Cond_t* hmpi_bnode,
        const int* coord
   );

   int HMPI_Evaluate_conditions
   (
       const char* conditions,
       const int* coord
   );

   int HMPI_Evaluate_conditions_i
   (
        const HMPI_Cond_t* hmpi_bnode,
        int cond_count,
        const int* operators,
        int op_count,
        const int* coord
   );

   int
   HMPI_Evaluate_bnode
   (
        const HMPI_Cond_t* hmpi_bnode,
        const int* coord
   );

   int
   HMPI_Get_value
   (    
        HMPI_Operand_t* hmpi_bnode,
        const int* coord
   );

   int HMPI_modulus
   (
       const int Tx,
       const int Ty
   );

   int HMPI_equal_to
   (
       const int Tx,
       const int Ty
   );

   int HMPI_not_equal_to
   (
       const int Tx,
       const int Ty
   );

   int HMPI_greater
   (
       const int Tx,
       const int Ty
   );

   int HMPI_greater_equal
   (
       const int Tx,
       const int Ty
   );

   int HMPI_less
   (
       const int Tx,
       const int Ty
   );

   int HMPI_less_equal
   (
       const int Tx,
       const int Ty
   );

   int HMPI_logical_and
   (
       const int Tx,
       const int Ty
   );

   int HMPI_logical_or
   (
       const int Tx,
       const int Ty
   );

   int HMPI_logical_not
   (
       const int Tx
   );

   int HMPI_plus
   (
       const int Tx,
       const int Ty
   );

   int HMPI_minus
   (
       const int Tx,
       const int Ty
   );

   int HMPI_mult
   (
       const int Tx,
       const int Ty
   );

   int HMPI_div
   (
       const int Tx,
       const int Ty
   );
   
   #endif /* __HMPI_OPS_HH */
