
   /**************************************************/
   /* HeteroDPI         - Heterogeneous Data         */
   /*                     Partitioning Interface     */
   /*                                                */
   /* Revision history                               */
   /* 19-05-2003  --      Initial version            */
   /**************************************************/

   #ifndef __HDPI_HH
   #define __HDPI_HH

   #include "hmpi_partitioning.h"

   /*
    * sets
    */
   #define   Partition_unordered_set     HMPI_Partition_unordered_set
   #define   Partition_ordered_set       HMPI_Partition_ordered_set
   #define   Get_set_processor           HMPI_Get_set_processor
   #define   Get_my_partition            HMPI_Get_my_partition

   /*
    * matrices
    */
   #define   Partition_matrix_2d               HMPI_Partition_matrix_2d
   #define   Partition_matrix_1d_dp            HMPI_Partition_matrix_1d_dp
   #define   Partition_matrix_1d_iterative     HMPI_Partition_matrix_1d_iterative
   #define   Partition_matrix_1d_refining      HMPI_Partition_matrix_1d_refining
   #define   Get_matrix_processor              HMPI_Get_matrix_processor
   #define   Get_processor_2d                  HMPI_Get_processor_2d
   #define   Get_processor_1d                  HMPI_Get_processor_1d
   #define   Print_rectangle_1d                HMPI_Print_rectangle_1d
   #define   Print_rectangle_2d                HMPI_Print_rectangle_2d
   #define   Common_height                     HMPI_Common_height
   #define   Get_my_width                      HMPI_Get_my_width
   #define   Get_my_height                     HMPI_Get_my_height
   #define   Get_diagonal                      HMPI_Get_diagonal
   #define   Get_my_elements                   HMPI_Get_my_elements
   #define   Get_my_kk_elements                HMPI_Get_my_kk_elements

   /*
    * graphs
    */
   #define   Partition_graph                   HMPI_Partition_graph
   #define   Partition_bipartite_graph         HMPI_Partition_bipartite_graph
   #define   Partition_hypergraph              HMPI_Partition_hypergraph

   /*
    * trees
    */
   #define   Partition_tree                    HMPI_Partition_tree

   #endif  /* __HDPI_HH */
